;;; emacs-goodies-custom.el --- Automatically harvested defgroups
;;
;;  Peter S Galbraith <psg@debian.org>
;;  License of copied code applies to this combined work (GPL V2)
;;
;;; Code:

;; dir-locals
(defgroup dir-locals ()
  "Directory-wide file-local variables"
  :link '(emacs-commentary-link "dir-locals")
  :group 'files
  :link '(custom-manual "(emacs-goodies-el)dir-locals")
  :load 'dir-locals
  :group 'emacs-goodies-el)

;; ff-paths
(defgroup ff-paths nil
  "Find file using paths."
  :group 'ffap
  :group 'matching
  :group 'convenience
  :link '(custom-manual "(emacs-goodies-el)ff-paths")
  :load 'ff-paths
  ;;:require 'ff-paths
  :group 'emacs-goodies-el)

;; muttrc-mode
(defgroup muttrc nil
  "Muttrc editing commands for Emacs."
  :group 'files
  :prefix "muttrc-"
  :link '(custom-manual "(emacs-goodies-el)muttrc-mode")
  :load 'muttrc-mode
;;:require 'muttrc-mode
  :group 'emacs-goodies-el)

;; projects
(defgroup projects nil
  "Project-based buffer name management."
  :group 'convenience
  :link '(custom-manual "(emacs-goodies-el)projects")
  :load 'projects
;;:require 'projects
  :group 'emacs-goodies-el)

(defcustom quack-install nil
  "Whether to setup quack for use."
  :type 'boolean
  :set (lambda (symbol value)
         (set-default symbol value)
         (when value
           (quack-install)))
  :require 'quack
  :group 'quack)

;; xrdb-mode
(defgroup xrdb nil
  "Support for editing X resource database files"
  :group 'languages
  :link '(custom-manual "(emacs-goodies-el)xrdb-mode")
  :load 'xrdb-mode
;;:require 'xrdb-mode
  :group 'emacs-goodies-el)

(provide 'emacs-goodies-custom)
