;;; emacs-goodies-el.el --- startup file for the emacs-goodies-el package

;;; Commentary:
;;
;; This file is loaded from /etc/emacs/site-start.d/50emacs-goodies-el.el

;;; History:
;;
;; 2009-02-22 Peter Galbraith
;;  - Replace $ by \\' in auto-mode-alist entries (Closes: #570293)
;; 2006-11-26 - Ramkumar R.
;;  - Obey `emacs-goodies-el-defaults' for xrdb-mode.
;; 2003-06-14 - Peter Galbraith
;;  - Delete autoloads that can be generated automatically.
;; 2003-05-14 - Peter Galbraith
;;  - Created from 50emacs-goodies-el.el contents.

;;; Code:

(defgroup emacs-goodies-el nil
  "Debian emacs-goodies-el package customization."
  :group 'convenience)

(require 'emacs-goodies-loaddefs)
(require 'emacs-goodies-custom)

(defcustom emacs-goodies-el-defaults nil
  "Whether default settings are chosen conservatively or aggressively.
non-nil means aggressive.
Setting to aggressive will enable features that supercede Emacs defaults."
  :type '(radio (const :tag "conservative" nil)
                (const :tag "aggressive" t))
  :link '(custom-manual "(emacs-goodies-el)Top")
  :group 'emacs-goodies-el)

;; ff-paths.el
(defcustom ff-paths-install emacs-goodies-el-defaults
  "Whether to setup ff-paths for use.
find-file-using-paths searches certain paths to find files."
  :type 'boolean
  :set (lambda (symbol value)
         (set-default symbol value)
         (when value
           (ff-paths-install)))
  :load 'ff-paths
;;  :require 'ff-paths
  :group 'emacs-goodies-el
  :group 'ff-paths)

(defcustom ff-paths-use-ffap emacs-goodies-el-defaults
  "Whether to setup ffap for use.

Usually packages don't advertise or try to setup other packages, but
ff-paths works well in combination with ffap (Find FILENAME, guessing a
default from text around point) and so I recommend it here.

find-file-using-paths searches certain paths to find files."
  :type 'boolean
  :set (lambda (symbol value)
         (set-default symbol value)
         (when value
           (require 'ffap)
           (ff-paths-in-ffap-install)))
;;  :require 'ff-paths
  :load 'ff-paths
  :group 'emacs-goodies-el
  :group 'ff-paths)

;; muttrc-mode.el
(add-to-list 'auto-mode-alist '("muttrc\\'" . muttrc-mode))

;; xrdb-mode.el

(defun xrdb-mode-setup-auto-mode-alist ()
  (add-to-list 'auto-mode-alist '("\\.Xdefaults\\'" . xrdb-mode))
  (add-to-list 'auto-mode-alist '("\\.Xenvironment\\'". xrdb-mode))
  (add-to-list 'auto-mode-alist '("\\.Xresources\\'". xrdb-mode))
  (add-to-list 'auto-mode-alist '("\\.ad\\'". xrdb-mode))
  (add-to-list 'auto-mode-alist '("/app-defaults/". xrdb-mode))
  (add-to-list 'auto-mode-alist '("/Xresources/". xrdb-mode)))

(defcustom xrdb-mode-setup-auto-mode-alist
  (or
   ;; Check if conf-xdefaults-mode is present
   (not (fboundp 'conf-xdefaults-mode))
   ;; Check if default setup provides bindings for conf-xdefaults-mode
   (< emacs-major-version 22)
   (featurep 'xemacs)
   ;; Check if the user wants settings to be clobbered
   emacs-goodies-el-defaults)
  "Whether to setup mode-alists for xrdb mode.

Newer versions of Emacs have a conf-xdefaults-mode which provides
this functionality. `xrdb' still has some features (like
electricity) which are absent in that mode. Setting this to
non-nil clobbers the default bindings in such cases.

This variable defaults to t for older emacsen and the value
`emacs-goodies-el-defaults' for newer ones.

Customizing this variable might require restarting emacs for the
effects to take effect."
  :type 'boolean
  :set (lambda (symbol value)
         (set-default symbol value)
         (when value
           (xrdb-mode-setup-auto-mode-alist)))
  :group 'emacs-goodies-el
  :group 'xrdb)

(provide 'emacs-goodies-el)

;;; emacs-goodies-el.el ends here
