<?php
#  Copyright (C) 2008,2009 Neil Williams <codehelp@debian.org>
#
#  This package is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

$SELF = "http://".$_SERVER["HTTP_HOST"];
$buildlog_path="/var/www/grip/logs/";
$loglist = array ();
$num_days = $default_days = 7;
if (is_dir ("$buildlog_path"))
{
	if ($builddh = opendir ("$buildlog_path"))
	{
		while (($file = readdir ($builddh)) != false)
		{
			if ($file == '.') { continue; }
			if ($file == '..') { continue; }
			# allow an index page
			if ($file == "index.html") { continue; }
			array_push ($loglist, $file);
		}
		closedir ($builddh);
	}
}
rsort ($loglist);
$files = array ();
$cut_off = date ("U") - (60*60*24*$num_days);
$total = array ();

foreach ($loglist as $logname)
{
	$omit = 0;
	$last_log=0;
	$check++;
	preg_match ("/([0-9]+)\.log$/", $logname, $matches);
	$time = $matches[1];
	if ($last_log > $time) { continue; }
	# add a 7 day cut-off
	$last_log = $time;
	$total[$check] = $logname;
	if (($num_days > 0) and ($cut_off > $time))  { continue; }
	$files[$check] = $logname;
	if ($omit > 0)
	{
		unset ($files[$check]);
		$omit = 0;
	}
}
foreach ($files as $file)
{
	if ($file == '.') { continue; }
	if ($file == '..') { continue; }
	$status=0;
	preg_match ("/([0-9]+)\.log$/", $file, $matches);
	$recent = array_search($file, $files);
	$time = $matches[1];
	$arch="";
	$archlist="";
	$cause="";
	$timestr = date ("D jS M, H:i:s T", $time);
	$safefile=urlencode($file);
	print "<a href=\"logs/$file\">$SELF/grip/logs/$safefile</a> $timestr<br/>\n";
}

?>
