<?php

#  Copyright (C) 2008,2009 Neil Williams <codehelp@debian.org>
#
#  This package is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

# A few notes:
# 1. The CSS from buildd.debian.org is embedded so the colours match
# 2. There is ONLY one file / data source available to this script -
#    the em_autogrip log.
# 3. Configuration is internal
# 4. $num_days controls how many recent logs to show (default = 7)
#    instead of previous behaviour of all

##### config #####
$buildlog_path = "/var/www/grip/logs/";
$template_file = "/var/www/toolchains/emdebian.php";
$default_days = 7;
$supported_arches = array ("i386", "amd64", "arm", "armel",
 "powerpc", "mips", "mipsel" );
#### end config ##

if (is_file ($template_file))
{
	include_once $template_file;
	emheader();
}
?>
<style type="text/css">
a:visited {
	color: #3030ff;
	text-decoration: none;
}

a:link    {
	color: #3030ff;
	text-decoration: none;
}

a:hover {
    text-decoration: underline;
}

/* data table */

.data {
    border-collapse: collapse;
    border: 1px solid #999999;
    font-size: 90%;
    margin: 1em 0em 1em 0em;
}

table.data th.title {
    background: #fffff1;
    border: 1px solid #999999;
    color: #333333;
    font-weight: bold;
    font-size: 120%;
    padding: 0.5em 1em 0.5em 1em;
    white-space: nowrap;
}

.data th {
    background: #ffffcc;
    border: 1px solid #999999;
    font-weight: bold;
    color: #545325;
    padding: 0em 0.2em 0em 0.2em;
}

.data td {
    border: 1px solid #999999;
    padding: 0.1em 0.5em;
    text-align: left;
    vertical-align: top;
}

.data tr.odd {
  background: #f9f9f1;
}

.data td.crit {
  background: #c15757;
}

.data td.warn {
  background: #cfcf00;
}

.data td.good {
  background: #00ff00;
}

.data tr.even {
  background: #ffffff;
}

.data tr:hover { background: #f4f4f4; }
</style>
<h1 style="position:absolute;top:10px;left:350px;font-family:sans-serif;">
Grip</h1>
<?php

$num_days = $default_days;
if (($_GET['days'] != ''))
{
	$num_days = htmlspecialchars ($_GET['days']);
	$num_days = preg_replace ('/\.+\/+/', "", $num_days);
}

if (($_GET['log'] != ''))
{
	$log = htmlspecialchars ($_GET['log']);
	$log = preg_replace ('/\.+\/+/', "", $log);
	$logfile = $log;
	print "<h2>Log: $log</h2>";
?>
<h3>Key</h3>
<p><b>INF</b> tags are informational</p>
<p><b>WRN</b> tags are warnings</p>
<p><b>ERR</b> tags indicate errors that need separate handling</p>
<p><b>RES</b> tags describe the results</p>
<?php
	print "<p>Skip to <a href=\"#end\">End of log</a></p>";
	print "<p><a href=\"logs.php\">Back to log report</a></p>\n";
	if (is_file ("$buildlog_path/$logfile"))
	{
		print "<pre id=\"start\">\n";
		readfile ("$buildlog_path/$logfile");
		print "</pre><span id=\"end\"/>\n";
	}
	print "<a href=\"#start\">Start of log</a>";
	if (is_file ($template_file))
	{
		footer();
	}
	exit;
}
?>
<p>
<?php
print " [ <a href=$SELF#table>Skip to table</a> ] ";
?>
</p>
<h2>Emdebian Grip package update report.</h2>
<p>Packages in Emdebian Grip are updated directly from Debian unstable.
These reports contain the details of which packages are processed and
any errors that arise in the process.</p>
<h3>Errors and dependency failures</h3>
<p>Updates are deemed to have failed if there are internal errors in the
update process or if the resulting repository is not well trimmed (with
all dependencies met). In the case of a dependency failure, only the
specified architecture(s) have any problems, other architectures passed
the dependency check.
</p>
<p>The update process also migrates packages into testing in line
with Debian testing. Errors in testing can also show up as a failed
update.</p>
<h4>RSS feeds of repository activity</h4>
<ul>
<li><a href="archive.php?suite=sid"><img 
src="../Pics/xml.png"> Sid (unstable)</a></li>
<li><a href="archive.php?suite=squeeze"><img 
src="../Pics/xml.png"> Squeeze (testing)</a></li>
</ul>
<h3>Time Filter</h3>
<?php
if ($num_days > 0)
{
	print "<p>Only logs from the last $num_days days are shown. ";
	print "<a href=\"$SELF?days=0\">Show all logs</a>, or \n";
	if ($num_days == $default_days)
	{
		print "<a href=\"$SELF?days=28\">show logs for 28 days</a>.</p>\n";
	}
	else
	{
		print "<a href=\"$SELF?days=$default_days\">show logs for $default_days days</a>.</p>\n";
	}
}
else
{
	print "<p>Showing all logs. \n";
	print "<a href=\"$SELF?days=$default_days\">Show the last $default_days days</a>.</p>\n";
}
$loglist = array ();
$waitlist = array ();
$faillist = array ();
if (is_dir ("$buildlog_path"))
{
	if ($builddh = opendir ("$buildlog_path"))
	{
		while (($file = readdir ($builddh)) != false)
		{
			if ($file == '.') { continue; }
			if ($file == '..') { continue; }
			# allow an index page
			if ($file == "index.html") { continue; }
			array_push ($loglist, $file);
		}
		closedir ($builddh);
	}
}
?>
<?php
rsort ($loglist);
$files = array ();
$cut_off = date ("U") - (60*60*24*$num_days);
$total = array ();

foreach ($loglist as $logname)
{
	$omit = 0;
	$last_log=0;
	$check++;
	preg_match ("/([0-9]+)\.log$/", $logname, $matches);
	$time = $matches[1];
	if ($last_log > $time) { continue; }
	# add a 7 day cut-off
	$last_log = $time;
	$total[$check] = $logname;
	if (($num_days > 0) and ($cut_off > $time))  { continue; }
	$files[$check] = $logname;
	if ($omit > 0)
	{
		unset ($files[$check]);
		$omit = 0;
	}
}
$numok=0;
$numfail=0;
$manual=0;
# identify memory problems in advance.
$list = preg_split ("/\n/", `find /etc/ -name php.ini`);
$have = memory_get_usage ();
foreach ($list as $file)
{
	# yes, I know this is shell but it's a lot easier than the
	# equivalent PHP. If memory_limit is not in megabytes or
	# if it is not found at all, current value is retained.
	$limit = `grep "memory_limit = " $file | cut -d' ' -f3 | cut -d'M' -f1` * 1024 * 1024;
	if ($limit > $have)
	{
		$have = $limit;
	}
}
?>
<table class="data" id="table">
<tr>
<th>Start time</th>
<th>Possible results</th>
<th>Affected architectures</th><tr>
<?php
foreach ($files as $file)
{
	$status=0;
	preg_match ("/([0-9]+)\.log$/", $file, $matches);
	$recent = array_search($file, $files);
	$time = $matches[1];
	$arch="";
	$archlist="";
	$cause="";
	$timestr = date ("D jS M, H:i:s T", $time);
	$safefile=urlencode($file);
	$need = filesize("$buildlog_path/$file");
	if ($need > $have)
	{
		print "<td class=\"warn\" colspan=\"2\">Log file is ";
		print "too large for available memory.</td>\n";
		print "</tr>\n";
		continue;
	}
	error_reporting(0);
	try
	{
		$contents = file_get_contents ("$buildlog_path/$file");
	}
	catch (Exception $e)
	{
		if ($recent)
		{
			print "<td class=\"warn\" colspan=\"2\">Log file is ";
			print "too large for available memory.</td>\n";
			print "</tr>\n";
		}
		continue;
	}
	print "<td>$timestr</td>";
	if (preg_match ("/em_autogrip: ERR:/", $contents))
	{
		print "<td class=\"warn\">";
		print "<a href=\"?log=$safefile\">maybe failed</a>";
		print "</td>\n";
		$cause = "internal error";
	}
	elseif (preg_match ("/NOT AVAILABLE/", $contents))
	{
		print "<td class=\"warn\">";
		print "<a href=\"?log=$safefile\">dependency fail</a>";
		print "</td>\n";
		$archlist="&nbsp;";
	}
	else
	{
		print "<td class=\"good\">";
		print "<a href=\"?log=$safefile\">maybe successful</a>";
		print "</td>\n";
	}
	foreach ($supported_arches as $arch)
	{
		if (preg_match ("/Checking $arch\n\n(.+)\n(.+)\n(.+)/", $contents, $matches))
		{
				if (preg_match ("/Starting/", $matches[0])) {continue; }
				if (preg_match ("/This is/", $matches[0])) {continue; }
				$archlist .= " $arch";
		}
	}
	if (($archlist == "") and ($cause == ""))
	{
		print "<td class=\"good\">&nbsp;(all architectures)</td>";
		print "</tr>\n";
	}
	elseif ($cause != "")
	{
		print "<td class=\"warn\">&nbsp;$cause</td>";
		print "</tr>\n";
	}
	elseif ($archlist == "&nbsp;")
	{
		print "<td class=\"warn\">&nbsp;(see log for detail)</td>";
		print "</tr>\n";
	}
	else
	{
		print "<td class=\"warn\">$archlist</td>";
		print "</tr>\n";
	}
}
?>
</table>
<div style="clear: both;">&nbsp;</div>
<p>The autobuilder is part of <a 
href="http://packages.qa.debian.org/e/emdebian-tools.html">emdebian-tools</a>.
</p>
<?php
if (is_file ($template_file))
{
	footer();
}
?>
