#!/usr/bin/perl

=head1 NAME

grip-checkpkg.pl - check a package prior to addition to Grip

=cut

=head1 Description

Very bare script that simply parses the debian/control file for the
current package - i.e. you must be in the source directory of the
package concerned - and compares each package with the list of packages
in the current Grip filter pkglist file (maintained by em_autogrip).

=cut

use Parse::DebControl;

$parser = new Parse::DebControl;
$control_data = "$ARGV[0]/debian/control";
%deplist=();
$data = $parser->parse_file($control_data, $options);
foreach my $line (sort @$data)
{
	next if $$line{'Package'} =~ /-dev$/;
	$dep = $$line{'Depends'};
	$dep =~ s/,//g;
	$dep =~ s/\(.*\)//g;
	$dep =~ s/\$\{.*\}//g;
	chomp ($dep);
	@deps = split (" ", $dep);
	foreach my $d (sort @deps)
	{
		chomp ($d);
		$deplist{$d}++;
	}
}

=head1 Needs SCP access to emdebian.org

This script does not do anything fancy with LWP to download the list of
packages, it merely assumes that the pkglist exists in /tmp. Hence, this
package lives only in Emdebian SVN, for now at least.

=cut

open (PKG, "/tmp/pkglist") or
	die ("Cannot find /tmp/pkglist from /org/emdebian/filter/conf/");
@list=<PKG>;
close (PKG);
%filter=();
foreach my $l (@list)
{
	chomp ($l);
	$l =~ s/install//g;
	$l =~ s/\s//g;
	$filter{$l}++;
}

foreach my $p (sort keys %deplist)
{
	print "Checking $p: ";
	if (not exists $filter{$p})
	{
		print "$p failed.\n";
	}
	else
	{
		print "ok\n";
	}
}

=head1 Copyright and Licence

 Copyright (C) 2009  Neil Williams <codehelp@debian.org>

 This package is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.

=cut
