/* $Id: e2p_find.c 555 2007-07-23 09:39:52Z tpgww $

Copyright (C) 2005-2007 tooar <tooar@gmx.net>
Portions copyright (C) 1999 Matthew Grossman <mattg@oz.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/
// much of this code was originally sourced from gtkfind 1.1 by Matthew Grossman
/**
@file plugins/e2p_find.c
@brief file-find plugin

This file contains functions related to creation of a file-find dialog, and
execution of a find task in accord with options selected in that dialog.
Back-end capability is provided by shell commands, specifically
GNU find, sed, grep and/or file. Some 'find' command parameters are
dependant on a latish version e.g. 4.2.11 is ok
This will not work on any virtual file system, unless that is mounted
*/

/* TODO
FIXME's
hard = detect end of shell command, and update start/stop/help btn sensitivity accordingly
share code with the rename plugin ?
*/

#include<stdlib.h>
#include<string.h>
#include <unistd.h>
// reported needed on a debian system
//#include<X11/Xos.h>
#include<time.h>
#ifdef TM_IN_SYS_TIME
#include<sys/time.h>
#endif

#include "e2p_find.h"
#include "e2_plugins.h"
#include "e2_dialog.h"
#include "e2_task.h"

static E2_FindDialogRuntime *find_rt;
static local_dt current;
static gboolean nocacheflags;
//session-cache for last-focused notebook page
static gint page_store;
//ditto for toggle values
static gboolean flags[MAX_FLAGS];
//ditto for entries' text (except the start-directory entry)
static gchar *entries[MAX_ENTRIES];
//real-cache data for entries' text
static GList *strings = NULL;
static gchar *blank = "";

static gchar *_e2p_find_quote_string (gchar *original);

static void _e2p_find_make_name_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt);
static void _e2p_find_make_size_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt);
#ifdef MIMEFIND
static void _e2p_find_make_mimetype_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt);
#endif
static void _e2p_find_make_content_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt);
static void _e2p_find_make_atime_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt);
static void _e2p_find_make_ctime_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt);
static void _e2p_find_make_mtime_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt);
static void _e2p_find_make_mode_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt);
static void _e2p_find_make_type_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt);
static void _e2p_find_make_owner_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt);

#define _e2p_find_create_vbox(box) e2_widget_add_box(box,TRUE,0,TRUE,FALSE,E2_PADDING)
#define _e2p_find_create_label(box,text) e2_widget_add_mid_label(box,text,0.5,FALSE,E2_PADDING_XSMALL)
#define _e2p_find_create_entry(box,text) e2_widget_add_entry(box,text,TRUE,FALSE)

static GtkWidget *_e2p_find_create_hbox (GtkWidget *box);
//static GtkWidget *_e2p_find_create_button (GtkWidget *container,
//	void (*callback) (), gpointer callback_data);
static GtkWidget *_e2p_find_create_toggle_grouped_button (GtkWidget *container,
	findflag_t f, gboolean state, gchar *label, GtkWidget *leader,
	E2_FindDialogRuntime *rt);
static GtkWidget *_e2p_find_create_toggle_button (GtkWidget *container,
	findflag_t f, gboolean state, gchar *label, E2_FindDialogRuntime *rt);
static GtkWidget *_e2p_find_create_radio_button (GtkWidget *container,
	findflag_t f, gboolean state, gchar *label, E2_FindDialogRuntime *rt);
static GtkWidget *_e2p_find_create_radio_grouped_button (GtkWidget *container, GtkWidget *group,
	findflag_t f, gboolean state, gchar *label, E2_FindDialogRuntime *rt);
static GtkWidget *_e2p_find_create_spin_button (gfloat *default_value, gfloat min_value,
	gfloat max_value);

static gboolean _e2p_find_check_leapyear (gint year);
static void _e2p_find_get_relative_datetime (GDate *now, offset *result, spinners *times);
static void _e2p_find_get_current_datetime (local_dt *current);
static gboolean _e2p_find_get_flag (findflag_t f);	//, E2_FindDialogRuntime *rt);
static void _e2p_find_set_flag (findflag_t f, gboolean value);	//, E2_FindDialogRuntime *rt);
static void _e2p_find_set_toggle_button_off (GtkWidget *widget);
static void _e2p_find_set_toggle_button_on (GtkWidget *widget);
static void _e2p_find_make_all_spinners (GtkWidget *box, spinners *times);
static void _e2p_find_reset_all_widgets (GtkWidget *widget, gpointer data);
static void _e2p_find_reset_flags (void);	//E2_FindDialogRuntime *rt);
static void _e2p_find_reset_entry (GtkWidget *widget);
static void _e2p_find_reset_spin_button (GtkWidget *widget);

  /*********************/
 /***** callbacks *****/
/*********************/

/**
@brief adjust directory string in @a entry
After a keypress, this clears any selection and completes the path.
If the current content is not an absolute path, the active-pane directory
is referenced for completion.
@param entry the entry widget for directory data
@param event pointer to event data struct
@param data UNUSED data specified when callback was connnected

@return TRUE if the key was non-modified and a textkey
*/
static gboolean _e2p_find_key_press_cb (GtkWidget *entry, GdkEventKey *event,
	gpointer data)
{
	if ((event->state & (GDK_CONTROL_MASK | GDK_MOD1_MASK)) == 0
//#ifdef USE_GTK2_10 | GDK_SUPER_MASK | GDK_HYPER_MASK | GDK_META_MASK
		&& (event->keyval < 0xF000 || event->keyval > 0xFFFF)
		&& e2_fs_complete_dir (entry, event->keyval, 0)) //default is active pane
			return TRUE;
	return FALSE;
}
/**
@brief cleanup after cancel button is pressed

@param widget clicked button, UNUSED
@param rt ptr to dialog data struct

@return
*/
static void _e2p_find_quit_cb (GtkWidget *widget, E2_FindDialogRuntime *rt)
{
	//clear current strings array and cache data list
	e2_list_free_with_data (&strings);
	//update array and list
	entries [NAME_ENTRY] = g_strdup (gtk_entry_get_text (GTK_ENTRY (rt->pattern)));
	entries [CONTENT_ENTRY] = g_strdup (gtk_entry_get_text (GTK_ENTRY (rt->content_pattern)));
	entries [MIME_ENTRY] = g_strdup (gtk_entry_get_text (GTK_ENTRY (rt->mime_entry)));
	entries [SIZE_ENTRY] = g_strdup (gtk_entry_get_text (GTK_ENTRY (rt->size_entry)));
	entries [UID_ENTRY] = g_strdup (gtk_entry_get_text (GTK_ENTRY (rt->user_entry)));
	entries [GID_ENTRY] = g_strdup (gtk_entry_get_text (GTK_ENTRY (rt->group_entry)));
	guint i;
	gchar *cachethis;
	for (i = 0; i < MAX_ENTRIES; i++)
	{
		//empty or space-only strings don't get saved
		if (i != NAME_ENTRY)
			g_strstrip (entries[i]);
		if (*entries[i] == '\0')
			cachethis = g_strdup (".");	//so we use this instead
		else
			cachethis = entries[i];
		strings = g_list_append (strings, cachethis);
	}

	if (rt->groups != NULL)
	{	//cleanup data stored with some buttons
		GSList *tmp, *members;
		for (tmp = rt->groups; tmp != NULL; tmp=tmp->next)
		{
			members = (GSList *) g_object_get_data
				(G_OBJECT (tmp->data), "group_members");
			g_slist_free (members);
		}
		g_slist_free (rt->groups);
	}
	gtk_widget_destroy (rt->dialog);
	DEALLOCATE (E2_FindDialogRuntime, rt);
	rt = NULL;
	find_rt = NULL;
//	gtk_widget_grab_focus (curr_view->treeview);
}
/**
@brief dialog response callback

@param dialog the dialog where the response was initiated, UNUSED
@param response the number assigned to the widget which triggered the response
@param rt ptr to dialog data struct

@return
*/
static void _e2p_find_response_cb (GtkDialog *dialog, gint response, E2_FindDialogRuntime *rt)
{
	printd (DEBUG, "Find plugin dialog response cb");
	if (response == GTK_RESPONSE_CLOSE)
		_e2p_find_quit_cb (NULL, rt);
}
/**
@brief toggle specified option flag after a radio or normal toggle button is clicked

@param widget clicked button, UNUSED
@param flagnum pointerized number of the flag to be toggled

@return
*/
static void _e2p_find_toggle_cb (GtkWidget *widget, gpointer flagnum)
{
	//if this if this is during setup, before a widget is created ...
	if (!GTK_WIDGET_MAPPED (find_rt->dialog))
		return;

	findflag_t flg = (findflag_t) flagnum;
	gboolean newflag = ! _e2p_find_get_flag (flg);	//, find_rt);
	_e2p_find_set_flag (flg, newflag);	//, find_rt);

	//handle here all the 'special cases', if any
	if (flg == SEARCH_THIS_P)
	gtk_widget_set_sensitive (find_rt->directory, newflag);
	else if (newflag)
	{
		switch (flg)
		{
			case UID_ANY_P:
			case UID_NONE_P:
			case UID_LOGIN_P:
				gtk_widget_set_sensitive (find_rt->curr_user, FALSE);
				gtk_widget_set_sensitive (find_rt->choose_user, FALSE);
				gtk_widget_set_sensitive (find_rt->user_entry, FALSE);
				break;
			case UID_SPECIFIC_P:
				gtk_widget_set_sensitive (find_rt->curr_user, TRUE);
				gtk_widget_set_sensitive (find_rt->choose_user, TRUE);
				gtk_widget_set_sensitive (find_rt->user_entry,
					_e2p_find_get_flag (UID_NOT_LOGIN_P));	//, find_rt));
				break;
			case GID_ANY_P:
			case GID_NONE_P:
			case GID_LOGIN_P:
				gtk_widget_set_sensitive (find_rt->curr_group, FALSE);
				gtk_widget_set_sensitive (find_rt->choose_group, FALSE);
				gtk_widget_set_sensitive (find_rt->group_entry, FALSE);
				break;
			case GID_SPECIFIC_P:
				gtk_widget_set_sensitive (find_rt->curr_group, TRUE);
				gtk_widget_set_sensitive (find_rt->choose_group, TRUE);
				gtk_widget_set_sensitive (find_rt->group_entry,
					_e2p_find_get_flag (GID_NOT_LOGIN_P));	//, find_rt));
			default:
				break;
		}
	}
}
/**
@brief toggle specified option flag after a grouped toggle button is clicked

@param widget clicked button
@param flagnum pointerized number of the flag to be toggled

@return
*/
static void _e2p_find_grouptoggle_cb (GtkWidget *widget, gpointer flagnum)
{
	findflag_t flg = (findflag_t) flagnum;
	gboolean newflag = ! _e2p_find_get_flag (flg);	//, find_rt);
	_e2p_find_set_flag (flg, newflag);	//, find_rt);
	if (newflag)
	{	//clear all other members of the group
		GtkWidget *tmp = g_object_get_data (G_OBJECT (widget), "group_leader");
		GSList *members = g_object_get_data (G_OBJECT (tmp), "group_members");
		for (;members != NULL; members = members->next)
		{
			tmp = members->data;
			if (tmp != widget)
				_e2p_find_set_toggle_button_off (tmp);
		}
	}
	//handle here all the 'special cases', if any
	 switch (GPOINTER_TO_INT(flagnum))
	{
		case UID_LOGIN_P:
			newflag = (newflag) ? FALSE : ! _e2p_find_get_flag (UID_NOT_LOGIN_P);	//, find_rt) ;
			gtk_widget_set_sensitive (find_rt->user_entry, newflag);
			break;
		case UID_NOT_LOGIN_P:
			gtk_widget_set_sensitive (find_rt->user_entry, newflag);
			break;
		case GID_LOGIN_P:
			newflag = (newflag) ? FALSE : ! _e2p_find_get_flag (GID_NOT_LOGIN_P);	//, find_rt) ;
			gtk_widget_set_sensitive (find_rt->group_entry, newflag);
			break;
		case GID_NOT_LOGIN_P:
			gtk_widget_set_sensitive (find_rt->group_entry, newflag);
		default:
			break;
	}
}
/* *
@brief bring up a system find-file window to choose the directory from which to search

@param w activated widget, UNUSED
@param rt ptr to dialog data struct

@return
*/
/*static void _e2p_find_choose_directory_cb (GtkWidget *w, E2_FindDialogRuntime *rt)
{
	GtkWidget *dialog = gtk_file_chooser_dialog_new (NULL,
		GTK_WINDOW (rt->dialog), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
		GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
		GTK_STOCK_OPEN, GTK_RESPONSE_OK,
		NULL);

	e2_dialog_setup_chooser (dialog,
		_("choose directory"),
		(utf-8) const gchar *filename,
		GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
		TRUE,	//show hidden
		FALSE,	//single-selection
		GTK_RESPONSE_OK);	//default response

	gint response;
	while ((response = gtk_dialog_run (GTK_DIALOG (dialog))) == E2_RESPONSE_USER1)
	{}

	if (response == GTK_RESPONSE_OK)
	{
		gchar *local = gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (dialog));
		if (strlen (local) > 0)
		{
			gchar *opendir = F_FILENAME_FROM_LOCALE (local);
			gtk_entry_set_text (GTK_ENTRY (rt->directory), opendir);
			F_FREE (opendir);
		}
		g_free (local);
	}
	gtk_widget_destroy (dialog);
} */
/**
@brief callback for find clear action

the "clear" button will reset the search pattern	(ie the notebook
stuff), and not change anything else

@param w activated widget, UNUSED
@param rt ptr to dialog data struct

@return
*/
static void _e2p_find_clear_find_cb (GtkWidget *w, E2_FindDialogRuntime *rt)
{
	_e2p_find_reset_all_widgets (rt->dialog, NULL);
}
/**
@brief callback for find button click

Parses the selected options, converts to corresponding
shell command, and executes it
uses GNU find, grep and/or ?? for mimetype, content

@param button clicked widget
@param rt ptr to search data struct

@return
*/
static void _e2p_find_find_cb (GtkWidget *button, E2_FindDialogRuntime *rt)
{
	const gchar *tmp;
	gchar *tmp2;
	//construct run shell command, using find/file/grep
	GString *command = g_string_sized_new (256);
/* find [-[HLP] [path...]
	 -P	never follow symbolic links (=default)
	 -L	follow symbolic links
	 -H	do not follow symbolic links, except those appearing on the command line
*/
	command = g_string_assign (command, "find -H ");
	if (_e2p_find_get_flag (SEARCH_ALL_P))	//, rt))
		tmp2 = g_strdup (G_DIR_SEPARATOR_S);
	else
	{
		if (_e2p_find_get_flag (SEARCH_CURRENT_P))	//, rt))
		{
#ifdef E2_VFSTMP
			if (curr_view->spacedata != NULL)
			{
				g_string_free (command, TRUE);
				return;	//FIXME message
			}
#endif
		 tmp2 = g_strdup (curr_view->dir);
		}
			else if (_e2p_find_get_flag (SEARCH_OTHER_P))	//, rt))
		{
#ifdef E2_VFSTMP
			if (other_view->fs != FS_LOCAL)
			{
				g_string_free (command, TRUE);
				return;	//FIXME message
			}
#endif
			tmp2 = g_strdup (other_view->dir);
		}
		else
		{
			tmp = gtk_entry_get_text (GTK_ENTRY (rt->directory));
			if (*tmp == '\0')
			{
				 g_string_free (command, TRUE);
				 return;
			}
#ifdef E2_VFSTMP
			if (0)	//FIXME do some check for local only
			{
				 g_string_free (command, TRUE);
				 return;	//FIXME message
			}
			else
#endif
			tmp2 = g_strdup (tmp);
		}
		gchar *tmp3 = tmp2 + strlen (tmp2) - 1;
		if (tmp3 > tmp2 && *tmp3 == G_DIR_SEPARATOR)
			*tmp3 = '\0';
		tmp2 = _e2p_find_quote_string (tmp2);
	}
	command = g_string_append (command, tmp2);
	g_free (tmp2);
/*
	[expression]
	! expr
	expr1 -a expr2 = expr1 expr2
	expr1 -o expr2
	\( expr \) force precedence, esp. for -o expressions

	 -daystart	Measure times (for -atime,	-ctime,	and -mtime)	from	the	beginning of today
		(otherwise, times start from 24 hours ago)
	-follow = dereference symbolic links (deprecated ??)
	-xdev = don't descend directories on other filesystems

*/
//	command = g_string_append (command, " -follow");

	if ( ! _e2p_find_get_flag (SEARCH_SUBDIRS_P))	//, rt))
		command = g_string_append (command, " -maxdepth 1");	//or -prune

/*	-name pattern
	-iname pattern like -name, but the match is case insensitive.
	-lname pattern a symbolic link whose contents match shell pattern pattern.
	-ilname pattern like -lname, but the match is case insensitive.
	-regex pattern
							Filename matches regular expression pattern. (this is a match
							on the whole path, not just the name)
	-iregex pattern
						Like -regex, but the match is case insensitive

	NB %f or %F result in quoted (space-separated if > 1 selected) names,
	_after_ the command is executed FIXME = how to wildcard those ??
*/
	tmp = gtk_entry_get_text (GTK_ENTRY (rt->pattern));
	if (*tmp != '\0')
	{
		gboolean macro = (g_str_equal (tmp, "%f") || g_str_equal (tmp, "%F"));
		if (_e2p_find_get_flag (STRING_FILENAME_P))	//, rt))
		{
			if (_e2p_find_get_flag (ANYCASE_FILENAME_P))	//, rt))
				command = g_string_append (command, " -iname ");
			else
				command = g_string_append (command, " -name ");
			tmp2 = (macro) ? g_strdup (tmp) : g_strconcat ( "\"", tmp, "\"", NULL);
		}
		else if (_e2p_find_get_flag (WILDCARD_FILENAME_P))	//, rt))
		{
			if (_e2p_find_get_flag (ANYCASE_FILENAME_P))	//, rt))
				command = g_string_append (command, " -iname ");
			else
				command = g_string_append (command, " -name ");
			tmp2 = (macro) ? g_strdup (tmp) : g_strconcat ( "\"*", tmp, "*\"", NULL);
		}
		else
		{
			if (_e2p_find_get_flag (ANYCASE_FILENAME_P))	//, rt))
				command = g_string_append (command, " -iregex ");
			else
				command = g_string_append (command, " -regex ");
			//for regex, need whole path instead of just name
			const gchar *tmp3 = gtk_entry_get_text (GTK_ENTRY (rt->directory));
	//		if (macro)	THIS WILL BE STUPID, IF MORE THAN 1 ITEM IS SELECTED
	//			tmp2 = g_strconcat (tmp5,"/?",tmp2, NULL);
	//		else
			//no surrounding "", unless %f or %F - but then the "" don't affect result
			tmp2 = g_strconcat (tmp3,"/?",tmp, NULL);
	//		macro = FALSE;	//make sure tmp2 is freed
		}
		tmp2 = _e2p_find_quote_string (tmp2);
	/*	if (!macro
			&& (strchr (tmp2, '*') != NULL || strchr (tmp2, '?') != NULL))
				command = g_string_prepend_c (command, '!');	//prevent wildcard expansion
		//FIXME ! also prevents macro (%d etc) expansion
		now seems no spurious wildcard expansion without it
	*/
		command = g_string_append (command, tmp2);
	//	if (!macro)
			g_free (tmp2);
	}
/*
	 +n -n
	-mtime n = file's data was last modified n*24 hours ago
	-atime n = file was last accessed n*24 hours ago
		-ctime n = file's status was last changed n*24 hours ago
*/
	gint usethis;
	offset result;
	GDate *nowat = g_date_new();
	g_date_set_time (nowat, time (NULL)); //refresh cuurent date/time
	if (   _e2p_find_get_flag (MTIME_ET_P)	//, rt)
		|| _e2p_find_get_flag (MTIME_EQ_P)	//, rt)
		|| _e2p_find_get_flag (MTIME_LT_P)	//, rt)
	   )
	{
		usethis = -1;
		_e2p_find_get_relative_datetime (nowat, &result, &rt->mtime);
		if (result.days > 0)
		{
			usethis = result.days;
			command = g_string_append (command, " -mtime ");
		}
		else if (result.minutes > 0)
		{
			usethis = result.minutes;
			command = g_string_append (command, " -mmin ");
		}
		if (usethis > 0)
		{
			if (_e2p_find_get_flag (MTIME_ET_P))	//, rt))
			{
				usethis--; //offset a day, just to cover fractional parts
				command = g_string_append_c (command, '+');
			}
			else if (_e2p_find_get_flag (MTIME_LT_P))	//, rt))
			{
				usethis++;
				command = g_string_append_c (command, '-');
			}
			g_string_append_printf (command, "%d", usethis);
		}
	}

	if (   _e2p_find_get_flag (ATIME_ET_P)	//, rt)
		|| _e2p_find_get_flag (ATIME_EQ_P)	//, rt)
		|| _e2p_find_get_flag (ATIME_LT_P)	//, rt)
		)
	{
		usethis = -1;
		_e2p_find_get_relative_datetime (nowat, &result, &rt->atime);
		if (result.days > 0)
		{
			usethis = result.days;
			command = g_string_append (command, " -atime ");
		}
		else if (result.minutes > 0)
		{
			usethis = result.minutes;
			command = g_string_append (command, " -amin ");
		}
		if (usethis > 0)
		{
			if (_e2p_find_get_flag (ATIME_ET_P))	//, rt))
			{
				usethis--; //offset a day, just to cover fractional parts
				command = g_string_append_c (command, '+');
			}
			else if (_e2p_find_get_flag (ATIME_LT_P))	//, rt))
			{
				usethis++; //offset a day, just to cover fractional parts
				command = g_string_append_c (command, '-');
			}
			g_string_append_printf (command, "%d", usethis);
		}
	}

	if (   _e2p_find_get_flag (CTIME_ET_P)	//, rt)
		|| _e2p_find_get_flag (CTIME_EQ_P)	//, rt)
		|| _e2p_find_get_flag (CTIME_LT_P)	//, rt)
		)
	{
		usethis = -1;
		_e2p_find_get_relative_datetime (nowat, &result, &rt->ctime);
		if (result.days > 0)
		{
			usethis = result.days;
			command = g_string_append (command, " -ctime ");
		}
		else if (result.minutes > 0)
		{
			usethis = result.minutes;
			command = g_string_append (command, " -cmin ");
		}
		if (usethis > 0)
		{
			if (_e2p_find_get_flag (CTIME_ET_P))	//, rt))
			{
				usethis--; //offset a day, just to cover fractional parts
				command = g_string_append_c (command, '+');
			}
			else if (_e2p_find_get_flag (CTIME_LT_P))	//, rt))
			{
				usethis++; //offset a day, just to cover fractional parts
				command = g_string_append_c (command, '-');
			}
			g_string_append_printf (command, "%d", usethis);
		}
	}

	g_date_free (nowat);
/*
	-user uname = file is owned by user uname (numeric user ID allowed).
	-group gname	= file belongs to group gname (numeric group ID allowed).
	-nouser = no user corresponds to file's numeric user ID.
	-nogroup = no group corresponds to file's numeric group ID.
*/
	if (_e2p_find_get_flag (UID_NONE_P))	//, rt))
		command = g_string_append (command, " -nouser");
	else if (_e2p_find_get_flag (UID_SPECIFIC_P))	//, rt))
	{
		//need to backet the 'or' tests, so find if we need then
		// (and always set tmp, for later)
		gboolean multi = (
		 ( (*(tmp = gtk_entry_get_text (GTK_ENTRY (rt->user_entry))) != '\0')
			&& _e2p_find_get_flag (UID_NOT_LOGIN_P) )	//, rt) )
			&& _e2p_find_get_flag (UID_LOGIN_P) );	//, rt) );
		if (multi)
			command = g_string_append (command, " \\(");
		if (_e2p_find_get_flag (UID_LOGIN_P))	//, rt))
		{
			guint user_id = getuid ();
			g_string_append_printf (command, " -user %d", user_id);
		}
		if (_e2p_find_get_flag (UID_NOT_LOGIN_P))	//, rt))
		{
			if (*tmp != '\0')
			{
				if (multi)
					command = g_string_append (command, " -o");
				tmp2 = g_locale_from_utf8 (tmp, -1, NULL, NULL, NULL);
				g_string_append_printf (command, " -user %s", tmp2);
				g_free (tmp2);
			}
		}
		if (multi)
			command = g_string_append (command, " ')'");
	}

	if (_e2p_find_get_flag (GID_NONE_P))	//, rt))
		command = g_string_append (command, " -nogroup");
	else if (_e2p_find_get_flag (GID_SPECIFIC_P))	//, rt))
	{
		gboolean multi = (
			( ( *(tmp = gtk_entry_get_text (GTK_ENTRY (rt->group_entry))) != '\0')
			&& _e2p_find_get_flag (GID_NOT_LOGIN_P))	//, rt))
			&& _e2p_find_get_flag (GID_LOGIN_P) );	//, rt) );
		if (multi)
		command = g_string_append (command, " '('");
		if (_e2p_find_get_flag (GID_LOGIN_P))	//, rt))
		{
			guint grp_id = getgid ();
			g_string_append_printf (command, " -group %d", grp_id);
		}
		if (_e2p_find_get_flag (GID_NOT_LOGIN_P))	//, rt))
		{
			if (*tmp != '\0')
			{
				if (multi)
					command = g_string_append (command, " -o");
				tmp2 = g_locale_from_utf8 (tmp, -1, NULL, NULL, NULL);
				g_string_append_printf (command, " -group %s", tmp2);
				g_free (tmp2);
			}
		}
		if (multi)
			command = g_string_append (command, " \\)");
	}
 /*
	-perm mode
							File's permission bits are exactly	mode	(octal	or	symbolic).
							Symbolic modes use mode 0 as a point of departure.
	-perm -mode
							All of the permission bits mode are set for the file.
	-perm +mode
							Any of the permission bits mode are set for the file.
*/

	mode_t mask[12] = {S_ISUID, S_ISGID, S_ISVTX, S_IRUSR, S_IWUSR, S_IXUSR,
			S_IRGRP, S_IWGRP, S_IXGRP, S_IROTH, S_IWOTH, S_IXOTH};
	mode_t mode = 0;
	gint i;
	for (i = 0; i < 12; i++)
	{
		if (_e2p_find_get_flag ( i + (gint) PERMISSIONS1))	//, rt))
				mode |= mask[i];
	}
	if (mode != 0)
	{
		if (_e2p_find_get_flag (MODE_NOT_P))	//, rt))
			command = g_string_append (command, " !");
		command = g_string_append (command, " -perm ");
		if (! _e2p_find_get_flag (MODE_IS_P))	//, rt))
			command = g_string_append_c (command, '-');
		g_string_append_printf (command, "%o" , (guint)mode);
	}
/*	-size nc	File uses n bytes
	-size nk	File uses n kilobytes
*/
	tmp = gtk_entry_get_text (GTK_ENTRY (rt->size_entry));
	if (*tmp != '\0')
	{
		tmp2 = g_locale_from_utf8 (tmp, -1, NULL, NULL, NULL);
		gdouble count = atof (tmp2);
		g_free (tmp2);
		command = g_string_append (command, " -size ");
		gchar s = '\0';
		if (_e2p_find_get_flag (FSIZE_LT_P))	//, rt))
			s = '-';
		else if (_e2p_find_get_flag (FSIZE_GT_P))	//, rt))
			s = '+';
		if (s != '\0')
			command = g_string_append_c (command, s);

		s = 'c';	//default size in bytes
		if (!_e2p_find_get_flag (FSIZE_B_P))	//, rt))
		{
			count = count * 1024;	//bump up the accuracy for finding big files with a fractional size
			if (_e2p_find_get_flag (FSIZE_MB_P))	//, rt))
				s = 'k';
		}

		g_string_append_printf (command, "%ld%c", (glong) count, s);
	}
/*	 -type c
							File is of type c:
							b			block (buffered) special
							c			character (unbuffered) special
							d			directory
							p			named pipe (FIFO)
							f			regular file
							l			symbolic link
							s			socket
	-xtype c
							The	same as -type unless the file is a symbolic link, for which -xtype	checks	the
							type of the linked file.
*/
	gint c = 0;
	gint p = (gint) REGULAR_P;
//REGULAR_P, DIRECTORY_P, RAW_DEVICE_P, BLOCK_DEVICE_P, SYMLINK_P, SOCKET_P, FIFO_P
	for	(i = 0; i < 7 ; i++)
	{
		if ( _e2p_find_get_flag ( i + p ))	//, rt))
		c++;
		if (c > 1)
		break;
	}
	if (c > 0)
	{
		gboolean multi = (c > 1);

		if (multi)
			command = g_string_append (command, " \\(");

		if (_e2p_find_get_flag (REGULAR_P))	//, rt))
		command = g_string_append (command, " -xtype f");
		if (_e2p_find_get_flag (DIRECTORY_P))	//, rt))
		{
			if (multi)
				command = g_string_append (command, " -o");
			command = g_string_append (command, " -xtype d");
		}
		if (_e2p_find_get_flag (RAW_DEVICE_P))	//, rt))
		{
			if (multi)
				command = g_string_append (command, " -o");
			command = g_string_append (command, " -xtype c");
		}
		if (_e2p_find_get_flag (BLOCK_DEVICE_P))	//, rt))
		{
			if (multi)
				command = g_string_append (command, " -o");
			command = g_string_append (command, " -xtype b");
		}
		if (_e2p_find_get_flag (SYMLINK_P))	//, rt))
		{
			if (multi)
				command = g_string_append (command, " -o");
			command = g_string_append (command, " -xtype l");
		}
		if (_e2p_find_get_flag (SOCKET_P))	//, rt))
		{
			if (multi)
				command = g_string_append (command, " -o");
			command = g_string_append (command, " -xtype s");
		}
		if (_e2p_find_get_flag (FIFO_P))	//, rt))
		{
			if (multi)
				command = g_string_append (command, " -o");
			command = g_string_append (command, " -xtype p");
		}
		if (multi)
			command = g_string_append (command, " \\)");
	} // c>0
/*
		 -exec command ;
							Execute	command;	true	if 0 status is returned.	All following
							arguments to find are taken to be arguments to the command until
							an	argument	consisting of `;' is encountered.	The string `{}'
							is replaced by the current file name being processed	everywhere
							it occurs in the arguments to the command, not just in arguments
							where it is alone, as in some versions of find.	Both	of	these
							constructions might need to be escaped (with a `\') or quoted to
							protect them from expansion by the shell.	The command	is	exe-
							cuted in the starting directory.
*/
	gchar *tmp3;
	tmp = gtk_entry_get_text (GTK_ENTRY (rt->mime_entry));
	gboolean msrch = (*tmp != '\0');
	tmp = gtk_entry_get_text (GTK_ENTRY (rt->content_pattern));
	gboolean csrch = (*tmp != '\0');

	if (csrch || msrch)
	// pipe(s) in command, need to exec in a separate shell
	command = g_string_prepend_c (command, '>');

	if (csrch && msrch)
	{
		tmp = gtk_entry_get_text (GTK_ENTRY (rt->mime_entry));
		tmp2 = g_locale_from_utf8 (tmp, -1, NULL, NULL, NULL);
			const gchar *tmp5 = gtk_entry_get_text (GTK_ENTRY (rt->content_pattern));
		gchar *tmp4 = g_locale_from_utf8 (tmp5, -1, NULL, NULL, NULL);
		tmp3 = (_e2p_find_get_flag (ANYCASE_CONTENT_P)) ? " -i" : "";
		//find cmd followed by a pipe needs to fork another shell
		//(in any event, e2 would need to fork a shell to do a pipe}
		g_string_append_printf (command,
	//		" -exec sh -c 'file -b -i -p -n {} | grep -q -i \'%s\' && grep%s -l -e \'%s\' {}' \\;",
	//		" -print0 | xargs -0 file -b -i -p -n {} | grep -q -i '%s' && grep%s -l -e '%s' {}",
			// sed = case-sensitive for mimetype
			//bash read command from pipe needs surrounding	(read .... ; ......)
			//and then, quotes needed to prevent command splitting when we run it
			//FIXME the final $F is not seen by bash, so the command fails
			" -print0 | xargs -0 file -i -p -n {} | sed -n '\\@%s@s/: .*//p' | (\"read F ; grep%s -l -e '%s' $F\")",
			tmp2, tmp3, tmp4);
		g_free (tmp2);
		g_free (tmp4);
	}
	else if (msrch)
	{
		tmp = gtk_entry_get_text (GTK_ENTRY (rt->mime_entry));
		tmp3 = g_locale_from_utf8 (tmp, -1, NULL, NULL, NULL);
		g_string_append_printf (command,
	//		" -exec sh -c 'file -b -i -p -n {} | grep -q -i \'%s\' && echo {}' \\;",
			//sed separator @ used instead of normal /, as mime string can have / in it
			// sed = case-sensitive for mimetype
			" -print0 | xargs -0 file -i -p -n {} | sed -n '\\@%s@s/: .*//p'",
			tmp3);
		g_free (tmp3);
	}
	else if (csrch)
	{
		tmp = gtk_entry_get_text (GTK_ENTRY (rt->content_pattern));
		tmp2 = (_e2p_find_get_flag (ANYCASE_CONTENT_P)) ? " -i" : "";
		tmp3 = g_locale_from_utf8 (tmp, -1, NULL, NULL, NULL);
		g_string_append_printf (command,
	//		" -exec grep%s -l -e '%s' '{}' \\;",
			" -print0 | xargs -0 grep%s -l -e '%s'",
			tmp2, tmp3);
		g_free (tmp3);
	}
	//DO IT
#ifdef E2_COMMANDQ
	gint res = e2_command_run (command->str, E2_COMMAND_RANGE_DEFAULT, TRUE);
#else
	gint res = e2_command_run (command->str, E2_COMMAND_RANGE_DEFAULT);
#endif
	if (res == 0)
	{
		E2_TaskRuntime *td = e2_task_find_last_running_child (TRUE);
		rt->find_pid = (td != NULL) ? td->pid : 0;
	}
	else
		rt->find_pid = 0;

//	printd (DEBUG, "find process id = %d", rt->find_pid);
	g_string_free (command, TRUE);

//we don't know when the command ends, to reset the buttons !
//	gtk_widget_set_sensitive (rt->help_button, FALSE);
//	gtk_widget_set_sensitive (rt->start_button, FALSE);
//	gtk_widget_set_sensitive (rt->stop_button, TRUE);
}
/**
@brief callback for stop find button click

@param w activated widget, UNUSED
@param rt ptr to dialog data struct

@return
*/
static void _e2p_find_stop_find_cb (GtkWidget *w, E2_FindDialogRuntime *rt)
{
	if (rt->find_pid > 0)
	{	//a process has been started
		e2_command_kill_child (rt->find_pid);
		rt->find_pid = 0; //prevent repeated attempts
		//revert button sensitivities
//		gtk_widget_set_sensitive (rt->help_button, TRUE);
//		gtk_widget_set_sensitive (rt->start_button, TRUE);
//		gtk_widget_set_sensitive (rt->stop_button, FALSE);
	}
}
/**
@brief callback for help button

executes external command "man gtkfind"

@param w activated widget, UNUSED
@param rt ptr to dialog data struct

@return
*/
static void _e2p_find_help_cb (GtkWidget *w, E2_FindDialogRuntime *rt)
{
	//these are components of help-file headings
	//_I( no translation until help docs are translated
 static gchar *msg[10] =
 {
	 "name",	//page 0
	 "content",	//page 1
#ifdef MIMEFIND
	 "mime",	//page 2
#endif
	 "mtime",	//page 3
	 "atime",	//page 4
	 "ctime",	//page 5
	 "size",	//page 6
	 "permission",	//page 7
	 "owner",	//page 8
	 "type"	//page 9
 };

	gint page = gtk_notebook_get_current_page (GTK_NOTEBOOK (rt->notebook));
 //_I( no translation until help docs are translated
 	gchar *title = g_strconcat ("find by ", msg[page], NULL);
	e2_utils_show_help (title);
	g_free (title);
}
/* *
@brief

@return
*/
/*static void _e2p_find_save_search_cb (E2_FindDialogRuntime *rt)
{
//	GtkWidget *filesel =
	_e2p_find_create_filesel (_("Save Search"), save_search_ok, save_search_cancel, rt);
} */
/**
@brief callback for year changed signal

This is needed to handle any February in a leap year

@param widget year spin-button widget
@param callback_data ptr to one of the day_spin widgets

@return
*/
static void _e2p_find_year_changed_cb (GtkWidget *widget, spinners *times)
{
	gint max_day;
	gint month = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (times->month_spin));

	if (month == 2)
	{	//we only need to do something about February
		if (_e2p_find_check_leapyear (gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget))))
			max_day = 29;
		else
			max_day = 28;

		gint day = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (times->day_spin));
		if (day > max_day)
		{
			day = max_day;
			gtk_spin_button_set_value (GTK_SPIN_BUTTON (times->day_spin), (gfloat) day);
		}
		GtkAdjustment* nadj = (GtkAdjustment *) gtk_adjustment_new
			((gfloat) day, 1, max_day, 1.0, 2.0, 0.0);
		gtk_spin_button_set_adjustment (GTK_SPIN_BUTTON (times->day_spin), nadj);
	}
}
/**
@brief callback for month changed signal

This is needed to handle any February in a leap year

@param widget month spin-button widget
@param callback_data ptr to one of the day_spin widgets

@return
*/
static void _e2p_find_month_changed_cb (GtkWidget *widget, spinners *times)
{
	gint nvalue;
	gint max_date;

	gint month = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget));
	gint ovalue = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (times->day_spin));
	if (month == 2)
	{
		if (_e2p_find_check_leapyear (gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (times->year_spin))))
			max_date = 29;
		else
			max_date = 28;
	}
	else if (month == 4 || month == 6 || month == 9 || month == 11)
		max_date = 30;
	else
		max_date = 31;

	if (ovalue > max_date)
	{
		nvalue = max_date;
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (times->day_spin), (gfloat) nvalue);
	}
	else
		nvalue = ovalue;

	GtkAdjustment *nadj = (GtkAdjustment *) gtk_adjustment_new
			( (gfloat) nvalue, 1, max_date, 1.0, 2.0, 0.0);
	gtk_spin_button_set_adjustment (GTK_SPIN_BUTTON (times->day_spin), nadj);
}

/**
@brief callback for notebook page-switched signal

@param notebook UNUSED the book whose page has changed
@param page UNUSED the new page
@param page_num the index of the new page
@param page_store pointer to store for @a page_num
@return
*/
static void _e2p_find_pagechange_cb (GtkNotebook *notebook,
	GtkNotebookPage *page, guint page_num, gint *page_store)
{
	*page_store = page_num;
}

  /*******************/
 /**** utilities ****/
/*******************/

/**
@brief add surrounding quotes to @a original if needed
@a original must be freeable, as it is replaced if need be
@param original the string to check

@return @a original, or a newly-allocated replacement
*/
static gchar *_e2p_find_quote_string (gchar *original)
{
	gboolean gap = (e2_utils_find_whitespace (original) != NULL);
	if (!gap)
		return original;
	if (*original == '"' && *(original + strlen (original) - 1) == '"')
		return original;
	gchar *quoted = g_strconcat ("\"", original, "\"", NULL);
	g_free (original);
	return quoted;
}
/**
@brief check if a specified year is a leap year
This was 'imported' from utils

@param year gint value of year to be checked

@return TRUE if @a year is a leap year
*/
static gboolean _e2p_find_check_leapyear (gint year)
{
	return (year % 4 == 0 && (year % 100 != 0 || year % 400 == 0));
}
/**
@brief set specified flag to T/F

The relevant array value is set

@param f enumerated value of flag to be set
@param value new value for the flag
@param rt UNUSED pointer to dialog data struct

@return
*/
static void _e2p_find_set_flag (findflag_t f, gboolean value)	//, E2_FindDialogRuntime *rt)
{
	if (f < MAX_FLAGS)
		flags [(gint) f] = value;
}
/**
@brief return the value of a specified flag

@param f enumerated value of flag to be interrogated
@param rt UNUSED pointer to dialog data struct

@return flag value, T/F, or FALSE if the value is not recognised
*/
static gboolean _e2p_find_get_flag (findflag_t f)	//, E2_FindDialogRuntime *rt)
{
	 if (f < MAX_FLAGS)
		return (flags[(gint) f]);
	 else
		 return (FALSE);
}
/**
@brief set all flags to FALSE

@param rt UNUSED pointer to dialog data struct

@return
*/
static void _e2p_find_reset_flags (void)	//E2_FindDialogRuntime *rt)
{
	gint i;
	for (i = 0; i < MAX_FLAGS; i++)
	{
/*		if (i == (gint) SEARCH_SUBDIRS_P
		 || i == (gint) PRINT_TO_WINDOW_P
		 || i == (gint) SHELL_COMMAND_P || i ==	(gint) PRINT_TO_STDOUT_P
		 || i == (gint) PRINT_FILENAME_ANYWAY_P || i ==	(gint) WARNING_WINDOW_P
		 || i == (gint) LONG_OUTPUT_P
		  )
		 ; // do nothing
		else
*/
			flags[i] = FALSE;
	}
}
/**
@brief determine difference between current date/time and the value from a spedified set of spinners

@param target ptr to data struct to store spinners results
@param times ptr to spinners data struct, with time to be interrogated

@return
*/
static void _e2p_find_get_relative_datetime (GDate *now, offset *result, spinners *times)
{
	_e2p_find_get_current_datetime (&current);	//need this till we figure out minutes diffs !
	GDate *target = g_date_new();
	g_date_set_dmy (target,
		gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (times->day_spin)),
	gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (times->month_spin)),
	gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (times->year_spin)) );
	result->days = g_date_days_between (target, now);	//if target < now, gives +ve no.

	if (result->days < 0)
	{
		result->days = 0;
		result->minutes = 0;
	}
	else if (result->days == 0)
	{	//figure out the minutes
/*		GTimeVal cs;
		g_get_current_time (&cs);
		gint cm = cs.tv_sec / 60;
		printd (DEBUG, "current hours = %d, current minutes = %d", cs.tv_sec / 3600, (cs.tv_sec % 3600) / 60);
*/
		gint cm = (gint) (current.hour * 60 + current.minute);
		gint th = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (times->hour_spin));
		gint tm = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (times->minute_spin))
			+ th * 60 - cm;
		if (tm >= 0)
			result->minutes = 0;
		else
			result->minutes = -tm;
	}
	else
	//signal we're not interested in minutes
		result->minutes = 0;

	g_date_free (target);
}
/**
@brief create local store of current date parameters

@param current ptr to struct for storage of current date/time data

@return
*/
static void _e2p_find_get_current_datetime (local_dt *current)
{
/* portable, but buggy, version (hours not correct)
	g_date_clear (&cur_date, 1);
	g_date_set_time (&cur_date, time (NULL));
	g_get_current_time (&cur_time);
	current->day = (gfloat) g_date_get_day (&cur_date);
	current->month = (gfloat) g_date_get_month (&cur_date);
	current->year = (gfloat) g_date_get_year (&cur_date);
	gint h1 = cur_time.tv_sec/3600;
	gint m1 = (cur_time.tv_sec - h1*3600)/60;
	gint s1 = cur_time.tv_sec - h1*3600 - m1 *60;
	current->hour = (gfloat) h1;
	current->minute = (gfloat) m1;
	current->second = (gfloat) s1;
*/
	time_t now = time (NULL);
	struct tm *tm = localtime (&now);

	current->day = (gfloat) tm->tm_mday;
	current->month = (gfloat) tm->tm_mon + 1;
	current->year = (gfloat) tm->tm_year + 1900;
	current->hour = (gfloat) tm->tm_hour;
	current->minute = (gfloat) tm->tm_min;
//	current->second = (gfloat) tm->tm_sec;
}
/**
@brief reset each resettable widget in the dialog

This applies recursively to all container widgets
The reset fn is determined from the widget's associated
"reset_yourself" data, if any

@param widget to be processed
@param data UNUSED data for the foreach fn

@return
*/
static void _e2p_find_reset_all_widgets (GtkWidget *widget, gpointer data)
{
	if (GTK_IS_CONTAINER (widget))
		gtk_container_foreach (GTK_CONTAINER (widget), _e2p_find_reset_all_widgets, NULL);

	gpointer (*reset_function) () = g_object_get_data (G_OBJECT (widget), "reset_yourself");
	if (reset_function != NULL)
		 (*reset_function) (widget);
}
/**
@brief reset an entry widget content to ""

@param widget the entry to be cleared

@return
*/
static void _e2p_find_reset_entry (GtkWidget *widget)
{
	gtk_entry_set_text (GTK_ENTRY (widget), "");
}
/**
@brief set toggle-button widget state to FALSE

@param widget the widget to be changed

@return
*/
static void _e2p_find_set_toggle_button_off (GtkWidget *widget)
{
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), FALSE);
}
/**
@brief set toggle-button widget state to TRUE

@param widget the widget to be changed

@return
*/
static void _e2p_find_set_toggle_button_on (GtkWidget *widget)
{
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), TRUE);
}
/**
@brief set spin-button widget state to its default value

The value is determined from the widget's associated
"default_value" data

@param widget the widget to be changed

@return
*/
static void _e2p_find_reset_spin_button (GtkWidget *widget)
{
	gfloat *value = g_object_get_data (G_OBJECT (widget), "default_value");
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget), *value);
}
/* *
@brief

@param w
@param filesel

@return
*/
/*OMIT? static void save_search_ok (GtkWidget *w, GtkFileSelection *filesel)
{
	const gchar *s = gtk_file_selection_get_filename (GTK_FILE_SELECTION (filesel));
	if (strlen (s) > 0)
	{
		save_search_command (s);
		gtk_widget_destroy (GTK_WIDGET (filesel));
	}
} */
/* *
@brief

@param w
@param filesel

@return
*/
/*OMIT ? static void save_search_cancel (GtkWidget *w, GtkFileSelection *filesel)
{
	gtk_widget_destroy (GTK_WIDGET (filesel));
} */

  /***************************/
 /***** widget creation *****/
/***************************/

#ifdef USE_SHELL
/**
@brief make the widgets associated with running shell commands

@param parent the widget into which the new widgets wll be packed

@return
*/
static void _e2p_find_make_shell_widgets (GtkWidget *parent)
{
	// output format selection
	GtkWidget *hbox = _e2p_find_create_hbox (parent);
	GtkWidget *radio = _e2p_find_create_radio_button (hbox,
//no _()		SHORT_OUTPUT_P, TRUE, _("Print only filename"));
	GSList *list = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radio));
//no _()	radio = gtk_radio_button_new_with_label (list, _("Print extra data"));
	g_signal_connect (G_OBJECT (radio), "toggled",
		G_CALLBACK (_e2p_find_toggle_cb), (gpointer) LONG_OUTPUT_P);
//need a reset for radio ??
	gtk_container_add (GTK_CONTAINER (hbox), radio);
	gtk_widget_show (radio);

	// shell command stuff

	_e2p_find_create_toggle_button (parent,
//no _()		SHELL_COMMAND_P, FALSE, _("Run a shell command?"));

	hbox = _e2p_find_create_hbox (parent);

//no _() GtkWidget *label = _e2p_find_create_label (hbox, _("Shell command:"));
	shell_command = _e2p_find_create_entry (hbox. "");

	hbox = _e2p_find_create_hbox (parent);

	_e2p_find_create_toggle_button (hbox,
//no _()		PRINT_TO_STDOUT_P, FALSE, _("Print to stdout"));
	_e2p_find_create_toggle_button (hbox,
//no _()		PRINT_TO_WINDOW_P, TRUE, _("Print to window"));
	_e2p_find_create_toggle_button (parent,
//no _()		PRINT_FILENAME_ANYWAY_P, FALSE, _("Always print filename"));
}
#endif	//def USE_SHELL
/**
@brief make the widgets involved with choosing the directory to search

@param box the widget into which the new widgets wll be packed
@param rt ptr to dialog data struct

@return
*/
static void _e2p_find_make_directory_widgets (GtkWidget *box, E2_FindDialogRuntime *rt)
{
	e2_widget_add_mid_label (box, _("Search for items:"), 0.0, FALSE, E2_PADDING_SMALL);
	GtkWidget *radio = _e2p_find_create_radio_button (box,
		SEARCH_ALL_P, FALSE, _("any_where"), rt);
	rt->active_button =
		_e2p_find_create_radio_grouped_button (box, radio,
		SEARCH_CURRENT_P, TRUE, _("in _active directory"), rt);
#ifdef E2_VFSTMP
	if (curr_view->spacedata != NULL)
		gtk_widget_set_sensitive (rt->active_button, FALSE);
	//FIXME later, change sensitivity if curr_view->fs changes
	rt->something =
#endif
	_e2p_find_create_radio_grouped_button (box, radio,
		SEARCH_OTHER_P, FALSE, _("in _other directory"), rt);
#ifdef E2_VFSTMP
	if (other_view->spacedata != NULL)
		gtk_widget_set_sensitive (rt->something, FALSE);
	//FIXME later, change sensitivity if other_view->fs changes
#endif
	rt->thisdir_button =
		_e2p_find_create_radio_grouped_button (box, radio,
		SEARCH_THIS_P, FALSE, _("in _this directory"), rt);
//	GtkWidget *button = _e2p_find_create_button (hbox, _e2p_find_choose_directory_cb, rt);
// _e2p_find_create_label (button, _("Choose Directory"));

	rt->directory = _e2p_find_create_entry (box, "");
	g_object_set_data (G_OBJECT (rt->directory), "reset_yourself", _e2p_find_reset_entry);
//#ifdef E2_VFSTMP
	//FIXME dir when not mounted local
//#else
//	gtk_entry_set_text (GTK_ENTRY (rt->directory), curr_view->dir);
//#endif
//	if (nocacheflags)
//	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rt->active_button), TRUE);
//	gboolean state = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (rt->thisdir_button));
//	gtk_widget_set_sensitive (rt->directory, state);

	//need to interpret keypresses for completion
	g_signal_connect (G_OBJECT (rt->directory), "key-press-event",
		G_CALLBACK (_e2p_find_key_press_cb), NULL);
//	_e2p_find_create_toggle_button (box,
//		SEARCH_SUBDIRS_P, TRUE, _("Recurse subdirectories"), rt);
	_e2p_find_create_toggle_button (box,
		SEARCH_SUBDIRS_P, TRUE, _("Recurse subdirectories"), rt);
}
/**
@brief make the file search-criteria notebook and its subwidgets

@param box the widget into which the notebook wll be packed
@param rt ptr to dialog data struct

@return
*/
static void _e2p_find_make_notebook (GtkWidget *box, E2_FindDialogRuntime *rt)
{
	rt->notebook = e2_widget_get_notebook (_e2p_find_pagechange_cb, &page_store);
	gtk_notebook_set_tab_pos (GTK_NOTEBOOK (rt->notebook), GTK_POS_LEFT);
	gtk_box_pack_start (GTK_BOX (box), rt->notebook, TRUE, TRUE, 0);
	gtk_widget_show (rt->notebook);

	_e2p_find_make_name_tab (rt->notebook, rt);	//page 0
	_e2p_find_make_content_tab (rt->notebook, rt);	//page 1
#ifdef MIMEFIND
	_e2p_find_make_mimetype_tab (rt->notebook, rt);	//page 2
#endif
	_e2p_find_get_current_datetime (&current);

	_e2p_find_make_mtime_tab (rt->notebook, rt);	//page 3
	_e2p_find_make_atime_tab (rt->notebook, rt);	//page 4
	_e2p_find_make_ctime_tab (rt->notebook, rt);	//page 5

	_e2p_find_make_size_tab (rt->notebook, rt);	//page 6
	_e2p_find_make_mode_tab (rt->notebook, rt);		//page 7
	_e2p_find_make_owner_tab (rt->notebook, rt);	//page 8
	_e2p_find_make_type_tab (rt->notebook, rt);		//page 9
}
/**
@brief make notebook tab with itemname search options

@param notebook the widget to which the tab wiil be added
@param rt ptr to dialog data struct

@return
*/
static void _e2p_find_make_name_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt)
{
	GtkWidget *label = gtk_label_new (_("name"));
	gtk_widget_show (label);
	GtkWidget *vbox = gtk_vbox_new (FALSE, E2_PADDING);
	gtk_widget_show (vbox);
	_e2p_find_create_label (vbox, _("Find items whose name:"));

	GtkWidget *hbox = _e2p_find_create_hbox (vbox);
	GtkWidget *radio = _e2p_find_create_radio_button (hbox,
		STRING_FILENAME_P, TRUE, _("is"), rt);
	_e2p_find_create_radio_grouped_button (hbox, radio,
		WILDCARD_FILENAME_P, FALSE, _("is like"), rt);
	//regex does not work - the find command is stuffed !
	GtkWidget *btn =
	_e2p_find_create_radio_grouped_button (hbox, radio,
		REGEXP_FILENAME_P, FALSE, _("matches this regex"), rt);
	gtk_widget_set_sensitive (btn, FALSE);

	hbox = _e2p_find_create_hbox (vbox);
	rt->pattern = _e2p_find_create_entry (hbox, entries [NAME_ENTRY]);
	g_object_set_data (G_OBJECT (rt->pattern), "reset_yourself", _e2p_find_reset_entry);

	hbox = _e2p_find_create_hbox (vbox);
	_e2p_find_create_toggle_button (hbox,
		ANYCASE_FILENAME_P, FALSE, _("ignore case"), rt);

	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox, label);
}
/**
@brief make notebook tab with itemsize search options

@param notebook notebook widget to which the tab wiil be added
@param rt ptr to dialog data struct

@return
*/
static void _e2p_find_make_size_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt)
{
	GtkWidget *label = gtk_label_new (_("size"));
	gtk_widget_show (label);

	GtkWidget *vbox = gtk_vbox_new (FALSE, E2_PADDING);
	gtk_widget_show (vbox);
	_e2p_find_create_label (vbox, _("Find items whose size is:"));

	GtkWidget *hbox = _e2p_find_create_hbox (vbox);
//	_e2p_find_create_toggle_button (hbox,
	GtkWidget *leader = _e2p_find_create_toggle_grouped_button
		(hbox, FSIZE_LT_P, FALSE, _("less than:"), NULL, rt);
	_e2p_find_create_toggle_button (hbox,
		FSIZE_EQ_P, FALSE, _("equal to:"), rt);
//	_e2p_find_create_toggle_button (hbox,
	_e2p_find_create_toggle_grouped_button (hbox,
		FSIZE_GT_P, TRUE, _("more than"), leader, rt);

	hbox = _e2p_find_create_hbox (vbox);
	rt->size_entry = _e2p_find_create_entry (hbox, entries [SIZE_ENTRY]);
	g_object_set_data (G_OBJECT (rt->size_entry), "reset_yourself", _e2p_find_reset_entry);

	GtkWidget *radio = _e2p_find_create_radio_button (hbox,
		FSIZE_B_P, TRUE, _("bytes"), rt);
	_e2p_find_create_radio_grouped_button (hbox, radio,
		FSIZE_KB_P, FALSE, _("kbytes"), rt);
	_e2p_find_create_radio_grouped_button (hbox, radio,
		FSIZE_MB_P, FALSE, _("Mbytes"), rt);

	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox, label);
}
#ifdef MIMEFIND
/**
@brief make notebook tab with mimetype search options

@param notebook notebook widget to which the tab wiil be added
@param rt ptr to dialog data struct

@return
*/
static void _e2p_find_make_mimetype_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt)
{
	GtkWidget *label = gtk_label_new (_("mime"));
	gtk_widget_show (label);

	GtkWidget *vbox = gtk_vbox_new (FALSE, E2_PADDING);
	gtk_widget_show (vbox);
//	GtkWidget *hbox = _e2p_find_create_hbox (vbox);
	_e2p_find_create_label (vbox, _("Find files whose mimetype is like this:"));

	GtkWidget *hbox = _e2p_find_create_hbox (vbox);
	rt->mime_entry = _e2p_find_create_entry (hbox, entries [MIME_ENTRY]);
	g_object_set_data (G_OBJECT (rt->mime_entry), "reset_yourself", _e2p_find_reset_entry);
// FIXME no lookup etc widgets ??
//	GtkWidget *hbox = _e2p_find_create_hbox (vbox);

	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox, label);
}
#endif	//def MIMEFIND
/**
@brief make notebook tab with file mtime search options

Options are: earlier than and/or equal to, later than and/or equal to.
By default, nothing is selected, so all mtimes will be matched

@param notebook notebook widget to which the tab wiil be added
@param rt ptr to dialog data struct

@return
*/
static void _e2p_find_make_mtime_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt)
{
	GtkWidget *label = gtk_label_new (_("save"));
	gtk_widget_show (label);

	GtkWidget *vbox = gtk_vbox_new (FALSE, E2_PADDING);
	gtk_widget_show (vbox);
	_e2p_find_create_label (vbox, _("Find items most-recently saved:"));

	GtkWidget *hbox = _e2p_find_create_hbox (vbox);

	GtkWidget *leader = _e2p_find_create_toggle_grouped_button
		(hbox, MTIME_ET_P, FALSE, _("before:"), NULL, rt);
	_e2p_find_create_toggle_button (hbox, MTIME_EQ_P, FALSE, _("on/at:"), rt);
	_e2p_find_create_toggle_grouped_button
		(hbox, MTIME_LT_P, FALSE, _("after:"), leader, rt);

	_e2p_find_make_all_spinners (vbox, &rt->mtime);
//	.day_spin, &rt->mtime.month_spin, &rt->mtime.year_spin,
//				&rt->mtime.hour_spin, &rt->mtime.minute_spin); //, &rt->mtime_second_spin);

	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox, label);
}
/**
@brief make notebook tab with file atime search options

Options are: earlier than and/or equal to, later than and/or equal to.
By default, nothing is selected, so all atimes will be matched

@param notebook widget to which the tab wiil be added
@param rt ptr to dialog data struct

@return
*/
static void _e2p_find_make_atime_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt)
{
	GtkWidget *label = gtk_label_new (_("access"));
	gtk_widget_show (label);
	GtkWidget *vbox = gtk_vbox_new (FALSE, E2_PADDING);
	gtk_widget_show (vbox);

	_e2p_find_create_label (vbox, _("Find items most-recently read or executed:"));

	GtkWidget *hbox = _e2p_find_create_hbox (vbox);

	GtkWidget *leader = _e2p_find_create_toggle_grouped_button
		(hbox, ATIME_ET_P, FALSE, _("before:"), NULL, rt);
	_e2p_find_create_toggle_button (hbox, ATIME_EQ_P, FALSE, _("on/at:"), rt);
	_e2p_find_create_toggle_grouped_button
	(hbox, ATIME_LT_P, FALSE, _("after:"), leader, rt);

	_e2p_find_make_all_spinners (vbox, &rt->atime);
//	.day_spin, &rt->atime.month_spin, &rt->atime.year_spin,
//				&rt->atime.hour_spin, &rt->atime.minute_spin); //, &rt->atime.second_spin);

	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox, label);
}
/**
@brief make notebook tab with filen ctime search options

Options are: earlier than and/or equal to, later than and/or equal to.
By default, nothing is selected, so all ctimes will be matched

@param notebook notebook widget to which the tab wiil be added
@param rt ptr to dialog data struct

@return
*/
static void _e2p_find_make_ctime_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt)
{
	GtkWidget *label = gtk_label_new (_("change"));
	gtk_widget_show (label);

	GtkWidget *vbox = gtk_vbox_new (FALSE, E2_PADDING);
	gtk_widget_show (vbox);
	_e2p_find_create_label (vbox, _("Find items whose inode was last changed:"));

	GtkWidget *hbox = _e2p_find_create_hbox (vbox);

	GtkWidget *leader = _e2p_find_create_toggle_grouped_button
		(hbox, CTIME_ET_P, FALSE, _("before:"), NULL, rt);
	_e2p_find_create_toggle_button (hbox, CTIME_EQ_P, FALSE, _("on/at:"), rt);
	_e2p_find_create_toggle_grouped_button
		(hbox, CTIME_LT_P, FALSE, _("after"), leader, rt);

	_e2p_find_make_all_spinners (vbox, &rt->ctime);
//	.day_spin, &rt->ctime.month_spin, &rt->ctime.year_spin,
//				&rt->ctime.hour_spin, &rt->ctime.minute_spin); //, &rt->ctime_second_spin);

	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox, label);
}
/**
@brief make notebook tab with file permissions search options

By default, nothing is selected, so any permissions will be matched

@param notebook widget to which the tab wiil be added
@param rt ptr to dialog data struct

@return
*/
static void _e2p_find_make_mode_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt)
{
	GtkWidget *label = gtk_label_new (_("permission"));
	gtk_widget_show (label);

	GtkWidget *vbox = gtk_vbox_new (FALSE, E2_PADDING);
	gtk_widget_show (vbox);
	_e2p_find_create_label (vbox, _("Find items whose permissions:"));

	GtkWidget *hbox = _e2p_find_create_hbox (vbox);
	GtkWidget *radio = _e2p_find_create_radio_button (hbox,
		MODE_IS_P, TRUE, _("are"), rt);
	_e2p_find_create_radio_grouped_button (hbox, radio,
		MODE_OR_P, FALSE, _("include"), rt);
	_e2p_find_create_radio_grouped_button (hbox, radio,
		MODE_NOT_P, FALSE, _("exclude"), rt);

	hbox = _e2p_find_create_hbox (vbox);
	// read
	GtkWidget *vbox2 = _e2p_find_create_vbox (hbox);
	_e2p_find_create_toggle_button (vbox2,
		OWNER_READ_P, FALSE, _("owner read"), rt);
	_e2p_find_create_toggle_button (vbox2,
		GROUP_READ_P, FALSE, _("group read"), rt);
	_e2p_find_create_toggle_button (vbox2,
		WORLD_READ_P, FALSE, _("anyone read"), rt);
	// write
	vbox2 = _e2p_find_create_vbox (hbox);
	_e2p_find_create_toggle_button (vbox2,
			OWNER_WRITE_P, FALSE, _("owner write"), rt);
	_e2p_find_create_toggle_button (vbox2,
		GROUP_WRITE_P, FALSE, _("group write"), rt);
	_e2p_find_create_toggle_button (vbox2,
		WORLD_WRITE_P, FALSE, _("anyone write"), rt);
	// exec
	vbox2 = _e2p_find_create_vbox (hbox);
	_e2p_find_create_toggle_button (vbox2,
		OWNER_EXEC_P, FALSE, _("owner execute"), rt);
	_e2p_find_create_toggle_button (vbox2,
		GROUP_EXEC_P, FALSE, _("group execute"), rt);
	_e2p_find_create_toggle_button (vbox2,
		WORLD_EXEC_P,	FALSE, _("anyone execute"), rt);
	// extra bits
	vbox2 = _e2p_find_create_vbox (hbox);
	_e2p_find_create_toggle_button (vbox2,
		SETUID_P, FALSE, _("setuid"), rt);
	_e2p_find_create_toggle_button (vbox2,
		SETGID_P, FALSE, _("setgid"), rt);
	_e2p_find_create_toggle_button (vbox2,
		STICKY_P, FALSE, _("sticky"), rt);

	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox, label);
}
/**
@brief make notebook tab with file type search options

By default, nothing is selected, so all types will be matched

@param notebook widget to which the tab wiil be added
@param rt ptr to dialog data struct

@return
*/
static void _e2p_find_make_type_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt)
{
	GtkWidget *label = gtk_label_new (_("type"));
	gtk_widget_show (label);

	GtkWidget *vbox = gtk_vbox_new (FALSE, E2_PADDING);
	gtk_widget_show (vbox);
	_e2p_find_create_label (vbox, _("Find items which are:"));

	GtkWidget *hbox = _e2p_find_create_hbox (vbox);
	GtkWidget *subvbox = _e2p_find_create_vbox (hbox);

	//FIXME use a table to align items horizontally as well
	_e2p_find_create_toggle_button (subvbox,
		REGULAR_P, FALSE, _("regular"), rt);
	_e2p_find_create_toggle_button (subvbox,
		DIRECTORY_P, FALSE, _("directory"), rt);
	_e2p_find_create_toggle_button (subvbox,
		SYMLINK_P, FALSE, _("symlink"), rt);

	subvbox = _e2p_find_create_vbox (hbox);
	_e2p_find_create_toggle_button (subvbox,
		BLOCK_DEVICE_P, FALSE, _("block device"), rt);
	_e2p_find_create_toggle_button (subvbox,
		RAW_DEVICE_P, FALSE, _("raw device"), rt);
	_e2p_find_create_toggle_button (subvbox,
		SOCKET_P, FALSE, _("socket"), rt);
	_e2p_find_create_toggle_button (subvbox,
		FIFO_P, FALSE, _("fifo"), rt);

	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox, label);
}
/**
@brief make notebook tab with file user/group search options

By default, any user and any group are selected

@param notebook widget to which the tab wiil be added
@param rt ptr to dialog data struct

@return
*/
static void _e2p_find_make_owner_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt)
{
	GtkWidget *label = gtk_label_new (_("owners"));
	gtk_widget_show (label);

	GtkWidget *vbox = gtk_vbox_new (FALSE, E2_PADDING);
	gtk_widget_show (vbox);
	_e2p_find_create_label (vbox, _("Find files with:"));

	GtkWidget *hbox = _e2p_find_create_hbox (vbox);

	//user
	GtkWidget *vbox2 = _e2p_find_create_vbox (hbox);
	GtkWidget *radio = _e2p_find_create_radio_button (vbox2,
		UID_ANY_P, TRUE, _("any user id"), rt);
	_e2p_find_create_radio_grouped_button (vbox2, radio,
		UID_SPECIFIC_P, FALSE, _("specific user id"), rt);
	find_rt->curr_user = _e2p_find_create_toggle_grouped_button (vbox2,
		UID_LOGIN_P, TRUE, _("current user's uid"), NULL, rt);
	find_rt->choose_user = _e2p_find_create_toggle_grouped_button (vbox2,
		UID_NOT_LOGIN_P, FALSE, _("this uid"), find_rt->curr_user, rt);
	//entry for specified uid
	rt->user_entry = _e2p_find_create_entry (vbox2, entries [UID_ENTRY]);
	g_object_set_data (G_OBJECT (rt->user_entry), "reset_yourself", _e2p_find_reset_entry);
	_e2p_find_create_radio_grouped_button (vbox2, radio,
		UID_NONE_P, FALSE, _("match unknown users"), rt);
	gboolean status = (_e2p_find_get_flag (UID_ANY_P) || _e2p_find_get_flag (UID_NONE_P));	//, rt));
	if (status)
	{
		gtk_widget_set_sensitive (find_rt->curr_user, FALSE);
		gtk_widget_set_sensitive (find_rt->choose_user, FALSE);
		gtk_widget_set_sensitive (find_rt->user_entry, FALSE);
	}
	else	//UID_SPECIFIC_P
	{
		gtk_widget_set_sensitive (find_rt->curr_user, TRUE);
		gtk_widget_set_sensitive (find_rt->choose_user, TRUE);
		gtk_widget_set_sensitive (find_rt->user_entry,
			_e2p_find_get_flag (UID_NOT_LOGIN_P));	//, find_rt));
	}
	// group
	vbox2 = _e2p_find_create_vbox (hbox);
	radio = _e2p_find_create_radio_button (vbox2,
		GID_ANY_P, TRUE, _("any group id"), rt);
	_e2p_find_create_radio_grouped_button (vbox2, radio,
		GID_SPECIFIC_P, FALSE, _("specific group id"), rt);
	find_rt->curr_group = _e2p_find_create_toggle_grouped_button (vbox2,
		GID_LOGIN_P, TRUE, _("current user's gid"), NULL, rt);
	find_rt->choose_group = _e2p_find_create_toggle_grouped_button (vbox2,
		GID_NOT_LOGIN_P, FALSE, _("this gid"), find_rt->curr_group, rt);
	//entry for specified gid
	rt->group_entry = _e2p_find_create_entry (vbox2, entries [GID_ENTRY]);
	g_object_set_data (G_OBJECT (rt->group_entry), "reset_yourself", _e2p_find_reset_entry);
	_e2p_find_create_radio_grouped_button (vbox2, radio,
		GID_NONE_P, FALSE, _("match unknown groups"), rt);
	status = (_e2p_find_get_flag (GID_ANY_P) || _e2p_find_get_flag (GID_NONE_P));	//, rt));
	if (status)
	{
		gtk_widget_set_sensitive (rt->curr_group, FALSE);
		gtk_widget_set_sensitive (rt->choose_group, FALSE);
		gtk_widget_set_sensitive (rt->group_entry, FALSE);
	}
	else	//GID_SPECIFIC_P
	{
		gtk_widget_set_sensitive (find_rt->curr_group, TRUE);
		gtk_widget_set_sensitive (find_rt->choose_group, TRUE);
		gtk_widget_set_sensitive (find_rt->group_entry,
			_e2p_find_get_flag (GID_NOT_LOGIN_P));	//, find_rt));
	}

	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox, label);
}
/**
@brief make notebook tab with file content search options

matches simple substrings by default, but may match wildcards.
If you want regexps, use grep !!

@param notebook widget to which the tab wiil be added
@param rt ptr to dialog data struct

@return
*/
static void _e2p_find_make_content_tab (GtkWidget *notebook, E2_FindDialogRuntime *rt)
{
	GtkWidget *label = gtk_label_new (_("content"));
	gtk_widget_show (label);

	GtkWidget *vbox = gtk_vbox_new (FALSE, E2_PADDING);
	gtk_widget_show (vbox);
	_e2p_find_create_label (vbox, _("Find files with content that is:"));

	GtkWidget *hbox = _e2p_find_create_hbox (vbox);
	GtkWidget *radio = _e2p_find_create_radio_button (hbox,
		STRING_CONTENT_P, TRUE, _("this"), rt);
	_e2p_find_create_radio_grouped_button (hbox, radio,
		WILDCARD_CONTENT_P, FALSE, _("like this"), rt);
	_e2p_find_create_radio_grouped_button (hbox, radio,
		REGEXP_CONTENT_P, FALSE, _("like this regex"), rt);

	hbox = _e2p_find_create_hbox (vbox);
//	hbox = e2_widget_add_box (vbox, TRUE, 0, TRUE, FALSE, E2_PADDING);
	rt->content_pattern = _e2p_find_create_entry (hbox, entries [CONTENT_ENTRY]);
	g_object_set_data (G_OBJECT (rt->content_pattern), "reset_yourself",
		_e2p_find_reset_entry);

	hbox = _e2p_find_create_hbox (vbox);
	_e2p_find_create_toggle_button (hbox,
		ANYCASE_CONTENT_P, FALSE, _("ignore case"), rt);

	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox, label);
}

  /**********************************/
 /***** lesser widget creation *****/
/**********************************/

/* *
@brief create and show a vbox widget in a specified container widget

@param container widget into which the vbox is to be added

@return the vbox widget
*/
/*static GtkWidget *_e2p_find_create_vbox (GtkWidget *container)
{
	GtkWidget *rv = gtk_vbox_new (FALSE, E2_PADDING);
	gtk_container_add (GTK_CONTAINER (container), rv);
	gtk_widget_show (rv);
	return rv;
} */
/* *
@brief create and show a hbox widget in a specified container widget

@param container widget into which the hbox is to be added

@return the hbox widget
*/
/*GtkWidget *_e2p_find_create_hbox (GtkWidget *container)
{
	GtkWidget *rv = gtk_hbox_new (FALSE, E2_PADDING);
	gtk_container_add (GTK_CONTAINER (container), rv);
	gtk_widget_show (rv);
	return rv;
} */
/* *
@brief create and show a label widget in a specified container widget

@param container widget into which the label is to be added

@return the label widget
*/
/*static GtkWidget *_e2p_find_create_label (GtkWidget *container, gchar *text)
{
	GtkWidget *rv = gtk_label_new (text);
	gtk_container_add (GTK_CONTAINER (container), rv);
	gtk_widget_show (rv);
	return rv;
} */
/* *
@brief create and show an entry widget in a specified container widget

@param container widget into which the entry is to be added

@return the entry widget
*/
/*static GtkWidget *_e2p_find_create_entry (GtkWidget *container)
{
	GtkWidget *rv = gtk_entry_new ();
	gtk_container_add (GTK_CONTAINER (container), rv);
	gtk_widget_show (rv);
	return rv;
} */
/**
@brief create a hbox in @a box

@param box the widget into which the button is to be placed

@return the created box widget
*/
static GtkWidget *_e2p_find_create_hbox (GtkWidget *box)
{
	GtkWidget *hbox = gtk_hbox_new (FALSE, E2_PADDING);
	gtk_box_pack_start (GTK_BOX (box), hbox, FALSE, FALSE, E2_PADDING);
	gtk_widget_show (hbox);
	return hbox;
}
/**
@brief create and show a button in a specified container

@param box the widget into which the button is to be placed
@param f enumerated value of flag to be associated with the button
@param state T/F initial state of the toggle
@param label translated string for the button label
@param callback the "toggled"-signal callback for the button
@param rt ptr to dialog data struct

@return the button widget
*/
static GtkWidget *_e2p_find_create_toggle_button_real (GtkWidget *box,
	findflag_t f, gboolean state, gchar *label, gpointer callback,
	E2_FindDialogRuntime *rt)
{
	gboolean defstate = state;
	if (nocacheflags)
	{
		//newly-initialised flags default to FALSE, we don't want that
		if (state)
			_e2p_find_set_flag (f, TRUE);	//, rt);
	}
	else
		state = _e2p_find_get_flag (f);	//, rt);

	GtkWidget *button = e2_button_add_toggle (box, TRUE, state,
		label, NULL, TRUE, E2_PADDING, callback, (gpointer) f);
	g_object_set_data (G_OBJECT (button), "reset_yourself",
		defstate ? _e2p_find_set_toggle_button_on : _e2p_find_set_toggle_button_off );
	return button;
}
/**
@brief create and show a grouped toggle in a specified box

@param box the widget into which the button is to be placed
@param f enumerated value of flag to be associated with the button
@param state T/F initial state of the toggle
@param label translated string for the button label
@param leader widget for the 'leader' of the group, or NULL if this is the leader
@param rt ptr to dialog data struct

@return the button widget (UNUSED, now)
*/
static GtkWidget *_e2p_find_create_toggle_grouped_button (GtkWidget *box,
	findflag_t f, gboolean state, gchar *label, GtkWidget *leader,
	E2_FindDialogRuntime *rt)
{
	GtkWidget *button = _e2p_find_create_toggle_button_real (box, f, state, label,
		_e2p_find_grouptoggle_cb, rt);
	GtkWidget *ptr;
	GSList *members;
	if (leader == NULL)
	{	//this is the leader of a new group
		ptr =	button;	//point to self
		members = NULL;
		rt->groups = g_slist_append (rt->groups, button);	//remember it, for cleaning up
	}
	else
	{	//this is a group member
		ptr = leader;	//point to group leader, which has list
		members = g_object_get_data (G_OBJECT (leader), "group_members");
	}
	g_object_set_data (G_OBJECT (button), "group_leader", ptr);
	members = g_slist_append (members, button);
	g_object_set_data (G_OBJECT (ptr), "group_members", members);
	return button;
}
/**
@brief create and show a toggle in a specified container

@param box the widget into which the button is to be placed
@param f enumerated value of flag to be associated with the button
@param state T/F initial state of the toggle
@param label translated string for the button label

@return the button widget (UNUSED, now)
*/
static GtkWidget *_e2p_find_create_toggle_button (GtkWidget *box, findflag_t f,
	gboolean state, gchar *label, E2_FindDialogRuntime *rt)
{
	GtkWidget *button = _e2p_find_create_toggle_button_real
		(box, f, state, label, _e2p_find_toggle_cb, rt);
	return button;
}
/**
@brief create and show a radio btn in a specified box
The leader of a group is initialized to TRUE, other group members
may cause that to be changed
@param box the widget into which the button is to be placed
@param f enumerated value of flag to be associated with the button
@param state the initial state of the button T/F
@param label translated string for the button label
@param rt ptr to dialog data struct

@return the button widget
*/
static GtkWidget *_e2p_find_create_radio_button (GtkWidget *box,
	findflag_t f, gboolean state, gchar *label, E2_FindDialogRuntime *rt)
{
	if (nocacheflags)
	{
		//newly-initialised flags default to FALSE, we don't want that
		if (state)
			_e2p_find_set_flag (f, TRUE);	//, rt);
	}
	else
		state = _e2p_find_get_flag (f);	//, rt);

	GtkWidget *button = e2_button_add_radio (box, label, NULL, state, TRUE, 0,
		_e2p_find_toggle_cb, (gpointer) f);
	g_object_set_data (G_OBJECT (button), "reset_yourself",
		state ? _e2p_find_set_toggle_button_on : _e2p_find_set_toggle_button_off );
	return button;
}
/**
@brief create and show a radio btn in a specified container

@param container the widget into which the button is to be placed
@param leader the radio button widget that 'leads' the group
@param f enumerated value of flag to be associated with the button
@param state T/F default initial state of the toggle
@param label translated string for the button label
@param rt ptr to dialog data struct

@return the button widget
*/
static GtkWidget *_e2p_find_create_radio_grouped_button (GtkWidget *box,
	GtkWidget *leader, findflag_t f, gboolean state, gchar *label,
	E2_FindDialogRuntime *rt)
{
	if (nocacheflags)
	{
	//newly-initialised flags default to FALSE, we don't want that
	if (state)
		_e2p_find_set_flag (f, TRUE);	//, rt);
	}
	else
		state = _e2p_find_get_flag (f);	//, rt);

	GSList *group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (leader));
	GtkWidget *button = e2_button_add_radio (box, label, group, state, TRUE, 0,
		_e2p_find_toggle_cb, (gpointer) f);
	g_object_set_data (G_OBJECT (button), "reset_yourself",
		state ? _e2p_find_set_toggle_button_on : _e2p_find_set_toggle_button_off );
	return button;
}
/**
@brief create a spin button

@param default_value ptr to value to be stored
@param min_value minimum allowed value for the button
@param max_value maximum allowed value for the button

@return the button widget
*/
static GtkWidget *_e2p_find_create_spin_button (gfloat *default_value,
	gfloat min_value, gfloat max_value)
{
	GtkObject *adj = gtk_adjustment_new (*default_value, min_value,
		max_value, 1.0, 2.0, 0.0);
	GtkWidget *button = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 0, 0);
	gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (button), TRUE);
	g_object_set_data (G_OBJECT (button), "default_value", default_value);
	g_object_set_data (G_OBJECT (button), "reset_yourself", _e2p_find_reset_spin_button);
	return button;
}
/**
@brief add date and time spinners to specified container

@param box widget to which the spinners are to be added
@param time ptr to spinners data struct for mtime, atime or ctime

@return
*/
static void _e2p_find_make_all_spinners (GtkWidget *box, spinners *time)
{
	GtkWidget *hbox = _e2p_find_create_hbox (box);
	//day widget
	GtkWidget *vbox = _e2p_find_create_vbox (hbox);
	GtkWidget *label = _e2p_find_create_label (vbox, _("Day"));
//	*day
	time->day_spin = _e2p_find_create_spin_button (&current.day, 1.0, 31.0);
	gtk_box_pack_start (GTK_BOX (vbox), time->day_spin, FALSE, FALSE, E2_PADDING_XSMALL);
	gtk_widget_show (time->day_spin);

	//month widget
	vbox = _e2p_find_create_vbox (hbox);
	label = _e2p_find_create_label (vbox, _("Month"));
//	*month
	time->month_spin = _e2p_find_create_spin_button (&current.month, 1.0, 12.0);
	gtk_box_pack_start (GTK_BOX (vbox), time->month_spin, FALSE, FALSE, E2_PADDING_XSMALL);
	g_signal_connect_after (G_OBJECT (time->month_spin), "changed",
		G_CALLBACK (_e2p_find_month_changed_cb), time);
	gtk_widget_show (time->month_spin);

	//year widget
	vbox = _e2p_find_create_vbox (hbox);
	label = _e2p_find_create_label (vbox, _("Year"));
//	*year
	time->year_spin = _e2p_find_create_spin_button (&current.year, 0.0, 9999.0);
//	gtk_widget_set_size_size_request (*year, 55, -1); // make it 4 digits wide
	gtk_box_pack_start (GTK_BOX (vbox), time->year_spin, FALSE, FALSE, E2_PADDING_XSMALL);
	g_signal_connect_after (G_OBJECT (time->year_spin), "changed",
		G_CALLBACK (_e2p_find_year_changed_cb), time);
	gtk_widget_show (time->year_spin);

	//hour widget
	vbox = _e2p_find_create_vbox (hbox);
	label = _e2p_find_create_label (vbox, _("Hour"));
//	*hour
	time->hour_spin = _e2p_find_create_spin_button (&current.hour, 0.0, 23.0);
	gtk_box_pack_start (GTK_BOX (vbox), time->hour_spin, FALSE, FALSE, E2_PADDING_XSMALL);
	gtk_widget_show (time->hour_spin);

	//minute widget
	vbox = _e2p_find_create_vbox (hbox);
	label = _e2p_find_create_label (vbox, _("Minute"));
//	*minute
	time->minute_spin = _e2p_find_create_spin_button (&current.minute, 0.0, 59.0);
	gtk_box_pack_start (GTK_BOX (vbox), time->minute_spin, FALSE, FALSE, E2_PADDING_XSMALL);
	gtk_widget_show (time->minute_spin);

/*	//second widget
	vbox = _e2p_find_create_vbox (hbox);
	label = _e2p_find_create_label (vbox, _("Second"));
	GtkWidget *second = _e2p_find_create_spin_button (&current.second, 0.0, 59.0);
	gtk_box_pack_start (GTK_BOX (vbox), second, FALSE, FALSE, E2_PADDING_XSMALL);
	gtk_widget_show (second); */

	//init proper days per month
	_e2p_find_month_changed_cb (time->month_spin, time);
}
/**
@brief establish and show find dialog
There is no compelling reason to queue this, it does not necessarily work
on either displayed filelist
@param from the button, menu item etc which was activated
@param art action runtime data

@return TRUE
*/
static gboolean _e2p_find_dialog_create (gpointer from, E2_ActionRuntime *art)
{
	//because we use static var's, check if there is already a config dialog opened
	if (find_rt != NULL)
	{
		gtk_window_present (GTK_WINDOW (find_rt->dialog));
		return TRUE;
	}
	//init runtime object
	find_rt = ALLOCATE (E2_FindDialogRuntime);
	CHECKALLOCATEDWARN (find_rt, return FALSE;)
	find_rt->groups = NULL;

	gint startpage = page_store;	//preserve this
	//create dialog
	find_rt->dialog = e2_dialog_create (NULL, NULL, _("find files"),
		_e2p_find_response_cb, find_rt);
	GtkWidget *dialog_vbox = GTK_DIALOG (find_rt->dialog)->vbox;
	gtk_container_set_border_width (GTK_CONTAINER (dialog_vbox), E2_PADDING);
	//populate it
	//first with things for selecting the seach starting place
	_e2p_find_make_directory_widgets (dialog_vbox, find_rt);
	e2_widget_add_separator (dialog_vbox, FALSE, E2_PADDING_SMALL);
	//then with things to identify the files of interest
	_e2p_find_make_notebook (dialog_vbox, find_rt);

	// add buttons in the order that they will appear
	//find_rt->help_button =
	e2_dialog_add_undefined_button_custom
		(find_rt->dialog, FALSE, E2_RESPONSE_USER2, _("_Help"), GTK_STOCK_HELP,
		_("get advice on search options on this page"), _e2p_find_help_cb, find_rt);
/*	//omit this
	button = _e2p_find_create_button (hbox, _e2p_find_save_search_cb, NULL);
	label = _e2p_find_create_label (button, _("_Save"));
*/
 // find_rt->stop_button =
	e2_dialog_add_button_custom (find_rt->dialog, FALSE,
		&E2_BUTTON_NOTOALL, _("stop the current search"), _e2p_find_stop_find_cb, find_rt);
	//de-sensitize stop btn, at this stage
//	gtk_widget_set_sensitive (find_rt->stop_button, FALSE);

//	find_rt->start_button =
	e2_dialog_add_undefined_button_custom (find_rt->dialog, FALSE,
		E2_RESPONSE_FIND, _("_Find"), GTK_STOCK_FIND, _("begin searching"),
		_e2p_find_find_cb, find_rt);
	e2_dialog_add_undefined_button_custom (find_rt->dialog, FALSE, E2_RESPONSE_USER1,
		_("Clea_r"), GTK_STOCK_CLEAR, _("clear all search parameters"),
		_e2p_find_clear_find_cb, find_rt);
	e2_dialog_add_defined_button (find_rt->dialog, &E2_BUTTON_CLOSE);
	e2_dialog_set_negative_response (find_rt->dialog, GTK_RESPONSE_CLOSE);

	e2_dialog_setup (find_rt->dialog, app.main_window);
	gtk_widget_show (find_rt->dialog);

	if (nocacheflags)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (find_rt->active_button), TRUE);
	gboolean state = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (find_rt->thisdir_button));
	gtk_widget_set_sensitive (find_rt->directory, state);
	//open at same page as last time
	if (startpage > 0)
		gtk_notebook_set_current_page (GTK_NOTEBOOK (find_rt->notebook), startpage);

	if (nocacheflags)
		nocacheflags = FALSE;	//from now on, use static/cached flag values

	gtk_main ();

	return TRUE;
}

//aname must be confined to this module
static gchar *aname;
/**
@brief plugin initialization function, called by main program

@param p ptr to plugin data struct

@return TRUE if the initialization succeeds, else FALSE
*/
gboolean init_plugin (Plugin *p)
{
#define ANAME "detfind"
	aname = _("detfind");

	p->signature = ANAME VERSION;
	p->menu_name = _("_Find..");
	p->description = _("Find and list items, using detailed criteria");
	p->icon = "plugin_find_"E2IP".png";	//use icon file pathname if appropriate

	if (p->action == NULL)
	{
		//no need to free this
		gchar *action_name = g_strconcat (_A(1),".",aname,NULL);
		p->action = e2_plugins_action_register
			(action_name, E2_ACTION_TYPE_ITEM, _e2p_find_dialog_create, NULL, FALSE, 0, NULL);

		nocacheflags = !e2_cache_check ("find-plugin-flags");
		if (nocacheflags)
			//initialise flags
			//(some will be further changed when specific widgets are created)
			_e2p_find_reset_flags ();	//find_rt);
		e2_cache_array_register ("find-plugin-flags", MAX_FLAGS, flags, flags);

		guint i;
		e2_cache_list_register ("find-plugin-strings", &strings);
		if (strings == NULL)
		{	//no cache found for this item
			//init entry strings, with fillers in case session ends before dialog is closed
			for (i = 0; i < MAX_ENTRIES; i++)
				strings = g_list_append (strings, g_strdup ("."));
		}

		for (i = 0; i < MAX_ENTRIES; i++)
		{
			entries[i] = (gchar *) g_list_nth_data (strings, i);
			//remove cached filler string
			if (g_str_equal (entries[i], "."))
				entries[i] = blank;
		}

		return TRUE;
	}
	return FALSE;
}
/**
@brief cleanup transient things for this plugin

@param p pointer to data struct for the plugin

@return TRUE if all cleanups were completed
*/
gboolean clean_plugin (Plugin *p)
{
	gchar *action_name = g_strconcat (_A(1),".",aname,NULL);
	gboolean ret = e2_plugins_action_unregister (action_name);
	g_free (action_name);
	if (ret)
	{
		//backup the cache data
		e2_cache_unregister ("find-plugin-flags");
		e2_cache_unregister ("find-plugin-strings");
		//cleanup
		e2_list_free_with_data (&strings);	//this also clears the array
	}
	return ret;
}
