/* $Id: e2p_track.c 544 2007-07-20 12:48:20Z tpgww $

Copyright (C) 2006-2007 tooar <tooar@gmx.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "emelfm2.h"
#include <string.h>
#include "e2_plugins.h"
#include "e2_dialog.h"

typedef struct _E2_TrackDlgData
{
	GtkWidget *dialog;
	GtkWidget *service_combo;
	GtkWidget *query_combo;
	GtkWidget *type_radio;	//1st member of search-type radio group
	GtkWidget *type_radio2;	//2nd member of search-type radio group
} E2_TrackDlgData;

enum {
	SERVICE_DOCUMENTS,
	SERVICE_TEXTFILES,
	SERVICE_IMAGES,
	SERVICE_VIDEOS,
	SERVICE_MUSIC,
/*	SERVICE_PLAYLISTS,
	SERVICE_PEOPLE,
	SERVICE_EMAILS,
	SERVICE_TALKS,
	SERVICE_APPOINTS,
	SERVICE_NOTES,
	SERVICE_TODOS,
	SERVICE_BOOKMARKS,
	SERVICE_PROJECTS,
*/
	SERVICE_OTHERFILES,
	SERVICE_DEVFILES,
//	SERVICE_FOLDERS,
//	SERVICE_APPLICATIONS,
	MAXSERVICES};

static gint service_index = 0;
static GList *query_history = NULL;

static gchar *object_names [MAXSERVICES] =
{ //these service strings are in same order as enum
  //FIXME make mnemonics work in combobox histories
	N_("office documents"),
	N_("text files"),
	N_("images"),
	N_("videos"),
	N_("music"),
/* not yet supported
	N_("playlists"),
	N_("people"),
	N_("emails"),
	N_("conversations"),
	N_("appointments"),
	N_("notes"),
	N_("tasks"),
	N_("bookmarks"),
	N_("projects")
*/
	N_("other files"),
	N_("development files"),
//	N_("folders"),
//	N_("applications"),
};
/*
      ( 'Files',             'system-file-manager'      ),
      ( 'Folders',           'folder'                   ),
      ( 'Applications',      'application-x-executable' ),
      ( 'Conversations',     'face-smile-big'           ),
      ( 'Contacts',          'x-office-address-book'    ),
      ( 'Development Files', 'applications-development' ),
      ( 'Documents',         'x-office-document'        ),
      ( 'Emails',            'email'                    ),
      ( 'Images',            'image-x-generic'          ),
      ( 'Music',             'audio-x-generic'          ),
      ( 'Text Files',        'text-x-generic'           ),
      ( 'Videos',            'video-x-generic'          ),
*/

static gchar *cmd_str [MAXSERVICES] =
{	//these service names are hardcoded in tracker-files, and not translated
	//same order here as enum
	"Documents",
	"Text",
	"Images",
	"Videos",
	"Music",
/*	NULL,	//SERVICE_PLAYLISTS,
	NULL,	//SERVICE_PEOPLE,
	NULL,	//SERVICE_EMAILS,
	NULL,	//SERVICE_TALKS,
	NULL,	//SERVICE_APPOINTS,
	NULL,	//SERVICE_NOTES,
	NULL,	//SERVICE_TODOS,
	NULL,	//SERVICE_BOOKMARKS,
	NULL,	//SERVICE_PROJECTS,
*/
	"Other",
	"Development",
//	NULL,	//SERVICE_FOLDERS,
//	NULL	//SERVICE_APPLICATIONS,
};

/**
@brief response callback for plugin selection dialog

@param dialog the dialog where the response was triggered
@param response the response assigned to the activated button widget
@param data ptr to plugins option data struct

@return
*/
static void _e2p_track_choose_response_cb (GtkDialog *dialog, gint response,
	E2_TrackDlgData *rt)
{
	if (response == E2_RESPONSE_USER1)
		return;	//ignore toggles of hidden-items
	if (response == GTK_RESPONSE_OK)
	{
		//returns localized string
		gchar *local = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
		if (local != NULL)
		{	//no conversion error
			gchar *utf = F_FILENAME_FROM_LOCALE (local);
			gtk_entry_set_text (GTK_ENTRY (GTK_BIN (rt->query_combo)->child), utf);
			g_free (local);
			F_FREE (utf);
		}
	}
	gtk_widget_destroy (GTK_WIDGET (dialog));
	gtk_widget_grab_focus (GTK_BIN (rt->query_combo)->child);
}
/**
@brief bring up a system find-file window to choose a plugin

@param button activated widget, UNUSED
@param rt ptr to dialog data struct

@return
*/
static void _e2p_track_choose_rdf_cb (GtkWidget *button, E2_TrackDlgData *rt)
{
	//no need for vfs support here
	GtkWidget *dialog = gtk_file_chooser_dialog_new (NULL,
		GTK_WINDOW (rt->dialog), GTK_FILE_CHOOSER_ACTION_OPEN,
		GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
		GTK_STOCK_OK, GTK_RESPONSE_OK,
		NULL);

	e2_dialog_setup_chooser (dialog,
		_("choose query"),
		NULL,	//CWD
		GTK_FILE_CHOOSER_ACTION_OPEN,
		FALSE,	//hide-hidden
		FALSE,	//single-selection
		GTK_RESPONSE_OK);	//default response

	GtkFileFilter *filter = gtk_file_filter_new ();
	gtk_file_filter_set_name (GTK_FILE_FILTER (filter), _("rdf"));
	gtk_file_filter_add_pattern (filter, "*.rdf");
	gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (dialog), filter);

/*	//hide the dialog's standard 'open' button
	GtkContainer *bbox = GTK_CONTAINER (GTK_DIALOG (dialog)->action_area);
	GList* children = gtk_container_get_children (bbox);
	GtkWidget *btn = children->data;
	gtk_widget_hide (btn);
	g_list_free (children);
	//add 2 buttons that we want
	e2_dialog_add_defined_button (dialog, &E2_BUTTON_APPLY);
	e2_dialog_add_defined_button (dialog, &E2_BUTTON_OK);
*/
	g_signal_connect (G_OBJECT (dialog), "response",
		G_CALLBACK (_e2p_track_choose_response_cb), rt);

	e2_dialog_setup (dialog, rt->dialog);
	gtk_widget_show (dialog);
}
/*
 //get files with service (Documents, Music, Images, Videos, Text, Development, Other)
tracker-files -s service
 //get files with mime type(s)
tracker-files -m Mime1 [Mime2...]

 //search files for certain terms (ANDed)
tracker-search [OPTION...] search terms ... -
  -l, --limit=limit         limit the number of results showed
  -s, --service=service     search from a specific service

 //perform an rdf query and return results with specified metadata fields
tracker-query [OPTION...] RDFQueryFile [MetaDataField...] ...
  -s, --service=service             search from a specific service
  -t, --search-term=search-term     adds a fulltext search filter
  -k, --keyword=keyword             adds a keyword filter
*/
/**
@brief find and list matching items in output pane
This is called from a callback, BGL closed
@param rt pointer to data for dialog

@return
*/
static void _e2p_track_list_results (E2_TrackDlgData *rt)
{
	GtkWidget *entry = GTK_BIN (rt->query_combo)->child;
	const gchar *find = gtk_entry_get_text (GTK_ENTRY (entry));
	gchar *command;
	gint result;

	if ((GTK_TOGGLE_BUTTON (rt->type_radio))->active)	//search for service
	{
		gint type = gtk_combo_box_get_active (GTK_COMBO_BOX (rt->service_combo));
		if (type == -1)
			return;
		if (*find == '\0'
			|| g_str_equal (find, "*")
			|| g_str_equal (find, _("all")))
			command = g_strdup_printf ("tracker-files -s %s", cmd_str[service_index]);
		else
			command = g_strdup_printf ("tracker-search -s %s %s",
				cmd_str[service_index], find);
	}
	else if ((GTK_TOGGLE_BUTTON (rt->type_radio2))->active)	//search for mimetype
	{
		if (*find == '\0')
		{
			e2_output_print_end (&app.tab, FALSE);
			return;
		}
		command = g_strdup_printf ("tracker-files -m %s", find);
	}
	else
	{
		if (*find == '\0')
		{
			e2_output_print_end (&app.tab, FALSE);
			return;
		}
		command = g_strdup_printf ("tracker-query %s", find);
	}

#ifdef E2_COMMANDQ
	result = e2_command_run (command, E2_COMMAND_RANGE_DEFAULT, TRUE);
#else
	result = e2_command_run (command, E2_COMMAND_RANGE_DEFAULT);
#endif
	if (result == 0)
		e2_output_print_end (&app.tab, FALSE);

	g_free (command);
}
/**
@brief callback for dialog's "response" signal

@param dialog the dialog where the response was triggered
@param response the response for the clicked button
@param rt pointer to data for dialog

@return
*/
static void _e2p_track_response_cb (GtkDialog *dialog, gint response,
	E2_TrackDlgData *rt)
{
	switch (response)
	{
		case E2_RESPONSE_USER1:	//show help on using tracker
			e2_utils_show_help ("tracker plugin"); //no translation unless help doc is translated
			gtk_widget_grab_focus (GTK_BIN (rt->query_combo)->child);
			break;
		case E2_RESPONSE_USER2:	//clear query entry
		{
			GtkWidget *entry = GTK_BIN (rt->query_combo)->child;
			gtk_entry_set_text (GTK_ENTRY (entry), "");
			gtk_widget_grab_focus (entry);
		}
			break;
		case E2_RESPONSE_FIND:
			//in case the user aborts during the search, update history stuff now
			service_index = gtk_combo_box_get_active (GTK_COMBO_BOX (rt->service_combo));
			GtkWidget *entry = GTK_BIN (rt->query_combo)->child;
			const gchar *find = gtk_entry_get_text (GTK_ENTRY (entry));
			if (*find != '\0')
				e2_list_update_history (find, &query_history, NULL, 30, FALSE);
			_e2p_track_list_results (rt);
			break;
		default:
			gtk_widget_destroy (rt->dialog);
			DEALLOCATE (E2_TrackDlgData, rt);
			break;
	}
}
/**
@brief handle activation (<Return> keypresses) in the query entry

@param entry UNUSED the entry widget for the combo box
@param rt pointer to dialog data struct
@return
*/
static void _e2p_track_query_activated_cb (GtkEntry *entry, E2_TrackDlgData *rt)
{
	_e2p_track_response_cb (GTK_DIALOG (rt->dialog), E2_RESPONSE_FIND, rt);
}
/**
@brief create and run dialog

@param from the button, menu item etc which was activated
@param art action runtime data

@return TRUE if action completed successfully, else FALSE
*/
static gboolean _e2p_track (gpointer from, E2_ActionRuntime *art)
{
	E2_TrackDlgData *rt = ALLOCATE (E2_TrackDlgData);
	CHECKALLOCATEDWARN (rt, return FALSE; );

	rt->dialog = e2_dialog_create (NULL, NULL, _("tracker query"),
		_e2p_track_response_cb, rt);

	GtkWidget *hbox = e2_widget_add_box ((GTK_DIALOG (rt->dialog))->vbox, TRUE,
		E2_PADDING, FALSE, FALSE, E2_PADDING_SMALL);
//	rt->type_radio = e2_button_add_radio (hbox, NULL, NULL, FALSE, 0, NULL, NULL);
//	e2_widget_add_label (hbox, _("Search for"), 0.0, 0.5, FALSE, 0);
	rt->type_radio = e2_button_add_radio (hbox, _("_Search for"), NULL,
		TRUE, FALSE, 0, NULL, NULL);

	rt->service_combo = e2_combobox_add (hbox, FALSE, E2_PADDING,
		NULL, NULL, NULL, E2_COMBOBOX_MENU_STYLE);
	guint i;
	for (i = 0; i < MAXSERVICES; i++)
		gtk_combo_box_append_text (GTK_COMBO_BOX (rt->service_combo),
			gettext (object_names[i]));
	gtk_combo_box_set_active (GTK_COMBO_BOX (rt->service_combo), service_index);
//USELESS? gtk_widget_set_tooltip_text (
//	rt->service_combo, _("Select information service"));
	e2_widget_add_label (hbox, _("which match:"), 0.0, 0.5, FALSE, 0);
	gtk_widget_show (hbox);

	hbox = e2_widget_add_box ((GTK_DIALOG (rt->dialog))->vbox, TRUE,
		E2_PADDING, FALSE, FALSE, E2_PADDING_SMALL);
	GSList *group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (rt->type_radio));
//	e2_button_add_radio (hbox, NULL, group, FALSE, 0, NULL, NULL);
//	e2_widget_add_label (hbox, _("Search for items whose _mimetype is any of:"), 0.0, 0.5, FALSE, 0);
	rt->type_radio2 = e2_button_add_radio (hbox,
		_("Search for items whose _mimetype is any of:"), group,
		FALSE, FALSE, 0, NULL, NULL);
	gtk_widget_show (hbox);

	hbox = e2_widget_add_box ((GTK_DIALOG (rt->dialog))->vbox, TRUE,
		E2_PADDING, FALSE, FALSE, E2_PADDING_SMALL);
//	group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (rt->type_radio));
	e2_button_add_radio (hbox, _("Search for items using this rdf query:"), group,
		FALSE, FALSE, 0, NULL, NULL);
	e2_button_add (hbox, FALSE, E2_PADDING_LARGE, _("_Select"), GTK_STOCK_OPEN,
			_("Open query-selection dialog"), _e2p_track_choose_rdf_cb, rt);
	gtk_widget_show (hbox);

	rt->query_combo = e2_combobox_add ((GTK_DIALOG (rt->dialog))->vbox, FALSE,
		E2_PADDING, _e2p_track_query_activated_cb, rt, &query_history,
		E2_COMBOBOX_HAS_ENTRY | E2_COMBOBOX_FOCUS_ON_CHANGE | E2_COMBOBOX_CYCLE_HISTORY);

	gtk_widget_show (rt->query_combo);

	GtkWidget *btn = e2_dialog_add_undefined_button (rt->dialog, GTK_STOCK_HELP,
		_("_Help"), E2_RESPONSE_USER1);
#ifdef USE_GTK2_12
	gtk_widget_set_tooltip_text (
#else
	e2_widget_set_tooltip (NULL,
#endif
		btn, _("Get help on constructing queries"));

	btn = e2_dialog_add_undefined_button (rt->dialog, GTK_STOCK_CLEAR,
		_("C_lear"), E2_RESPONSE_USER2);
#ifdef USE_GTK2_12
	gtk_widget_set_tooltip_text (
#else
	e2_widget_set_tooltip (NULL,
#endif
		btn, _("Clear the current query"));

	btn = e2_dialog_add_undefined_button (rt->dialog, GTK_STOCK_FIND,
		_("_Find"), E2_RESPONSE_FIND);
#ifdef USE_GTK2_12
	gtk_widget_set_tooltip_text (
#else
	e2_widget_set_tooltip (NULL,
#endif
		btn, _("Initiate a query using currently-specified criteria"));

	e2_dialog_set_negative_response (rt->dialog, GTK_RESPONSE_CLOSE);
	e2_dialog_show (rt->dialog, app.main_window, 0, &E2_BUTTON_CLOSE, NULL);
	GtkWidget *entry = GTK_BIN (rt->query_combo)->child;
	gtk_widget_grab_focus (entry);

	return TRUE;
}

//aname must be confined to this module
static gchar *aname;
/**
@brief plugin initialization function, called by main program

@param p ptr to plugin data struct

@return TRUE if the initialization succeeds, else FALSE
*/
gboolean init_plugin (Plugin *p)
{
#define ANAME "track"
	aname = _("track");

	p->signature = ANAME VERSION;
	p->menu_name = _("_Track..");
	p->description = _("Find items in the tracker database");
	p->icon = "plugin_"ANAME"_"E2IP".png";  //use icon file pathname if appropriate

	if (p->action == NULL)
	{
		//no need to free this
		gchar *action_name = g_strconcat (_A(1),".",aname,NULL);
		p->action = e2_plugins_action_register
			(action_name, E2_ACTION_TYPE_ITEM, _e2p_track, NULL, FALSE, 0, NULL);

		e2_cache_int_register ("track-plugin-type", &service_index, 0);
		e2_cache_list_register ("track-plugin-history", &query_history);

		return TRUE;
	}
	return FALSE;
}
/**
@brief cleanup transient things for this plugin

@param p pointer to data struct for the plugin

@return TRUE if all cleanups were completed
*/
gboolean clean_plugin (Plugin *p)
{
	gchar *action_name = g_strconcat (_A(1),".",aname,NULL);
	gboolean ret = e2_plugins_action_unregister (action_name);
	g_free (action_name);
	if (ret)
	{
		//backup the cache data
		e2_cache_unregister ("track-plugin-type");
		e2_cache_unregister ("track-plugin-history");
		//cleanup ?
	}
	return ret;
}
