/* $Id: e2_action_option.c 469 2007-07-06 22:58:30Z tpgww $

Copyright (C) 2004-2007 tooar <tooar@gmx.net>

This file is part of emelfm2.
emelfm2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelfm2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "emelfm2.h"
//#include <unistd.h>
#include "e2_action_option.h"

/**
@brief set the value of a non-tree config option
requires arg string in config-file format like "option-name=option_value"
@param from the button, menu item etc which was activated
@param art action runtime data

@return TRUE
*/
static gboolean _e2_action_option_set (gpointer from, E2_ActionRuntime *art)
{
	gchar *tmp[2] = { (gchar *)art->data, NULL };
	e2_option_read_array (tmp);
	return TRUE;
}

void e2_action_option_actions_register ()
{
	gchar *action_name = g_strconcat (_A(8),".",_A(77),NULL);  //_(option.set")
	e2_action_register_simple (action_name, E2_ACTION_TYPE_ITEM,
		_e2_action_option_set, NULL, FALSE);
}
