/* $Id: e2_password_dialog.c 482 2007-07-10 06:48:54Z tpgww $

Copyright (C) 2007 tooar <tooar@gmx.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

/**
@file src/dialogs/e2_password_dialog.c
@brief functions to setup and run a generic password-input dialog
*/

#include "e2_password_dialog.h"
//#include <pthread.h>
#define E2_HINT_MSEC 600

//static GStaticRecMutex pw_mutex;
//OR
//static pthread_mutex_t pw_mutex = PTHREAD_RECURSIVE_MUTEX_INITIALIZER_NP;
//static assuming last-closed window sets size for next one in this session only
static gint window_width = -1;
#ifdef USE_GTK2_10
static guint pwrefcount = 0;
static guint hinttime;
static gboolean hinted = FALSE;		//TRUE when the last char in either used entry is displayed as plaintext
#endif
static gboolean plaintext = FALSE;	//TRUE when all entered chars are echoed as is
static gboolean hidden = FALSE;		//TRUE when no entered char is to be echoed

/**
@brief toggle temporary display of last-entered character in the password
This is a key-press callback for both password-entry entry widgets
@param entry pointer to the widget that received the keypress
@param event event data struct
@param rt pointer to data struct for the dialog

@return TRUE if the key was <Ctrl>t or <Ctrl>h
*/
static gboolean _e2_pwdlg_key_press_cb (GtkWidget *entry, GdkEventKey *event,
	E2_PWDialogRuntime *rt)
{
	if ((event->state & GDK_CONTROL_MASK) != 0)
	{
		if (event->keyval == GDK_p || event->keyval == GDK_P)
		{
			rt->plain = !rt->plain;
			gtk_entry_set_visibility (GTK_ENTRY (rt->pwentry1), rt->plain);
			gtk_entry_set_visibility (GTK_ENTRY (rt->pwentry2), rt->plain);
			return TRUE;
		}
		else if (event->keyval == GDK_h || event->keyval == GDK_H)
		{
			if (rt->plain)
			{
				rt->plain = FALSE;
				gtk_entry_set_visibility (GTK_ENTRY (rt->pwentry1), FALSE);
				gtk_entry_set_visibility (GTK_ENTRY (rt->pwentry2), FALSE);
			}
			rt->hide = !rt->hide;
			gunichar ch = (rt->hide) ? (gunichar) 0 : (gunichar) '*';
			gtk_entry_set_invisible_char (GTK_ENTRY (rt->pwentry1), ch);
			gtk_entry_set_invisible_char (GTK_ENTRY (rt->pwentry2), ch);
			return TRUE;
		}
#ifdef USE_GTK2_10
		else if (event->keyval == GDK_t || event->keyval == GDK_T)
		{
			if (rt->plain)
			{
				rt->plain = FALSE;
				gtk_entry_set_visibility (GTK_ENTRY (rt->pwentry1), FALSE);
				gtk_entry_set_visibility (GTK_ENTRY (rt->pwentry2), FALSE);
			}
			rt->hint = !rt->hint;
			guint msec = (rt->hint) ? E2_HINT_MSEC : 0;
			GtkSettings *s = gtk_settings_get_default ();
			g_object_set (G_OBJECT (s), "gtk-entry-password-hint-timeout", msec, NULL);
			return TRUE;
		}
#endif
	}
	return FALSE;
}
/**
@brief handle button click, window-close etc for directory-tree dialog
This is the callback for response signals emitted from @a dialog
@param dialog UNUSED the dialog where the response was generated
@param response the response returned from the dialog
@param rt pointer to data struct for the dialog

@return
*/
static void _e2_passdlg_response_cb (GtkDialog *dialog, gint response,
	E2_PWDialogRuntime *rt)
{
	rt->result = CANCEL;	//default result
	switch (response)
	{
		case E2_RESPONSE_YESTOALL:
		case GTK_RESPONSE_OK:
		{
			const gchar *pw1;
			pw1 = gtk_entry_get_text (GTK_ENTRY (rt->pwentry1));
			if (*pw1 == '\0')
			{
				DialogButtons choice =
					e2_dialog_warning (_("No password provided"));
				if (choice == OK)
				{
					gtk_widget_grab_focus (rt->pwentry1);
					break;	//keep the P/W dialog alive
				}
			}
			if (rt->confirm)
			{
				const gchar *pw2;
				pw2 = gtk_entry_get_text (GTK_ENTRY (rt->pwentry2));
				if (g_str_equal (pw1, pw2))
				{
					rt->result = (response == GTK_RESPONSE_OK) ? OK : YES_TO_ALL;
					*rt->passwd = g_strdup (pw1);
				}
				else
				{
					DialogButtons choice =
					e2_dialog_warning (_("Entered passwords are different"));
					if (choice == OK)
					{
						gtk_widget_grab_focus (rt->pwentry1);
						break;	//keep the P/W dialog alive
					}
//this is default	else
//						response = GTK_RESPONSE_CANCEL;
				}
			}
			else
			{
				rt->result = (response == GTK_RESPONSE_OK) ? OK : YES_TO_ALL;
				*rt->passwd = g_strdup (pw1);
			}
		}
		default:
			if (response == E2_RESPONSE_NOTOALL)
				rt->result = NO_TO_ALL;

		//	g_static_rec_mutex_lock (&pw_mutex);
		//	pthread_mutex_lock (&pw_mutex);
#ifdef USE_GTK2_10
			if (--pwrefcount == 0)
			{
				GtkSettings *defs = gtk_settings_get_default ();
				g_object_set (G_OBJECT (defs), "gtk-entry-password-hint-timeout",
					hinttime, NULL);
			}
			hinted = rt->hint;
#endif
			if (rt->destroy)
			{
				hidden = rt->hide;
				plaintext = rt->plain;
				window_width = rt->dialog->allocation.width;
		//	g_static_rec_mutex_unlock (&pw_mutex);
		//	pthread_mutex_unlock (&pw_mutex);
//			if (rt->destroy)
//			{
				gtk_widget_destroy (rt->dialog);
				DEALLOCATE (E2_PWDialogRuntime, rt);
			}
			gtk_main_quit ();
			break;
	}
}
/**
@brief handle activation (<Return> keypresses) in the password entry

@param entry the entry widget where the activation happened
@param rt pointer to dialog data struct

@return
*/
static void _e2_pwdlg_activated_cb (GtkEntry *entry, E2_PWDialogRuntime *rt)
{
	if (rt->confirm)
	{
		const gchar *pw1 = gtk_entry_get_text (GTK_ENTRY (rt->pwentry1));
		const gchar *pw2 = gtk_entry_get_text (GTK_ENTRY (rt->pwentry2));
		if (entry == GTK_ENTRY (rt->pwentry1))
		{
			if (*pw1 != '\0')
			{
				if (*pw2 == '\0')
					gtk_widget_grab_focus (rt->pwentry2);
				else
					_e2_passdlg_response_cb (GTK_DIALOG (rt->dialog), GTK_RESPONSE_OK, rt);
			}
		}
		else	//we arrived from the confirmation entry
		{
			if (*pw2 != '\0')
			{
				if (*pw1 == '\0')
					gtk_widget_grab_focus (rt->pwentry1);
				else
					_e2_passdlg_response_cb (GTK_DIALOG (rt->dialog), GTK_RESPONSE_OK, rt);
			}
		}
	}
	else
		_e2_passdlg_response_cb (GTK_DIALOG (rt->dialog), GTK_RESPONSE_OK, rt);
}

/**
@brief create and show dialog to get user input with obfuscated text display
@a pw may hold a pointer to a suggested value.  If the user so chooses, @a pw
will be set to a pointer to a newly-allocated inputted string, without affecting
any existing string there
This assumes that BGL is open/off
@param title custom window title string, or NULL for default
@param stock name of stock item or icon-file path, or NULL for nothing
@param prompt custom prompt string, or NULL for default
@param confirm TRUE to get 2 matched copies of entered password
@param extras enumerator for showing extra (stop, yes-all) dialog buttons
@param pw store for password pointer
@param destroy TRUE to cleanup the dialog and data after the user's choice

@return button code according to user's choice
*/
E2_PWDialogRuntime *e2_password_dialog_setup (gchar *title, gchar *stock, gchar *prompt,
	gboolean confirm, OW_ButtonFlags extras, gchar **pw, gboolean destroy)
{
	//FIXME handle multi - yes-all, stop buttons
	gchar *realtitle, *realprompt, *realpw;

	printd (DEBUG, "create password dialog");
	E2_PWDialogRuntime *rt = ALLOCATE0 (E2_PWDialogRuntime);
	CHECKALLOCATEDWARN (rt, return NULL;)

	realtitle = (title != NULL) ? title : _("password");
	realprompt = (prompt != NULL) ? prompt : _("Enter password:");
	rt->dialog = e2_dialog_create (stock, realprompt, realtitle,
		_e2_passdlg_response_cb, rt);
	rt->destroy = destroy;

	realpw = (*pw != NULL && **pw != '\0') ? *pw : NULL;
	//this reduces bad latency when entering passwords ? CHECKME blockage ?
	gdk_threads_enter ();
	rt->pwentry1 = e2_widget_add_entry (GTK_DIALOG (rt->dialog)->vbox, realpw,
		TRUE, (realpw != NULL));
	gdk_threads_leave ();
//	g_static_rec_mutex_lock (&pw_mutex);
//	pthread_mutex_lock (&pw_mutex);
	rt->plain = plaintext;
#ifdef USE_GTK2_10
	rt->hint = hinted;
#endif
	rt->hide = hidden;
	if (!rt->plain)
	{
		gtk_entry_set_visibility (GTK_ENTRY (rt->pwentry1), FALSE);
		if (rt->hide)
			gtk_entry_set_invisible_char (GTK_ENTRY (rt->pwentry1), 0);
#ifdef USE_GTK2_10
		//setup to handle password hinting
		GtkSettings *defs = gtk_settings_get_default ();
		//log original value
		guint msec;
		g_object_get (G_OBJECT (defs), "gtk-entry-password-hint-timeout", &msec, NULL);
//		g_static_rec_mutex_lock (&pw_mutex);
//		pthread_mutex_lock (&pw_mutex);
		if (++pwrefcount == 1)
			hinttime = msec;
//		g_static_rec_mutex_unlock (&pw_mutex);
//		pthread_mutex_unlock (&pw_mutex);
		msec =  (rt->hint) ? E2_HINT_MSEC : 0;
		g_object_set (G_OBJECT (defs), "gtk-entry-password-hint-timeout", msec, NULL);
#endif
	}
	//handle Return-key presses when the entry is focused
	g_signal_connect (G_OBJECT (rt->pwentry1), "activate",
		G_CALLBACK (_e2_pwdlg_activated_cb), rt);
	//handle hint-key or hide-key presses
	g_signal_connect (G_OBJECT (rt->pwentry1), "key-press-event",
		G_CALLBACK (_e2_pwdlg_key_press_cb), rt);

	rt->confirm = confirm;
	if (confirm)
	{
		e2_widget_add_label (GTK_DIALOG (rt->dialog)->vbox, _("Confirm password:"),
			0.5, 0.0, FALSE, E2_PADDING);
		gdk_threads_enter ();
		rt->pwentry2 = e2_widget_add_entry (GTK_DIALOG (rt->dialog)->vbox, NULL, TRUE,
			FALSE);
		gdk_threads_leave ();
		if (!rt->plain)
		{
			gtk_entry_set_visibility (GTK_ENTRY (rt->pwentry2), FALSE);
			if (rt->hide)
				gtk_entry_set_invisible_char (GTK_ENTRY (rt->pwentry2), 0);
		}
		//handle Return-key presses when the entry is focused
		g_signal_connect (G_OBJECT (rt->pwentry2), "activate",
			G_CALLBACK (_e2_pwdlg_activated_cb), rt);
		//handle hint-key or hide-key presses
		g_signal_connect (G_OBJECT (rt->pwentry2), "key-press-event",
			G_CALLBACK (_e2_pwdlg_key_press_cb), rt);
	}
	rt->passwd = pw;
	rt->result = CANCEL;

	//relate initial size to last-used, or if first, to filepanes size
//	g_static_rec_mutex_lock (&pw_mutex);
//	pthread_mutex_lock (&pw_mutex);
/*	if (window_width == -1)
		window_width = MIN(400, app.window.panes_paned->allocation.width*2/3);
	gtk_window_resize (GTK_WINDOW(rt->dialog), window_width, -1);
*/
//	g_static_rec_mutex_unlock (&pw_mutex);
//	pthread_mutex_unlock (&pw_mutex);
	if (extras)
	{
		if (extras & NOALL)
		{
			E2_BUTTON_YESTOALL.showflags |= E2_BTN_GREY;
			e2_dialog_set_negative_response (rt->dialog, E2_RESPONSE_NOTOALL);
		}
		else if (!(extras & BOTHALL))
		{
			E2_BUTTON_YESTOALL.showflags |= E2_BTN_GREY;
			E2_BUTTON_NOTOALL.showflags |= E2_BTN_GREY;
		}
		e2_dialog_add_defined_button (rt->dialog, &E2_BUTTON_NOTOALL);
		e2_dialog_add_defined_button (rt->dialog, &E2_BUTTON_YESTOALL);
	}
//	E2_BUTTON_CANCEL.showflags |= E2_BTN_DEFAULT;
	E2_BUTTON_OK.showflags &= ~E2_BTN_DEFAULT;

	e2_dialog_add_defined_button (rt->dialog, &E2_BUTTON_CANCEL);
	e2_dialog_add_defined_button (rt->dialog, &E2_BUTTON_OK);

	printd (DEBUG, "create password dialog - completed");
	return rt;
}

/*
	//setup mutex to protect threaded access to static variables
	g_static_rec_mutex_init (&pw_mutex);
*/

/* *
@brief create and show dialog to get user input with obfuscated text display

@param threaded TRUE when BGL is open/off upon arrival here

@return button code according to user's choice
*/
/* UNUSED
DialogButtons e2_password_dialog_run (gboolean threaded)
{
	gchar *pw = NULL;
	if (!threaded)
		gdk_threads_leave ();
	E2_PWDialogRuntime *rt = e2_password_dialog_setup
		(NULL, GTK_STOCK_DIALOG_QUESTION, NULL, TRUE, NONE, &pw, TRUE);
	if (!threaded)
		gdk_threads_enter ();
	if (rt != NULL)
	{
		e2_dialog_setup (rt->dialog, app.main_window);
//		pthread_mutex_lock (&pw_mutex);
/ *		if (window_width == -1)
			window_width = MIN(400, app.window.panes_paned->allocation.width*2/3);
		gtk_window_resize (GTK_WINDOW(rt->dialog), window_width, -1);
* /
//		g_static_rec_mutex_unlock (&pw_mutex);
//		pthread_mutex_unlock (&pw_mutex);
		if (threaded)
			gdk_threads_enter ();
		e2_dialog_run (rt->dialog, app.main_window, 0);
		gtk_widget_grab_focus (rt->pwentry1);
		gtk_main ();
		if (threaded)
			gdk_threads_leave ();

		if (rt->result == OK || rt->result == YES_TO_ALL)
		{
			//use pw
		}
		if (pw != NULL)
			g_free (pw);
	}
	return rt->result;
}
*/
