/* $Id: e2_tree.h 469 2007-07-06 22:58:30Z tpgww $

Copyright (C) 2004-2007 tooar <tooar@gmx.net>

This file is part of emelfm2.
emelfm2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelfm2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef E2_TREE_H
#define E2_TREE_H

#include "emelfm2.h"

gboolean e2_tree_find_iter_from_str (GtkTreeModel *model, gint column,
	const gchar *search, GtkTreeIter *iter, gboolean with_children);
gboolean e2_tree_find_iter_from_str_simple (GtkTreeModel *model, gint column,
	const gchar *search, GtkTreeIter *iter, gboolean with_children);
gboolean e2_tree_find_iter_from_str_same (GtkTreeModel *model, gint column,
	const gchar *search, GtkTreeIter *iter);
gboolean e2_tree_find_lowest_iter_from_str (GtkTreeModel *model,
	gint column, const gchar *search, GtkTreeIter *iter);
#ifdef E2_TREEINCREMENT
void e2_tree_create_lowest_iter_from_str (GtkTreeModel *model,
	gint column, gchar *name, GtkTreeIter *iter);
#endif
//gchar *e2_tree_get_last_string (GtkTreeModel *model, gint column);
//guint e2_tree_store_count (GtkTreeModel *model);
GtkTreeRowReference *e2_tree_iter_to_ref (GtkTreeStore *store, GtkTreeIter *iter);
gboolean e2_tree_ref_to_iter (GtkTreeStore *store, GtkTreeRowReference *ref,
	GtkTreeIter *iter);
gboolean e2_tree_expand_all_cb (GtkWidget *widget, GtkTreeView *treeview);
gboolean e2_tree_collapse_all_cb (GtkWidget *widget, GtkTreeView *treeview);
gboolean e2_tree_iter_previous (GtkTreeModel *model, GtkTreeIter *iter);
GList *e2_tree_copy (GtkTreeView *treeview);
void e2_tree_paste (GList *rowscopied, GtkTreeView *treeview);
void e2_tree_delete (GtkTreeView *treeview);
gchar *e2_tree_row_to_string (GtkTreeModel *model, GtkTreeIter *iter,
	gint columns, gint level);

#endif //ndef E2_TREE_H
