#!/usr/bin/python

from distutils.core import setup, Extension
import glob, os.path
import sys

for arg in sys.argv:
    if arg == 'install': 
        print 'Hello.\nYou are trying to do a system-wide install of emesene '\
              'using this script, which is a very bad thing to do.\n'\
              'Seriously, you do NOT want to do this, since it can break '\
              'other python apps, and emesene too!\n'\
              'Follow my advice: just run the \"emesene\" script that is '\
              'in this very same directory and you\'re done. emesene is running '\
              'and your system is safe. It\'s a win-win, don\'t you think?\n'\
              'Thanks for trying emesene.'
        quit()
        
# From apport's setup.py
mo_files = []
for filepath in glob.glob("po/*/LC_MESSAGES/*.mo"):
    lang = filepath[len("po/"):]
    targetpath = os.path.dirname(os.path.join("share/locale",lang))
    mo_files.append((targetpath, [filepath]))

libmimic_module = Extension('libmimic',
                    sources = ['libmimic/' + file for file in ['bitstring.c', 
                     'colorspace.c', 'deblock.c', 'decode.c', 'encode.c',
                     'fdct_quant.c', 'idct_dequant.c', 'mimic.c', 'vlc_common.c', 
                     'vlc_decode.c', 'vlc_encode.c', 'py_libmimic.c']])


setup(name         = 'emesene',
      version      = '1.5',
      description  = 'MSN messenger client',
      author       = 'Luis Mariano Guerra, dx, C10uD',
      author_email = 'luismarianoguerra@gmail.com',
      url          = 'http://www.emesene.org/',
      license      = 'GNU GPL 2',
      requires     = ['gtk'],
      platforms    = ['any'],
      packages     = ['', 'abstract', 'emesenelib', 'emesenelib.p2p', 
                      'emesenelib.soap', 'plugins_base', 'plugins_base.currentSong'],
      scripts      = ['emesene'],
      package_data = {'': ['conversation_themes/*/*', 'smilies/*/*',
                           'sound_themes/*/*', 'themes/*/*', 'hotmlog.htm']},
      data_files   = [('share/pixmaps', ['misc/emesene.png']),
                      ('share/icons/hicolor/scalable/apps', ['misc/emesene.svg']),
                      ('share/man/man1', ['misc/emesene.1']),
                      ('share/applications', ['misc/emesene.desktop'])] + mo_files,
      ext_modules = [libmimic_module]
      )
