C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      INTEGER FUNCTION GASETUP( KSEC2, KSEC4)
C
C---->
C**** GASETUP
C
C     Purpose
C     -------
C
C     Setup GRIB sections 2 and 4 for the new interpolation product.
C
C     Added because of merging with grib_api
C
C     Interface
C     ---------
C
C     IRET GASETUP( KSEC2, KSEC4)
C
C     Input
C     -----
C
C     KSEC2   - Section 2 values (for GRIBEX)
C     KSEC3   - Section 4 values (for GRIBEX)
C
C     Output
C     ------
C
C     KSEC2   - Modified section 2 values (for GRIBEX)
C     KSEC3   - Modified section 4 values (for GRIBEX)
C
C     Method
C     ------
C
C     Use common block values and existing values from the original GRIB
C     product used for interpolation.
C
C
C     Externals
C     ---------
C
C     INTLOG   - Logs messages.
C
C
C     Author
C     ------
C
C     J.D.Chambers     ECMWF     Aug 1994
C
C----<
C
      IMPLICIT NONE
C
#include "parim.h"
#include "nifld.common"
#include "nofld.common"
C
C     Parameter(s)
C
      INTEGER JPROUTINE
      PARAMETER ( JPROUTINE = 19100 )
C
C     Function arguments
C
      INTEGER KSEC2, KSEC4, REPRES, NOPAAPI
      DIMENSION KSEC2(*), KSEC4(*)
C
C     Local variables
C
      LOGICAL LIROTAT, LOROTAT
      INTEGER ILOOP, ITEMP
C
C***********************************************************************
C     Section 1.   Startup.
C***********************************************************************
C
 100  CONTINUE
C
      GASETUP = 0
C
C     Check a recognized data representation type is being processed
        
		 REPRES = NOREPR
C
      IF ( (NOREPR .NE.JPREGULAR  ) .AND.
     X     (NOREPR .NE.JPREGROT   ) .AND.
     X     (NOREPR .NE.JPGAUSSIAN ) .AND.
     X     (NOREPR .NE.JPFGGROT   ) .AND.
     X     (NOREPR .NE.JPQUASI    ) .AND.
     X     (NOREPR .NE.JPQGGROT   ) .AND.
     X     (NOREPR .NE.JPSPHROT   ) .AND.
     X     (NOREPR .NE.JPSPHERE   ) ) GOTO 910
C
C     Set flags if input is rotated or if a rotation angle has been given
C
      LIROTAT = (NIREPR.EQ.JPSPHROT).OR.
     X          (NIREPR.EQ.JPREGROT).OR.
     X          (NIREPR.EQ.JPFGGROT).OR.
     X          (NIREPR.EQ.JPQGGROT)
C
      LOROTAT = ((NOROTA(1).NE.-9000000).AND.(NOROTA(1).NE.0)).OR.
     X          (NOROTA(2).NE.0)
C
C***********************************************************************
C     Section 2.   Setup output product section 2.
C***********************************************************************
C
 300  CONTINUE
C
C     Data representation type
C
C     Adjust output representation type if field is rotated
C
      IF( LIROTAT.OR.LOROTAT ) THEN
        KSEC2(1) = NOREPR
        IF(NOREPR.EQ.JPREGULAR )  KSEC2(1) = JPREGROT
        IF(NOREPR.EQ.JPSPHERE )   KSEC2(1) = JPSPHROT
        IF(NOREPR.EQ.JPQUASI )    KSEC2(1) = JPFGGROT
        IF(NOREPR.EQ.JPQGGROT )   KSEC2(1) = JPFGGROT
        IF(NOREPR.EQ.JPGAUSSIAN ) KSEC2(1) = JPFGGROT
C
      ELSE
C
        IF( (NOREPR.EQ.JPQUASI).OR.(NOREPR.EQ.JPQGGROT) ) THEN
          KSEC2(1) = JPGAUSSIAN
        ELSE
          KSEC2(1) = NOREPR
        ENDIF
      ENDIF
C
C***********************************************************************
C     Section 3.1. Setup section 2 for lat/long, equidistant
C                  cylindrical or plate carre grids.
C***********************************************************************
C
 310  CONTINUE
C
      IF ( (NOREPR.EQ.JPREGULAR).OR.(NOREPR.EQ.JPREGROT) ) THEN
C
C       For south to north grids, only global area allowed (eg KWBC SST)
C
        IF( KSEC2(4).LT.KSEC2(7) ) THEN
          IF((NOAAPI(1).NE.(-NOAAPI(3))).AND.(NOAAPI(3).NE.JP90)) THEN
            CALL INTLOG(JP_ERROR,
     X        'GASETUP: Subareas not allowed interpolating',JPQUIET)
            CALL INTLOG(JP_ERROR,
     X        'GASETUP: grids running from south to north',JPQUIET)
            GASETUP = JPROUTINE + 2
            GOTO 900
          ENDIF
        ENDIF
C
C       Number of points along a parallel
C
        KSEC2(2) = NOWE
C
C       Number of points along a meridian
C
        KSEC2(3) = NONS
C
C       Latitude and longitude of first grid point
C
        IF( NOAAPI(1).GE.0 ) THEN
          KSEC2(4) = (NOAAPI(1)+(JPMICRO/2)) / JPMICRO
        ELSE
          KSEC2(4) = (NOAAPI(1)-(JPMICRO/2)) / JPMICRO
        ENDIF
        IF( NOAAPI(2).GE.0 ) THEN
          KSEC2(5) = (NOAAPI(2)+(JPMICRO/2)) / JPMICRO
        ELSE
          KSEC2(5) = (NOAAPI(2)-(JPMICRO/2)) / JPMICRO
        ENDIF
C
C       Resolution flag, increments are given
C
        KSEC2(6) = 128
C
C       Latitude and longitude of last grid point
C
        IF( NOAAPI(3).GE.0 ) THEN
          KSEC2(7) = (NOAAPI(3)+(JPMICRO/2)) / JPMICRO
        ELSE
          KSEC2(7) = (NOAAPI(3)-(JPMICRO/2)) / JPMICRO
        ENDIF
        IF( NOAAPI(4).GE.0 ) THEN
          KSEC2(8) = (NOAAPI(4)+(JPMICRO/2)) / JPMICRO
        ELSE
          KSEC2(8) = (NOAAPI(4)-(JPMICRO/2)) / JPMICRO
        ENDIF
C
C       Flip latitudes if they run from south to north
C       Set scanning mode flags
C
        IF( KSEC2(4).LT.KSEC2(7) ) THEN
          IF( LNOGRID ) THEN
            ITEMP = KSEC2(7)
            KSEC2(7) = KSEC2(4)
            KSEC2(4) = ITEMP
            KSEC2(11) = 0
          ELSE
            KSEC2(11) = 64
          ENDIF
        ELSE
          KSEC2(11) = NOSCNM
        ENDIF
C
C       i and j  direction increments
C
        KSEC2(9)  = (NOGRID(1) + (JPMICRO/2)) / JPMICRO
        KSEC2(10) = (NOGRID(2) + (JPMICRO/2)) / JPMICRO
C
C       Following left same as for input product
C       - no.of vertical coordinate parameters,
C       - lat/long of southern pole of rotation
C       - lat/long of pole of stretching
C
C       If rotated, put in new lat/long of southern pole of rotation
C
        IF( LIROTAT.OR.LOROTAT ) THEN
          IF( NOROTA(1).GE.0 ) THEN
            KSEC2(13) = (NOROTA(1) + (JPMICRO/2)) / JPMICRO
          ELSE
            KSEC2(13) = (NOROTA(1) - (JPMICRO/2)) / JPMICRO
          ENDIF
          IF( NOROTA(2).GE.0 ) THEN
            KSEC2(14) = (NOROTA(2) + (JPMICRO/2)) / JPMICRO
          ELSE
            KSEC2(14) = (NOROTA(2) - (JPMICRO/2)) / JPMICRO
          ENDIF
        ENDIF
C
C       Regular grid flag
C
        KSEC2(17) = 0
C
C       Following left same as for input product
C       - earth flag
C       - components flag
C       - reserved fields
C
      ENDIF
C
C***********************************************************************
C     Section 3.2. Setup section 2 for gaussian grids.
C***********************************************************************
C
 320  CONTINUE
C
      IF ( (NOREPR.EQ.JPGAUSSIAN).OR.
     X     (NOREPR.EQ.JPFGGROT).OR.
     X     (NOREPR.EQ.JPQUASI).OR.
     X     (NOREPR.EQ.JPQGGROT) ) THEN
C
C       Number of points along a parallel
C
C       For a regular gaussian grid only
        IF( (NOREPR.EQ.JPGAUSSIAN).OR.(NOREPR.EQ.JPFGGROT) ) THEN
          KSEC2(2) = NOWE
        ELSE
          KSEC2(2) = 0
        ENDIF
C
C       Number of points along a meridian
C
        KSEC2(3) = NONS
C
C       Latitude and longitude of first grid point
C
        IF( NOAAPI(1).GE.0 ) THEN
          KSEC2(4) = (NOAAPI(1)+(JPMICRO/2)) / JPMICRO
        ELSE
          KSEC2(4) = (NOAAPI(1)-(JPMICRO/2)) / JPMICRO
        ENDIF
        IF( NOAAPI(2).GE.0 ) THEN
          KSEC2(5) = (NOAAPI(2)+(JPMICRO/2)) / JPMICRO
        ELSE
          KSEC2(5) = (NOAAPI(2)-(JPMICRO/2)) / JPMICRO
        ENDIF
C
C       Resolution flag
C
C       For a regular gaussian grid only, increments are given
C
        IF( (NOREPR.EQ.JPGAUSSIAN).OR.(NOREPR.EQ.JPFGGROT) ) THEN
          KSEC2(6) = 128
        ELSE
          KSEC2(6) = 0
        ENDIF
C
C       Latitude and longitude of last grid point
C
        IF( NOAAPI(3).GE.0 ) THEN
          KSEC2(7) = (NOAAPI(3)+(JPMICRO/2)) / JPMICRO
        ELSE
          KSEC2(7) = (NOAAPI(3)-(JPMICRO/2)) / JPMICRO
        ENDIF
        IF( NOAAPI(4).GE.0 ) THEN
          KSEC2(8) = (NOAAPI(4)+(JPMICRO/2)) / JPMICRO
        ELSE
          KSEC2(8) = (NOAAPI(4)-(JPMICRO/2)) / JPMICRO
        ENDIF
C
C       i direction increment
C
C       For a regular gaussian grid, only 
C
        IF( (NOREPR.EQ.JPGAUSSIAN).OR.(NOREPR.EQ.JPFGGROT) ) THEN
          KSEC2(9) = (((JP90)/NOGAUSS)+(JPMICRO/2)) / JPMICRO
        ELSE
          KSEC2(9) = 0
        ENDIF
C
C       Number of parallels between a pole and the Equator
C
        KSEC2(10) = NOGAUSS
C
C       Scanning mode flags
C
        KSEC2(11) = NOSCNM
C
C       Following left same as for input product
C       - no.of vertical coordinate parameters,
C       - lat/long of southern pole of rotation
C       - lat/long of pole of stretching
C
C       If rotated, put in new lat/long of southern pole of rotation
C
        IF( LIROTAT.OR.LOROTAT ) THEN
          IF( NOROTA(1).GE.0 ) THEN
            KSEC2(13) = (NOROTA(1) + (JPMICRO/2)) / JPMICRO
          ELSE
            KSEC2(13) = (NOROTA(1) - (JPMICRO/2)) / JPMICRO
          ENDIF
          IF( NOROTA(2).GE.0 ) THEN
            KSEC2(14) = (NOROTA(2) + (JPMICRO/2)) / JPMICRO
          ELSE
            KSEC2(14) = (NOROTA(2) - (JPMICRO/2)) / JPMICRO
          ENDIF
        ENDIF
C
C       Regular grid flag
C
        IF( (NOREPR.EQ.JPGAUSSIAN).OR.(NOREPR.EQ.JPFGGROT) ) THEN
          KSEC2(17) = 0
        ELSE
          KSEC2(17) = 1
        ENDIF
C
C       Following left same as for input product
C       - earth flag
C       - components flag
C       - reserved fields
C
C       For reduced grid, move in number of points along each parallel
C
          IF( (NOREPR.EQ.JPQUASI) .OR.
     X        (NOREPR.EQ.JPQGGROT) ) THEN
          DO 325 ILOOP = 1, KSEC2(3)
            KSEC2(22+ILOOP) = NOLPTS(ILOOP+NO1NS-1)
 325      CONTINUE
        ENDIF
C
      ENDIF
C
C***********************************************************************
C     Section 3.3. Setup section 2 for spherical harmonic coefficients.
C***********************************************************************
C
 330  CONTINUE
C
      IF ( (NOREPR.EQ.JPSPHERE).OR.(NOREPR.EQ.JPSPHROT) ) THEN
C
C       I, K, M pentagonal resolution parameters
C
        KSEC2(2) = NORESO
        KSEC2(3) = NORESO
        KSEC2(4) = NORESO
C
C       Representation type, associated legendre functions of the
C                            first kind
        KSEC2(5) = 1
C
C       Representation mode, complex packing
C
        KSEC2(6) = 2
C
C       Following left same as for input product
C       - reserved words 7-11
C       - no.of vertical coordinate parameters,
C       - lat/long of southern pole of rotation
C       - lat/long of pole of stretching
C       - reserved words 17-22
C
C       If rotated, put in new lat/long of southern pole of rotation
C
        IF( LIROTAT.OR.LOROTAT ) THEN
          IF( NOROTA(1).GE.0 ) THEN
            KSEC2(13) = (NOROTA(1) + (JPMICRO/2)) / JPMICRO
          ELSE
            KSEC2(13) = (NOROTA(1) - (JPMICRO/2)) / JPMICRO
          ENDIF
          IF( NOROTA(2).GE.0 ) THEN
            KSEC2(14) = (NOROTA(2) + (JPMICRO/2)) / JPMICRO
          ELSE
            KSEC2(14) = (NOROTA(2) - (JPMICRO/2)) / JPMICRO
          ENDIF
        ENDIF
      ENDIF
C
C***********************************************************************
C     Section 4.   Setup output product section 4.
C***********************************************************************
C
 400  CONTINUE
C
C     Number of values to be packed
C
      IF ( (NOREPR.EQ.JPSPHERE).OR.(NOREPR.EQ.JPSPHROT) ) THEN
        KSEC4(1) = (NORESO + 1) * (NORESO + 2)
      ELSE IF( (NOREPR.EQ.JPQUASI).OR.(NOREPR.EQ.JPQGGROT) ) THEN
        KSEC4(1) = NOPCNT
      ELSE
        KSEC4(1) = NOWE * NONS
      ENDIF
C
C     If all the values are missing, set the count of values negative
C
      IF(NOMISS.NE.0) THEN
        KSEC4(1) = -KSEC4(1)
      ENDIF
C
C     Number of bits used for each packed value
C
      KSEC4(2) = NOACC
C
C     Type of data, spherical harmonic = 128, grid point = 0
C
      IF ( (NOREPR.EQ.JPSPHERE).OR.(NOREPR.EQ.JPSPHROT) ) THEN
        KSEC4(3) = 128
      ELSE
        KSEC4(3) = 0
      ENDIF
C
C     Type of packing, spherical harmonic = complex
C
      IF ( (NOREPR.EQ.JPSPHERE).OR.(NOREPR.EQ.JPSPHROT) ) THEN
        KSEC4(4) = 64
      ELSE
        KSEC4(4) = 0
      ENDIF
C     Sinisa added jpeg packing just for merging with grib_api
        IF( NOHFUNC.EQ.'J' ) THEN
            KSEC4(4) = 77
        ENDIF

        IF( NOHFUNC.EQ.'S' ) THEN
            KSEC4(4) = 8
        ENDIF
C
C     Type of data = floating point
C
      KSEC4(5) = 0
C
C     Additional flags indicator = none
C
      KSEC4(6) = 0
C
C     Reserved word, set to 0
C
      KSEC4(7) = 0
C
C     Following set to simplest case
C     - no.of values indicator
C     - secondary bitmaps indicator
C     - values width indicator
C     - no.of bits for 2nd order values
C
      KSEC4(8)  = 0
      KSEC4(9)  = 0
      KSEC4(10) = 0
      KSEC4(11) = 0
C     
C     Reserved words, set to 0
C
      KSEC4(12) = 0
      KSEC4(13) = 0
      KSEC4(14) = 0
      KSEC4(15) = 0
C
C     If spherical harmonics, set following for complex packing
C
      IF ( (NOREPR.EQ.JPSPHERE).OR.(NOREPR.EQ.JPSPHROT) ) THEN
C
C       KSEC4(16), pointer to start of packed data, setup by packing
C       KSEC4(17), scaling factor P, unchanged from input
C       KSEC4(18), pentagonal resolution parameter J for packing of subset,
C                  unchanged from input
C       KSEC4(19), pentagonal resolution parameter K for packing of subset,
C                  unchanged from input
C       KSEC4(20), pentagonal resolution parameter M for packing of subset,
C                  unchanged from input
C
      ELSE
        DO 410 ILOOP = 16, 20
          KSEC4(ILOOP) = 0
 410    CONTINUE
      ENDIF
C
C     Words 21-33 reserved, set to zero.
C
      DO 420 ILOOP = 21, 33
        KSEC4(ILOOP) = 0
 420  CONTINUE
C
C***********************************************************************
C     Section 9.   Closedown
C***********************************************************************
C
 900  CONTINUE
C
      RETURN
C
C     Invalid data represntation type
C
 910  CONTINUE
      CALL INTLOG(JP_ERROR,
     X  'GASETUP: Data representation type not recognized: ',NOREPR)
      CALL INTLOG(JP_ERROR,
     X  'GASETUP: Only the following types are recognized:',JPQUIET)
      CALL INTLOG(JP_ERROR,'GASETUP: Lat/long grid = ', JPREGULAR)
      CALL INTLOG(JP_ERROR,'GASETUP: Lat/long (rotated) = ', JPREGROT)
      CALL INTLOG(JP_ERROR,'GASETUP: regular gaussian = ', JPGAUSSIAN)
      CALL INTLOG(JP_ERROR,'GASETUP: reg gauss rotated = ', JPFGGROT)
      CALL INTLOG(JP_ERROR,'GASETUP: reduced gaussian = ', JPQUASI)
      CALL INTLOG(JP_ERROR,'GASETUP: red gauss rotated = ', JPQUASI)
      CALL INTLOG(JP_ERROR,'GASETUP: spherical harmonic = ', JPSPHERE)
      CALL INTLOG(JP_ERROR,'GASETUP: spectral (rotated) = ', JPSPHROT)
C
      GASETUP = JPROUTINE + 1
      RETURN
      END
