/**
* Copyright 1981-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

#include <stdio.h>
#include <stdlib.h>

#include "fortint.h"

#if (defined hpR64) || (defined hpiaR64) || (defined CRAY) || (defined rs6000)
#define XALLOC malloc
#else
#define XALLOC malloc
#endif

#if (defined hpR64) || (defined hpiaR64)
JPointer jmalloc_( fortint * n)
{
int number = *n;
long * alloc;
JPointer falloc;

    alloc = (long *) XALLOC(number);
    falloc = (JPointer) alloc;
    return falloc;
}

JPointer jmalloc( fortint * n) {
  return jmalloc_(n);
}
#elif (defined __alpha)
JPointer jmalloc_( int * n)
{
static JPointer ret;
    ret = (JPointer) XALLOC(*n);
    return ret;
}

JPointer jmalloc( int * n) {
  return jmalloc_(n);
}
#elif (defined POINTER_64)
JPointer jmalloc_( int * n)
{
size_t number_of_bytes = (size_t) (*n);

    return (JPointer) XALLOC(*n);
}

JPointer jmalloc( int * n) {
  return jmalloc_(n);
}
#else
int * jmalloc_( int * n)
{
    return (int *) XALLOC(*n);
}

int * jmalloc( int * n) {
  return jmalloc_(n);
}
#endif
