/**
* Copyright 1981-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

#include "gdecode.h"
#include "sencode.h"

#include "sencode1.h"

fortint IS1NUMB(gribProduct ** grib, fortint * number) {
gribProduct * g = *grib;

  if( !( ecmwfLocalDefinitionPresent(g) && (g1_definition(g)==1) ) )
    return (fortint) -1;

  MOVE1BYTE(((g->g1)->local.contents.def1.number),number);
  return 0;
}

fortint RS1NUMB(gribProduct ** grib, fortdouble *number) {
fortint Number = (fortint) *number;
  return IS1NUMB(grib,&Number);
}

fortint IS1TOTL(gribProduct ** grib, fortint * total) {
gribProduct * g = *grib;

  if( !( ecmwfLocalDefinitionPresent(g) && (g1_definition(g)==1) ) )
    return (fortint) -1;

  MOVE1BYTE(((g->g1)->local.contents.def1.total),total);
  return 0;
}

fortint RS1TOTL(gribProduct ** grib, fortdouble *total) {
fortint Total = (fortint) *total;
  return IS1TOTL(grib,&Total);
}
