C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      SUBROUTINE INTLOGR(KLEVEL, MESSAGE, PNUM)
C
C---->
C**** INTLOGR
C
C     PURPOSE
C     _______
C
C     This routine logs error messages.
C
C
C     INTERFACE
C     _________
C
C     CALL INTLOGR(KLEVEL, MESSAGE, PNUM)
C
C
C     Input parameters
C     ________________
C
C     KLEVEL   - Severity level for reported message
C                = 0 for debug
C                = 1 for information
C                = 2 for warning
C                = 3 for error
C                = 4 for fatal
C     MESSAGE  - Message text
C     PNUM     - Message number
C
C
C     Output parameters
C     ________________
C
C     None.
C
C
C     Common block usage
C     __________________
C
C     LDEBUG in /INTLOGC/ controls display of message
C                 = 0 for no display
C                 = 1 to display
C
C
C     Method
C     ______
C
C     Prints message and number if debug flag is 'on'.
C
C
C     Externals
C     _________
C
C     INTLOGT  - sends any ERROR or FATAL message to the MARS server.
C
C
C     Comments
C     ________
C
C     LDEBUG is toggled by a call to INTLOGD.
C
C
C     AUTHOR
C     ______
C
C     J.D.Chambers      *ECMWF*      Jul 1995
C
C
C     MODIFICATIONS
C     _____________
C
C     J.D.Chambers      *ECMWF*      March 1996
C     Prepare error message for MARS server.
C
C
C----<
C     _______________________________________________________
      IMPLICIT NONE
C
#include "parim.h"
C
C     Subroutine arguments.
C
      INTEGER KLEVEL
      REAL PNUM
      CHARACTER *(*) MESSAGE
C
#include "intlog.h"
C
C     Local variables.
C
      CHARACTER*79 NEWMESS
      INTEGER NLEV, LOOP
      CHARACTER*5 TITLE(JP_FATAL+1)
      DATA TITLE/'DEBUG',
     X           'INFO ',
     X           'WARN ',
     X           'ERROR',
     X           'FATAL'/
      INTEGER IRET, ILEN
C
C ------------------------------------------------------------------
C*    Section 1.   Initialise
C ------------------------------------------------------------------
C
  100 CONTINUE
C
C     Ensure valid level is used.
      NLEV = KLEVEL + 1
      IF ( KLEVEL .GT. JP_FATAL) NLEV = JP_FATAL + 1
C
      DO LOOP = 1, 79
        NEWMESS(LOOP:LOOP) = ' '
      ENDDO
C
C ------------------------------------------------------------------
C*    Section 2.   Prepare ERROR or FATAL message for MARS server.
C ------------------------------------------------------------------
C
  200 CONTINUE
C
      ILEN = LEN(MESSAGE)
      IF( ILEN.GT.55 ) ILEN = 55
      NEWMESS(1:ILEN) = MESSAGE
      ILEN = ILEN + 1
      IF( ABS(PNUM).LT.100000.0 ) THEN
        WRITE(NEWMESS(ILEN:),'(F24.15)') PNUM
      ELSE IF ( ABS(PNUM).LT.10000000000.0 ) THEN
        WRITE(NEWMESS(ILEN:),'(F24.10)') PNUM
      ELSE IF ( ABS(PNUM).LT.10000000000000.0 ) THEN
        WRITE(NEWMESS(ILEN:),'(F24.7)') PNUM
      ELSE
        WRITE(NEWMESS(ILEN:),'(F25.2)') PNUM
      ENDIF
C
C     Send the message
C
      IF( KLEVEL.GE.JP_WARN ) CALL INTLOGT(NEWMESS)
C
      IF( LDEBUG ) WRITE(*,9001) TITLE(NLEV),NEWMESS(1:66)
 9001 FORMAT('INTLOG ',A5,': ',A66)
C
C ------------------------------------------------------------------
C*    Section 9.   Closedown.
C ------------------------------------------------------------------
C
  900 CONTINUE
C
      RETURN
      END
