// LLVM_STYLE: new

// Capture the output of this into a variable, if you want
//(function(Module, args) {
//  Module = Module || {};
//  args = args || [];

// Runs much faster, for some reason
var Module = {};
// XXX manually added for demo // var args = arguments;
    // === Auto-generated preamble library stuff ===
  
  Runtime = {
    stackAlloc: function stackAlloc(size) { var ret = STACKTOP; for (var i = 0; i < size; i++) IHEAP[STACKTOP+i] = FHEAP[STACKTOP+i] = 0; STACKTOP += size;STACKTOP = Math.ceil(STACKTOP/4)*4;; return ret; },
    staticAlloc: function staticAlloc(size) { var ret = STATICTOP; for (var i = 0; i < size; i++) IHEAP[STATICTOP+i] = FHEAP[STATICTOP+i] = 0; STATICTOP += size;STATICTOP = Math.ceil(STATICTOP/4)*4;; return ret; },
    alignMemory: function alignMemory(size,quantum) { var ret = size = Math.ceil(size/(quantum ? quantum : 4))*(quantum ? quantum : 4);; return ret; },
    getFunctionIndex: function getFunctionIndex(func, ident) {
      var key = FUNCTION_TABLE.length;
      FUNCTION_TABLE[key] = func;
      FUNCTION_TABLE[key+1] = null; // Need to have keys be even numbers, see |polymorph| test
      Module[ident] = func; // Export using full name, for Closure Compiler
      return key;
    },
    isNumberType: function (type) {
      return type in Runtime.INT_TYPES || type in Runtime.FLOAT_TYPES;
    },
    isPointerType: function isPointerType(type) {
    return pointingLevels(type) > 0;
  },
    isStructType: function isStructType(type) {
    if (isPointerType(type)) return false;
    if (new RegExp(/^\[\d+\ x\ (.*)\]/g).test(type)) return true; // [15 x ?] blocks. Like structs
    // See comment in isStructPointerType()
    return !Runtime.isNumberType(type) && type[0] == '%';
  },
    INT_TYPES: {"i1":0,"i8":0,"i16":0,"i32":0,"i64":0},
    FLOAT_TYPES: {"float":0,"double":0},
    getNativeFieldSize: function getNativeFieldSize(field, alone) {
    var size;
    if (4 > 1) {
      size = {
        'i1': alone ? 1 : 4, // inside a struct, aligned to 4,
        'i8': alone ? 1 : 4, // most likely...? XXX
        'i16': alone ? 2 : 4, // ditto
        'i32': 4,
        'i64': 8,
        'float': 4,
        'double':8
      }[field]; // XXX 32/64 bit stuff
      if (!size) {
        size = 4; // Must be a pointer XXX 32/64
      }
    } else {
      size = 1;
    }
    return size;
  },
    dedup: function dedup(items, ident) {
    var seen = {};
    if (ident) {
      return items.filter(function(item) {
        if (seen[item[ident]]) return false;
        seen[item[ident]] = true;
        return true;
      });
    } else {
      return items.filter(function(item) {
        if (seen[item]) return false;
        seen[item] = true;
        return true;
      });
    }
  },
    calculateStructAlignment: function calculateStructAlignment(type, otherTypes) {
      type.flatSize = 0;
      var diffs = [];
      var prev = -1, maxSize = -1;
      type.flatIndexes = type.fields.map(function(field) {
        var size;
        if (Runtime.isNumberType(field) || Runtime.isPointerType(field)) {
          size = Runtime.getNativeFieldSize(field, true); // pack char; char; in structs, also char[X]s.
          maxSize = Math.max(maxSize, size);
        } else if (Runtime.isStructType(field)) {
          size = otherTypes[field].flatSize;
          maxSize = Math.max(maxSize, 4);
        } else {
          dprint('Unclear type in struct: ' + field + ', in ' + type.name_);
          assert(0);
        }
        var curr = Runtime.alignMemory(type.flatSize, Math.min(4, size)); // if necessary, place this on aligned memory
        type.flatSize = curr + size;
        if (prev >= 0) {
          diffs.push(curr-prev);
        }
        prev = curr;
        return curr;
      });
      type.flatSize = Runtime.alignMemory(type.flatSize, maxSize);
      if (diffs.length == 0) {
        type.flatFactor = type.flatSize;
      } else if (Runtime.dedup(diffs).length == 1) {
        type.flatFactor = diffs[0];
      }
      type.needsFlattening = (type.flatFactor != 1);
      return type.flatIndexes;
    },
    __dummy__: 0
  }
  
  
  function __globalConstructor__() {
  }
  
  // Maps ints ==> functions. This lets us pass around ints, which are
  // actually pointers to functions, and we convert at call()time
  var FUNCTION_TABLE = [];
  
  var __THREW__ = false; // Used in checking for thrown exceptions.
  
  var __ATEXIT__ = [];
  
  
  
  
  var ABORT = false;
  
  var undef = 0;
  
  function assert(condition, text) {
    if (!condition) {
      var text = "Assertion failed: " + text;
      print(text + ':\n' + (new Error).stack);
      ABORT = true;
      throw "Assertion: " + text;
    }
  }
  
  function Pointer_niceify(ptr) {
    return { slab: IHEAP, pos: ptr };
  }
  
  // Creates a pointer for a certain slab and a certain address in that slab.
  // If just a slab is given, will allocate room for it and copy it there. In
  // other words, do whatever is necessary in order to return a pointer, that
  // points to the slab (and possibly position) we are given.
  
  var ALLOC_NORMAL = 0; // Tries to use _malloc()
  var ALLOC_STACK = 1; // Lives for the duration of the current function call
  var ALLOC_STATIC = 2; // Cannot be freed
  
  function Pointer_make(slab, pos, allocator) {
    pos = pos ? pos : 0;
    assert(pos === 0); // TODO: remove 'pos'
    if (slab === HEAP) return pos;
    var size = slab.length;
  
    var i;
    for (i = 0; i < size; i++) {
      if (slab[i] === undefined) {
        throw 'Invalid element in slab at ' + new Error().stack; // This can be caught, and you can try again to allocate later, see globalFuncs in run()
      }
    }
  
    // Finalize
    var ret = [_malloc, Runtime.stackAlloc, Runtime.staticAlloc][allocator ? allocator : ALLOC_STATIC](Math.max(size, 1));
  
    for (i = 0; i < size; i++) {
      var curr = slab[i];
  
      if (typeof curr === 'function') {
        curr = Runtime.getFunctionIndex(curr);
      }
      // TODO: Check - also in non-typedarray case - for functions, and if so add |.__index__|
      if (typeof curr === 'number' || typeof curr === 'boolean') {
        IHEAP[ret + i] = curr; // TODO: optimize. Can easily detect floats, but 1.0 might look like an int...
        FHEAP[ret + i] = curr;
      } else {
        HEAP[ret + i] = curr;
      }
    }
  
    return ret;
  }
  
  function Pointer_stringify(ptr) {
    ptr = Pointer_niceify(ptr);
  
    var ret = "";
    var i = 0;
    var t;
    while (1) {
  //    if ((ptr.pos + i) >= ptr.slab.length) { return "<< Invalid read: " + (ptr.pos+i) + " : " + ptr.slab.length + " >>"; } else {}
      if ((ptr.pos+i) >= ptr.slab.length) { break; } else {}
      t = String.fromCharCode(ptr.slab[ptr.pos + i]);
      if (t == "\0") { break; } else {}
      ret += t;
      i += 1;
    }
    return ret;
  }
  
  // Memory management
  
  var PAGE_SIZE = 4096;
  function alignMemoryPage(x) {
    return Math.ceil(x/PAGE_SIZE)*PAGE_SIZE;
  }
  
  var HEAP, IHEAP, FHEAP;
  var STACK_ROOT, STACKTOP, STACK_MAX;
  var STATICTOP;
  
  // Mangled |new| and |free| (various manglings, for int, long params; new and new[], etc.
  var _malloc, _free, __Znwj, __Znaj, __Znam, __Znwm, __ZdlPv, __ZdaPv;
  
  var HAS_TYPED_ARRAYS = false;
  var TOTAL_MEMORY = 50*1024*1024;
  
  function __initializeRuntime__() {
    // If we don't have malloc/free implemented, use a simple implementation.
    Module['_malloc'] = _malloc = __Znwj = __Znaj = __Znam = __Znwm = Module['_malloc'] ? Module['_malloc'] : Runtime.staticAlloc;
    Module['_free']   = _free = __ZdlPv = __ZdaPv =                   Module['_free']   ? Module['_free']   : function() { };
  
    // TODO: Remove one of the 3 heaps!
    HEAP = intArrayFromString('(null)'); // So printing %s of NULL gives '(null)'
                                         // Also this ensures we leave 0 as an invalid address, 'NULL'
    HAS_TYPED_ARRAYS = this['Int32Array'] && this['Float64Array']; // check for engine support
    if (HAS_TYPED_ARRAYS) {
      IHEAP = new Int32Array(TOTAL_MEMORY);
      for (var i = 0; i < HEAP.length; i++) {
        IHEAP[i] = HEAP[i];
      }
      HEAP = IHEAP;
      FHEAP = new Float64Array(TOTAL_MEMORY);
    } else {
      IHEAP = HEAP; // fallback
      FHEAP = HEAP; // fallback
    }
  
    Module['HEAP'] = HEAP;
    Module['IHEAP'] = IHEAP;
    Module['FHEAP'] = FHEAP;
  
    STACK_ROOT = STACKTOP = alignMemoryPage(10);
    if (!this['TOTAL_STACK']) TOTAL_STACK = 1024*1024; // Reserved room for stack
    STACK_MAX = STACK_ROOT + TOTAL_STACK;
  
    STATICTOP = alignMemoryPage(STACK_MAX);
  }
  
  function __shutdownRuntime__() {
    while( __ATEXIT__.length > 0) {
      var func = __ATEXIT__.pop();
      if (typeof func === 'number') {
        func = FUNCTION_TABLE[func];
      }
      func();
    }
  }
  
  // stdio.h
  
  // C-style: we work on ints on the HEAP.
  function __formatString() {
    var cStyle = false;
    var textIndex = arguments[0];
    var argIndex = 1;
    if (textIndex < 0) {
      cStyle = true;
      textIndex = -textIndex;
      slab = null;
      argIndex = arguments[1];
    } else {
      var _arguments = arguments;
    }
    function getNextArg(type) {
      var ret;
      if (!cStyle) {
        ret = _arguments[argIndex];
        argIndex++;
      } else {
        ret = (type === 'f' ? FHEAP : IHEAP)[argIndex];
        argIndex += type === 'l'.charCodeAt(0) ? 8 : 4; // XXX hardcoded native sizes
      }
      return ret;
    }
  
    var ret = [];
    var curr = -1, next, currArg;
    while (curr) { // Note: should be curr != 0, technically. But this helps catch bugs with undefineds
      curr = IHEAP[textIndex];
      next = IHEAP[textIndex+1];
      if (curr == '%'.charCodeAt(0) && ['d', 'u', 'f', '.'].indexOf(String.fromCharCode(next)) != -1) {
        var currArg;
        var argText;
        // Handle very very simply formatting, namely only %.Xf
        if (next == '.'.charCodeAt(0)) {
          var limit = 0;
          while(1) {
            var limitChr = IHEAP[textIndex+2];
            if (!(limitChr >= '0'.charCodeAt(0) && limitChr <= '9'.charCodeAt(0))) break;
            limit *= 10;
            limit += limitChr - '0'.charCodeAt(0);
            textIndex++;
          }
          textIndex--;
          next = IHEAP[textIndex+1];
          currArg = getNextArg(next);
          argText = String(+currArg); // +: boolean=>int
          var dotIndex = argText.indexOf('.');
          if (dotIndex == -1) {
            dotIndex = argText.length;
            argText += '.';
          }
          argText += '00000000000'; // padding
          argText = argText.substr(0, dotIndex+1+limit);
          textIndex += 2;
        } else if (next == 'u'.charCodeAt(0)) {
          currArg = getNextArg(next);
          argText = String(unSign(currArg, 32));
        } else {
          currArg = getNextArg(next);
          argText = String(+currArg); // +: boolean=>int
        }
        argText.split('').forEach(function(chr) {
          ret.push(chr.charCodeAt(0));
        });
        textIndex += 2;
      } else if (curr == '%'.charCodeAt(0) && next == 's'.charCodeAt(0)) {
        ret = ret.concat(String_copy(getNextArg(next)));
        textIndex += 2;
      } else if (curr == '%'.charCodeAt(0) && next == 'c'.charCodeAt(0)) {
        ret = ret.concat(getNextArg(next));
        textIndex += 2;
      } else {
        ret.push(curr);
        textIndex += 1;
      }
    }
    return Pointer_make(ret, 0, ALLOC_STACK); // NB: Stored on the stack
  }
  
  // Copies a list of num items on the HEAP into a
  // a normal JavaScript array of numbers
  function Array_copy(ptr, num) {
    return Array.prototype.slice.call(IHEAP.slice(ptr, ptr+num)); // Make a normal array out of the typed one
  }
  
  // Copies a C-style string, terminated by a zero, from the HEAP into
  // a normal JavaScript array of numbers
  function String_copy(ptr, addZero) {
    return Array_copy(ptr, _strlen(ptr)).concat(addZero ? [0] : []);
  }
  
  // stdlib.h
  
  // Get a pointer, return int value of the string it points to
  function _atoi(s) {
    return Math.floor(Number(Pointer_stringify(s)));
  }
  
  function _llvm_memcpy_i32(dest, src, num, idunno) {
    var curr;
    for (var i = 0; i < num; i++) {
      curr = HEAP[src + i] || 0; // memcpy sometimes copies uninitialized areas XXX: Investigate why initializing alloc'ed memory does not fix that too
      HEAP[dest + i] = curr;
      // TODO: optimize somehow - this is slower than without typed arrays
      IHEAP[dest + i] = IHEAP[src + i];
      FHEAP[dest + i] = FHEAP[src + i];
    }
  }
  _memcpy = _llvm_memcpy_i64 = _llvm_memcpy_p0i8_p0i8_i32 = _llvm_memcpy_p0i8_p0i8_i64 = _llvm_memcpy_i32;
  
  function llvm_memset_i32(ptr, value, num) {
    for (var i = 0; i < num; i++) {
      HEAP[ptr+i] = IHEAP[ptr+i] = FHEAP[ptr+i] = value;
    }
  }
  _llvm_memset_p0i8_i64 = _llvm_memset_p0i8_i32 = llvm_memset_i32;
  
  function _strlen(ptr) {
    var i = 0;
    while (IHEAP[ptr+i]) i++; // Note: should be IHEAP[ptr+i] != 0, technically. But this helps catch bugs with undefineds
    return i;
  }
  
  // Tools
  
  PRINTBUFFER = '';
  function __print__(text) {
    if (text === null) {
      // Flush
      print(PRINTBUFFER);
      PRINTBUFFER = '';
      return;
    }
    // We print only when we see a '\n', as console JS engines always add
    // one anyhow.
    PRINTBUFFER = PRINTBUFFER + text;
    var endIndex;
    while ((endIndex = PRINTBUFFER.indexOf('\n')) != -1) {
      print(PRINTBUFFER.substr(0, endIndex));
      PRINTBUFFER = PRINTBUFFER.substr(endIndex + 1);
    }
  }
  
  function jrint(label, obj) { // XXX manual debugging
    if (!obj) {
      obj = label;
      label = '';
    } else
      label = label + ' : ';
    print(label + JSON.stringify(obj));
  }
  
  // This processes a 'normal' string into a C-line array of numbers.
  // For LLVM-originating strings, see parser.js:parseLLVMString function
  function intArrayFromString(stringy) {
    var ret = [];
    var t;
    var i = 0;
    while (i < stringy.length) {
      ret.push(stringy.charCodeAt(i));
      i = i + 1;
    }
    ret.push(0);
    return ret;
  }
  
  // Converts a value we have as signed, into an unsigned value. For
  // example, -1 in int32 would be a very large number as unsigned.
  function unSign(value, bits) {
    if (value >= 0) return value;
    return 2*Math.abs(1 << (bits-1)) + value;
  }
  
  // === Body ===
  
  var $0___SIZE = 12; // %0
  
  var $1___SIZE = 16; // %1
  var $1___FLATTENER = [0,8,12];
  var $2___SIZE = 8; // %2
  
  var $3___SIZE = 8; // %3
  
  var $4___SIZE = 20; // %4
  var $4___FLATTENER = [0,4,5,8,12,16];
  var $5___SIZE = 8; // %5
  
  var $6___SIZE = 16; // %6
  
  var $7___SIZE = 12; // %7
  
  var $8___SIZE = 8; // %8
  
  var $9___SIZE = 28; // %9
  
  var $10___SIZE = 16; // %10
  
  var $11___SIZE = 16; // %11
  var $11___FLATTENER = [0,8,12];
  var $12___SIZE = 20; // %12
  
  var $13___SIZE = 8; // %13
  
  var $14___SIZE = 16; // %14
  
  var $enum_BinOpr___SIZE = 4; // %enum.BinOpr
  
  var $enum_OpArgMask___SIZE = 4; // %enum.OpArgMask
  
  var $enum_OpMode___SIZE = 4; // %enum.OpMode
  
  var $enum_UnOpr___SIZE = 4; // %enum.UnOpr
  
  var $enum_anon___SIZE = 4; // %enum.anon
  
  var $struct_BlockCnt___SIZE = 12; // %struct.BlockCnt
  var $struct_BlockCnt___FLATTENER = [0,4,8,9,10];
  var $struct_CCallS___SIZE = 8; // %struct.CCallS
  
  var $struct_CClosure___SIZE = 32; // %struct.CClosure
  var $struct_CClosure___FLATTENER = [0,4,5,6,7,8,12,16,20];
  var $struct_CallInfo___SIZE = 24; // %struct.CallInfo
  
  var $struct_CallS___SIZE = 8; // %struct.CallS
  
  var $struct_ConsControl___SIZE = 36; // %struct.ConsControl
  var $struct_ConsControl___FLATTENER = [0,20,24,28,32];
  var $struct_FuncState___SIZE = 572; // %struct.FuncState
  var $struct_FuncState___FLATTENER = [0,4,8,12,16,20,24,28,32,36,40,44,48,50,52,172];
  var $struct_GCheader___SIZE = 8; // %struct.GCheader
  var $struct_GCheader___FLATTENER = [0,4,5];
  var $struct_LClosure___SIZE = 24; // %struct.LClosure
  var $struct_LClosure___FLATTENER = [0,4,5,6,7,8,12,16,20];
  var $struct_LG___SIZE = 348; // %struct.LG
  
  var $struct_LHS_assign___SIZE = 24; // %struct.LHS_assign
  
  var $struct_LexState___SIZE = 60; // %struct.LexState
  var $struct_LexState___FLATTENER = [0,4,8,12,24,36,40,44,48,52,56];
  var $struct_LoadF___SIZE = 8200; // %struct.LoadF
  
  var $struct_LoadS___SIZE = 8; // %struct.LoadS
  
  var $struct_LocVar___SIZE = 12; // %struct.LocVar
  
  var $struct_MatchState___SIZE = 272; // %struct.MatchState
  
  var $struct_Mbuffer___SIZE = 12; // %struct.Mbuffer
  
  var $struct_Node___SIZE = 28; // %struct.Node
  
  var $struct_Proto___SIZE = 76; // %struct.Proto
  var $struct_Proto___FLATTENER = [0,4,5,8,12,16,20,24,28,32,36,40,44,48,52,56,60,64,68,72,73,74,75];
  var $struct_SParser___SIZE = 20; // %struct.SParser
  var $struct_SParser___FLATTENER = [0,4,16];
  var $struct_Smain___SIZE = 12; // %struct.Smain
  
  var $struct_Table___SIZE = 32; // %struct.Table
  var $struct_Table___FLATTENER = [0,4,5,6,7,8,12,16,20,24,28];
  var $struct_Token___SIZE = 12; // %struct.Token
  
  var $struct_UpVal___SIZE = 24; // %struct.UpVal
  var $struct_UpVal___FLATTENER = [0,4,5,8,12];
  var $struct_Zio___SIZE = 20; // %struct.Zio
  
  var $struct__IO_FILE___SIZE = 152; // %struct._IO_FILE
  var $struct__IO_FILE___FLATTENER = [0,4,8,12,16,20,24,28,32,36,40,44,48,52,56,60,64,68,70,71,72,76,84,88,92,96,100,104,108];
  var $struct__IO_marker___SIZE = 12; // %struct._IO_marker
  
  var $struct_anon___SIZE = 16; // %struct.anon
  var $struct_anon___FLATTENER = [0,4,5,6,8,12];
  var $struct_expdesc___SIZE = 20; // %struct.expdesc
  var $struct_expdesc___FLATTENER = [0,4,12,16];
  var $struct_global_State___SIZE = 236; // %struct.global_State
  var $struct_global_State___FLATTENER = [0,12,16,20,21,24,28,32,36,40,44,48,52,64,68,72,76,80,84,88,92,104,108,132,168];
  var $struct_lconv___SIZE = 56; // %struct.lconv
  var $struct_lconv___FLATTENER = [0,4,8,12,16,20,24,28,32,36,40,41,42,43,44,45,46,47,48,49,50,51,52,53];
  var $struct_luaL_Buffer___SIZE = 8204; // %struct.luaL_Buffer
  
  var $struct_luaL_Reg___SIZE = 8; // %struct.luaL_Reg
  
  var $struct_lua_Debug___SIZE = 100; // %struct.lua_Debug
  var $struct_lua_Debug___FLATTENER = [0,4,8,12,16,20,24,28,32,36,96];
  var $struct_lua_State___SIZE = 112; // %struct.lua_State
  var $struct_lua_State___FLATTENER = [0,4,5,6,8,12,16,20,24,28,32,36,40,44,48,52,54,56,57,60,64,68,72,84,96,100,104,108];
  var $struct_lua_TValue___SIZE = 12; // %struct.lua_TValue
  
  var $struct_lua_longjmp___SIZE = 12; // %struct.lua_longjmp
  
  var $struct_stringtable___SIZE = 12; // %struct.stringtable
  
  var $struct_tm___SIZE = 44; // %struct.tm
  
  var $struct_upvaldesc___SIZE = 2; // %struct.upvaldesc
  
  var $union_Closure___SIZE = 32; // %union.Closure
  
  var $union_GCObject___SIZE = 112; // %union.GCObject
  
  var $union_TKey___SIZE = 16; // %union.TKey
  
  var $union_TString___SIZE = 16; // %union.TString
  
  var $union_Udata___SIZE = 20; // %union.Udata
  
  var $union_anon___SIZE = 8; // %union.anon
  
  var __ZL7globalL;
  var __str;
  var __str1;
  var __ZL8progname;
  var __str2;
  var __str3;
  var __str4;
  var __str5;
  var _stdout;
  var __str6;
  var __str7;
  var __str8;
  var __str9;
  var __str10;
  var _stdin;
  var __str11;
  var __str12;
  var __str13;
  var __str14;
  var __str15;
  var __str16;
  var __str17;
  var __str18;
  var __str19;
  var __str20;
  var __str21;
  var __str22;
  var _stderr;
  var __str23;
  var __str24;
  var __str25;
  var __str26;
  var __str27;
  var __str28;
  var __str129;
  var __str230;
  var __str331;
  var __str432;
  var __str1533;
  var __str2634;
  var __str37;
  var __str835;
  var __str1936;
  var __str210;
  var __str311;
  var __str412;
  var __str537;
  var __str638;
  var __str739;
  var __str813;
  var __str940;
  var __str1041;
  var __str1142;
  var __str1243;
  var __str1344;
  var __str1445;
  var __str1514;
  var __str1646;
  var __str1747;
  var __str1848;
  var __str1915;
  var __str2049;
  var __str2150;
  var __str122;
  var __ZTVN10__cxxabiv119__pointer_type_infoE;
  var __ZTSP11lua_longjmp;
  var __ZTVN10__cxxabiv117__class_type_infoE;
  var __ZTS11lua_longjmp;
  var __ZTI11lua_longjmp;
  var __ZTIP11lua_longjmp;
  var __str223;
  var __str324;
  var __str425;
  var __str526;
  var __str627;
  var __str728;
  var __str829;
  var __str47;
  var __str148;
  var __str249;
  var __str350;
  var __str451;
  var __str552;
  var __str653;
  var __str754;
  var __str855;
  var __str956;
  var __str1057;
  var __str1158;
  var __str1259;
  var __str1360;
  var __str1461;
  var __str1562;
  var __str1663;
  var __str1764;
  var __str1865;
  var __str1966;
  var __str2067;
  var __str2168;
  var __str2251;
  var __str2352;
  var __str2453;
  var __str2554;
  var __str2669;
  var __str2755;
  var __str2856;
  var __str29;
  var __str30;
  var _luaX_tokens;
  var __str31;
  var __str32;
  var __str33;
  var __str34;
  var __str35;
  var __str36;
  var __str3770;
  var __str38;
  var __str39;
  var __str40;
  var __str41;
  var __str42;
  var __str43;
  var __str44;
  var __str45;
  var __str46;
  var __str72;
  var _luaO_nilobject_;
  var __ZZ9luaO_log2jE5log_2;
  var __str77;
  var __str178;
  var __str279;
  var __str380;
  var __str481;
  var __str582;
  var __str683;
  var __str784;
  var __str90;
  var __str191;
  var __str292;
  var __str393;
  var __str494;
  var __str595;
  var __str696;
  var __str797;
  var __str898;
  var __str999;
  var __str10100;
  var __str11101;
  var __str12102;
  var __str13103;
  var __str14104;
  var __str15105;
  var __str16106;
  var __str17107;
  var __str18108;
  var __str19109;
  var __str20110;
  var __str21111;
  var __str22112;
  var __str23113;
  var __str24114;
  var __str25115;
  var __str26116;
  var __str27117;
  var __str28118;
  var __str29119;
  var __str30120;
  var __str31121;
  var __str32122;
  var __str33123;
  var __str34124;
  var __str35125;
  var __str36126;
  var __str37127;
  var _luaP_opnames;
  var _luaP_opmodes;
  var __str12957;
  var __str1130;
  var __ZL8priority;
  var __str2131;
  var __str3132;
  var __str4133;
  var __str5134;
  var __str6135;
  var __str7136;
  var __str8137;
  var __str9138;
  var __str10139;
  var __str11140;
  var __str12141;
  var __str13142;
  var __str14143;
  var __str15144;
  var __str16145;
  var __str17146;
  var __str18147;
  var __str19148;
  var __str20149;
  var __str21150;
  var __str22151;
  var __str23152;
  var __str24153;
  var __str25154;
  var __str26155;
  var __str27156;
  var __str158;
  var __ZL10dummynode_;
  var __str164;
  var __str1165;
  var __str2166;
  var __str3167;
  var __str177;
  var __str1178;
  var __str2179;
  var __str3180;
  var __str4181;
  var __str5182;
  var __str6183;
  var __str7184;
  var __str8185;
  var __str9186;
  var _luaT_typenames;
  var __ZZ9luaT_initP9lua_StateE14luaT_eventname;
  var __str10188;
  var __str11189;
  var __str12190;
  var __str13191;
  var __str14192;
  var __str15193;
  var __str16194;
  var __str17195;
  var __str18196;
  var __str19197;
  var __str20198;
  var __str21199;
  var __str22200;
  var __str23201;
  var __str24202;
  var __str25203;
  var __str26204;
  var __str208;
  var __str1209;
  var __str2210;
  var __str3211;
  var __str4212;
  var __str5213;
  var __str6214;
  var __str7215;
  var __str8216;
  var __str9217;
  var __str220;
  var __str1221;
  var __str2222;
  var __str3223;
  var __str4224;
  var __str5225;
  var __str6226;
  var __str7227;
  var __str8228;
  var __str242;
  var __str124358;
  var __str2244;
  var __str3245;
  var __str4246;
  var __str5247;
  var __str6248;
  var __str7249;
  var __str8250;
  var __str9251;
  var __str10252;
  var __str11253;
  var __str12254;
  var __str13255;
  var __str14256;
  var __str15257;
  var __str16258;
  var __str17259;
  var __str18260;
  var __str19261;
  var __str20262;
  var __str21263;
  var __str22264;
  var __str23265;
  var __str24266;
  var __str25267;
  var __str268;
  var __str1269;
  var __str2270;
  var __str3271;
  var __str4272;
  var __str5273;
  var __str6274;
  var __str7275;
  var __str8276;
  var __str9277;
  var __str10278;
  var __str11279;
  var __str12280;
  var __str13281;
  var __str14282;
  var __str15283;
  var __str16284;
  var __str17285;
  var __str18286;
  var __str19287;
  var __str20288;
  var __str21289;
  var __str22290;
  var __str23291;
  var __ZL10base_funcs;
  var __str24292;
  var __str25293;
  var __str26294;
  var __str27295;
  var __str28296;
  var __str29297;
  var __ZL8co_funcs;
  var __str30298;
  var __str31299;
  var __str32300;
  var __str33301;
  var __str34302;
  var __str35303;
  var __str36304;
  var __str37305;
  var __str38306;
  var __str39307;
  var __str40308;
  var __str41309;
  var __ZL9statnames;
  var __str42310;
  var __str43311;
  var __str44312;
  var __str45313;
  var __str46314;
  var __str47315;
  var __str48;
  var __str49;
  var __str50;
  var __str51;
  var __str52;
  var __str53;
  var __str54;
  var __str55;
  var __str56;
  var __str57;
  var __str58;
  var __str59;
  var __str60;
  var __str61;
  var __str62;
  var __str63;
  var __str64;
  var __str65;
  var __str66;
  var __str67;
  var __str68;
  var __str69;
  var __ZZ19luaB_collectgarbageP9lua_StateE4opts;
  var __str70;
  var __str71;
  var __str72316;
  var __str73;
  var __str74;
  var __str75;
  var __str76;
  var __ZZ19luaB_collectgarbageP9lua_StateE7optsnum;
  var __str77317;
  var __str78;
  var __str318;
  var __str1319;
  var __str2320;
  var __str3321;
  var __str4322;
  var __str5323;
  var __str6324;
  var __str7325;
  var __str8326;
  var __str9327;
  var __str10328;
  var __str11329;
  var __str12330;
  var __str13331;
  var __ZL5dblib;
  var __str14332;
  var __str15333;
  var __str16334;
  var __str17335;
  var __str18336;
  var __str19337;
  var __str20338;
  var __str21339;
  var __str22340;
  var __str23341;
  var __str24342;
  var __str25343;
  var __str26344;
  var __str27345;
  var __ZL8KEY_HOOK;
  var __ZZ5hookfP9lua_StateP9lua_DebugE9hooknames;
  var __str28346;
  var __str29347;
  var __str30348;
  var __str31349;
  var __str32350;
  var __str33351;
  var __str34352;
  var __str35353;
  var __str36354;
  var __str37355;
  var __str38356;
  var __str39357;
  var __str40358;
  var __str41359;
  var __str42360;
  var __str43361;
  var __str44362;
  var __str45363;
  var __str46364;
  var __str47365;
  var __str48366;
  var __str49367;
  var __str50368;
  var __str51369;
  var __str52370;
  var __str371;
  var __str1372;
  var __str2373;
  var __str3374;
  var __str4375;
  var __str5376;
  var __str6377;
  var __str7378;
  var __str8379;
  var __str9380;
  var __str10381;
  var __ZL5iolib;
  var __str11382;
  var __str12383;
  var __str13384;
  var __str14385;
  var __ZL4flib;
  var __str15386;
  var __str16387;
  var __str17388;
  var __str18389;
  var __str19390;
  var __str20391;
  var __str21392;
  var __str22393;
  var __str23394;
  var __str24395;
  var __str25396;
  var __str26397;
  var __str27398;
  var __str28399;
  var __ZZ9f_setvbufP9lua_StateE4mode;
  var __ZZ9f_setvbufP9lua_StateE9modenames;
  var __str29400;
  var __str30401;
  var __str31402;
  var __ZZ6f_seekP9lua_StateE4mode;
  var __ZZ6f_seekP9lua_StateE9modenames;
  var __str32403;
  var __str33404;
  var __str34405;
  var __str35406;
  var __str36407;
  var __str37408;
  var __str38409;
  var __str39410;
  var __str40411;
  var __ZL6fnames;
  var __str41412;
  var __str42413;
  var __str43414;
  var __str44415;
  var __str45416;
  var __str417;
  var __str1418;
  var __str2419;
  var __str3420;
  var __str4421;
  var __str5422;
  var __str6423;
  var __str7424;
  var __str8425;
  var __str9426;
  var __str10427;
  var __str11428;
  var __str12429;
  var __str13430;
  var __str14431;
  var __str15432;
  var __str16433;
  var __str17434;
  var __str18435;
  var __str19436;
  var __str20437;
  var __str21438;
  var __str22439;
  var __str23440;
  var __str24441;
  var __str25442;
  var __str26443;
  var __str27444;
  var __ZL7mathlib;
  var __str28445;
  var __str29446;
  var __str30447;
  var __str31448;
  var __str32449;
  var __str33450;
  var __str452;
  var __str1453;
  var __str2454;
  var __str3455;
  var __str4456;
  var __str5457;
  var __str6458;
  var __str7459;
  var __str8460;
  var __str9461;
  var __str10462;
  var __ZL6syslib;
  var __str11463;
  var __str12464;
  var __str13465;
  var __str14466;
  var __str15467;
  var __str16468;
  var __str17469;
  var __str18470;
  var __str19471;
  var __str20472;
  var __ZZ12os_setlocaleP9lua_StateE3cat;
  var __ZZ12os_setlocaleP9lua_StateE8catnames;
  var __str21473;
  var __str22474;
  var __str23475;
  var __str24476;
  var __str25477;
  var __str26478;
  var __str27479;
  var __str28480;
  var __str29481;
  var __str30482;
  var __str483;
  var __str1484;
  var __str2485;
  var __str3486;
  var __str4487;
  var __str5488;
  var __str6489;
  var __str7490;
  var __str8491;
  var __ZL9tab_funcs;
  var __str9492;
  var __str10493;
  var __str11494;
  var __str12495;
  var __str13496;
  var __str14497;
  var __str498;
  var __str1499;
  var __str2500;
  var __str3501;
  var __str4502;
  var __str5503;
  var __str6504;
  var __str7505;
  var __str8506;
  var __str9507;
  var __str10508;
  var __str11509;
  var __str12510;
  var __str13511;
  var __str14512;
  var __ZL6strlib;
  var __str15513;
  var __str16514;
  var __str17515;
  var __str18516;
  var __str19517;
  var __str20518;
  var __str21519;
  var __str22520;
  var __str23521;
  var __str24522;
  var __str25523;
  var __str26524;
  var __str27525;
  var __str28526;
  var __str29527;
  var __str30528;
  var __str31529;
  var __str32530;
  var __str33531;
  var __str34532;
  var __str35533;
  var __str36534;
  var __str37535;
  var __str38536;
  var __str39537;
  var __str538;
  var __str1539;
  var __ZL8pk_funcs;
  var __str2540;
  var __str3541;
  var __ZL8ll_funcs;
  var __ZL7loaders;
  var __str4542;
  var __str5543;
  var __str6544;
  var __str7545;
  var __str8546;
  var __str9547;
  var __str10548;
  var __str11549;
  var __str12550;
  var __str13551;
  var __str14552;
  var __str15553;
  var __str16554;
  var __str17555;
  var __str18556;
  var __str19557;
  var __str20558;
  var __str21559;
  var __str22560;
  var __str23561;
  var __str24562;
  var __str25563;
  var __str26564;
  var __str27565;
  var __str28566;
  var __str29567;
  var __str30568;
  var __str31569;
  var __str32570;
  var __str33571;
  var __str34572;
  var __str35573;
  var __str36574;
  var __str37575;
  var __str38576;
  var __str39577;
  var __ZL9sentinel_;
  var __str40578;
  var __str41579;
  var __str42580;
  var __str43581;
  var __str44582;
  var __str45583;
  var __str46584;
  var __str47585;
  var __str48586;
  var __str49587;
  var __str50588;
  var __str51589;
  var __str590;
  var __str1591;
  var __str2592;
  var __str3593;
  var __str4594;
  var __str5595;
  var __str6596;
  var __str7597;
  var __ZL7lualibs;
  
  _fputs = function (p, stream) {
      var str = Pointer_stringify(p); if (str == '\n') return; // XXX manually added for demo, suppress unneeded newlines
      __print__(Pointer_stringify(p) + '\n');
    }
  _fflush = function (file) {
      __print__(null);
    }
  _signal = function (sig, func) {
      // TODO
      return 0;
    }
  // stub for _strstr
  // stub for _fgets
  // stub for _strlen
  _strcmp = function (px, py) {
      var i = 0;
      while (true) {
        var x = IHEAP[px+i];
        var y = IHEAP[py+i];
        if (x == y && x == 0) return 0;
        if (x == 0) return -1;
        if (y == 0) return 1;
        if (x == y) {
          i ++;
          continue;
        } else {
          return x > y ? 1 : -1;
        }
      }
    }
  _fprintf = function () {
      var file = arguments[0]; // TODO: something clever with this
      var args = Array.prototype.slice.call(arguments, 1);
      __print__(Pointer_stringify(__formatString.apply(null, args)));
    }
  _getenv = function (name_) {
      return 0; // TODO
    }
  // stub for _llvm_memcpy_p0i8_p0i8_i32
  // stub for _llvm_va_start
  // stub for _llvm_va_end
  // stub for _floor
  // stub for _llvm_pow_f64
  _abs = Math.abs
  _strchr = function (ptr, chr) {
      ptr--;
      do {
        ptr++;
        var val = IHEAP[ptr];
        if (val == chr) return ptr;
      } while (val);
      return 0;
    }
  ___cxa_allocate_exception = function (size) {
      return _malloc(size); // warning: leaked
    }
  ___cxa_throw = function (ptr, data, dunno) {
      throw ptr;
    }
  // stub for _exit
  _llvm_eh_exception = function () {
      return 'code-generated exception: ' + (new Error().stack);
    }
  ___gxx_personality_v0 = function () {
    }
  _llvm_eh_selector = function (exception, personality, num) {
      return 0;
    }
  // stub for _llvm_eh_typeid_for
  ___cxa_begin_catch = function (ptr) {
    }
  ___cxa_end_catch = function (ptr) {
    }
  _iscntrl = function (chr) {
      return (chr >= 0 && chr <= 0x1f) || chr === 0x7f;
    }
  _isdigit = function (chr) {
      return chr >= '0'.charCodeAt(0) && chr <= '9'.charCodeAt(0);
    }
  _isspace = function (chr) {
      return chr in { 32: 0, 9: 0, 10: 0, 11: 0, 12: 0, 13: 0 };
    }
  _isalpha = function (chr) {
      return (chr >= 'a'.charCodeAt(0) && chr <= 'z'.charCodeAt(0)) ||
             (chr >= 'A'.charCodeAt(0) && chr <= 'Z'.charCodeAt(0));
    }
  _isalnum = function (chr) {
      return (chr >= '0'.charCodeAt(0) && chr <= '9'.charCodeAt(0)) ||
             (chr >= 'a'.charCodeAt(0) && chr <= 'z'.charCodeAt(0)) ||
             (chr >= 'A'.charCodeAt(0) && chr <= 'Z'.charCodeAt(0));
    }
  // stub for _localeconv
  _strtod = function (str, endptr) {
      // XXX handles only whitespace + |[0-9]+(.[0.9]+)?|, no e+
      while (_isspace(str)) str++;
      var chr;
      var ret = 0;
      while(1) {
        chr = IHEAP[str];
        if (!_isdigit(chr)) break;
        ret = ret*10 + chr - '0'.charCodeAt(0);
        str++;
      }
      if (IHEAP[str] == '.'.charCodeAt(0)) {
        str++;
        var mul=1/10;
        while(1) {
          chr = IHEAP[str];
          if (!_isdigit(chr)) break;
          ret += mul*(chr - '0'.charCodeAt(0));
          mul /= 10;
          str++;
        }
      }
      if (endptr) {
        IHEAP[endptr] = str;
      }
      return ret;
    }
  // stub for _strtoul
  _sprintf = function () {
      var str = arguments[0];
      var args = Array.prototype.slice.call(arguments, 1);
      _strcpy(str, __formatString.apply(null, args)); // not terribly efficient
    }
  _strncpy = function (pdest, psrc, num) {
      var padding = false;
      for (var i = 0; i < num; i++) {
        IHEAP[pdest+i] = padding ? 0 : IHEAP[psrc+i];
        padding = padding || IHEAP[psrc+i] == 0;
      }
    }
  _strcpy = function (pdest, psrc) {
      var i = 0;
      do {
        IHEAP[pdest+i] = IHEAP[psrc+i];
        i ++;
      } while (IHEAP[psrc+i-1] != 0);
    }
  _strcat = function (pdest, psrc) {
      var len = Pointer_stringify(pdest).length; // TODO: use strlen, but need dependencies system
      var i = 0;
      do {
        IHEAP[pdest+len+i] = IHEAP[psrc+i];
        i ++;
      } while (IHEAP[psrc+i-1] != 0);
    }
  _strcspn = function (pstr, pset) {
      var str = String_copy(pstr, true);
      var set = String_copy(pset, true);
      var i = 0;
      while (set.indexOf(str[i]) == -1) i++; // Must halt, as 0 is in both
      return i;
    }
  // stub for _strncat
  _memcmp = function (p1, p2, num) {
      for (var i = 0; i < num; i++) {
        var v1 = IHEAP[p1+i];
        var v2 = IHEAP[p2+i];
        if (v1 != v2) return v1 > v2 ? 1 : -1;
      }
      return 0;
    }
  // stub for _strcoll
  _fopen = function (filename, mode) {
      return 1; // XXX
    }
  __IO_getc = function (file) {
      return -1; // EOF
    }
  // stub for _freopen
  _ungetc = function (chr, stream) {
      return chr;
    }
  _ferror = function (stream) {
      return 0;
    }
  _fclose = function (stream) {
      return 0;
    }
  // stub for _free
  _realloc = function (ptr, size) {
      // Very simple, inefficient implementation - if you use a real malloc, best to use
      // a real realloc with it
      if (!size) {
        if (ptr) _free(ptr);
        return 0;
      }
      var ret = _malloc(size);
      if (ptr) {
        _memcpy(ret, ptr, size); // might be some invalid reads
        _free(ptr);
      }
      return ret;
    }
  _feof = function (stream) {
      return 1;
    }
  // stub for _fread
  // stub for _strerror
  // stub for ___errno_location
  // stub for _fwrite
  // stub for _setvbuf
  // stub for _fseek
  // stub for _ftell
  // stub for _clearerr
  // stub for _fscanf
  // stub for _tmpfile
  _tan = Math.tan
  // stub for _tanh
  _sqrt = Math.sqrt
  _sin = Math.sin
  // stub for _sinh
  // stub for _srand
  // stub for _rand
  // stub for _modf
  // stub for _log
  // stub for _log10
  // stub for _ldexp
  // stub for _frexp
  // stub for _fmod
  // stub for _exp
  _cos = Math.cos
  // stub for _cosh
  // stub for _ceil
  _atan = Math.atan
  _atan2 = Math.atan2
  _asin = Math.asin
  _acos = Math.acos
  _fabs = Math.abs
  // stub for _tmpnam
  _time = function (ptr) {
      var ret = Math.floor(Date.now()/1000);
      if (ptr) {
        IHEAP[ptr] = ret;
      }
      return ret;
    }
  // stub for _mktime
  // stub for _setlocale
  // stub for _rename
  // stub for _remove
  // stub for _system
  // stub for _difftime
  // stub for _gmtime
  // stub for _localtime
  // stub for _strftime
  // stub for _clock
  _toupper = function (chr) {
      if (chr >= 'a'.charCodeAt(0) && chr <= 'z'.charCodeAt(0)) {
        return chr - 'a'.charCodeAt(0) + 'A'.charCodeAt(0);
      }
      return chr;
    }
  // stub for _strpbrk
  // stub for _tolower
  // stub for _islower
  // stub for _ispunct
  // stub for _isupper
  _isxdigit = function (chr) {
      return (chr >= '0'.charCodeAt(0) && chr <= '9'.charCodeAt(0)) ||
             (chr >= 'a'.charCodeAt(0) && chr <= 'f'.charCodeAt(0)) ||
             (chr >= 'A'.charCodeAt(0) && chr <= 'F'.charCodeAt(0));
    }
  // stub for _memchr
  // stub for _strrchr
  
  
  function _main($argc, $argv) {
    var __stackBase__  = STACKTOP; STACKTOP += 12; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $status;
    var $s = __stackBase__;
    var $L;
    $1 = 0;
    $2 = $argc;
    $3 = $argv;
    var $4 = __Z13luaL_newstatev();
    $L = $4;
    var $5 = $L;
    var $6 = $5 == 0;
    ;
    if ($6) {
      ;
      var $8 = $3;
      var $9 = $8;
      var $10 = IHEAP[$9];
      __Z9l_messagePKcS0_($10, __str);
      $1 = 1;
      ;
    }
    else {
      ;
      var $12 = $2;
      var $13 = $s;
      IHEAP[$13] = $12;
      var $14 = $3;
      var $15 = $s+4;
      IHEAP[$15] = $14;
      var $16 = $L;
      var $17 = $s;
      var $18 = __Z10lua_cpcallP9lua_StatePFiS0_EPv($16, __Z5pmainP9lua_State.__index__, $17);
      $status = $18;
      var $19 = $L;
      var $20 = $status;
      var $21 = __Z6reportP9lua_Statei($19, $20);
      var $22 = $L;
      return; // XXX manually added for demo
      __Z9lua_closeP9lua_State($22);
      var $23 = $status;
      var $24 = $23 != 0;
      ;
      if ($24) {
        __lastLabel__ = 3; ;
      }
      else {
        __lastLabel__ = 3; ;
        var $26 = $s+8;
        var $27 = IHEAP[$26];
        var $28 = $27 != 0;
        __lastLabel__ = 1; ;
      }
      var $30 = __lastLabel__ == 3 ? 1 : ($28);
      var $31 = $30 ? 1 : 0;
      $1 = $31;
      ;
    }
    var $33 = $1;
    STACKTOP = __stackBase__;
    return $33;
  }
  _main.__index__ = Runtime.getFunctionIndex(_main, "_main");
  
  
  function __Z9l_messagePKcS0_($pname, $msg) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $pname;
    $2 = $msg;
    var $3 = $1;
    var $4 = $3 != 0;
    ;
    if ($4) {
      ;
      var $6 = IHEAP[_stderr];
      var $7 = $1;
      var $8 = _fprintf($6, __str26, $7);
      ;
    }
    var $10 = IHEAP[_stderr];
    var $11 = $2;
    var $12 = _fprintf($10, __str27, $11);
    var $13 = IHEAP[_stderr];
    var $14 = _fflush($13);
    ;
    return;
  }
  __Z9l_messagePKcS0_.__index__ = Runtime.getFunctionIndex(__Z9l_messagePKcS0_, "__Z9l_messagePKcS0_");
  
  
  function __Z5pmainP9lua_State($L) {
    var __stackBase__  = STACKTOP; STACKTOP += 12; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $s;
    var $argv;
    var $script;
    var $has_i = __stackBase__;
    var $has_v = __stackBase__+4;
    var $has_e = __stackBase__+8;
    $2 = $L;
    var $3 = $2;
    var $4 = __Z14lua_touserdataP9lua_Statei($3, 1);
    var $5 = $4;
    $s = $5;
    var $6 = $s;
    var $7 = $6+4;
    var $8 = IHEAP[$7];
    $argv = $8;
    IHEAP[$has_i] = 0;
    IHEAP[$has_v] = 0;
    IHEAP[$has_e] = 0;
    var $9 = $2;
    IHEAP[__ZL7globalL] = $9;
    var $10 = $argv;
    var $11 = $10;
    var $12 = IHEAP[$11];
    var $13 = $12 != 0;
    ;
    $14$25$2: do { 
      if ($13) {
        ;
        var $15 = $argv;
        var $16 = $15;
        var $17 = IHEAP[$16];
        var $18 = $17;
        var $19 = IHEAP[$18];
        var $20 = $19 != 0;
        if (!($20)) { __label__ = 1; /* $25 */ break $14$25$2; }
        var $22 = $argv;
        var $23 = $22;
        var $24 = IHEAP[$23];
        IHEAP[__ZL8progname] = $24;
        ;
      }
    } while(0);
    var $26 = $2;
    var $27 = __Z6lua_gcP9lua_Stateii($26, 0, 0);
    var $28 = $2;
    __Z13luaL_openlibsP9lua_State($28);
    var $29 = $2;
    var $30 = __Z6lua_gcP9lua_Stateii($29, 1, 0);
    var $31 = $2;
    var $32 = __Z14handle_luainitP9lua_State($31);
    var $33 = $s;
    var $34 = $33+8;
    IHEAP[$34] = $32;
    var $35 = $s;
    var $36 = $35+8;
    var $37 = IHEAP[$36];
    var $38 = $37 != 0;
    ;
    if ($38) {
      ;
      $1 = 0;
      ;
    }
    else {
      ;
      var $41 = $argv;
      var $42 = __Z11collectargsPPcPiS1_S1_($41, $has_i, $has_v, $has_e);
      $script = $42;
      var $43 = $script;
      var $44 = $43 < 0;
      ;
      if ($44) {
        ;
        __Z11print_usagev();
        var $46 = $s;
        var $47 = $46+8;
        IHEAP[$47] = 1;
        $1 = 0;
        ;
      }
      else {
        ;
        var $49 = IHEAP[$has_v];
        var $50 = $49 != 0;
        ;
        if ($50) {
          ;
          __Z13print_versionv();
          ;
        }
        var $53 = $2;
        var $54 = $argv;
        var $55 = $script;
        var $56 = $55 > 0;
        ;
        if ($56) {
          ;
          var $58 = $script;
          __lastLabel__ = 5; ;
        }
        else {
          ;
          var $60 = $s;
          var $61 = $60;
          var $62 = IHEAP[$61];
          __lastLabel__ = 7; ;
        }
        var $64 = __lastLabel__ == 5 ? $58 : ($62);
        var $65 = __Z7runargsP9lua_StatePPci($53, $54, $64);
        var $66 = $s;
        var $67 = $66+8;
        IHEAP[$67] = $65;
        var $68 = $s;
        var $69 = $68+8;
        var $70 = IHEAP[$69];
        var $71 = $70 != 0;
        ;
        if ($71) {
          ;
          $1 = 0;
          ;
        }
        else {
          ;
          var $74 = $script;
          var $75 = $74 != 0;
          ;
          if ($75) {
            ;
            var $77 = $2;
            var $78 = $argv;
            var $79 = $script;
            var $80 = __Z13handle_scriptP9lua_StatePPci($77, $78, $79);
            var $81 = $s;
            var $82 = $81+8;
            IHEAP[$82] = $80;
            ;
          }
          var $84 = $s;
          var $85 = $84+8;
          var $86 = IHEAP[$85];
          var $87 = $86 != 0;
          ;
          if ($87) {
            ;
            $1 = 0;
            ;
          }
          else {
            ;
            var $90 = IHEAP[$has_i];
            var $91 = $90 != 0;
            ;
            if ($91) {
              ;
              var $93 = $2;
              __Z5dottyP9lua_State($93);
              ;
            }
            else {
              ;
              var $95 = $script;
              var $96 = $95 == 0;
              ;
              $97$105$31: do { 
                if ($96) {
                  ;
                  var $98 = IHEAP[$has_e];
                  var $99 = $98 != 0;
                  if ($99) { __label__ = 10; /* $105 */ break $97$105$31; }
                  var $101 = IHEAP[$has_v];
                  var $102 = $101 != 0;
                  if ($102) { __label__ = 10; /* $105 */ break $97$105$31; }
                  __Z13print_versionv();
                  var $104 = $2;
                  __Z5dottyP9lua_State($104);
                  ;
                }
              } while(0);
              ;
            }
            $1 = 0;
            ;
          }
        }
      }
    }
    var $108 = $1;
    STACKTOP = __stackBase__;
    return $108;
  }
  __Z5pmainP9lua_State.__index__ = Runtime.getFunctionIndex(__Z5pmainP9lua_State, "__Z5pmainP9lua_State");
  
  
  function __Z6reportP9lua_Statei($L, $status) {
    ;
    var __label__;
    var $1;
    var $2;
    var $msg;
    $1 = $L;
    $2 = $status;
    var $3 = $2;
    var $4 = $3 != 0;
    ;
    $5$19$2: do { 
      if ($4) {
        ;
        var $6 = $1;
        var $7 = __Z8lua_typeP9lua_Statei($6, -1);
        var $8 = $7 == 0;
        if ($8) { __label__ = 0; /* $19 */ break $5$19$2; }
        var $10 = $1;
        var $11 = __Z13lua_tolstringP9lua_StateiPj($10, -1, 0);
        $msg = $11;
        var $12 = $msg;
        var $13 = $12 == 0;
        ;
        if ($13) {
          ;
          $msg = __str1;
          ;
        }
        var $16 = IHEAP[__ZL8progname];
        var $17 = $msg;
        __Z9l_messagePKcS0_($16, $17);
        var $18 = $1;
        __Z10lua_settopP9lua_Statei($18, -2);
        ;
      }
    } while(0);
    var $20 = $2;
    ;
    return $20;
  }
  __Z6reportP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z6reportP9lua_Statei, "__Z6reportP9lua_Statei");
  
  
  function __Z14handle_luainitP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $2;
    var $init;
    $2 = $L;
    var $3 = _getenv(__str24);
    $init = $3;
    var $4 = $init;
    var $5 = $4 == 0;
    ;
    if ($5) {
      ;
      $1 = 0;
      ;
    }
    else {
      ;
      var $8 = $init;
      var $9 = $8;
      var $10 = IHEAP[$9];
      var $11 = $10;
      var $12 = $11 == 64;
      ;
      if ($12) {
        ;
        var $14 = $2;
        var $15 = $init;
        var $16 = $15+1;
        var $17 = __Z6dofileP9lua_StatePKc($14, $16);
        $1 = $17;
        ;
      }
      else {
        ;
        var $19 = $2;
        var $20 = $init;
        var $21 = __Z8dostringP9lua_StatePKcS2_($19, $20, __str25);
        $1 = $21;
        ;
      }
    }
    var $23 = $1;
    ;
    return $23;
  }
  __Z14handle_luainitP9lua_State.__index__ = Runtime.getFunctionIndex(__Z14handle_luainitP9lua_State, "__Z14handle_luainitP9lua_State");
  
  
  function __Z11collectargsPPcPiS1_S1_($argv, $pi, $pv, $pe) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $4;
    var $5;
    var $i;
    $2 = $argv;
    $3 = $pi;
    $4 = $pv;
    $5 = $pe;
    $i = 1;
    ;
    $6$2: while(1) { // $6
      var $7 = $i;
      var $8 = $2;
      var $9 = $8+4*$7;
      var $10 = IHEAP[$9];
      var $11 = $10 != 0;
      if (!($11)) { __label__ = 2; /* $107 */ break $6$2; }
      var $13 = $i;
      var $14 = $2;
      var $15 = $14+4*$13;
      var $16 = IHEAP[$15];
      var $17 = $16;
      var $18 = IHEAP[$17];
      var $19 = $18;
      var $20 = $19 != 45;
      if ($20) { __label__ = 3; /* $21 */ break $6$2; }
      var $24 = $i;
      var $25 = $2;
      var $26 = $25+4*$24;
      var $27 = IHEAP[$26];
      var $28 = $27+1;
      var $29 = IHEAP[$28];
      var $30 = $29;
      if ($30 == 45) {
        __label__ = 20; /* $31 */ break $6$2;
      }
      else if ($30 == 0) {
        __label__ = 21; /* $54 */ break $6$2;
      }
      else if ($30 == 105) {
        __label__ = 22; /* $56 */ 
      }
      else if ($30 == 118) {
        __label__ = 11; /* $68 */ 
      }
      else if ($30 == 101) {
        __label__ = 23; /* $80 */ 
      }
      else if ($30 == 108) {
        __label__ = 15; /* $82 */ 
      }
      else {
      __label__ = 24; /* $102 */ break $6$2;
      }
      
      $56$68$80$82$6: do { 
        if (__label__ == 22) {
          var $57 = $i;
          var $58 = $2;
          var $59 = $58+4*$57;
          var $60 = IHEAP[$59];
          var $61 = $60+2;
          var $62 = IHEAP[$61];
          var $63 = $62;
          var $64 = $63 != 0;
          if ($64) { __label__ = 9; /* $65 */ break $6$2; }
          var $67 = $3;
          IHEAP[$67] = 1;
          __label__ = 11; /* $68 */ break $56$68$80$82$6;
        }
        else if (__label__ == 23) {
          var $81 = $5;
          IHEAP[$81] = 1;
          __label__ = 15; /* $82 */ break $56$68$80$82$6;
        }
      } while(0);
      if (__label__ == 11) {
        var $69 = $i;
        var $70 = $2;
        var $71 = $70+4*$69;
        var $72 = IHEAP[$71];
        var $73 = $72+2;
        var $74 = IHEAP[$73];
        var $75 = $74;
        var $76 = $75 != 0;
        if ($76) { __label__ = 12; /* $77 */ break $6$2; }
        var $79 = $4;
        IHEAP[$79] = 1;
        ;
      }
      else if (__label__ == 15) {
        var $83 = $i;
        var $84 = $2;
        var $85 = $84+4*$83;
        var $86 = IHEAP[$85];
        var $87 = $86+2;
        var $88 = IHEAP[$87];
        var $89 = $88;
        var $90 = $89 == 0;
        ;
        if ($90) {
          ;
          var $92 = $i;
          var $93 = $92 + 1;
          $i = $93;
          var $94 = $i;
          var $95 = $2;
          var $96 = $95+4*$94;
          var $97 = IHEAP[$96];
          var $98 = $97 == 0;
          if ($98) { __label__ = 16; /* $99 */ break $6$2; }
          ;
        }
        ;
      }
      ;
      var $105 = $i;
      var $106 = $105 + 1;
      $i = $106;
      __label__ = 0; /* $6 */ continue $6$2;
    }
    if (__label__ == 2) {
      $1 = 0;
      ;
    }
    else if (__label__ == 3) {
      var $22 = $i;
      $1 = $22;
      ;
    }
    else if (__label__ == 24) {
      $1 = -1;
      ;
    }
    else if (__label__ == 20) {
      var $32 = $i;
      var $33 = $2;
      var $34 = $33+4*$32;
      var $35 = IHEAP[$34];
      var $36 = $35+2;
      var $37 = IHEAP[$36];
      var $38 = $37;
      var $39 = $38 != 0;
      ;
      if ($39) {
        ;
        $1 = -1;
        ;
      }
      else {
        ;
        var $42 = $i;
        var $43 = $42 + 1;
        var $44 = $2;
        var $45 = $44+4*$43;
        var $46 = IHEAP[$45];
        var $47 = $46 != 0;
        ;
        if ($47) {
          ;
          var $49 = $i;
          var $50 = $49 + 1;
          __lastLabel__ = 6; ;
        }
        else {
          ;
          __lastLabel__ = 8; ;
        }
        var $53 = __lastLabel__ == 6 ? $50 : (0);
        $1 = $53;
        ;
      }
    }
    else if (__label__ == 21) {
      var $55 = $i;
      $1 = $55;
      ;
    }
    else if (__label__ == 9) {
      $1 = -1;
      ;
    }
    else if (__label__ == 12) {
      $1 = -1;
      ;
    }
    else if (__label__ == 16) {
      $1 = -1;
      ;
    }
    var $109 = $1;
    ;
    return $109;
  }
  __Z11collectargsPPcPiS1_S1_.__index__ = Runtime.getFunctionIndex(__Z11collectargsPPcPiS1_S1_, "__Z11collectargsPPcPiS1_S1_");
  
  
  function __Z11print_usagev() {
    ;
    var __label__;
    var $1 = IHEAP[_stderr];
    var $2 = IHEAP[__ZL8progname];
    var $3 = _fprintf($1, __str23, $2);
    var $4 = IHEAP[_stderr];
    var $5 = _fflush($4);
    ;
    return;
  }
  __Z11print_usagev.__index__ = Runtime.getFunctionIndex(__Z11print_usagev, "__Z11print_usagev");
  
  
  function __Z13print_versionv() {
    ;
    var __label__;
    __Z9l_messagePKcS0_(0, __str22);
    ;
    return;
  }
  __Z13print_versionv.__index__ = Runtime.getFunctionIndex(__Z13print_versionv, "__Z13print_versionv");
  
  
  function __Z7runargsP9lua_StatePPci($L, $argv, $n) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $i;
    var $chunk;
    var $filename;
    $2 = $L;
    $3 = $argv;
    $4 = $n;
    $i = 1;
    ;
    $5$2: while(1) { // $5
      var $6 = $i;
      var $7 = $4;
      var $8 = $6 < $7;
      if (!($8)) { __label__ = 2; /* $75 */ break $5$2; }
      var $10 = $i;
      var $11 = $3;
      var $12 = $11+4*$10;
      var $13 = IHEAP[$12];
      var $14 = $13 == 0;
      ;
      if ($14) {
        ;
        ;
      }
      else {
        ;
        var $17 = $i;
        var $18 = $3;
        var $19 = $18+4*$17;
        var $20 = IHEAP[$19];
        var $21 = $20+1;
        var $22 = IHEAP[$21];
        var $23 = $22;
        if ($23 == 101) {
          __label__ = 12; /* $24 */ 
        }
        else if ($23 == 108) {
          __label__ = 13; /* $47 */ 
        }
        else {
        __label__ = 14; /* $70 */ 
        }
        
        if (__label__ == 14) {
          ;
        }
        else if (__label__ == 12) {
          var $25 = $i;
          var $26 = $3;
          var $27 = $26+4*$25;
          var $28 = IHEAP[$27];
          var $29 = $28+2;
          $chunk = $29;
          var $30 = $chunk;
          var $31 = IHEAP[$30];
          var $32 = $31;
          var $33 = $32 == 0;
          ;
          if ($33) {
            ;
            var $35 = $i;
            var $36 = $35 + 1;
            $i = $36;
            var $37 = $3;
            var $38 = $37+4*$36;
            var $39 = IHEAP[$38];
            $chunk = $39;
            ;
          }
          var $41 = $2;
          var $42 = $chunk;
          GLOBAL_L = $41; // XXX manually added for demo
          var $43 = __Z8dostringP9lua_StatePKcS2_($41, $42, __str20);
          var $44 = $43 != 0;
          if ($44) { __label__ = 5; /* $45 */ break $5$2; }
          ;
        }
        else if (__label__ == 13) {
          var $48 = $i;
          var $49 = $3;
          var $50 = $49+4*$48;
          var $51 = IHEAP[$50];
          var $52 = $51+2;
          $filename = $52;
          var $53 = $filename;
          var $54 = IHEAP[$53];
          var $55 = $54;
          var $56 = $55 == 0;
          ;
          if ($56) {
            ;
            var $58 = $i;
            var $59 = $58 + 1;
            $i = $59;
            var $60 = $3;
            var $61 = $60+4*$59;
            var $62 = IHEAP[$61];
            $filename = $62;
            ;
          }
          var $64 = $2;
          var $65 = $filename;
          var $66 = __Z9dolibraryP9lua_StatePKc($64, $65);
          var $67 = $66 != 0;
          if ($67) { __label__ = 10; /* $68 */ break $5$2; }
          ;
        }
        ;
      }
      var $73 = $i;
      var $74 = $73 + 1;
      $i = $74;
      __label__ = 0; /* $5 */ continue $5$2;
    }
    if (__label__ == 2) {
      $1 = 0;
      ;
    }
    else if (__label__ == 5) {
      $1 = 1;
      ;
    }
    else if (__label__ == 10) {
      $1 = 1;
      ;
    }
    var $77 = $1;
    ;
    return $77;
  }
  __Z7runargsP9lua_StatePPci.__index__ = Runtime.getFunctionIndex(__Z7runargsP9lua_StatePPci, "__Z7runargsP9lua_StatePPci");
  
  
  function __Z13handle_scriptP9lua_StatePPci($L, $argv, $n) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $status;
    var $fname;
    var $narg;
    $1 = $L;
    $2 = $argv;
    $3 = $n;
    var $4 = $1;
    var $5 = $2;
    var $6 = $3;
    var $7 = __Z7getargsP9lua_StatePPci($4, $5, $6);
    $narg = $7;
    var $8 = $1;
    __Z12lua_setfieldP9lua_StateiPKc($8, -10002, __str16);
    var $9 = $3;
    var $10 = $2;
    var $11 = $10+4*$9;
    var $12 = IHEAP[$11];
    $fname = $12;
    var $13 = $fname;
    var $14 = _strcmp($13, __str17);
    var $15 = $14 == 0;
    ;
    $16$25$2: do { 
      if ($15) {
        ;
        var $17 = $3;
        var $18 = $17 - 1;
        var $19 = $2;
        var $20 = $19+4*$18;
        var $21 = IHEAP[$20];
        var $22 = _strcmp($21, __str18);
        var $23 = $22 != 0;
        if (!($23)) { __label__ = 1; /* $25 */ break $16$25$2; }
        $fname = 0;
        ;
      }
    } while(0);
    var $26 = $1;
    var $27 = $fname;
    var $28 = __Z13luaL_loadfileP9lua_StatePKc($26, $27);
    $status = $28;
    var $29 = $1;
    var $30 = $narg;
    var $31 = $30 + 1;
    var $32 = 0 - $31;
    __Z10lua_insertP9lua_Statei($29, $32);
    var $33 = $status;
    var $34 = $33 == 0;
    ;
    if ($34) {
      ;
      var $36 = $1;
      var $37 = $narg;
      var $38 = __Z6docallP9lua_Stateii($36, $37, 0);
      $status = $38;
      ;
    }
    else {
      ;
      var $40 = $1;
      var $41 = $narg;
      var $42 = 0 - $41;
      var $43 = $42 - 1;
      __Z10lua_settopP9lua_Statei($40, $43);
      ;
    }
    var $45 = $1;
    var $46 = $status;
    var $47 = __Z6reportP9lua_Statei($45, $46);
    ;
    return $47;
  }
  __Z13handle_scriptP9lua_StatePPci.__index__ = Runtime.getFunctionIndex(__Z13handle_scriptP9lua_StatePPci, "__Z13handle_scriptP9lua_StatePPci");
  
  
  function __Z5dottyP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $status;
    var $oldprogname;
    $1 = $L;
    var $2 = IHEAP[__ZL8progname];
    $oldprogname = $2;
    IHEAP[__ZL8progname] = 0;
    ;
    $3$2: while(1) { // $3
      var $4 = $1;
      var $5 = __Z8loadlineP9lua_State($4);
      $status = $5;
      var $6 = $5 != -1;
      if (!($6)) { __label__ = 2; /* $40 */ break $3$2; }
      var $8 = $status;
      var $9 = $8 == 0;
      ;
      if ($9) {
        ;
        var $11 = $1;
        var $12 = __Z6docallP9lua_Stateii($11, 0, 0);
        $status = $12;
        ;
      }
      var $14 = $1;
      var $15 = $status;
      var $16 = __Z6reportP9lua_Statei($14, $15);
      var $17 = $status;
      var $18 = $17 == 0;
      ;
      $19$39$8: do { 
        if ($18) {
          ;
          var $20 = $1;
          var $21 = __Z10lua_gettopP9lua_State($20);
          var $22 = $21 > 0;
          if (!($22)) { __label__ = 5; /* $39 */ break $19$39$8; }
          var $24 = $1;
          __Z12lua_getfieldP9lua_StateiPKc($24, -10002, __str3);
          var $25 = $1;
          __Z10lua_insertP9lua_Statei($25, 1);
          var $26 = $1;
          var $27 = $1;
          var $28 = __Z10lua_gettopP9lua_State($27);
          var $29 = $28 - 1;
          var $30 = __Z9lua_pcallP9lua_Stateiii($26, $29, 0, 0);
          var $31 = $30 != 0;
          ;
          if ($31) {
            ;
            var $33 = IHEAP[__ZL8progname];
            var $34 = $1;
            var $35 = $1;
            var $36 = __Z13lua_tolstringP9lua_StateiPj($35, -1, 0);
            var $37 = __Z15lua_pushfstringP9lua_StatePKcz($34, __str4, Pointer_make([$36,0,0,0], 0, ALLOC_STACK));
            __Z9l_messagePKcS0_($33, $37);
            ;
          }
          ;
        }
      } while(0);
      __label__ = 0; /* $3 */ continue $3$2;
    }
    var $41 = $1;
    __Z10lua_settopP9lua_Statei($41, 0);
    var $42 = IHEAP[_stdout];
    var $43 = _fputs(__str5, $42);
    var $44 = IHEAP[_stdout];
    var $45 = _fflush($44);
    var $46 = $oldprogname;
    IHEAP[__ZL8progname] = $46;
    ;
    return;
  }
  __Z5dottyP9lua_State.__index__ = Runtime.getFunctionIndex(__Z5dottyP9lua_State, "__Z5dottyP9lua_State");
  
  
  function __Z8loadlineP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $2;
    var $status;
    $2 = $L;
    var $3 = $2;
    __Z10lua_settopP9lua_Statei($3, 0);
    var $4 = $2;
    var $5 = __Z8pushlineP9lua_Statei($4, 1);
    var $6 = $5 != 0;
    ;
    if ($6) {
      ;
      ;
      $9$4: while(1) { // $9
        var $10 = $2;
        var $11 = $2;
        var $12 = __Z13lua_tolstringP9lua_StateiPj($11, 1, 0);
        var $13 = $2;
        var $14 = __Z10lua_objlenP9lua_Statei($13, 1);
        var $15 = __Z15luaL_loadbufferP9lua_StatePKcjS2_($10, $12, $14, __str9);
        $status = $15;
        var $16 = $2;
        var $17 = $status;
        var $18 = __Z10incompleteP9lua_Statei($16, $17);
        var $19 = $18 != 0;
        if (!($19)) { __label__ = 3; /* $20 */ break $9$4; }
        var $22 = $2;
        var $23 = __Z8pushlineP9lua_Statei($22, 0);
        var $24 = $23 != 0;
        if (!($24)) { __label__ = 6; /* $25 */ break $9$4; }
        var $27 = $2;
        __Z15lua_pushlstringP9lua_StatePKcj($27, __str5, 1);
        var $28 = $2;
        __Z10lua_insertP9lua_Statei($28, -2);
        var $29 = $2;
        __Z10lua_concatP9lua_Statei($29, 3);
        __label__ = 1; /* $9 */ continue $9$4;
      }
      if (__label__ == 3) {
        ;
        var $31 = $2;
        __Z10lua_removeP9lua_Statei($31, 1);
        var $32 = $status;
        $1 = $32;
        ;
      }
      else if (__label__ == 6) {
        $1 = -1;
        ;
      }
    }
    else {
      ;
      $1 = -1;
      ;
    }
    var $34 = $1;
    ;
    return $34;
  }
  __Z8loadlineP9lua_State.__index__ = Runtime.getFunctionIndex(__Z8loadlineP9lua_State, "__Z8loadlineP9lua_State");
  
  
  function __Z6docallP9lua_Stateii($L, $narg, $clear) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $status;
    var $base;
    $1 = $L;
    $2 = $narg;
    $3 = $clear;
    var $4 = $1;
    var $5 = __Z10lua_gettopP9lua_State($4);
    var $6 = $2;
    var $7 = $5 - $6;
    $base = $7;
    var $8 = $1;
    __Z16lua_pushcclosureP9lua_StatePFiS0_Ei($8, __Z9tracebackP9lua_State.__index__, 0);
    var $9 = $1;
    var $10 = $base;
    __Z10lua_insertP9lua_Statei($9, $10);
    var $11 = _signal(2, __Z7lactioni.__index__);
    var $12 = $1;
    var $13 = $2;
    var $14 = $3;
    var $15 = $14 != 0;
    ;
    if ($15) {
      ;
      __lastLabel__ = 0; ;
    }
    else {
      ;
      __lastLabel__ = 2; ;
    }
    var $19 = __lastLabel__ == 0 ? 0 : (-1);
    var $20 = $base;
    var $21 = __Z9lua_pcallP9lua_Stateiii($12, $13, $19, $20);
    $status = $21;
    var $22 = _signal(2, 0);
    var $23 = $1;
    var $24 = $base;
    __Z10lua_removeP9lua_Statei($23, $24);
    var $25 = $status;
    var $26 = $25 != 0;
    ;
    if ($26) {
      ;
      var $28 = $1;
      var $29 = __Z6lua_gcP9lua_Stateii($28, 2, 0);
      ;
    }
    var $31 = $status;
    ;
    return $31;
  }
  __Z6docallP9lua_Stateii.__index__ = Runtime.getFunctionIndex(__Z6docallP9lua_Stateii, "__Z6docallP9lua_Stateii");
  
  
  function __Z9tracebackP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $2;
    $2 = $L;
    var $3 = $2;
    var $4 = __Z12lua_isstringP9lua_Statei($3, 1);
    var $5 = $4 != 0;
    ;
    if ($5) {
      ;
      var $8 = $2;
      __Z12lua_getfieldP9lua_StateiPKc($8, -10002, __str7);
      var $9 = $2;
      var $10 = __Z8lua_typeP9lua_Statei($9, -1);
      var $11 = $10 == 5;
      ;
      if ($11) {
        ;
        var $15 = $2;
        __Z12lua_getfieldP9lua_StateiPKc($15, -1, __str8);
        var $16 = $2;
        var $17 = __Z8lua_typeP9lua_Statei($16, -1);
        var $18 = $17 == 6;
        ;
        if ($18) {
          ;
          var $22 = $2;
          __Z13lua_pushvalueP9lua_Statei($22, 1);
          var $23 = $2;
          __Z15lua_pushintegerP9lua_Statei($23, 2);
          var $24 = $2;
          __Z8lua_callP9lua_Stateii($24, 2, 1);
          $1 = 1;
          ;
        }
        else {
          ;
          var $20 = $2;
          __Z10lua_settopP9lua_Statei($20, -3);
          $1 = 1;
          ;
        }
      }
      else {
        ;
        var $13 = $2;
        __Z10lua_settopP9lua_Statei($13, -2);
        $1 = 1;
        ;
      }
    }
    else {
      ;
      $1 = 1;
      ;
    }
    var $26 = $1;
    ;
    return $26;
  }
  __Z9tracebackP9lua_State.__index__ = Runtime.getFunctionIndex(__Z9tracebackP9lua_State, "__Z9tracebackP9lua_State");
  
  
  function __Z7lactioni($i) {
    ;
    var __label__;
    var $1;
    $1 = $i;
    var $2 = $1;
    var $3 = _signal($2, 0);
    var $4 = IHEAP[__ZL7globalL];
    var $5 = __Z11lua_sethookP9lua_StatePFvS0_P9lua_DebugEii($4, __Z5lstopP9lua_StateP9lua_Debug.__index__, 11, 1);
    ;
    return;
  }
  __Z7lactioni.__index__ = Runtime.getFunctionIndex(__Z7lactioni, "__Z7lactioni");
  
  
  function __Z5lstopP9lua_StateP9lua_Debug($L, $ar) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $L;
    $2 = $ar;
    var $3 = $1;
    var $4 = __Z11lua_sethookP9lua_StatePFvS0_P9lua_DebugEii($3, 0, 0, 0);
    var $5 = $1;
    var $6 = __Z10luaL_errorP9lua_StatePKcz($5, __str6);
    ;
    return;
  }
  __Z5lstopP9lua_StateP9lua_Debug.__index__ = Runtime.getFunctionIndex(__Z5lstopP9lua_StateP9lua_Debug, "__Z5lstopP9lua_StateP9lua_Debug");
  
  
  function __Z8pushlineP9lua_Statei($L, $firstline) {
    var __stackBase__  = STACKTOP; STACKTOP += 512; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $buffer = __stackBase__;
    var $b;
    var $l;
    var $prmt;
    $2 = $L;
    $3 = $firstline;
    var $4 = $buffer;
    $b = $4;
    var $5 = $2;
    var $6 = $3;
    var $7 = __Z10get_promptP9lua_Statei($5, $6);
    $prmt = $7;
    var $8 = $prmt;
    var $9 = IHEAP[_stdout];
    var $10 = _fputs($8, $9);
    var $11 = IHEAP[_stdout];
    var $12 = _fflush($11);
    var $13 = $b;
    var $14 = IHEAP[_stdin];
    var $15 = _fgets($13, 512, $14);
    var $16 = $15 != 0;
    var $17 = $16;
    var $18 = $17 == 0;
    ;
    if ($18) {
      ;
      $1 = 0;
      ;
    }
    else {
      ;
      var $21 = $b;
      var $22 = _strlen($21);
      $l = $22;
      var $23 = $l;
      var $24 = unSign($23, 32) > unSign(0, 32);
      ;
      $25$38$5: do { 
        if ($24) {
          ;
          var $26 = $l;
          var $27 = $26 - 1;
          var $28 = $b;
          var $29 = $28+$27;
          var $30 = IHEAP[$29];
          var $31 = $30;
          var $32 = $31 == 10;
          if (!($32)) { __label__ = 2; /* $38 */ break $25$38$5; }
          var $34 = $l;
          var $35 = $34 - 1;
          var $36 = $b;
          var $37 = $36+$35;
          IHEAP[$37] = 0;
          ;
        }
      } while(0);
      var $39 = $3;
      var $40 = $39 != 0;
      ;
      $41$52$9: do { 
        if ($40) {
          ;
          var $42 = $b;
          var $43 = $42;
          var $44 = IHEAP[$43];
          var $45 = $44;
          var $46 = $45 == 61;
          if (!($46)) { __label__ = 5; /* $52 */ break $41$52$9; }
          var $48 = $2;
          var $49 = $b;
          var $50 = $49+1;
          var $51 = __Z15lua_pushfstringP9lua_StatePKcz($48, __str11, Pointer_make([$50,0,0,0], 0, ALLOC_STACK));
          __label__ = 6; /* $55 */ break $41$52$9;
        }
        else {
          __label__ = 5; /* $52 */ 
        }
      } while(0);
      if (__label__ == 5) {
        var $53 = $2;
        var $54 = $b;
        __Z14lua_pushstringP9lua_StatePKc($53, $54);
        ;
      }
      $1 = 1;
      ;
    }
    var $57 = $1;
    STACKTOP = __stackBase__;
    return $57;
  }
  __Z8pushlineP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z8pushlineP9lua_Statei, "__Z8pushlineP9lua_Statei");
  
  
  function __Z10incompleteP9lua_Statei($L, $status) {
    var __stackBase__  = STACKTOP; STACKTOP += 4; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $lmsg = __stackBase__;
    var $msg;
    var $tp;
    $2 = $L;
    $3 = $status;
    var $4 = $3;
    var $5 = $4 == 3;
    ;
    $6$20$2: do { 
      if ($5) {
        ;
        var $7 = $2;
        var $8 = __Z13lua_tolstringP9lua_StateiPj($7, -1, $lmsg);
        $msg = $8;
        var $9 = $msg;
        var $10 = IHEAP[$lmsg];
        var $11 = $9+$10;
        var $12 = $11+-7;
        $tp = $12;
        var $13 = $msg;
        var $14 = _strstr($13, __str10);
        var $15 = $tp;
        var $16 = $14 == $15;
        ;
        if ($16) {
          ;
          var $18 = $2;
          __Z10lua_settopP9lua_Statei($18, -2);
          $1 = 1;
          __label__ = 0; /* $21 */ break $6$20$2;
        }
        else {
          ;
          __label__ = 1; /* $20 */ break $6$20$2;
        }
      }
      else {
        __label__ = 1; /* $20 */ 
      }
    } while(0);
    if (__label__ == 1) {
      $1 = 0;
      ;
    }
    var $22 = $1;
    STACKTOP = __stackBase__;
    return $22;
  }
  __Z10incompleteP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z10incompleteP9lua_Statei, "__Z10incompleteP9lua_Statei");
  
  
  function __Z10get_promptP9lua_Statei($L, $firstline) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $p;
    $1 = $L;
    $2 = $firstline;
    var $3 = $1;
    var $4 = $2;
    var $5 = $4 != 0;
    ;
    if ($5) {
      ;
      __lastLabel__ = 0; ;
    }
    else {
      ;
      __lastLabel__ = 2; ;
    }
    var $9 = __lastLabel__ == 0 ? __str12 : (__str13);
    __Z12lua_getfieldP9lua_StateiPKc($3, -10002, $9);
    var $10 = $1;
    var $11 = __Z13lua_tolstringP9lua_StateiPj($10, -1, 0);
    $p = $11;
    var $12 = $p;
    var $13 = $12 == 0;
    ;
    if ($13) {
      ;
      var $15 = $2;
      var $16 = $15 != 0;
      ;
      if ($16) {
        ;
        __lastLabel__ = 3; ;
      }
      else {
        ;
        __lastLabel__ = 5; ;
      }
      var $20 = __lastLabel__ == 3 ? __str14 : (__str15);
      $p = $20;
      ;
    }
    var $22 = $1;
    __Z10lua_settopP9lua_Statei($22, -2);
    var $23 = $p;
    ;
    return $23;
  }
  __Z10get_promptP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z10get_promptP9lua_Statei, "__Z10get_promptP9lua_Statei");
  
  
  function __Z7getargsP9lua_StatePPci($L, $argv, $n) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $narg;
    var $i;
    var $argc;
    $1 = $L;
    $2 = $argv;
    $3 = $n;
    $argc = 0;
    ;
    $4$2: while(1) { // $4
      var $5 = $argc;
      var $6 = $2;
      var $7 = $6+4*$5;
      var $8 = IHEAP[$7];
      var $9 = $8 != 0;
      if (!($9)) { __label__ = 2; /* $13 */ break $4$2; }
      var $11 = $argc;
      var $12 = $11 + 1;
      $argc = $12;
      __label__ = 0; /* $4 */ continue $4$2;
    }
    var $14 = $argc;
    var $15 = $3;
    var $16 = $15 + 1;
    var $17 = $14 - $16;
    $narg = $17;
    var $18 = $1;
    var $19 = $narg;
    var $20 = $19 + 3;
    __Z15luaL_checkstackP9lua_StateiPKc($18, $20, __str19);
    var $21 = $3;
    var $22 = $21 + 1;
    $i = $22;
    ;
    $23$6: while(1) { // $23
      var $24 = $i;
      var $25 = $argc;
      var $26 = $24 < $25;
      if (!($26)) { __label__ = 5; /* $36 */ break $23$6; }
      var $28 = $1;
      var $29 = $i;
      var $30 = $2;
      var $31 = $30+4*$29;
      var $32 = IHEAP[$31];
      __Z14lua_pushstringP9lua_StatePKc($28, $32);
      ;
      var $34 = $i;
      var $35 = $34 + 1;
      $i = $35;
      __label__ = 3; /* $23 */ continue $23$6;
    }
    var $37 = $1;
    var $38 = $narg;
    var $39 = $3;
    var $40 = $39 + 1;
    __Z15lua_createtableP9lua_Stateii($37, $38, $40);
    $i = 0;
    ;
    $41$11: while(1) { // $41
      var $42 = $i;
      var $43 = $argc;
      var $44 = $42 < $43;
      if (!($44)) { __label__ = 9; /* $58 */ break $41$11; }
      var $46 = $1;
      var $47 = $i;
      var $48 = $2;
      var $49 = $48+4*$47;
      var $50 = IHEAP[$49];
      __Z14lua_pushstringP9lua_StatePKc($46, $50);
      var $51 = $1;
      var $52 = $i;
      var $53 = $3;
      var $54 = $52 - $53;
      __Z11lua_rawsetiP9lua_Stateii($51, -2, $54);
      ;
      var $56 = $i;
      var $57 = $56 + 1;
      $i = $57;
      __label__ = 7; /* $41 */ continue $41$11;
    }
    var $59 = $narg;
    ;
    return $59;
  }
  __Z7getargsP9lua_StatePPci.__index__ = Runtime.getFunctionIndex(__Z7getargsP9lua_StatePPci, "__Z7getargsP9lua_StatePPci");
  
  
  function __Z8dostringP9lua_StatePKcS2_($L, $s, $name) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $status;
    $1 = $L;
    $2 = $s;
    $3 = $name;
    var $4 = $1;
    var $5 = $2;
    var $6 = $2;
    var $7 = _strlen($6);
    var $8 = $3;
    var $9 = __Z15luaL_loadbufferP9lua_StatePKcjS2_($4, $5, $7, $8);
    var $10 = $9 != 0;
    ;
    if ($10) {
      __lastLabel__ = 2; ;
    }
    else {
      __lastLabel__ = 2; ;
      var $12 = $1;
      var $13 = __Z6docallP9lua_Stateii($12, 0, 1);
      var $14 = $13 != 0;
      __lastLabel__ = 0; ;
    }
    var $16 = __lastLabel__ == 2 ? 1 : ($14);
    var $17 = $16;
    $status = $17;
    var $18 = $1;
    var $19 = $status;
    var $20 = __Z6reportP9lua_Statei($18, $19);
    ;
    return $20;
  }
  __Z8dostringP9lua_StatePKcS2_.__index__ = Runtime.getFunctionIndex(__Z8dostringP9lua_StatePKcS2_, "__Z8dostringP9lua_StatePKcS2_");
  
  
  function __Z9dolibraryP9lua_StatePKc($L, $name) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $L;
    $2 = $name;
    var $3 = $1;
    __Z12lua_getfieldP9lua_StateiPKc($3, -10002, __str21);
    var $4 = $1;
    var $5 = $2;
    __Z14lua_pushstringP9lua_StatePKc($4, $5);
    var $6 = $1;
    var $7 = $1;
    var $8 = __Z6docallP9lua_Stateii($7, 1, 1);
    var $9 = __Z6reportP9lua_Statei($6, $8);
    ;
    return $9;
  }
  __Z9dolibraryP9lua_StatePKc.__index__ = Runtime.getFunctionIndex(__Z9dolibraryP9lua_StatePKc, "__Z9dolibraryP9lua_StatePKc");
  
  
  function __Z6dofileP9lua_StatePKc($L, $name) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $status;
    $1 = $L;
    $2 = $name;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z13luaL_loadfileP9lua_StatePKc($3, $4);
    var $6 = $5 != 0;
    ;
    if ($6) {
      __lastLabel__ = 2; ;
    }
    else {
      __lastLabel__ = 2; ;
      var $8 = $1;
      var $9 = __Z6docallP9lua_Stateii($8, 0, 1);
      var $10 = $9 != 0;
      __lastLabel__ = 0; ;
    }
    var $12 = __lastLabel__ == 2 ? 1 : ($10);
    var $13 = $12;
    $status = $13;
    var $14 = $1;
    var $15 = $status;
    var $16 = __Z6reportP9lua_Statei($14, $15);
    ;
    return $16;
  }
  __Z6dofileP9lua_StatePKc.__index__ = Runtime.getFunctionIndex(__Z6dofileP9lua_StatePKc, "__Z6dofileP9lua_StatePKc");
  
  
  function __Z15luaA_pushobjectP9lua_StatePK10lua_TValue($L, $o) {
    ;
    var __label__;
    var $1;
    var $2;
    var $o2;
    var $o1;
    $1 = $L;
    $2 = $o;
    var $3 = $2;
    $o2 = $3;
    var $4 = $1;
    var $5 = $4+8;
    var $6 = IHEAP[$5];
    $o1 = $6;
    var $7 = $o1;
    var $8 = $7;
    var $9 = $o2;
    var $10 = $9;
    var $11 = $8;
    var $12 = $10;
    _llvm_memcpy_p0i8_p0i8_i32($11, $12, 8, 4, 0);
    var $13 = $o2;
    var $14 = $13+8;
    var $15 = IHEAP[$14];
    var $16 = $o1;
    var $17 = $16+8;
    IHEAP[$17] = $15;
    var $18 = $1;
    var $19 = $18+8;
    var $20 = IHEAP[$19];
    var $21 = $20+12;
    IHEAP[$19] = $21;
    ;
    return;
  }
  __Z15luaA_pushobjectP9lua_StatePK10lua_TValue.__index__ = Runtime.getFunctionIndex(__Z15luaA_pushobjectP9lua_StatePK10lua_TValue, "__Z15luaA_pushobjectP9lua_StatePK10lua_TValue");
  
  
  function __Z14lua_checkstackP9lua_Statei($L, $size) {
    ;
    var __label__;
    var $1;
    var $2;
    var $res;
    $1 = $L;
    $2 = $size;
    $res = 1;
    var $3 = $2;
    var $4 = $3 > 8000;
    ;
    $19$5$2: do { 
      if ($4) {
        __label__ = 0; /* $19 */ 
      }
      else {
        ;
        var $6 = $1;
        var $7 = $6+8;
        var $8 = IHEAP[$7];
        var $9 = $1;
        var $10 = $9+12;
        var $11 = IHEAP[$10];
        var $12 = $8;
        var $13 = $11;
        var $14 = $12 - $13;
        var $15 = Math.floor($14 / 12);
        var $16 = $2;
        var $17 = $15 + $16;
        var $18 = $17 > 8000;
        if ($18) { __label__ = 0; /* $19 */ break $19$5$2; }
        var $21 = $2;
        var $22 = $21 > 0;
        ;
        if ($22) {
          ;
          var $24 = $1;
          var $25 = $24+28;
          var $26 = IHEAP[$25];
          var $27 = $26;
          var $28 = $1;
          var $29 = $28+8;
          var $30 = IHEAP[$29];
          var $31 = $30;
          var $32 = $27;
          var $33 = $31;
          var $34 = $32 - $33;
          var $35 = $2;
          var $36 = $35 * 12;
          var $37 = $34 <= $36;
          ;
          if ($37) {
            ;
            var $39 = $1;
            var $40 = $2;
            __Z14luaD_growstackP9lua_Statei($39, $40);
            ;
          }
          else {
            ;
            ;
          }
          var $43 = $1;
          var $44 = $43+20;
          var $45 = IHEAP[$44];
          var $46 = $45+8;
          var $47 = IHEAP[$46];
          var $48 = $1;
          var $49 = $48+8;
          var $50 = IHEAP[$49];
          var $51 = $2;
          var $52 = $50+12*$51;
          var $53 = $47 < $52;
          ;
          if ($53) {
            ;
            var $55 = $1;
            var $56 = $55+8;
            var $57 = IHEAP[$56];
            var $58 = $2;
            var $59 = $57+12*$58;
            var $60 = $1;
            var $61 = $60+20;
            var $62 = IHEAP[$61];
            var $63 = $62+8;
            IHEAP[$63] = $59;
            ;
          }
          ;
        }
        __label__ = 6; /* $66 */ break $19$5$2;
      }
    } while(0);
    if (__label__ == 0) {
      $res = 0;
      ;
    }
    var $67 = $res;
    ;
    return $67;
  }
  __Z14lua_checkstackP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z14lua_checkstackP9lua_Statei, "__Z14lua_checkstackP9lua_Statei");
  
  
  function __Z9lua_xmoveP9lua_StateS0_i($from, $to, $n) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $i;
    var $o2;
    var $o1;
    $1 = $from;
    $2 = $to;
    $3 = $n;
    var $4 = $1;
    var $5 = $2;
    var $6 = $4 == $5;
    ;
    $7$8$2: do { 
      if ($6) {
        ;
        ;
      }
      else {
        ;
        var $9 = $3;
        var $10 = $1;
        var $11 = $10+8;
        var $12 = IHEAP[$11];
        var $13 = 0 - $9;
        var $14 = $12+12*$13;
        IHEAP[$11] = $14;
        $i = 0;
        ;
        $15$5: while(1) { // $15
          var $16 = $i;
          var $17 = $3;
          var $18 = $16 < $17;
          if (!($18)) { __label__ = 3; /* $43 */ break $7$8$2; }
          var $20 = $1;
          var $21 = $20+8;
          var $22 = IHEAP[$21];
          var $23 = $i;
          var $24 = $22+12*$23;
          $o2 = $24;
          var $25 = $2;
          var $26 = $25+8;
          var $27 = IHEAP[$26];
          var $28 = $27+12;
          IHEAP[$26] = $28;
          $o1 = $27;
          var $29 = $o1;
          var $30 = $29;
          var $31 = $o2;
          var $32 = $31;
          var $33 = $30;
          var $34 = $32;
          _llvm_memcpy_p0i8_p0i8_i32($33, $34, 8, 4, 0);
          var $35 = $o2;
          var $36 = $35+8;
          var $37 = IHEAP[$36];
          var $38 = $o1;
          var $39 = $38+8;
          IHEAP[$39] = $37;
          ;
          var $41 = $i;
          var $42 = $41 + 1;
          $i = $42;
          __label__ = 1; /* $15 */ continue $15$5;
        }
      }
    } while(0);
    ;
    return;
  }
  __Z9lua_xmoveP9lua_StateS0_i.__index__ = Runtime.getFunctionIndex(__Z9lua_xmoveP9lua_StateS0_i, "__Z9lua_xmoveP9lua_StateS0_i");
  
  
  function __Z12lua_setlevelP9lua_StateS0_($from, $to) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $from;
    $2 = $to;
    var $3 = $1;
    var $4 = $3+52;
    var $5 = IHEAP[$4];
    var $6 = $2;
    var $7 = $6+52;
    IHEAP[$7] = $5;
    ;
    return;
  }
  __Z12lua_setlevelP9lua_StateS0_.__index__ = Runtime.getFunctionIndex(__Z12lua_setlevelP9lua_StateS0_, "__Z12lua_setlevelP9lua_StateS0_");
  
  
  function __Z11lua_atpanicP9lua_StatePFiS0_E($L, $panicf) {
    ;
    var __label__;
    var $1;
    var $2;
    var $old;
    $1 = $L;
    $2 = $panicf;
    var $3 = $1;
    var $4 = $3+16;
    var $5 = IHEAP[$4];
    var $6 = $5+88;
    var $7 = IHEAP[$6];
    $old = $7;
    var $8 = $2;
    var $9 = $1;
    var $10 = $9+16;
    var $11 = IHEAP[$10];
    var $12 = $11+88;
    IHEAP[$12] = $8;
    var $13 = $old;
    ;
    return $13;
  }
  __Z11lua_atpanicP9lua_StatePFiS0_E.__index__ = Runtime.getFunctionIndex(__Z11lua_atpanicP9lua_StatePFiS0_E, "__Z11lua_atpanicP9lua_StatePFiS0_E");
  
  
  function __Z13lua_newthreadP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $L1;
    var $i_o;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+16;
    var $4 = IHEAP[$3];
    var $5 = $4+68;
    var $6 = IHEAP[$5];
    var $7 = $1;
    var $8 = $7+16;
    var $9 = IHEAP[$8];
    var $10 = $9+64;
    var $11 = IHEAP[$10];
    var $12 = unSign($6, 32) >= unSign($11, 32);
    ;
    if ($12) {
      ;
      var $14 = $1;
      __Z9luaC_stepP9lua_State($14);
      ;
    }
    var $16 = $1;
    var $17 = __Z14luaE_newthreadP9lua_State($16);
    $L1 = $17;
    var $18 = $1;
    var $19 = $18+8;
    var $20 = IHEAP[$19];
    $i_o = $20;
    var $21 = $L1;
    var $22 = $21;
    var $23 = $i_o;
    var $24 = $23;
    var $25 = $24;
    var $26 = $25;
    IHEAP[$26] = $22;
    var $27 = $i_o;
    var $28 = $27+8;
    IHEAP[$28] = 8;
    var $29 = $1;
    var $30 = $29+8;
    var $31 = IHEAP[$30];
    var $32 = $31+12;
    IHEAP[$30] = $32;
    var $33 = $L1;
    ;
    return $33;
  }
  __Z13lua_newthreadP9lua_State.__index__ = Runtime.getFunctionIndex(__Z13lua_newthreadP9lua_State, "__Z13lua_newthreadP9lua_State");
  
  
  function __Z10lua_gettopP9lua_State($L) {
    ;
    var __label__;
    var $1;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+8;
    var $4 = IHEAP[$3];
    var $5 = $1;
    var $6 = $5+12;
    var $7 = IHEAP[$6];
    var $8 = $4;
    var $9 = $7;
    var $10 = $8 - $9;
    var $11 = Math.floor($10 / 12);
    ;
    return $11;
  }
  __Z10lua_gettopP9lua_State.__index__ = Runtime.getFunctionIndex(__Z10lua_gettopP9lua_State, "__Z10lua_gettopP9lua_State");
  
  
  function __Z10lua_settopP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $L;
    $2 = $idx;
    var $3 = $2;
    var $4 = $3 >= 0;
    ;
    if ($4) {
      ;
      ;
      $6$4: while(1) { // $6
        var $7 = $1;
        var $8 = $7+8;
        var $9 = IHEAP[$8];
        var $10 = $1;
        var $11 = $10+12;
        var $12 = IHEAP[$11];
        var $13 = $2;
        var $14 = $12+12*$13;
        var $15 = $9 < $14;
        if (!($15)) { __label__ = 2; /* $22 */ break $6$4; }
        var $17 = $1;
        var $18 = $17+8;
        var $19 = IHEAP[$18];
        var $20 = $19+12;
        IHEAP[$18] = $20;
        var $21 = $19+8;
        IHEAP[$21] = 0;
        __label__ = 0; /* $6 */ continue $6$4;
      }
      var $23 = $1;
      var $24 = $23+12;
      var $25 = IHEAP[$24];
      var $26 = $2;
      var $27 = $25+12*$26;
      var $28 = $1;
      var $29 = $28+8;
      IHEAP[$29] = $27;
      ;
    }
    else {
      ;
      var $31 = $2;
      var $32 = $31 + 1;
      var $33 = $1;
      var $34 = $33+8;
      var $35 = IHEAP[$34];
      var $36 = $35+12*$32;
      IHEAP[$34] = $36;
      ;
    }
    ;
    return;
  }
  __Z10lua_settopP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z10lua_settopP9lua_Statei, "__Z10lua_settopP9lua_Statei");
  
  
  function __Z10lua_removeP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var $1;
    var $2;
    var $p;
    var $o2;
    var $o1;
    $1 = $L;
    $2 = $idx;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z9index2adrP9lua_Statei($3, $4);
    $p = $5;
    ;
    $6$2: while(1) { // $6
      var $7 = $p;
      var $8 = $7+12;
      $p = $8;
      var $9 = $1;
      var $10 = $9+8;
      var $11 = IHEAP[$10];
      var $12 = $8 < $11;
      if (!($12)) { __label__ = 2; /* $28 */ break $6$2; }
      var $14 = $p;
      $o2 = $14;
      var $15 = $p;
      var $16 = $15+-12;
      $o1 = $16;
      var $17 = $o1;
      var $18 = $17;
      var $19 = $o2;
      var $20 = $19;
      var $21 = $18;
      var $22 = $20;
      _llvm_memcpy_p0i8_p0i8_i32($21, $22, 8, 4, 0);
      var $23 = $o2;
      var $24 = $23+8;
      var $25 = IHEAP[$24];
      var $26 = $o1;
      var $27 = $26+8;
      IHEAP[$27] = $25;
      __label__ = 0; /* $6 */ continue $6$2;
    }
    var $29 = $1;
    var $30 = $29+8;
    var $31 = IHEAP[$30];
    var $32 = $31+-12;
    IHEAP[$30] = $32;
    ;
    return;
  }
  __Z10lua_removeP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z10lua_removeP9lua_Statei, "__Z10lua_removeP9lua_Statei");
  
  
  function __Z9index2adrP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $o;
    var $func;
    var $i_o;
    var $func1;
    $2 = $L;
    $3 = $idx;
    var $4 = $3;
    var $5 = $4 > 0;
    ;
    if ($5) {
      ;
      var $7 = $2;
      var $8 = $7+12;
      var $9 = IHEAP[$8];
      var $10 = $3;
      var $11 = $10 - 1;
      var $12 = $9+12*$11;
      $o = $12;
      var $13 = $o;
      var $14 = $2;
      var $15 = $14+8;
      var $16 = IHEAP[$15];
      var $17 = $13 >= $16;
      ;
      if ($17) {
        ;
        $1 = _luaO_nilobject_;
        ;
      }
      else {
        ;
        var $20 = $o;
        $1 = $20;
        ;
      }
    }
    else {
      ;
      var $22 = $3;
      var $23 = $22 > -10000;
      ;
      if ($23) {
        ;
        var $25 = $2;
        var $26 = $25+8;
        var $27 = IHEAP[$26];
        var $28 = $3;
        var $29 = $27+12*$28;
        $1 = $29;
        ;
      }
      else {
        ;
        var $31 = $3;
        if ($31 == -10000) {
          __label__ = 4; /* $32 */ 
        }
        else if ($31 == -10001) {
          __label__ = 5; /* $37 */ 
        }
        else if ($31 == -10002) {
          __label__ = 6; /* $64 */ 
        }
        else {
        __label__ = 7; /* $67 */ 
        }
        
        if (__label__ == 7) {
          var $68 = $2;
          var $69 = $68+20;
          var $70 = IHEAP[$69];
          var $71 = $70+4;
          var $72 = IHEAP[$71];
          var $73 = $72;
          var $74 = $73;
          var $75 = $74;
          var $76 = IHEAP[$75];
          var $77 = $76;
          var $78 = $77;
          $func1 = $78;
          var $79 = $3;
          var $80 = -10002 - $79;
          $3 = $80;
          var $81 = $3;
          var $82 = $func1;
          var $83 = $82;
          var $84 = $83+7;
          var $85 = IHEAP[$84];
          var $86 = $85;
          var $87 = $81 <= $86;
          ;
          if ($87) {
            ;
            var $89 = $3;
            var $90 = $89 - 1;
            var $91 = $func1;
            var $92 = $91;
            var $93 = $92+20;
            var $94 = $93+$90*12;
            __lastLabel__ = 1; ;
          }
          else {
            ;
            __lastLabel__ = 3; ;
          }
          var $97 = __lastLabel__ == 1 ? $94 : (_luaO_nilobject_);
          $1 = $97;
          ;
        }
        else if (__label__ == 4) {
          var $33 = $2;
          var $34 = $33+16;
          var $35 = IHEAP[$34];
          var $36 = $35+92;
          $1 = $36;
          ;
        }
        else if (__label__ == 5) {
          var $38 = $2;
          var $39 = $38+20;
          var $40 = IHEAP[$39];
          var $41 = $40+4;
          var $42 = IHEAP[$41];
          var $43 = $42;
          var $44 = $43;
          var $45 = $44;
          var $46 = IHEAP[$45];
          var $47 = $46;
          var $48 = $47;
          $func = $48;
          var $49 = $2;
          var $50 = $49+84;
          $i_o = $50;
          var $51 = $func;
          var $52 = $51;
          var $53 = $52+12;
          var $54 = IHEAP[$53];
          var $55 = $54;
          var $56 = $i_o;
          var $57 = $56;
          var $58 = $57;
          var $59 = $58;
          IHEAP[$59] = $55;
          var $60 = $i_o;
          var $61 = $60+8;
          IHEAP[$61] = 5;
          var $62 = $2;
          var $63 = $62+84;
          $1 = $63;
          ;
        }
        else if (__label__ == 6) {
          var $65 = $2;
          var $66 = $65+72;
          $1 = $66;
          ;
        }
      }
    }
    var $99 = $1;
    ;
    return $99;
  }
  __Z9index2adrP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z9index2adrP9lua_Statei, "__Z9index2adrP9lua_Statei");
  
  
  function __Z10lua_insertP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var $1;
    var $2;
    var $p;
    var $q;
    var $o2;
    var $o1;
    var $o21;
    var $o12;
    $1 = $L;
    $2 = $idx;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z9index2adrP9lua_Statei($3, $4);
    $p = $5;
    var $6 = $1;
    var $7 = $6+8;
    var $8 = IHEAP[$7];
    $q = $8;
    ;
    $9$2: while(1) { // $9
      var $10 = $q;
      var $11 = $p;
      var $12 = $10 > $11;
      if (!($12)) { __label__ = 2; /* $31 */ break $9$2; }
      var $14 = $q;
      var $15 = $14+-12;
      $o2 = $15;
      var $16 = $q;
      $o1 = $16;
      var $17 = $o1;
      var $18 = $17;
      var $19 = $o2;
      var $20 = $19;
      var $21 = $18;
      var $22 = $20;
      _llvm_memcpy_p0i8_p0i8_i32($21, $22, 8, 4, 0);
      var $23 = $o2;
      var $24 = $23+8;
      var $25 = IHEAP[$24];
      var $26 = $o1;
      var $27 = $26+8;
      IHEAP[$27] = $25;
      ;
      var $29 = $q;
      var $30 = $29+-12;
      $q = $30;
      __label__ = 0; /* $9 */ continue $9$2;
    }
    var $32 = $1;
    var $33 = $32+8;
    var $34 = IHEAP[$33];
    $o21 = $34;
    var $35 = $p;
    $o12 = $35;
    var $36 = $o12;
    var $37 = $36;
    var $38 = $o21;
    var $39 = $38;
    var $40 = $37;
    var $41 = $39;
    _llvm_memcpy_p0i8_p0i8_i32($40, $41, 8, 4, 0);
    var $42 = $o21;
    var $43 = $42+8;
    var $44 = IHEAP[$43];
    var $45 = $o12;
    var $46 = $45+8;
    IHEAP[$46] = $44;
    ;
    return;
  }
  __Z10lua_insertP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z10lua_insertP9lua_Statei, "__Z10lua_insertP9lua_Statei");
  
  
  function __Z11lua_replaceP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var $1;
    var $2;
    var $o;
    var $func;
    var $o2;
    var $o1;
    $1 = $L;
    $2 = $idx;
    var $3 = $2;
    var $4 = $3 == -10001;
    ;
    $5$15$2: do { 
      if ($4) {
        ;
        var $6 = $1;
        var $7 = $6+20;
        var $8 = IHEAP[$7];
        var $9 = $1;
        var $10 = $9+40;
        var $11 = IHEAP[$10];
        var $12 = $8 == $11;
        if (!($12)) { __label__ = 1; /* $15 */ break $5$15$2; }
        var $14 = $1;
        __Z13luaG_runerrorP9lua_StatePKcz($14, __str28);
        ;
      }
    } while(0);
    var $16 = $1;
    var $17 = $2;
    var $18 = __Z9index2adrP9lua_Statei($16, $17);
    $o = $18;
    var $19 = $2;
    var $20 = $19 == -10001;
    ;
    if ($20) {
      ;
      var $22 = $1;
      var $23 = $22+20;
      var $24 = IHEAP[$23];
      var $25 = $24+4;
      var $26 = IHEAP[$25];
      var $27 = $26;
      var $28 = $27;
      var $29 = $28;
      var $30 = IHEAP[$29];
      var $31 = $30;
      var $32 = $31;
      $func = $32;
      var $33 = $1;
      var $34 = $33+8;
      var $35 = IHEAP[$34];
      var $36 = $35+-12;
      var $37 = $36;
      var $38 = $37;
      var $39 = $38;
      var $40 = IHEAP[$39];
      var $41 = $40;
      var $42 = $41;
      var $43 = $func;
      var $44 = $43;
      var $45 = $44+12;
      IHEAP[$45] = $42;
      var $46 = $1;
      var $47 = $46+8;
      var $48 = IHEAP[$47];
      var $49 = $48+-12;
      var $50 = $49+8;
      var $51 = IHEAP[$50];
      var $52 = $51 >= 4;
      ;
      $53$91$8: do { 
        if ($52) {
          ;
          var $54 = $1;
          var $55 = $54+8;
          var $56 = IHEAP[$55];
          var $57 = $56+-12;
          var $58 = $57;
          var $59 = $58;
          var $60 = $59;
          var $61 = IHEAP[$60];
          var $62 = $61;
          var $63 = $62;
          var $64 = $63+5;
          var $65 = IHEAP[$64];
          var $66 = $65;
          var $67 = $66 & 3;
          var $68 = $67 != 0;
          if (!($68)) { __label__ = 4; /* $91 */ break $53$91$8; }
          var $70 = $func;
          var $71 = $70;
          var $72 = $71;
          var $73 = $72;
          var $74 = $73+5;
          var $75 = IHEAP[$74];
          var $76 = $75;
          var $77 = $76 & 4;
          var $78 = $77 != 0;
          if (!($78)) { __label__ = 4; /* $91 */ break $53$91$8; }
          var $80 = $1;
          var $81 = $func;
          var $82 = $81;
          var $83 = $1;
          var $84 = $83+8;
          var $85 = IHEAP[$84];
          var $86 = $85+-12;
          var $87 = $86;
          var $88 = $87;
          var $89 = $88;
          var $90 = IHEAP[$89];
          __Z13luaC_barrierfP9lua_StateP8GCObjectS2_($80, $82, $90);
          ;
        }
      } while(0);
      ;
    }
    else {
      ;
      var $93 = $1;
      var $94 = $93+8;
      var $95 = IHEAP[$94];
      var $96 = $95+-12;
      $o2 = $96;
      var $97 = $o;
      $o1 = $97;
      var $98 = $o1;
      var $99 = $98;
      var $100 = $o2;
      var $101 = $100;
      var $102 = $99;
      var $103 = $101;
      _llvm_memcpy_p0i8_p0i8_i32($102, $103, 8, 4, 0);
      var $104 = $o2;
      var $105 = $104+8;
      var $106 = IHEAP[$105];
      var $107 = $o1;
      var $108 = $107+8;
      IHEAP[$108] = $106;
      var $109 = $2;
      var $110 = $109 < -10002;
      ;
      if ($110) {
        ;
        var $112 = $1;
        var $113 = $112+8;
        var $114 = IHEAP[$113];
        var $115 = $114+-12;
        var $116 = $115+8;
        var $117 = IHEAP[$116];
        var $118 = $117 >= 4;
        ;
        $119$177$16: do { 
          if ($118) {
            ;
            var $120 = $1;
            var $121 = $120+8;
            var $122 = IHEAP[$121];
            var $123 = $122+-12;
            var $124 = $123;
            var $125 = $124;
            var $126 = $125;
            var $127 = IHEAP[$126];
            var $128 = $127;
            var $129 = $128;
            var $130 = $129+5;
            var $131 = IHEAP[$130];
            var $132 = $131;
            var $133 = $132 & 3;
            var $134 = $133 != 0;
            if (!($134)) { __label__ = 9; /* $177 */ break $119$177$16; }
            var $136 = $1;
            var $137 = $136+20;
            var $138 = IHEAP[$137];
            var $139 = $138+4;
            var $140 = IHEAP[$139];
            var $141 = $140;
            var $142 = $141;
            var $143 = $142;
            var $144 = IHEAP[$143];
            var $145 = $144;
            var $146 = $145;
            var $147 = $146;
            var $148 = $147;
            var $149 = $148;
            var $150 = $149+5;
            var $151 = IHEAP[$150];
            var $152 = $151;
            var $153 = $152 & 4;
            var $154 = $153 != 0;
            if (!($154)) { __label__ = 9; /* $177 */ break $119$177$16; }
            var $156 = $1;
            var $157 = $1;
            var $158 = $157+20;
            var $159 = IHEAP[$158];
            var $160 = $159+4;
            var $161 = IHEAP[$160];
            var $162 = $161;
            var $163 = $162;
            var $164 = $163;
            var $165 = IHEAP[$164];
            var $166 = $165;
            var $167 = $166;
            var $168 = $167;
            var $169 = $1;
            var $170 = $169+8;
            var $171 = IHEAP[$170];
            var $172 = $171+-12;
            var $173 = $172;
            var $174 = $173;
            var $175 = $174;
            var $176 = IHEAP[$175];
            __Z13luaC_barrierfP9lua_StateP8GCObjectS2_($156, $168, $176);
            ;
          }
        } while(0);
        ;
      }
      ;
    }
    var $180 = $1;
    var $181 = $180+8;
    var $182 = IHEAP[$181];
    var $183 = $182+-12;
    IHEAP[$181] = $183;
    ;
    return;
  }
  __Z11lua_replaceP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z11lua_replaceP9lua_Statei, "__Z11lua_replaceP9lua_Statei");
  
  
  function __Z13lua_pushvalueP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var $1;
    var $2;
    var $o2;
    var $o1;
    $1 = $L;
    $2 = $idx;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z9index2adrP9lua_Statei($3, $4);
    $o2 = $5;
    var $6 = $1;
    var $7 = $6+8;
    var $8 = IHEAP[$7];
    $o1 = $8;
    var $9 = $o1;
    var $10 = $9;
    var $11 = $o2;
    var $12 = $11;
    var $13 = $10;
    var $14 = $12;
    _llvm_memcpy_p0i8_p0i8_i32($13, $14, 8, 4, 0);
    var $15 = $o2;
    var $16 = $15+8;
    var $17 = IHEAP[$16];
    var $18 = $o1;
    var $19 = $18+8;
    IHEAP[$19] = $17;
    var $20 = $1;
    var $21 = $20+8;
    var $22 = IHEAP[$21];
    var $23 = $22+12;
    IHEAP[$21] = $23;
    ;
    return;
  }
  __Z13lua_pushvalueP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z13lua_pushvalueP9lua_Statei, "__Z13lua_pushvalueP9lua_Statei");
  
  
  function __Z8lua_typeP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $o;
    $1 = $L;
    $2 = $idx;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z9index2adrP9lua_Statei($3, $4);
    $o = $5;
    var $6 = $o;
    var $7 = $6 == _luaO_nilobject_;
    ;
    if ($7) {
      ;
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $10 = $o;
      var $11 = $10+8;
      var $12 = IHEAP[$11];
      __lastLabel__ = 2; ;
    }
    var $14 = __lastLabel__ == 0 ? -1 : ($12);
    ;
    return $14;
  }
  __Z8lua_typeP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z8lua_typeP9lua_Statei, "__Z8lua_typeP9lua_Statei");
  
  
  function __Z12lua_typenameP9lua_Statei($L, $t) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    $1 = $L;
    $2 = $t;
    var $3 = $2;
    var $4 = $3 == -1;
    ;
    if ($4) {
      ;
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $7 = $2;
      var $8 = _luaT_typenames+$7*4;
      var $9 = IHEAP[$8];
      __lastLabel__ = 2; ;
    }
    var $11 = __lastLabel__ == 0 ? __str129 : ($9);
    ;
    return $11;
  }
  __Z12lua_typenameP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z12lua_typenameP9lua_Statei, "__Z12lua_typenameP9lua_Statei");
  
  
  function __Z15lua_iscfunctionP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $o;
    $1 = $L;
    $2 = $idx;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z9index2adrP9lua_Statei($3, $4);
    $o = $5;
    var $6 = $o;
    var $7 = $6+8;
    var $8 = IHEAP[$7];
    var $9 = $8 == 6;
    ;
    if ($9) {
      __lastLabel__ = 2; ;
      var $11 = $o;
      var $12 = $11;
      var $13 = $12;
      var $14 = $13;
      var $15 = IHEAP[$14];
      var $16 = $15;
      var $17 = $16;
      var $18 = $17;
      var $19 = $18+6;
      var $20 = IHEAP[$19];
      var $21 = $20 != 0;
      __lastLabel__ = 0; ;
    }
    else {
      __lastLabel__ = 2; ;
    }
    var $23 = __lastLabel__ == 2 ? 0 : ($21);
    var $24 = $23;
    ;
    return $24;
  }
  __Z15lua_iscfunctionP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z15lua_iscfunctionP9lua_Statei, "__Z15lua_iscfunctionP9lua_Statei");
  
  
  function __Z12lua_isnumberP9lua_Statei($L, $idx) {
    var __stackBase__  = STACKTOP; STACKTOP += 12; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $n = __stackBase__;
    var $o;
    $1 = $L;
    $2 = $idx;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z9index2adrP9lua_Statei($3, $4);
    $o = $5;
    var $6 = $o;
    var $7 = $6+8;
    var $8 = IHEAP[$7];
    var $9 = $8 == 3;
    ;
    if ($9) {
      __lastLabel__ = 2; ;
    }
    else {
      __lastLabel__ = 2; ;
      var $11 = $o;
      var $12 = __Z13luaV_tonumberPK10lua_TValuePS_($11, $n);
      $o = $12;
      var $13 = $12 != 0;
      __lastLabel__ = 0; ;
    }
    var $15 = __lastLabel__ == 2 ? 1 : ($13);
    var $16 = $15;
    STACKTOP = __stackBase__;
    return $16;
  }
  __Z12lua_isnumberP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z12lua_isnumberP9lua_Statei, "__Z12lua_isnumberP9lua_Statei");
  
  
  function __Z12lua_isstringP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $t;
    $1 = $L;
    $2 = $idx;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z8lua_typeP9lua_Statei($3, $4);
    $t = $5;
    var $6 = $t;
    var $7 = $6 == 4;
    ;
    if ($7) {
      __lastLabel__ = 2; ;
    }
    else {
      __lastLabel__ = 2; ;
      var $9 = $t;
      var $10 = $9 == 3;
      __lastLabel__ = 0; ;
    }
    var $12 = __lastLabel__ == 2 ? 1 : ($10);
    var $13 = $12;
    ;
    return $13;
  }
  __Z12lua_isstringP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z12lua_isstringP9lua_Statei, "__Z12lua_isstringP9lua_Statei");
  
  
  function __Z14lua_isuserdataP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $o;
    $1 = $L;
    $2 = $idx;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z9index2adrP9lua_Statei($3, $4);
    $o = $5;
    var $6 = $o;
    var $7 = $6+8;
    var $8 = IHEAP[$7];
    var $9 = $8 == 7;
    ;
    if ($9) {
      __lastLabel__ = 2; ;
    }
    else {
      __lastLabel__ = 2; ;
      var $11 = $o;
      var $12 = $11+8;
      var $13 = IHEAP[$12];
      var $14 = $13 == 2;
      __lastLabel__ = 0; ;
    }
    var $16 = __lastLabel__ == 2 ? 1 : ($14);
    var $17 = $16;
    ;
    return $17;
  }
  __Z14lua_isuserdataP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z14lua_isuserdataP9lua_Statei, "__Z14lua_isuserdataP9lua_Statei");
  
  
  function __Z12lua_rawequalP9lua_Stateii($L, $index1, $index2) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $o1;
    var $o2;
    $1 = $L;
    $2 = $index1;
    $3 = $index2;
    var $4 = $1;
    var $5 = $2;
    var $6 = __Z9index2adrP9lua_Statei($4, $5);
    $o1 = $6;
    var $7 = $1;
    var $8 = $3;
    var $9 = __Z9index2adrP9lua_Statei($7, $8);
    $o2 = $9;
    var $10 = $o1;
    var $11 = $10 == _luaO_nilobject_;
    ;
    $15$12$2: do { 
      if ($11) {
        __label__ = 0; /* $15 */ 
      }
      else {
        ;
        var $13 = $o2;
        var $14 = $13 == _luaO_nilobject_;
        if ($14) { __label__ = 0; /* $15 */ break $15$12$2; }
        var $17 = $o1;
        var $18 = $o2;
        var $19 = __Z16luaO_rawequalObjPK10lua_TValueS1_($17, $18);
        __lastLabel__ = 1; __label__ = 3; /* $20 */ break $15$12$2;
      }
    } while(0);
    if (__label__ == 0) {
      __lastLabel__ = 0; ;
    }
    var $21 = __lastLabel__ == 0 ? 0 : ($19);
    ;
    return $21;
  }
  __Z12lua_rawequalP9lua_Stateii.__index__ = Runtime.getFunctionIndex(__Z12lua_rawequalP9lua_Stateii, "__Z12lua_rawequalP9lua_Stateii");
  
  
  function __Z9lua_equalP9lua_Stateii($L, $index1, $index2) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $o1;
    var $o2;
    var $i;
    $1 = $L;
    $2 = $index1;
    $3 = $index2;
    var $4 = $1;
    var $5 = $2;
    var $6 = __Z9index2adrP9lua_Statei($4, $5);
    $o1 = $6;
    var $7 = $1;
    var $8 = $3;
    var $9 = __Z9index2adrP9lua_Statei($7, $8);
    $o2 = $9;
    var $10 = $o1;
    var $11 = $10 == _luaO_nilobject_;
    ;
    $15$12$2: do { 
      if ($11) {
        __label__ = 0; /* $15 */ 
      }
      else {
        ;
        var $13 = $o2;
        var $14 = $13 == _luaO_nilobject_;
        if ($14) { __label__ = 0; /* $15 */ break $15$12$2; }
        var $17 = $o1;
        var $18 = $17+8;
        var $19 = IHEAP[$18];
        var $20 = $o2;
        var $21 = $20+8;
        var $22 = IHEAP[$21];
        var $23 = $19 == $22;
        ;
        if ($23) {
          __lastLabel__ = 1; ;
          var $25 = $1;
          var $26 = $o1;
          var $27 = $o2;
          var $28 = __Z13luaV_equalvalP9lua_StatePK10lua_TValueS3_($25, $26, $27);
          var $29 = $28 != 0;
          __lastLabel__ = 3; ;
        }
        else {
          __lastLabel__ = 1; ;
        }
        var $31 = __lastLabel__ == 1 ? 0 : ($29);
        var $32 = $31;
        __lastLabel__ = 5; __label__ = 6; /* $33 */ break $15$12$2;
      }
    } while(0);
    if (__label__ == 0) {
      __lastLabel__ = 0; ;
    }
    var $34 = __lastLabel__ == 0 ? 0 : ($32);
    $i = $34;
    var $35 = $i;
    ;
    return $35;
  }
  __Z9lua_equalP9lua_Stateii.__index__ = Runtime.getFunctionIndex(__Z9lua_equalP9lua_Stateii, "__Z9lua_equalP9lua_Stateii");
  
  
  function __Z12lua_lessthanP9lua_Stateii($L, $index1, $index2) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $o1;
    var $o2;
    var $i;
    $1 = $L;
    $2 = $index1;
    $3 = $index2;
    var $4 = $1;
    var $5 = $2;
    var $6 = __Z9index2adrP9lua_Statei($4, $5);
    $o1 = $6;
    var $7 = $1;
    var $8 = $3;
    var $9 = __Z9index2adrP9lua_Statei($7, $8);
    $o2 = $9;
    var $10 = $o1;
    var $11 = $10 == _luaO_nilobject_;
    ;
    $15$12$2: do { 
      if ($11) {
        __label__ = 0; /* $15 */ 
      }
      else {
        ;
        var $13 = $o2;
        var $14 = $13 == _luaO_nilobject_;
        if ($14) { __label__ = 0; /* $15 */ break $15$12$2; }
        var $17 = $1;
        var $18 = $o1;
        var $19 = $o2;
        var $20 = __Z13luaV_lessthanP9lua_StatePK10lua_TValueS3_($17, $18, $19);
        __lastLabel__ = 1; __label__ = 3; /* $21 */ break $15$12$2;
      }
    } while(0);
    if (__label__ == 0) {
      __lastLabel__ = 0; ;
    }
    var $22 = __lastLabel__ == 0 ? 0 : ($20);
    $i = $22;
    var $23 = $i;
    ;
    return $23;
  }
  __Z12lua_lessthanP9lua_Stateii.__index__ = Runtime.getFunctionIndex(__Z12lua_lessthanP9lua_Stateii, "__Z12lua_lessthanP9lua_Stateii");
  
  
  function __Z12lua_tonumberP9lua_Statei($L, $idx) {
    var __stackBase__  = STACKTOP; STACKTOP += 12; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $n = __stackBase__;
    var $o;
    $2 = $L;
    $3 = $idx;
    var $4 = $2;
    var $5 = $3;
    var $6 = __Z9index2adrP9lua_Statei($4, $5);
    $o = $6;
    var $7 = $o;
    var $8 = $7+8;
    var $9 = IHEAP[$8];
    var $10 = $9 == 3;
    ;
    $15$11$2: do { 
      if ($10) {
        __label__ = 0; /* $15 */ 
      }
      else {
        ;
        var $12 = $o;
        var $13 = __Z13luaV_tonumberPK10lua_TValuePS_($12, $n);
        $o = $13;
        var $14 = $13 != 0;
        if ($14) { __label__ = 0; /* $15 */ break $15$11$2; }
        $1 = 0;
        __label__ = 3; /* $21 */ break $15$11$2;
      }
    } while(0);
    if (__label__ == 0) {
      var $16 = $o;
      var $17 = $16;
      var $18 = $17;
      var $19 = FHEAP[$18];
      $1 = $19;
      ;
    }
    var $22 = $1;
    STACKTOP = __stackBase__;
    return $22;
  }
  __Z12lua_tonumberP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z12lua_tonumberP9lua_Statei, "__Z12lua_tonumberP9lua_Statei");
  
  
  function __Z13lua_tointegerP9lua_Statei($L, $idx) {
    var __stackBase__  = STACKTOP; STACKTOP += 12; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $n = __stackBase__;
    var $o;
    var $res;
    var $num;
    $2 = $L;
    $3 = $idx;
    var $4 = $2;
    var $5 = $3;
    var $6 = __Z9index2adrP9lua_Statei($4, $5);
    $o = $6;
    var $7 = $o;
    var $8 = $7+8;
    var $9 = IHEAP[$8];
    var $10 = $9 == 3;
    ;
    $15$11$2: do { 
      if ($10) {
        __label__ = 0; /* $15 */ 
      }
      else {
        ;
        var $12 = $o;
        var $13 = __Z13luaV_tonumberPK10lua_TValuePS_($12, $n);
        $o = $13;
        var $14 = $13 != 0;
        if ($14) { __label__ = 0; /* $15 */ break $15$11$2; }
        $1 = 0;
        __label__ = 3; /* $24 */ break $15$11$2;
      }
    } while(0);
    if (__label__ == 0) {
      var $16 = $o;
      var $17 = $16;
      var $18 = $17;
      var $19 = FHEAP[$18];
      $num = $19;
      var $20 = $num;
      var $21 = Math.floor($20);
      $res = $21;
      var $22 = $res;
      $1 = $22;
      ;
    }
    var $25 = $1;
    STACKTOP = __stackBase__;
    return $25;
  }
  __Z13lua_tointegerP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z13lua_tointegerP9lua_Statei, "__Z13lua_tointegerP9lua_Statei");
  
  
  function __Z13lua_tobooleanP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $o;
    $1 = $L;
    $2 = $idx;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z9index2adrP9lua_Statei($3, $4);
    $o = $5;
    var $6 = $o;
    var $7 = $6+8;
    var $8 = IHEAP[$7];
    var $9 = $8 == 0;
    ;
    if ($9) {
      __lastLabel__ = 5; ;
    }
    else {
      __lastLabel__ = 5; ;
      var $11 = $o;
      var $12 = $11+8;
      var $13 = IHEAP[$12];
      var $14 = $13 == 1;
      ;
      if ($14) {
        __lastLabel__ = 4; ;
        var $16 = $o;
        var $17 = $16;
        var $18 = $17;
        var $19 = $18;
        var $20 = IHEAP[$19];
        var $21 = $20 == 0;
        __lastLabel__ = 0; ;
      }
      else {
        __lastLabel__ = 4; ;
      }
      var $23 = __lastLabel__ == 4 ? 0 : ($21);
      __lastLabel__ = 2; ;
    }
    var $25 = __lastLabel__ == 5 ? 1 : ($23);
    var $26 = $25 ^ 1;
    var $27 = $26;
    ;
    return $27;
  }
  __Z13lua_tobooleanP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z13lua_tobooleanP9lua_Statei, "__Z13lua_tobooleanP9lua_Statei");
  
  
  function __Z13lua_tolstringP9lua_StateiPj($L, $idx, $len) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $o;
    $2 = $L;
    $3 = $idx;
    $4 = $len;
    var $5 = $2;
    var $6 = $3;
    var $7 = __Z9index2adrP9lua_Statei($5, $6);
    $o = $7;
    var $8 = $o;
    var $9 = $8+8;
    var $10 = IHEAP[$9];
    var $11 = $10 == 4;
    ;
    $41$12$2: do { 
      if ($11) {
        __label__ = 3; /* $41 */ 
      }
      else {
        ;
        var $13 = $2;
        var $14 = $o;
        var $15 = __Z13luaV_tostringP9lua_StateP10lua_TValue($13, $14);
        var $16 = $15 != 0;
        ;
        if ($16) {
          ;
          var $24 = $2;
          var $25 = $24+16;
          var $26 = IHEAP[$25];
          var $27 = $26+68;
          var $28 = IHEAP[$27];
          var $29 = $2;
          var $30 = $29+16;
          var $31 = IHEAP[$30];
          var $32 = $31+64;
          var $33 = IHEAP[$32];
          var $34 = unSign($28, 32) >= unSign($33, 32);
          ;
          if ($34) {
            ;
            var $36 = $2;
            __Z9luaC_stepP9lua_State($36);
            ;
          }
          var $38 = $2;
          var $39 = $3;
          var $40 = __Z9index2adrP9lua_Statei($38, $39);
          $o = $40;
          __label__ = 3; /* $41 */ break $41$12$2;
        }
        else {
          ;
          var $18 = $4;
          var $19 = $18 != 0;
          ;
          if ($19) {
            ;
            var $21 = $4;
            IHEAP[$21] = 0;
            ;
          }
          $1 = 0;
          __label__ = 1; /* $66 */ break $41$12$2;
        }
      }
    } while(0);
    if (__label__ == 3) {
      var $42 = $4;
      var $43 = $42 != 0;
      ;
      if ($43) {
        ;
        var $45 = $o;
        var $46 = $45;
        var $47 = $46;
        var $48 = $47;
        var $49 = IHEAP[$48];
        var $50 = $49;
        var $51 = $50;
        var $52 = $51;
        var $53 = $52+12;
        var $54 = IHEAP[$53];
        var $55 = $4;
        IHEAP[$55] = $54;
        ;
      }
      var $57 = $o;
      var $58 = $57;
      var $59 = $58;
      var $60 = $59;
      var $61 = IHEAP[$60];
      var $62 = $61;
      var $63 = $62;
      var $64 = $63+16;
      var $65 = $64;
      $1 = $65;
      ;
    }
    var $67 = $1;
    ;
    return $67;
  }
  __Z13lua_tolstringP9lua_StateiPj.__index__ = Runtime.getFunctionIndex(__Z13lua_tolstringP9lua_StateiPj, "__Z13lua_tolstringP9lua_StateiPj");
  
  
  function __Z10lua_objlenP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $o;
    var $l;
    $2 = $L;
    $3 = $idx;
    var $4 = $2;
    var $5 = $3;
    var $6 = __Z9index2adrP9lua_Statei($4, $5);
    $o = $6;
    var $7 = $o;
    var $8 = $7+8;
    var $9 = IHEAP[$8];
    if ($9 == 4) {
      __label__ = 4; /* $10 */ 
    }
    else if ($9 == 7) {
      __label__ = 5; /* $21 */ 
    }
    else if ($9 == 5) {
      __label__ = 6; /* $32 */ 
    }
    else if ($9 == 3) {
      __label__ = 7; /* $41 */ 
    }
    else {
    __label__ = 8; /* $61 */ 
    }
    
    if (__label__ == 8) {
      $1 = 0;
      ;
    }
    else if (__label__ == 4) {
      var $11 = $o;
      var $12 = $11;
      var $13 = $12;
      var $14 = $13;
      var $15 = IHEAP[$14];
      var $16 = $15;
      var $17 = $16;
      var $18 = $17;
      var $19 = $18+12;
      var $20 = IHEAP[$19];
      $1 = $20;
      ;
    }
    else if (__label__ == 5) {
      var $22 = $o;
      var $23 = $22;
      var $24 = $23;
      var $25 = $24;
      var $26 = IHEAP[$25];
      var $27 = $26;
      var $28 = $27;
      var $29 = $28;
      var $30 = $29+16;
      var $31 = IHEAP[$30];
      $1 = $31;
      ;
    }
    else if (__label__ == 6) {
      var $33 = $o;
      var $34 = $33;
      var $35 = $34;
      var $36 = $35;
      var $37 = IHEAP[$36];
      var $38 = $37;
      var $39 = $38;
      var $40 = __Z9luaH_getnP5Table($39);
      $1 = $40;
      ;
    }
    else if (__label__ == 7) {
      var $42 = $2;
      var $43 = $o;
      var $44 = __Z13luaV_tostringP9lua_StateP10lua_TValue($42, $43);
      var $45 = $44 != 0;
      ;
      if ($45) {
        ;
        var $47 = $o;
        var $48 = $47;
        var $49 = $48;
        var $50 = $49;
        var $51 = IHEAP[$50];
        var $52 = $51;
        var $53 = $52;
        var $54 = $53;
        var $55 = $54+12;
        var $56 = IHEAP[$55];
        __lastLabel__ = 1; ;
      }
      else {
        ;
        __lastLabel__ = 3; ;
      }
      var $59 = __lastLabel__ == 1 ? $56 : (0);
      $l = $59;
      var $60 = $l;
      $1 = $60;
      ;
    }
    var $63 = $1;
    ;
    return $63;
  }
  __Z10lua_objlenP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z10lua_objlenP9lua_Statei, "__Z10lua_objlenP9lua_Statei");
  
  
  function __Z15lua_tocfunctionP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $o;
    $1 = $L;
    $2 = $idx;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z9index2adrP9lua_Statei($3, $4);
    $o = $5;
    var $6 = $o;
    var $7 = $6+8;
    var $8 = IHEAP[$7];
    var $9 = $8 == 6;
    ;
    $10$22$2: do { 
      if ($9) {
        ;
        var $11 = $o;
        var $12 = $11;
        var $13 = $12;
        var $14 = $13;
        var $15 = IHEAP[$14];
        var $16 = $15;
        var $17 = $16;
        var $18 = $17;
        var $19 = $18+6;
        var $20 = IHEAP[$19];
        var $21 = $20 != 0;
        if (!($21)) { __label__ = 1; /* $22 */ break $10$22$2; }
        var $24 = $o;
        var $25 = $24;
        var $26 = $25;
        var $27 = $26;
        var $28 = IHEAP[$27];
        var $29 = $28;
        var $30 = $29;
        var $31 = $30;
        var $32 = $31+16;
        var $33 = IHEAP[$32];
        __lastLabel__ = 0; __label__ = 3; /* $34 */ break $10$22$2;
      }
      else {
        __label__ = 1; /* $22 */ 
      }
    } while(0);
    if (__label__ == 1) {
      __lastLabel__ = 1; ;
    }
    var $35 = __lastLabel__ == 1 ? 0 : ($33);
    ;
    return $35;
  }
  __Z15lua_tocfunctionP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z15lua_tocfunctionP9lua_Statei, "__Z15lua_tocfunctionP9lua_Statei");
  
  
  function __Z14lua_touserdataP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $o;
    $2 = $L;
    $3 = $idx;
    var $4 = $2;
    var $5 = $3;
    var $6 = __Z9index2adrP9lua_Statei($4, $5);
    $o = $6;
    var $7 = $o;
    var $8 = $7+8;
    var $9 = IHEAP[$8];
    if ($9 == 7) {
      __label__ = 1; /* $10 */ 
    }
    else if ($9 == 2) {
      __label__ = 2; /* $20 */ 
    }
    else {
    __label__ = 3; /* $26 */ 
    }
    
    if (__label__ == 3) {
      $1 = 0;
      ;
    }
    else if (__label__ == 1) {
      var $11 = $o;
      var $12 = $11;
      var $13 = $12;
      var $14 = $13;
      var $15 = IHEAP[$14];
      var $16 = $15;
      var $17 = $16;
      var $18 = $17+20;
      var $19 = $18;
      $1 = $19;
      ;
    }
    else if (__label__ == 2) {
      var $21 = $o;
      var $22 = $21;
      var $23 = $22;
      var $24 = $23;
      var $25 = IHEAP[$24];
      $1 = $25;
      ;
    }
    var $28 = $1;
    ;
    return $28;
  }
  __Z14lua_touserdataP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z14lua_touserdataP9lua_Statei, "__Z14lua_touserdataP9lua_Statei");
  
  
  function __Z12lua_tothreadP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $o;
    $1 = $L;
    $2 = $idx;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z9index2adrP9lua_Statei($3, $4);
    $o = $5;
    var $6 = $o;
    var $7 = $6+8;
    var $8 = IHEAP[$7];
    var $9 = $8 == 8;
    ;
    if ($9) {
      ;
      var $12 = $o;
      var $13 = $12;
      var $14 = $13;
      var $15 = $14;
      var $16 = IHEAP[$15];
      var $17 = $16;
      __lastLabel__ = 2; ;
    }
    else {
      ;
      __lastLabel__ = 0; ;
    }
    var $19 = __lastLabel__ == 0 ? 0 : ($17);
    ;
    return $19;
  }
  __Z12lua_tothreadP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z12lua_tothreadP9lua_Statei, "__Z12lua_tothreadP9lua_Statei");
  
  
  function __Z13lua_topointerP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $o;
    $2 = $L;
    $3 = $idx;
    var $4 = $2;
    var $5 = $3;
    var $6 = __Z9index2adrP9lua_Statei($4, $5);
    $o = $6;
    var $7 = $o;
    var $8 = $7+8;
    var $9 = IHEAP[$8];
    if ($9 == 5) {
      __label__ = 1; /* $10 */ 
    }
    else if ($9 == 6) {
      __label__ = 2; /* $19 */ 
    }
    else if ($9 == 8) {
      __label__ = 3; /* $28 */ 
    }
    else if ($9 == 7) {
      __label__ = 4; /* $36 */ 
    }
    else if ($9 == 2) {
      __label__ = 4; /* $36 */ 
    }
    else {
    __label__ = 5; /* $40 */ 
    }
    
    if (__label__ == 5) {
      $1 = 0;
      ;
    }
    else if (__label__ == 1) {
      var $11 = $o;
      var $12 = $11;
      var $13 = $12;
      var $14 = $13;
      var $15 = IHEAP[$14];
      var $16 = $15;
      var $17 = $16;
      var $18 = $17;
      $1 = $18;
      ;
    }
    else if (__label__ == 2) {
      var $20 = $o;
      var $21 = $20;
      var $22 = $21;
      var $23 = $22;
      var $24 = IHEAP[$23];
      var $25 = $24;
      var $26 = $25;
      var $27 = $26;
      $1 = $27;
      ;
    }
    else if (__label__ == 3) {
      var $29 = $o;
      var $30 = $29;
      var $31 = $30;
      var $32 = $31;
      var $33 = IHEAP[$32];
      var $34 = $33;
      var $35 = $34;
      $1 = $35;
      ;
    }
    else if (__label__ == 4) {
      var $37 = $2;
      var $38 = $3;
      var $39 = __Z14lua_touserdataP9lua_Statei($37, $38);
      $1 = $39;
      ;
    }
    var $42 = $1;
    ;
    return $42;
  }
  __Z13lua_topointerP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z13lua_topointerP9lua_Statei, "__Z13lua_topointerP9lua_Statei");
  
  
  function __Z11lua_pushnilP9lua_State($L) {
    ;
    var __label__;
    var $1;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+8;
    var $4 = IHEAP[$3];
    var $5 = $4+8;
    IHEAP[$5] = 0;
    var $6 = $1;
    var $7 = $6+8;
    var $8 = IHEAP[$7];
    var $9 = $8+12;
    IHEAP[$7] = $9;
    ;
    return;
  }
  __Z11lua_pushnilP9lua_State.__index__ = Runtime.getFunctionIndex(__Z11lua_pushnilP9lua_State, "__Z11lua_pushnilP9lua_State");
  
  
  function __Z14lua_pushnumberP9lua_Stated($L, $n) {
    ;
    var __label__;
    var $1;
    var $2;
    var $i_o;
    $1 = $L;
    $2 = $n;
    var $3 = $1;
    var $4 = $3+8;
    var $5 = IHEAP[$4];
    $i_o = $5;
    var $6 = $2;
    var $7 = $i_o;
    var $8 = $7;
    var $9 = $8;
    FHEAP[$9] = $6;
    var $10 = $i_o;
    var $11 = $10+8;
    IHEAP[$11] = 3;
    var $12 = $1;
    var $13 = $12+8;
    var $14 = IHEAP[$13];
    var $15 = $14+12;
    IHEAP[$13] = $15;
    ;
    return;
  }
  __Z14lua_pushnumberP9lua_Stated.__index__ = Runtime.getFunctionIndex(__Z14lua_pushnumberP9lua_Stated, "__Z14lua_pushnumberP9lua_Stated");
  
  
  function __Z15lua_pushintegerP9lua_Statei($L, $n) {
    ;
    var __label__;
    var $1;
    var $2;
    var $i_o;
    $1 = $L;
    $2 = $n;
    var $3 = $1;
    var $4 = $3+8;
    var $5 = IHEAP[$4];
    $i_o = $5;
    var $6 = $2;
    var $7 = $6;
    var $8 = $i_o;
    var $9 = $8;
    var $10 = $9;
    FHEAP[$10] = $7;
    var $11 = $i_o;
    var $12 = $11+8;
    IHEAP[$12] = 3;
    var $13 = $1;
    var $14 = $13+8;
    var $15 = IHEAP[$14];
    var $16 = $15+12;
    IHEAP[$14] = $16;
    ;
    return;
  }
  __Z15lua_pushintegerP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z15lua_pushintegerP9lua_Statei, "__Z15lua_pushintegerP9lua_Statei");
  
  
  function __Z15lua_pushlstringP9lua_StatePKcj($L, $s, $len) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $i_o;
    $1 = $L;
    $2 = $s;
    $3 = $len;
    var $4 = $1;
    var $5 = $4+16;
    var $6 = IHEAP[$5];
    var $7 = $6+68;
    var $8 = IHEAP[$7];
    var $9 = $1;
    var $10 = $9+16;
    var $11 = IHEAP[$10];
    var $12 = $11+64;
    var $13 = IHEAP[$12];
    var $14 = unSign($8, 32) >= unSign($13, 32);
    ;
    if ($14) {
      ;
      var $16 = $1;
      __Z9luaC_stepP9lua_State($16);
      ;
    }
    var $18 = $1;
    var $19 = $18+8;
    var $20 = IHEAP[$19];
    $i_o = $20;
    var $21 = $1;
    var $22 = $2;
    var $23 = $3;
    var $24 = __Z12luaS_newlstrP9lua_StatePKcj($21, $22, $23);
    var $25 = $24;
    var $26 = $i_o;
    var $27 = $26;
    var $28 = $27;
    var $29 = $28;
    IHEAP[$29] = $25;
    var $30 = $i_o;
    var $31 = $30+8;
    IHEAP[$31] = 4;
    var $32 = $1;
    var $33 = $32+8;
    var $34 = IHEAP[$33];
    var $35 = $34+12;
    IHEAP[$33] = $35;
    ;
    return;
  }
  __Z15lua_pushlstringP9lua_StatePKcj.__index__ = Runtime.getFunctionIndex(__Z15lua_pushlstringP9lua_StatePKcj, "__Z15lua_pushlstringP9lua_StatePKcj");
  
  
  function __Z14lua_pushstringP9lua_StatePKc($L, $s) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $L;
    $2 = $s;
    var $3 = $2;
    var $4 = $3 == 0;
    ;
    if ($4) {
      ;
      var $6 = $1;
      __Z11lua_pushnilP9lua_State($6);
      ;
    }
    else {
      ;
      var $8 = $1;
      var $9 = $2;
      var $10 = $2;
      var $11 = _strlen($10);
      __Z15lua_pushlstringP9lua_StatePKcj($8, $9, $11);
      ;
    }
    ;
    return;
  }
  __Z14lua_pushstringP9lua_StatePKc.__index__ = Runtime.getFunctionIndex(__Z14lua_pushstringP9lua_StatePKc, "__Z14lua_pushstringP9lua_StatePKc");
  
  
  function __Z16lua_pushvfstringP9lua_StatePKcPc($L, $fmt, $argp) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $ret;
    $1 = $L;
    $2 = $fmt;
    $3 = $argp;
    var $4 = $1;
    var $5 = $4+16;
    var $6 = IHEAP[$5];
    var $7 = $6+68;
    var $8 = IHEAP[$7];
    var $9 = $1;
    var $10 = $9+16;
    var $11 = IHEAP[$10];
    var $12 = $11+64;
    var $13 = IHEAP[$12];
    var $14 = unSign($8, 32) >= unSign($13, 32);
    ;
    if ($14) {
      ;
      var $16 = $1;
      __Z9luaC_stepP9lua_State($16);
      ;
    }
    var $18 = $1;
    var $19 = $2;
    var $20 = $3;
    var $21 = __Z17luaO_pushvfstringP9lua_StatePKcPc($18, $19, $20);
    $ret = $21;
    var $22 = $ret;
    ;
    return $22;
  }
  __Z16lua_pushvfstringP9lua_StatePKcPc.__index__ = Runtime.getFunctionIndex(__Z16lua_pushvfstringP9lua_StatePKcPc, "__Z16lua_pushvfstringP9lua_StatePKcPc");
  
  
  function __Z15lua_pushfstringP9lua_StatePKcz($L, $fmt) {
    var __stackBase__  = STACKTOP; STACKTOP += 4; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var __numArgs__ = 2;
    var $1;
    var $2;
    var $ret;
    var $argp = __stackBase__;
    $1 = $L;
    $2 = $fmt;
    var $3 = $1;
    var $4 = $3+16;
    var $5 = IHEAP[$4];
    var $6 = $5+68;
    var $7 = IHEAP[$6];
    var $8 = $1;
    var $9 = $8+16;
    var $10 = IHEAP[$9];
    var $11 = $10+64;
    var $12 = IHEAP[$11];
    var $13 = unSign($7, 32) >= unSign($12, 32);
    ;
    if ($13) {
      ;
      var $15 = $1;
      __Z9luaC_stepP9lua_State($15);
      ;
    }
    var $17 = $argp;
    IHEAP[$17] = arguments[__numArgs__];
    var $18 = $1;
    var $19 = $2;
    var $20 = IHEAP[$argp];
    var $21 = __Z17luaO_pushvfstringP9lua_StatePKcPc($18, $19, $20);
    $ret = $21;
    var $22 = $argp;
    ;;
    var $23 = $ret;
    STACKTOP = __stackBase__;
    return $23;
  }
  __Z15lua_pushfstringP9lua_StatePKcz.__index__ = Runtime.getFunctionIndex(__Z15lua_pushfstringP9lua_StatePKcz, "__Z15lua_pushfstringP9lua_StatePKcz");
  
  
  function __Z16lua_pushcclosureP9lua_StatePFiS0_Ei($L, $fn, $n) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $cl;
    var $o2;
    var $o1;
    var $i_o;
    $1 = $L;
    $2 = $fn;
    $3 = $n;
    var $4 = $1;
    var $5 = $4+16;
    var $6 = IHEAP[$5];
    var $7 = $6+68;
    var $8 = IHEAP[$7];
    var $9 = $1;
    var $10 = $9+16;
    var $11 = IHEAP[$10];
    var $12 = $11+64;
    var $13 = IHEAP[$12];
    var $14 = unSign($8, 32) >= unSign($13, 32);
    ;
    if ($14) {
      ;
      var $16 = $1;
      __Z9luaC_stepP9lua_State($16);
      ;
    }
    var $18 = $1;
    var $19 = $3;
    var $20 = $1;
    var $21 = __Z10getcurrenvP9lua_State($20);
    var $22 = __Z16luaF_newCclosureP9lua_StateiP5Table($18, $19, $21);
    $cl = $22;
    var $23 = $2;
    var $24 = $cl;
    var $25 = $24;
    var $26 = $25+16;
    IHEAP[$26] = $23;
    var $27 = $3;
    var $28 = $1;
    var $29 = $28+8;
    var $30 = IHEAP[$29];
    var $31 = 0 - $27;
    var $32 = $30+12*$31;
    IHEAP[$29] = $32;
    ;
    $33$5: while(1) { // $33
      var $34 = $3;
      var $35 = $34 + -1;
      $3 = $35;
      var $36 = $34 != 0;
      if (!($36)) { __label__ = 3; /* $59 */ break $33$5; }
      var $38 = $1;
      var $39 = $38+8;
      var $40 = IHEAP[$39];
      var $41 = $3;
      var $42 = $40+12*$41;
      $o2 = $42;
      var $43 = $3;
      var $44 = $cl;
      var $45 = $44;
      var $46 = $45+20;
      var $47 = $46+$43*12;
      $o1 = $47;
      var $48 = $o1;
      var $49 = $48;
      var $50 = $o2;
      var $51 = $50;
      var $52 = $49;
      var $53 = $51;
      _llvm_memcpy_p0i8_p0i8_i32($52, $53, 8, 4, 0);
      var $54 = $o2;
      var $55 = $54+8;
      var $56 = IHEAP[$55];
      var $57 = $o1;
      var $58 = $57+8;
      IHEAP[$58] = $56;
      __label__ = 1; /* $33 */ continue $33$5;
    }
    var $60 = $1;
    var $61 = $60+8;
    var $62 = IHEAP[$61];
    $i_o = $62;
    var $63 = $cl;
    var $64 = $63;
    var $65 = $i_o;
    var $66 = $65;
    var $67 = $66;
    var $68 = $67;
    IHEAP[$68] = $64;
    var $69 = $i_o;
    var $70 = $69+8;
    IHEAP[$70] = 6;
    var $71 = $1;
    var $72 = $71+8;
    var $73 = IHEAP[$72];
    var $74 = $73+12;
    IHEAP[$72] = $74;
    ;
    return;
  }
  __Z16lua_pushcclosureP9lua_StatePFiS0_Ei.__index__ = Runtime.getFunctionIndex(__Z16lua_pushcclosureP9lua_StatePFiS0_Ei, "__Z16lua_pushcclosureP9lua_StatePFiS0_Ei");
  
  
  function __Z10getcurrenvP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $2;
    var $func;
    $2 = $L;
    var $3 = $2;
    var $4 = $3+20;
    var $5 = IHEAP[$4];
    var $6 = $2;
    var $7 = $6+40;
    var $8 = IHEAP[$7];
    var $9 = $5 == $8;
    ;
    if ($9) {
      ;
      var $11 = $2;
      var $12 = $11+72;
      var $13 = $12;
      var $14 = $13;
      var $15 = $14;
      var $16 = IHEAP[$15];
      var $17 = $16;
      var $18 = $17;
      $1 = $18;
      ;
    }
    else {
      ;
      var $20 = $2;
      var $21 = $20+20;
      var $22 = IHEAP[$21];
      var $23 = $22+4;
      var $24 = IHEAP[$23];
      var $25 = $24;
      var $26 = $25;
      var $27 = $26;
      var $28 = IHEAP[$27];
      var $29 = $28;
      var $30 = $29;
      $func = $30;
      var $31 = $func;
      var $32 = $31;
      var $33 = $32+12;
      var $34 = IHEAP[$33];
      $1 = $34;
      ;
    }
    var $36 = $1;
    ;
    return $36;
  }
  __Z10getcurrenvP9lua_State.__index__ = Runtime.getFunctionIndex(__Z10getcurrenvP9lua_State, "__Z10getcurrenvP9lua_State");
  
  
  function __Z15lua_pushbooleanP9lua_Statei($L, $b) {
    ;
    var __label__;
    var $1;
    var $2;
    var $i_o;
    $1 = $L;
    $2 = $b;
    var $3 = $1;
    var $4 = $3+8;
    var $5 = IHEAP[$4];
    $i_o = $5;
    var $6 = $2;
    var $7 = $6 != 0;
    var $8 = $7;
    var $9 = $i_o;
    var $10 = $9;
    var $11 = $10;
    var $12 = $11;
    IHEAP[$12] = $8;
    var $13 = $i_o;
    var $14 = $13+8;
    IHEAP[$14] = 1;
    var $15 = $1;
    var $16 = $15+8;
    var $17 = IHEAP[$16];
    var $18 = $17+12;
    IHEAP[$16] = $18;
    ;
    return;
  }
  __Z15lua_pushbooleanP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z15lua_pushbooleanP9lua_Statei, "__Z15lua_pushbooleanP9lua_Statei");
  
  
  function __Z21lua_pushlightuserdataP9lua_StatePv($L, $p) {
    ;
    var __label__;
    var $1;
    var $2;
    var $i_o;
    $1 = $L;
    $2 = $p;
    var $3 = $1;
    var $4 = $3+8;
    var $5 = IHEAP[$4];
    $i_o = $5;
    var $6 = $2;
    var $7 = $i_o;
    var $8 = $7;
    var $9 = $8;
    var $10 = $9;
    IHEAP[$10] = $6;
    var $11 = $i_o;
    var $12 = $11+8;
    IHEAP[$12] = 2;
    var $13 = $1;
    var $14 = $13+8;
    var $15 = IHEAP[$14];
    var $16 = $15+12;
    IHEAP[$14] = $16;
    ;
    return;
  }
  __Z21lua_pushlightuserdataP9lua_StatePv.__index__ = Runtime.getFunctionIndex(__Z21lua_pushlightuserdataP9lua_StatePv, "__Z21lua_pushlightuserdataP9lua_StatePv");
  
  
  function __Z14lua_pushthreadP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $i_o;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+8;
    var $4 = IHEAP[$3];
    $i_o = $4;
    var $5 = $1;
    var $6 = $5;
    var $7 = $i_o;
    var $8 = $7;
    var $9 = $8;
    var $10 = $9;
    IHEAP[$10] = $6;
    var $11 = $i_o;
    var $12 = $11+8;
    IHEAP[$12] = 8;
    var $13 = $1;
    var $14 = $13+8;
    var $15 = IHEAP[$14];
    var $16 = $15+12;
    IHEAP[$14] = $16;
    var $17 = $1;
    var $18 = $17+16;
    var $19 = IHEAP[$18];
    var $20 = $19+104;
    var $21 = IHEAP[$20];
    var $22 = $1;
    var $23 = $21 == $22;
    var $24 = $23;
    ;
    return $24;
  }
  __Z14lua_pushthreadP9lua_State.__index__ = Runtime.getFunctionIndex(__Z14lua_pushthreadP9lua_State, "__Z14lua_pushthreadP9lua_State");
  
  
  function __Z12lua_gettableP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var $1;
    var $2;
    var $t;
    $1 = $L;
    $2 = $idx;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z9index2adrP9lua_Statei($3, $4);
    $t = $5;
    var $6 = $1;
    var $7 = $t;
    var $8 = $1;
    var $9 = $8+8;
    var $10 = IHEAP[$9];
    var $11 = $10+-12;
    var $12 = $1;
    var $13 = $12+8;
    var $14 = IHEAP[$13];
    var $15 = $14+-12;
    __Z13luaV_gettableP9lua_StatePK10lua_TValuePS1_S4_($6, $7, $11, $15);
    ;
    return;
  }
  __Z12lua_gettableP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z12lua_gettableP9lua_Statei, "__Z12lua_gettableP9lua_Statei");
  
  
  function __Z12lua_getfieldP9lua_StateiPKc($L, $idx, $k) {
    var __stackBase__  = STACKTOP; STACKTOP += 12; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $t;
    var $key = __stackBase__;
    var $i_o;
    $1 = $L;
    $2 = $idx;
    $3 = $k;
    var $4 = $1;
    var $5 = $2;
    var $6 = __Z9index2adrP9lua_Statei($4, $5);
    $t = $6;
    $i_o = $key;
    var $7 = $1;
    var $8 = $3;
    var $9 = $3;
    var $10 = _strlen($9);
    var $11 = __Z12luaS_newlstrP9lua_StatePKcj($7, $8, $10);
    var $12 = $11;
    var $13 = $i_o;
    var $14 = $13;
    var $15 = $14;
    var $16 = $15;
    IHEAP[$16] = $12;
    var $17 = $i_o;
    var $18 = $17+8;
    IHEAP[$18] = 4;
    var $19 = $1;
    var $20 = $t;
    var $21 = $1;
    var $22 = $21+8;
    var $23 = IHEAP[$22];
    __Z13luaV_gettableP9lua_StatePK10lua_TValuePS1_S4_($19, $20, $key, $23);
    var $24 = $1;
    var $25 = $24+8;
    var $26 = IHEAP[$25];
    var $27 = $26+12;
    IHEAP[$25] = $27;
    STACKTOP = __stackBase__;
    return;
  }
  __Z12lua_getfieldP9lua_StateiPKc.__index__ = Runtime.getFunctionIndex(__Z12lua_getfieldP9lua_StateiPKc, "__Z12lua_getfieldP9lua_StateiPKc");
  
  
  function __Z10lua_rawgetP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var $1;
    var $2;
    var $t;
    var $o2;
    var $o1;
    $1 = $L;
    $2 = $idx;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z9index2adrP9lua_Statei($3, $4);
    $t = $5;
    var $6 = $t;
    var $7 = $6;
    var $8 = $7;
    var $9 = $8;
    var $10 = IHEAP[$9];
    var $11 = $10;
    var $12 = $11;
    var $13 = $1;
    var $14 = $13+8;
    var $15 = IHEAP[$14];
    var $16 = $15+-12;
    var $17 = __Z8luaH_getP5TablePK10lua_TValue($12, $16);
    $o2 = $17;
    var $18 = $1;
    var $19 = $18+8;
    var $20 = IHEAP[$19];
    var $21 = $20+-12;
    $o1 = $21;
    var $22 = $o1;
    var $23 = $22;
    var $24 = $o2;
    var $25 = $24;
    var $26 = $23;
    var $27 = $25;
    _llvm_memcpy_p0i8_p0i8_i32($26, $27, 8, 4, 0);
    var $28 = $o2;
    var $29 = $28+8;
    var $30 = IHEAP[$29];
    var $31 = $o1;
    var $32 = $31+8;
    IHEAP[$32] = $30;
    ;
    return;
  }
  __Z10lua_rawgetP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z10lua_rawgetP9lua_Statei, "__Z10lua_rawgetP9lua_Statei");
  
  
  function __Z11lua_rawgetiP9lua_Stateii($L, $idx, $n) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $o;
    var $o2;
    var $o1;
    $1 = $L;
    $2 = $idx;
    $3 = $n;
    var $4 = $1;
    var $5 = $2;
    var $6 = __Z9index2adrP9lua_Statei($4, $5);
    $o = $6;
    var $7 = $o;
    var $8 = $7;
    var $9 = $8;
    var $10 = $9;
    var $11 = IHEAP[$10];
    var $12 = $11;
    var $13 = $12;
    var $14 = $3;
    var $15 = __Z11luaH_getnumP5Tablei($13, $14);
    $o2 = $15;
    var $16 = $1;
    var $17 = $16+8;
    var $18 = IHEAP[$17];
    $o1 = $18;
    var $19 = $o1;
    var $20 = $19;
    var $21 = $o2;
    var $22 = $21;
    var $23 = $20;
    var $24 = $22;
    _llvm_memcpy_p0i8_p0i8_i32($23, $24, 8, 4, 0);
    var $25 = $o2;
    var $26 = $25+8;
    var $27 = IHEAP[$26];
    var $28 = $o1;
    var $29 = $28+8;
    IHEAP[$29] = $27;
    var $30 = $1;
    var $31 = $30+8;
    var $32 = IHEAP[$31];
    var $33 = $32+12;
    IHEAP[$31] = $33;
    ;
    return;
  }
  __Z11lua_rawgetiP9lua_Stateii.__index__ = Runtime.getFunctionIndex(__Z11lua_rawgetiP9lua_Stateii, "__Z11lua_rawgetiP9lua_Stateii");
  
  
  function __Z15lua_createtableP9lua_Stateii($L, $narray, $nrec) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $i_o;
    $1 = $L;
    $2 = $narray;
    $3 = $nrec;
    var $4 = $1;
    var $5 = $4+16;
    var $6 = IHEAP[$5];
    var $7 = $6+68;
    var $8 = IHEAP[$7];
    var $9 = $1;
    var $10 = $9+16;
    var $11 = IHEAP[$10];
    var $12 = $11+64;
    var $13 = IHEAP[$12];
    var $14 = unSign($8, 32) >= unSign($13, 32);
    ;
    if ($14) {
      ;
      var $16 = $1;
      __Z9luaC_stepP9lua_State($16);
      ;
    }
    var $18 = $1;
    var $19 = $18+8;
    var $20 = IHEAP[$19];
    $i_o = $20;
    var $21 = $1;
    var $22 = $2;
    var $23 = $3;
    var $24 = __Z8luaH_newP9lua_Stateii($21, $22, $23);
    var $25 = $24;
    var $26 = $i_o;
    var $27 = $26;
    var $28 = $27;
    var $29 = $28;
    IHEAP[$29] = $25;
    var $30 = $i_o;
    var $31 = $30+8;
    IHEAP[$31] = 5;
    var $32 = $1;
    var $33 = $32+8;
    var $34 = IHEAP[$33];
    var $35 = $34+12;
    IHEAP[$33] = $35;
    ;
    return;
  }
  __Z15lua_createtableP9lua_Stateii.__index__ = Runtime.getFunctionIndex(__Z15lua_createtableP9lua_Stateii, "__Z15lua_createtableP9lua_Stateii");
  
  
  function __Z16lua_getmetatableP9lua_Statei($L, $objindex) {
    ;
    var __label__;
    var $1;
    var $2;
    var $obj;
    var $mt;
    var $res;
    var $i_o;
    $1 = $L;
    $2 = $objindex;
    $mt = 0;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z9index2adrP9lua_Statei($3, $4);
    $obj = $5;
    var $6 = $obj;
    var $7 = $6+8;
    var $8 = IHEAP[$7];
    if ($8 == 5) {
      __label__ = 2; /* $9 */ 
    }
    else if ($8 == 7) {
      __label__ = 3; /* $19 */ 
    }
    else {
    __label__ = 4; /* $30 */ 
    }
    
    if (__label__ == 4) {
      var $31 = $obj;
      var $32 = $31+8;
      var $33 = IHEAP[$32];
      var $34 = $1;
      var $35 = $34+16;
      var $36 = IHEAP[$35];
      var $37 = $36+132;
      var $38 = $37+$33*4;
      var $39 = IHEAP[$38];
      $mt = $39;
      ;
    }
    else if (__label__ == 2) {
      var $10 = $obj;
      var $11 = $10;
      var $12 = $11;
      var $13 = $12;
      var $14 = IHEAP[$13];
      var $15 = $14;
      var $16 = $15;
      var $17 = $16+8;
      var $18 = IHEAP[$17];
      $mt = $18;
      ;
    }
    else if (__label__ == 3) {
      var $20 = $obj;
      var $21 = $20;
      var $22 = $21;
      var $23 = $22;
      var $24 = IHEAP[$23];
      var $25 = $24;
      var $26 = $25;
      var $27 = $26;
      var $28 = $27+8;
      var $29 = IHEAP[$28];
      $mt = $29;
      ;
    }
    var $41 = $mt;
    var $42 = $41 == 0;
    ;
    if ($42) {
      ;
      $res = 0;
      ;
    }
    else {
      ;
      var $45 = $1;
      var $46 = $45+8;
      var $47 = IHEAP[$46];
      $i_o = $47;
      var $48 = $mt;
      var $49 = $48;
      var $50 = $i_o;
      var $51 = $50;
      var $52 = $51;
      var $53 = $52;
      IHEAP[$53] = $49;
      var $54 = $i_o;
      var $55 = $54+8;
      IHEAP[$55] = 5;
      var $56 = $1;
      var $57 = $56+8;
      var $58 = IHEAP[$57];
      var $59 = $58+12;
      IHEAP[$57] = $59;
      $res = 1;
      ;
    }
    var $61 = $res;
    ;
    return $61;
  }
  __Z16lua_getmetatableP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z16lua_getmetatableP9lua_Statei, "__Z16lua_getmetatableP9lua_Statei");
  
  
  function __Z11lua_getfenvP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var $1;
    var $2;
    var $o;
    var $i_o;
    var $i_o1;
    var $o2;
    var $o1;
    $1 = $L;
    $2 = $idx;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z9index2adrP9lua_Statei($3, $4);
    $o = $5;
    var $6 = $o;
    var $7 = $6+8;
    var $8 = IHEAP[$7];
    if ($8 == 6) {
      __label__ = 1; /* $9 */ 
    }
    else if ($8 == 7) {
      __label__ = 2; /* $30 */ 
    }
    else if ($8 == 8) {
      __label__ = 3; /* $51 */ 
    }
    else {
    __label__ = 4; /* $73 */ 
    }
    
    if (__label__ == 4) {
      var $74 = $1;
      var $75 = $74+8;
      var $76 = IHEAP[$75];
      var $77 = $76+8;
      IHEAP[$77] = 0;
      ;
    }
    else if (__label__ == 1) {
      var $10 = $1;
      var $11 = $10+8;
      var $12 = IHEAP[$11];
      $i_o = $12;
      var $13 = $o;
      var $14 = $13;
      var $15 = $14;
      var $16 = $15;
      var $17 = IHEAP[$16];
      var $18 = $17;
      var $19 = $18;
      var $20 = $19;
      var $21 = $20+12;
      var $22 = IHEAP[$21];
      var $23 = $22;
      var $24 = $i_o;
      var $25 = $24;
      var $26 = $25;
      var $27 = $26;
      IHEAP[$27] = $23;
      var $28 = $i_o;
      var $29 = $28+8;
      IHEAP[$29] = 5;
      ;
    }
    else if (__label__ == 2) {
      var $31 = $1;
      var $32 = $31+8;
      var $33 = IHEAP[$32];
      $i_o1 = $33;
      var $34 = $o;
      var $35 = $34;
      var $36 = $35;
      var $37 = $36;
      var $38 = IHEAP[$37];
      var $39 = $38;
      var $40 = $39;
      var $41 = $40;
      var $42 = $41+12;
      var $43 = IHEAP[$42];
      var $44 = $43;
      var $45 = $i_o1;
      var $46 = $45;
      var $47 = $46;
      var $48 = $47;
      IHEAP[$48] = $44;
      var $49 = $i_o1;
      var $50 = $49+8;
      IHEAP[$50] = 5;
      ;
    }
    else if (__label__ == 3) {
      var $52 = $o;
      var $53 = $52;
      var $54 = $53;
      var $55 = $54;
      var $56 = IHEAP[$55];
      var $57 = $56;
      var $58 = $57+72;
      $o2 = $58;
      var $59 = $1;
      var $60 = $59+8;
      var $61 = IHEAP[$60];
      $o1 = $61;
      var $62 = $o1;
      var $63 = $62;
      var $64 = $o2;
      var $65 = $64;
      var $66 = $63;
      var $67 = $65;
      _llvm_memcpy_p0i8_p0i8_i32($66, $67, 8, 4, 0);
      var $68 = $o2;
      var $69 = $68+8;
      var $70 = IHEAP[$69];
      var $71 = $o1;
      var $72 = $71+8;
      IHEAP[$72] = $70;
      ;
    }
    var $79 = $1;
    var $80 = $79+8;
    var $81 = IHEAP[$80];
    var $82 = $81+12;
    IHEAP[$80] = $82;
    ;
    return;
  }
  __Z11lua_getfenvP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z11lua_getfenvP9lua_Statei, "__Z11lua_getfenvP9lua_Statei");
  
  
  function __Z12lua_settableP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var $1;
    var $2;
    var $t;
    $1 = $L;
    $2 = $idx;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z9index2adrP9lua_Statei($3, $4);
    $t = $5;
    var $6 = $1;
    var $7 = $t;
    var $8 = $1;
    var $9 = $8+8;
    var $10 = IHEAP[$9];
    var $11 = $10+-24;
    var $12 = $1;
    var $13 = $12+8;
    var $14 = IHEAP[$13];
    var $15 = $14+-12;
    __Z13luaV_settableP9lua_StatePK10lua_TValuePS1_S4_($6, $7, $11, $15);
    var $16 = $1;
    var $17 = $16+8;
    var $18 = IHEAP[$17];
    var $19 = $18+-24;
    IHEAP[$17] = $19;
    ;
    return;
  }
  __Z12lua_settableP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z12lua_settableP9lua_Statei, "__Z12lua_settableP9lua_Statei");
  
  
  function __Z12lua_setfieldP9lua_StateiPKc($L, $idx, $k) {
    var __stackBase__  = STACKTOP; STACKTOP += 12; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $t;
    var $key = __stackBase__;
    var $i_o;
    $1 = $L;
    $2 = $idx;
    $3 = $k;
    var $4 = $1;
    var $5 = $2;
    var $6 = __Z9index2adrP9lua_Statei($4, $5);
    $t = $6;
    $i_o = $key;
    var $7 = $1;
    var $8 = $3;
    var $9 = $3;
    var $10 = _strlen($9);
    var $11 = __Z12luaS_newlstrP9lua_StatePKcj($7, $8, $10);
    var $12 = $11;
    var $13 = $i_o;
    var $14 = $13;
    var $15 = $14;
    var $16 = $15;
    IHEAP[$16] = $12;
    var $17 = $i_o;
    var $18 = $17+8;
    IHEAP[$18] = 4;
    var $19 = $1;
    var $20 = $t;
    var $21 = $1;
    var $22 = $21+8;
    var $23 = IHEAP[$22];
    var $24 = $23+-12;
    __Z13luaV_settableP9lua_StatePK10lua_TValuePS1_S4_($19, $20, $key, $24);
    var $25 = $1;
    var $26 = $25+8;
    var $27 = IHEAP[$26];
    var $28 = $27+-12;
    IHEAP[$26] = $28;
    STACKTOP = __stackBase__;
    return;
  }
  __Z12lua_setfieldP9lua_StateiPKc.__index__ = Runtime.getFunctionIndex(__Z12lua_setfieldP9lua_StateiPKc, "__Z12lua_setfieldP9lua_StateiPKc");
  
  
  function __Z10lua_rawsetP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var $1;
    var $2;
    var $t;
    var $o2;
    var $o1;
    $1 = $L;
    $2 = $idx;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z9index2adrP9lua_Statei($3, $4);
    $t = $5;
    var $6 = $1;
    var $7 = $6+8;
    var $8 = IHEAP[$7];
    var $9 = $8+-12;
    $o2 = $9;
    var $10 = $1;
    var $11 = $t;
    var $12 = $11;
    var $13 = $12;
    var $14 = $13;
    var $15 = IHEAP[$14];
    var $16 = $15;
    var $17 = $16;
    var $18 = $1;
    var $19 = $18+8;
    var $20 = IHEAP[$19];
    var $21 = $20+-24;
    var $22 = __Z8luaH_setP9lua_StateP5TablePK10lua_TValue($10, $17, $21);
    $o1 = $22;
    var $23 = $o1;
    var $24 = $23;
    var $25 = $o2;
    var $26 = $25;
    var $27 = $24;
    var $28 = $26;
    _llvm_memcpy_p0i8_p0i8_i32($27, $28, 8, 4, 0);
    var $29 = $o2;
    var $30 = $29+8;
    var $31 = IHEAP[$30];
    var $32 = $o1;
    var $33 = $32+8;
    IHEAP[$33] = $31;
    var $34 = $1;
    var $35 = $34+8;
    var $36 = IHEAP[$35];
    var $37 = $36+-12;
    var $38 = $37+8;
    var $39 = IHEAP[$38];
    var $40 = $39 >= 4;
    ;
    $41$82$2: do { 
      if ($40) {
        ;
        var $42 = $1;
        var $43 = $42+8;
        var $44 = IHEAP[$43];
        var $45 = $44+-12;
        var $46 = $45;
        var $47 = $46;
        var $48 = $47;
        var $49 = IHEAP[$48];
        var $50 = $49;
        var $51 = $50;
        var $52 = $51+5;
        var $53 = IHEAP[$52];
        var $54 = $53;
        var $55 = $54 & 3;
        var $56 = $55 != 0;
        if (!($56)) { __label__ = 1; /* $82 */ break $41$82$2; }
        var $58 = $t;
        var $59 = $58;
        var $60 = $59;
        var $61 = $60;
        var $62 = IHEAP[$61];
        var $63 = $62;
        var $64 = $63;
        var $65 = $64;
        var $66 = $65;
        var $67 = $66;
        var $68 = $67+5;
        var $69 = IHEAP[$68];
        var $70 = $69;
        var $71 = $70 & 4;
        var $72 = $71 != 0;
        if (!($72)) { __label__ = 1; /* $82 */ break $41$82$2; }
        var $74 = $1;
        var $75 = $t;
        var $76 = $75;
        var $77 = $76;
        var $78 = $77;
        var $79 = IHEAP[$78];
        var $80 = $79;
        var $81 = $80;
        __Z16luaC_barrierbackP9lua_StateP5Table($74, $81);
        ;
      }
    } while(0);
    var $83 = $1;
    var $84 = $83+8;
    var $85 = IHEAP[$84];
    var $86 = $85+-24;
    IHEAP[$84] = $86;
    ;
    return;
  }
  __Z10lua_rawsetP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z10lua_rawsetP9lua_Statei, "__Z10lua_rawsetP9lua_Statei");
  
  
  function __Z11lua_rawsetiP9lua_Stateii($L, $idx, $n) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $o;
    var $o2;
    var $o1;
    $1 = $L;
    $2 = $idx;
    $3 = $n;
    var $4 = $1;
    var $5 = $2;
    var $6 = __Z9index2adrP9lua_Statei($4, $5);
    $o = $6;
    var $7 = $1;
    var $8 = $7+8;
    var $9 = IHEAP[$8];
    var $10 = $9+-12;
    $o2 = $10;
    var $11 = $1;
    var $12 = $o;
    var $13 = $12;
    var $14 = $13;
    var $15 = $14;
    var $16 = IHEAP[$15];
    var $17 = $16;
    var $18 = $17;
    var $19 = $3;
    var $20 = __Z11luaH_setnumP9lua_StateP5Tablei($11, $18, $19);
    $o1 = $20;
    var $21 = $o1;
    var $22 = $21;
    var $23 = $o2;
    var $24 = $23;
    var $25 = $22;
    var $26 = $24;
    _llvm_memcpy_p0i8_p0i8_i32($25, $26, 8, 4, 0);
    var $27 = $o2;
    var $28 = $27+8;
    var $29 = IHEAP[$28];
    var $30 = $o1;
    var $31 = $30+8;
    IHEAP[$31] = $29;
    var $32 = $1;
    var $33 = $32+8;
    var $34 = IHEAP[$33];
    var $35 = $34+-12;
    var $36 = $35+8;
    var $37 = IHEAP[$36];
    var $38 = $37 >= 4;
    ;
    $39$80$2: do { 
      if ($38) {
        ;
        var $40 = $1;
        var $41 = $40+8;
        var $42 = IHEAP[$41];
        var $43 = $42+-12;
        var $44 = $43;
        var $45 = $44;
        var $46 = $45;
        var $47 = IHEAP[$46];
        var $48 = $47;
        var $49 = $48;
        var $50 = $49+5;
        var $51 = IHEAP[$50];
        var $52 = $51;
        var $53 = $52 & 3;
        var $54 = $53 != 0;
        if (!($54)) { __label__ = 1; /* $80 */ break $39$80$2; }
        var $56 = $o;
        var $57 = $56;
        var $58 = $57;
        var $59 = $58;
        var $60 = IHEAP[$59];
        var $61 = $60;
        var $62 = $61;
        var $63 = $62;
        var $64 = $63;
        var $65 = $64;
        var $66 = $65+5;
        var $67 = IHEAP[$66];
        var $68 = $67;
        var $69 = $68 & 4;
        var $70 = $69 != 0;
        if (!($70)) { __label__ = 1; /* $80 */ break $39$80$2; }
        var $72 = $1;
        var $73 = $o;
        var $74 = $73;
        var $75 = $74;
        var $76 = $75;
        var $77 = IHEAP[$76];
        var $78 = $77;
        var $79 = $78;
        __Z16luaC_barrierbackP9lua_StateP5Table($72, $79);
        ;
      }
    } while(0);
    var $81 = $1;
    var $82 = $81+8;
    var $83 = IHEAP[$82];
    var $84 = $83+-12;
    IHEAP[$82] = $84;
    ;
    return;
  }
  __Z11lua_rawsetiP9lua_Stateii.__index__ = Runtime.getFunctionIndex(__Z11lua_rawsetiP9lua_Stateii, "__Z11lua_rawsetiP9lua_Stateii");
  
  
  function __Z16lua_setmetatableP9lua_Statei($L, $objindex) {
    ;
    var __label__;
    var $1;
    var $2;
    var $obj;
    var $mt;
    $1 = $L;
    $2 = $objindex;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z9index2adrP9lua_Statei($3, $4);
    $obj = $5;
    var $6 = $1;
    var $7 = $6+8;
    var $8 = IHEAP[$7];
    var $9 = $8+-12;
    var $10 = $9+8;
    var $11 = IHEAP[$10];
    var $12 = $11 == 0;
    ;
    if ($12) {
      ;
      $mt = 0;
      ;
    }
    else {
      ;
      var $15 = $1;
      var $16 = $15+8;
      var $17 = IHEAP[$16];
      var $18 = $17+-12;
      var $19 = $18;
      var $20 = $19;
      var $21 = $20;
      var $22 = IHEAP[$21];
      var $23 = $22;
      var $24 = $23;
      $mt = $24;
      ;
    }
    var $26 = $obj;
    var $27 = $26+8;
    var $28 = IHEAP[$27];
    if ($28 == 5) {
      __label__ = 10; /* $29 */ 
    }
    else if ($28 == 7) {
      __label__ = 11; /* $78 */ 
    }
    else {
    __label__ = 12; /* $131 */ 
    }
    
    if (__label__ == 12) {
      var $132 = $mt;
      var $133 = $obj;
      var $134 = $133+8;
      var $135 = IHEAP[$134];
      var $136 = $1;
      var $137 = $136+16;
      var $138 = IHEAP[$137];
      var $139 = $138+132;
      var $140 = $139+$135*4;
      IHEAP[$140] = $132;
      ;
    }
    else if (__label__ == 10) {
      var $30 = $mt;
      var $31 = $obj;
      var $32 = $31;
      var $33 = $32;
      var $34 = $33;
      var $35 = IHEAP[$34];
      var $36 = $35;
      var $37 = $36;
      var $38 = $37+8;
      IHEAP[$38] = $30;
      var $39 = $mt;
      var $40 = $39 != 0;
      ;
      if ($40) {
        ;
        var $42 = $mt;
        var $43 = $42;
        var $44 = $43;
        var $45 = $44;
        var $46 = $45+5;
        var $47 = IHEAP[$46];
        var $48 = $47;
        var $49 = $48 & 3;
        var $50 = $49 != 0;
        ;
        $51$76$11: do { 
          if ($50) {
            ;
            var $52 = $obj;
            var $53 = $52;
            var $54 = $53;
            var $55 = $54;
            var $56 = IHEAP[$55];
            var $57 = $56;
            var $58 = $57;
            var $59 = $58;
            var $60 = $59;
            var $61 = $60;
            var $62 = $61+5;
            var $63 = IHEAP[$62];
            var $64 = $63;
            var $65 = $64 & 4;
            var $66 = $65 != 0;
            if (!($66)) { __label__ = 2; /* $76 */ break $51$76$11; }
            var $68 = $1;
            var $69 = $obj;
            var $70 = $69;
            var $71 = $70;
            var $72 = $71;
            var $73 = IHEAP[$72];
            var $74 = $73;
            var $75 = $74;
            __Z16luaC_barrierbackP9lua_StateP5Table($68, $75);
            ;
          }
        } while(0);
        ;
      }
      ;
    }
    else if (__label__ == 11) {
      var $79 = $mt;
      var $80 = $obj;
      var $81 = $80;
      var $82 = $81;
      var $83 = $82;
      var $84 = IHEAP[$83];
      var $85 = $84;
      var $86 = $85;
      var $87 = $86;
      var $88 = $87+8;
      IHEAP[$88] = $79;
      var $89 = $mt;
      var $90 = $89 != 0;
      ;
      if ($90) {
        ;
        var $92 = $mt;
        var $93 = $92;
        var $94 = $93;
        var $95 = $94;
        var $96 = $95+5;
        var $97 = IHEAP[$96];
        var $98 = $97;
        var $99 = $98 & 3;
        var $100 = $99 != 0;
        ;
        $101$129$19: do { 
          if ($100) {
            ;
            var $102 = $obj;
            var $103 = $102;
            var $104 = $103;
            var $105 = $104;
            var $106 = IHEAP[$105];
            var $107 = $106;
            var $108 = $107;
            var $109 = $108;
            var $110 = $109;
            var $111 = $110;
            var $112 = $111+5;
            var $113 = IHEAP[$112];
            var $114 = $113;
            var $115 = $114 & 4;
            var $116 = $115 != 0;
            if (!($116)) { __label__ = 7; /* $129 */ break $101$129$19; }
            var $118 = $1;
            var $119 = $obj;
            var $120 = $119;
            var $121 = $120;
            var $122 = $121;
            var $123 = IHEAP[$122];
            var $124 = $123;
            var $125 = $124;
            var $126 = $125;
            var $127 = $mt;
            var $128 = $127;
            __Z13luaC_barrierfP9lua_StateP8GCObjectS2_($118, $126, $128);
            ;
          }
        } while(0);
        ;
      }
      ;
    }
    var $142 = $1;
    var $143 = $142+8;
    var $144 = IHEAP[$143];
    var $145 = $144+-12;
    IHEAP[$143] = $145;
    ;
    return 1;
  }
  __Z16lua_setmetatableP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z16lua_setmetatableP9lua_Statei, "__Z16lua_setmetatableP9lua_Statei");
  
  
  function __Z11lua_setfenvP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var $1;
    var $2;
    var $o;
    var $res;
    var $i_o;
    $1 = $L;
    $2 = $idx;
    $res = 1;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z9index2adrP9lua_Statei($3, $4);
    $o = $5;
    var $6 = $o;
    var $7 = $6+8;
    var $8 = IHEAP[$7];
    if ($8 == 6) {
      __label__ = 5; /* $9 */ 
    }
    else if ($8 == 7) {
      __label__ = 6; /* $29 */ 
    }
    else if ($8 == 8) {
      __label__ = 7; /* $49 */ 
    }
    else {
    __label__ = 8; /* $74 */ 
    }
    
    if (__label__ == 8) {
      $res = 0;
      ;
    }
    else if (__label__ == 5) {
      var $10 = $1;
      var $11 = $10+8;
      var $12 = IHEAP[$11];
      var $13 = $12+-12;
      var $14 = $13;
      var $15 = $14;
      var $16 = $15;
      var $17 = IHEAP[$16];
      var $18 = $17;
      var $19 = $18;
      var $20 = $o;
      var $21 = $20;
      var $22 = $21;
      var $23 = $22;
      var $24 = IHEAP[$23];
      var $25 = $24;
      var $26 = $25;
      var $27 = $26;
      var $28 = $27+12;
      IHEAP[$28] = $19;
      ;
    }
    else if (__label__ == 6) {
      var $30 = $1;
      var $31 = $30+8;
      var $32 = IHEAP[$31];
      var $33 = $32+-12;
      var $34 = $33;
      var $35 = $34;
      var $36 = $35;
      var $37 = IHEAP[$36];
      var $38 = $37;
      var $39 = $38;
      var $40 = $o;
      var $41 = $40;
      var $42 = $41;
      var $43 = $42;
      var $44 = IHEAP[$43];
      var $45 = $44;
      var $46 = $45;
      var $47 = $46;
      var $48 = $47+12;
      IHEAP[$48] = $39;
      ;
    }
    else if (__label__ == 7) {
      var $50 = $o;
      var $51 = $50;
      var $52 = $51;
      var $53 = $52;
      var $54 = IHEAP[$53];
      var $55 = $54;
      var $56 = $55+72;
      $i_o = $56;
      var $57 = $1;
      var $58 = $57+8;
      var $59 = IHEAP[$58];
      var $60 = $59+-12;
      var $61 = $60;
      var $62 = $61;
      var $63 = $62;
      var $64 = IHEAP[$63];
      var $65 = $64;
      var $66 = $65;
      var $67 = $66;
      var $68 = $i_o;
      var $69 = $68;
      var $70 = $69;
      var $71 = $70;
      IHEAP[$71] = $67;
      var $72 = $i_o;
      var $73 = $72+8;
      IHEAP[$73] = 5;
      ;
    }
    var $76 = $res;
    var $77 = $76 != 0;
    ;
    if ($77) {
      ;
      var $79 = $1;
      var $80 = $79+8;
      var $81 = IHEAP[$80];
      var $82 = $81+-12;
      var $83 = $82;
      var $84 = $83;
      var $85 = $84;
      var $86 = IHEAP[$85];
      var $87 = $86;
      var $88 = $87;
      var $89 = $88;
      var $90 = $89;
      var $91 = $90;
      var $92 = $91+5;
      var $93 = IHEAP[$92];
      var $94 = $93;
      var $95 = $94 & 3;
      var $96 = $95 != 0;
      ;
      $97$128$10: do { 
        if ($96) {
          ;
          var $98 = $o;
          var $99 = $98;
          var $100 = $99;
          var $101 = $100;
          var $102 = IHEAP[$101];
          var $103 = $102;
          var $104 = $103;
          var $105 = $104+5;
          var $106 = IHEAP[$105];
          var $107 = $106;
          var $108 = $107 & 4;
          var $109 = $108 != 0;
          if (!($109)) { __label__ = 2; /* $128 */ break $97$128$10; }
          var $111 = $1;
          var $112 = $o;
          var $113 = $112;
          var $114 = $113;
          var $115 = $114;
          var $116 = IHEAP[$115];
          var $117 = $1;
          var $118 = $117+8;
          var $119 = IHEAP[$118];
          var $120 = $119+-12;
          var $121 = $120;
          var $122 = $121;
          var $123 = $122;
          var $124 = IHEAP[$123];
          var $125 = $124;
          var $126 = $125;
          var $127 = $126;
          __Z13luaC_barrierfP9lua_StateP8GCObjectS2_($111, $116, $127);
          ;
        }
      } while(0);
      ;
    }
    var $130 = $1;
    var $131 = $130+8;
    var $132 = IHEAP[$131];
    var $133 = $132+-12;
    IHEAP[$131] = $133;
    var $134 = $res;
    ;
    return $134;
  }
  __Z11lua_setfenvP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z11lua_setfenvP9lua_Statei, "__Z11lua_setfenvP9lua_Statei");
  
  
  function __Z8lua_callP9lua_Stateii($L, $nargs, $nresults) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $func;
    $1 = $L;
    $2 = $nargs;
    $3 = $nresults;
    var $4 = $1;
    var $5 = $4+8;
    var $6 = IHEAP[$5];
    var $7 = $2;
    var $8 = $7 + 1;
    var $9 = 0 - $8;
    var $10 = $6+12*$9;
    $func = $10;
    var $11 = $1;
    var $12 = $func;
    var $13 = $3;
    __Z9luaD_callP9lua_StateP10lua_TValuei($11, $12, $13);
    var $14 = $3;
    var $15 = $14 == -1;
    ;
    $16$34$2: do { 
      if ($15) {
        ;
        var $17 = $1;
        var $18 = $17+8;
        var $19 = IHEAP[$18];
        var $20 = $1;
        var $21 = $20+20;
        var $22 = IHEAP[$21];
        var $23 = $22+8;
        var $24 = IHEAP[$23];
        var $25 = $19 >= $24;
        if (!($25)) { __label__ = 1; /* $34 */ break $16$34$2; }
        var $27 = $1;
        var $28 = $27+8;
        var $29 = IHEAP[$28];
        var $30 = $1;
        var $31 = $30+20;
        var $32 = IHEAP[$31];
        var $33 = $32+8;
        IHEAP[$33] = $29;
        ;
      }
    } while(0);
    ;
    return;
  }
  __Z8lua_callP9lua_Stateii.__index__ = Runtime.getFunctionIndex(__Z8lua_callP9lua_Stateii, "__Z8lua_callP9lua_Stateii");
  
  
  function __Z9lua_pcallP9lua_Stateiii($L, $nargs, $nresults, $errfunc) {
    var __stackBase__  = STACKTOP; STACKTOP += 8; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $c = __stackBase__;
    var $status;
    var $func;
    var $o;
    $1 = $L;
    $2 = $nargs;
    $3 = $nresults;
    $4 = $errfunc;
    var $5 = $4;
    var $6 = $5 == 0;
    ;
    if ($6) {
      ;
      $func = 0;
      ;
    }
    else {
      ;
      var $9 = $1;
      var $10 = $4;
      var $11 = __Z9index2adrP9lua_Statei($9, $10);
      $o = $11;
      var $12 = $o;
      var $13 = $12;
      var $14 = $1;
      var $15 = $14+32;
      var $16 = IHEAP[$15];
      var $17 = $16;
      var $18 = $13;
      var $19 = $17;
      var $20 = $18 - $19;
      $func = $20;
      ;
    }
    var $22 = $1;
    var $23 = $22+8;
    var $24 = IHEAP[$23];
    var $25 = $2;
    var $26 = $25 + 1;
    var $27 = 0 - $26;
    var $28 = $24+12*$27;
    var $29 = $c;
    IHEAP[$29] = $28;
    var $30 = $3;
    var $31 = $c+4;
    IHEAP[$31] = $30;
    var $32 = $1;
    var $33 = $c;
    var $34 = $c;
    var $35 = IHEAP[$34];
    var $36 = $35;
    var $37 = $1;
    var $38 = $37+32;
    var $39 = IHEAP[$38];
    var $40 = $39;
    var $41 = $36;
    var $42 = $40;
    var $43 = $41 - $42;
    var $44 = $func;
    var $45 = __Z10luaD_pcallP9lua_StatePFvS0_PvES1_ii($32, __Z6f_callP9lua_StatePv.__index__, $33, $43, $44);
    $status = $45;
    var $46 = $3;
    var $47 = $46 == -1;
    ;
    $48$66$6: do { 
      if ($47) {
        ;
        var $49 = $1;
        var $50 = $49+8;
        var $51 = IHEAP[$50];
        var $52 = $1;
        var $53 = $52+20;
        var $54 = IHEAP[$53];
        var $55 = $54+8;
        var $56 = IHEAP[$55];
        var $57 = $51 >= $56;
        if (!($57)) { __label__ = 2; /* $66 */ break $48$66$6; }
        var $59 = $1;
        var $60 = $59+8;
        var $61 = IHEAP[$60];
        var $62 = $1;
        var $63 = $62+20;
        var $64 = IHEAP[$63];
        var $65 = $64+8;
        IHEAP[$65] = $61;
        ;
      }
    } while(0);
    var $67 = $status;
    STACKTOP = __stackBase__;
    return $67;
  }
  __Z9lua_pcallP9lua_Stateiii.__index__ = Runtime.getFunctionIndex(__Z9lua_pcallP9lua_Stateiii, "__Z9lua_pcallP9lua_Stateiii");
  
  
  function __Z6f_callP9lua_StatePv($L, $ud) {
    ;
    var __label__;
    var $1;
    var $2;
    var $c;
    $1 = $L;
    $2 = $ud;
    var $3 = $2;
    var $4 = $3;
    $c = $4;
    var $5 = $1;
    var $6 = $c;
    var $7 = $6;
    var $8 = IHEAP[$7];
    var $9 = $c;
    var $10 = $9+4;
    var $11 = IHEAP[$10];
    __Z9luaD_callP9lua_StateP10lua_TValuei($5, $8, $11);
    ;
    return;
  }
  __Z6f_callP9lua_StatePv.__index__ = Runtime.getFunctionIndex(__Z6f_callP9lua_StatePv, "__Z6f_callP9lua_StatePv");
  
  
  function __Z10lua_cpcallP9lua_StatePFiS0_EPv($L, $func, $ud) {
    var __stackBase__  = STACKTOP; STACKTOP += 8; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $c = __stackBase__;
    var $status;
    $1 = $L;
    $2 = $func;
    $3 = $ud;
    var $4 = $2;
    var $5 = $c;
    IHEAP[$5] = $4;
    var $6 = $3;
    var $7 = $c+4;
    IHEAP[$7] = $6;
    var $8 = $1;
    var $9 = $c;
    var $10 = $1;
    var $11 = $10+8;
    var $12 = IHEAP[$11];
    var $13 = $12;
    var $14 = $1;
    var $15 = $14+32;
    var $16 = IHEAP[$15];
    var $17 = $16;
    var $18 = $13;
    var $19 = $17;
    var $20 = $18 - $19;
    var $21 = __Z10luaD_pcallP9lua_StatePFvS0_PvES1_ii($8, __Z7f_CcallP9lua_StatePv.__index__, $9, $20, 0);
    $status = $21;
    var $22 = $status;
    STACKTOP = __stackBase__;
    return $22;
  }
  __Z10lua_cpcallP9lua_StatePFiS0_EPv.__index__ = Runtime.getFunctionIndex(__Z10lua_cpcallP9lua_StatePFiS0_EPv, "__Z10lua_cpcallP9lua_StatePFiS0_EPv");
  
  
  function __Z7f_CcallP9lua_StatePv($L, $ud) {
    ;
    var __label__;
    var $1;
    var $2;
    var $c;
    var $cl;
    var $i_o;
    var $i_o1;
    $1 = $L;
    $2 = $ud;
    var $3 = $2;
    var $4 = $3;
    $c = $4;
    var $5 = $1;
    var $6 = $1;
    var $7 = __Z10getcurrenvP9lua_State($6);
    var $8 = __Z16luaF_newCclosureP9lua_StateiP5Table($5, 0, $7);
    $cl = $8;
    var $9 = $c;
    var $10 = $9;
    var $11 = IHEAP[$10];
    var $12 = $cl;
    var $13 = $12;
    var $14 = $13+16;
    IHEAP[$14] = $11;
    var $15 = $1;
    var $16 = $15+8;
    var $17 = IHEAP[$16];
    $i_o = $17;
    var $18 = $cl;
    var $19 = $18;
    var $20 = $i_o;
    var $21 = $20;
    var $22 = $21;
    var $23 = $22;
    IHEAP[$23] = $19;
    var $24 = $i_o;
    var $25 = $24+8;
    IHEAP[$25] = 6;
    var $26 = $1;
    var $27 = $26+8;
    var $28 = IHEAP[$27];
    var $29 = $28+12;
    IHEAP[$27] = $29;
    var $30 = $1;
    var $31 = $30+8;
    var $32 = IHEAP[$31];
    $i_o1 = $32;
    var $33 = $c;
    var $34 = $33+4;
    var $35 = IHEAP[$34];
    var $36 = $i_o1;
    var $37 = $36;
    var $38 = $37;
    var $39 = $38;
    IHEAP[$39] = $35;
    var $40 = $i_o1;
    var $41 = $40+8;
    IHEAP[$41] = 2;
    var $42 = $1;
    var $43 = $42+8;
    var $44 = IHEAP[$43];
    var $45 = $44+12;
    IHEAP[$43] = $45;
    var $46 = $1;
    var $47 = $1;
    var $48 = $47+8;
    var $49 = IHEAP[$48];
    var $50 = $49+-24;
    __Z9luaD_callP9lua_StateP10lua_TValuei($46, $50, 0);
    ;
    return;
  }
  __Z7f_CcallP9lua_StatePv.__index__ = Runtime.getFunctionIndex(__Z7f_CcallP9lua_StatePv, "__Z7f_CcallP9lua_StatePv");
  
  
  function __Z8lua_loadP9lua_StatePFPKcS0_PvPjES3_S2_($L, $reader, $data, $chunkname) {
    var __stackBase__  = STACKTOP; STACKTOP += 20; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $z = __stackBase__;
    var $status;
    $1 = $L;
    $2 = $reader;
    $3 = $data;
    $4 = $chunkname;
    var $5 = $4;
    var $6 = $5 != 0;
    ;
    if (!$6) {
      ;
      $4 = __str230;
      ;
    }
    var $9 = $1;
    var $10 = $2;
    var $11 = $3;
    __Z9luaZ_initP9lua_StateP3ZioPFPKcS0_PvPjES5_($9, $z, $10, $11);
    var $12 = $1;
    var $13 = $4;
    var $14 = __Z20luaD_protectedparserP9lua_StateP3ZioPKc($12, $z, $13);
    $status = $14;
    var $15 = $status;
    STACKTOP = __stackBase__;
    return $15;
  }
  __Z8lua_loadP9lua_StatePFPKcS0_PvPjES3_S2_.__index__ = Runtime.getFunctionIndex(__Z8lua_loadP9lua_StatePFPKcS0_PvPjES3_S2_, "__Z8lua_loadP9lua_StatePFPKcS0_PvPjES3_S2_");
  
  
  function __Z8lua_dumpP9lua_StatePFiS0_PKvjPvES3_($L, $writer, $data) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $status;
    var $o;
    $1 = $L;
    $2 = $writer;
    $3 = $data;
    var $4 = $1;
    var $5 = $4+8;
    var $6 = IHEAP[$5];
    var $7 = $6+-12;
    $o = $7;
    var $8 = $o;
    var $9 = $8+8;
    var $10 = IHEAP[$9];
    var $11 = $10 == 6;
    ;
    $12$40$2: do { 
      if ($11) {
        ;
        var $13 = $o;
        var $14 = $13;
        var $15 = $14;
        var $16 = $15;
        var $17 = IHEAP[$16];
        var $18 = $17;
        var $19 = $18;
        var $20 = $19;
        var $21 = $20+6;
        var $22 = IHEAP[$21];
        var $23 = $22 != 0;
        if ($23) { __label__ = 0; /* $40 */ break $12$40$2; }
        var $25 = $1;
        var $26 = $o;
        var $27 = $26;
        var $28 = $27;
        var $29 = $28;
        var $30 = IHEAP[$29];
        var $31 = $30;
        var $32 = $31;
        var $33 = $32;
        var $34 = $33;
        var $35 = $34+16;
        var $36 = IHEAP[$35];
        var $37 = $2;
        var $38 = $3;
        var $39 = __Z9luaU_dumpP9lua_StatePK5ProtoPFiS0_PKvjPvES6_i($25, $36, $37, $38, 0);
        $status = $39;
        __label__ = 2; /* $41 */ break $12$40$2;
      }
      else {
        __label__ = 0; /* $40 */ 
      }
    } while(0);
    if (__label__ == 0) {
      $status = 1;
      ;
    }
    var $42 = $status;
    ;
    return $42;
  }
  __Z8lua_dumpP9lua_StatePFiS0_PKvjPvES3_.__index__ = Runtime.getFunctionIndex(__Z8lua_dumpP9lua_StatePFiS0_PKvjPvES3_, "__Z8lua_dumpP9lua_StatePFiS0_PKvjPvES3_");
  
  
  function __Z10lua_statusP9lua_State($L) {
    ;
    var __label__;
    var $1;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+6;
    var $4 = IHEAP[$3];
    var $5 = $4;
    ;
    return $5;
  }
  __Z10lua_statusP9lua_State.__index__ = Runtime.getFunctionIndex(__Z10lua_statusP9lua_State, "__Z10lua_statusP9lua_State");
  
  
  function __Z6lua_gcP9lua_Stateii($L, $what, $data) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $res;
    var $g;
    var $a;
    $1 = $L;
    $2 = $what;
    $3 = $data;
    $res = 0;
    var $4 = $1;
    var $5 = $4+16;
    var $6 = IHEAP[$5];
    $g = $6;
    var $7 = $2;
    if ($7 == 0) {
      __label__ = 8; /* $8 */ 
    }
    else if ($7 == 1) {
      __label__ = 9; /* $11 */ 
    }
    else if ($7 == 2) {
      __label__ = 10; /* $17 */ 
    }
    else if ($7 == 3) {
      __label__ = 11; /* $19 */ 
    }
    else if ($7 == 4) {
      __label__ = 12; /* $24 */ 
    }
    else if ($7 == 5) {
      __label__ = 13; /* $29 */ 
    }
    else if ($7 == 6) {
      __label__ = 14; /* $67 */ 
    }
    else if ($7 == 7) {
      __label__ = 15; /* $74 */ 
    }
    else {
    __label__ = 16; /* $81 */ 
    }
    
    if (__label__ == 16) {
      $res = -1;
      ;
    }
    else if (__label__ == 8) {
      var $9 = $g;
      var $10 = $9+64;
      IHEAP[$10] = -3;
      ;
    }
    else if (__label__ == 9) {
      var $12 = $g;
      var $13 = $12+68;
      var $14 = IHEAP[$13];
      var $15 = $g;
      var $16 = $15+64;
      IHEAP[$16] = $14;
      ;
    }
    else if (__label__ == 10) {
      var $18 = $1;
      __Z11luaC_fullgcP9lua_State($18);
      ;
    }
    else if (__label__ == 11) {
      var $20 = $g;
      var $21 = $20+68;
      var $22 = IHEAP[$21];
      var $23 = $22 >> 10;
      $res = $23;
      ;
    }
    else if (__label__ == 12) {
      var $25 = $g;
      var $26 = $25+68;
      var $27 = IHEAP[$26];
      var $28 = $27 & 1023;
      $res = $28;
      ;
    }
    else if (__label__ == 13) {
      var $30 = $3;
      var $31 = $30 << 10;
      $a = $31;
      var $32 = $a;
      var $33 = $g;
      var $34 = $33+68;
      var $35 = IHEAP[$34];
      var $36 = unSign($32, 32) <= unSign($35, 32);
      ;
      if ($36) {
        ;
        var $38 = $g;
        var $39 = $38+68;
        var $40 = IHEAP[$39];
        var $41 = $a;
        var $42 = $40 - $41;
        var $43 = $g;
        var $44 = $43+64;
        IHEAP[$44] = $42;
        ;
      }
      else {
        ;
        var $46 = $g;
        var $47 = $46+64;
        IHEAP[$47] = 0;
        ;
      }
      ;
      $49$14: while(1) { // $49
        var $50 = $g;
        var $51 = $50+64;
        var $52 = IHEAP[$51];
        var $53 = $g;
        var $54 = $53+68;
        var $55 = IHEAP[$54];
        var $56 = unSign($52, 32) <= unSign($55, 32);
        if (!($56)) { __label__ = 4; /* $66 */ break $49$14; }
        var $58 = $1;
        __Z9luaC_stepP9lua_State($58);
        var $59 = $g;
        var $60 = $59+21;
        var $61 = IHEAP[$60];
        var $62 = $61;
        var $63 = $62 == 0;
        if ($63) { __label__ = 5; /* $64 */ break $49$14; }
        __label__ = 2; /* $49 */ continue $49$14;
      }
      if (__label__ == 5) {
        $res = 1;
        ;
      }
      ;
    }
    else if (__label__ == 14) {
      var $68 = $g;
      var $69 = $68+80;
      var $70 = IHEAP[$69];
      $res = $70;
      var $71 = $3;
      var $72 = $g;
      var $73 = $72+80;
      IHEAP[$73] = $71;
      ;
    }
    else if (__label__ == 15) {
      var $75 = $g;
      var $76 = $75+84;
      var $77 = IHEAP[$76];
      $res = $77;
      var $78 = $3;
      var $79 = $g;
      var $80 = $79+84;
      IHEAP[$80] = $78;
      ;
    }
    var $83 = $res;
    ;
    return $83;
  }
  __Z6lua_gcP9lua_Stateii.__index__ = Runtime.getFunctionIndex(__Z6lua_gcP9lua_Stateii, "__Z6lua_gcP9lua_Stateii");
  
  
  function __Z9lua_errorP9lua_State($L) {
    ;
    var __label__;
    var $1;
    $1 = $L;
    var $2 = $1;
    __Z13luaG_errormsgP9lua_State($2);
    ;
    return 0;
  }
  __Z9lua_errorP9lua_State.__index__ = Runtime.getFunctionIndex(__Z9lua_errorP9lua_State, "__Z9lua_errorP9lua_State");
  
  
  function __Z8lua_nextP9lua_Statei($L, $idx) {
    ;
    var __label__;
    var $1;
    var $2;
    var $t;
    var $more;
    $1 = $L;
    $2 = $idx;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z9index2adrP9lua_Statei($3, $4);
    $t = $5;
    var $6 = $1;
    var $7 = $t;
    var $8 = $7;
    var $9 = $8;
    var $10 = $9;
    var $11 = IHEAP[$10];
    var $12 = $11;
    var $13 = $12;
    var $14 = $1;
    var $15 = $14+8;
    var $16 = IHEAP[$15];
    var $17 = $16+-12;
    var $18 = __Z9luaH_nextP9lua_StateP5TableP10lua_TValue($6, $13, $17);
    $more = $18;
    var $19 = $more;
    var $20 = $19 != 0;
    ;
    if ($20) {
      ;
      var $22 = $1;
      var $23 = $22+8;
      var $24 = IHEAP[$23];
      var $25 = $24+12;
      IHEAP[$23] = $25;
      ;
    }
    else {
      ;
      var $27 = $1;
      var $28 = $27+8;
      var $29 = IHEAP[$28];
      var $30 = $29+-12;
      IHEAP[$28] = $30;
      ;
    }
    var $32 = $more;
    ;
    return $32;
  }
  __Z8lua_nextP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z8lua_nextP9lua_Statei, "__Z8lua_nextP9lua_Statei");
  
  
  function __Z10lua_concatP9lua_Statei($L, $n) {
    ;
    var __label__;
    var $1;
    var $2;
    var $i_o;
    $1 = $L;
    $2 = $n;
    var $3 = $2;
    var $4 = $3 >= 2;
    ;
    if ($4) {
      ;
      var $6 = $1;
      var $7 = $6+16;
      var $8 = IHEAP[$7];
      var $9 = $8+68;
      var $10 = IHEAP[$9];
      var $11 = $1;
      var $12 = $11+16;
      var $13 = IHEAP[$12];
      var $14 = $13+64;
      var $15 = IHEAP[$14];
      var $16 = unSign($10, 32) >= unSign($15, 32);
      ;
      if ($16) {
        ;
        var $18 = $1;
        __Z9luaC_stepP9lua_State($18);
        ;
      }
      var $20 = $1;
      var $21 = $2;
      var $22 = $1;
      var $23 = $22+8;
      var $24 = IHEAP[$23];
      var $25 = $1;
      var $26 = $25+12;
      var $27 = IHEAP[$26];
      var $28 = $24;
      var $29 = $27;
      var $30 = $28 - $29;
      var $31 = Math.floor($30 / 12);
      var $32 = $31 - 1;
      __Z11luaV_concatP9lua_Stateii($20, $21, $32);
      var $33 = $2;
      var $34 = $33 - 1;
      var $35 = $1;
      var $36 = $35+8;
      var $37 = IHEAP[$36];
      var $38 = 0 - $34;
      var $39 = $37+12*$38;
      IHEAP[$36] = $39;
      ;
    }
    else {
      ;
      var $41 = $2;
      var $42 = $41 == 0;
      ;
      if ($42) {
        ;
        var $44 = $1;
        var $45 = $44+8;
        var $46 = IHEAP[$45];
        $i_o = $46;
        var $47 = $1;
        var $48 = __Z12luaS_newlstrP9lua_StatePKcj($47, __str331, 0);
        var $49 = $48;
        var $50 = $i_o;
        var $51 = $50;
        var $52 = $51;
        var $53 = $52;
        IHEAP[$53] = $49;
        var $54 = $i_o;
        var $55 = $54+8;
        IHEAP[$55] = 4;
        var $56 = $1;
        var $57 = $56+8;
        var $58 = IHEAP[$57];
        var $59 = $58+12;
        IHEAP[$57] = $59;
        ;
      }
      ;
    }
    ;
    return;
  }
  __Z10lua_concatP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z10lua_concatP9lua_Statei, "__Z10lua_concatP9lua_Statei");
  
  
  function __Z13lua_getallocfP9lua_StatePPv($L, $ud) {
    ;
    var __label__;
    var $1;
    var $2;
    var $f;
    $1 = $L;
    $2 = $ud;
    var $3 = $2;
    var $4 = $3 != 0;
    ;
    if ($4) {
      ;
      var $6 = $1;
      var $7 = $6+16;
      var $8 = IHEAP[$7];
      var $9 = $8+16;
      var $10 = IHEAP[$9];
      var $11 = $2;
      IHEAP[$11] = $10;
      ;
    }
    var $13 = $1;
    var $14 = $13+16;
    var $15 = IHEAP[$14];
    var $16 = $15+12;
    var $17 = IHEAP[$16];
    $f = $17;
    var $18 = $f;
    ;
    return $18;
  }
  __Z13lua_getallocfP9lua_StatePPv.__index__ = Runtime.getFunctionIndex(__Z13lua_getallocfP9lua_StatePPv, "__Z13lua_getallocfP9lua_StatePPv");
  
  
  function __Z13lua_setallocfP9lua_StatePFPvS1_S1_jjES1_($L, $f, $ud) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    $1 = $L;
    $2 = $f;
    $3 = $ud;
    var $4 = $3;
    var $5 = $1;
    var $6 = $5+16;
    var $7 = IHEAP[$6];
    var $8 = $7+16;
    IHEAP[$8] = $4;
    var $9 = $2;
    var $10 = $1;
    var $11 = $10+16;
    var $12 = IHEAP[$11];
    var $13 = $12+12;
    IHEAP[$13] = $9;
    ;
    return;
  }
  __Z13lua_setallocfP9lua_StatePFPvS1_S1_jjES1_.__index__ = Runtime.getFunctionIndex(__Z13lua_setallocfP9lua_StatePFPvS1_S1_jjES1_, "__Z13lua_setallocfP9lua_StatePFPvS1_S1_jjES1_");
  
  
  function __Z15lua_newuserdataP9lua_Statej($L, $size) {
    ;
    var __label__;
    var $1;
    var $2;
    var $u;
    var $i_o;
    $1 = $L;
    $2 = $size;
    var $3 = $1;
    var $4 = $3+16;
    var $5 = IHEAP[$4];
    var $6 = $5+68;
    var $7 = IHEAP[$6];
    var $8 = $1;
    var $9 = $8+16;
    var $10 = IHEAP[$9];
    var $11 = $10+64;
    var $12 = IHEAP[$11];
    var $13 = unSign($7, 32) >= unSign($12, 32);
    ;
    if ($13) {
      ;
      var $15 = $1;
      __Z9luaC_stepP9lua_State($15);
      ;
    }
    var $17 = $1;
    var $18 = $2;
    var $19 = $1;
    var $20 = __Z10getcurrenvP9lua_State($19);
    var $21 = __Z13luaS_newudataP9lua_StatejP5Table($17, $18, $20);
    $u = $21;
    var $22 = $1;
    var $23 = $22+8;
    var $24 = IHEAP[$23];
    $i_o = $24;
    var $25 = $u;
    var $26 = $25;
    var $27 = $i_o;
    var $28 = $27;
    var $29 = $28;
    var $30 = $29;
    IHEAP[$30] = $26;
    var $31 = $i_o;
    var $32 = $31+8;
    IHEAP[$32] = 7;
    var $33 = $1;
    var $34 = $33+8;
    var $35 = IHEAP[$34];
    var $36 = $35+12;
    IHEAP[$34] = $36;
    var $37 = $u;
    var $38 = $37+20;
    var $39 = $38;
    ;
    return $39;
  }
  __Z15lua_newuserdataP9lua_Statej.__index__ = Runtime.getFunctionIndex(__Z15lua_newuserdataP9lua_Statej, "__Z15lua_newuserdataP9lua_Statej");
  
  
  function __Z14lua_getupvalueP9lua_Stateii($L, $funcindex, $n) {
    var __stackBase__  = STACKTOP; STACKTOP += 4; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $name;
    var $val = __stackBase__;
    var $o2;
    var $o1;
    $1 = $L;
    $2 = $funcindex;
    $3 = $n;
    var $4 = $1;
    var $5 = $2;
    var $6 = __Z9index2adrP9lua_Statei($4, $5);
    var $7 = $3;
    var $8 = __Z11aux_upvalueP10lua_TValueiPS0_($6, $7, $val);
    $name = $8;
    var $9 = $name;
    var $10 = $9 != 0;
    ;
    if ($10) {
      ;
      var $12 = IHEAP[$val];
      $o2 = $12;
      var $13 = $1;
      var $14 = $13+8;
      var $15 = IHEAP[$14];
      $o1 = $15;
      var $16 = $o1;
      var $17 = $16;
      var $18 = $o2;
      var $19 = $18;
      var $20 = $17;
      var $21 = $19;
      _llvm_memcpy_p0i8_p0i8_i32($20, $21, 8, 4, 0);
      var $22 = $o2;
      var $23 = $22+8;
      var $24 = IHEAP[$23];
      var $25 = $o1;
      var $26 = $25+8;
      IHEAP[$26] = $24;
      var $27 = $1;
      var $28 = $27+8;
      var $29 = IHEAP[$28];
      var $30 = $29+12;
      IHEAP[$28] = $30;
      ;
    }
    var $32 = $name;
    STACKTOP = __stackBase__;
    return $32;
  }
  __Z14lua_getupvalueP9lua_Stateii.__index__ = Runtime.getFunctionIndex(__Z14lua_getupvalueP9lua_Stateii, "__Z14lua_getupvalueP9lua_Stateii");
  
  
  function __Z11aux_upvalueP10lua_TValueiPS0_($fi, $n, $val) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $f;
    var $p;
    $2 = $fi;
    $3 = $n;
    $4 = $val;
    var $5 = $2;
    var $6 = $5+8;
    var $7 = IHEAP[$6];
    var $8 = $7 == 6;
    ;
    $10$9$2: do { 
      if ($8) {
        ;
        var $11 = $2;
        var $12 = $11;
        var $13 = $12;
        var $14 = $13;
        var $15 = IHEAP[$14];
        var $16 = $15;
        var $17 = $16;
        $f = $17;
        var $18 = $f;
        var $19 = $18;
        var $20 = $19+6;
        var $21 = IHEAP[$20];
        var $22 = $21 != 0;
        ;
        if ($22) {
          ;
          var $24 = $3;
          var $25 = 1 <= $24;
          ;
          $26$34$6: do { 
            if ($25) {
              ;
              var $27 = $3;
              var $28 = $f;
              var $29 = $28;
              var $30 = $29+7;
              var $31 = IHEAP[$30];
              var $32 = $31;
              var $33 = $27 <= $32;
              if (!($33)) { __label__ = 2; /* $34 */ break $26$34$6; }
              var $36 = $3;
              var $37 = $36 - 1;
              var $38 = $f;
              var $39 = $38;
              var $40 = $39+20;
              var $41 = $40+$37*12;
              var $42 = $4;
              IHEAP[$42] = $41;
              $1 = __str331;
              __label__ = 3; /* $79 */ break $10$9$2;
            }
          } while(0);
          $1 = 0;
          ;
        }
        else {
          ;
          var $44 = $f;
          var $45 = $44;
          var $46 = $45;
          var $47 = $46+16;
          var $48 = IHEAP[$47];
          $p = $48;
          var $49 = $3;
          var $50 = 1 <= $49;
          ;
          $51$57$11: do { 
            if ($50) {
              ;
              var $52 = $3;
              var $53 = $p;
              var $54 = $53+36;
              var $55 = IHEAP[$54];
              var $56 = $52 <= $55;
              if (!($56)) { __label__ = 5; /* $57 */ break $51$57$11; }
              var $59 = $3;
              var $60 = $59 - 1;
              var $61 = $f;
              var $62 = $61;
              var $63 = $62;
              var $64 = $63+20;
              var $65 = $64+$60*4;
              var $66 = IHEAP[$65];
              var $67 = $66+8;
              var $68 = IHEAP[$67];
              var $69 = $4;
              IHEAP[$69] = $68;
              var $70 = $3;
              var $71 = $70 - 1;
              var $72 = $p;
              var $73 = $72+28;
              var $74 = IHEAP[$73];
              var $75 = $74+4*$71;
              var $76 = IHEAP[$75];
              var $77 = $76+16;
              var $78 = $77;
              $1 = $78;
              __label__ = 3; /* $79 */ break $10$9$2;
            }
          } while(0);
          $1 = 0;
          ;
        }
      }
      else {
        ;
        $1 = 0;
        ;
      }
    } while(0);
    var $80 = $1;
    ;
    return $80;
  }
  __Z11aux_upvalueP10lua_TValueiPS0_.__index__ = Runtime.getFunctionIndex(__Z11aux_upvalueP10lua_TValueiPS0_, "__Z11aux_upvalueP10lua_TValueiPS0_");
  
  
  function __Z14lua_setupvalueP9lua_Stateii($L, $funcindex, $n) {
    var __stackBase__  = STACKTOP; STACKTOP += 4; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $name;
    var $val = __stackBase__;
    var $fi;
    var $o2;
    var $o1;
    $1 = $L;
    $2 = $funcindex;
    $3 = $n;
    var $4 = $1;
    var $5 = $2;
    var $6 = __Z9index2adrP9lua_Statei($4, $5);
    $fi = $6;
    var $7 = $fi;
    var $8 = $3;
    var $9 = __Z11aux_upvalueP10lua_TValueiPS0_($7, $8, $val);
    $name = $9;
    var $10 = $name;
    var $11 = $10 != 0;
    ;
    if ($11) {
      ;
      var $13 = $1;
      var $14 = $13+8;
      var $15 = IHEAP[$14];
      var $16 = $15+-12;
      IHEAP[$14] = $16;
      var $17 = $1;
      var $18 = $17+8;
      var $19 = IHEAP[$18];
      $o2 = $19;
      var $20 = IHEAP[$val];
      $o1 = $20;
      var $21 = $o1;
      var $22 = $21;
      var $23 = $o2;
      var $24 = $23;
      var $25 = $22;
      var $26 = $24;
      _llvm_memcpy_p0i8_p0i8_i32($25, $26, 8, 4, 0);
      var $27 = $o2;
      var $28 = $27+8;
      var $29 = IHEAP[$28];
      var $30 = $o1;
      var $31 = $30+8;
      IHEAP[$31] = $29;
      var $32 = $1;
      var $33 = $32+8;
      var $34 = IHEAP[$33];
      var $35 = $34+8;
      var $36 = IHEAP[$35];
      var $37 = $36 >= 4;
      ;
      $38$86$4: do { 
        if ($37) {
          ;
          var $39 = $1;
          var $40 = $39+8;
          var $41 = IHEAP[$40];
          var $42 = $41;
          var $43 = $42;
          var $44 = $43;
          var $45 = IHEAP[$44];
          var $46 = $45;
          var $47 = $46;
          var $48 = $47+5;
          var $49 = IHEAP[$48];
          var $50 = $49;
          var $51 = $50 & 3;
          var $52 = $51 != 0;
          if (!($52)) { __label__ = 1; /* $86 */ break $38$86$4; }
          var $54 = $fi;
          var $55 = $54;
          var $56 = $55;
          var $57 = $56;
          var $58 = IHEAP[$57];
          var $59 = $58;
          var $60 = $59;
          var $61 = $60;
          var $62 = $61;
          var $63 = $62;
          var $64 = $63+5;
          var $65 = IHEAP[$64];
          var $66 = $65;
          var $67 = $66 & 4;
          var $68 = $67 != 0;
          if (!($68)) { __label__ = 1; /* $86 */ break $38$86$4; }
          var $70 = $1;
          var $71 = $fi;
          var $72 = $71;
          var $73 = $72;
          var $74 = $73;
          var $75 = IHEAP[$74];
          var $76 = $75;
          var $77 = $76;
          var $78 = $77;
          var $79 = $1;
          var $80 = $79+8;
          var $81 = IHEAP[$80];
          var $82 = $81;
          var $83 = $82;
          var $84 = $83;
          var $85 = IHEAP[$84];
          __Z13luaC_barrierfP9lua_StateP8GCObjectS2_($70, $78, $85);
          ;
        }
      } while(0);
      ;
    }
    var $88 = $name;
    STACKTOP = __stackBase__;
    return $88;
  }
  __Z14lua_setupvalueP9lua_Stateii.__index__ = Runtime.getFunctionIndex(__Z14lua_setupvalueP9lua_Stateii, "__Z14lua_setupvalueP9lua_Stateii");
  
  
  function __Z8luaK_nilP9FuncStateii($fs, $from, $n) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $previous;
    var $pfrom;
    var $pto;
    $1 = $fs;
    $2 = $from;
    $3 = $n;
    var $4 = $1;
    var $5 = $4+24;
    var $6 = IHEAP[$5];
    var $7 = $1;
    var $8 = $7+28;
    var $9 = IHEAP[$8];
    var $10 = $6 > $9;
    ;
    $11$81$2: do { 
      if ($10) {
        ;
        var $12 = $1;
        var $13 = $12+24;
        var $14 = IHEAP[$13];
        var $15 = $14 == 0;
        ;
        if ($15) {
          ;
          var $17 = $2;
          var $18 = $1;
          var $19 = $18+50;
          var $20 = IHEAP[$19];
          var $21 = $20;
          var $22 = $17 >= $21;
          ;
          if ($22) {
            ;
            __label__ = 0; /* $89 */ break $11$81$2;
          }
          else {
            ;
            ;
          }
        }
        else {
          ;
          var $26 = $1;
          var $27 = $26+24;
          var $28 = IHEAP[$27];
          var $29 = $28 - 1;
          var $30 = $1;
          var $31 = $30;
          var $32 = IHEAP[$31];
          var $33 = $32+12;
          var $34 = IHEAP[$33];
          var $35 = $34+4*$29;
          $previous = $35;
          var $36 = $previous;
          var $37 = IHEAP[$36];
          var $38 = $37 >> 0;
          var $39 = $38 & 63;
          var $40 = $39 == 3;
          ;
          if ($40) {
            ;
            var $42 = $previous;
            var $43 = IHEAP[$42];
            var $44 = $43 >> 6;
            var $45 = $44 & 255;
            $pfrom = $45;
            var $46 = $previous;
            var $47 = IHEAP[$46];
            var $48 = $47 >> 23;
            var $49 = $48 & 511;
            $pto = $49;
            var $50 = $pfrom;
            var $51 = $2;
            var $52 = $50 <= $51;
            ;
            $53$78$12: do { 
              if ($52) {
                ;
                var $54 = $2;
                var $55 = $pto;
                var $56 = $55 + 1;
                var $57 = $54 <= $56;
                if (!($57)) { __label__ = 3; /* $78 */ break $53$78$12; }
                var $59 = $2;
                var $60 = $3;
                var $61 = $59 + $60;
                var $62 = $61 - 1;
                var $63 = $pto;
                var $64 = $62 > $63;
                ;
                if ($64) {
                  ;
                  var $66 = $previous;
                  var $67 = IHEAP[$66];
                  var $68 = $67 & 8388607;
                  var $69 = $2;
                  var $70 = $3;
                  var $71 = $69 + $70;
                  var $72 = $71 - 1;
                  var $73 = $72 << 23;
                  var $74 = $73 & -8388608;
                  var $75 = $68 | $74;
                  var $76 = $previous;
                  IHEAP[$76] = $75;
                  ;
                }
                __label__ = 0; /* $89 */ break $11$81$2;
              }
            } while(0);
            ;
          }
          ;
        }
        __label__ = 6; /* $81 */ break $11$81$2;
      }
      else {
        __label__ = 6; /* $81 */ 
      }
    } while(0);
    if (__label__ == 6) {
      var $82 = $1;
      var $83 = $2;
      var $84 = $2;
      var $85 = $3;
      var $86 = $84 + $85;
      var $87 = $86 - 1;
      var $88 = __Z12luaK_codeABCP9FuncState6OpCodeiii($82, 3, $83, $87, 0);
      ;
    }
    ;
    return;
  }
  __Z8luaK_nilP9FuncStateii.__index__ = Runtime.getFunctionIndex(__Z8luaK_nilP9FuncStateii, "__Z8luaK_nilP9FuncStateii");
  
  
  function __Z12luaK_codeABCP9FuncState6OpCodeiii($fs, $o, $a, $b, $c) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $5;
    $1 = $fs;
    $2 = $o;
    $3 = $a;
    $4 = $b;
    $5 = $c;
    var $6 = $1;
    var $7 = $2;
    var $8 = $7 << 0;
    var $9 = $3;
    var $10 = $9 << 6;
    var $11 = $8 | $10;
    var $12 = $4;
    var $13 = $12 << 23;
    var $14 = $11 | $13;
    var $15 = $5;
    var $16 = $15 << 14;
    var $17 = $14 | $16;
    var $18 = $1;
    var $19 = $18+12;
    var $20 = IHEAP[$19];
    var $21 = $20+8;
    var $22 = IHEAP[$21];
    var $23 = __Z9luaK_codeP9FuncStateji($6, $17, $22);
    ;
    return $23;
  }
  __Z12luaK_codeABCP9FuncState6OpCodeiii.__index__ = Runtime.getFunctionIndex(__Z12luaK_codeABCP9FuncState6OpCodeiii, "__Z12luaK_codeABCP9FuncState6OpCodeiii");
  
  
  function __Z9luaK_jumpP9FuncState($fs) {
    var __stackBase__  = STACKTOP; STACKTOP += 4; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $jpc;
    var $j = __stackBase__;
    $1 = $fs;
    var $2 = $1;
    var $3 = $2+32;
    var $4 = IHEAP[$3];
    $jpc = $4;
    var $5 = $1;
    var $6 = $5+32;
    IHEAP[$6] = -1;
    var $7 = $1;
    var $8 = __Z12luaK_codeABxP9FuncState6OpCodeij($7, 22, 0, 131070);
    IHEAP[$j] = $8;
    var $9 = $1;
    var $10 = $jpc;
    __Z11luaK_concatP9FuncStatePii($9, $j, $10);
    var $11 = IHEAP[$j];
    STACKTOP = __stackBase__;
    return $11;
  }
  __Z9luaK_jumpP9FuncState.__index__ = Runtime.getFunctionIndex(__Z9luaK_jumpP9FuncState, "__Z9luaK_jumpP9FuncState");
  
  
  function __Z12luaK_codeABxP9FuncState6OpCodeij($fs, $o, $a, $bc) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    $1 = $fs;
    $2 = $o;
    $3 = $a;
    $4 = $bc;
    var $5 = $1;
    var $6 = $2;
    var $7 = $6 << 0;
    var $8 = $3;
    var $9 = $8 << 6;
    var $10 = $7 | $9;
    var $11 = $4;
    var $12 = $11 << 14;
    var $13 = $10 | $12;
    var $14 = $1;
    var $15 = $14+12;
    var $16 = IHEAP[$15];
    var $17 = $16+8;
    var $18 = IHEAP[$17];
    var $19 = __Z9luaK_codeP9FuncStateji($5, $13, $18);
    ;
    return $19;
  }
  __Z12luaK_codeABxP9FuncState6OpCodeij.__index__ = Runtime.getFunctionIndex(__Z12luaK_codeABxP9FuncState6OpCodeij, "__Z12luaK_codeABxP9FuncState6OpCodeij");
  
  
  function __Z11luaK_concatP9FuncStatePii($fs, $l1, $l2) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $list;
    var $next;
    $1 = $fs;
    $2 = $l1;
    $3 = $l2;
    var $4 = $3;
    var $5 = $4 == -1;
    ;
    if ($5) {
      ;
      ;
    }
    else {
      ;
      var $8 = $2;
      var $9 = IHEAP[$8];
      var $10 = $9 == -1;
      ;
      if ($10) {
        ;
        var $12 = $3;
        var $13 = $2;
        IHEAP[$13] = $12;
        ;
      }
      else {
        ;
        var $15 = $2;
        var $16 = IHEAP[$15];
        $list = $16;
        ;
        $17$8: while(1) { // $17
          var $18 = $1;
          var $19 = $list;
          var $20 = __Z7getjumpP9FuncStatei($18, $19);
          $next = $20;
          var $21 = $20 != -1;
          if (!($21)) { __label__ = 4; /* $24 */ break $17$8; }
          var $23 = $next;
          $list = $23;
          __label__ = 2; /* $17 */ continue $17$8;
        }
        var $25 = $1;
        var $26 = $list;
        var $27 = $3;
        __Z7fixjumpP9FuncStateii($25, $26, $27);
        ;
      }
      ;
    }
    ;
    return;
  }
  __Z11luaK_concatP9FuncStatePii.__index__ = Runtime.getFunctionIndex(__Z11luaK_concatP9FuncStatePii, "__Z11luaK_concatP9FuncStatePii");
  
  
  function __Z8luaK_retP9FuncStateii($fs, $first, $nret) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    $1 = $fs;
    $2 = $first;
    $3 = $nret;
    var $4 = $1;
    var $5 = $2;
    var $6 = $3;
    var $7 = $6 + 1;
    var $8 = __Z12luaK_codeABCP9FuncState6OpCodeiii($4, 30, $5, $7, 0);
    ;
    return;
  }
  __Z8luaK_retP9FuncStateii.__index__ = Runtime.getFunctionIndex(__Z8luaK_retP9FuncStateii, "__Z8luaK_retP9FuncStateii");
  
  
  function __Z13luaK_getlabelP9FuncState($fs) {
    ;
    var __label__;
    var $1;
    $1 = $fs;
    var $2 = $1;
    var $3 = $2+24;
    var $4 = IHEAP[$3];
    var $5 = $1;
    var $6 = $5+28;
    IHEAP[$6] = $4;
    var $7 = $1;
    var $8 = $7+24;
    var $9 = IHEAP[$8];
    ;
    return $9;
  }
  __Z13luaK_getlabelP9FuncState.__index__ = Runtime.getFunctionIndex(__Z13luaK_getlabelP9FuncState, "__Z13luaK_getlabelP9FuncState");
  
  
  function __Z14luaK_patchlistP9FuncStateii($fs, $list, $target) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    $1 = $fs;
    $2 = $list;
    $3 = $target;
    var $4 = $3;
    var $5 = $1;
    var $6 = $5+24;
    var $7 = IHEAP[$6];
    var $8 = $4 == $7;
    ;
    if ($8) {
      ;
      var $10 = $1;
      var $11 = $2;
      __Z16luaK_patchtohereP9FuncStatei($10, $11);
      ;
    }
    else {
      ;
      var $13 = $1;
      var $14 = $2;
      var $15 = $3;
      var $16 = $3;
      __Z12patchlistauxP9FuncStateiiii($13, $14, $15, 255, $16);
      ;
    }
    ;
    return;
  }
  __Z14luaK_patchlistP9FuncStateii.__index__ = Runtime.getFunctionIndex(__Z14luaK_patchlistP9FuncStateii, "__Z14luaK_patchlistP9FuncStateii");
  
  
  function __Z16luaK_patchtohereP9FuncStatei($fs, $list) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $fs;
    $2 = $list;
    var $3 = $1;
    var $4 = __Z13luaK_getlabelP9FuncState($3);
    var $5 = $1;
    var $6 = $1;
    var $7 = $6+32;
    var $8 = $2;
    __Z11luaK_concatP9FuncStatePii($5, $7, $8);
    ;
    return;
  }
  __Z16luaK_patchtohereP9FuncStatei.__index__ = Runtime.getFunctionIndex(__Z16luaK_patchtohereP9FuncStatei, "__Z16luaK_patchtohereP9FuncStatei");
  
  
  function __Z12patchlistauxP9FuncStateiiii($fs, $list, $vtarget, $reg, $dtarget) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $5;
    var $next;
    $1 = $fs;
    $2 = $list;
    $3 = $vtarget;
    $4 = $reg;
    $5 = $dtarget;
    ;
    $6$2: while(1) { // $6
      var $7 = $2;
      var $8 = $7 != -1;
      if (!($8)) { __label__ = 2; /* $28 */ break $6$2; }
      var $10 = $1;
      var $11 = $2;
      var $12 = __Z7getjumpP9FuncStatei($10, $11);
      $next = $12;
      var $13 = $1;
      var $14 = $2;
      var $15 = $4;
      var $16 = __Z12patchtestregP9FuncStateii($13, $14, $15);
      var $17 = $16 != 0;
      ;
      if ($17) {
        ;
        var $19 = $1;
        var $20 = $2;
        var $21 = $3;
        __Z7fixjumpP9FuncStateii($19, $20, $21);
        ;
      }
      else {
        ;
        var $23 = $1;
        var $24 = $2;
        var $25 = $5;
        __Z7fixjumpP9FuncStateii($23, $24, $25);
        ;
      }
      var $27 = $next;
      $2 = $27;
      __label__ = 0; /* $6 */ continue $6$2;
    }
    ;
    return;
  }
  __Z12patchlistauxP9FuncStateiiii.__index__ = Runtime.getFunctionIndex(__Z12patchlistauxP9FuncStateiiii, "__Z12patchlistauxP9FuncStateiiii");
  
  
  function __Z7getjumpP9FuncStatei($fs, $pc) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $offset;
    $2 = $fs;
    $3 = $pc;
    var $4 = $3;
    var $5 = $2;
    var $6 = $5;
    var $7 = IHEAP[$6];
    var $8 = $7+12;
    var $9 = IHEAP[$8];
    var $10 = $9+4*$4;
    var $11 = IHEAP[$10];
    var $12 = $11 >> 14;
    var $13 = $12 & 262143;
    var $14 = $13 - 131071;
    $offset = $14;
    var $15 = $offset;
    var $16 = $15 == -1;
    ;
    if ($16) {
      ;
      $1 = -1;
      ;
    }
    else {
      ;
      var $19 = $3;
      var $20 = $19 + 1;
      var $21 = $offset;
      var $22 = $20 + $21;
      $1 = $22;
      ;
    }
    var $24 = $1;
    ;
    return $24;
  }
  __Z7getjumpP9FuncStatei.__index__ = Runtime.getFunctionIndex(__Z7getjumpP9FuncStatei, "__Z7getjumpP9FuncStatei");
  
  
  function __Z7fixjumpP9FuncStateii($fs, $pc, $dest) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $jmp;
    var $offset;
    $1 = $fs;
    $2 = $pc;
    $3 = $dest;
    var $4 = $2;
    var $5 = $1;
    var $6 = $5;
    var $7 = IHEAP[$6];
    var $8 = $7+12;
    var $9 = IHEAP[$8];
    var $10 = $9+4*$4;
    $jmp = $10;
    var $11 = $3;
    var $12 = $2;
    var $13 = $12 + 1;
    var $14 = $11 - $13;
    $offset = $14;
    var $15 = $offset;
    var $16 = _abs($15);
    var $17 = $16 > 131071;
    ;
    if ($17) {
      ;
      var $19 = $1;
      var $20 = $19+12;
      var $21 = IHEAP[$20];
      __Z16luaX_syntaxerrorP8LexStatePKc($21, __str37);
      ;
    }
    var $23 = $jmp;
    var $24 = IHEAP[$23];
    var $25 = $24 & 16383;
    var $26 = $offset;
    var $27 = $26 + 131071;
    var $28 = $27 << 14;
    var $29 = $28 & -16384;
    var $30 = $25 | $29;
    var $31 = $jmp;
    IHEAP[$31] = $30;
    ;
    return;
  }
  __Z7fixjumpP9FuncStateii.__index__ = Runtime.getFunctionIndex(__Z7fixjumpP9FuncStateii, "__Z7fixjumpP9FuncStateii");
  
  
  function __Z15luaK_checkstackP9FuncStatei($fs, $n) {
    ;
    var __label__;
    var $1;
    var $2;
    var $newstack;
    $1 = $fs;
    $2 = $n;
    var $3 = $1;
    var $4 = $3+36;
    var $5 = IHEAP[$4];
    var $6 = $2;
    var $7 = $5 + $6;
    $newstack = $7;
    var $8 = $newstack;
    var $9 = $1;
    var $10 = $9;
    var $11 = IHEAP[$10];
    var $12 = $11+75;
    var $13 = IHEAP[$12];
    var $14 = $13;
    var $15 = $8 > $14;
    ;
    if ($15) {
      ;
      var $17 = $newstack;
      var $18 = $17 >= 250;
      ;
      if ($18) {
        ;
        var $20 = $1;
        var $21 = $20+12;
        var $22 = IHEAP[$21];
        __Z16luaX_syntaxerrorP8LexStatePKc($22, __str432);
        ;
      }
      var $24 = $newstack;
      var $25 = $24;
      var $26 = $1;
      var $27 = $26;
      var $28 = IHEAP[$27];
      var $29 = $28+75;
      IHEAP[$29] = $25;
      ;
    }
    ;
    return;
  }
  __Z15luaK_checkstackP9FuncStatei.__index__ = Runtime.getFunctionIndex(__Z15luaK_checkstackP9FuncStatei, "__Z15luaK_checkstackP9FuncStatei");
  
  
  function __Z16luaK_reserveregsP9FuncStatei($fs, $n) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $fs;
    $2 = $n;
    var $3 = $1;
    var $4 = $2;
    __Z15luaK_checkstackP9FuncStatei($3, $4);
    var $5 = $2;
    var $6 = $1;
    var $7 = $6+36;
    var $8 = IHEAP[$7];
    var $9 = $8 + $5;
    IHEAP[$7] = $9;
    ;
    return;
  }
  __Z16luaK_reserveregsP9FuncStatei.__index__ = Runtime.getFunctionIndex(__Z16luaK_reserveregsP9FuncStatei, "__Z16luaK_reserveregsP9FuncStatei");
  
  
  function __Z12luaK_stringKP9FuncStateP7TString($fs, $s) {
    var __stackBase__  = STACKTOP; STACKTOP += 12; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $o = __stackBase__;
    var $i_o;
    $1 = $fs;
    $2 = $s;
    $i_o = $o;
    var $3 = $2;
    var $4 = $3;
    var $5 = $i_o;
    var $6 = $5;
    var $7 = $6;
    var $8 = $7;
    IHEAP[$8] = $4;
    var $9 = $i_o;
    var $10 = $9+8;
    IHEAP[$10] = 4;
    var $11 = $1;
    var $12 = __Z4addkP9FuncStateP10lua_TValueS2_($11, $o, $o);
    STACKTOP = __stackBase__;
    return $12;
  }
  __Z12luaK_stringKP9FuncStateP7TString.__index__ = Runtime.getFunctionIndex(__Z12luaK_stringKP9FuncStateP7TString, "__Z12luaK_stringKP9FuncStateP7TString");
  
  
  function __Z4addkP9FuncStateP10lua_TValueS2_($fs, $k, $v) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $L;
    var $idx;
    var $f;
    var $oldsize;
    var $i_o;
    var $o2;
    var $o1;
    $2 = $fs;
    $3 = $k;
    $4 = $v;
    var $5 = $2;
    var $6 = $5+16;
    var $7 = IHEAP[$6];
    $L = $7;
    var $8 = $L;
    var $9 = $2;
    var $10 = $9+4;
    var $11 = IHEAP[$10];
    var $12 = $3;
    var $13 = __Z8luaH_setP9lua_StateP5TablePK10lua_TValue($8, $11, $12);
    $idx = $13;
    var $14 = $2;
    var $15 = $14;
    var $16 = IHEAP[$15];
    $f = $16;
    var $17 = $f;
    var $18 = $17+40;
    var $19 = IHEAP[$18];
    $oldsize = $19;
    var $20 = $idx;
    var $21 = $20+8;
    var $22 = IHEAP[$21];
    var $23 = $22 == 3;
    ;
    if ($23) {
      ;
      var $25 = $idx;
      var $26 = $25;
      var $27 = $26;
      var $28 = FHEAP[$27];
      var $29 = Math.floor($28);
      $1 = $29;
      ;
    }
    else {
      ;
      var $31 = $idx;
      $i_o = $31;
      var $32 = $2;
      var $33 = $32+40;
      var $34 = IHEAP[$33];
      var $35 = $34;
      var $36 = $i_o;
      var $37 = $36;
      var $38 = $37;
      FHEAP[$38] = $35;
      var $39 = $i_o;
      var $40 = $39+8;
      IHEAP[$40] = 3;
      var $41 = $2;
      var $42 = $41+40;
      var $43 = IHEAP[$42];
      var $44 = $43 + 1;
      var $45 = $f;
      var $46 = $45+40;
      var $47 = IHEAP[$46];
      var $48 = $44 > $47;
      ;
      if ($48) {
        ;
        var $50 = $L;
        var $51 = $f;
        var $52 = $51+8;
        var $53 = IHEAP[$52];
        var $54 = $53;
        var $55 = $f;
        var $56 = $55+40;
        var $57 = __Z13luaM_growaux_P9lua_StatePvPijiPKc($50, $54, $56, 12, 262143, __str2634);
        var $58 = $57;
        var $59 = $f;
        var $60 = $59+8;
        IHEAP[$60] = $58;
        ;
      }
      ;
      $62$8: while(1) { // $62
        var $63 = $oldsize;
        var $64 = $f;
        var $65 = $64+40;
        var $66 = IHEAP[$65];
        var $67 = $63 < $66;
        if (!($67)) { __label__ = 4; /* $76 */ break $62$8; }
        var $69 = $oldsize;
        var $70 = $69 + 1;
        $oldsize = $70;
        var $71 = $f;
        var $72 = $71+8;
        var $73 = IHEAP[$72];
        var $74 = $73+12*$69;
        var $75 = $74+8;
        IHEAP[$75] = 0;
        __label__ = 2; /* $62 */ continue $62$8;
      }
      var $77 = $4;
      $o2 = $77;
      var $78 = $2;
      var $79 = $78+40;
      var $80 = IHEAP[$79];
      var $81 = $f;
      var $82 = $81+8;
      var $83 = IHEAP[$82];
      var $84 = $83+12*$80;
      $o1 = $84;
      var $85 = $o1;
      var $86 = $85;
      var $87 = $o2;
      var $88 = $87;
      var $89 = $86;
      var $90 = $88;
      _llvm_memcpy_p0i8_p0i8_i32($89, $90, 8, 4, 0);
      var $91 = $o2;
      var $92 = $91+8;
      var $93 = IHEAP[$92];
      var $94 = $o1;
      var $95 = $94+8;
      IHEAP[$95] = $93;
      var $96 = $4;
      var $97 = $96+8;
      var $98 = IHEAP[$97];
      var $99 = $98 >= 4;
      ;
      $100$132$12: do { 
        if ($99) {
          ;
          var $101 = $4;
          var $102 = $101;
          var $103 = $102;
          var $104 = $103;
          var $105 = IHEAP[$104];
          var $106 = $105;
          var $107 = $106;
          var $108 = $107+5;
          var $109 = IHEAP[$108];
          var $110 = $109;
          var $111 = $110 & 3;
          var $112 = $111 != 0;
          if (!($112)) { __label__ = 6; /* $132 */ break $100$132$12; }
          var $114 = $f;
          var $115 = $114;
          var $116 = $115;
          var $117 = $116;
          var $118 = $117+5;
          var $119 = IHEAP[$118];
          var $120 = $119;
          var $121 = $120 & 4;
          var $122 = $121 != 0;
          if (!($122)) { __label__ = 6; /* $132 */ break $100$132$12; }
          var $124 = $L;
          var $125 = $f;
          var $126 = $125;
          var $127 = $4;
          var $128 = $127;
          var $129 = $128;
          var $130 = $129;
          var $131 = IHEAP[$130];
          __Z13luaC_barrierfP9lua_StateP8GCObjectS2_($124, $126, $131);
          ;
        }
      } while(0);
      var $133 = $2;
      var $134 = $133+40;
      var $135 = IHEAP[$134];
      var $136 = $135 + 1;
      IHEAP[$134] = $136;
      $1 = $135;
      ;
    }
    var $138 = $1;
    ;
    return $138;
  }
  __Z4addkP9FuncStateP10lua_TValueS2_.__index__ = Runtime.getFunctionIndex(__Z4addkP9FuncStateP10lua_TValueS2_, "__Z4addkP9FuncStateP10lua_TValueS2_");
  
  
  function __Z12luaK_numberKP9FuncStated($fs, $r) {
    var __stackBase__  = STACKTOP; STACKTOP += 12; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $o = __stackBase__;
    var $i_o;
    $1 = $fs;
    $2 = $r;
    $i_o = $o;
    var $3 = $2;
    var $4 = $i_o;
    var $5 = $4;
    var $6 = $5;
    FHEAP[$6] = $3;
    var $7 = $i_o;
    var $8 = $7+8;
    IHEAP[$8] = 3;
    var $9 = $1;
    var $10 = __Z4addkP9FuncStateP10lua_TValueS2_($9, $o, $o);
    STACKTOP = __stackBase__;
    return $10;
  }
  __Z12luaK_numberKP9FuncStated.__index__ = Runtime.getFunctionIndex(__Z12luaK_numberKP9FuncStated, "__Z12luaK_numberKP9FuncStated");
  
  
  function __Z15luaK_setreturnsP9FuncStateP7expdesci($fs, $e, $nresults) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    $1 = $fs;
    $2 = $e;
    $3 = $nresults;
    var $4 = $2;
    var $5 = $4;
    var $6 = IHEAP[$5];
    var $7 = $6 == 13;
    ;
    if ($7) {
      ;
      var $9 = $2;
      var $10 = $9+4;
      var $11 = $10;
      var $12 = $11;
      var $13 = IHEAP[$12];
      var $14 = $1;
      var $15 = $14;
      var $16 = IHEAP[$15];
      var $17 = $16+12;
      var $18 = IHEAP[$17];
      var $19 = $18+4*$13;
      var $20 = IHEAP[$19];
      var $21 = $20 & -8372225;
      var $22 = $3;
      var $23 = $22 + 1;
      var $24 = $23 << 14;
      var $25 = $24 & 8372224;
      var $26 = $21 | $25;
      var $27 = $2;
      var $28 = $27+4;
      var $29 = $28;
      var $30 = $29;
      var $31 = IHEAP[$30];
      var $32 = $1;
      var $33 = $32;
      var $34 = IHEAP[$33];
      var $35 = $34+12;
      var $36 = IHEAP[$35];
      var $37 = $36+4*$31;
      IHEAP[$37] = $26;
      ;
    }
    else {
      ;
      var $39 = $2;
      var $40 = $39;
      var $41 = IHEAP[$40];
      var $42 = $41 == 14;
      ;
      if ($42) {
        ;
        var $44 = $2;
        var $45 = $44+4;
        var $46 = $45;
        var $47 = $46;
        var $48 = IHEAP[$47];
        var $49 = $1;
        var $50 = $49;
        var $51 = IHEAP[$50];
        var $52 = $51+12;
        var $53 = IHEAP[$52];
        var $54 = $53+4*$48;
        var $55 = IHEAP[$54];
        var $56 = $55 & 8388607;
        var $57 = $3;
        var $58 = $57 + 1;
        var $59 = $58 << 23;
        var $60 = $59 & -8388608;
        var $61 = $56 | $60;
        var $62 = $2;
        var $63 = $62+4;
        var $64 = $63;
        var $65 = $64;
        var $66 = IHEAP[$65];
        var $67 = $1;
        var $68 = $67;
        var $69 = IHEAP[$68];
        var $70 = $69+12;
        var $71 = IHEAP[$70];
        var $72 = $71+4*$66;
        IHEAP[$72] = $61;
        var $73 = $2;
        var $74 = $73+4;
        var $75 = $74;
        var $76 = $75;
        var $77 = IHEAP[$76];
        var $78 = $1;
        var $79 = $78;
        var $80 = IHEAP[$79];
        var $81 = $80+12;
        var $82 = IHEAP[$81];
        var $83 = $82+4*$77;
        var $84 = IHEAP[$83];
        var $85 = $84 & -16321;
        var $86 = $1;
        var $87 = $86+36;
        var $88 = IHEAP[$87];
        var $89 = $88 << 6;
        var $90 = $89 & 16320;
        var $91 = $85 | $90;
        var $92 = $2;
        var $93 = $92+4;
        var $94 = $93;
        var $95 = $94;
        var $96 = IHEAP[$95];
        var $97 = $1;
        var $98 = $97;
        var $99 = IHEAP[$98];
        var $100 = $99+12;
        var $101 = IHEAP[$100];
        var $102 = $101+4*$96;
        IHEAP[$102] = $91;
        var $103 = $1;
        __Z16luaK_reserveregsP9FuncStatei($103, 1);
        ;
      }
      ;
    }
    ;
    return;
  }
  __Z15luaK_setreturnsP9FuncStateP7expdesci.__index__ = Runtime.getFunctionIndex(__Z15luaK_setreturnsP9FuncStateP7expdesci, "__Z15luaK_setreturnsP9FuncStateP7expdesci");
  
  
  function __Z14luaK_setoneretP9FuncStateP7expdesc($fs, $e) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $fs;
    $2 = $e;
    var $3 = $2;
    var $4 = $3;
    var $5 = IHEAP[$4];
    var $6 = $5 == 13;
    ;
    if ($6) {
      ;
      var $8 = $2;
      var $9 = $8;
      IHEAP[$9] = 12;
      var $10 = $2;
      var $11 = $10+4;
      var $12 = $11;
      var $13 = $12;
      var $14 = IHEAP[$13];
      var $15 = $1;
      var $16 = $15;
      var $17 = IHEAP[$16];
      var $18 = $17+12;
      var $19 = IHEAP[$18];
      var $20 = $19+4*$14;
      var $21 = IHEAP[$20];
      var $22 = $21 >> 6;
      var $23 = $22 & 255;
      var $24 = $2;
      var $25 = $24+4;
      var $26 = $25;
      var $27 = $26;
      IHEAP[$27] = $23;
      ;
    }
    else {
      ;
      var $29 = $2;
      var $30 = $29;
      var $31 = IHEAP[$30];
      var $32 = $31 == 14;
      ;
      if ($32) {
        ;
        var $34 = $2;
        var $35 = $34+4;
        var $36 = $35;
        var $37 = $36;
        var $38 = IHEAP[$37];
        var $39 = $1;
        var $40 = $39;
        var $41 = IHEAP[$40];
        var $42 = $41+12;
        var $43 = IHEAP[$42];
        var $44 = $43+4*$38;
        var $45 = IHEAP[$44];
        var $46 = $45 & 8388607;
        var $47 = $46 | 16777216;
        var $48 = $2;
        var $49 = $48+4;
        var $50 = $49;
        var $51 = $50;
        var $52 = IHEAP[$51];
        var $53 = $1;
        var $54 = $53;
        var $55 = IHEAP[$54];
        var $56 = $55+12;
        var $57 = IHEAP[$56];
        var $58 = $57+4*$52;
        IHEAP[$58] = $47;
        var $59 = $2;
        var $60 = $59;
        IHEAP[$60] = 11;
        ;
      }
      ;
    }
    ;
    return;
  }
  __Z14luaK_setoneretP9FuncStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z14luaK_setoneretP9FuncStateP7expdesc, "__Z14luaK_setoneretP9FuncStateP7expdesc");
  
  
  function __Z18luaK_dischargevarsP9FuncStateP7expdesc($fs, $e) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $fs;
    $2 = $e;
    var $3 = $2;
    var $4 = $3;
    var $5 = IHEAP[$4];
    if ($5 == 6) {
      __label__ = 1; /* $6 */ 
    }
    else if ($5 == 7) {
      __label__ = 2; /* $9 */ 
    }
    else if ($5 == 8) {
      __label__ = 3; /* $23 */ 
    }
    else if ($5 == 9) {
      __label__ = 4; /* $37 */ 
    }
    else if ($5 == 14) {
      __label__ = 5; /* $68 */ 
    }
    else if ($5 == 13) {
      __label__ = 5; /* $68 */ 
    }
    else {
    __label__ = 6; /* $71 */ 
    }
    
    if (__label__ == 6) {
      ;
    }
    else if (__label__ == 1) {
      var $7 = $2;
      var $8 = $7;
      IHEAP[$8] = 12;
      ;
    }
    else if (__label__ == 2) {
      var $10 = $1;
      var $11 = $2;
      var $12 = $11+4;
      var $13 = $12;
      var $14 = $13;
      var $15 = IHEAP[$14];
      var $16 = __Z12luaK_codeABCP9FuncState6OpCodeiii($10, 4, 0, $15, 0);
      var $17 = $2;
      var $18 = $17+4;
      var $19 = $18;
      var $20 = $19;
      IHEAP[$20] = $16;
      var $21 = $2;
      var $22 = $21;
      IHEAP[$22] = 11;
      ;
    }
    else if (__label__ == 3) {
      var $24 = $1;
      var $25 = $2;
      var $26 = $25+4;
      var $27 = $26;
      var $28 = $27;
      var $29 = IHEAP[$28];
      var $30 = __Z12luaK_codeABxP9FuncState6OpCodeij($24, 5, 0, $29);
      var $31 = $2;
      var $32 = $31+4;
      var $33 = $32;
      var $34 = $33;
      IHEAP[$34] = $30;
      var $35 = $2;
      var $36 = $35;
      IHEAP[$36] = 11;
      ;
    }
    else if (__label__ == 4) {
      var $38 = $1;
      var $39 = $2;
      var $40 = $39+4;
      var $41 = $40;
      var $42 = $41+4;
      var $43 = IHEAP[$42];
      __Z7freeregP9FuncStatei($38, $43);
      var $44 = $1;
      var $45 = $2;
      var $46 = $45+4;
      var $47 = $46;
      var $48 = $47;
      var $49 = IHEAP[$48];
      __Z7freeregP9FuncStatei($44, $49);
      var $50 = $1;
      var $51 = $2;
      var $52 = $51+4;
      var $53 = $52;
      var $54 = $53;
      var $55 = IHEAP[$54];
      var $56 = $2;
      var $57 = $56+4;
      var $58 = $57;
      var $59 = $58+4;
      var $60 = IHEAP[$59];
      var $61 = __Z12luaK_codeABCP9FuncState6OpCodeiii($50, 6, 0, $55, $60);
      var $62 = $2;
      var $63 = $62+4;
      var $64 = $63;
      var $65 = $64;
      IHEAP[$65] = $61;
      var $66 = $2;
      var $67 = $66;
      IHEAP[$67] = 11;
      ;
    }
    else if (__label__ == 5) {
      var $69 = $1;
      var $70 = $2;
      __Z14luaK_setoneretP9FuncStateP7expdesc($69, $70);
      ;
    }
    ;
    return;
  }
  __Z18luaK_dischargevarsP9FuncStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z18luaK_dischargevarsP9FuncStateP7expdesc, "__Z18luaK_dischargevarsP9FuncStateP7expdesc");
  
  
  function __Z7freeregP9FuncStatei($fs, $reg) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $fs;
    $2 = $reg;
    var $3 = $2;
    var $4 = $3 & 256;
    var $5 = $4 != 0;
    ;
    $18$6$2: do { 
      if (!$5) {
        ;
        var $7 = $2;
        var $8 = $1;
        var $9 = $8+50;
        var $10 = IHEAP[$9];
        var $11 = $10;
        var $12 = $7 >= $11;
        if (!($12)) { __label__ = 1; /* $18 */ break $18$6$2; }
        var $14 = $1;
        var $15 = $14+36;
        var $16 = IHEAP[$15];
        var $17 = $16 + -1;
        IHEAP[$15] = $17;
        ;
      }
    } while(0);
    ;
    return;
  }
  __Z7freeregP9FuncStatei.__index__ = Runtime.getFunctionIndex(__Z7freeregP9FuncStatei, "__Z7freeregP9FuncStatei");
  
  
  function __Z16luaK_exp2nextregP9FuncStateP7expdesc($fs, $e) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $fs;
    $2 = $e;
    var $3 = $1;
    var $4 = $2;
    __Z18luaK_dischargevarsP9FuncStateP7expdesc($3, $4);
    var $5 = $1;
    var $6 = $2;
    __Z7freeexpP9FuncStateP7expdesc($5, $6);
    var $7 = $1;
    __Z16luaK_reserveregsP9FuncStatei($7, 1);
    var $8 = $1;
    var $9 = $2;
    var $10 = $1;
    var $11 = $10+36;
    var $12 = IHEAP[$11];
    var $13 = $12 - 1;
    __Z7exp2regP9FuncStateP7expdesci($8, $9, $13);
    ;
    return;
  }
  __Z16luaK_exp2nextregP9FuncStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z16luaK_exp2nextregP9FuncStateP7expdesc, "__Z16luaK_exp2nextregP9FuncStateP7expdesc");
  
  
  function __Z7freeexpP9FuncStateP7expdesc($fs, $e) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $fs;
    $2 = $e;
    var $3 = $2;
    var $4 = $3;
    var $5 = IHEAP[$4];
    var $6 = $5 == 12;
    ;
    if ($6) {
      ;
      var $8 = $1;
      var $9 = $2;
      var $10 = $9+4;
      var $11 = $10;
      var $12 = $11;
      var $13 = IHEAP[$12];
      __Z7freeregP9FuncStatei($8, $13);
      ;
    }
    ;
    return;
  }
  __Z7freeexpP9FuncStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z7freeexpP9FuncStateP7expdesc, "__Z7freeexpP9FuncStateP7expdesc");
  
  
  function __Z7exp2regP9FuncStateP7expdesci($fs, $e, $reg) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $final;
    var $p_f;
    var $p_t;
    var $fj;
    $1 = $fs;
    $2 = $e;
    $3 = $reg;
    var $4 = $1;
    var $5 = $2;
    var $6 = $3;
    __Z13discharge2regP9FuncStateP7expdesci($4, $5, $6);
    var $7 = $2;
    var $8 = $7;
    var $9 = IHEAP[$8];
    var $10 = $9 == 10;
    ;
    if ($10) {
      ;
      var $12 = $1;
      var $13 = $2;
      var $14 = $13+12;
      var $15 = $2;
      var $16 = $15+4;
      var $17 = $16;
      var $18 = $17;
      var $19 = IHEAP[$18];
      __Z11luaK_concatP9FuncStatePii($12, $14, $19);
      ;
    }
    var $21 = $2;
    var $22 = $21+12;
    var $23 = IHEAP[$22];
    var $24 = $2;
    var $25 = $24+16;
    var $26 = IHEAP[$25];
    var $27 = $23 != $26;
    ;
    if ($27) {
      ;
      $p_f = -1;
      $p_t = -1;
      var $29 = $1;
      var $30 = $2;
      var $31 = $30+12;
      var $32 = IHEAP[$31];
      var $33 = __Z10need_valueP9FuncStatei($29, $32);
      var $34 = $33 != 0;
      ;
      $42$35$7: do { 
        if ($34) {
          __label__ = 1; /* $42 */ 
        }
        else {
          ;
          var $36 = $1;
          var $37 = $2;
          var $38 = $37+16;
          var $39 = IHEAP[$38];
          var $40 = __Z10need_valueP9FuncStatei($36, $39);
          var $41 = $40 != 0;
          if ($41) { __label__ = 1; /* $42 */ break $42$35$7; } else { __label__ = 2; /* $61 */ break $42$35$7; }
        }
      } while(0);
      if (__label__ == 1) {
        var $43 = $2;
        var $44 = $43;
        var $45 = IHEAP[$44];
        var $46 = $45 == 10;
        ;
        if ($46) {
          ;
          __lastLabel__ = 3; ;
        }
        else {
          ;
          var $49 = $1;
          var $50 = __Z9luaK_jumpP9FuncState($49);
          __lastLabel__ = 5; ;
        }
        var $52 = __lastLabel__ == 3 ? -1 : ($50);
        $fj = $52;
        var $53 = $1;
        var $54 = $3;
        var $55 = __Z10code_labelP9FuncStateiii($53, $54, 0, 1);
        $p_f = $55;
        var $56 = $1;
        var $57 = $3;
        var $58 = __Z10code_labelP9FuncStateiii($56, $57, 1, 0);
        $p_t = $58;
        var $59 = $1;
        var $60 = $fj;
        __Z16luaK_patchtohereP9FuncStatei($59, $60);
        ;
      }
      var $62 = $1;
      var $63 = __Z13luaK_getlabelP9FuncState($62);
      $final = $63;
      var $64 = $1;
      var $65 = $2;
      var $66 = $65+16;
      var $67 = IHEAP[$66];
      var $68 = $final;
      var $69 = $3;
      var $70 = $p_f;
      __Z12patchlistauxP9FuncStateiiii($64, $67, $68, $69, $70);
      var $71 = $1;
      var $72 = $2;
      var $73 = $72+12;
      var $74 = IHEAP[$73];
      var $75 = $final;
      var $76 = $3;
      var $77 = $p_t;
      __Z12patchlistauxP9FuncStateiiii($71, $74, $75, $76, $77);
      ;
    }
    var $79 = $2;
    var $80 = $79+12;
    IHEAP[$80] = -1;
    var $81 = $2;
    var $82 = $81+16;
    IHEAP[$82] = -1;
    var $83 = $3;
    var $84 = $2;
    var $85 = $84+4;
    var $86 = $85;
    var $87 = $86;
    IHEAP[$87] = $83;
    var $88 = $2;
    var $89 = $88;
    IHEAP[$89] = 12;
    ;
    return;
  }
  __Z7exp2regP9FuncStateP7expdesci.__index__ = Runtime.getFunctionIndex(__Z7exp2regP9FuncStateP7expdesci, "__Z7exp2regP9FuncStateP7expdesci");
  
  
  function __Z15luaK_exp2anyregP9FuncStateP7expdesc($fs, $e) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    $2 = $fs;
    $3 = $e;
    var $4 = $2;
    var $5 = $3;
    __Z18luaK_dischargevarsP9FuncStateP7expdesc($4, $5);
    var $6 = $3;
    var $7 = $6;
    var $8 = IHEAP[$7];
    var $9 = $8 == 12;
    ;
    $10$49$2: do { 
      if ($9) {
        ;
        var $11 = $3;
        var $12 = $11+12;
        var $13 = IHEAP[$12];
        var $14 = $3;
        var $15 = $14+16;
        var $16 = IHEAP[$15];
        var $17 = $13 != $16;
        ;
        if ($17) {
          ;
          var $25 = $3;
          var $26 = $25+4;
          var $27 = $26;
          var $28 = $27;
          var $29 = IHEAP[$28];
          var $30 = $2;
          var $31 = $30+50;
          var $32 = IHEAP[$31];
          var $33 = $32;
          var $34 = $29 >= $33;
          ;
          if ($34) {
            ;
            var $36 = $2;
            var $37 = $3;
            var $38 = $3;
            var $39 = $38+4;
            var $40 = $39;
            var $41 = $40;
            var $42 = IHEAP[$41];
            __Z7exp2regP9FuncStateP7expdesci($36, $37, $42);
            var $43 = $3;
            var $44 = $43+4;
            var $45 = $44;
            var $46 = $45;
            var $47 = IHEAP[$46];
            $1 = $47;
            __label__ = 0; /* $57 */ break $10$49$2;
          }
          else {
            ;
            __label__ = 1; /* $49 */ break $10$49$2;
          }
        }
        else {
          ;
          var $19 = $3;
          var $20 = $19+4;
          var $21 = $20;
          var $22 = $21;
          var $23 = IHEAP[$22];
          $1 = $23;
          __label__ = 0; /* $57 */ break $10$49$2;
        }
      }
      else {
        __label__ = 1; /* $49 */ 
      }
    } while(0);
    if (__label__ == 1) {
      var $50 = $2;
      var $51 = $3;
      __Z16luaK_exp2nextregP9FuncStateP7expdesc($50, $51);
      var $52 = $3;
      var $53 = $52+4;
      var $54 = $53;
      var $55 = $54;
      var $56 = IHEAP[$55];
      $1 = $56;
      ;
    }
    var $58 = $1;
    ;
    return $58;
  }
  __Z15luaK_exp2anyregP9FuncStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z15luaK_exp2anyregP9FuncStateP7expdesc, "__Z15luaK_exp2anyregP9FuncStateP7expdesc");
  
  
  function __Z12luaK_exp2valP9FuncStateP7expdesc($fs, $e) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $fs;
    $2 = $e;
    var $3 = $2;
    var $4 = $3+12;
    var $5 = IHEAP[$4];
    var $6 = $2;
    var $7 = $6+16;
    var $8 = IHEAP[$7];
    var $9 = $5 != $8;
    ;
    if ($9) {
      ;
      var $11 = $1;
      var $12 = $2;
      var $13 = __Z15luaK_exp2anyregP9FuncStateP7expdesc($11, $12);
      ;
    }
    else {
      ;
      var $15 = $1;
      var $16 = $2;
      __Z18luaK_dischargevarsP9FuncStateP7expdesc($15, $16);
      ;
    }
    ;
    return;
  }
  __Z12luaK_exp2valP9FuncStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z12luaK_exp2valP9FuncStateP7expdesc, "__Z12luaK_exp2valP9FuncStateP7expdesc");
  
  
  function __Z11luaK_exp2RKP9FuncStateP7expdesc($fs, $e) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    $2 = $fs;
    $3 = $e;
    var $4 = $2;
    var $5 = $3;
    __Z12luaK_exp2valP9FuncStateP7expdesc($4, $5);
    var $6 = $3;
    var $7 = $6;
    var $8 = IHEAP[$7];
    if ($8 == 5) {
      __label__ = 9; /* $9 */ 
    }
    else if ($8 == 2) {
      __label__ = 9; /* $9 */ 
    }
    else if ($8 == 3) {
      __label__ = 9; /* $9 */ 
    }
    else if ($8 == 1) {
      __label__ = 9; /* $9 */ 
    }
    else if ($8 == 4) {
      __label__ = 10; /* $60 */ 
    }
    else {
    __label__ = 11; /* $75 */ 
    }
    
    $75$9$60$2: do { 
      if (__label__ == 11) {
        __label__ = 7; /* $76 */ break $75$9$60$2;
      }
      else if (__label__ == 9) {
        var $10 = $2;
        var $11 = $10+40;
        var $12 = IHEAP[$11];
        var $13 = $12 <= 255;
        ;
        if ($13) {
          ;
          var $15 = $3;
          var $16 = $15;
          var $17 = IHEAP[$16];
          var $18 = $17 == 1;
          ;
          if ($18) {
            ;
            var $20 = $2;
            var $21 = __Z4nilKP9FuncState($20);
            __lastLabel__ = 0; ;
          }
          else {
            ;
            var $23 = $3;
            var $24 = $23;
            var $25 = IHEAP[$24];
            var $26 = $25 == 5;
            ;
            if ($26) {
              ;
              var $28 = $2;
              var $29 = $3;
              var $30 = $29+4;
              var $31 = $30;
              var $32 = $31;
              var $33 = FHEAP[$32];
              var $34 = __Z12luaK_numberKP9FuncStated($28, $33);
              __lastLabel__ = 2; ;
            }
            else {
              ;
              var $36 = $2;
              var $37 = $3;
              var $38 = $37;
              var $39 = IHEAP[$38];
              var $40 = $39 == 2;
              var $41 = $40;
              var $42 = __Z5boolKP9FuncStatei($36, $41);
              __lastLabel__ = 4; ;
            }
            var $44 = __lastLabel__ == 2 ? $34 : ($42);
            __lastLabel__ = 5; ;
          }
          var $46 = __lastLabel__ == 0 ? $21 : ($44);
          var $47 = $3;
          var $48 = $47+4;
          var $49 = $48;
          var $50 = $49;
          IHEAP[$50] = $46;
          var $51 = $3;
          var $52 = $51;
          IHEAP[$52] = 4;
          var $53 = $3;
          var $54 = $53+4;
          var $55 = $54;
          var $56 = $55;
          var $57 = IHEAP[$56];
          var $58 = $57 | 256;
          $1 = $58;
          __label__ = 6; /* $80 */ break $75$9$60$2;
        }
        else {
          ;
          __label__ = 7; /* $76 */ break $75$9$60$2;
        }
      }
      else if (__label__ == 10) {
        var $61 = $3;
        var $62 = $61+4;
        var $63 = $62;
        var $64 = $63;
        var $65 = IHEAP[$64];
        var $66 = $65 <= 255;
        ;
        if ($66) {
          ;
          var $68 = $3;
          var $69 = $68+4;
          var $70 = $69;
          var $71 = $70;
          var $72 = IHEAP[$71];
          var $73 = $72 | 256;
          $1 = $73;
          __label__ = 6; /* $80 */ break $75$9$60$2;
        }
        else {
          ;
          __label__ = 7; /* $76 */ break $75$9$60$2;
        }
      }
    } while(0);
    if (__label__ == 7) {
      var $77 = $2;
      var $78 = $3;
      var $79 = __Z15luaK_exp2anyregP9FuncStateP7expdesc($77, $78);
      $1 = $79;
      ;
    }
    var $81 = $1;
    ;
    return $81;
  }
  __Z11luaK_exp2RKP9FuncStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z11luaK_exp2RKP9FuncStateP7expdesc, "__Z11luaK_exp2RKP9FuncStateP7expdesc");
  
  
  function __Z4nilKP9FuncState($fs) {
    var __stackBase__  = STACKTOP; STACKTOP += 24; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $k = __stackBase__;
    var $v = __stackBase__+12;
    var $i_o;
    $1 = $fs;
    var $2 = $v+8;
    IHEAP[$2] = 0;
    $i_o = $k;
    var $3 = $1;
    var $4 = $3+4;
    var $5 = IHEAP[$4];
    var $6 = $5;
    var $7 = $i_o;
    var $8 = $7;
    var $9 = $8;
    var $10 = $9;
    IHEAP[$10] = $6;
    var $11 = $i_o;
    var $12 = $11+8;
    IHEAP[$12] = 5;
    var $13 = $1;
    var $14 = __Z4addkP9FuncStateP10lua_TValueS2_($13, $k, $v);
    STACKTOP = __stackBase__;
    return $14;
  }
  __Z4nilKP9FuncState.__index__ = Runtime.getFunctionIndex(__Z4nilKP9FuncState, "__Z4nilKP9FuncState");
  
  
  function __Z5boolKP9FuncStatei($fs, $b) {
    var __stackBase__  = STACKTOP; STACKTOP += 12; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $o = __stackBase__;
    var $i_o;
    $1 = $fs;
    $2 = $b;
    $i_o = $o;
    var $3 = $2;
    var $4 = $i_o;
    var $5 = $4;
    var $6 = $5;
    var $7 = $6;
    IHEAP[$7] = $3;
    var $8 = $i_o;
    var $9 = $8+8;
    IHEAP[$9] = 1;
    var $10 = $1;
    var $11 = __Z4addkP9FuncStateP10lua_TValueS2_($10, $o, $o);
    STACKTOP = __stackBase__;
    return $11;
  }
  __Z5boolKP9FuncStatei.__index__ = Runtime.getFunctionIndex(__Z5boolKP9FuncStatei, "__Z5boolKP9FuncStatei");
  
  
  function __Z13luaK_storevarP9FuncStateP7expdescS2_($fs, $var, $ex) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $e;
    var $e1;
    var $e2;
    $1 = $fs;
    $2 = $var;
    $3 = $ex;
    var $4 = $2;
    var $5 = $4;
    var $6 = IHEAP[$5];
    if ($6 == 6) {
      __label__ = 3; /* $7 */ 
    }
    else if ($6 == 7) {
      __label__ = 4; /* $17 */ 
    }
    else if ($6 == 8) {
      __label__ = 5; /* $29 */ 
    }
    else if ($6 == 9) {
      __label__ = 6; /* $41 */ 
    }
    else {
    __label__ = 7; /* $58 */ 
    }
    
    $58$7$17$29$41$2: do { 
      if (__label__ == 7) {
        __label__ = 1; /* $59 */ break $58$7$17$29$41$2;
      }
      else if (__label__ == 3) {
        var $8 = $1;
        var $9 = $3;
        __Z7freeexpP9FuncStateP7expdesc($8, $9);
        var $10 = $1;
        var $11 = $3;
        var $12 = $2;
        var $13 = $12+4;
        var $14 = $13;
        var $15 = $14;
        var $16 = IHEAP[$15];
        __Z7exp2regP9FuncStateP7expdesci($10, $11, $16);
        __label__ = 0; /* $62 */ break $58$7$17$29$41$2;
      }
      else if (__label__ == 4) {
        var $18 = $1;
        var $19 = $3;
        var $20 = __Z15luaK_exp2anyregP9FuncStateP7expdesc($18, $19);
        $e = $20;
        var $21 = $1;
        var $22 = $e;
        var $23 = $2;
        var $24 = $23+4;
        var $25 = $24;
        var $26 = $25;
        var $27 = IHEAP[$26];
        var $28 = __Z12luaK_codeABCP9FuncState6OpCodeiii($21, 8, $22, $27, 0);
        __label__ = 1; /* $59 */ break $58$7$17$29$41$2;
      }
      else if (__label__ == 5) {
        var $30 = $1;
        var $31 = $3;
        var $32 = __Z15luaK_exp2anyregP9FuncStateP7expdesc($30, $31);
        $e1 = $32;
        var $33 = $1;
        var $34 = $e1;
        var $35 = $2;
        var $36 = $35+4;
        var $37 = $36;
        var $38 = $37;
        var $39 = IHEAP[$38];
        var $40 = __Z12luaK_codeABxP9FuncState6OpCodeij($33, 7, $34, $39);
        __label__ = 1; /* $59 */ break $58$7$17$29$41$2;
      }
      else if (__label__ == 6) {
        var $42 = $1;
        var $43 = $3;
        var $44 = __Z11luaK_exp2RKP9FuncStateP7expdesc($42, $43);
        $e2 = $44;
        var $45 = $1;
        var $46 = $2;
        var $47 = $46+4;
        var $48 = $47;
        var $49 = $48;
        var $50 = IHEAP[$49];
        var $51 = $2;
        var $52 = $51+4;
        var $53 = $52;
        var $54 = $53+4;
        var $55 = IHEAP[$54];
        var $56 = $e2;
        var $57 = __Z12luaK_codeABCP9FuncState6OpCodeiii($45, 9, $50, $55, $56);
        __label__ = 1; /* $59 */ break $58$7$17$29$41$2;
      }
    } while(0);
    if (__label__ == 1) {
      var $60 = $1;
      var $61 = $3;
      __Z7freeexpP9FuncStateP7expdesc($60, $61);
      ;
    }
    ;
    return;
  }
  __Z13luaK_storevarP9FuncStateP7expdescS2_.__index__ = Runtime.getFunctionIndex(__Z13luaK_storevarP9FuncStateP7expdescS2_, "__Z13luaK_storevarP9FuncStateP7expdescS2_");
  
  
  function __Z9luaK_selfP9FuncStateP7expdescS2_($fs, $e, $key) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $func;
    $1 = $fs;
    $2 = $e;
    $3 = $key;
    var $4 = $1;
    var $5 = $2;
    var $6 = __Z15luaK_exp2anyregP9FuncStateP7expdesc($4, $5);
    var $7 = $1;
    var $8 = $2;
    __Z7freeexpP9FuncStateP7expdesc($7, $8);
    var $9 = $1;
    var $10 = $9+36;
    var $11 = IHEAP[$10];
    $func = $11;
    var $12 = $1;
    __Z16luaK_reserveregsP9FuncStatei($12, 2);
    var $13 = $1;
    var $14 = $func;
    var $15 = $2;
    var $16 = $15+4;
    var $17 = $16;
    var $18 = $17;
    var $19 = IHEAP[$18];
    var $20 = $1;
    var $21 = $3;
    var $22 = __Z11luaK_exp2RKP9FuncStateP7expdesc($20, $21);
    var $23 = __Z12luaK_codeABCP9FuncState6OpCodeiii($13, 11, $14, $19, $22);
    var $24 = $1;
    var $25 = $3;
    __Z7freeexpP9FuncStateP7expdesc($24, $25);
    var $26 = $func;
    var $27 = $2;
    var $28 = $27+4;
    var $29 = $28;
    var $30 = $29;
    IHEAP[$30] = $26;
    var $31 = $2;
    var $32 = $31;
    IHEAP[$32] = 12;
    ;
    return;
  }
  __Z9luaK_selfP9FuncStateP7expdescS2_.__index__ = Runtime.getFunctionIndex(__Z9luaK_selfP9FuncStateP7expdescS2_, "__Z9luaK_selfP9FuncStateP7expdescS2_");
  
  
  function __Z13luaK_goiftrueP9FuncStateP7expdesc($fs, $e) {
    ;
    var __label__;
    var $1;
    var $2;
    var $pc;
    $1 = $fs;
    $2 = $e;
    var $3 = $1;
    var $4 = $2;
    __Z18luaK_dischargevarsP9FuncStateP7expdesc($3, $4);
    var $5 = $2;
    var $6 = $5;
    var $7 = IHEAP[$6];
    if ($7 == 4) {
      __label__ = 1; /* $8 */ 
    }
    else if ($7 == 5) {
      __label__ = 1; /* $8 */ 
    }
    else if ($7 == 2) {
      __label__ = 1; /* $8 */ 
    }
    else if ($7 == 3) {
      __label__ = 2; /* $9 */ 
    }
    else if ($7 == 10) {
      __label__ = 3; /* $12 */ 
    }
    else {
    __label__ = 4; /* $20 */ 
    }
    
    if (__label__ == 4) {
      var $21 = $1;
      var $22 = $2;
      var $23 = __Z10jumponcondP9FuncStateP7expdesci($21, $22, 0);
      $pc = $23;
      ;
    }
    else if (__label__ == 1) {
      $pc = -1;
      ;
    }
    else if (__label__ == 2) {
      var $10 = $1;
      var $11 = __Z9luaK_jumpP9FuncState($10);
      $pc = $11;
      ;
    }
    else if (__label__ == 3) {
      var $13 = $1;
      var $14 = $2;
      __Z10invertjumpP9FuncStateP7expdesc($13, $14);
      var $15 = $2;
      var $16 = $15+4;
      var $17 = $16;
      var $18 = $17;
      var $19 = IHEAP[$18];
      $pc = $19;
      ;
    }
    var $25 = $1;
    var $26 = $2;
    var $27 = $26+16;
    var $28 = $pc;
    __Z11luaK_concatP9FuncStatePii($25, $27, $28);
    var $29 = $1;
    var $30 = $2;
    var $31 = $30+12;
    var $32 = IHEAP[$31];
    __Z16luaK_patchtohereP9FuncStatei($29, $32);
    var $33 = $2;
    var $34 = $33+12;
    IHEAP[$34] = -1;
    ;
    return;
  }
  __Z13luaK_goiftrueP9FuncStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z13luaK_goiftrueP9FuncStateP7expdesc, "__Z13luaK_goiftrueP9FuncStateP7expdesc");
  
  
  function __Z10invertjumpP9FuncStateP7expdesc($fs, $e) {
    ;
    var __label__;
    var $1;
    var $2;
    var $pc;
    $1 = $fs;
    $2 = $e;
    var $3 = $1;
    var $4 = $2;
    var $5 = $4+4;
    var $6 = $5;
    var $7 = $6;
    var $8 = IHEAP[$7];
    var $9 = __Z14getjumpcontrolP9FuncStatei($3, $8);
    $pc = $9;
    var $10 = $pc;
    var $11 = IHEAP[$10];
    var $12 = $11 & -16321;
    var $13 = $pc;
    var $14 = IHEAP[$13];
    var $15 = $14 >> 6;
    var $16 = $15 & 255;
    var $17 = $16 != 0;
    var $18 = $17 ^ 1;
    var $19 = $18;
    var $20 = $19 << 6;
    var $21 = $20 & 16320;
    var $22 = $12 | $21;
    var $23 = $pc;
    IHEAP[$23] = $22;
    ;
    return;
  }
  __Z10invertjumpP9FuncStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z10invertjumpP9FuncStateP7expdesc, "__Z10invertjumpP9FuncStateP7expdesc");
  
  
  function __Z10jumponcondP9FuncStateP7expdesci($fs, $e, $cond) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $ie;
    $2 = $fs;
    $3 = $e;
    $4 = $cond;
    var $5 = $3;
    var $6 = $5;
    var $7 = IHEAP[$6];
    var $8 = $7 == 11;
    ;
    $9$41$2: do { 
      if ($8) {
        ;
        var $10 = $3;
        var $11 = $10+4;
        var $12 = $11;
        var $13 = $12;
        var $14 = IHEAP[$13];
        var $15 = $2;
        var $16 = $15;
        var $17 = IHEAP[$16];
        var $18 = $17+12;
        var $19 = IHEAP[$18];
        var $20 = $19+4*$14;
        var $21 = IHEAP[$20];
        $ie = $21;
        var $22 = $ie;
        var $23 = $22 >> 0;
        var $24 = $23 & 63;
        var $25 = $24 == 19;
        ;
        if ($25) {
          ;
          var $27 = $2;
          var $28 = $27+24;
          var $29 = IHEAP[$28];
          var $30 = $29 + -1;
          IHEAP[$28] = $30;
          var $31 = $2;
          var $32 = $ie;
          var $33 = $32 >> 23;
          var $34 = $33 & 511;
          var $35 = $4;
          var $36 = $35 != 0;
          var $37 = $36 ^ 1;
          var $38 = $37;
          var $39 = __Z8condjumpP9FuncState6OpCodeiii($31, 26, $34, 0, $38);
          $1 = $39;
          __label__ = 0; /* $54 */ break $9$41$2;
        }
        else {
          ;
          __label__ = 1; /* $41 */ break $9$41$2;
        }
      }
      else {
        __label__ = 1; /* $41 */ 
      }
    } while(0);
    if (__label__ == 1) {
      var $42 = $2;
      var $43 = $3;
      __Z16discharge2anyregP9FuncStateP7expdesc($42, $43);
      var $44 = $2;
      var $45 = $3;
      __Z7freeexpP9FuncStateP7expdesc($44, $45);
      var $46 = $2;
      var $47 = $3;
      var $48 = $47+4;
      var $49 = $48;
      var $50 = $49;
      var $51 = IHEAP[$50];
      var $52 = $4;
      var $53 = __Z8condjumpP9FuncState6OpCodeiii($46, 27, 255, $51, $52);
      $1 = $53;
      ;
    }
    var $55 = $1;
    ;
    return $55;
  }
  __Z10jumponcondP9FuncStateP7expdesci.__index__ = Runtime.getFunctionIndex(__Z10jumponcondP9FuncStateP7expdesci, "__Z10jumponcondP9FuncStateP7expdesci");
  
  
  function __Z12luaK_indexedP9FuncStateP7expdescS2_($fs, $t, $k) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    $1 = $fs;
    $2 = $t;
    $3 = $k;
    var $4 = $1;
    var $5 = $3;
    var $6 = __Z11luaK_exp2RKP9FuncStateP7expdesc($4, $5);
    var $7 = $2;
    var $8 = $7+4;
    var $9 = $8;
    var $10 = $9+4;
    IHEAP[$10] = $6;
    var $11 = $2;
    var $12 = $11;
    IHEAP[$12] = 9;
    ;
    return;
  }
  __Z12luaK_indexedP9FuncStateP7expdescS2_.__index__ = Runtime.getFunctionIndex(__Z12luaK_indexedP9FuncStateP7expdescS2_, "__Z12luaK_indexedP9FuncStateP7expdescS2_");
  
  
  function __Z11luaK_prefixP9FuncState5UnOprP7expdesc($fs, $op, $e) {
    var __stackBase__  = STACKTOP; STACKTOP += 20; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $e2 = __stackBase__;
    $1 = $fs;
    $2 = $op;
    $3 = $e;
    var $4 = $e2+16;
    IHEAP[$4] = -1;
    var $5 = $e2+12;
    IHEAP[$5] = -1;
    var $6 = $e2;
    IHEAP[$6] = 5;
    var $7 = $e2+4;
    var $8 = $7;
    var $9 = $8;
    FHEAP[$9] = 0;
    var $10 = $2;
    if ($10 == 0) {
      __label__ = 2; /* $11 */ 
    }
    else if ($10 == 1) {
      __label__ = 3; /* $22 */ 
    }
    else if ($10 == 2) {
      __label__ = 4; /* $25 */ 
    }
    else {
    __label__ = 5; /* $31 */ 
    }
    
    if (__label__ == 5) {
      ;
    }
    else if (__label__ == 2) {
      var $12 = $3;
      var $13 = __Z9isnumeralP7expdesc($12);
      var $14 = $13 != 0;
      ;
      if (!$14) {
        ;
        var $16 = $1;
        var $17 = $3;
        var $18 = __Z15luaK_exp2anyregP9FuncStateP7expdesc($16, $17);
        ;
      }
      var $20 = $1;
      var $21 = $3;
      __Z9codearithP9FuncState6OpCodeP7expdescS3_($20, 18, $21, $e2);
      ;
    }
    else if (__label__ == 3) {
      var $23 = $1;
      var $24 = $3;
      __Z7codenotP9FuncStateP7expdesc($23, $24);
      ;
    }
    else if (__label__ == 4) {
      var $26 = $1;
      var $27 = $3;
      var $28 = __Z15luaK_exp2anyregP9FuncStateP7expdesc($26, $27);
      var $29 = $1;
      var $30 = $3;
      __Z9codearithP9FuncState6OpCodeP7expdescS3_($29, 20, $30, $e2);
      ;
    }
    STACKTOP = __stackBase__;
    return;
  }
  __Z11luaK_prefixP9FuncState5UnOprP7expdesc.__index__ = Runtime.getFunctionIndex(__Z11luaK_prefixP9FuncState5UnOprP7expdesc, "__Z11luaK_prefixP9FuncState5UnOprP7expdesc");
  
  
  function __Z9isnumeralP7expdesc($e) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    $1 = $e;
    var $2 = $1;
    var $3 = $2;
    var $4 = IHEAP[$3];
    var $5 = $4 == 5;
    ;
    $6$16$2: do { 
      if ($5) {
        __lastLabel__ = 4; ;
        var $7 = $1;
        var $8 = $7+12;
        var $9 = IHEAP[$8];
        var $10 = $9 == -1;
        if ($10) { __lastLabel__ = 0; ; } else { __lastLabel__ = 0; __label__ = 2; /* $16 */ break $6$16$2; }
        var $12 = $1;
        var $13 = $12+16;
        var $14 = IHEAP[$13];
        var $15 = $14 == -1;
        __lastLabel__ = 1; ;
      }
      else {
        __lastLabel__ = 4; ;
      }
    } while(0);
    var $17 = __lastLabel__ == 0 ? 0 : (__lastLabel__ == 4 ? 0 : ($15));
    var $18 = $17;
    ;
    return $18;
  }
  __Z9isnumeralP7expdesc.__index__ = Runtime.getFunctionIndex(__Z9isnumeralP7expdesc, "__Z9isnumeralP7expdesc");
  
  
  function __Z9codearithP9FuncState6OpCodeP7expdescS3_($fs, $op, $e1, $e2) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $4;
    var $o2;
    var $o1;
    $1 = $fs;
    $2 = $op;
    $3 = $e1;
    $4 = $e2;
    var $5 = $2;
    var $6 = $3;
    var $7 = $4;
    var $8 = __Z12constfolding6OpCodeP7expdescS1_($5, $6, $7);
    var $9 = $8 != 0;
    ;
    if ($9) {
      ;
      ;
    }
    else {
      ;
      var $12 = $2;
      var $13 = $12 != 18;
      ;
      $14$21$5: do { 
        if ($13) {
          ;
          var $15 = $2;
          var $16 = $15 != 20;
          if (!($16)) { __label__ = 2; /* $21 */ break $14$21$5; }
          var $18 = $1;
          var $19 = $4;
          var $20 = __Z11luaK_exp2RKP9FuncStateP7expdesc($18, $19);
          __lastLabel__ = 1; __label__ = 3; /* $22 */ break $14$21$5;
        }
        else {
          __label__ = 2; /* $21 */ 
        }
      } while(0);
      if (__label__ == 2) {
        __lastLabel__ = 2; ;
      }
      var $23 = __lastLabel__ == 1 ? $20 : (0);
      $o2 = $23;
      var $24 = $1;
      var $25 = $3;
      var $26 = __Z11luaK_exp2RKP9FuncStateP7expdesc($24, $25);
      $o1 = $26;
      var $27 = $o1;
      var $28 = $o2;
      var $29 = $27 > $28;
      ;
      if ($29) {
        ;
        var $31 = $1;
        var $32 = $3;
        __Z7freeexpP9FuncStateP7expdesc($31, $32);
        var $33 = $1;
        var $34 = $4;
        __Z7freeexpP9FuncStateP7expdesc($33, $34);
        ;
      }
      else {
        ;
        var $36 = $1;
        var $37 = $4;
        __Z7freeexpP9FuncStateP7expdesc($36, $37);
        var $38 = $1;
        var $39 = $3;
        __Z7freeexpP9FuncStateP7expdesc($38, $39);
        ;
      }
      var $41 = $1;
      var $42 = $2;
      var $43 = $o1;
      var $44 = $o2;
      var $45 = __Z12luaK_codeABCP9FuncState6OpCodeiii($41, $42, 0, $43, $44);
      var $46 = $3;
      var $47 = $46+4;
      var $48 = $47;
      var $49 = $48;
      IHEAP[$49] = $45;
      var $50 = $3;
      var $51 = $50;
      IHEAP[$51] = 11;
      ;
    }
    ;
    return;
  }
  __Z9codearithP9FuncState6OpCodeP7expdescS3_.__index__ = Runtime.getFunctionIndex(__Z9codearithP9FuncState6OpCodeP7expdescS3_, "__Z9codearithP9FuncState6OpCodeP7expdescS3_");
  
  
  function __Z7codenotP9FuncStateP7expdesc($fs, $e) {
    ;
    var __label__;
    var $1;
    var $2;
    var $temp;
    $1 = $fs;
    $2 = $e;
    var $3 = $1;
    var $4 = $2;
    __Z18luaK_dischargevarsP9FuncStateP7expdesc($3, $4);
    var $5 = $2;
    var $6 = $5;
    var $7 = IHEAP[$6];
    if ($7 == 1) {
      __label__ = 1; /* $8 */ 
    }
    else if ($7 == 3) {
      __label__ = 1; /* $8 */ 
    }
    else if ($7 == 4) {
      __label__ = 2; /* $11 */ 
    }
    else if ($7 == 5) {
      __label__ = 2; /* $11 */ 
    }
    else if ($7 == 2) {
      __label__ = 2; /* $11 */ 
    }
    else if ($7 == 10) {
      __label__ = 3; /* $14 */ 
    }
    else if ($7 == 11) {
      __label__ = 4; /* $17 */ 
    }
    else if ($7 == 12) {
      __label__ = 4; /* $17 */ 
    }
    else {
    __label__ = 5; /* $35 */ 
    }
    
    if (__label__ == 5) {
      ;
    }
    else if (__label__ == 1) {
      var $9 = $2;
      var $10 = $9;
      IHEAP[$10] = 2;
      ;
    }
    else if (__label__ == 2) {
      var $12 = $2;
      var $13 = $12;
      IHEAP[$13] = 3;
      ;
    }
    else if (__label__ == 3) {
      var $15 = $1;
      var $16 = $2;
      __Z10invertjumpP9FuncStateP7expdesc($15, $16);
      ;
    }
    else if (__label__ == 4) {
      var $18 = $1;
      var $19 = $2;
      __Z16discharge2anyregP9FuncStateP7expdesc($18, $19);
      var $20 = $1;
      var $21 = $2;
      __Z7freeexpP9FuncStateP7expdesc($20, $21);
      var $22 = $1;
      var $23 = $2;
      var $24 = $23+4;
      var $25 = $24;
      var $26 = $25;
      var $27 = IHEAP[$26];
      var $28 = __Z12luaK_codeABCP9FuncState6OpCodeiii($22, 19, 0, $27, 0);
      var $29 = $2;
      var $30 = $29+4;
      var $31 = $30;
      var $32 = $31;
      IHEAP[$32] = $28;
      var $33 = $2;
      var $34 = $33;
      IHEAP[$34] = 11;
      ;
    }
    var $37 = $2;
    var $38 = $37+16;
    var $39 = IHEAP[$38];
    $temp = $39;
    var $40 = $2;
    var $41 = $40+12;
    var $42 = IHEAP[$41];
    var $43 = $2;
    var $44 = $43+16;
    IHEAP[$44] = $42;
    var $45 = $temp;
    var $46 = $2;
    var $47 = $46+12;
    IHEAP[$47] = $45;
    var $48 = $1;
    var $49 = $2;
    var $50 = $49+16;
    var $51 = IHEAP[$50];
    __Z12removevaluesP9FuncStatei($48, $51);
    var $52 = $1;
    var $53 = $2;
    var $54 = $53+12;
    var $55 = IHEAP[$54];
    __Z12removevaluesP9FuncStatei($52, $55);
    ;
    return;
  }
  __Z7codenotP9FuncStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z7codenotP9FuncStateP7expdesc, "__Z7codenotP9FuncStateP7expdesc");
  
  
  function __Z10luaK_infixP9FuncState6BinOprP7expdesc($fs, $op, $v) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    $1 = $fs;
    $2 = $op;
    $3 = $v;
    var $4 = $2;
    if ($4 == 13) {
      __label__ = 2; /* $5 */ 
    }
    else if ($4 == 14) {
      __label__ = 3; /* $8 */ 
    }
    else if ($4 == 6) {
      __label__ = 4; /* $11 */ 
    }
    else if ($4 == 0) {
      __label__ = 5; /* $14 */ 
    }
    else if ($4 == 1) {
      __label__ = 5; /* $14 */ 
    }
    else if ($4 == 2) {
      __label__ = 5; /* $14 */ 
    }
    else if ($4 == 3) {
      __label__ = 5; /* $14 */ 
    }
    else if ($4 == 4) {
      __label__ = 5; /* $14 */ 
    }
    else if ($4 == 5) {
      __label__ = 5; /* $14 */ 
    }
    else {
    __label__ = 6; /* $23 */ 
    }
    
    if (__label__ == 6) {
      var $24 = $1;
      var $25 = $3;
      var $26 = __Z11luaK_exp2RKP9FuncStateP7expdesc($24, $25);
      ;
    }
    else if (__label__ == 2) {
      var $6 = $1;
      var $7 = $3;
      __Z13luaK_goiftrueP9FuncStateP7expdesc($6, $7);
      ;
    }
    else if (__label__ == 3) {
      var $9 = $1;
      var $10 = $3;
      __Z14luaK_goiffalseP9FuncStateP7expdesc($9, $10);
      ;
    }
    else if (__label__ == 4) {
      var $12 = $1;
      var $13 = $3;
      __Z16luaK_exp2nextregP9FuncStateP7expdesc($12, $13);
      ;
    }
    else if (__label__ == 5) {
      var $15 = $3;
      var $16 = __Z9isnumeralP7expdesc($15);
      var $17 = $16 != 0;
      ;
      if (!$17) {
        ;
        var $19 = $1;
        var $20 = $3;
        var $21 = __Z11luaK_exp2RKP9FuncStateP7expdesc($19, $20);
        ;
      }
      ;
    }
    ;
    return;
  }
  __Z10luaK_infixP9FuncState6BinOprP7expdesc.__index__ = Runtime.getFunctionIndex(__Z10luaK_infixP9FuncState6BinOprP7expdesc, "__Z10luaK_infixP9FuncState6BinOprP7expdesc");
  
  
  function __Z14luaK_goiffalseP9FuncStateP7expdesc($fs, $e) {
    ;
    var __label__;
    var $1;
    var $2;
    var $pc;
    $1 = $fs;
    $2 = $e;
    var $3 = $1;
    var $4 = $2;
    __Z18luaK_dischargevarsP9FuncStateP7expdesc($3, $4);
    var $5 = $2;
    var $6 = $5;
    var $7 = IHEAP[$6];
    if ($7 == 1) {
      __label__ = 1; /* $8 */ 
    }
    else if ($7 == 3) {
      __label__ = 1; /* $8 */ 
    }
    else if ($7 == 2) {
      __label__ = 2; /* $9 */ 
    }
    else if ($7 == 10) {
      __label__ = 3; /* $12 */ 
    }
    else {
    __label__ = 4; /* $18 */ 
    }
    
    if (__label__ == 4) {
      var $19 = $1;
      var $20 = $2;
      var $21 = __Z10jumponcondP9FuncStateP7expdesci($19, $20, 1);
      $pc = $21;
      ;
    }
    else if (__label__ == 1) {
      $pc = -1;
      ;
    }
    else if (__label__ == 2) {
      var $10 = $1;
      var $11 = __Z9luaK_jumpP9FuncState($10);
      $pc = $11;
      ;
    }
    else if (__label__ == 3) {
      var $13 = $2;
      var $14 = $13+4;
      var $15 = $14;
      var $16 = $15;
      var $17 = IHEAP[$16];
      $pc = $17;
      ;
    }
    var $23 = $1;
    var $24 = $2;
    var $25 = $24+12;
    var $26 = $pc;
    __Z11luaK_concatP9FuncStatePii($23, $25, $26);
    var $27 = $1;
    var $28 = $2;
    var $29 = $28+16;
    var $30 = IHEAP[$29];
    __Z16luaK_patchtohereP9FuncStatei($27, $30);
    var $31 = $2;
    var $32 = $31+16;
    IHEAP[$32] = -1;
    ;
    return;
  }
  __Z14luaK_goiffalseP9FuncStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z14luaK_goiffalseP9FuncStateP7expdesc, "__Z14luaK_goiffalseP9FuncStateP7expdesc");
  
  
  function __Z11luaK_posfixP9FuncState6BinOprP7expdescS3_($fs, $op, $e1, $e2) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    $1 = $fs;
    $2 = $op;
    $3 = $e1;
    $4 = $e2;
    var $5 = $2;
    if ($5 == 13) {
      __label__ = 5; /* $6 */ 
    }
    else if ($5 == 14) {
      __label__ = 6; /* $19 */ 
    }
    else if ($5 == 6) {
      __label__ = 7; /* $32 */ 
    }
    else if ($5 == 0) {
      __label__ = 8; /* $108 */ 
    }
    else if ($5 == 1) {
      __label__ = 9; /* $112 */ 
    }
    else if ($5 == 2) {
      __label__ = 10; /* $116 */ 
    }
    else if ($5 == 3) {
      __label__ = 11; /* $120 */ 
    }
    else if ($5 == 4) {
      __label__ = 12; /* $124 */ 
    }
    else if ($5 == 5) {
      __label__ = 13; /* $128 */ 
    }
    else if ($5 == 8) {
      __label__ = 14; /* $132 */ 
    }
    else if ($5 == 7) {
      __label__ = 15; /* $136 */ 
    }
    else if ($5 == 9) {
      __label__ = 16; /* $140 */ 
    }
    else if ($5 == 10) {
      __label__ = 17; /* $144 */ 
    }
    else if ($5 == 11) {
      __label__ = 18; /* $148 */ 
    }
    else if ($5 == 12) {
      __label__ = 19; /* $152 */ 
    }
    else {
    __label__ = 20; /* $156 */ 
    }
    
    if (__label__ == 20) {
      ;
    }
    else if (__label__ == 5) {
      var $7 = $1;
      var $8 = $4;
      __Z18luaK_dischargevarsP9FuncStateP7expdesc($7, $8);
      var $9 = $1;
      var $10 = $4;
      var $11 = $10+16;
      var $12 = $3;
      var $13 = $12+16;
      var $14 = IHEAP[$13];
      __Z11luaK_concatP9FuncStatePii($9, $11, $14);
      var $15 = $3;
      var $16 = $4;
      var $17 = $15;
      var $18 = $16;
      _llvm_memcpy_p0i8_p0i8_i32($17, $18, 20, 4, 0);
      ;
    }
    else if (__label__ == 6) {
      var $20 = $1;
      var $21 = $4;
      __Z18luaK_dischargevarsP9FuncStateP7expdesc($20, $21);
      var $22 = $1;
      var $23 = $4;
      var $24 = $23+12;
      var $25 = $3;
      var $26 = $25+12;
      var $27 = IHEAP[$26];
      __Z11luaK_concatP9FuncStatePii($22, $24, $27);
      var $28 = $3;
      var $29 = $4;
      var $30 = $28;
      var $31 = $29;
      _llvm_memcpy_p0i8_p0i8_i32($30, $31, 20, 4, 0);
      ;
    }
    else if (__label__ == 7) {
      var $33 = $1;
      var $34 = $4;
      __Z12luaK_exp2valP9FuncStateP7expdesc($33, $34);
      var $35 = $4;
      var $36 = $35;
      var $37 = IHEAP[$36];
      var $38 = $37 == 11;
      ;
      $39$101$7: do { 
        if ($38) {
          ;
          var $40 = $4;
          var $41 = $40+4;
          var $42 = $41;
          var $43 = $42;
          var $44 = IHEAP[$43];
          var $45 = $1;
          var $46 = $45;
          var $47 = IHEAP[$46];
          var $48 = $47+12;
          var $49 = IHEAP[$48];
          var $50 = $49+4*$44;
          var $51 = IHEAP[$50];
          var $52 = $51 >> 0;
          var $53 = $52 & 63;
          var $54 = $53 == 21;
          if (!($54)) { __label__ = 2; /* $101 */ break $39$101$7; }
          var $56 = $1;
          var $57 = $3;
          __Z7freeexpP9FuncStateP7expdesc($56, $57);
          var $58 = $4;
          var $59 = $58+4;
          var $60 = $59;
          var $61 = $60;
          var $62 = IHEAP[$61];
          var $63 = $1;
          var $64 = $63;
          var $65 = IHEAP[$64];
          var $66 = $65+12;
          var $67 = IHEAP[$66];
          var $68 = $67+4*$62;
          var $69 = IHEAP[$68];
          var $70 = $69 & 8388607;
          var $71 = $3;
          var $72 = $71+4;
          var $73 = $72;
          var $74 = $73;
          var $75 = IHEAP[$74];
          var $76 = $75 << 23;
          var $77 = $76 & -8388608;
          var $78 = $70 | $77;
          var $79 = $4;
          var $80 = $79+4;
          var $81 = $80;
          var $82 = $81;
          var $83 = IHEAP[$82];
          var $84 = $1;
          var $85 = $84;
          var $86 = IHEAP[$85];
          var $87 = $86+12;
          var $88 = IHEAP[$87];
          var $89 = $88+4*$83;
          IHEAP[$89] = $78;
          var $90 = $3;
          var $91 = $90;
          IHEAP[$91] = 11;
          var $92 = $4;
          var $93 = $92+4;
          var $94 = $93;
          var $95 = $94;
          var $96 = IHEAP[$95];
          var $97 = $3;
          var $98 = $97+4;
          var $99 = $98;
          var $100 = $99;
          IHEAP[$100] = $96;
          __label__ = 3; /* $107 */ break $39$101$7;
        }
        else {
          __label__ = 2; /* $101 */ 
        }
      } while(0);
      if (__label__ == 2) {
        var $102 = $1;
        var $103 = $4;
        __Z16luaK_exp2nextregP9FuncStateP7expdesc($102, $103);
        var $104 = $1;
        var $105 = $3;
        var $106 = $4;
        __Z9codearithP9FuncState6OpCodeP7expdescS3_($104, 21, $105, $106);
        ;
      }
      ;
    }
    else if (__label__ == 8) {
      var $109 = $1;
      var $110 = $3;
      var $111 = $4;
      __Z9codearithP9FuncState6OpCodeP7expdescS3_($109, 12, $110, $111);
      ;
    }
    else if (__label__ == 9) {
      var $113 = $1;
      var $114 = $3;
      var $115 = $4;
      __Z9codearithP9FuncState6OpCodeP7expdescS3_($113, 13, $114, $115);
      ;
    }
    else if (__label__ == 10) {
      var $117 = $1;
      var $118 = $3;
      var $119 = $4;
      __Z9codearithP9FuncState6OpCodeP7expdescS3_($117, 14, $118, $119);
      ;
    }
    else if (__label__ == 11) {
      var $121 = $1;
      var $122 = $3;
      var $123 = $4;
      __Z9codearithP9FuncState6OpCodeP7expdescS3_($121, 15, $122, $123);
      ;
    }
    else if (__label__ == 12) {
      var $125 = $1;
      var $126 = $3;
      var $127 = $4;
      __Z9codearithP9FuncState6OpCodeP7expdescS3_($125, 16, $126, $127);
      ;
    }
    else if (__label__ == 13) {
      var $129 = $1;
      var $130 = $3;
      var $131 = $4;
      __Z9codearithP9FuncState6OpCodeP7expdescS3_($129, 17, $130, $131);
      ;
    }
    else if (__label__ == 14) {
      var $133 = $1;
      var $134 = $3;
      var $135 = $4;
      __Z8codecompP9FuncState6OpCodeiP7expdescS3_($133, 23, 1, $134, $135);
      ;
    }
    else if (__label__ == 15) {
      var $137 = $1;
      var $138 = $3;
      var $139 = $4;
      __Z8codecompP9FuncState6OpCodeiP7expdescS3_($137, 23, 0, $138, $139);
      ;
    }
    else if (__label__ == 16) {
      var $141 = $1;
      var $142 = $3;
      var $143 = $4;
      __Z8codecompP9FuncState6OpCodeiP7expdescS3_($141, 24, 1, $142, $143);
      ;
    }
    else if (__label__ == 17) {
      var $145 = $1;
      var $146 = $3;
      var $147 = $4;
      __Z8codecompP9FuncState6OpCodeiP7expdescS3_($145, 25, 1, $146, $147);
      ;
    }
    else if (__label__ == 18) {
      var $149 = $1;
      var $150 = $3;
      var $151 = $4;
      __Z8codecompP9FuncState6OpCodeiP7expdescS3_($149, 24, 0, $150, $151);
      ;
    }
    else if (__label__ == 19) {
      var $153 = $1;
      var $154 = $3;
      var $155 = $4;
      __Z8codecompP9FuncState6OpCodeiP7expdescS3_($153, 25, 0, $154, $155);
      ;
    }
    ;
    return;
  }
  __Z11luaK_posfixP9FuncState6BinOprP7expdescS3_.__index__ = Runtime.getFunctionIndex(__Z11luaK_posfixP9FuncState6BinOprP7expdescS3_, "__Z11luaK_posfixP9FuncState6BinOprP7expdescS3_");
  
  
  function __Z8codecompP9FuncState6OpCodeiP7expdescS3_($fs, $op, $cond, $e1, $e2) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $5;
    var $o1;
    var $o2;
    var $temp;
    $1 = $fs;
    $2 = $op;
    $3 = $cond;
    $4 = $e1;
    $5 = $e2;
    var $6 = $1;
    var $7 = $4;
    var $8 = __Z11luaK_exp2RKP9FuncStateP7expdesc($6, $7);
    $o1 = $8;
    var $9 = $1;
    var $10 = $5;
    var $11 = __Z11luaK_exp2RKP9FuncStateP7expdesc($9, $10);
    $o2 = $11;
    var $12 = $1;
    var $13 = $5;
    __Z7freeexpP9FuncStateP7expdesc($12, $13);
    var $14 = $1;
    var $15 = $4;
    __Z7freeexpP9FuncStateP7expdesc($14, $15);
    var $16 = $3;
    var $17 = $16 == 0;
    ;
    $18$25$2: do { 
      if ($17) {
        ;
        var $19 = $2;
        var $20 = $19 != 23;
        if (!($20)) { __label__ = 1; /* $25 */ break $18$25$2; }
        var $22 = $o1;
        $temp = $22;
        var $23 = $o2;
        $o1 = $23;
        var $24 = $temp;
        $o2 = $24;
        $3 = 1;
        ;
      }
    } while(0);
    var $26 = $1;
    var $27 = $2;
    var $28 = $3;
    var $29 = $o1;
    var $30 = $o2;
    var $31 = __Z8condjumpP9FuncState6OpCodeiii($26, $27, $28, $29, $30);
    var $32 = $4;
    var $33 = $32+4;
    var $34 = $33;
    var $35 = $34;
    IHEAP[$35] = $31;
    var $36 = $4;
    var $37 = $36;
    IHEAP[$37] = 10;
    ;
    return;
  }
  __Z8codecompP9FuncState6OpCodeiP7expdescS3_.__index__ = Runtime.getFunctionIndex(__Z8codecompP9FuncState6OpCodeiP7expdescS3_, "__Z8codecompP9FuncState6OpCodeiP7expdescS3_");
  
  
  function __Z12luaK_fixlineP9FuncStatei($fs, $line) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $fs;
    $2 = $line;
    var $3 = $2;
    var $4 = $1;
    var $5 = $4+24;
    var $6 = IHEAP[$5];
    var $7 = $6 - 1;
    var $8 = $1;
    var $9 = $8;
    var $10 = IHEAP[$9];
    var $11 = $10+20;
    var $12 = IHEAP[$11];
    var $13 = $12+4*$7;
    IHEAP[$13] = $3;
    ;
    return;
  }
  __Z12luaK_fixlineP9FuncStatei.__index__ = Runtime.getFunctionIndex(__Z12luaK_fixlineP9FuncStatei, "__Z12luaK_fixlineP9FuncStatei");
  
  
  function __Z9luaK_codeP9FuncStateji($fs, $i, $line) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $f;
    $1 = $fs;
    $2 = $i;
    $3 = $line;
    var $4 = $1;
    var $5 = $4;
    var $6 = IHEAP[$5];
    $f = $6;
    var $7 = $1;
    __Z12dischargejpcP9FuncState($7);
    var $8 = $1;
    var $9 = $8+24;
    var $10 = IHEAP[$9];
    var $11 = $10 + 1;
    var $12 = $f;
    var $13 = $12+44;
    var $14 = IHEAP[$13];
    var $15 = $11 > $14;
    ;
    if ($15) {
      ;
      var $17 = $1;
      var $18 = $17+16;
      var $19 = IHEAP[$18];
      var $20 = $f;
      var $21 = $20+12;
      var $22 = IHEAP[$21];
      var $23 = $22;
      var $24 = $f;
      var $25 = $24+44;
      var $26 = __Z13luaM_growaux_P9lua_StatePvPijiPKc($19, $23, $25, 4, 2147483645, __str1533);
      var $27 = $26;
      var $28 = $f;
      var $29 = $28+12;
      IHEAP[$29] = $27;
      ;
    }
    var $31 = $2;
    var $32 = $1;
    var $33 = $32+24;
    var $34 = IHEAP[$33];
    var $35 = $f;
    var $36 = $35+12;
    var $37 = IHEAP[$36];
    var $38 = $37+4*$34;
    IHEAP[$38] = $31;
    var $39 = $1;
    var $40 = $39+24;
    var $41 = IHEAP[$40];
    var $42 = $41 + 1;
    var $43 = $f;
    var $44 = $43+48;
    var $45 = IHEAP[$44];
    var $46 = $42 > $45;
    ;
    if ($46) {
      ;
      var $48 = $1;
      var $49 = $48+16;
      var $50 = IHEAP[$49];
      var $51 = $f;
      var $52 = $51+20;
      var $53 = IHEAP[$52];
      var $54 = $53;
      var $55 = $f;
      var $56 = $55+48;
      var $57 = __Z13luaM_growaux_P9lua_StatePvPijiPKc($50, $54, $56, 4, 2147483645, __str1533);
      var $58 = $57;
      var $59 = $f;
      var $60 = $59+20;
      IHEAP[$60] = $58;
      ;
    }
    var $62 = $3;
    var $63 = $1;
    var $64 = $63+24;
    var $65 = IHEAP[$64];
    var $66 = $f;
    var $67 = $66+20;
    var $68 = IHEAP[$67];
    var $69 = $68+4*$65;
    IHEAP[$69] = $62;
    var $70 = $1;
    var $71 = $70+24;
    var $72 = IHEAP[$71];
    var $73 = $72 + 1;
    IHEAP[$71] = $73;
    ;
    return $72;
  }
  __Z9luaK_codeP9FuncStateji.__index__ = Runtime.getFunctionIndex(__Z9luaK_codeP9FuncStateji, "__Z9luaK_codeP9FuncStateji");
  
  
  function __Z12luaK_setlistP9FuncStateiii($fs, $base, $nelems, $tostore) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $c;
    var $b;
    $1 = $fs;
    $2 = $base;
    $3 = $nelems;
    $4 = $tostore;
    var $5 = $3;
    var $6 = $5 - 1;
    var $7 = Math.floor($6 / 50);
    var $8 = $7 + 1;
    $c = $8;
    var $9 = $4;
    var $10 = $9 == -1;
    var $11 = $4;
    var $12 = $10 ? 0 : $11;
    $b = $12;
    var $13 = $c;
    var $14 = $13 <= 511;
    ;
    if ($14) {
      ;
      var $16 = $1;
      var $17 = $2;
      var $18 = $b;
      var $19 = $c;
      var $20 = __Z12luaK_codeABCP9FuncState6OpCodeiii($16, 34, $17, $18, $19);
      ;
    }
    else {
      ;
      var $22 = $1;
      var $23 = $2;
      var $24 = $b;
      var $25 = __Z12luaK_codeABCP9FuncState6OpCodeiii($22, 34, $23, $24, 0);
      var $26 = $1;
      var $27 = $c;
      var $28 = $1;
      var $29 = $28+12;
      var $30 = IHEAP[$29];
      var $31 = $30+8;
      var $32 = IHEAP[$31];
      var $33 = __Z9luaK_codeP9FuncStateji($26, $27, $32);
      ;
    }
    var $35 = $2;
    var $36 = $35 + 1;
    var $37 = $1;
    var $38 = $37+36;
    IHEAP[$38] = $36;
    ;
    return;
  }
  __Z12luaK_setlistP9FuncStateiii.__index__ = Runtime.getFunctionIndex(__Z12luaK_setlistP9FuncStateiii, "__Z12luaK_setlistP9FuncStateiii");
  
  
  function __Z12dischargejpcP9FuncState($fs) {
    ;
    var __label__;
    var $1;
    $1 = $fs;
    var $2 = $1;
    var $3 = $1;
    var $4 = $3+32;
    var $5 = IHEAP[$4];
    var $6 = $1;
    var $7 = $6+24;
    var $8 = IHEAP[$7];
    var $9 = $1;
    var $10 = $9+24;
    var $11 = IHEAP[$10];
    __Z12patchlistauxP9FuncStateiiii($2, $5, $8, 255, $11);
    var $12 = $1;
    var $13 = $12+32;
    IHEAP[$13] = -1;
    ;
    return;
  }
  __Z12dischargejpcP9FuncState.__index__ = Runtime.getFunctionIndex(__Z12dischargejpcP9FuncState, "__Z12dischargejpcP9FuncState");
  
  
  function __Z8condjumpP9FuncState6OpCodeiii($fs, $op, $A, $B, $C) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $5;
    $1 = $fs;
    $2 = $op;
    $3 = $A;
    $4 = $B;
    $5 = $C;
    var $6 = $1;
    var $7 = $2;
    var $8 = $3;
    var $9 = $4;
    var $10 = $5;
    var $11 = __Z12luaK_codeABCP9FuncState6OpCodeiii($6, $7, $8, $9, $10);
    var $12 = $1;
    var $13 = __Z9luaK_jumpP9FuncState($12);
    ;
    return $13;
  }
  __Z8condjumpP9FuncState6OpCodeiii.__index__ = Runtime.getFunctionIndex(__Z8condjumpP9FuncState6OpCodeiii, "__Z8condjumpP9FuncState6OpCodeiii");
  
  
  function __Z16discharge2anyregP9FuncStateP7expdesc($fs, $e) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $fs;
    $2 = $e;
    var $3 = $2;
    var $4 = $3;
    var $5 = IHEAP[$4];
    var $6 = $5 != 12;
    ;
    if ($6) {
      ;
      var $8 = $1;
      __Z16luaK_reserveregsP9FuncStatei($8, 1);
      var $9 = $1;
      var $10 = $2;
      var $11 = $1;
      var $12 = $11+36;
      var $13 = IHEAP[$12];
      var $14 = $13 - 1;
      __Z13discharge2regP9FuncStateP7expdesci($9, $10, $14);
      ;
    }
    ;
    return;
  }
  __Z16discharge2anyregP9FuncStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z16discharge2anyregP9FuncStateP7expdesc, "__Z16discharge2anyregP9FuncStateP7expdesc");
  
  
  function __Z12removevaluesP9FuncStatei($fs, $list) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $fs;
    $2 = $list;
    ;
    $3$2: while(1) { // $3
      var $4 = $2;
      var $5 = $4 != -1;
      if (!($5)) { __label__ = 2; /* $14 */ break $3$2; }
      var $7 = $1;
      var $8 = $2;
      var $9 = __Z12patchtestregP9FuncStateii($7, $8, 255);
      ;
      var $11 = $1;
      var $12 = $2;
      var $13 = __Z7getjumpP9FuncStatei($11, $12);
      $2 = $13;
      __label__ = 0; /* $3 */ continue $3$2;
    }
    ;
    return;
  }
  __Z12removevaluesP9FuncStatei.__index__ = Runtime.getFunctionIndex(__Z12removevaluesP9FuncStatei, "__Z12removevaluesP9FuncStatei");
  
  
  function __Z12patchtestregP9FuncStateii($fs, $node, $reg) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $i;
    $2 = $fs;
    $3 = $node;
    $4 = $reg;
    var $5 = $2;
    var $6 = $3;
    var $7 = __Z14getjumpcontrolP9FuncStatei($5, $6);
    $i = $7;
    var $8 = $i;
    var $9 = IHEAP[$8];
    var $10 = $9 >> 0;
    var $11 = $10 & 63;
    var $12 = $11 != 27;
    ;
    if ($12) {
      ;
      $1 = 0;
      ;
    }
    else {
      ;
      var $15 = $4;
      var $16 = $15 != 255;
      ;
      $17$33$5: do { 
        if ($16) {
          ;
          var $18 = $4;
          var $19 = $i;
          var $20 = IHEAP[$19];
          var $21 = $20 >> 23;
          var $22 = $21 & 511;
          var $23 = $18 != $22;
          if (!($23)) { __label__ = 2; /* $33 */ break $17$33$5; }
          var $25 = $i;
          var $26 = IHEAP[$25];
          var $27 = $26 & -16321;
          var $28 = $4;
          var $29 = $28 << 6;
          var $30 = $29 & 16320;
          var $31 = $27 | $30;
          var $32 = $i;
          IHEAP[$32] = $31;
          __label__ = 3; /* $47 */ break $17$33$5;
        }
        else {
          __label__ = 2; /* $33 */ 
        }
      } while(0);
      if (__label__ == 2) {
        var $34 = $i;
        var $35 = IHEAP[$34];
        var $36 = $35 >> 23;
        var $37 = $36 & 511;
        var $38 = $37 << 6;
        var $39 = 26 | $38;
        var $40 = $i;
        var $41 = IHEAP[$40];
        var $42 = $41 >> 14;
        var $43 = $42 & 511;
        var $44 = $43 << 14;
        var $45 = $39 | $44;
        var $46 = $i;
        IHEAP[$46] = $45;
        ;
      }
      $1 = 1;
      ;
    }
    var $49 = $1;
    ;
    return $49;
  }
  __Z12patchtestregP9FuncStateii.__index__ = Runtime.getFunctionIndex(__Z12patchtestregP9FuncStateii, "__Z12patchtestregP9FuncStateii");
  
  
  function __Z14getjumpcontrolP9FuncStatei($fs, $pc) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $pi;
    $2 = $fs;
    $3 = $pc;
    var $4 = $3;
    var $5 = $2;
    var $6 = $5;
    var $7 = IHEAP[$6];
    var $8 = $7+12;
    var $9 = IHEAP[$8];
    var $10 = $9+4*$4;
    $pi = $10;
    var $11 = $3;
    var $12 = $11 >= 1;
    ;
    $13$27$2: do { 
      if ($12) {
        ;
        var $14 = $pi;
        var $15 = $14+-4;
        var $16 = IHEAP[$15];
        var $17 = $16 >> 0;
        var $18 = $17 & 63;
        var $19 = _luaP_opmodes+$18;
        var $20 = IHEAP[$19];
        var $21 = $20;
        var $22 = $21 & 128;
        var $23 = $22 != 0;
        if (!($23)) { __label__ = 1; /* $27 */ break $13$27$2; }
        var $25 = $pi;
        var $26 = $25+-4;
        $1 = $26;
        __label__ = 2; /* $29 */ break $13$27$2;
      }
      else {
        __label__ = 1; /* $27 */ 
      }
    } while(0);
    if (__label__ == 1) {
      var $28 = $pi;
      $1 = $28;
      ;
    }
    var $30 = $1;
    ;
    return $30;
  }
  __Z14getjumpcontrolP9FuncStatei.__index__ = Runtime.getFunctionIndex(__Z14getjumpcontrolP9FuncStatei, "__Z14getjumpcontrolP9FuncStatei");
  
  
  function __Z13discharge2regP9FuncStateP7expdesci($fs, $e, $reg) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $pc;
    $1 = $fs;
    $2 = $e;
    $3 = $reg;
    var $4 = $1;
    var $5 = $2;
    __Z18luaK_dischargevarsP9FuncStateP7expdesc($4, $5);
    var $6 = $2;
    var $7 = $6;
    var $8 = IHEAP[$7];
    if ($8 == 1) {
      __label__ = 4; /* $9 */ 
    }
    else if ($8 == 3) {
      __label__ = 5; /* $12 */ 
    }
    else if ($8 == 2) {
      __label__ = 5; /* $12 */ 
    }
    else if ($8 == 4) {
      __label__ = 6; /* $21 */ 
    }
    else if ($8 == 5) {
      __label__ = 7; /* $30 */ 
    }
    else if ($8 == 11) {
      __label__ = 8; /* $41 */ 
    }
    else if ($8 == 12) {
      __label__ = 9; /* $61 */ 
    }
    else {
    __label__ = 10; /* $79 */ 
    }
    
    $79$9$12$21$30$41$61$2: do { 
      if (__label__ == 10) {
        __label__ = 2; /* $88 */ break $79$9$12$21$30$41$61$2;
      }
      else if (__label__ == 4) {
        var $10 = $1;
        var $11 = $3;
        __Z8luaK_nilP9FuncStateii($10, $11, 1);
        __label__ = 0; /* $80 */ break $79$9$12$21$30$41$61$2;
      }
      else if (__label__ == 5) {
        var $13 = $1;
        var $14 = $3;
        var $15 = $2;
        var $16 = $15;
        var $17 = IHEAP[$16];
        var $18 = $17 == 2;
        var $19 = $18;
        var $20 = __Z12luaK_codeABCP9FuncState6OpCodeiii($13, 2, $14, $19, 0);
        __label__ = 0; /* $80 */ break $79$9$12$21$30$41$61$2;
      }
      else if (__label__ == 6) {
        var $22 = $1;
        var $23 = $3;
        var $24 = $2;
        var $25 = $24+4;
        var $26 = $25;
        var $27 = $26;
        var $28 = IHEAP[$27];
        var $29 = __Z12luaK_codeABxP9FuncState6OpCodeij($22, 1, $23, $28);
        __label__ = 0; /* $80 */ break $79$9$12$21$30$41$61$2;
      }
      else if (__label__ == 7) {
        var $31 = $1;
        var $32 = $3;
        var $33 = $1;
        var $34 = $2;
        var $35 = $34+4;
        var $36 = $35;
        var $37 = $36;
        var $38 = FHEAP[$37];
        var $39 = __Z12luaK_numberKP9FuncStated($33, $38);
        var $40 = __Z12luaK_codeABxP9FuncState6OpCodeij($31, 1, $32, $39);
        __label__ = 0; /* $80 */ break $79$9$12$21$30$41$61$2;
      }
      else if (__label__ == 8) {
        var $42 = $2;
        var $43 = $42+4;
        var $44 = $43;
        var $45 = $44;
        var $46 = IHEAP[$45];
        var $47 = $1;
        var $48 = $47;
        var $49 = IHEAP[$48];
        var $50 = $49+12;
        var $51 = IHEAP[$50];
        var $52 = $51+4*$46;
        $pc = $52;
        var $53 = $pc;
        var $54 = IHEAP[$53];
        var $55 = $54 & -16321;
        var $56 = $3;
        var $57 = $56 << 6;
        var $58 = $57 & 16320;
        var $59 = $55 | $58;
        var $60 = $pc;
        IHEAP[$60] = $59;
        __label__ = 0; /* $80 */ break $79$9$12$21$30$41$61$2;
      }
      else if (__label__ == 9) {
        var $62 = $3;
        var $63 = $2;
        var $64 = $63+4;
        var $65 = $64;
        var $66 = $65;
        var $67 = IHEAP[$66];
        var $68 = $62 != $67;
        ;
        if ($68) {
          ;
          var $70 = $1;
          var $71 = $3;
          var $72 = $2;
          var $73 = $72+4;
          var $74 = $73;
          var $75 = $74;
          var $76 = IHEAP[$75];
          var $77 = __Z12luaK_codeABCP9FuncState6OpCodeiii($70, 0, $71, $76, 0);
          ;
        }
        __label__ = 0; /* $80 */ break $79$9$12$21$30$41$61$2;
      }
    } while(0);
    if (__label__ == 0) {
      var $81 = $3;
      var $82 = $2;
      var $83 = $82+4;
      var $84 = $83;
      var $85 = $84;
      IHEAP[$85] = $81;
      var $86 = $2;
      var $87 = $86;
      IHEAP[$87] = 12;
      ;
    }
    ;
    return;
  }
  __Z13discharge2regP9FuncStateP7expdesci.__index__ = Runtime.getFunctionIndex(__Z13discharge2regP9FuncStateP7expdesci, "__Z13discharge2regP9FuncStateP7expdesci");
  
  
  function __Z12constfolding6OpCodeP7expdescS1_($op, $e1, $e2) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $v1;
    var $v2;
    var $r;
    $2 = $op;
    $3 = $e1;
    $4 = $e2;
    var $5 = $3;
    var $6 = __Z9isnumeralP7expdesc($5);
    var $7 = $6 != 0;
    ;
    $8$12$2: do { 
      if ($7) {
        ;
        var $9 = $4;
        var $10 = __Z9isnumeralP7expdesc($9);
        var $11 = $10 != 0;
        if (!($11)) { __label__ = 1; /* $12 */ break $8$12$2; }
        var $14 = $3;
        var $15 = $14+4;
        var $16 = $15;
        var $17 = $16;
        var $18 = FHEAP[$17];
        $v1 = $18;
        var $19 = $4;
        var $20 = $19+4;
        var $21 = $20;
        var $22 = $21;
        var $23 = FHEAP[$22];
        $v2 = $23;
        var $24 = $2;
        if ($24 == 12) {
          __label__ = 5; /* $25 */ 
        }
        else if ($24 == 13) {
          __label__ = 6; /* $29 */ 
        }
        else if ($24 == 14) {
          __label__ = 7; /* $33 */ 
        }
        else if ($24 == 15) {
          __label__ = 8; /* $37 */ 
        }
        else if ($24 == 16) {
          __label__ = 9; /* $45 */ 
        }
        else if ($24 == 17) {
          __label__ = 10; /* $58 */ 
        }
        else if ($24 == 18) {
          __label__ = 11; /* $62 */ 
        }
        else if ($24 == 20) {
          __label__ = 12; /* $65 */ 
        }
        else {
        __label__ = 13; /* $66 */ 
        }
        
        if (__label__ == 13) {
          $r = 0;
          ;
        }
        else if (__label__ == 5) {
          var $26 = $v1;
          var $27 = $v2;
          var $28 = $26 + $27;
          $r = $28;
          ;
        }
        else if (__label__ == 6) {
          var $30 = $v1;
          var $31 = $v2;
          var $32 = $30 - $31;
          $r = $32;
          ;
        }
        else if (__label__ == 7) {
          var $34 = $v1;
          var $35 = $v2;
          var $36 = $34 * $35;
          $r = $36;
          ;
        }
        else if (__label__ == 8) {
          var $38 = $v2;
          var $39 = $38 == 0;
          ;
          if ($39) {
            ;
            $1 = 0;
            __label__ = 4; /* $78 */ break $8$12$2;
          }
          else {
            ;
            var $42 = $v1;
            var $43 = $v2;
            var $44 = $42 / $43;
            $r = $44;
            ;
          }
        }
        else if (__label__ == 9) {
          var $46 = $v2;
          var $47 = $46 == 0;
          ;
          if ($47) {
            ;
            $1 = 0;
            __label__ = 4; /* $78 */ break $8$12$2;
          }
          else {
            ;
            var $50 = $v1;
            var $51 = $v1;
            var $52 = $v2;
            var $53 = $51 / $52;
            var $54 = _floor($53);
            var $55 = $v2;
            var $56 = $54 * $55;
            var $57 = $50 - $56;
            $r = $57;
            ;
          }
        }
        else if (__label__ == 10) {
          var $59 = $v1;
          var $60 = $v2;
          var $61 = _llvm_pow_f64($59, $60);
          $r = $61;
          ;
        }
        else if (__label__ == 11) {
          var $63 = $v1;
          var $64 = 0 - $63;
          $r = $64;
          ;
        }
        else if (__label__ == 12) {
          $1 = 0;
          __label__ = 4; /* $78 */ break $8$12$2;
        }
        var $68 = $r;
        var $69 = $r;
        var $70 = $68 == $69;
        ;
        if ($70) {
          ;
          var $73 = $r;
          var $74 = $3;
          var $75 = $74+4;
          var $76 = $75;
          var $77 = $76;
          FHEAP[$77] = $73;
          $1 = 1;
          __label__ = 4; /* $78 */ break $8$12$2;
        }
        else {
          ;
          $1 = 0;
          __label__ = 4; /* $78 */ break $8$12$2;
        }
      }
      else {
        __label__ = 1; /* $12 */ 
      }
    } while(0);
    if (__label__ == 1) {
      $1 = 0;
      ;
    }
    var $79 = $1;
    ;
    return $79;
  }
  __Z12constfolding6OpCodeP7expdescS1_.__index__ = Runtime.getFunctionIndex(__Z12constfolding6OpCodeP7expdescS1_, "__Z12constfolding6OpCodeP7expdescS1_");
  
  
  function __Z10need_valueP9FuncStatei($fs, $list) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $i;
    $2 = $fs;
    $3 = $list;
    ;
    $4$2: while(1) { // $4
      var $5 = $3;
      var $6 = $5 != -1;
      if (!($6)) { __label__ = 2; /* $22 */ break $4$2; }
      var $8 = $2;
      var $9 = $3;
      var $10 = __Z14getjumpcontrolP9FuncStatei($8, $9);
      var $11 = IHEAP[$10];
      $i = $11;
      var $12 = $i;
      var $13 = $12 >> 0;
      var $14 = $13 & 63;
      var $15 = $14 != 27;
      if ($15) { __label__ = 3; /* $16 */ break $4$2; }
      ;
      var $19 = $2;
      var $20 = $3;
      var $21 = __Z7getjumpP9FuncStatei($19, $20);
      $3 = $21;
      __label__ = 0; /* $4 */ continue $4$2;
    }
    if (__label__ == 2) {
      $1 = 0;
      ;
    }
    else if (__label__ == 3) {
      $1 = 1;
      ;
    }
    var $24 = $1;
    ;
    return $24;
  }
  __Z10need_valueP9FuncStatei.__index__ = Runtime.getFunctionIndex(__Z10need_valueP9FuncStatei, "__Z10need_valueP9FuncStatei");
  
  
  function __Z10code_labelP9FuncStateiii($fs, $A, $b, $jump) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    $1 = $fs;
    $2 = $A;
    $3 = $b;
    $4 = $jump;
    var $5 = $1;
    var $6 = __Z13luaK_getlabelP9FuncState($5);
    var $7 = $1;
    var $8 = $2;
    var $9 = $3;
    var $10 = $4;
    var $11 = __Z12luaK_codeABCP9FuncState6OpCodeiii($7, 2, $8, $9, $10);
    ;
    return $11;
  }
  __Z10code_labelP9FuncStateiii.__index__ = Runtime.getFunctionIndex(__Z10code_labelP9FuncStateiii, "__Z10code_labelP9FuncStateiii");
  
  
  function __Z11lua_sethookP9lua_StatePFvS0_P9lua_DebugEii($L, $func, $mask, $count) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    $1 = $L;
    $2 = $func;
    $3 = $mask;
    $4 = $count;
    var $5 = $2;
    var $6 = $5 == 0;
    ;
    $10$7$2: do { 
      if ($6) {
        __label__ = 0; /* $10 */ 
      }
      else {
        ;
        var $8 = $3;
        var $9 = $8 == 0;
        if ($9) { __label__ = 0; /* $10 */ break $10$7$2; } else { __label__ = 1; /* $11 */ break $10$7$2; }
      }
    } while(0);
    if (__label__ == 0) {
      $3 = 0;
      $2 = 0;
      ;
    }
    var $12 = $2;
    var $13 = $1;
    var $14 = $13+68;
    IHEAP[$14] = $12;
    var $15 = $4;
    var $16 = $1;
    var $17 = $16+60;
    IHEAP[$17] = $15;
    var $18 = $1;
    var $19 = $18+60;
    var $20 = IHEAP[$19];
    var $21 = $1;
    var $22 = $21+64;
    IHEAP[$22] = $20;
    var $23 = $3;
    var $24 = $23;
    var $25 = $1;
    var $26 = $25+56;
    IHEAP[$26] = $24;
    ;
    return 1;
  }
  __Z11lua_sethookP9lua_StatePFvS0_P9lua_DebugEii.__index__ = Runtime.getFunctionIndex(__Z11lua_sethookP9lua_StatePFvS0_P9lua_DebugEii, "__Z11lua_sethookP9lua_StatePFvS0_P9lua_DebugEii");
  
  
  function __Z11lua_gethookP9lua_State($L) {
    ;
    var __label__;
    var $1;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+68;
    var $4 = IHEAP[$3];
    ;
    return $4;
  }
  __Z11lua_gethookP9lua_State.__index__ = Runtime.getFunctionIndex(__Z11lua_gethookP9lua_State, "__Z11lua_gethookP9lua_State");
  
  
  function __Z15lua_gethookmaskP9lua_State($L) {
    ;
    var __label__;
    var $1;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+56;
    var $4 = IHEAP[$3];
    var $5 = $4;
    ;
    return $5;
  }
  __Z15lua_gethookmaskP9lua_State.__index__ = Runtime.getFunctionIndex(__Z15lua_gethookmaskP9lua_State, "__Z15lua_gethookmaskP9lua_State");
  
  
  function __Z16lua_gethookcountP9lua_State($L) {
    ;
    var __label__;
    var $1;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+60;
    var $4 = IHEAP[$3];
    ;
    return $4;
  }
  __Z16lua_gethookcountP9lua_State.__index__ = Runtime.getFunctionIndex(__Z16lua_gethookcountP9lua_State, "__Z16lua_gethookcountP9lua_State");
  
  
  function __Z12lua_getstackP9lua_StateiP9lua_Debug($L, $level, $ar) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $status;
    var $ci;
    $1 = $L;
    $2 = $level;
    $3 = $ar;
    var $4 = $1;
    var $5 = $4+20;
    var $6 = IHEAP[$5];
    $ci = $6;
    ;
    $7$2: while(1) { // $7
      var $8 = $2;
      var $9 = $8 > 0;
      ;
      if ($9) {
        __lastLabel__ = 0; ;
        var $11 = $ci;
        var $12 = $1;
        var $13 = $12+40;
        var $14 = IHEAP[$13];
        var $15 = $11 > $14;
        __lastLabel__ = 1; ;
      }
      else {
        __lastLabel__ = 0; ;
      }
      var $17 = __lastLabel__ == 0 ? 0 : ($15);
      if (!($17)) { __label__ = 4; /* $44 */ break $7$2; }
      var $19 = $2;
      var $20 = $19 + -1;
      $2 = $20;
      var $21 = $ci;
      var $22 = $21+4;
      var $23 = IHEAP[$22];
      var $24 = $23;
      var $25 = $24;
      var $26 = $25;
      var $27 = IHEAP[$26];
      var $28 = $27;
      var $29 = $28;
      var $30 = $29;
      var $31 = $30+6;
      var $32 = IHEAP[$31];
      var $33 = $32 != 0;
      ;
      if (!$33) {
        ;
        var $35 = $ci;
        var $36 = $35+20;
        var $37 = IHEAP[$36];
        var $38 = $2;
        var $39 = $38 - $37;
        $2 = $39;
        ;
      }
      ;
      var $42 = $ci;
      var $43 = $42+-24;
      $ci = $43;
      __label__ = 0; /* $7 */ continue $7$2;
    }
    var $45 = $2;
    var $46 = $45 == 0;
    ;
    $47$64$13: do { 
      if ($46) {
        ;
        var $48 = $ci;
        var $49 = $1;
        var $50 = $49+40;
        var $51 = IHEAP[$50];
        var $52 = $48 > $51;
        if (!($52)) { __label__ = 8; /* $64 */ break $47$64$13; }
        $status = 1;
        var $54 = $ci;
        var $55 = $1;
        var $56 = $55+40;
        var $57 = IHEAP[$56];
        var $58 = $54;
        var $59 = $57;
        var $60 = $58 - $59;
        var $61 = Math.floor($60 / 24);
        var $62 = $3;
        var $63 = $62+96;
        IHEAP[$63] = $61;
        __label__ = 9; /* $72 */ break $47$64$13;
      }
      else {
        __label__ = 8; /* $64 */ 
      }
    } while(0);
    if (__label__ == 8) {
      var $65 = $2;
      var $66 = $65 < 0;
      ;
      if ($66) {
        ;
        $status = 1;
        var $68 = $3;
        var $69 = $68+96;
        IHEAP[$69] = 0;
        ;
      }
      else {
        ;
        $status = 0;
        ;
      }
      ;
    }
    var $73 = $status;
    ;
    return $73;
  }
  __Z12lua_getstackP9lua_StateiP9lua_Debug.__index__ = Runtime.getFunctionIndex(__Z12lua_getstackP9lua_StateiP9lua_Debug, "__Z12lua_getstackP9lua_StateiP9lua_Debug");
  
  
  function __Z12lua_getlocalP9lua_StatePK9lua_Debugi($L, $ar, $n) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $ci;
    var $name;
    $1 = $L;
    $2 = $ar;
    $3 = $n;
    var $4 = $1;
    var $5 = $4+40;
    var $6 = IHEAP[$5];
    var $7 = $2;
    var $8 = $7+96;
    var $9 = IHEAP[$8];
    var $10 = $6+24*$9;
    $ci = $10;
    var $11 = $1;
    var $12 = $ci;
    var $13 = $3;
    var $14 = __Z9findlocalP9lua_StateP8CallInfoi($11, $12, $13);
    $name = $14;
    var $15 = $name;
    var $16 = $15 != 0;
    ;
    if ($16) {
      ;
      var $18 = $1;
      var $19 = $ci;
      var $20 = $19;
      var $21 = IHEAP[$20];
      var $22 = $3;
      var $23 = $22 - 1;
      var $24 = $21+12*$23;
      __Z15luaA_pushobjectP9lua_StatePK10lua_TValue($18, $24);
      ;
    }
    var $26 = $name;
    ;
    return $26;
  }
  __Z12lua_getlocalP9lua_StatePK9lua_Debugi.__index__ = Runtime.getFunctionIndex(__Z12lua_getlocalP9lua_StatePK9lua_Debugi, "__Z12lua_getlocalP9lua_StatePK9lua_Debugi");
  
  
  function __Z9findlocalP9lua_StateP8CallInfoi($L, $ci, $n) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $4;
    var $name;
    var $fp;
    var $limit;
    $2 = $L;
    $3 = $ci;
    $4 = $n;
    var $5 = $3;
    var $6 = __Z11getluaprotoP8CallInfo($5);
    $fp = $6;
    var $7 = $fp;
    var $8 = $7 != 0;
    ;
    $9$19$2: do { 
      if ($8) {
        ;
        var $10 = $fp;
        var $11 = $4;
        var $12 = $2;
        var $13 = $3;
        var $14 = __Z9currentpcP9lua_StateP8CallInfo($12, $13);
        var $15 = __Z17luaF_getlocalnamePK5Protoii($10, $11, $14);
        $name = $15;
        var $16 = $15 != 0;
        if (!($16)) { __label__ = 1; /* $19 */ break $9$19$2; }
        var $18 = $name;
        $1 = $18;
        __label__ = 2; /* $51 */ break $9$19$2;
      }
      else {
        __label__ = 1; /* $19 */ 
      }
    } while(0);
    $51$19$5: do { 
      if (__label__ == 1) {
        var $20 = $3;
        var $21 = $2;
        var $22 = $21+20;
        var $23 = IHEAP[$22];
        var $24 = $20 == $23;
        ;
        if ($24) {
          ;
          var $26 = $2;
          var $27 = $26+8;
          var $28 = IHEAP[$27];
          __lastLabel__ = 3; ;
        }
        else {
          ;
          var $30 = $3;
          var $31 = $30+24;
          var $32 = $31+4;
          var $33 = IHEAP[$32];
          __lastLabel__ = 5; ;
        }
        var $35 = __lastLabel__ == 3 ? $28 : ($33);
        $limit = $35;
        var $36 = $limit;
        var $37 = $3;
        var $38 = $37;
        var $39 = IHEAP[$38];
        var $40 = $36;
        var $41 = $39;
        var $42 = $40 - $41;
        var $43 = Math.floor($42 / 12);
        var $44 = $4;
        var $45 = $43 >= $44;
        ;
        $46$50$11: do { 
          if ($45) {
            ;
            var $47 = $4;
            var $48 = $47 > 0;
            if (!($48)) { __label__ = 7; /* $50 */ break $46$50$11; }
            $1 = __str2049;
            __label__ = 2; /* $51 */ break $51$19$5;
          }
        } while(0);
        $1 = 0;
        ;
      }
    } while(0);
    var $52 = $1;
    ;
    return $52;
  }
  __Z9findlocalP9lua_StateP8CallInfoi.__index__ = Runtime.getFunctionIndex(__Z9findlocalP9lua_StateP8CallInfoi, "__Z9findlocalP9lua_StateP8CallInfoi");
  
  
  function __Z12lua_setlocalP9lua_StatePK9lua_Debugi($L, $ar, $n) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $ci;
    var $name;
    var $o2;
    var $o1;
    $1 = $L;
    $2 = $ar;
    $3 = $n;
    var $4 = $1;
    var $5 = $4+40;
    var $6 = IHEAP[$5];
    var $7 = $2;
    var $8 = $7+96;
    var $9 = IHEAP[$8];
    var $10 = $6+24*$9;
    $ci = $10;
    var $11 = $1;
    var $12 = $ci;
    var $13 = $3;
    var $14 = __Z9findlocalP9lua_StateP8CallInfoi($11, $12, $13);
    $name = $14;
    var $15 = $name;
    var $16 = $15 != 0;
    ;
    if ($16) {
      ;
      var $18 = $1;
      var $19 = $18+8;
      var $20 = IHEAP[$19];
      var $21 = $20+-12;
      $o2 = $21;
      var $22 = $ci;
      var $23 = $22;
      var $24 = IHEAP[$23];
      var $25 = $3;
      var $26 = $25 - 1;
      var $27 = $24+12*$26;
      $o1 = $27;
      var $28 = $o1;
      var $29 = $28;
      var $30 = $o2;
      var $31 = $30;
      var $32 = $29;
      var $33 = $31;
      _llvm_memcpy_p0i8_p0i8_i32($32, $33, 8, 4, 0);
      var $34 = $o2;
      var $35 = $34+8;
      var $36 = IHEAP[$35];
      var $37 = $o1;
      var $38 = $37+8;
      IHEAP[$38] = $36;
      ;
    }
    var $40 = $1;
    var $41 = $40+8;
    var $42 = IHEAP[$41];
    var $43 = $42+-12;
    IHEAP[$41] = $43;
    var $44 = $name;
    ;
    return $44;
  }
  __Z12lua_setlocalP9lua_StatePK9lua_Debugi.__index__ = Runtime.getFunctionIndex(__Z12lua_setlocalP9lua_StatePK9lua_Debugi, "__Z12lua_setlocalP9lua_StatePK9lua_Debugi");
  
  
  function __Z11lua_getinfoP9lua_StatePKcP9lua_Debug($L, $what, $ar) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $status;
    var $f;
    var $ci;
    var $func;
    var $i_o;
    $1 = $L;
    $2 = $what;
    $3 = $ar;
    $f = 0;
    $ci = 0;
    var $4 = $2;
    var $5 = IHEAP[$4];
    var $6 = $5;
    var $7 = $6 == 62;
    ;
    if ($7) {
      ;
      var $9 = $1;
      var $10 = $9+8;
      var $11 = IHEAP[$10];
      var $12 = $11+-12;
      $func = $12;
      var $13 = $2;
      var $14 = $13+1;
      $2 = $14;
      var $15 = $func;
      var $16 = $15;
      var $17 = $16;
      var $18 = $17;
      var $19 = IHEAP[$18];
      var $20 = $19;
      var $21 = $20;
      $f = $21;
      var $22 = $1;
      var $23 = $22+8;
      var $24 = IHEAP[$23];
      var $25 = $24+-12;
      IHEAP[$23] = $25;
      ;
    }
    else {
      ;
      var $27 = $3;
      var $28 = $27+96;
      var $29 = IHEAP[$28];
      var $30 = $29 != 0;
      ;
      if ($30) {
        ;
        var $32 = $1;
        var $33 = $32+40;
        var $34 = IHEAP[$33];
        var $35 = $3;
        var $36 = $35+96;
        var $37 = IHEAP[$36];
        var $38 = $34+24*$37;
        $ci = $38;
        var $39 = $ci;
        var $40 = $39+4;
        var $41 = IHEAP[$40];
        var $42 = $41;
        var $43 = $42;
        var $44 = $43;
        var $45 = IHEAP[$44];
        var $46 = $45;
        var $47 = $46;
        $f = $47;
        ;
      }
      ;
    }
    var $50 = $1;
    var $51 = $2;
    var $52 = $3;
    var $53 = $f;
    var $54 = $ci;
    var $55 = __Z10auxgetinfoP9lua_StatePKcP9lua_DebugP7ClosureP8CallInfo($50, $51, $52, $53, $54);
    $status = $55;
    var $56 = $2;
    var $57 = _strchr($56, 102);
    var $58 = $57 != 0;
    ;
    if ($58) {
      ;
      var $60 = $f;
      var $61 = $60 == 0;
      ;
      if ($61) {
        ;
        var $63 = $1;
        var $64 = $63+8;
        var $65 = IHEAP[$64];
        var $66 = $65+8;
        IHEAP[$66] = 0;
        ;
      }
      else {
        ;
        var $68 = $1;
        var $69 = $68+8;
        var $70 = IHEAP[$69];
        $i_o = $70;
        var $71 = $f;
        var $72 = $71;
        var $73 = $i_o;
        var $74 = $73;
        var $75 = $74;
        var $76 = $75;
        IHEAP[$76] = $72;
        var $77 = $i_o;
        var $78 = $77+8;
        IHEAP[$78] = 6;
        ;
      }
      var $80 = $1;
      var $81 = $80+28;
      var $82 = IHEAP[$81];
      var $83 = $82;
      var $84 = $1;
      var $85 = $84+8;
      var $86 = IHEAP[$85];
      var $87 = $86;
      var $88 = $83;
      var $89 = $87;
      var $90 = $88 - $89;
      var $91 = $90 <= 12;
      ;
      if ($91) {
        ;
        var $93 = $1;
        __Z14luaD_growstackP9lua_Statei($93, 1);
        ;
      }
      else {
        ;
        ;
      }
      var $96 = $1;
      var $97 = $96+8;
      var $98 = IHEAP[$97];
      var $99 = $98+12;
      IHEAP[$97] = $99;
      ;
    }
    var $101 = $2;
    var $102 = _strchr($101, 76);
    var $103 = $102 != 0;
    ;
    if ($103) {
      ;
      var $105 = $1;
      var $106 = $f;
      __Z17collectvalidlinesP9lua_StateP7Closure($105, $106);
      ;
    }
    var $108 = $status;
    ;
    return $108;
  }
  __Z11lua_getinfoP9lua_StatePKcP9lua_Debug.__index__ = Runtime.getFunctionIndex(__Z11lua_getinfoP9lua_StatePKcP9lua_Debug, "__Z11lua_getinfoP9lua_StatePKcP9lua_Debug");
  
  
  function __Z10auxgetinfoP9lua_StatePKcP9lua_DebugP7ClosureP8CallInfo($L, $what, $ar, $f, $ci) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $4;
    var $5;
    var $6;
    var $status;
    $2 = $L;
    $3 = $what;
    $4 = $ar;
    $5 = $f;
    $6 = $ci;
    $status = 1;
    var $7 = $5;
    var $8 = $7 == 0;
    ;
    if ($8) {
      ;
      var $10 = $4;
      __Z13info_tailcallP9lua_Debug($10);
      var $11 = $status;
      $1 = $11;
      ;
    }
    else {
      ;
      ;
      $13$5: while(1) { // $13
        var $14 = $3;
        var $15 = IHEAP[$14];
        var $16 = $15 != 0;
        if (!($16)) { __label__ = 3; /* $74 */ break $13$5; }
        var $18 = $3;
        var $19 = IHEAP[$18];
        var $20 = $19;
        if ($20 == 83) {
          __label__ = 13; /* $21 */ 
        }
        else if ($20 == 108) {
          __label__ = 14; /* $24 */ 
        }
        else if ($20 == 117) {
          __label__ = 15; /* $36 */ 
        }
        else if ($20 == 110) {
          __label__ = 16; /* $44 */ 
        }
        else if ($20 == 76) {
          __label__ = 17; /* $68 */ 
        }
        else if ($20 == 102) {
          __label__ = 17; /* $68 */ 
        }
        else {
        __label__ = 18; /* $69 */ 
        }
        
        if (__label__ == 18) {
          $status = 0;
          ;
        }
        else if (__label__ == 13) {
          var $22 = $4;
          var $23 = $5;
          __Z8funcinfoP9lua_DebugP7Closure($22, $23);
          ;
        }
        else if (__label__ == 14) {
          var $25 = $6;
          var $26 = $25 != 0;
          ;
          if ($26) {
            ;
            var $28 = $2;
            var $29 = $6;
            var $30 = __Z11currentlineP9lua_StateP8CallInfo($28, $29);
            __lastLabel__ = 5; ;
          }
          else {
            ;
            __lastLabel__ = 7; ;
          }
          var $33 = __lastLabel__ == 5 ? $30 : (-1);
          var $34 = $4;
          var $35 = $34+20;
          IHEAP[$35] = $33;
          ;
        }
        else if (__label__ == 15) {
          var $37 = $5;
          var $38 = $37;
          var $39 = $38+7;
          var $40 = IHEAP[$39];
          var $41 = $40;
          var $42 = $4;
          var $43 = $42+24;
          IHEAP[$43] = $41;
          ;
        }
        else if (__label__ == 16) {
          var $45 = $6;
          var $46 = $45 != 0;
          ;
          if ($46) {
            ;
            var $48 = $2;
            var $49 = $6;
            var $50 = $4;
            var $51 = $50+4;
            var $52 = __Z11getfuncnameP9lua_StateP8CallInfoPPKc($48, $49, $51);
            __lastLabel__ = 8; ;
          }
          else {
            ;
            __lastLabel__ = 10; ;
          }
          var $55 = __lastLabel__ == 8 ? $52 : (0);
          var $56 = $4;
          var $57 = $56+8;
          IHEAP[$57] = $55;
          var $58 = $4;
          var $59 = $58+8;
          var $60 = IHEAP[$59];
          var $61 = $60 == 0;
          ;
          if ($61) {
            ;
            var $63 = $4;
            var $64 = $63+8;
            IHEAP[$64] = __str1344;
            var $65 = $4;
            var $66 = $65+4;
            IHEAP[$66] = 0;
            ;
          }
          ;
        }
        else if (__label__ == 17) {
          ;
        }
        ;
        var $72 = $3;
        var $73 = $72+1;
        $3 = $73;
        __label__ = 1; /* $13 */ continue $13$5;
      }
      var $75 = $status;
      $1 = $75;
      ;
    }
    var $77 = $1;
    ;
    return $77;
  }
  __Z10auxgetinfoP9lua_StatePKcP9lua_DebugP7ClosureP8CallInfo.__index__ = Runtime.getFunctionIndex(__Z10auxgetinfoP9lua_StatePKcP9lua_DebugP7ClosureP8CallInfo, "__Z10auxgetinfoP9lua_StatePKcP9lua_DebugP7ClosureP8CallInfo");
  
  
  function __Z17collectvalidlinesP9lua_StateP7Closure($L, $f) {
    ;
    var __label__;
    var $1;
    var $2;
    var $t;
    var $lineinfo;
    var $i;
    var $i_o;
    var $i_o1;
    $1 = $L;
    $2 = $f;
    var $3 = $2;
    var $4 = $3 == 0;
    ;
    $11$5$2: do { 
      if ($4) {
        __label__ = 0; /* $11 */ 
      }
      else {
        ;
        var $6 = $2;
        var $7 = $6;
        var $8 = $7+6;
        var $9 = IHEAP[$8];
        var $10 = $9 != 0;
        if ($10) { __label__ = 0; /* $11 */ break $11$5$2; }
        var $17 = $1;
        var $18 = __Z8luaH_newP9lua_Stateii($17, 0, 0);
        $t = $18;
        var $19 = $2;
        var $20 = $19;
        var $21 = $20;
        var $22 = $21+16;
        var $23 = IHEAP[$22];
        var $24 = $23+20;
        var $25 = IHEAP[$24];
        $lineinfo = $25;
        $i = 0;
        ;
        $26$5: while(1) { // $26
          var $27 = $i;
          var $28 = $2;
          var $29 = $28;
          var $30 = $29;
          var $31 = $30+16;
          var $32 = IHEAP[$31];
          var $33 = $32+48;
          var $34 = IHEAP[$33];
          var $35 = $27 < $34;
          if (!($35)) { __label__ = 5; /* $53 */ break $26$5; }
          var $37 = $1;
          var $38 = $t;
          var $39 = $i;
          var $40 = $lineinfo;
          var $41 = $40+4*$39;
          var $42 = IHEAP[$41];
          var $43 = __Z11luaH_setnumP9lua_StateP5Tablei($37, $38, $42);
          $i_o = $43;
          var $44 = $i_o;
          var $45 = $44;
          var $46 = $45;
          var $47 = $46;
          IHEAP[$47] = 1;
          var $48 = $i_o;
          var $49 = $48+8;
          IHEAP[$49] = 1;
          ;
          var $51 = $i;
          var $52 = $51 + 1;
          $i = $52;
          __label__ = 3; /* $26 */ continue $26$5;
        }
        var $54 = $1;
        var $55 = $54+8;
        var $56 = IHEAP[$55];
        $i_o1 = $56;
        var $57 = $t;
        var $58 = $57;
        var $59 = $i_o1;
        var $60 = $59;
        var $61 = $60;
        var $62 = $61;
        IHEAP[$62] = $58;
        var $63 = $i_o1;
        var $64 = $63+8;
        IHEAP[$64] = 5;
        __label__ = 7; /* $65 */ break $11$5$2;
      }
    } while(0);
    if (__label__ == 0) {
      var $12 = $1;
      var $13 = $12+8;
      var $14 = IHEAP[$13];
      var $15 = $14+8;
      IHEAP[$15] = 0;
      ;
    }
    var $66 = $1;
    var $67 = $66+28;
    var $68 = IHEAP[$67];
    var $69 = $68;
    var $70 = $1;
    var $71 = $70+8;
    var $72 = IHEAP[$71];
    var $73 = $72;
    var $74 = $69;
    var $75 = $73;
    var $76 = $74 - $75;
    var $77 = $76 <= 12;
    ;
    if ($77) {
      ;
      var $79 = $1;
      __Z14luaD_growstackP9lua_Statei($79, 1);
      ;
    }
    else {
      ;
      ;
    }
    var $82 = $1;
    var $83 = $82+8;
    var $84 = IHEAP[$83];
    var $85 = $84+12;
    IHEAP[$83] = $85;
    ;
    return;
  }
  __Z17collectvalidlinesP9lua_StateP7Closure.__index__ = Runtime.getFunctionIndex(__Z17collectvalidlinesP9lua_StateP7Closure, "__Z17collectvalidlinesP9lua_StateP7Closure");
  
  
  function __Z16luaG_checkopenopj($i) {
    ;
    var __label__;
    var $1;
    var $2;
    $2 = $i;
    var $3 = $2;
    var $4 = $3 >> 0;
    var $5 = $4 & 63;
    if ($5 == 28) {
      __label__ = 1; /* $6 */ 
    }
    else if ($5 == 29) {
      __label__ = 1; /* $6 */ 
    }
    else if ($5 == 30) {
      __label__ = 1; /* $6 */ 
    }
    else if ($5 == 34) {
      __label__ = 1; /* $6 */ 
    }
    else {
    __label__ = 2; /* $13 */ 
    }
    
    if (__label__ == 2) {
      $1 = 0;
      ;
    }
    else if (__label__ == 1) {
      var $7 = $2;
      var $8 = $7 >> 23;
      var $9 = $8 & 511;
      var $10 = $9 == 0;
      ;
      if ($10) {
        ;
        $1 = 1;
        ;
      }
      else {
        ;
        $1 = 0;
        ;
      }
    }
    var $15 = $1;
    ;
    return $15;
  }
  __Z16luaG_checkopenopj.__index__ = Runtime.getFunctionIndex(__Z16luaG_checkopenopj, "__Z16luaG_checkopenopj");
  
  
  function __Z14luaG_checkcodePK5Proto($pt) {
    ;
    var __label__;
    var $1;
    $1 = $pt;
    var $2 = $1;
    var $3 = $1;
    var $4 = $3+44;
    var $5 = IHEAP[$4];
    var $6 = __Z8symbexecPK5Protoii($2, $5, 255);
    var $7 = $6 != 0;
    var $8 = $7;
    ;
    return $8;
  }
  __Z14luaG_checkcodePK5Proto.__index__ = Runtime.getFunctionIndex(__Z14luaG_checkcodePK5Proto, "__Z14luaG_checkcodePK5Proto");
  
  
  function __Z8symbexecPK5Protoii($pt, $lastpc, $reg) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $pc;
    var $last;
    var $i;
    var $op;
    var $a;
    var $b;
    var $c;
    var $dest;
    var $j;
    var $d;
    var $dest1;
    var $nup;
    var $j2;
    var $op1;
    $2 = $pt;
    $3 = $lastpc;
    $4 = $reg;
    var $5 = $2;
    var $6 = $5+44;
    var $7 = IHEAP[$6];
    var $8 = $7 - 1;
    $last = $8;
    var $9 = $2;
    var $10 = __Z8precheckPK5Proto($9);
    var $11 = $10 != 0;
    ;
    if ($11) {
      ;
      $pc = 0;
      ;
      $14$4: while(1) { // $14
        var $15 = $pc;
        var $16 = $3;
        var $17 = $15 < $16;
        if (!($17)) { __label__ = 3; /* $562 */ break $14$4; }
        var $19 = $pc;
        var $20 = $2;
        var $21 = $20+12;
        var $22 = IHEAP[$21];
        var $23 = $22+4*$19;
        var $24 = IHEAP[$23];
        $i = $24;
        var $25 = $i;
        var $26 = $25 >> 0;
        var $27 = $26 & 63;
        $op = $27;
        var $28 = $i;
        var $29 = $28 >> 6;
        var $30 = $29 & 255;
        $a = $30;
        $b = 0;
        $c = 0;
        var $31 = $op;
        var $32 = $31 < 38;
        if (!($32)) { __label__ = 5; /* $33 */ break $14$4; }
        var $35 = $a;
        var $36 = $2;
        var $37 = $36+75;
        var $38 = IHEAP[$37];
        var $39 = $38;
        var $40 = $35 < $39;
        if (!($40)) { __label__ = 7; /* $41 */ break $14$4; }
        var $43 = $op;
        var $44 = _luaP_opmodes+$43;
        var $45 = IHEAP[$44];
        var $46 = $45;
        var $47 = $46 & 3;
        if ($47 == 0) {
          __label__ = 108; /* $48 */ 
        }
        else if ($47 == 1) {
          __label__ = 109; /* $79 */ 
        }
        else if ($47 == 2) {
          __label__ = 110; /* $99 */ 
        }
        else {
        __label__ = 111; /* $165 */ 
        }
        
        if (__label__ == 108) {
          var $49 = $i;
          var $50 = $49 >> 23;
          var $51 = $50 & 511;
          $b = $51;
          var $52 = $i;
          var $53 = $52 >> 14;
          var $54 = $53 & 511;
          $c = $54;
          var $55 = $2;
          var $56 = $b;
          var $57 = $op;
          var $58 = _luaP_opmodes+$57;
          var $59 = IHEAP[$58];
          var $60 = $59;
          var $61 = $60 >> 4;
          var $62 = $61 & 3;
          var $63 = __Z12checkArgModePK5Protoi9OpArgMask($55, $56, $62);
          var $64 = $63 != 0;
          if (!($64)) { __label__ = 9; /* $65 */ break $14$4; }
          var $67 = $2;
          var $68 = $c;
          var $69 = $op;
          var $70 = _luaP_opmodes+$69;
          var $71 = IHEAP[$70];
          var $72 = $71;
          var $73 = $72 >> 2;
          var $74 = $73 & 3;
          var $75 = __Z12checkArgModePK5Protoi9OpArgMask($67, $68, $74);
          var $76 = $75 != 0;
          if (!($76)) { __label__ = 11; /* $77 */ break $14$4; }
          ;
        }
        else if (__label__ == 109) {
          var $80 = $i;
          var $81 = $80 >> 14;
          var $82 = $81 & 262143;
          $b = $82;
          var $83 = $op;
          var $84 = _luaP_opmodes+$83;
          var $85 = IHEAP[$84];
          var $86 = $85;
          var $87 = $86 >> 4;
          var $88 = $87 & 3;
          var $89 = $88 == 3;
          ;
          if ($89) {
            ;
            var $91 = $b;
            var $92 = $2;
            var $93 = $92+40;
            var $94 = IHEAP[$93];
            var $95 = $91 < $94;
            if (!($95)) { __label__ = 14; /* $96 */ break $14$4; }
            ;
          }
          ;
        }
        else if (__label__ == 110) {
          var $100 = $i;
          var $101 = $100 >> 14;
          var $102 = $101 & 262143;
          var $103 = $102 - 131071;
          $b = $103;
          var $104 = $op;
          var $105 = _luaP_opmodes+$104;
          var $106 = IHEAP[$105];
          var $107 = $106;
          var $108 = $107 >> 4;
          var $109 = $108 & 3;
          var $110 = $109 == 2;
          ;
          if ($110) {
            ;
            var $112 = $pc;
            var $113 = $112 + 1;
            var $114 = $b;
            var $115 = $113 + $114;
            $dest = $115;
            var $116 = $dest;
            var $117 = 0 <= $116;
            if (!($117)) { __label__ = 17; /* $124 */ break $14$4; }
            var $119 = $dest;
            var $120 = $2;
            var $121 = $120+44;
            var $122 = IHEAP[$121];
            var $123 = $119 < $122;
            if (!($123)) { __label__ = 17; /* $124 */ break $14$4; }
            var $126 = $dest;
            var $127 = $126 > 0;
            ;
            if ($127) {
              ;
              $j = 0;
              ;
              $129$25: while(1) { // $129
                var $130 = $j;
                var $131 = $dest;
                var $132 = $130 < $131;
                if (!($132)) { __label__ = 21; /* $157 */ break $129$25; }
                var $134 = $dest;
                var $135 = $134 - 1;
                var $136 = $j;
                var $137 = $135 - $136;
                var $138 = $2;
                var $139 = $138+12;
                var $140 = IHEAP[$139];
                var $141 = $140+4*$137;
                var $142 = IHEAP[$141];
                $d = $142;
                var $143 = $d;
                var $144 = $143 >> 0;
                var $145 = $144 & 63;
                var $146 = $145 == 34;
                if (!($146)) { __label__ = 23; /* $152 */ break $129$25; }
                var $148 = $d;
                var $149 = $148 >> 14;
                var $150 = $149 & 511;
                var $151 = $150 == 0;
                if (!($151)) { __label__ = 23; /* $152 */ break $129$25; }
                ;
                var $155 = $j;
                var $156 = $155 + 1;
                $j = $156;
                __label__ = 19; /* $129 */ continue $129$25;
              }
              if (__label__ == 23) {
                ;
              }
              var $158 = $j;
              var $159 = $158 & 1;
              var $160 = $159 == 0;
              if (!($160)) { __label__ = 28; /* $161 */ break $14$4; }
              ;
            }
            ;
          }
          ;
        }
        var $166 = $op;
        var $167 = _luaP_opmodes+$166;
        var $168 = IHEAP[$167];
        var $169 = $168;
        var $170 = $169 & 64;
        var $171 = $170 != 0;
        ;
        if ($171) {
          ;
          var $173 = $a;
          var $174 = $4;
          var $175 = $173 == $174;
          ;
          if ($175) {
            ;
            var $177 = $pc;
            $last = $177;
            ;
          }
          ;
        }
        var $180 = $op;
        var $181 = _luaP_opmodes+$180;
        var $182 = IHEAP[$181];
        var $183 = $182;
        var $184 = $183 & 128;
        var $185 = $184 != 0;
        ;
        if ($185) {
          ;
          var $187 = $pc;
          var $188 = $187 + 2;
          var $189 = $2;
          var $190 = $189+44;
          var $191 = IHEAP[$190];
          var $192 = $188 < $191;
          if (!($192)) { __label__ = 34; /* $193 */ break $14$4; }
          var $195 = $pc;
          var $196 = $195 + 1;
          var $197 = $2;
          var $198 = $197+12;
          var $199 = IHEAP[$198];
          var $200 = $199+4*$196;
          var $201 = IHEAP[$200];
          var $202 = $201 >> 0;
          var $203 = $202 & 63;
          var $204 = $203 == 22;
          if (!($204)) { __label__ = 36; /* $205 */ break $14$4; }
          ;
        }
        var $208 = $op;
        if ($208 == 2) {
          __label__ = 112; /* $209 */ 
        }
        else if ($208 == 3) {
          __label__ = 113; /* $245 */ 
        }
        else if ($208 == 4) {
          __label__ = 114; /* $256 */ 
        }
        else if ($208 == 8) {
          __label__ = 114; /* $256 */ 
        }
        else if ($208 == 5) {
          __label__ = 115; /* $265 */ 
        }
        else if ($208 == 7) {
          __label__ = 115; /* $265 */ 
        }
        else if ($208 == 11) {
          __label__ = 116; /* $276 */ 
        }
        else if ($208 == 21) {
          __label__ = 117; /* $293 */ 
        }
        else if ($208 == 33) {
          __label__ = 118; /* $299 */ 
        }
        else if ($208 == 31) {
          __label__ = 119; /* $322 */ 
        }
        else if ($208 == 32) {
          __label__ = 119; /* $322 */ 
        }
        else if ($208 == 22) {
          __label__ = 63; /* $332 */ 
        }
        else if ($208 == 28) {
          __label__ = 120; /* $352 */ 
        }
        else if ($208 == 29) {
          __label__ = 120; /* $352 */ 
        }
        else if ($208 == 30) {
          __label__ = 121; /* $407 */ 
        }
        else if ($208 == 34) {
          __label__ = 122; /* $425 */ 
        }
        else if ($208 == 36) {
          __label__ = 123; /* $454 */ 
        }
        else if ($208 == 37) {
          __label__ = 124; /* $513 */ 
        }
        else {
        __label__ = 125; /* $557 */ 
        }
        
        $557$209$245$256$265$276$293$299$322$332$352$407$425$454$513$49: do { 
          if (__label__ == 125) {
            __label__ = 43; /* $558 */ break $557$209$245$256$265$276$293$299$322$332$352$407$425$454$513$49;
          }
          else if (__label__ == 112) {
            var $210 = $c;
            var $211 = $210 == 1;
            ;
            if ($211) {
              ;
              var $213 = $pc;
              var $214 = $213 + 2;
              var $215 = $2;
              var $216 = $215+44;
              var $217 = IHEAP[$216];
              var $218 = $214 < $217;
              if (!($218)) { __label__ = 39; /* $219 */ break $14$4; }
              var $221 = $pc;
              var $222 = $221 + 1;
              var $223 = $2;
              var $224 = $223+12;
              var $225 = IHEAP[$224];
              var $226 = $225+4*$222;
              var $227 = IHEAP[$226];
              var $228 = $227 >> 0;
              var $229 = $228 & 63;
              var $230 = $229 != 34;
              ;
              if (!$230) {
                ;
                var $232 = $pc;
                var $233 = $232 + 1;
                var $234 = $2;
                var $235 = $234+12;
                var $236 = IHEAP[$235];
                var $237 = $236+4*$233;
                var $238 = IHEAP[$237];
                var $239 = $238 >> 14;
                var $240 = $239 & 511;
                var $241 = $240 != 0;
                if (!($241)) { __label__ = 41; /* $242 */ break $14$4; }
              }
              ;
            }
            __label__ = 43; /* $558 */ break $557$209$245$256$265$276$293$299$322$332$352$407$425$454$513$49;
          }
          else if (__label__ == 113) {
            var $246 = $a;
            var $247 = $4;
            var $248 = $246 <= $247;
            ;
            $249$255$60: do { 
              if ($248) {
                ;
                var $250 = $4;
                var $251 = $b;
                var $252 = $250 <= $251;
                if (!($252)) { __label__ = 45; /* $255 */ break $249$255$60; }
                var $254 = $pc;
                $last = $254;
                ;
              }
            } while(0);
            __label__ = 43; /* $558 */ break $557$209$245$256$265$276$293$299$322$332$352$407$425$454$513$49;
          }
          else if (__label__ == 114) {
            var $257 = $b;
            var $258 = $2;
            var $259 = $258+72;
            var $260 = IHEAP[$259];
            var $261 = $260;
            var $262 = $257 < $261;
            if (!($262)) { __label__ = 48; /* $263 */ break $14$4; }
            __label__ = 43; /* $558 */ break $557$209$245$256$265$276$293$299$322$332$352$407$425$454$513$49;
          }
          else if (__label__ == 115) {
            var $266 = $b;
            var $267 = $2;
            var $268 = $267+8;
            var $269 = IHEAP[$268];
            var $270 = $269+12*$266;
            var $271 = $270+8;
            var $272 = IHEAP[$271];
            var $273 = $272 == 4;
            if (!($273)) { __label__ = 50; /* $274 */ break $14$4; }
            __label__ = 43; /* $558 */ break $557$209$245$256$265$276$293$299$322$332$352$407$425$454$513$49;
          }
          else if (__label__ == 116) {
            var $277 = $a;
            var $278 = $277 + 1;
            var $279 = $2;
            var $280 = $279+75;
            var $281 = IHEAP[$280];
            var $282 = $281;
            var $283 = $278 < $282;
            if (!($283)) { __label__ = 52; /* $284 */ break $14$4; }
            var $286 = $4;
            var $287 = $a;
            var $288 = $287 + 1;
            var $289 = $286 == $288;
            ;
            if ($289) {
              ;
              var $291 = $pc;
              $last = $291;
              ;
            }
            __label__ = 43; /* $558 */ break $557$209$245$256$265$276$293$299$322$332$352$407$425$454$513$49;
          }
          else if (__label__ == 117) {
            var $294 = $b;
            var $295 = $c;
            var $296 = $294 < $295;
            if (!($296)) { __label__ = 55; /* $297 */ break $14$4; }
            __label__ = 43; /* $558 */ break $557$209$245$256$265$276$293$299$322$332$352$407$425$454$513$49;
          }
          else if (__label__ == 118) {
            var $300 = $c;
            var $301 = $300 >= 1;
            if (!($301)) { __label__ = 57; /* $302 */ break $14$4; }
            var $304 = $a;
            var $305 = $304 + 2;
            var $306 = $c;
            var $307 = $305 + $306;
            var $308 = $2;
            var $309 = $308+75;
            var $310 = IHEAP[$309];
            var $311 = $310;
            var $312 = $307 < $311;
            if (!($312)) { __label__ = 59; /* $313 */ break $14$4; }
            var $315 = $4;
            var $316 = $a;
            var $317 = $316 + 2;
            var $318 = $315 >= $317;
            ;
            if ($318) {
              ;
              var $320 = $pc;
              $last = $320;
              ;
            }
            __label__ = 43; /* $558 */ break $557$209$245$256$265$276$293$299$322$332$352$407$425$454$513$49;
          }
          else if (__label__ == 119) {
            var $323 = $a;
            var $324 = $323 + 3;
            var $325 = $2;
            var $326 = $325+75;
            var $327 = IHEAP[$326];
            var $328 = $327;
            var $329 = $324 < $328;
            if (!($329)) { __label__ = 62; /* $330 */ break $14$4; }
            __label__ = 63; /* $332 */ break $557$209$245$256$265$276$293$299$322$332$352$407$425$454$513$49;
          }
          else if (__label__ == 120) {
            var $353 = $b;
            var $354 = $353 != 0;
            ;
            if ($354) {
              ;
              var $356 = $a;
              var $357 = $b;
              var $358 = $356 + $357;
              var $359 = $358 - 1;
              var $360 = $2;
              var $361 = $360+75;
              var $362 = IHEAP[$361];
              var $363 = $362;
              var $364 = $359 < $363;
              if (!($364)) { __label__ = 70; /* $365 */ break $14$4; }
              ;
            }
            var $368 = $c;
            var $369 = $368 + -1;
            $c = $369;
            var $370 = $c;
            var $371 = $370 == -1;
            ;
            if ($371) {
              ;
              var $373 = $pc;
              var $374 = $373 + 1;
              var $375 = $2;
              var $376 = $375+12;
              var $377 = IHEAP[$376];
              var $378 = $377+4*$374;
              var $379 = IHEAP[$378];
              var $380 = __Z16luaG_checkopenopj($379);
              var $381 = $380 != 0;
              if (!($381)) { __label__ = 73; /* $382 */ break $14$4; }
              ;
            }
            else {
              ;
              var $385 = $c;
              var $386 = $385 != 0;
              ;
              if ($386) {
                ;
                var $388 = $a;
                var $389 = $c;
                var $390 = $388 + $389;
                var $391 = $390 - 1;
                var $392 = $2;
                var $393 = $392+75;
                var $394 = IHEAP[$393];
                var $395 = $394;
                var $396 = $391 < $395;
                if (!($396)) { __label__ = 76; /* $397 */ break $14$4; }
                ;
              }
              ;
            }
            var $401 = $4;
            var $402 = $a;
            var $403 = $401 >= $402;
            ;
            if ($403) {
              ;
              var $405 = $pc;
              $last = $405;
              ;
            }
            __label__ = 43; /* $558 */ break $557$209$245$256$265$276$293$299$322$332$352$407$425$454$513$49;
          }
          else if (__label__ == 121) {
            var $408 = $b;
            var $409 = $408 + -1;
            $b = $409;
            var $410 = $b;
            var $411 = $410 > 0;
            ;
            if ($411) {
              ;
              var $413 = $a;
              var $414 = $b;
              var $415 = $413 + $414;
              var $416 = $415 - 1;
              var $417 = $2;
              var $418 = $417+75;
              var $419 = IHEAP[$418];
              var $420 = $419;
              var $421 = $416 < $420;
              if (!($421)) { __label__ = 80; /* $422 */ break $14$4; }
              ;
            }
            __label__ = 43; /* $558 */ break $557$209$245$256$265$276$293$299$322$332$352$407$425$454$513$49;
          }
          else if (__label__ == 122) {
            var $426 = $b;
            var $427 = $426 > 0;
            ;
            if ($427) {
              ;
              var $429 = $a;
              var $430 = $b;
              var $431 = $429 + $430;
              var $432 = $2;
              var $433 = $432+75;
              var $434 = IHEAP[$433];
              var $435 = $434;
              var $436 = $431 < $435;
              if (!($436)) { __label__ = 83; /* $437 */ break $14$4; }
              ;
            }
            var $440 = $c;
            var $441 = $440 == 0;
            ;
            if ($441) {
              ;
              var $443 = $pc;
              var $444 = $443 + 1;
              $pc = $444;
              var $445 = $pc;
              var $446 = $2;
              var $447 = $446+44;
              var $448 = IHEAP[$447];
              var $449 = $448 - 1;
              var $450 = $445 < $449;
              if (!($450)) { __label__ = 86; /* $451 */ break $14$4; }
              ;
            }
            __label__ = 43; /* $558 */ break $557$209$245$256$265$276$293$299$322$332$352$407$425$454$513$49;
          }
          else if (__label__ == 123) {
            var $455 = $b;
            var $456 = $2;
            var $457 = $456+52;
            var $458 = IHEAP[$457];
            var $459 = $455 < $458;
            if (!($459)) { __label__ = 89; /* $460 */ break $14$4; }
            var $462 = $b;
            var $463 = $2;
            var $464 = $463+16;
            var $465 = IHEAP[$464];
            var $466 = $465+4*$462;
            var $467 = IHEAP[$466];
            var $468 = $467+72;
            var $469 = IHEAP[$468];
            var $470 = $469;
            $nup = $470;
            var $471 = $pc;
            var $472 = $nup;
            var $473 = $471 + $472;
            var $474 = $2;
            var $475 = $474+44;
            var $476 = IHEAP[$475];
            var $477 = $473 < $476;
            if (!($477)) { __label__ = 91; /* $478 */ break $14$4; }
            $j2 = 1;
            ;
            $480$117: while(1) { // $480
              var $481 = $j2;
              var $482 = $nup;
              var $483 = $481 <= $482;
              if (!($483)) { __label__ = 94; /* $505 */ break $480$117; }
              var $485 = $pc;
              var $486 = $j2;
              var $487 = $485 + $486;
              var $488 = $2;
              var $489 = $488+12;
              var $490 = IHEAP[$489];
              var $491 = $490+4*$487;
              var $492 = IHEAP[$491];
              var $493 = $492 >> 0;
              var $494 = $493 & 63;
              $op1 = $494;
              var $495 = $op1;
              var $496 = $495 == 4;
              ;
              if (!$496) {
                ;
                var $498 = $op1;
                var $499 = $498 == 0;
                if (!($499)) { __label__ = 96; /* $500 */ break $14$4; }
              }
              ;
              var $503 = $j2;
              var $504 = $503 + 1;
              $j2 = $504;
              __label__ = 92; /* $480 */ continue $480$117;
            }
            var $506 = $4;
            var $507 = $506 != 255;
            ;
            if ($507) {
              ;
              var $509 = $nup;
              var $510 = $pc;
              var $511 = $510 + $509;
              $pc = $511;
              ;
            }
            __label__ = 43; /* $558 */ break $557$209$245$256$265$276$293$299$322$332$352$407$425$454$513$49;
          }
          else if (__label__ == 124) {
            var $514 = $2;
            var $515 = $514+74;
            var $516 = IHEAP[$515];
            var $517 = $516;
            var $518 = $517 & 2;
            var $519 = $518 != 0;
            if (!($519)) { __label__ = 100; /* $527 */ break $14$4; }
            var $521 = $2;
            var $522 = $521+74;
            var $523 = IHEAP[$522];
            var $524 = $523;
            var $525 = $524 & 4;
            var $526 = $525 != 0;
            if ($526) { __label__ = 100; /* $527 */ break $14$4; }
            var $529 = $b;
            var $530 = $529 + -1;
            $b = $530;
            var $531 = $b;
            var $532 = $531 == -1;
            ;
            if ($532) {
              ;
              var $534 = $pc;
              var $535 = $534 + 1;
              var $536 = $2;
              var $537 = $536+12;
              var $538 = IHEAP[$537];
              var $539 = $538+4*$535;
              var $540 = IHEAP[$539];
              var $541 = __Z16luaG_checkopenopj($540);
              var $542 = $541 != 0;
              if (!($542)) { __label__ = 103; /* $543 */ break $14$4; }
              ;
            }
            var $546 = $a;
            var $547 = $b;
            var $548 = $546 + $547;
            var $549 = $548 - 1;
            var $550 = $2;
            var $551 = $550+75;
            var $552 = IHEAP[$551];
            var $553 = $552;
            var $554 = $549 < $553;
            if (!($554)) { __label__ = 106; /* $555 */ break $14$4; }
            __label__ = 43; /* $558 */ break $557$209$245$256$265$276$293$299$322$332$352$407$425$454$513$49;
          }
        } while(0);
        if (__label__ == 63) {
          var $333 = $pc;
          var $334 = $333 + 1;
          var $335 = $b;
          var $336 = $334 + $335;
          $dest1 = $336;
          var $337 = $4;
          var $338 = $337 != 255;
          ;
          $339$351$138: do { 
            if ($338) {
              ;
              var $340 = $pc;
              var $341 = $dest1;
              var $342 = $340 < $341;
              if (!($342)) { __label__ = 65; /* $351 */ break $339$351$138; }
              var $344 = $dest1;
              var $345 = $3;
              var $346 = $344 <= $345;
              if (!($346)) { __label__ = 65; /* $351 */ break $339$351$138; }
              var $348 = $b;
              var $349 = $pc;
              var $350 = $349 + $348;
              $pc = $350;
              ;
            }
          } while(0);
          ;
        }
        ;
        var $560 = $pc;
        var $561 = $560 + 1;
        $pc = $561;
        __label__ = 1; /* $14 */ continue $14$4;
      }
      if (__label__ == 3) {
        var $563 = $last;
        var $564 = $2;
        var $565 = $564+12;
        var $566 = IHEAP[$565];
        var $567 = $566+4*$563;
        var $568 = IHEAP[$567];
        $1 = $568;
        ;
      }
      else if (__label__ == 5) {
        $1 = 0;
        ;
      }
      else if (__label__ == 7) {
        $1 = 0;
        ;
      }
      else if (__label__ == 34) {
        $1 = 0;
        ;
      }
      else if (__label__ == 36) {
        $1 = 0;
        ;
      }
      else if (__label__ == 39) {
        $1 = 0;
        ;
      }
      else if (__label__ == 41) {
        $1 = 0;
        ;
      }
      else if (__label__ == 48) {
        $1 = 0;
        ;
      }
      else if (__label__ == 50) {
        $1 = 0;
        ;
      }
      else if (__label__ == 52) {
        $1 = 0;
        ;
      }
      else if (__label__ == 55) {
        $1 = 0;
        ;
      }
      else if (__label__ == 57) {
        $1 = 0;
        ;
      }
      else if (__label__ == 59) {
        $1 = 0;
        ;
      }
      else if (__label__ == 62) {
        $1 = 0;
        ;
      }
      else if (__label__ == 70) {
        $1 = 0;
        ;
      }
      else if (__label__ == 73) {
        $1 = 0;
        ;
      }
      else if (__label__ == 76) {
        $1 = 0;
        ;
      }
      else if (__label__ == 80) {
        $1 = 0;
        ;
      }
      else if (__label__ == 83) {
        $1 = 0;
        ;
      }
      else if (__label__ == 86) {
        $1 = 0;
        ;
      }
      else if (__label__ == 89) {
        $1 = 0;
        ;
      }
      else if (__label__ == 91) {
        $1 = 0;
        ;
      }
      else if (__label__ == 96) {
        $1 = 0;
        ;
      }
      else if (__label__ == 100) {
        $1 = 0;
        ;
      }
      else if (__label__ == 103) {
        $1 = 0;
        ;
      }
      else if (__label__ == 106) {
        $1 = 0;
        ;
      }
      else if (__label__ == 9) {
        $1 = 0;
        ;
      }
      else if (__label__ == 11) {
        $1 = 0;
        ;
      }
      else if (__label__ == 14) {
        $1 = 0;
        ;
      }
      else if (__label__ == 17) {
        $1 = 0;
        ;
      }
      else if (__label__ == 28) {
        $1 = 0;
        ;
      }
    }
    else {
      ;
      $1 = 0;
      ;
    }
    var $570 = $1;
    ;
    return $570;
  }
  __Z8symbexecPK5Protoii.__index__ = Runtime.getFunctionIndex(__Z8symbexecPK5Protoii, "__Z8symbexecPK5Protoii");
  
  
  function __Z14luaG_typeerrorP9lua_StatePK10lua_TValuePKc($L, $o, $op) {
    var __stackBase__  = STACKTOP; STACKTOP += 4; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $name = __stackBase__;
    var $t;
    var $kind;
    $1 = $L;
    $2 = $o;
    $3 = $op;
    IHEAP[$name] = 0;
    var $4 = $2;
    var $5 = $4+8;
    var $6 = IHEAP[$5];
    var $7 = _luaT_typenames+$6*4;
    var $8 = IHEAP[$7];
    $t = $8;
    var $9 = $1;
    var $10 = $9+20;
    var $11 = IHEAP[$10];
    var $12 = $2;
    var $13 = __Z9isinstackP8CallInfoPK10lua_TValue($11, $12);
    var $14 = $13 != 0;
    ;
    if ($14) {
      ;
      var $16 = $1;
      var $17 = $1;
      var $18 = $17+20;
      var $19 = IHEAP[$18];
      var $20 = $2;
      var $21 = $1;
      var $22 = $21+12;
      var $23 = IHEAP[$22];
      var $24 = $20;
      var $25 = $23;
      var $26 = $24 - $25;
      var $27 = Math.floor($26 / 12);
      var $28 = __Z10getobjnameP9lua_StateP8CallInfoiPPKc($16, $19, $27, $name);
      __lastLabel__ = 0; ;
    }
    else {
      ;
      __lastLabel__ = 2; ;
    }
    var $31 = __lastLabel__ == 0 ? $28 : (0);
    $kind = $31;
    var $32 = $kind;
    var $33 = $32 != 0;
    ;
    if ($33) {
      ;
      var $35 = $1;
      var $36 = $3;
      var $37 = $kind;
      var $38 = IHEAP[$name];
      var $39 = $t;
      __Z13luaG_runerrorP9lua_StatePKcz($35, __str835, Pointer_make([$36,0,0,0,$37,0,0,0,$38,0,0,0,$39,0,0,0], 0, ALLOC_STACK));
      ;
    }
    else {
      ;
      var $41 = $1;
      var $42 = $3;
      var $43 = $t;
      __Z13luaG_runerrorP9lua_StatePKcz($41, __str1936, Pointer_make([$42,0,0,0,$43,0,0,0], 0, ALLOC_STACK));
      ;
    }
    STACKTOP = __stackBase__;
    return;
  }
  __Z14luaG_typeerrorP9lua_StatePK10lua_TValuePKc.__index__ = Runtime.getFunctionIndex(__Z14luaG_typeerrorP9lua_StatePK10lua_TValuePKc, "__Z14luaG_typeerrorP9lua_StatePK10lua_TValuePKc");
  
  
  function __Z9isinstackP8CallInfoPK10lua_TValue($ci, $o) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $p;
    $2 = $ci;
    $3 = $o;
    var $4 = $2;
    var $5 = $4;
    var $6 = IHEAP[$5];
    $p = $6;
    ;
    $7$2: while(1) { // $7
      var $8 = $p;
      var $9 = $2;
      var $10 = $9+8;
      var $11 = IHEAP[$10];
      var $12 = $8 < $11;
      if (!($12)) { __label__ = 2; /* $22 */ break $7$2; }
      var $14 = $3;
      var $15 = $p;
      var $16 = $14 == $15;
      if ($16) { __label__ = 3; /* $17 */ break $7$2; }
      ;
      var $20 = $p;
      var $21 = $20+12;
      $p = $21;
      __label__ = 0; /* $7 */ continue $7$2;
    }
    if (__label__ == 2) {
      $1 = 0;
      ;
    }
    else if (__label__ == 3) {
      $1 = 1;
      ;
    }
    var $24 = $1;
    ;
    return $24;
  }
  __Z9isinstackP8CallInfoPK10lua_TValue.__index__ = Runtime.getFunctionIndex(__Z9isinstackP8CallInfoPK10lua_TValue, "__Z9isinstackP8CallInfoPK10lua_TValue");
  
  
  function __Z10getobjnameP9lua_StateP8CallInfoiPPKc($L, $ci, $stackpos, $name) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $4;
    var $5;
    var $p;
    var $pc;
    var $i;
    var $g;
    var $a;
    var $b;
    var $k;
    var $u;
    var $k1;
    $2 = $L;
    $3 = $ci;
    $4 = $stackpos;
    $5 = $name;
    var $6 = $3;
    var $7 = $6+4;
    var $8 = IHEAP[$7];
    var $9 = $8+8;
    var $10 = IHEAP[$9];
    var $11 = $10 == 6;
    ;
    $12$135$2: do { 
      if ($11) {
        ;
        var $13 = $3;
        var $14 = $13+4;
        var $15 = IHEAP[$14];
        var $16 = $15;
        var $17 = $16;
        var $18 = $17;
        var $19 = IHEAP[$18];
        var $20 = $19;
        var $21 = $20;
        var $22 = $21;
        var $23 = $22+6;
        var $24 = IHEAP[$23];
        var $25 = $24 != 0;
        if ($25) { __label__ = 0; /* $135 */ break $12$135$2; }
        var $27 = $3;
        var $28 = $27+4;
        var $29 = IHEAP[$28];
        var $30 = $29;
        var $31 = $30;
        var $32 = $31;
        var $33 = IHEAP[$32];
        var $34 = $33;
        var $35 = $34;
        var $36 = $35;
        var $37 = $36;
        var $38 = $37+16;
        var $39 = IHEAP[$38];
        $p = $39;
        var $40 = $2;
        var $41 = $3;
        var $42 = __Z9currentpcP9lua_StateP8CallInfo($40, $41);
        $pc = $42;
        var $43 = $p;
        var $44 = $4;
        var $45 = $44 + 1;
        var $46 = $pc;
        var $47 = __Z17luaF_getlocalnamePK5Protoii($43, $45, $46);
        var $48 = $5;
        IHEAP[$48] = $47;
        var $49 = $5;
        var $50 = IHEAP[$49];
        var $51 = $50 != 0;
        ;
        if ($51) {
          ;
          $1 = __str739;
          __label__ = 2; /* $136 */ break $12$135$2;
        }
        else {
          ;
          var $54 = $p;
          var $55 = $pc;
          var $56 = $4;
          var $57 = __Z8symbexecPK5Protoii($54, $55, $56);
          $i = $57;
          var $58 = $i;
          var $59 = $58 >> 0;
          var $60 = $59 & 63;
          if ($60 == 5) {
            __label__ = 8; /* $61 */ 
          }
          else if ($60 == 0) {
            __label__ = 9; /* $79 */ 
          }
          else if ($60 == 6) {
            __label__ = 10; /* $96 */ 
          }
          else if ($60 == 4) {
            __label__ = 11; /* $104 */ 
          }
          else if ($60 == 11) {
            __label__ = 12; /* $125 */ 
          }
          else {
          __label__ = 13; /* $133 */ 
          }
          
          if (__label__ == 13) {
            ;
          }
          else if (__label__ == 8) {
            var $62 = $i;
            var $63 = $62 >> 14;
            var $64 = $63 & 262143;
            $g = $64;
            var $65 = $g;
            var $66 = $p;
            var $67 = $66+8;
            var $68 = IHEAP[$67];
            var $69 = $68+12*$65;
            var $70 = $69;
            var $71 = $70;
            var $72 = $71;
            var $73 = IHEAP[$72];
            var $74 = $73;
            var $75 = $74;
            var $76 = $75+16;
            var $77 = $76;
            var $78 = $5;
            IHEAP[$78] = $77;
            $1 = __str813;
            __label__ = 2; /* $136 */ break $12$135$2;
          }
          else if (__label__ == 9) {
            var $80 = $i;
            var $81 = $80 >> 6;
            var $82 = $81 & 255;
            $a = $82;
            var $83 = $i;
            var $84 = $83 >> 23;
            var $85 = $84 & 511;
            $b = $85;
            var $86 = $b;
            var $87 = $a;
            var $88 = $86 < $87;
            ;
            if ($88) {
              ;
              var $90 = $2;
              var $91 = $3;
              var $92 = $b;
              var $93 = $5;
              var $94 = __Z10getobjnameP9lua_StateP8CallInfoiPPKc($90, $91, $92, $93);
              $1 = $94;
              __label__ = 2; /* $136 */ break $12$135$2;
            }
            else {
              ;
              ;
            }
          }
          else if (__label__ == 10) {
            var $97 = $i;
            var $98 = $97 >> 14;
            var $99 = $98 & 511;
            $k = $99;
            var $100 = $p;
            var $101 = $k;
            var $102 = __Z5knameP5Protoi($100, $101);
            var $103 = $5;
            IHEAP[$103] = $102;
            $1 = __str940;
            __label__ = 2; /* $136 */ break $12$135$2;
          }
          else if (__label__ == 11) {
            var $105 = $i;
            var $106 = $105 >> 23;
            var $107 = $106 & 511;
            $u = $107;
            var $108 = $p;
            var $109 = $108+28;
            var $110 = IHEAP[$109];
            var $111 = $110 != 0;
            ;
            if ($111) {
              ;
              var $113 = $u;
              var $114 = $p;
              var $115 = $114+28;
              var $116 = IHEAP[$115];
              var $117 = $116+4*$113;
              var $118 = IHEAP[$117];
              var $119 = $118+16;
              var $120 = $119;
              __lastLabel__ = 4; ;
            }
            else {
              ;
              __lastLabel__ = 6; ;
            }
            var $123 = __lastLabel__ == 4 ? $120 : (__str1041);
            var $124 = $5;
            IHEAP[$124] = $123;
            $1 = __str1142;
            __label__ = 2; /* $136 */ break $12$135$2;
          }
          else if (__label__ == 12) {
            var $126 = $i;
            var $127 = $126 >> 14;
            var $128 = $127 & 511;
            $k1 = $128;
            var $129 = $p;
            var $130 = $k1;
            var $131 = __Z5knameP5Protoi($129, $130);
            var $132 = $5;
            IHEAP[$132] = $131;
            $1 = __str1243;
            __label__ = 2; /* $136 */ break $12$135$2;
          }
          __label__ = 0; /* $135 */ break $12$135$2;
        }
      }
      else {
        __label__ = 0; /* $135 */ 
      }
    } while(0);
    if (__label__ == 0) {
      $1 = 0;
      ;
    }
    var $137 = $1;
    ;
    return $137;
  }
  __Z10getobjnameP9lua_StateP8CallInfoiPPKc.__index__ = Runtime.getFunctionIndex(__Z10getobjnameP9lua_StateP8CallInfoiPPKc, "__Z10getobjnameP9lua_StateP8CallInfoiPPKc");
  
  
  function __Z13luaG_runerrorP9lua_StatePKcz($L, $fmt) {
    var __stackBase__  = STACKTOP; STACKTOP += 4; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var __numArgs__ = 2;
    var $1;
    var $2;
    var $argp = __stackBase__;
    $1 = $L;
    $2 = $fmt;
    var $3 = $argp;
    IHEAP[$3] = arguments[__numArgs__];
    var $4 = $1;
    var $5 = $1;
    var $6 = $2;
    var $7 = IHEAP[$argp];
    var $8 = __Z17luaO_pushvfstringP9lua_StatePKcPc($5, $6, $7);
    __Z7addinfoP9lua_StatePKc($4, $8);
    var $9 = $argp;
    ;;
    var $10 = $1;
    __Z13luaG_errormsgP9lua_State($10);
    STACKTOP = __stackBase__;
    return;
  }
  __Z13luaG_runerrorP9lua_StatePKcz.__index__ = Runtime.getFunctionIndex(__Z13luaG_runerrorP9lua_StatePKcz, "__Z13luaG_runerrorP9lua_StatePKcz");
  
  
  function __Z16luaG_concaterrorP9lua_StateP10lua_TValueS2_($L, $p1, $p2) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    $1 = $L;
    $2 = $p1;
    $3 = $p2;
    var $4 = $2;
    var $5 = $4+8;
    var $6 = IHEAP[$5];
    var $7 = $6 == 4;
    ;
    $13$8$2: do { 
      if ($7) {
        __label__ = 0; /* $13 */ 
      }
      else {
        ;
        var $9 = $2;
        var $10 = $9+8;
        var $11 = IHEAP[$10];
        var $12 = $11 == 3;
        if ($12) { __label__ = 0; /* $13 */ break $13$8$2; } else { __label__ = 1; /* $15 */ break $13$8$2; }
      }
    } while(0);
    if (__label__ == 0) {
      var $14 = $3;
      $2 = $14;
      ;
    }
    var $16 = $1;
    var $17 = $2;
    __Z14luaG_typeerrorP9lua_StatePK10lua_TValuePKc($16, $17, __str210);
    ;
    return;
  }
  __Z16luaG_concaterrorP9lua_StateP10lua_TValueS2_.__index__ = Runtime.getFunctionIndex(__Z16luaG_concaterrorP9lua_StateP10lua_TValueS2_, "__Z16luaG_concaterrorP9lua_StateP10lua_TValueS2_");
  
  
  function __Z15luaG_aritherrorP9lua_StatePK10lua_TValueS3_($L, $p1, $p2) {
    var __stackBase__  = STACKTOP; STACKTOP += 12; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $temp = __stackBase__;
    $1 = $L;
    $2 = $p1;
    $3 = $p2;
    var $4 = $2;
    var $5 = __Z13luaV_tonumberPK10lua_TValuePS_($4, $temp);
    var $6 = $5 == 0;
    ;
    if ($6) {
      ;
      var $8 = $2;
      $3 = $8;
      ;
    }
    var $10 = $1;
    var $11 = $3;
    __Z14luaG_typeerrorP9lua_StatePK10lua_TValuePKc($10, $11, __str311);
    STACKTOP = __stackBase__;
    return;
  }
  __Z15luaG_aritherrorP9lua_StatePK10lua_TValueS3_.__index__ = Runtime.getFunctionIndex(__Z15luaG_aritherrorP9lua_StatePK10lua_TValueS3_, "__Z15luaG_aritherrorP9lua_StatePK10lua_TValueS3_");
  
  
  function __Z15luaG_ordererrorP9lua_StatePK10lua_TValueS3_($L, $p1, $p2) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $t1;
    var $t2;
    $1 = $L;
    $2 = $p1;
    $3 = $p2;
    var $4 = $2;
    var $5 = $4+8;
    var $6 = IHEAP[$5];
    var $7 = _luaT_typenames+$6*4;
    var $8 = IHEAP[$7];
    $t1 = $8;
    var $9 = $3;
    var $10 = $9+8;
    var $11 = IHEAP[$10];
    var $12 = _luaT_typenames+$11*4;
    var $13 = IHEAP[$12];
    $t2 = $13;
    var $14 = $t1;
    var $15 = $14+2;
    var $16 = IHEAP[$15];
    var $17 = $16;
    var $18 = $t2;
    var $19 = $18+2;
    var $20 = IHEAP[$19];
    var $21 = $20;
    var $22 = $17 == $21;
    ;
    if ($22) {
      ;
      var $24 = $1;
      var $25 = $t1;
      __Z13luaG_runerrorP9lua_StatePKcz($24, __str412, Pointer_make([$25,0,0,0], 0, ALLOC_STACK));
      ;
    }
    else {
      ;
      var $27 = $1;
      var $28 = $t1;
      var $29 = $t2;
      __Z13luaG_runerrorP9lua_StatePKcz($27, __str537, Pointer_make([$28,0,0,0,$29,0,0,0], 0, ALLOC_STACK));
      ;
    }
    ;
    return 0;
  }
  __Z15luaG_ordererrorP9lua_StatePK10lua_TValueS3_.__index__ = Runtime.getFunctionIndex(__Z15luaG_ordererrorP9lua_StatePK10lua_TValueS3_, "__Z15luaG_ordererrorP9lua_StatePK10lua_TValueS3_");
  
  
  function __Z13luaG_errormsgP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $errfunc;
    var $o2;
    var $o1;
    var $o21;
    var $o12;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+108;
    var $4 = IHEAP[$3];
    var $5 = $4 != 0;
    ;
    if ($5) {
      ;
      var $7 = $1;
      var $8 = $7+32;
      var $9 = IHEAP[$8];
      var $10 = $9;
      var $11 = $1;
      var $12 = $11+108;
      var $13 = IHEAP[$12];
      var $14 = $10+$13;
      var $15 = $14;
      $errfunc = $15;
      var $16 = $errfunc;
      var $17 = $16+8;
      var $18 = IHEAP[$17];
      var $19 = $18 == 6;
      ;
      if (!$19) {
        ;
        var $21 = $1;
        __Z10luaD_throwP9lua_Statei($21, 5);
        ;
      }
      var $23 = $1;
      var $24 = $23+8;
      var $25 = IHEAP[$24];
      var $26 = $25+-12;
      $o2 = $26;
      var $27 = $1;
      var $28 = $27+8;
      var $29 = IHEAP[$28];
      $o1 = $29;
      var $30 = $o1;
      var $31 = $30;
      var $32 = $o2;
      var $33 = $32;
      var $34 = $31;
      var $35 = $33;
      _llvm_memcpy_p0i8_p0i8_i32($34, $35, 8, 4, 0);
      var $36 = $o2;
      var $37 = $36+8;
      var $38 = IHEAP[$37];
      var $39 = $o1;
      var $40 = $39+8;
      IHEAP[$40] = $38;
      var $41 = $errfunc;
      $o21 = $41;
      var $42 = $1;
      var $43 = $42+8;
      var $44 = IHEAP[$43];
      var $45 = $44+-12;
      $o12 = $45;
      var $46 = $o12;
      var $47 = $46;
      var $48 = $o21;
      var $49 = $48;
      var $50 = $47;
      var $51 = $49;
      _llvm_memcpy_p0i8_p0i8_i32($50, $51, 8, 4, 0);
      var $52 = $o21;
      var $53 = $52+8;
      var $54 = IHEAP[$53];
      var $55 = $o12;
      var $56 = $55+8;
      IHEAP[$56] = $54;
      var $57 = $1;
      var $58 = $57+28;
      var $59 = IHEAP[$58];
      var $60 = $59;
      var $61 = $1;
      var $62 = $61+8;
      var $63 = IHEAP[$62];
      var $64 = $63;
      var $65 = $60;
      var $66 = $64;
      var $67 = $65 - $66;
      var $68 = $67 <= 12;
      ;
      if ($68) {
        ;
        var $70 = $1;
        __Z14luaD_growstackP9lua_Statei($70, 1);
        ;
      }
      else {
        ;
        ;
      }
      var $73 = $1;
      var $74 = $73+8;
      var $75 = IHEAP[$74];
      var $76 = $75+12;
      IHEAP[$74] = $76;
      var $77 = $1;
      var $78 = $1;
      var $79 = $78+8;
      var $80 = IHEAP[$79];
      var $81 = $80+-24;
      __Z9luaD_callP9lua_StateP10lua_TValuei($77, $81, 1);
      ;
    }
    var $83 = $1;
    __Z10luaD_throwP9lua_Statei($83, 2);
    ;
    return;
  }
  __Z13luaG_errormsgP9lua_State.__index__ = Runtime.getFunctionIndex(__Z13luaG_errormsgP9lua_State, "__Z13luaG_errormsgP9lua_State");
  
  
  function __Z7addinfoP9lua_StatePKc($L, $msg) {
    var __stackBase__  = STACKTOP; STACKTOP += 60; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $ci;
    var $buff = __stackBase__;
    var $line;
    $1 = $L;
    $2 = $msg;
    var $3 = $1;
    var $4 = $3+20;
    var $5 = IHEAP[$4];
    $ci = $5;
    var $6 = $ci;
    var $7 = $6+4;
    var $8 = IHEAP[$7];
    var $9 = $8+8;
    var $10 = IHEAP[$9];
    var $11 = $10 == 6;
    ;
    $12$42$2: do { 
      if ($11) {
        ;
        var $13 = $ci;
        var $14 = $13+4;
        var $15 = IHEAP[$14];
        var $16 = $15;
        var $17 = $16;
        var $18 = $17;
        var $19 = IHEAP[$18];
        var $20 = $19;
        var $21 = $20;
        var $22 = $21;
        var $23 = $22+6;
        var $24 = IHEAP[$23];
        var $25 = $24 != 0;
        if ($25) { __label__ = 0; /* $42 */ break $12$42$2; }
        var $27 = $1;
        var $28 = $ci;
        var $29 = __Z11currentlineP9lua_StateP8CallInfo($27, $28);
        $line = $29;
        var $30 = $buff;
        var $31 = $ci;
        var $32 = __Z11getluaprotoP8CallInfo($31);
        var $33 = $32+32;
        var $34 = IHEAP[$33];
        var $35 = $34+16;
        var $36 = $35;
        __Z12luaO_chunkidPcPKcj($30, $36, 60);
        var $37 = $1;
        var $38 = $buff;
        var $39 = $line;
        var $40 = $2;
        var $41 = __Z16luaO_pushfstringP9lua_StatePKcz($37, __str638, Pointer_make([$38,0,0,0,$39,0,0,0,$40,0,0,0], 0, ALLOC_STACK));
        ;
      }
    } while(0);
    STACKTOP = __stackBase__;
    return;
  }
  __Z7addinfoP9lua_StatePKc.__index__ = Runtime.getFunctionIndex(__Z7addinfoP9lua_StatePKc, "__Z7addinfoP9lua_StatePKc");
  
  
  function __Z11currentlineP9lua_StateP8CallInfo($L, $ci) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $pc;
    $2 = $L;
    $3 = $ci;
    var $4 = $2;
    var $5 = $3;
    var $6 = __Z9currentpcP9lua_StateP8CallInfo($4, $5);
    $pc = $6;
    var $7 = $pc;
    var $8 = $7 < 0;
    ;
    if ($8) {
      ;
      $1 = -1;
      ;
    }
    else {
      ;
      var $11 = $3;
      var $12 = $11+4;
      var $13 = IHEAP[$12];
      var $14 = $13;
      var $15 = $14;
      var $16 = $15;
      var $17 = IHEAP[$16];
      var $18 = $17;
      var $19 = $18;
      var $20 = $19;
      var $21 = $20;
      var $22 = $21+16;
      var $23 = IHEAP[$22];
      var $24 = $23+20;
      var $25 = IHEAP[$24];
      var $26 = $25 != 0;
      ;
      if ($26) {
        ;
        var $28 = $pc;
        var $29 = $3;
        var $30 = $29+4;
        var $31 = IHEAP[$30];
        var $32 = $31;
        var $33 = $32;
        var $34 = $33;
        var $35 = IHEAP[$34];
        var $36 = $35;
        var $37 = $36;
        var $38 = $37;
        var $39 = $38;
        var $40 = $39+16;
        var $41 = IHEAP[$40];
        var $42 = $41+20;
        var $43 = IHEAP[$42];
        var $44 = $43+4*$28;
        var $45 = IHEAP[$44];
        __lastLabel__ = 1; ;
      }
      else {
        ;
        __lastLabel__ = 3; ;
      }
      var $48 = __lastLabel__ == 1 ? $45 : (0);
      $1 = $48;
      ;
    }
    var $50 = $1;
    ;
    return $50;
  }
  __Z11currentlineP9lua_StateP8CallInfo.__index__ = Runtime.getFunctionIndex(__Z11currentlineP9lua_StateP8CallInfo, "__Z11currentlineP9lua_StateP8CallInfo");
  
  
  function __Z11getluaprotoP8CallInfo($ci) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    $1 = $ci;
    var $2 = $1;
    var $3 = $2+4;
    var $4 = IHEAP[$3];
    var $5 = $4+8;
    var $6 = IHEAP[$5];
    var $7 = $6 == 6;
    ;
    $8$36$2: do { 
      if ($7) {
        ;
        var $9 = $1;
        var $10 = $9+4;
        var $11 = IHEAP[$10];
        var $12 = $11;
        var $13 = $12;
        var $14 = $13;
        var $15 = IHEAP[$14];
        var $16 = $15;
        var $17 = $16;
        var $18 = $17;
        var $19 = $18+6;
        var $20 = IHEAP[$19];
        var $21 = $20 != 0;
        if ($21) { __label__ = 0; /* $36 */ break $8$36$2; }
        var $23 = $1;
        var $24 = $23+4;
        var $25 = IHEAP[$24];
        var $26 = $25;
        var $27 = $26;
        var $28 = $27;
        var $29 = IHEAP[$28];
        var $30 = $29;
        var $31 = $30;
        var $32 = $31;
        var $33 = $32;
        var $34 = $33+16;
        var $35 = IHEAP[$34];
        __lastLabel__ = 1; __label__ = 2; /* $37 */ break $8$36$2;
      }
      else {
        __label__ = 0; /* $36 */ 
      }
    } while(0);
    if (__label__ == 0) {
      __lastLabel__ = 0; ;
    }
    var $38 = __lastLabel__ == 1 ? $35 : (0);
    ;
    return $38;
  }
  __Z11getluaprotoP8CallInfo.__index__ = Runtime.getFunctionIndex(__Z11getluaprotoP8CallInfo, "__Z11getluaprotoP8CallInfo");
  
  
  function __Z9currentpcP9lua_StateP8CallInfo($L, $ci) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    $2 = $L;
    $3 = $ci;
    var $4 = $3;
    var $5 = $4+4;
    var $6 = IHEAP[$5];
    var $7 = $6+8;
    var $8 = IHEAP[$7];
    var $9 = $8 == 6;
    ;
    $10$24$2: do { 
      if ($9) {
        ;
        var $11 = $3;
        var $12 = $11+4;
        var $13 = IHEAP[$12];
        var $14 = $13;
        var $15 = $14;
        var $16 = $15;
        var $17 = IHEAP[$16];
        var $18 = $17;
        var $19 = $18;
        var $20 = $19;
        var $21 = $20+6;
        var $22 = IHEAP[$21];
        var $23 = $22 != 0;
        if ($23) { __label__ = 0; /* $24 */ break $10$24$2; }
        var $26 = $3;
        var $27 = $2;
        var $28 = $27+20;
        var $29 = IHEAP[$28];
        var $30 = $26 == $29;
        ;
        if ($30) {
          ;
          var $32 = $2;
          var $33 = $32+24;
          var $34 = IHEAP[$33];
          var $35 = $3;
          var $36 = $35+12;
          IHEAP[$36] = $34;
          ;
        }
        var $38 = $3;
        var $39 = $38+12;
        var $40 = IHEAP[$39];
        var $41 = $3;
        var $42 = $41+4;
        var $43 = IHEAP[$42];
        var $44 = $43;
        var $45 = $44;
        var $46 = $45;
        var $47 = IHEAP[$46];
        var $48 = $47;
        var $49 = $48;
        var $50 = $49;
        var $51 = $50;
        var $52 = $51+16;
        var $53 = IHEAP[$52];
        var $54 = $53+12;
        var $55 = IHEAP[$54];
        var $56 = $40;
        var $57 = $55;
        var $58 = $56 - $57;
        var $59 = Math.floor($58 / 4);
        var $60 = $59 - 1;
        $1 = $60;
        __label__ = 4; /* $61 */ break $10$24$2;
      }
      else {
        __label__ = 0; /* $24 */ 
      }
    } while(0);
    if (__label__ == 0) {
      $1 = -1;
      ;
    }
    var $62 = $1;
    ;
    return $62;
  }
  __Z9currentpcP9lua_StateP8CallInfo.__index__ = Runtime.getFunctionIndex(__Z9currentpcP9lua_StateP8CallInfo, "__Z9currentpcP9lua_StateP8CallInfo");
  
  
  function __Z5knameP5Protoi($p, $c) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    $2 = $p;
    $3 = $c;
    var $4 = $3;
    var $5 = $4 & 256;
    var $6 = $5 != 0;
    ;
    $7$32$2: do { 
      if ($6) {
        ;
        var $8 = $3;
        var $9 = $8 & -257;
        var $10 = $2;
        var $11 = $10+8;
        var $12 = IHEAP[$11];
        var $13 = $12+12*$9;
        var $14 = $13+8;
        var $15 = IHEAP[$14];
        var $16 = $15 == 4;
        if (!($16)) { __label__ = 1; /* $32 */ break $7$32$2; }
        var $18 = $3;
        var $19 = $18 & -257;
        var $20 = $2;
        var $21 = $20+8;
        var $22 = IHEAP[$21];
        var $23 = $22+12*$19;
        var $24 = $23;
        var $25 = $24;
        var $26 = $25;
        var $27 = IHEAP[$26];
        var $28 = $27;
        var $29 = $28;
        var $30 = $29+16;
        var $31 = $30;
        $1 = $31;
        __label__ = 2; /* $33 */ break $7$32$2;
      }
      else {
        __label__ = 1; /* $32 */ 
      }
    } while(0);
    if (__label__ == 1) {
      $1 = __str1041;
      ;
    }
    var $34 = $1;
    ;
    return $34;
  }
  __Z5knameP5Protoi.__index__ = Runtime.getFunctionIndex(__Z5knameP5Protoi, "__Z5knameP5Protoi");
  
  
  function __Z8precheckPK5Proto($pt) {
    ;
    var __label__;
    var $1;
    var $2;
    $2 = $pt;
    var $3 = $2;
    var $4 = $3+75;
    var $5 = IHEAP[$4];
    var $6 = $5;
    var $7 = $6 <= 250;
    ;
    $9$8$2: do { 
      if ($7) {
        ;
        var $10 = $2;
        var $11 = $10+73;
        var $12 = IHEAP[$11];
        var $13 = $12;
        var $14 = $2;
        var $15 = $14+74;
        var $16 = IHEAP[$15];
        var $17 = $16;
        var $18 = $17 & 1;
        var $19 = $13 + $18;
        var $20 = $2;
        var $21 = $20+75;
        var $22 = IHEAP[$21];
        var $23 = $22;
        var $24 = $19 <= $23;
        ;
        if ($24) {
          ;
          var $27 = $2;
          var $28 = $27+74;
          var $29 = IHEAP[$28];
          var $30 = $29;
          var $31 = $30 & 4;
          var $32 = $31 != 0;
          ;
          $33$41$6: do { 
            if ($32) {
              ;
              var $34 = $2;
              var $35 = $34+74;
              var $36 = IHEAP[$35];
              var $37 = $36;
              var $38 = $37 & 1;
              var $39 = $38 != 0;
              if ($39) { __label__ = 1; /* $41 */ break $33$41$6; }
              $1 = 0;
              __label__ = 3; /* $85 */ break $9$8$2;
            }
          } while(0);
          var $42 = $2;
          var $43 = $42+36;
          var $44 = IHEAP[$43];
          var $45 = $2;
          var $46 = $45+72;
          var $47 = IHEAP[$46];
          var $48 = $47;
          var $49 = $44 <= $48;
          ;
          if ($49) {
            ;
            var $52 = $2;
            var $53 = $52+48;
            var $54 = IHEAP[$53];
            var $55 = $2;
            var $56 = $55+44;
            var $57 = IHEAP[$56];
            var $58 = $54 == $57;
            ;
            $65$59$12: do { 
              if (!$58) {
                ;
                var $60 = $2;
                var $61 = $60+48;
                var $62 = IHEAP[$61];
                var $63 = $62 == 0;
                if ($63) { __label__ = 4; /* $65 */ break $65$59$12; }
                $1 = 0;
                __label__ = 3; /* $85 */ break $9$8$2;
              }
            } while(0);
            var $66 = $2;
            var $67 = $66+44;
            var $68 = IHEAP[$67];
            var $69 = $68 > 0;
            ;
            $70$83$16: do { 
              if ($69) {
                ;
                var $71 = $2;
                var $72 = $71+44;
                var $73 = IHEAP[$72];
                var $74 = $73 - 1;
                var $75 = $2;
                var $76 = $75+12;
                var $77 = IHEAP[$76];
                var $78 = $77+4*$74;
                var $79 = IHEAP[$78];
                var $80 = $79 >> 0;
                var $81 = $80 & 63;
                var $82 = $81 == 30;
                if (!($82)) { __label__ = 7; /* $83 */ break $70$83$16; }
                $1 = 1;
                __label__ = 3; /* $85 */ break $9$8$2;
              }
            } while(0);
            $1 = 0;
            ;
          }
          else {
            ;
            $1 = 0;
            ;
          }
        }
        else {
          ;
          $1 = 0;
          ;
        }
      }
      else {
        ;
        $1 = 0;
        ;
      }
    } while(0);
    var $86 = $1;
    ;
    return $86;
  }
  __Z8precheckPK5Proto.__index__ = Runtime.getFunctionIndex(__Z8precheckPK5Proto, "__Z8precheckPK5Proto");
  
  
  function __Z12checkArgModePK5Protoi9OpArgMask($pt, $r, $mode) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    $2 = $pt;
    $3 = $r;
    $4 = $mode;
    var $5 = $4;
    if ($5 == 0) {
      __label__ = 5; /* $6 */ 
    }
    else if ($5 == 1) {
      __label__ = 6; /* $11 */ 
    }
    else if ($5 == 2) {
      __label__ = 7; /* $12 */ 
    }
    else if ($5 == 3) {
      __label__ = 8; /* $21 */ 
    }
    else {
    __label__ = 1; /* $41 */ 
    }
    
    $41$6$11$12$21$2: do { 
      if (__label__ == 5) {
        var $7 = $3;
        var $8 = $7 == 0;
        ;
        if ($8) {
          ;
          __label__ = 1; /* $41 */ break $41$6$11$12$21$2;
        }
        else {
          ;
          $1 = 0;
          __label__ = 0; /* $42 */ break $41$6$11$12$21$2;
        }
      }
      else if (__label__ == 6) {
        __label__ = 1; /* $41 */ break $41$6$11$12$21$2;
      }
      else if (__label__ == 7) {
        var $13 = $3;
        var $14 = $2;
        var $15 = $14+75;
        var $16 = IHEAP[$15];
        var $17 = $16;
        var $18 = $13 < $17;
        ;
        if ($18) {
          ;
          __label__ = 1; /* $41 */ break $41$6$11$12$21$2;
        }
        else {
          ;
          $1 = 0;
          __label__ = 0; /* $42 */ break $41$6$11$12$21$2;
        }
      }
      else if (__label__ == 8) {
        var $22 = $3;
        var $23 = $22 & 256;
        var $24 = $23 != 0;
        ;
        $25$32$13: do { 
          if ($24) {
            ;
            var $26 = $3;
            var $27 = $26 & -257;
            var $28 = $2;
            var $29 = $28+40;
            var $30 = IHEAP[$29];
            var $31 = $27 < $30;
            if ($31) { __label__ = 2; /* $40 */ break $25$32$13; } else { __label__ = 3; /* $39 */ break $25$32$13; }
          }
          else {
            ;
            var $33 = $3;
            var $34 = $2;
            var $35 = $34+75;
            var $36 = IHEAP[$35];
            var $37 = $36;
            var $38 = $33 < $37;
            if ($38) { __label__ = 2; /* $40 */ break $25$32$13; } else { __label__ = 3; /* $39 */ break $25$32$13; }
          }
        } while(0);
        if (__label__ == 2) {
          __label__ = 1; /* $41 */ break $41$6$11$12$21$2;
        }
        else if (__label__ == 3) {
          $1 = 0;
          __label__ = 0; /* $42 */ break $41$6$11$12$21$2;
        }
      }
    } while(0);
    if (__label__ == 1) {
      $1 = 1;
      ;
    }
    var $43 = $1;
    ;
    return $43;
  }
  __Z12checkArgModePK5Protoi9OpArgMask.__index__ = Runtime.getFunctionIndex(__Z12checkArgModePK5Protoi9OpArgMask, "__Z12checkArgModePK5Protoi9OpArgMask");
  
  
  function __Z13info_tailcallP9lua_Debug($ar) {
    ;
    var __label__;
    var $1;
    $1 = $ar;
    var $2 = $1;
    var $3 = $2+8;
    IHEAP[$3] = __str1344;
    var $4 = $1;
    var $5 = $4+4;
    IHEAP[$5] = __str1344;
    var $6 = $1;
    var $7 = $6+12;
    IHEAP[$7] = __str1848;
    var $8 = $1;
    var $9 = $8+20;
    IHEAP[$9] = -1;
    var $10 = $1;
    var $11 = $10+28;
    IHEAP[$11] = -1;
    var $12 = $1;
    var $13 = $12+32;
    IHEAP[$13] = -1;
    var $14 = $1;
    var $15 = $14+16;
    IHEAP[$15] = __str1915;
    var $16 = $1;
    var $17 = $16+36;
    var $18 = $17;
    var $19 = $1;
    var $20 = $19+16;
    var $21 = IHEAP[$20];
    __Z12luaO_chunkidPcPKcj($18, $21, 60);
    var $22 = $1;
    var $23 = $22+24;
    IHEAP[$23] = 0;
    ;
    return;
  }
  __Z13info_tailcallP9lua_Debug.__index__ = Runtime.getFunctionIndex(__Z13info_tailcallP9lua_Debug, "__Z13info_tailcallP9lua_Debug");
  
  
  function __Z8funcinfoP9lua_DebugP7Closure($ar, $cl) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    $1 = $ar;
    $2 = $cl;
    var $3 = $2;
    var $4 = $3;
    var $5 = $4+6;
    var $6 = IHEAP[$5];
    var $7 = $6 != 0;
    ;
    if ($7) {
      ;
      var $9 = $1;
      var $10 = $9+16;
      IHEAP[$10] = __str1445;
      var $11 = $1;
      var $12 = $11+28;
      IHEAP[$12] = -1;
      var $13 = $1;
      var $14 = $13+32;
      IHEAP[$14] = -1;
      var $15 = $1;
      var $16 = $15+12;
      IHEAP[$16] = __str1514;
      ;
    }
    else {
      ;
      var $18 = $2;
      var $19 = $18;
      var $20 = $19;
      var $21 = $20+16;
      var $22 = IHEAP[$21];
      var $23 = $22+32;
      var $24 = IHEAP[$23];
      var $25 = $24+16;
      var $26 = $25;
      var $27 = $1;
      var $28 = $27+16;
      IHEAP[$28] = $26;
      var $29 = $2;
      var $30 = $29;
      var $31 = $30;
      var $32 = $31+16;
      var $33 = IHEAP[$32];
      var $34 = $33+60;
      var $35 = IHEAP[$34];
      var $36 = $1;
      var $37 = $36+28;
      IHEAP[$37] = $35;
      var $38 = $2;
      var $39 = $38;
      var $40 = $39;
      var $41 = $40+16;
      var $42 = IHEAP[$41];
      var $43 = $42+64;
      var $44 = IHEAP[$43];
      var $45 = $1;
      var $46 = $45+32;
      IHEAP[$46] = $44;
      var $47 = $1;
      var $48 = $47+28;
      var $49 = IHEAP[$48];
      var $50 = $49 == 0;
      ;
      if ($50) {
        ;
        __lastLabel__ = 1; ;
      }
      else {
        ;
        __lastLabel__ = 3; ;
      }
      var $54 = __lastLabel__ == 1 ? __str1646 : (__str1747);
      var $55 = $1;
      var $56 = $55+12;
      IHEAP[$56] = $54;
      ;
    }
    var $58 = $1;
    var $59 = $58+36;
    var $60 = $59;
    var $61 = $1;
    var $62 = $61+16;
    var $63 = IHEAP[$62];
    __Z12luaO_chunkidPcPKcj($60, $63, 60);
    ;
    return;
  }
  __Z8funcinfoP9lua_DebugP7Closure.__index__ = Runtime.getFunctionIndex(__Z8funcinfoP9lua_DebugP7Closure, "__Z8funcinfoP9lua_DebugP7Closure");
  
  
  function __Z11getfuncnameP9lua_StateP8CallInfoPPKc($L, $ci, $name) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $i;
    $2 = $L;
    $3 = $ci;
    $4 = $name;
    var $5 = $3;
    var $6 = $5+4;
    var $7 = IHEAP[$6];
    var $8 = $7+8;
    var $9 = IHEAP[$8];
    var $10 = $9 == 6;
    ;
    $11$30$2: do { 
      if ($10) {
        ;
        var $12 = $3;
        var $13 = $12+4;
        var $14 = IHEAP[$13];
        var $15 = $14;
        var $16 = $15;
        var $17 = $16;
        var $18 = IHEAP[$17];
        var $19 = $18;
        var $20 = $19;
        var $21 = $20;
        var $22 = $21+6;
        var $23 = IHEAP[$22];
        var $24 = $23 != 0;
        if ($24) { __label__ = 0; /* $30 */ break $11$30$2; }
        var $26 = $3;
        var $27 = $26+20;
        var $28 = IHEAP[$27];
        var $29 = $28 > 0;
        if ($29) { __label__ = 2; /* $53 */ break $11$30$2; } else { __label__ = 0; /* $30 */ break $11$30$2; }
      }
      else {
        __label__ = 0; /* $30 */ 
      }
    } while(0);
    $30$53$5: do { 
      if (__label__ == 0) {
        var $31 = $3;
        var $32 = $31+-24;
        var $33 = $32+4;
        var $34 = IHEAP[$33];
        var $35 = $34+8;
        var $36 = IHEAP[$35];
        var $37 = $36 == 6;
        if (!($37)) { __label__ = 2; /* $53 */ break $30$53$5; }
        var $39 = $3;
        var $40 = $39+-24;
        var $41 = $40+4;
        var $42 = IHEAP[$41];
        var $43 = $42;
        var $44 = $43;
        var $45 = $44;
        var $46 = IHEAP[$45];
        var $47 = $46;
        var $48 = $47;
        var $49 = $48;
        var $50 = $49+6;
        var $51 = IHEAP[$50];
        var $52 = $51 != 0;
        if ($52) { __label__ = 2; /* $53 */ break $30$53$5; }
        var $55 = $3;
        var $56 = $55+-24;
        $3 = $56;
        var $57 = $2;
        var $58 = $3;
        var $59 = __Z9currentpcP9lua_StateP8CallInfo($57, $58);
        var $60 = $3;
        var $61 = $60+4;
        var $62 = IHEAP[$61];
        var $63 = $62;
        var $64 = $63;
        var $65 = $64;
        var $66 = IHEAP[$65];
        var $67 = $66;
        var $68 = $67;
        var $69 = $68;
        var $70 = $69;
        var $71 = $70+16;
        var $72 = IHEAP[$71];
        var $73 = $72+12;
        var $74 = IHEAP[$73];
        var $75 = $74+4*$59;
        var $76 = IHEAP[$75];
        $i = $76;
        var $77 = $i;
        var $78 = $77 >> 0;
        var $79 = $78 & 63;
        var $80 = $79 == 28;
        ;
        $91$81$9: do { 
          if (!$80) {
            ;
            var $82 = $i;
            var $83 = $82 >> 0;
            var $84 = $83 & 63;
            var $85 = $84 == 29;
            if ($85) { __label__ = 6; /* $91 */ break $91$81$9; }
            var $87 = $i;
            var $88 = $87 >> 0;
            var $89 = $88 & 63;
            var $90 = $89 == 33;
            if ($90) { __label__ = 6; /* $91 */ break $91$81$9; }
            $1 = 0;
            __label__ = 9; /* $100 */ break $30$53$5;
          }
        } while(0);
        var $92 = $2;
        var $93 = $3;
        var $94 = $i;
        var $95 = $94 >> 6;
        var $96 = $95 & 255;
        var $97 = $4;
        var $98 = __Z10getobjnameP9lua_StateP8CallInfoiPPKc($92, $93, $96, $97);
        $1 = $98;
        __label__ = 9; /* $100 */ break $30$53$5;
      }
    } while(0);
    if (__label__ == 2) {
      $1 = 0;
      ;
    }
    var $101 = $1;
    ;
    return $101;
  }
  __Z11getfuncnameP9lua_StateP8CallInfoPPKc.__index__ = Runtime.getFunctionIndex(__Z11getfuncnameP9lua_StateP8CallInfoPPKc, "__Z11getfuncnameP9lua_StateP8CallInfoPPKc");
  
  
  function __Z16luaD_seterrorobjP9lua_StateiP10lua_TValue($L, $errcode, $oldtop) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $i_o;
    var $i_o1;
    var $o2;
    var $o1;
    $1 = $L;
    $2 = $errcode;
    $3 = $oldtop;
    var $4 = $2;
    if ($4 == 4) {
      __label__ = 1; /* $5 */ 
    }
    else if ($4 == 5) {
      __label__ = 2; /* $16 */ 
    }
    else if ($4 == 3) {
      __label__ = 3; /* $27 */ 
    }
    else if ($4 == 2) {
      __label__ = 3; /* $27 */ 
    }
    else {
    __label__ = 4; /* $44 */ 
    }
    
    if (__label__ == 1) {
      var $6 = $3;
      $i_o = $6;
      var $7 = $1;
      var $8 = __Z12luaS_newlstrP9lua_StatePKcj($7, __str2150, 17);
      var $9 = $8;
      var $10 = $i_o;
      var $11 = $10;
      var $12 = $11;
      var $13 = $12;
      IHEAP[$13] = $9;
      var $14 = $i_o;
      var $15 = $14+8;
      IHEAP[$15] = 4;
      ;
    }
    else if (__label__ == 2) {
      var $17 = $3;
      $i_o1 = $17;
      var $18 = $1;
      var $19 = __Z12luaS_newlstrP9lua_StatePKcj($18, __str122, 23);
      var $20 = $19;
      var $21 = $i_o1;
      var $22 = $21;
      var $23 = $22;
      var $24 = $23;
      IHEAP[$24] = $20;
      var $25 = $i_o1;
      var $26 = $25+8;
      IHEAP[$26] = 4;
      ;
    }
    else if (__label__ == 3) {
      var $28 = $1;
      var $29 = $28+8;
      var $30 = IHEAP[$29];
      var $31 = $30+-12;
      $o2 = $31;
      var $32 = $3;
      $o1 = $32;
      var $33 = $o1;
      var $34 = $33;
      var $35 = $o2;
      var $36 = $35;
      var $37 = $34;
      var $38 = $36;
      _llvm_memcpy_p0i8_p0i8_i32($37, $38, 8, 4, 0);
      var $39 = $o2;
      var $40 = $39+8;
      var $41 = IHEAP[$40];
      var $42 = $o1;
      var $43 = $42+8;
      IHEAP[$43] = $41;
      ;
    }
    var $45 = $3;
    var $46 = $45+12;
    var $47 = $1;
    var $48 = $47+8;
    IHEAP[$48] = $46;
    ;
    return;
  }
  __Z16luaD_seterrorobjP9lua_StateiP10lua_TValue.__index__ = Runtime.getFunctionIndex(__Z16luaD_seterrorobjP9lua_StateiP10lua_TValue, "__Z16luaD_seterrorobjP9lua_StateiP10lua_TValue");
  
  
  function __Z10luaD_throwP9lua_Statei($L, $errcode) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    $3 = 0;
    $1 = $L;
    $2 = $errcode;
    var $5 = $1;
    var $6 = $5+104;
    var $7 = IHEAP[$6];
    var $8 = $7 != 0;
    ;
    if ($8) {
      ;
      var $10 = $2;
      var $11 = $1;
      var $12 = $11+104;
      var $13 = IHEAP[$12];
      var $14 = $13+8;
      IHEAP[$14] = $10;
      var $15 = ___cxa_allocate_exception(4);
      $4 = $15;
      $3 = 1;
      var $16 = $15;
      var $17 = $1;
      var $18 = $17+104;
      var $19 = IHEAP[$18];
      IHEAP[$16] = $19;
      $3 = 0;
      ___cxa_throw($15, __ZTIP11lua_longjmp, 0);
      throw "Reached an unreachable! Original .ll line: 13652";
    }
    else {
      ;
      var $21 = $2;
      var $22 = $21;
      var $23 = $1;
      var $24 = $23+6;
      IHEAP[$24] = $22;
      var $25 = $1;
      var $26 = $25+16;
      var $27 = IHEAP[$26];
      var $28 = $27+88;
      var $29 = IHEAP[$28];
      var $30 = $29 != 0;
      ;
      if ($30) {
        ;
        var $32 = $1;
        var $33 = $2;
        __Z10resetstackP9lua_Statei($32, $33);
        var $34 = $1;
        var $35 = $34+16;
        var $36 = IHEAP[$35];
        var $37 = $36+88;
        var $38 = IHEAP[$37];
        var $39 = $1;
        var $40 = FUNCTION_TABLE[$38]($39);
        ;
      }
      _exit(1);
      throw "Reached an unreachable! Original .ll line: 13683";
      ;
      return;
    }
  }
  __Z10luaD_throwP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z10luaD_throwP9lua_Statei, "__Z10luaD_throwP9lua_Statei");
  
  
  function __Z10resetstackP9lua_Statei($L, $status) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $L;
    $2 = $status;
    var $3 = $1;
    var $4 = $3+40;
    var $5 = IHEAP[$4];
    var $6 = $1;
    var $7 = $6+20;
    IHEAP[$7] = $5;
    var $8 = $1;
    var $9 = $8+20;
    var $10 = IHEAP[$9];
    var $11 = $10;
    var $12 = IHEAP[$11];
    var $13 = $1;
    var $14 = $13+12;
    IHEAP[$14] = $12;
    var $15 = $1;
    var $16 = $1;
    var $17 = $16+12;
    var $18 = IHEAP[$17];
    __Z10luaF_closeP9lua_StateP10lua_TValue($15, $18);
    var $19 = $1;
    var $20 = $2;
    var $21 = $1;
    var $22 = $21+12;
    var $23 = IHEAP[$22];
    __Z16luaD_seterrorobjP9lua_StateiP10lua_TValue($19, $20, $23);
    var $24 = $1;
    var $25 = $24+54;
    var $26 = IHEAP[$25];
    var $27 = $1;
    var $28 = $27+52;
    IHEAP[$28] = $26;
    var $29 = $1;
    var $30 = $29+57;
    IHEAP[$30] = 1;
    var $31 = $1;
    __Z19restore_stack_limitP9lua_State($31);
    var $32 = $1;
    var $33 = $32+108;
    IHEAP[$33] = 0;
    var $34 = $1;
    var $35 = $34+104;
    IHEAP[$35] = 0;
    ;
    return;
  }
  __Z10resetstackP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z10resetstackP9lua_Statei, "__Z10resetstackP9lua_Statei");
  
  
  function __Z20luaD_rawrunprotectedP9lua_StatePFvS0_PvES1_($L, $f, $ud) {
    var __stackBase__  = STACKTOP; STACKTOP += 12; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $lj = __stackBase__;
    var $4;
    $1 = $L;
    $2 = $f;
    $3 = $ud;
    var $5 = $lj+8;
    IHEAP[$5] = 0;
    var $6 = $1;
    var $7 = $6+104;
    var $8 = IHEAP[$7];
    var $9 = $lj;
    IHEAP[$9] = $8;
    var $10 = $1;
    var $11 = $10+104;
    IHEAP[$11] = $lj;
    var $12 = $2;
    var $13 = $1;
    var $14 = $3;
    (function() { try { __THREW__ = false; return FUNCTION_TABLE[$12]($13, $14) } catch(e) { if (ABORT) throw e; __THREW__ = true; } })(); if (!__THREW__) { __label__ = 3; /* $15 */  } else { __label__ = 4; /* $24 */  }
    if (__label__ == 3) {
      ;
    }
    else if (__label__ == 4) {
      var $25 = _llvm_eh_exception();
      $4 = $25;
      var $26 = _llvm_eh_selector($25, ___gxx_personality_v0, 0);
      ;
      var $17 = $4;
      var $18 = ___cxa_begin_catch($17);
      var $19 = $lj+8;
      var $20 = IHEAP[$19];
      var $21 = $20 == 0;
      ;
      if ($21) {
        ;
        var $23 = $lj+8;
        IHEAP[$23] = -1;
        ;
      }
      ___cxa_end_catch();
      ;
    }
    var $29 = $lj;
    var $30 = IHEAP[$29];
    var $31 = $1;
    var $32 = $31+104;
    IHEAP[$32] = $30;
    var $33 = $lj+8;
    var $34 = IHEAP[$33];
    STACKTOP = __stackBase__;
    return $34;
  }
  __Z20luaD_rawrunprotectedP9lua_StatePFvS0_PvES1_.__index__ = Runtime.getFunctionIndex(__Z20luaD_rawrunprotectedP9lua_StatePFvS0_PvES1_, "__Z20luaD_rawrunprotectedP9lua_StatePFvS0_PvES1_");
  
  
  function __Z17luaD_reallocstackP9lua_Statei($L, $newsize) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $oldstack;
    var $realsize;
    $1 = $L;
    $2 = $newsize;
    var $3 = $1;
    var $4 = $3+32;
    var $5 = IHEAP[$4];
    $oldstack = $5;
    var $6 = $2;
    var $7 = $6 + 1;
    var $8 = $7 + 5;
    $realsize = $8;
    var $9 = $realsize;
    var $10 = $9 + 1;
    var $11 = unSign($10, 32) <= unSign(357913941, 32);
    ;
    if ($11) {
      ;
      var $13 = $1;
      var $14 = $1;
      var $15 = $14+32;
      var $16 = IHEAP[$15];
      var $17 = $16;
      var $18 = $1;
      var $19 = $18+44;
      var $20 = IHEAP[$19];
      var $21 = $20 * 12;
      var $22 = $realsize;
      var $23 = $22 * 12;
      var $24 = __Z13luaM_realloc_P9lua_StatePvjj($13, $17, $21, $23);
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $26 = $1;
      var $27 = __Z11luaM_toobigP9lua_State($26);
      __lastLabel__ = 2; ;
    }
    var $29 = __lastLabel__ == 0 ? $24 : ($27);
    var $30 = $29;
    var $31 = $1;
    var $32 = $31+32;
    IHEAP[$32] = $30;
    var $33 = $realsize;
    var $34 = $1;
    var $35 = $34+44;
    IHEAP[$35] = $33;
    var $36 = $1;
    var $37 = $36+32;
    var $38 = IHEAP[$37];
    var $39 = $2;
    var $40 = $38+12*$39;
    var $41 = $1;
    var $42 = $41+28;
    IHEAP[$42] = $40;
    var $43 = $1;
    var $44 = $oldstack;
    __Z12correctstackP9lua_StateP10lua_TValue($43, $44);
    ;
    return;
  }
  __Z17luaD_reallocstackP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z17luaD_reallocstackP9lua_Statei, "__Z17luaD_reallocstackP9lua_Statei");
  
  
  function __Z12correctstackP9lua_StateP10lua_TValue($L, $oldstack) {
    ;
    var __label__;
    var $1;
    var $2;
    var $ci;
    var $up;
    $1 = $L;
    $2 = $oldstack;
    var $3 = $1;
    var $4 = $3+8;
    var $5 = IHEAP[$4];
    var $6 = $2;
    var $7 = $5;
    var $8 = $6;
    var $9 = $7 - $8;
    var $10 = Math.floor($9 / 12);
    var $11 = $1;
    var $12 = $11+32;
    var $13 = IHEAP[$12];
    var $14 = $13+12*$10;
    var $15 = $1;
    var $16 = $15+8;
    IHEAP[$16] = $14;
    var $17 = $1;
    var $18 = $17+96;
    var $19 = IHEAP[$18];
    $up = $19;
    ;
    $20$2: while(1) { // $20
      var $21 = $up;
      var $22 = $21 != 0;
      if (!($22)) { __label__ = 2; /* $48 */ break $20$2; }
      var $24 = $up;
      var $25 = $24;
      var $26 = $25;
      var $27 = $26+8;
      var $28 = IHEAP[$27];
      var $29 = $2;
      var $30 = $28;
      var $31 = $29;
      var $32 = $30 - $31;
      var $33 = Math.floor($32 / 12);
      var $34 = $1;
      var $35 = $34+32;
      var $36 = IHEAP[$35];
      var $37 = $36+12*$33;
      var $38 = $up;
      var $39 = $38;
      var $40 = $39;
      var $41 = $40+8;
      IHEAP[$41] = $37;
      ;
      var $43 = $up;
      var $44 = $43;
      var $45 = $44;
      var $46 = $45;
      var $47 = IHEAP[$46];
      $up = $47;
      __label__ = 0; /* $20 */ continue $20$2;
    }
    var $49 = $1;
    var $50 = $49+40;
    var $51 = IHEAP[$50];
    $ci = $51;
    ;
    $52$7: while(1) { // $52
      var $53 = $ci;
      var $54 = $1;
      var $55 = $54+20;
      var $56 = IHEAP[$55];
      var $57 = $53 <= $56;
      if (!($57)) { __label__ = 6; /* $104 */ break $52$7; }
      var $59 = $ci;
      var $60 = $59+8;
      var $61 = IHEAP[$60];
      var $62 = $2;
      var $63 = $61;
      var $64 = $62;
      var $65 = $63 - $64;
      var $66 = Math.floor($65 / 12);
      var $67 = $1;
      var $68 = $67+32;
      var $69 = IHEAP[$68];
      var $70 = $69+12*$66;
      var $71 = $ci;
      var $72 = $71+8;
      IHEAP[$72] = $70;
      var $73 = $ci;
      var $74 = $73;
      var $75 = IHEAP[$74];
      var $76 = $2;
      var $77 = $75;
      var $78 = $76;
      var $79 = $77 - $78;
      var $80 = Math.floor($79 / 12);
      var $81 = $1;
      var $82 = $81+32;
      var $83 = IHEAP[$82];
      var $84 = $83+12*$80;
      var $85 = $ci;
      var $86 = $85;
      IHEAP[$86] = $84;
      var $87 = $ci;
      var $88 = $87+4;
      var $89 = IHEAP[$88];
      var $90 = $2;
      var $91 = $89;
      var $92 = $90;
      var $93 = $91 - $92;
      var $94 = Math.floor($93 / 12);
      var $95 = $1;
      var $96 = $95+32;
      var $97 = IHEAP[$96];
      var $98 = $97+12*$94;
      var $99 = $ci;
      var $100 = $99+4;
      IHEAP[$100] = $98;
      ;
      var $102 = $ci;
      var $103 = $102+24;
      $ci = $103;
      __label__ = 4; /* $52 */ continue $52$7;
    }
    var $105 = $1;
    var $106 = $105+12;
    var $107 = IHEAP[$106];
    var $108 = $2;
    var $109 = $107;
    var $110 = $108;
    var $111 = $109 - $110;
    var $112 = Math.floor($111 / 12);
    var $113 = $1;
    var $114 = $113+32;
    var $115 = IHEAP[$114];
    var $116 = $115+12*$112;
    var $117 = $1;
    var $118 = $117+12;
    IHEAP[$118] = $116;
    ;
    return;
  }
  __Z12correctstackP9lua_StateP10lua_TValue.__index__ = Runtime.getFunctionIndex(__Z12correctstackP9lua_StateP10lua_TValue, "__Z12correctstackP9lua_StateP10lua_TValue");
  
  
  function __Z14luaD_reallocCIP9lua_Statei($L, $newsize) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $oldci;
    $1 = $L;
    $2 = $newsize;
    var $3 = $1;
    var $4 = $3+40;
    var $5 = IHEAP[$4];
    $oldci = $5;
    var $6 = $2;
    var $7 = $6 + 1;
    var $8 = unSign($7, 32) <= unSign(178956970, 32);
    ;
    if ($8) {
      ;
      var $10 = $1;
      var $11 = $1;
      var $12 = $11+40;
      var $13 = IHEAP[$12];
      var $14 = $13;
      var $15 = $1;
      var $16 = $15+48;
      var $17 = IHEAP[$16];
      var $18 = $17 * 24;
      var $19 = $2;
      var $20 = $19 * 24;
      var $21 = __Z13luaM_realloc_P9lua_StatePvjj($10, $14, $18, $20);
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $23 = $1;
      var $24 = __Z11luaM_toobigP9lua_State($23);
      __lastLabel__ = 2; ;
    }
    var $26 = __lastLabel__ == 0 ? $21 : ($24);
    var $27 = $26;
    var $28 = $1;
    var $29 = $28+40;
    IHEAP[$29] = $27;
    var $30 = $2;
    var $31 = $1;
    var $32 = $31+48;
    IHEAP[$32] = $30;
    var $33 = $1;
    var $34 = $33+20;
    var $35 = IHEAP[$34];
    var $36 = $oldci;
    var $37 = $35;
    var $38 = $36;
    var $39 = $37 - $38;
    var $40 = Math.floor($39 / 24);
    var $41 = $1;
    var $42 = $41+40;
    var $43 = IHEAP[$42];
    var $44 = $43+24*$40;
    var $45 = $1;
    var $46 = $45+20;
    IHEAP[$46] = $44;
    var $47 = $1;
    var $48 = $47+40;
    var $49 = IHEAP[$48];
    var $50 = $1;
    var $51 = $50+48;
    var $52 = IHEAP[$51];
    var $53 = $49+24*$52;
    var $54 = $53+-24;
    var $55 = $1;
    var $56 = $55+36;
    IHEAP[$56] = $54;
    ;
    return;
  }
  __Z14luaD_reallocCIP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z14luaD_reallocCIP9lua_Statei, "__Z14luaD_reallocCIP9lua_Statei");
  
  
  function __Z14luaD_growstackP9lua_Statei($L, $n) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $L;
    $2 = $n;
    var $3 = $2;
    var $4 = $1;
    var $5 = $4+44;
    var $6 = IHEAP[$5];
    var $7 = $3 <= $6;
    ;
    if ($7) {
      ;
      var $9 = $1;
      var $10 = $1;
      var $11 = $10+44;
      var $12 = IHEAP[$11];
      var $13 = 2 * $12;
      __Z17luaD_reallocstackP9lua_Statei($9, $13);
      ;
    }
    else {
      ;
      var $15 = $1;
      var $16 = $1;
      var $17 = $16+44;
      var $18 = IHEAP[$17];
      var $19 = $2;
      var $20 = $18 + $19;
      __Z17luaD_reallocstackP9lua_Statei($15, $20);
      ;
    }
    ;
    return;
  }
  __Z14luaD_growstackP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z14luaD_growstackP9lua_Statei, "__Z14luaD_growstackP9lua_Statei");
  
  
  function __Z13luaD_callhookP9lua_Stateii($L, $event, $line) {
    var __stackBase__  = STACKTOP; STACKTOP += 100; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $hook;
    var $top;
    var $ci_top;
    var $ar = __stackBase__;
    $1 = $L;
    $2 = $event;
    $3 = $line;
    var $4 = $1;
    var $5 = $4+68;
    var $6 = IHEAP[$5];
    $hook = $6;
    var $7 = $hook;
    var $8 = $7 != 0;
    ;
    $9$110$2: do { 
      if ($8) {
        ;
        var $10 = $1;
        var $11 = $10+57;
        var $12 = IHEAP[$11];
        var $13 = $12 != 0;
        if (!($13)) { __label__ = 1; /* $110 */ break $9$110$2; }
        var $15 = $1;
        var $16 = $15+8;
        var $17 = IHEAP[$16];
        var $18 = $17;
        var $19 = $1;
        var $20 = $19+32;
        var $21 = IHEAP[$20];
        var $22 = $21;
        var $23 = $18;
        var $24 = $22;
        var $25 = $23 - $24;
        $top = $25;
        var $26 = $1;
        var $27 = $26+20;
        var $28 = IHEAP[$27];
        var $29 = $28+8;
        var $30 = IHEAP[$29];
        var $31 = $30;
        var $32 = $1;
        var $33 = $32+32;
        var $34 = IHEAP[$33];
        var $35 = $34;
        var $36 = $31;
        var $37 = $35;
        var $38 = $36 - $37;
        $ci_top = $38;
        var $39 = $2;
        var $40 = $ar;
        IHEAP[$40] = $39;
        var $41 = $3;
        var $42 = $ar+20;
        IHEAP[$42] = $41;
        var $43 = $2;
        var $44 = $43 == 4;
        ;
        if ($44) {
          ;
          var $46 = $ar+96;
          IHEAP[$46] = 0;
          ;
        }
        else {
          ;
          var $48 = $1;
          var $49 = $48+20;
          var $50 = IHEAP[$49];
          var $51 = $1;
          var $52 = $51+40;
          var $53 = IHEAP[$52];
          var $54 = $50;
          var $55 = $53;
          var $56 = $54 - $55;
          var $57 = Math.floor($56 / 24);
          var $58 = $ar+96;
          IHEAP[$58] = $57;
          ;
        }
        var $60 = $1;
        var $61 = $60+28;
        var $62 = IHEAP[$61];
        var $63 = $62;
        var $64 = $1;
        var $65 = $64+8;
        var $66 = IHEAP[$65];
        var $67 = $66;
        var $68 = $63;
        var $69 = $67;
        var $70 = $68 - $69;
        var $71 = $70 <= 240;
        ;
        if ($71) {
          ;
          var $73 = $1;
          __Z14luaD_growstackP9lua_Statei($73, 20);
          ;
        }
        else {
          ;
          ;
        }
        var $76 = $1;
        var $77 = $76+8;
        var $78 = IHEAP[$77];
        var $79 = $78+240;
        var $80 = $1;
        var $81 = $80+20;
        var $82 = IHEAP[$81];
        var $83 = $82+8;
        IHEAP[$83] = $79;
        var $84 = $1;
        var $85 = $84+57;
        IHEAP[$85] = 0;
        var $86 = $hook;
        var $87 = $1;
        FUNCTION_TABLE[$86]($87, $ar);
        var $88 = $1;
        var $89 = $88+57;
        IHEAP[$89] = 1;
        var $90 = $1;
        var $91 = $90+32;
        var $92 = IHEAP[$91];
        var $93 = $92;
        var $94 = $ci_top;
        var $95 = $93+$94;
        var $96 = $95;
        var $97 = $1;
        var $98 = $97+20;
        var $99 = IHEAP[$98];
        var $100 = $99+8;
        IHEAP[$100] = $96;
        var $101 = $1;
        var $102 = $101+32;
        var $103 = IHEAP[$102];
        var $104 = $103;
        var $105 = $top;
        var $106 = $104+$105;
        var $107 = $106;
        var $108 = $1;
        var $109 = $108+8;
        IHEAP[$109] = $107;
        ;
      }
    } while(0);
    STACKTOP = __stackBase__;
    return;
  }
  __Z13luaD_callhookP9lua_Stateii.__index__ = Runtime.getFunctionIndex(__Z13luaD_callhookP9lua_Stateii, "__Z13luaD_callhookP9lua_Stateii");
  
  
  function __Z12luaD_precallP9lua_StateP10lua_TValuei($L, $func, $nresults) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $4;
    var $cl;
    var $funcr;
    var $ci;
    var $st;
    var $base;
    var $p;
    var $nargs;
    var $ci1;
    var $n;
    $2 = $L;
    $3 = $func;
    $4 = $nresults;
    var $5 = $3;
    var $6 = $5+8;
    var $7 = IHEAP[$6];
    var $8 = $7 == 6;
    ;
    if (!$8) {
      ;
      var $10 = $2;
      var $11 = $3;
      var $12 = __Z9tryfuncTMP9lua_StateP10lua_TValue($10, $11);
      $3 = $12;
      ;
    }
    var $14 = $3;
    var $15 = $14;
    var $16 = $2;
    var $17 = $16+32;
    var $18 = IHEAP[$17];
    var $19 = $18;
    var $20 = $15;
    var $21 = $19;
    var $22 = $20 - $21;
    $funcr = $22;
    var $23 = $3;
    var $24 = $23;
    var $25 = $24;
    var $26 = $25;
    var $27 = IHEAP[$26];
    var $28 = $27;
    var $29 = $28;
    var $30 = $29;
    var $31 = $30;
    $cl = $31;
    var $32 = $2;
    var $33 = $32+24;
    var $34 = IHEAP[$33];
    var $35 = $2;
    var $36 = $35+20;
    var $37 = IHEAP[$36];
    var $38 = $37+12;
    IHEAP[$38] = $34;
    var $39 = $cl;
    var $40 = $39+6;
    var $41 = IHEAP[$40];
    var $42 = $41 != 0;
    ;
    if ($42) {
      ;
      var $212 = $2;
      var $213 = $212+28;
      var $214 = IHEAP[$213];
      var $215 = $214;
      var $216 = $2;
      var $217 = $216+8;
      var $218 = IHEAP[$217];
      var $219 = $218;
      var $220 = $215;
      var $221 = $219;
      var $222 = $220 - $221;
      var $223 = $222 <= 240;
      ;
      if ($223) {
        ;
        var $225 = $2;
        __Z14luaD_growstackP9lua_Statei($225, 20);
        ;
      }
      else {
        ;
        ;
      }
      var $228 = $2;
      var $229 = $228+20;
      var $230 = IHEAP[$229];
      var $231 = $2;
      var $232 = $231+36;
      var $233 = IHEAP[$232];
      var $234 = $230 == $233;
      ;
      if ($234) {
        ;
        var $236 = $2;
        var $237 = __Z6growCIP9lua_State($236);
        __lastLabel__ = 14; ;
      }
      else {
        ;
        var $239 = $2;
        var $240 = $239+20;
        var $241 = IHEAP[$240];
        var $242 = $241+24;
        IHEAP[$240] = $242;
        __lastLabel__ = 16; ;
      }
      var $244 = __lastLabel__ == 14 ? $237 : ($242);
      $ci1 = $244;
      var $245 = $2;
      var $246 = $245+32;
      var $247 = IHEAP[$246];
      var $248 = $247;
      var $249 = $funcr;
      var $250 = $248+$249;
      var $251 = $250;
      var $252 = $ci1;
      var $253 = $252+4;
      IHEAP[$253] = $251;
      var $254 = $ci1;
      var $255 = $254+4;
      var $256 = IHEAP[$255];
      var $257 = $256+12;
      var $258 = $ci1;
      var $259 = $258;
      IHEAP[$259] = $257;
      var $260 = $2;
      var $261 = $260+12;
      IHEAP[$261] = $257;
      var $262 = $2;
      var $263 = $262+8;
      var $264 = IHEAP[$263];
      var $265 = $264+240;
      var $266 = $ci1;
      var $267 = $266+8;
      IHEAP[$267] = $265;
      var $268 = $4;
      var $269 = $ci1;
      var $270 = $269+16;
      IHEAP[$270] = $268;
      var $271 = $2;
      var $272 = $271+56;
      var $273 = IHEAP[$272];
      var $274 = $273;
      var $275 = $274 & 1;
      var $276 = $275 != 0;
      ;
      if ($276) {
        ;
        var $278 = $2;
        __Z13luaD_callhookP9lua_Stateii($278, 0, -1);
        ;
      }
      var $280 = $2;
      var $281 = $280+20;
      var $282 = IHEAP[$281];
      var $283 = $282+4;
      var $284 = IHEAP[$283];
      var $285 = $284;
      var $286 = $285;
      var $287 = $286;
      var $288 = IHEAP[$287];
      var $289 = $288;
      var $290 = $289;
      var $291 = $290;
      var $292 = $291+16;
      var $293 = IHEAP[$292];
      var $294 = $2;
      var $295 = FUNCTION_TABLE[$293]($294);
      $n = $295;
      var $296 = $n;
      var $297 = $296 < 0;
      ;
      if ($297) {
        ;
        $1 = 2;
        ;
      }
      else {
        ;
        var $300 = $2;
        var $301 = $2;
        var $302 = $301+8;
        var $303 = IHEAP[$302];
        var $304 = $n;
        var $305 = 0 - $304;
        var $306 = $303+12*$305;
        var $307 = __Z12luaD_poscallP9lua_StateP10lua_TValue($300, $306);
        $1 = 1;
        ;
      }
    }
    else {
      ;
      var $44 = $cl;
      var $45 = $44+16;
      var $46 = IHEAP[$45];
      $p = $46;
      var $47 = $2;
      var $48 = $47+28;
      var $49 = IHEAP[$48];
      var $50 = $49;
      var $51 = $2;
      var $52 = $51+8;
      var $53 = IHEAP[$52];
      var $54 = $53;
      var $55 = $50;
      var $56 = $54;
      var $57 = $55 - $56;
      var $58 = $p;
      var $59 = $58+75;
      var $60 = IHEAP[$59];
      var $61 = $60;
      var $62 = $61 * 12;
      var $63 = $57 <= $62;
      ;
      if ($63) {
        ;
        var $65 = $2;
        var $66 = $p;
        var $67 = $66+75;
        var $68 = IHEAP[$67];
        var $69 = $68;
        __Z14luaD_growstackP9lua_Statei($65, $69);
        ;
      }
      else {
        ;
        ;
      }
      var $72 = $2;
      var $73 = $72+32;
      var $74 = IHEAP[$73];
      var $75 = $74;
      var $76 = $funcr;
      var $77 = $75+$76;
      var $78 = $77;
      $3 = $78;
      var $79 = $p;
      var $80 = $79+74;
      var $81 = IHEAP[$80];
      var $82 = $81 != 0;
      ;
      if ($82) {
        ;
        var $107 = $2;
        var $108 = $107+8;
        var $109 = IHEAP[$108];
        var $110 = $3;
        var $111 = $109;
        var $112 = $110;
        var $113 = $111 - $112;
        var $114 = Math.floor($113 / 12);
        var $115 = $114 - 1;
        $nargs = $115;
        var $116 = $2;
        var $117 = $p;
        var $118 = $nargs;
        var $119 = __Z14adjust_varargsP9lua_StateP5Protoi($116, $117, $118);
        $base = $119;
        var $120 = $2;
        var $121 = $120+32;
        var $122 = IHEAP[$121];
        var $123 = $122;
        var $124 = $funcr;
        var $125 = $123+$124;
        var $126 = $125;
        $3 = $126;
        ;
      }
      else {
        ;
        var $84 = $3;
        var $85 = $84+12;
        $base = $85;
        var $86 = $2;
        var $87 = $86+8;
        var $88 = IHEAP[$87];
        var $89 = $base;
        var $90 = $p;
        var $91 = $90+73;
        var $92 = IHEAP[$91];
        var $93 = $92;
        var $94 = $89+12*$93;
        var $95 = $88 > $94;
        ;
        if ($95) {
          ;
          var $97 = $base;
          var $98 = $p;
          var $99 = $98+73;
          var $100 = IHEAP[$99];
          var $101 = $100;
          var $102 = $97+12*$101;
          var $103 = $2;
          var $104 = $103+8;
          IHEAP[$104] = $102;
          ;
        }
        ;
      }
      var $128 = $2;
      var $129 = $128+20;
      var $130 = IHEAP[$129];
      var $131 = $2;
      var $132 = $131+36;
      var $133 = IHEAP[$132];
      var $134 = $130 == $133;
      ;
      if ($134) {
        ;
        var $136 = $2;
        var $137 = __Z6growCIP9lua_State($136);
        __lastLabel__ = 4; ;
      }
      else {
        ;
        var $139 = $2;
        var $140 = $139+20;
        var $141 = IHEAP[$140];
        var $142 = $141+24;
        IHEAP[$140] = $142;
        __lastLabel__ = 6; ;
      }
      var $144 = __lastLabel__ == 4 ? $137 : ($142);
      $ci = $144;
      var $145 = $3;
      var $146 = $ci;
      var $147 = $146+4;
      IHEAP[$147] = $145;
      var $148 = $base;
      var $149 = $ci;
      var $150 = $149;
      IHEAP[$150] = $148;
      var $151 = $2;
      var $152 = $151+12;
      IHEAP[$152] = $148;
      var $153 = $2;
      var $154 = $153+12;
      var $155 = IHEAP[$154];
      var $156 = $p;
      var $157 = $156+75;
      var $158 = IHEAP[$157];
      var $159 = $158;
      var $160 = $155+12*$159;
      var $161 = $ci;
      var $162 = $161+8;
      IHEAP[$162] = $160;
      var $163 = $p;
      var $164 = $163+12;
      var $165 = IHEAP[$164];
      var $166 = $2;
      var $167 = $166+24;
      IHEAP[$167] = $165;
      var $168 = $ci;
      var $169 = $168+20;
      IHEAP[$169] = 0;
      var $170 = $4;
      var $171 = $ci;
      var $172 = $171+16;
      IHEAP[$172] = $170;
      var $173 = $2;
      var $174 = $173+8;
      var $175 = IHEAP[$174];
      $st = $175;
      ;
      $176$37: while(1) { // $176
        var $177 = $st;
        var $178 = $ci;
        var $179 = $178+8;
        var $180 = IHEAP[$179];
        var $181 = $177 < $180;
        if (!($181)) { __label__ = 9; /* $188 */ break $176$37; }
        var $183 = $st;
        var $184 = $183+8;
        IHEAP[$184] = 0;
        ;
        var $186 = $st;
        var $187 = $186+12;
        $st = $187;
        __label__ = 7; /* $176 */ continue $176$37;
      }
      var $189 = $ci;
      var $190 = $189+8;
      var $191 = IHEAP[$190];
      var $192 = $2;
      var $193 = $192+8;
      IHEAP[$193] = $191;
      var $194 = $2;
      var $195 = $194+56;
      var $196 = IHEAP[$195];
      var $197 = $196;
      var $198 = $197 & 1;
      var $199 = $198 != 0;
      ;
      if ($199) {
        ;
        var $201 = $2;
        var $202 = $201+24;
        var $203 = IHEAP[$202];
        var $204 = $203+4;
        IHEAP[$202] = $204;
        var $205 = $2;
        __Z13luaD_callhookP9lua_Stateii($205, 0, -1);
        var $206 = $2;
        var $207 = $206+24;
        var $208 = IHEAP[$207];
        var $209 = $208+-4;
        IHEAP[$207] = $209;
        ;
      }
      $1 = 0;
      ;
    }
    var $309 = $1;
    ;
    return $309;
  }
  __Z12luaD_precallP9lua_StateP10lua_TValuei.__index__ = Runtime.getFunctionIndex(__Z12luaD_precallP9lua_StateP10lua_TValuei, "__Z12luaD_precallP9lua_StateP10lua_TValuei");
  
  
  function __Z9tryfuncTMP9lua_StateP10lua_TValue($L, $func) {
    ;
    var __label__;
    var $1;
    var $2;
    var $tm;
    var $p;
    var $funcr;
    var $o2;
    var $o1;
    var $o21;
    var $o12;
    $1 = $L;
    $2 = $func;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z15luaT_gettmbyobjP9lua_StatePK10lua_TValue3TMS($3, $4, 16);
    $tm = $5;
    var $6 = $2;
    var $7 = $6;
    var $8 = $1;
    var $9 = $8+32;
    var $10 = IHEAP[$9];
    var $11 = $10;
    var $12 = $7;
    var $13 = $11;
    var $14 = $12 - $13;
    $funcr = $14;
    var $15 = $tm;
    var $16 = $15+8;
    var $17 = IHEAP[$16];
    var $18 = $17 == 6;
    ;
    if (!$18) {
      ;
      var $20 = $1;
      var $21 = $2;
      __Z14luaG_typeerrorP9lua_StatePK10lua_TValuePKc($20, $21, __str829);
      ;
    }
    var $23 = $1;
    var $24 = $23+8;
    var $25 = IHEAP[$24];
    $p = $25;
    ;
    $26$5: while(1) { // $26
      var $27 = $p;
      var $28 = $2;
      var $29 = $27 > $28;
      if (!($29)) { __label__ = 3; /* $48 */ break $26$5; }
      var $31 = $p;
      var $32 = $31+-12;
      $o2 = $32;
      var $33 = $p;
      $o1 = $33;
      var $34 = $o1;
      var $35 = $34;
      var $36 = $o2;
      var $37 = $36;
      var $38 = $35;
      var $39 = $37;
      _llvm_memcpy_p0i8_p0i8_i32($38, $39, 8, 4, 0);
      var $40 = $o2;
      var $41 = $40+8;
      var $42 = IHEAP[$41];
      var $43 = $o1;
      var $44 = $43+8;
      IHEAP[$44] = $42;
      ;
      var $46 = $p;
      var $47 = $46+-12;
      $p = $47;
      __label__ = 1; /* $26 */ continue $26$5;
    }
    var $49 = $1;
    var $50 = $49+28;
    var $51 = IHEAP[$50];
    var $52 = $51;
    var $53 = $1;
    var $54 = $53+8;
    var $55 = IHEAP[$54];
    var $56 = $55;
    var $57 = $52;
    var $58 = $56;
    var $59 = $57 - $58;
    var $60 = $59 <= 12;
    ;
    if ($60) {
      ;
      var $62 = $1;
      __Z14luaD_growstackP9lua_Statei($62, 1);
      ;
    }
    else {
      ;
      ;
    }
    var $65 = $1;
    var $66 = $65+8;
    var $67 = IHEAP[$66];
    var $68 = $67+12;
    IHEAP[$66] = $68;
    var $69 = $1;
    var $70 = $69+32;
    var $71 = IHEAP[$70];
    var $72 = $71;
    var $73 = $funcr;
    var $74 = $72+$73;
    var $75 = $74;
    $2 = $75;
    var $76 = $tm;
    $o21 = $76;
    var $77 = $2;
    $o12 = $77;
    var $78 = $o12;
    var $79 = $78;
    var $80 = $o21;
    var $81 = $80;
    var $82 = $79;
    var $83 = $81;
    _llvm_memcpy_p0i8_p0i8_i32($82, $83, 8, 4, 0);
    var $84 = $o21;
    var $85 = $84+8;
    var $86 = IHEAP[$85];
    var $87 = $o12;
    var $88 = $87+8;
    IHEAP[$88] = $86;
    var $89 = $2;
    ;
    return $89;
  }
  __Z9tryfuncTMP9lua_StateP10lua_TValue.__index__ = Runtime.getFunctionIndex(__Z9tryfuncTMP9lua_StateP10lua_TValue, "__Z9tryfuncTMP9lua_StateP10lua_TValue");
  
  
  function __Z14adjust_varargsP9lua_StateP5Protoi($L, $p, $actual) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $i;
    var $nfixargs;
    var $htab;
    var $base;
    var $fixed;
    var $nvar;
    var $o2;
    var $o1;
    var $i_o;
    var $o21;
    var $o12;
    var $i_o3;
    $1 = $L;
    $2 = $p;
    $3 = $actual;
    var $4 = $2;
    var $5 = $4+73;
    var $6 = IHEAP[$5];
    var $7 = $6;
    $nfixargs = $7;
    $htab = 0;
    ;
    $8$2: while(1) { // $8
      var $9 = $3;
      var $10 = $nfixargs;
      var $11 = $9 < $10;
      if (!($11)) { __label__ = 2; /* $21 */ break $8$2; }
      var $13 = $1;
      var $14 = $13+8;
      var $15 = IHEAP[$14];
      var $16 = $15+12;
      IHEAP[$14] = $16;
      var $17 = $15+8;
      IHEAP[$17] = 0;
      ;
      var $19 = $3;
      var $20 = $19 + 1;
      $3 = $20;
      __label__ = 0; /* $8 */ continue $8$2;
    }
    var $22 = $2;
    var $23 = $22+74;
    var $24 = IHEAP[$23];
    var $25 = $24;
    var $26 = $25 & 4;
    var $27 = $26 != 0;
    ;
    if ($27) {
      ;
      var $29 = $3;
      var $30 = $nfixargs;
      var $31 = $29 - $30;
      $nvar = $31;
      var $32 = $1;
      var $33 = $32+16;
      var $34 = IHEAP[$33];
      var $35 = $34+68;
      var $36 = IHEAP[$35];
      var $37 = $1;
      var $38 = $37+16;
      var $39 = IHEAP[$38];
      var $40 = $39+64;
      var $41 = IHEAP[$40];
      var $42 = unSign($36, 32) >= unSign($41, 32);
      ;
      if ($42) {
        ;
        var $44 = $1;
        __Z9luaC_stepP9lua_State($44);
        ;
      }
      var $46 = $1;
      var $47 = $nvar;
      var $48 = __Z8luaH_newP9lua_Stateii($46, $47, 1);
      $htab = $48;
      $i = 0;
      ;
      $49$12: while(1) { // $49
        var $50 = $i;
        var $51 = $nvar;
        var $52 = $50 < $51;
        if (!($52)) { __label__ = 7; /* $81 */ break $49$12; }
        var $54 = $1;
        var $55 = $54+8;
        var $56 = IHEAP[$55];
        var $57 = $nvar;
        var $58 = 0 - $57;
        var $59 = $56+12*$58;
        var $60 = $i;
        var $61 = $59+12*$60;
        $o2 = $61;
        var $62 = $1;
        var $63 = $htab;
        var $64 = $i;
        var $65 = $64 + 1;
        var $66 = __Z11luaH_setnumP9lua_StateP5Tablei($62, $63, $65);
        $o1 = $66;
        var $67 = $o1;
        var $68 = $67;
        var $69 = $o2;
        var $70 = $69;
        var $71 = $68;
        var $72 = $70;
        _llvm_memcpy_p0i8_p0i8_i32($71, $72, 8, 4, 0);
        var $73 = $o2;
        var $74 = $73+8;
        var $75 = IHEAP[$74];
        var $76 = $o1;
        var $77 = $76+8;
        IHEAP[$77] = $75;
        ;
        var $79 = $i;
        var $80 = $79 + 1;
        $i = $80;
        __label__ = 5; /* $49 */ continue $49$12;
      }
      var $82 = $1;
      var $83 = $htab;
      var $84 = $1;
      var $85 = __Z12luaS_newlstrP9lua_StatePKcj($84, __str728, 1);
      var $86 = __Z11luaH_setstrP9lua_StateP5TableP7TString($82, $83, $85);
      $i_o = $86;
      var $87 = $nvar;
      var $88 = $87;
      var $89 = $i_o;
      var $90 = $89;
      var $91 = $90;
      FHEAP[$91] = $88;
      var $92 = $i_o;
      var $93 = $92+8;
      IHEAP[$93] = 3;
      ;
    }
    var $95 = $1;
    var $96 = $95+8;
    var $97 = IHEAP[$96];
    var $98 = $3;
    var $99 = 0 - $98;
    var $100 = $97+12*$99;
    $fixed = $100;
    var $101 = $1;
    var $102 = $101+8;
    var $103 = IHEAP[$102];
    $base = $103;
    $i = 0;
    ;
    $104$18: while(1) { // $104
      var $105 = $i;
      var $106 = $nfixargs;
      var $107 = $105 < $106;
      if (!($107)) { __label__ = 12; /* $134 */ break $104$18; }
      var $109 = $fixed;
      var $110 = $i;
      var $111 = $109+12*$110;
      $o21 = $111;
      var $112 = $1;
      var $113 = $112+8;
      var $114 = IHEAP[$113];
      var $115 = $114+12;
      IHEAP[$113] = $115;
      $o12 = $114;
      var $116 = $o12;
      var $117 = $116;
      var $118 = $o21;
      var $119 = $118;
      var $120 = $117;
      var $121 = $119;
      _llvm_memcpy_p0i8_p0i8_i32($120, $121, 8, 4, 0);
      var $122 = $o21;
      var $123 = $122+8;
      var $124 = IHEAP[$123];
      var $125 = $o12;
      var $126 = $125+8;
      IHEAP[$126] = $124;
      var $127 = $fixed;
      var $128 = $i;
      var $129 = $127+12*$128;
      var $130 = $129+8;
      IHEAP[$130] = 0;
      ;
      var $132 = $i;
      var $133 = $132 + 1;
      $i = $133;
      __label__ = 10; /* $104 */ continue $104$18;
    }
    var $135 = $htab;
    var $136 = $135 != 0;
    ;
    if ($136) {
      ;
      var $138 = $1;
      var $139 = $138+8;
      var $140 = IHEAP[$139];
      var $141 = $140+12;
      IHEAP[$139] = $141;
      $i_o3 = $140;
      var $142 = $htab;
      var $143 = $142;
      var $144 = $i_o3;
      var $145 = $144;
      var $146 = $145;
      var $147 = $146;
      IHEAP[$147] = $143;
      var $148 = $i_o3;
      var $149 = $148+8;
      IHEAP[$149] = 5;
      ;
    }
    var $151 = $base;
    ;
    return $151;
  }
  __Z14adjust_varargsP9lua_StateP5Protoi.__index__ = Runtime.getFunctionIndex(__Z14adjust_varargsP9lua_StateP5Protoi, "__Z14adjust_varargsP9lua_StateP5Protoi");
  
  
  function __Z6growCIP9lua_State($L) {
    ;
    var __label__;
    var $1;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+48;
    var $4 = IHEAP[$3];
    var $5 = $4 > 20000;
    ;
    if ($5) {
      ;
      var $7 = $1;
      __Z10luaD_throwP9lua_Statei($7, 5);
      ;
    }
    else {
      ;
      var $9 = $1;
      var $10 = $1;
      var $11 = $10+48;
      var $12 = IHEAP[$11];
      var $13 = 2 * $12;
      __Z14luaD_reallocCIP9lua_Statei($9, $13);
      var $14 = $1;
      var $15 = $14+48;
      var $16 = IHEAP[$15];
      var $17 = $16 > 20000;
      ;
      if ($17) {
        ;
        var $19 = $1;
        __Z13luaG_runerrorP9lua_StatePKcz($19, __str627);
        ;
      }
      ;
    }
    var $22 = $1;
    var $23 = $22+20;
    var $24 = IHEAP[$23];
    var $25 = $24+24;
    IHEAP[$23] = $25;
    ;
    return $25;
  }
  __Z6growCIP9lua_State.__index__ = Runtime.getFunctionIndex(__Z6growCIP9lua_State, "__Z6growCIP9lua_State");
  
  
  function __Z12luaD_poscallP9lua_StateP10lua_TValue($L, $firstResult) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $res;
    var $wanted;
    var $i;
    var $ci;
    var $o2;
    var $o1;
    $1 = $L;
    $2 = $firstResult;
    var $3 = $1;
    var $4 = $3+56;
    var $5 = IHEAP[$4];
    var $6 = $5;
    var $7 = $6 & 2;
    var $8 = $7 != 0;
    ;
    if ($8) {
      ;
      var $10 = $1;
      var $11 = $2;
      var $12 = __Z12callrethooksP9lua_StateP10lua_TValue($10, $11);
      $2 = $12;
      ;
    }
    var $14 = $1;
    var $15 = $14+20;
    var $16 = IHEAP[$15];
    var $17 = $16+-24;
    IHEAP[$15] = $17;
    $ci = $16;
    var $18 = $ci;
    var $19 = $18+4;
    var $20 = IHEAP[$19];
    $res = $20;
    var $21 = $ci;
    var $22 = $21+16;
    var $23 = IHEAP[$22];
    $wanted = $23;
    var $24 = $ci;
    var $25 = $24+-24;
    var $26 = $25;
    var $27 = IHEAP[$26];
    var $28 = $1;
    var $29 = $28+12;
    IHEAP[$29] = $27;
    var $30 = $ci;
    var $31 = $30+-24;
    var $32 = $31+12;
    var $33 = IHEAP[$32];
    var $34 = $1;
    var $35 = $34+24;
    IHEAP[$35] = $33;
    var $36 = $wanted;
    $i = $36;
    ;
    $37$5: while(1) { // $37
      var $38 = $i;
      var $39 = $38 != 0;
      ;
      if ($39) {
        __lastLabel__ = 1; ;
        var $41 = $2;
        var $42 = $1;
        var $43 = $42+8;
        var $44 = IHEAP[$43];
        var $45 = $41 < $44;
        __lastLabel__ = 2; ;
      }
      else {
        __lastLabel__ = 1; ;
      }
      var $47 = __lastLabel__ == 1 ? 0 : ($45);
      if (!($47)) { __label__ = 5; /* $67 */ break $37$5; }
      var $49 = $2;
      var $50 = $49+12;
      $2 = $50;
      $o2 = $49;
      var $51 = $res;
      var $52 = $51+12;
      $res = $52;
      $o1 = $51;
      var $53 = $o1;
      var $54 = $53;
      var $55 = $o2;
      var $56 = $55;
      var $57 = $54;
      var $58 = $56;
      _llvm_memcpy_p0i8_p0i8_i32($57, $58, 8, 4, 0);
      var $59 = $o2;
      var $60 = $59+8;
      var $61 = IHEAP[$60];
      var $62 = $o1;
      var $63 = $62+8;
      IHEAP[$63] = $61;
      ;
      var $65 = $i;
      var $66 = $65 + -1;
      $i = $66;
      __label__ = 1; /* $37 */ continue $37$5;
    }
    ;
    $68$13: while(1) { // $68
      var $69 = $i;
      var $70 = $69 + -1;
      $i = $70;
      var $71 = $69 > 0;
      if (!($71)) { __label__ = 9; /* $76 */ break $68$13; }
      var $73 = $res;
      var $74 = $73+12;
      $res = $74;
      var $75 = $73+8;
      IHEAP[$75] = 0;
      __label__ = 7; /* $68 */ continue $68$13;
    }
    var $77 = $res;
    var $78 = $1;
    var $79 = $78+8;
    IHEAP[$79] = $77;
    var $80 = $wanted;
    var $81 = $80 - -1;
    ;
    return $81;
  }
  __Z12luaD_poscallP9lua_StateP10lua_TValue.__index__ = Runtime.getFunctionIndex(__Z12luaD_poscallP9lua_StateP10lua_TValue, "__Z12luaD_poscallP9lua_StateP10lua_TValue");
  
  
  function __Z12callrethooksP9lua_StateP10lua_TValue($L, $firstResult) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $fr;
    $1 = $L;
    $2 = $firstResult;
    var $3 = $2;
    var $4 = $3;
    var $5 = $1;
    var $6 = $5+32;
    var $7 = IHEAP[$6];
    var $8 = $7;
    var $9 = $4;
    var $10 = $8;
    var $11 = $9 - $10;
    $fr = $11;
    var $12 = $1;
    __Z13luaD_callhookP9lua_Stateii($12, 1, -1);
    var $13 = $1;
    var $14 = $13+20;
    var $15 = IHEAP[$14];
    var $16 = $15+4;
    var $17 = IHEAP[$16];
    var $18 = $17;
    var $19 = $18;
    var $20 = $19;
    var $21 = IHEAP[$20];
    var $22 = $21;
    var $23 = $22;
    var $24 = $23;
    var $25 = $24+6;
    var $26 = IHEAP[$25];
    var $27 = $26 != 0;
    ;
    if (!$27) {
      ;
      ;
      $29$4: while(1) { // $29
        var $30 = $1;
        var $31 = $30+56;
        var $32 = IHEAP[$31];
        var $33 = $32;
        var $34 = $33 & 2;
        var $35 = $34 != 0;
        ;
        if ($35) {
          __lastLabel__ = 0; ;
          var $37 = $1;
          var $38 = $37+20;
          var $39 = IHEAP[$38];
          var $40 = $39+20;
          var $41 = IHEAP[$40];
          var $42 = $41 + -1;
          IHEAP[$40] = $42;
          var $43 = $41 != 0;
          __lastLabel__ = 1; ;
        }
        else {
          __lastLabel__ = 0; ;
        }
        var $45 = __lastLabel__ == 0 ? 0 : ($43);
        if (!($45)) { __label__ = 4; /* $48 */ break $29$4; }
        var $47 = $1;
        __Z13luaD_callhookP9lua_Stateii($47, 4, -1);
        __label__ = 0; /* $29 */ continue $29$4;
      }
      ;
    }
    var $50 = $1;
    var $51 = $50+32;
    var $52 = IHEAP[$51];
    var $53 = $52;
    var $54 = $fr;
    var $55 = $53+$54;
    var $56 = $55;
    ;
    return $56;
  }
  __Z12callrethooksP9lua_StateP10lua_TValue.__index__ = Runtime.getFunctionIndex(__Z12callrethooksP9lua_StateP10lua_TValue, "__Z12callrethooksP9lua_StateP10lua_TValue");
  
  
  function __Z9luaD_callP9lua_StateP10lua_TValuei($L, $func, $nResults) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    $1 = $L;
    $2 = $func;
    $3 = $nResults;
    var $4 = $1;
    var $5 = $4+52;
    var $6 = IHEAP[$5];
    var $7 = $6 + 1;
    IHEAP[$5] = $7;
    var $8 = $7;
    var $9 = $8 >= 200;
    ;
    if ($9) {
      ;
      var $11 = $1;
      var $12 = $11+52;
      var $13 = IHEAP[$12];
      var $14 = $13;
      var $15 = $14 == 200;
      ;
      if ($15) {
        ;
        var $17 = $1;
        __Z13luaG_runerrorP9lua_StatePKcz($17, __str223);
        ;
      }
      else {
        ;
        var $19 = $1;
        var $20 = $19+52;
        var $21 = IHEAP[$20];
        var $22 = $21;
        var $23 = $22 >= 225;
        ;
        if ($23) {
          ;
          var $25 = $1;
          __Z10luaD_throwP9lua_Statei($25, 5);
          ;
        }
        ;
      }
      ;
    }
    var $29 = $1;
    var $30 = $2;
    var $31 = $3;
    var $32 = __Z12luaD_precallP9lua_StateP10lua_TValuei($29, $30, $31);
    var $33 = $32 == 0;
    ;
    if ($33) {
      ;
      var $35 = $1;
      __Z12luaV_executeP9lua_Statei($35, 1);
      ;
    }
    var $37 = $1;
    var $38 = $37+52;
    var $39 = IHEAP[$38];
    var $40 = $39 + -1;
    IHEAP[$38] = $40;
    var $41 = $1;
    var $42 = $41+16;
    var $43 = IHEAP[$42];
    var $44 = $43+68;
    var $45 = IHEAP[$44];
    var $46 = $1;
    var $47 = $46+16;
    var $48 = IHEAP[$47];
    var $49 = $48+64;
    var $50 = IHEAP[$49];
    var $51 = unSign($45, 32) >= unSign($50, 32);
    ;
    if ($51) {
      ;
      var $53 = $1;
      __Z9luaC_stepP9lua_State($53);
      ;
    }
    ;
    return;
  }
  __Z9luaD_callP9lua_StateP10lua_TValuei.__index__ = Runtime.getFunctionIndex(__Z9luaD_callP9lua_StateP10lua_TValuei, "__Z9luaD_callP9lua_StateP10lua_TValuei");
  
  
  function __Z10lua_resumeP9lua_Statei($L, $nargs) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $status;
    $2 = $L;
    $3 = $nargs;
    var $4 = $2;
    var $5 = $4+6;
    var $6 = IHEAP[$5];
    var $7 = $6;
    var $8 = $7 != 1;
    ;
    $9$26$2: do { 
      if ($8) {
        ;
        var $10 = $2;
        var $11 = $10+6;
        var $12 = IHEAP[$11];
        var $13 = $12;
        var $14 = $13 != 0;
        ;
        if (!$14) {
          ;
          var $16 = $2;
          var $17 = $16+20;
          var $18 = IHEAP[$17];
          var $19 = $2;
          var $20 = $19+40;
          var $21 = IHEAP[$20];
          var $22 = $18 != $21;
          if (!($22)) { __label__ = 1; /* $26 */ break $9$26$2; }
        }
        var $24 = $2;
        var $25 = __Z12resume_errorP9lua_StatePKc($24, __str324);
        $1 = $25;
        __label__ = 2; /* $81 */ break $9$26$2;
      }
      else {
        __label__ = 1; /* $26 */ 
      }
    } while(0);
    if (__label__ == 1) {
      var $27 = $2;
      var $28 = $27+52;
      var $29 = IHEAP[$28];
      var $30 = $29;
      var $31 = $30 >= 200;
      ;
      if ($31) {
        ;
        var $33 = $2;
        var $34 = __Z12resume_errorP9lua_StatePKc($33, __str223);
        $1 = $34;
        ;
      }
      else {
        ;
        var $36 = $2;
        var $37 = $36+52;
        var $38 = IHEAP[$37];
        var $39 = $38 + 1;
        IHEAP[$37] = $39;
        var $40 = $2;
        var $41 = $40+54;
        IHEAP[$41] = $39;
        var $42 = $2;
        var $43 = $2;
        var $44 = $43+8;
        var $45 = IHEAP[$44];
        var $46 = $3;
        var $47 = 0 - $46;
        var $48 = $45+12*$47;
        var $49 = $48;
        var $50 = __Z20luaD_rawrunprotectedP9lua_StatePFvS0_PvES1_($42, __Z6resumeP9lua_StatePv.__index__, $49);
        $status = $50;
        var $51 = $status;
        var $52 = $51 != 0;
        ;
        if ($52) {
          ;
          var $54 = $status;
          var $55 = $54;
          var $56 = $2;
          var $57 = $56+6;
          IHEAP[$57] = $55;
          var $58 = $2;
          var $59 = $status;
          var $60 = $2;
          var $61 = $60+8;
          var $62 = IHEAP[$61];
          __Z16luaD_seterrorobjP9lua_StateiP10lua_TValue($58, $59, $62);
          var $63 = $2;
          var $64 = $63+8;
          var $65 = IHEAP[$64];
          var $66 = $2;
          var $67 = $66+20;
          var $68 = IHEAP[$67];
          var $69 = $68+8;
          IHEAP[$69] = $65;
          ;
        }
        else {
          ;
          var $71 = $2;
          var $72 = $71+6;
          var $73 = IHEAP[$72];
          var $74 = $73;
          $status = $74;
          ;
        }
        var $76 = $2;
        var $77 = $76+52;
        var $78 = IHEAP[$77];
        var $79 = $78 + -1;
        IHEAP[$77] = $79;
        var $80 = $status;
        $1 = $80;
        ;
      }
    }
    var $82 = $1;
    ;
    return $82;
  }
  __Z10lua_resumeP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z10lua_resumeP9lua_Statei, "__Z10lua_resumeP9lua_Statei");
  
  
  function __Z12resume_errorP9lua_StatePKc($L, $msg) {
    ;
    var __label__;
    var $1;
    var $2;
    var $i_o;
    $1 = $L;
    $2 = $msg;
    var $3 = $1;
    var $4 = $3+20;
    var $5 = IHEAP[$4];
    var $6 = $5;
    var $7 = IHEAP[$6];
    var $8 = $1;
    var $9 = $8+8;
    IHEAP[$9] = $7;
    var $10 = $1;
    var $11 = $10+8;
    var $12 = IHEAP[$11];
    $i_o = $12;
    var $13 = $1;
    var $14 = $2;
    var $15 = $2;
    var $16 = _strlen($15);
    var $17 = __Z12luaS_newlstrP9lua_StatePKcj($13, $14, $16);
    var $18 = $17;
    var $19 = $i_o;
    var $20 = $19;
    var $21 = $20;
    var $22 = $21;
    IHEAP[$22] = $18;
    var $23 = $i_o;
    var $24 = $23+8;
    IHEAP[$24] = 4;
    var $25 = $1;
    var $26 = $25+28;
    var $27 = IHEAP[$26];
    var $28 = $27;
    var $29 = $1;
    var $30 = $29+8;
    var $31 = IHEAP[$30];
    var $32 = $31;
    var $33 = $28;
    var $34 = $32;
    var $35 = $33 - $34;
    var $36 = $35 <= 12;
    ;
    if ($36) {
      ;
      var $38 = $1;
      __Z14luaD_growstackP9lua_Statei($38, 1);
      ;
    }
    else {
      ;
      ;
    }
    var $41 = $1;
    var $42 = $41+8;
    var $43 = IHEAP[$42];
    var $44 = $43+12;
    IHEAP[$42] = $44;
    ;
    return 2;
  }
  __Z12resume_errorP9lua_StatePKc.__index__ = Runtime.getFunctionIndex(__Z12resume_errorP9lua_StatePKc, "__Z12resume_errorP9lua_StatePKc");
  
  
  function __Z6resumeP9lua_StatePv($L, $ud) {
    ;
    var __label__;
    var $1;
    var $2;
    var $firstArg;
    var $ci;
    $1 = $L;
    $2 = $ud;
    var $3 = $2;
    var $4 = $3;
    $firstArg = $4;
    var $5 = $1;
    var $6 = $5+20;
    var $7 = IHEAP[$6];
    $ci = $7;
    var $8 = $1;
    var $9 = $8+6;
    var $10 = IHEAP[$9];
    var $11 = $10;
    var $12 = $11 == 0;
    ;
    $13$21$2: do { 
      if ($12) {
        ;
        var $14 = $1;
        var $15 = $firstArg;
        var $16 = $15+-12;
        var $17 = __Z12luaD_precallP9lua_StateP10lua_TValuei($14, $16, -1);
        var $18 = $17 != 0;
        ;
        if ($18) {
          ;
          __label__ = 0; /* $72 */ break $13$21$2;
        }
        else {
          ;
          __label__ = 1; /* $60 */ break $13$21$2;
        }
      }
      else {
        ;
        var $22 = $1;
        var $23 = $22+6;
        IHEAP[$23] = 0;
        var $24 = $ci;
        var $25 = $24+4;
        var $26 = IHEAP[$25];
        var $27 = $26;
        var $28 = $27;
        var $29 = $28;
        var $30 = IHEAP[$29];
        var $31 = $30;
        var $32 = $31;
        var $33 = $32;
        var $34 = $33+6;
        var $35 = IHEAP[$34];
        var $36 = $35 != 0;
        ;
        if ($36) {
          ;
          var $38 = $1;
          var $39 = $firstArg;
          var $40 = __Z12luaD_poscallP9lua_StateP10lua_TValue($38, $39);
          var $41 = $40 != 0;
          ;
          if ($41) {
            ;
            var $43 = $1;
            var $44 = $43+20;
            var $45 = IHEAP[$44];
            var $46 = $45+8;
            var $47 = IHEAP[$46];
            var $48 = $1;
            var $49 = $48+8;
            IHEAP[$49] = $47;
            ;
          }
          ;
        }
        else {
          ;
          var $52 = $1;
          var $53 = $52+20;
          var $54 = IHEAP[$53];
          var $55 = $54;
          var $56 = IHEAP[$55];
          var $57 = $1;
          var $58 = $57+12;
          IHEAP[$58] = $56;
          ;
        }
        __label__ = 1; /* $60 */ break $13$21$2;
      }
    } while(0);
    if (__label__ == 1) {
      var $61 = $1;
      var $62 = $1;
      var $63 = $62+20;
      var $64 = IHEAP[$63];
      var $65 = $1;
      var $66 = $65+40;
      var $67 = IHEAP[$66];
      var $68 = $64;
      var $69 = $67;
      var $70 = $68 - $69;
      var $71 = Math.floor($70 / 24);
      __Z12luaV_executeP9lua_Statei($61, $71);
      ;
    }
    ;
    return;
  }
  __Z6resumeP9lua_StatePv.__index__ = Runtime.getFunctionIndex(__Z6resumeP9lua_StatePv, "__Z6resumeP9lua_StatePv");
  
  
  function __Z9lua_yieldP9lua_Statei($L, $nresults) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $L;
    $2 = $nresults;
    var $3 = $1;
    var $4 = $3+52;
    var $5 = IHEAP[$4];
    var $6 = $5;
    var $7 = $1;
    var $8 = $7+54;
    var $9 = IHEAP[$8];
    var $10 = $9;
    var $11 = $6 > $10;
    ;
    if ($11) {
      ;
      var $13 = $1;
      __Z13luaG_runerrorP9lua_StatePKcz($13, __str425);
      ;
    }
    var $15 = $1;
    var $16 = $15+8;
    var $17 = IHEAP[$16];
    var $18 = $2;
    var $19 = 0 - $18;
    var $20 = $17+12*$19;
    var $21 = $1;
    var $22 = $21+12;
    IHEAP[$22] = $20;
    var $23 = $1;
    var $24 = $23+6;
    IHEAP[$24] = 1;
    ;
    return -1;
  }
  __Z9lua_yieldP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z9lua_yieldP9lua_Statei, "__Z9lua_yieldP9lua_Statei");
  
  
  function __Z10luaD_pcallP9lua_StatePFvS0_PvES1_ii($L, $func, $u, $old_top, $ef) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $5;
    var $status;
    var $oldnCcalls;
    var $old_ci;
    var $old_allowhooks;
    var $old_errfunc;
    var $oldtop;
    $1 = $L;
    $2 = $func;
    $3 = $u;
    $4 = $old_top;
    $5 = $ef;
    var $6 = $1;
    var $7 = $6+52;
    var $8 = IHEAP[$7];
    $oldnCcalls = $8;
    var $9 = $1;
    var $10 = $9+20;
    var $11 = IHEAP[$10];
    var $12 = $11;
    var $13 = $1;
    var $14 = $13+40;
    var $15 = IHEAP[$14];
    var $16 = $15;
    var $17 = $12;
    var $18 = $16;
    var $19 = $17 - $18;
    $old_ci = $19;
    var $20 = $1;
    var $21 = $20+57;
    var $22 = IHEAP[$21];
    $old_allowhooks = $22;
    var $23 = $1;
    var $24 = $23+108;
    var $25 = IHEAP[$24];
    $old_errfunc = $25;
    var $26 = $5;
    var $27 = $1;
    var $28 = $27+108;
    IHEAP[$28] = $26;
    var $29 = $1;
    var $30 = $2;
    var $31 = $3;
    var $32 = __Z20luaD_rawrunprotectedP9lua_StatePFvS0_PvES1_($29, $30, $31);
    $status = $32;
    var $33 = $status;
    var $34 = $33 != 0;
    ;
    if ($34) {
      ;
      var $36 = $1;
      var $37 = $36+32;
      var $38 = IHEAP[$37];
      var $39 = $38;
      var $40 = $4;
      var $41 = $39+$40;
      var $42 = $41;
      $oldtop = $42;
      var $43 = $1;
      var $44 = $oldtop;
      __Z10luaF_closeP9lua_StateP10lua_TValue($43, $44);
      var $45 = $1;
      var $46 = $status;
      var $47 = $oldtop;
      __Z16luaD_seterrorobjP9lua_StateiP10lua_TValue($45, $46, $47);
      var $48 = $oldnCcalls;
      var $49 = $1;
      var $50 = $49+52;
      IHEAP[$50] = $48;
      var $51 = $1;
      var $52 = $51+40;
      var $53 = IHEAP[$52];
      var $54 = $53;
      var $55 = $old_ci;
      var $56 = $54+$55;
      var $57 = $56;
      var $58 = $1;
      var $59 = $58+20;
      IHEAP[$59] = $57;
      var $60 = $1;
      var $61 = $60+20;
      var $62 = IHEAP[$61];
      var $63 = $62;
      var $64 = IHEAP[$63];
      var $65 = $1;
      var $66 = $65+12;
      IHEAP[$66] = $64;
      var $67 = $1;
      var $68 = $67+20;
      var $69 = IHEAP[$68];
      var $70 = $69+12;
      var $71 = IHEAP[$70];
      var $72 = $1;
      var $73 = $72+24;
      IHEAP[$73] = $71;
      var $74 = $old_allowhooks;
      var $75 = $1;
      var $76 = $75+57;
      IHEAP[$76] = $74;
      var $77 = $1;
      __Z19restore_stack_limitP9lua_State($77);
      ;
    }
    var $79 = $old_errfunc;
    var $80 = $1;
    var $81 = $80+108;
    IHEAP[$81] = $79;
    var $82 = $status;
    ;
    return $82;
  }
  __Z10luaD_pcallP9lua_StatePFvS0_PvES1_ii.__index__ = Runtime.getFunctionIndex(__Z10luaD_pcallP9lua_StatePFvS0_PvES1_ii, "__Z10luaD_pcallP9lua_StatePFvS0_PvES1_ii");
  
  
  function __Z19restore_stack_limitP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $inuse;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+48;
    var $4 = IHEAP[$3];
    var $5 = $4 > 20000;
    ;
    if ($5) {
      ;
      var $7 = $1;
      var $8 = $7+20;
      var $9 = IHEAP[$8];
      var $10 = $1;
      var $11 = $10+40;
      var $12 = IHEAP[$11];
      var $13 = $9;
      var $14 = $12;
      var $15 = $13 - $14;
      var $16 = Math.floor($15 / 24);
      $inuse = $16;
      var $17 = $inuse;
      var $18 = $17 + 1;
      var $19 = $18 < 20000;
      ;
      if ($19) {
        ;
        var $21 = $1;
        __Z14luaD_reallocCIP9lua_Statei($21, 20000);
        ;
      }
      ;
    }
    ;
    return;
  }
  __Z19restore_stack_limitP9lua_State.__index__ = Runtime.getFunctionIndex(__Z19restore_stack_limitP9lua_State, "__Z19restore_stack_limitP9lua_State");
  
  
  function __Z20luaD_protectedparserP9lua_StateP3ZioPKc($L, $z, $name) {
    var __stackBase__  = STACKTOP; STACKTOP += 20; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $p = __stackBase__;
    var $status;
    $1 = $L;
    $2 = $z;
    $3 = $name;
    var $4 = $2;
    var $5 = $p;
    IHEAP[$5] = $4;
    var $6 = $3;
    var $7 = $p+16;
    IHEAP[$7] = $6;
    var $8 = $p+4;
    var $9 = $8;
    IHEAP[$9] = 0;
    var $10 = $p+4;
    var $11 = $10+8;
    IHEAP[$11] = 0;
    var $12 = $1;
    var $13 = $p;
    var $14 = $1;
    var $15 = $14+8;
    var $16 = IHEAP[$15];
    var $17 = $16;
    var $18 = $1;
    var $19 = $18+32;
    var $20 = IHEAP[$19];
    var $21 = $20;
    var $22 = $17;
    var $23 = $21;
    var $24 = $22 - $23;
    var $25 = $1;
    var $26 = $25+108;
    var $27 = IHEAP[$26];
    var $28 = __Z10luaD_pcallP9lua_StatePFvS0_PvES1_ii($12, __Z8f_parserP9lua_StatePv.__index__, $13, $24, $27);
    $status = $28;
    var $29 = $1;
    var $30 = $p+4;
    var $31 = $30;
    var $32 = IHEAP[$31];
    var $33 = $p+4;
    var $34 = $33+8;
    var $35 = IHEAP[$34];
    var $36 = $35 * 1;
    var $37 = __Z13luaM_realloc_P9lua_StatePvjj($29, $32, $36, 0);
    var $38 = $p+4;
    var $39 = $38;
    IHEAP[$39] = $37;
    var $40 = $p+4;
    var $41 = $40+8;
    IHEAP[$41] = 0;
    var $42 = $status;
    STACKTOP = __stackBase__;
    return $42;
  }
  __Z20luaD_protectedparserP9lua_StateP3ZioPKc.__index__ = Runtime.getFunctionIndex(__Z20luaD_protectedparserP9lua_StateP3ZioPKc, "__Z20luaD_protectedparserP9lua_StateP3ZioPKc");
  
  
  function __Z8f_parserP9lua_StatePv($L, $ud) {
    ;
    var __label__;
    var $1;
    var $2;
    var $i;
    var $tf;
    var $cl;
    var $p;
    var $c;
    var $3;
    var $i_o;
    $1 = $L;
    $2 = $ud;
    var $4 = $2;
    var $5 = $4;
    $p = $5;
    var $6 = $p;
    var $7 = $6;
    var $8 = IHEAP[$7];
    var $9 = __Z14luaZ_lookaheadP3Zio($8);
    $c = $9;
    var $10 = $1;
    var $11 = $10+16;
    var $12 = IHEAP[$11];
    var $13 = $12+68;
    var $14 = IHEAP[$13];
    var $15 = $1;
    var $16 = $15+16;
    var $17 = IHEAP[$16];
    var $18 = $17+64;
    var $19 = IHEAP[$18];
    var $20 = unSign($14, 32) >= unSign($19, 32);
    ;
    if ($20) {
      ;
      var $22 = $1;
      __Z9luaC_stepP9lua_State($22);
      ;
    }
    var $24 = $c;
    var $25 = IHEAP[__str526];
    var $26 = $25;
    var $27 = $24 == $26;
    ;
    if ($27) {
      ;
      $3 = __Z11luaU_undumpP9lua_StateP3ZioP7MbufferPKc.__index__;
      ;
    }
    else {
      ;
      $3 = __Z11luaY_parserP9lua_StateP3ZioP7MbufferPKc.__index__;
      ;
    }
    var $31 = $3;
    var $32 = $1;
    var $33 = $p;
    var $34 = $33;
    var $35 = IHEAP[$34];
    var $36 = $p;
    var $37 = $36+4;
    var $38 = $p;
    var $39 = $38+16;
    var $40 = IHEAP[$39];
    var $41 = FUNCTION_TABLE[$31]($32, $35, $37, $40);
    $tf = $41;
    var $42 = $1;
    var $43 = $tf;
    var $44 = $43+72;
    var $45 = IHEAP[$44];
    var $46 = $45;
    var $47 = $1;
    var $48 = $47+72;
    var $49 = $48;
    var $50 = $49;
    var $51 = $50;
    var $52 = IHEAP[$51];
    var $53 = $52;
    var $54 = $53;
    var $55 = __Z16luaF_newLclosureP9lua_StateiP5Table($42, $46, $54);
    $cl = $55;
    var $56 = $tf;
    var $57 = $cl;
    var $58 = $57;
    var $59 = $58;
    var $60 = $59+16;
    IHEAP[$60] = $56;
    $i = 0;
    ;
    $61$9: while(1) { // $61
      var $62 = $i;
      var $63 = $tf;
      var $64 = $63+72;
      var $65 = IHEAP[$64];
      var $66 = $65;
      var $67 = $62 < $66;
      if (!($67)) { __label__ = 4; /* $80 */ break $61$9; }
      var $69 = $1;
      var $70 = __Z13luaF_newupvalP9lua_State($69);
      var $71 = $i;
      var $72 = $cl;
      var $73 = $72;
      var $74 = $73;
      var $75 = $74+20;
      var $76 = $75+$71*4;
      IHEAP[$76] = $70;
      ;
      var $78 = $i;
      var $79 = $78 + 1;
      $i = $79;
      __label__ = 2; /* $61 */ continue $61$9;
    }
    var $81 = $1;
    var $82 = $81+8;
    var $83 = IHEAP[$82];
    $i_o = $83;
    var $84 = $cl;
    var $85 = $84;
    var $86 = $i_o;
    var $87 = $86;
    var $88 = $87;
    var $89 = $88;
    IHEAP[$89] = $85;
    var $90 = $i_o;
    var $91 = $90+8;
    IHEAP[$91] = 6;
    var $92 = $1;
    var $93 = $92+28;
    var $94 = IHEAP[$93];
    var $95 = $94;
    var $96 = $1;
    var $97 = $96+8;
    var $98 = IHEAP[$97];
    var $99 = $98;
    var $100 = $95;
    var $101 = $99;
    var $102 = $100 - $101;
    var $103 = $102 <= 12;
    ;
    if ($103) {
      ;
      var $105 = $1;
      __Z14luaD_growstackP9lua_Statei($105, 1);
      ;
    }
    else {
      ;
      ;
    }
    var $108 = $1;
    var $109 = $108+8;
    var $110 = IHEAP[$109];
    var $111 = $110+12;
    IHEAP[$109] = $111;
    ;
    return;
  }
  __Z8f_parserP9lua_StatePv.__index__ = Runtime.getFunctionIndex(__Z8f_parserP9lua_StatePv, "__Z8f_parserP9lua_StatePv");
  
  
  function __Z9luaU_dumpP9lua_StatePK5ProtoPFiS0_PKvjPvES6_i($L, $f, $w, $data, $strip) {
    var __stackBase__  = STACKTOP; STACKTOP += 20; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $5;
    var $D = __stackBase__;
    $1 = $L;
    $2 = $f;
    $3 = $w;
    $4 = $data;
    $5 = $strip;
    var $6 = $1;
    var $7 = $D;
    IHEAP[$7] = $6;
    var $8 = $3;
    var $9 = $D+4;
    IHEAP[$9] = $8;
    var $10 = $4;
    var $11 = $D+8;
    IHEAP[$11] = $10;
    var $12 = $5;
    var $13 = $D+12;
    IHEAP[$13] = $12;
    var $14 = $D+16;
    IHEAP[$14] = 0;
    __Z10DumpHeaderP9DumpState($D);
    var $15 = $2;
    __Z12DumpFunctionPK5ProtoPK7TStringP9DumpState($15, 0, $D);
    var $16 = $D+16;
    var $17 = IHEAP[$16];
    STACKTOP = __stackBase__;
    return $17;
  }
  __Z9luaU_dumpP9lua_StatePK5ProtoPFiS0_PKvjPvES6_i.__index__ = Runtime.getFunctionIndex(__Z9luaU_dumpP9lua_StatePK5ProtoPFiS0_PKvjPvES6_i, "__Z9luaU_dumpP9lua_StatePK5ProtoPFiS0_PKvjPvES6_i");
  
  
  function __Z10DumpHeaderP9DumpState($D) {
    var __stackBase__  = STACKTOP; STACKTOP += 12; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $h = __stackBase__;
    $1 = $D;
    var $2 = $h;
    __Z11luaU_headerPc($2);
    var $3 = $h;
    var $4 = $1;
    __Z9DumpBlockPKvjP9DumpState($3, 12, $4);
    STACKTOP = __stackBase__;
    return;
  }
  __Z10DumpHeaderP9DumpState.__index__ = Runtime.getFunctionIndex(__Z10DumpHeaderP9DumpState, "__Z10DumpHeaderP9DumpState");
  
  
  function __Z12DumpFunctionPK5ProtoPK7TStringP9DumpState($f, $p, $D) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    $1 = $f;
    $2 = $p;
    $3 = $D;
    var $4 = $1;
    var $5 = $4+32;
    var $6 = IHEAP[$5];
    var $7 = $2;
    var $8 = $6 == $7;
    ;
    $14$9$2: do { 
      if ($8) {
        __label__ = 0; /* $14 */ 
      }
      else {
        ;
        var $10 = $3;
        var $11 = $10+12;
        var $12 = IHEAP[$11];
        var $13 = $12 != 0;
        if ($13) { __label__ = 0; /* $14 */ break $14$9$2; }
        var $16 = $1;
        var $17 = $16+32;
        var $18 = IHEAP[$17];
        __lastLabel__ = 1; __label__ = 3; /* $19 */ break $14$9$2;
      }
    } while(0);
    if (__label__ == 0) {
      __lastLabel__ = 0; ;
    }
    var $20 = __lastLabel__ == 0 ? 0 : ($18);
    var $21 = $3;
    __Z10DumpStringPK7TStringP9DumpState($20, $21);
    var $22 = $1;
    var $23 = $22+60;
    var $24 = IHEAP[$23];
    var $25 = $3;
    __Z7DumpIntiP9DumpState($24, $25);
    var $26 = $1;
    var $27 = $26+64;
    var $28 = IHEAP[$27];
    var $29 = $3;
    __Z7DumpIntiP9DumpState($28, $29);
    var $30 = $1;
    var $31 = $30+72;
    var $32 = IHEAP[$31];
    var $33 = $32;
    var $34 = $3;
    __Z8DumpChariP9DumpState($33, $34);
    var $35 = $1;
    var $36 = $35+73;
    var $37 = IHEAP[$36];
    var $38 = $37;
    var $39 = $3;
    __Z8DumpChariP9DumpState($38, $39);
    var $40 = $1;
    var $41 = $40+74;
    var $42 = IHEAP[$41];
    var $43 = $42;
    var $44 = $3;
    __Z8DumpChariP9DumpState($43, $44);
    var $45 = $1;
    var $46 = $45+75;
    var $47 = IHEAP[$46];
    var $48 = $47;
    var $49 = $3;
    __Z8DumpChariP9DumpState($48, $49);
    var $50 = $1;
    var $51 = $50+12;
    var $52 = IHEAP[$51];
    var $53 = $52;
    var $54 = $1;
    var $55 = $54+44;
    var $56 = IHEAP[$55];
    var $57 = $3;
    __Z10DumpVectorPKvijP9DumpState($53, $56, 4, $57);
    var $58 = $1;
    var $59 = $3;
    __Z13DumpConstantsPK5ProtoP9DumpState($58, $59);
    var $60 = $1;
    var $61 = $3;
    __Z9DumpDebugPK5ProtoP9DumpState($60, $61);
    ;
    return;
  }
  __Z12DumpFunctionPK5ProtoPK7TStringP9DumpState.__index__ = Runtime.getFunctionIndex(__Z12DumpFunctionPK5ProtoPK7TStringP9DumpState, "__Z12DumpFunctionPK5ProtoPK7TStringP9DumpState");
  
  
  function __Z10DumpStringPK7TStringP9DumpState($s, $D) {
    var __stackBase__  = STACKTOP; STACKTOP += 8; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $size = __stackBase__;
    var $size1 = __stackBase__+4;
    $1 = $s;
    $2 = $D;
    var $3 = $1;
    var $4 = $3 == 0;
    ;
    $10$5$2: do { 
      if ($4) {
        __label__ = 0; /* $10 */ 
      }
      else {
        ;
        var $6 = $1;
        var $7 = $6+16;
        var $8 = $7;
        var $9 = $8 == 0;
        if ($9) { __label__ = 0; /* $10 */ break $10$5$2; }
        var $14 = $1;
        var $15 = $14;
        var $16 = $15+12;
        var $17 = IHEAP[$16];
        var $18 = $17 + 1;
        IHEAP[$size1] = $18;
        var $19 = $size1;
        var $20 = $2;
        __Z9DumpBlockPKvjP9DumpState($19, 4, $20);
        var $21 = $1;
        var $22 = $21+16;
        var $23 = $22;
        var $24 = IHEAP[$size1];
        var $25 = $2;
        __Z9DumpBlockPKvjP9DumpState($23, $24, $25);
        __label__ = 3; /* $26 */ break $10$5$2;
      }
    } while(0);
    if (__label__ == 0) {
      IHEAP[$size] = 0;
      var $11 = $size;
      var $12 = $2;
      __Z9DumpBlockPKvjP9DumpState($11, 4, $12);
      ;
    }
    STACKTOP = __stackBase__;
    return;
  }
  __Z10DumpStringPK7TStringP9DumpState.__index__ = Runtime.getFunctionIndex(__Z10DumpStringPK7TStringP9DumpState, "__Z10DumpStringPK7TStringP9DumpState");
  
  
  function __Z7DumpIntiP9DumpState($x, $D) {
    var __stackBase__  = STACKTOP; STACKTOP += 4; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1 = __stackBase__;
    var $2;
    IHEAP[$1] = $x;
    $2 = $D;
    var $3 = $1;
    var $4 = $2;
    __Z9DumpBlockPKvjP9DumpState($3, 4, $4);
    STACKTOP = __stackBase__;
    return;
  }
  __Z7DumpIntiP9DumpState.__index__ = Runtime.getFunctionIndex(__Z7DumpIntiP9DumpState, "__Z7DumpIntiP9DumpState");
  
  
  function __Z8DumpChariP9DumpState($y, $D) {
    var __stackBase__  = STACKTOP; STACKTOP += 1; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $x = __stackBase__;
    $1 = $y;
    $2 = $D;
    var $3 = $1;
    var $4 = $3;
    IHEAP[$x] = $4;
    var $5 = $2;
    __Z9DumpBlockPKvjP9DumpState($x, 1, $5);
    STACKTOP = __stackBase__;
    return;
  }
  __Z8DumpChariP9DumpState.__index__ = Runtime.getFunctionIndex(__Z8DumpChariP9DumpState, "__Z8DumpChariP9DumpState");
  
  
  function __Z10DumpVectorPKvijP9DumpState($b, $n, $size, $D) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    $1 = $b;
    $2 = $n;
    $3 = $size;
    $4 = $D;
    var $5 = $2;
    var $6 = $4;
    __Z7DumpIntiP9DumpState($5, $6);
    var $7 = $1;
    var $8 = $2;
    var $9 = $3;
    var $10 = $8 * $9;
    var $11 = $4;
    __Z9DumpBlockPKvjP9DumpState($7, $10, $11);
    ;
    return;
  }
  __Z10DumpVectorPKvijP9DumpState.__index__ = Runtime.getFunctionIndex(__Z10DumpVectorPKvijP9DumpState, "__Z10DumpVectorPKvijP9DumpState");
  
  
  function __Z13DumpConstantsPK5ProtoP9DumpState($f, $D) {
    ;
    var __label__;
    var $1;
    var $2;
    var $i;
    var $n;
    var $o;
    $1 = $f;
    $2 = $D;
    var $3 = $1;
    var $4 = $3+40;
    var $5 = IHEAP[$4];
    $n = $5;
    var $6 = $n;
    var $7 = $2;
    __Z7DumpIntiP9DumpState($6, $7);
    $i = 0;
    ;
    $8$2: while(1) { // $8
      var $9 = $i;
      var $10 = $n;
      var $11 = $9 < $10;
      if (!($11)) { __label__ = 2; /* $53 */ break $8$2; }
      var $13 = $i;
      var $14 = $1;
      var $15 = $14+8;
      var $16 = IHEAP[$15];
      var $17 = $16+12*$13;
      $o = $17;
      var $18 = $o;
      var $19 = $18+8;
      var $20 = IHEAP[$19];
      var $21 = $2;
      __Z8DumpChariP9DumpState($20, $21);
      var $22 = $o;
      var $23 = $22+8;
      var $24 = IHEAP[$23];
      if ($24 == 0) {
        __label__ = 9; /* $25 */ 
      }
      else if ($24 == 1) {
        __label__ = 10; /* $26 */ 
      }
      else if ($24 == 3) {
        __label__ = 11; /* $33 */ 
      }
      else if ($24 == 4) {
        __label__ = 12; /* $39 */ 
      }
      else {
      __label__ = 13; /* $48 */ 
      }
      
      if (__label__ == 13) {
        ;
      }
      else if (__label__ == 9) {
        ;
      }
      else if (__label__ == 10) {
        var $27 = $o;
        var $28 = $27;
        var $29 = $28;
        var $30 = $29;
        var $31 = IHEAP[$30];
        var $32 = $2;
        __Z8DumpChariP9DumpState($31, $32);
        ;
      }
      else if (__label__ == 11) {
        var $34 = $o;
        var $35 = $34;
        var $36 = $35;
        var $37 = FHEAP[$36];
        var $38 = $2;
        __Z10DumpNumberdP9DumpState($37, $38);
        ;
      }
      else if (__label__ == 12) {
        var $40 = $o;
        var $41 = $40;
        var $42 = $41;
        var $43 = $42;
        var $44 = IHEAP[$43];
        var $45 = $44;
        var $46 = $45;
        var $47 = $2;
        __Z10DumpStringPK7TStringP9DumpState($46, $47);
        ;
      }
      ;
      var $51 = $i;
      var $52 = $51 + 1;
      $i = $52;
      __label__ = 0; /* $8 */ continue $8$2;
    }
    var $54 = $1;
    var $55 = $54+52;
    var $56 = IHEAP[$55];
    $n = $56;
    var $57 = $n;
    var $58 = $2;
    __Z7DumpIntiP9DumpState($57, $58);
    $i = 0;
    ;
    $59$14: while(1) { // $59
      var $60 = $i;
      var $61 = $n;
      var $62 = $60 < $61;
      if (!($62)) { __label__ = 7; /* $77 */ break $59$14; }
      var $64 = $i;
      var $65 = $1;
      var $66 = $65+16;
      var $67 = IHEAP[$66];
      var $68 = $67+4*$64;
      var $69 = IHEAP[$68];
      var $70 = $1;
      var $71 = $70+32;
      var $72 = IHEAP[$71];
      var $73 = $2;
      __Z12DumpFunctionPK5ProtoPK7TStringP9DumpState($69, $72, $73);
      ;
      var $75 = $i;
      var $76 = $75 + 1;
      $i = $76;
      __label__ = 5; /* $59 */ continue $59$14;
    }
    ;
    return;
  }
  __Z13DumpConstantsPK5ProtoP9DumpState.__index__ = Runtime.getFunctionIndex(__Z13DumpConstantsPK5ProtoP9DumpState, "__Z13DumpConstantsPK5ProtoP9DumpState");
  
  
  function __Z9DumpDebugPK5ProtoP9DumpState($f, $D) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $i;
    var $n;
    $1 = $f;
    $2 = $D;
    var $3 = $2;
    var $4 = $3+12;
    var $5 = IHEAP[$4];
    var $6 = $5 != 0;
    ;
    if ($6) {
      ;
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $9 = $1;
      var $10 = $9+48;
      var $11 = IHEAP[$10];
      __lastLabel__ = 2; ;
    }
    var $13 = __lastLabel__ == 0 ? 0 : ($11);
    $n = $13;
    var $14 = $1;
    var $15 = $14+20;
    var $16 = IHEAP[$15];
    var $17 = $16;
    var $18 = $n;
    var $19 = $2;
    __Z10DumpVectorPKvijP9DumpState($17, $18, 4, $19);
    var $20 = $2;
    var $21 = $20+12;
    var $22 = IHEAP[$21];
    var $23 = $22 != 0;
    ;
    if ($23) {
      ;
      __lastLabel__ = 3; ;
    }
    else {
      ;
      var $26 = $1;
      var $27 = $26+56;
      var $28 = IHEAP[$27];
      __lastLabel__ = 5; ;
    }
    var $30 = __lastLabel__ == 3 ? 0 : ($28);
    $n = $30;
    var $31 = $n;
    var $32 = $2;
    __Z7DumpIntiP9DumpState($31, $32);
    $i = 0;
    ;
    $33$10: while(1) { // $33
      var $34 = $i;
      var $35 = $n;
      var $36 = $34 < $35;
      if (!($36)) { __label__ = 8; /* $65 */ break $33$10; }
      var $38 = $i;
      var $39 = $1;
      var $40 = $39+24;
      var $41 = IHEAP[$40];
      var $42 = $41+12*$38;
      var $43 = $42;
      var $44 = IHEAP[$43];
      var $45 = $2;
      __Z10DumpStringPK7TStringP9DumpState($44, $45);
      var $46 = $i;
      var $47 = $1;
      var $48 = $47+24;
      var $49 = IHEAP[$48];
      var $50 = $49+12*$46;
      var $51 = $50+4;
      var $52 = IHEAP[$51];
      var $53 = $2;
      __Z7DumpIntiP9DumpState($52, $53);
      var $54 = $i;
      var $55 = $1;
      var $56 = $55+24;
      var $57 = IHEAP[$56];
      var $58 = $57+12*$54;
      var $59 = $58+8;
      var $60 = IHEAP[$59];
      var $61 = $2;
      __Z7DumpIntiP9DumpState($60, $61);
      ;
      var $63 = $i;
      var $64 = $63 + 1;
      $i = $64;
      __label__ = 6; /* $33 */ continue $33$10;
    }
    var $66 = $2;
    var $67 = $66+12;
    var $68 = IHEAP[$67];
    var $69 = $68 != 0;
    ;
    if ($69) {
      ;
      __lastLabel__ = 10; ;
    }
    else {
      ;
      var $72 = $1;
      var $73 = $72+36;
      var $74 = IHEAP[$73];
      __lastLabel__ = 12; ;
    }
    var $76 = __lastLabel__ == 10 ? 0 : ($74);
    $n = $76;
    var $77 = $n;
    var $78 = $2;
    __Z7DumpIntiP9DumpState($77, $78);
    $i = 0;
    ;
    $79$19: while(1) { // $79
      var $80 = $i;
      var $81 = $n;
      var $82 = $80 < $81;
      if (!($82)) { __label__ = 15; /* $94 */ break $79$19; }
      var $84 = $i;
      var $85 = $1;
      var $86 = $85+28;
      var $87 = IHEAP[$86];
      var $88 = $87+4*$84;
      var $89 = IHEAP[$88];
      var $90 = $2;
      __Z10DumpStringPK7TStringP9DumpState($89, $90);
      ;
      var $92 = $i;
      var $93 = $92 + 1;
      $i = $93;
      __label__ = 13; /* $79 */ continue $79$19;
    }
    ;
    return;
  }
  __Z9DumpDebugPK5ProtoP9DumpState.__index__ = Runtime.getFunctionIndex(__Z9DumpDebugPK5ProtoP9DumpState, "__Z9DumpDebugPK5ProtoP9DumpState");
  
  
  function __Z10DumpNumberdP9DumpState($x, $D) {
    var __stackBase__  = STACKTOP; STACKTOP += 8; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1 = __stackBase__;
    var $2;
    FHEAP[$1] = $x;
    $2 = $D;
    var $3 = $1;
    var $4 = $2;
    __Z9DumpBlockPKvjP9DumpState($3, 8, $4);
    STACKTOP = __stackBase__;
    return;
  }
  __Z10DumpNumberdP9DumpState.__index__ = Runtime.getFunctionIndex(__Z10DumpNumberdP9DumpState, "__Z10DumpNumberdP9DumpState");
  
  
  function __Z9DumpBlockPKvjP9DumpState($b, $size, $D) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    $1 = $b;
    $2 = $size;
    $3 = $D;
    var $4 = $3;
    var $5 = $4+16;
    var $6 = IHEAP[$5];
    var $7 = $6 == 0;
    ;
    if ($7) {
      ;
      var $9 = $3;
      var $10 = $9+4;
      var $11 = IHEAP[$10];
      var $12 = $3;
      var $13 = $12;
      var $14 = IHEAP[$13];
      var $15 = $1;
      var $16 = $2;
      var $17 = $3;
      var $18 = $17+8;
      var $19 = IHEAP[$18];
      var $20 = FUNCTION_TABLE[$11]($14, $15, $16, $19);
      var $21 = $3;
      var $22 = $21+16;
      IHEAP[$22] = $20;
      ;
    }
    ;
    return;
  }
  __Z9DumpBlockPKvjP9DumpState.__index__ = Runtime.getFunctionIndex(__Z9DumpBlockPKvjP9DumpState, "__Z9DumpBlockPKvjP9DumpState");
  
  
  function __Z16luaF_newCclosureP9lua_StateiP5Table($L, $nelems, $e) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $c;
    $1 = $L;
    $2 = $nelems;
    $3 = $e;
    var $4 = $1;
    var $5 = $2;
    var $6 = $5 - 1;
    var $7 = 12 * $6;
    var $8 = 32 + $7;
    var $9 = __Z13luaM_realloc_P9lua_StatePvjj($4, 0, 0, $8);
    var $10 = $9;
    $c = $10;
    var $11 = $1;
    var $12 = $c;
    var $13 = $12;
    __Z9luaC_linkP9lua_StateP8GCObjecth($11, $13, 6);
    var $14 = $c;
    var $15 = $14;
    var $16 = $15+6;
    IHEAP[$16] = 1;
    var $17 = $3;
    var $18 = $c;
    var $19 = $18;
    var $20 = $19+12;
    IHEAP[$20] = $17;
    var $21 = $2;
    var $22 = $21;
    var $23 = $c;
    var $24 = $23;
    var $25 = $24+7;
    IHEAP[$25] = $22;
    var $26 = $c;
    ;
    return $26;
  }
  __Z16luaF_newCclosureP9lua_StateiP5Table.__index__ = Runtime.getFunctionIndex(__Z16luaF_newCclosureP9lua_StateiP5Table, "__Z16luaF_newCclosureP9lua_StateiP5Table");
  
  
  function __Z16luaF_newLclosureP9lua_StateiP5Table($L, $nelems, $e) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $c;
    $1 = $L;
    $2 = $nelems;
    $3 = $e;
    var $4 = $1;
    var $5 = $2;
    var $6 = $5 - 1;
    var $7 = 4 * $6;
    var $8 = 24 + $7;
    var $9 = __Z13luaM_realloc_P9lua_StatePvjj($4, 0, 0, $8);
    var $10 = $9;
    $c = $10;
    var $11 = $1;
    var $12 = $c;
    var $13 = $12;
    __Z9luaC_linkP9lua_StateP8GCObjecth($11, $13, 6);
    var $14 = $c;
    var $15 = $14;
    var $16 = $15;
    var $17 = $16+6;
    IHEAP[$17] = 0;
    var $18 = $3;
    var $19 = $c;
    var $20 = $19;
    var $21 = $20;
    var $22 = $21+12;
    IHEAP[$22] = $18;
    var $23 = $2;
    var $24 = $23;
    var $25 = $c;
    var $26 = $25;
    var $27 = $26;
    var $28 = $27+7;
    IHEAP[$28] = $24;
    ;
    $29$2: while(1) { // $29
      var $30 = $2;
      var $31 = $30 + -1;
      $2 = $31;
      var $32 = $30 != 0;
      if (!($32)) { __label__ = 2; /* $40 */ break $29$2; }
      var $34 = $2;
      var $35 = $c;
      var $36 = $35;
      var $37 = $36;
      var $38 = $37+20;
      var $39 = $38+$34*4;
      IHEAP[$39] = 0;
      __label__ = 0; /* $29 */ continue $29$2;
    }
    var $41 = $c;
    ;
    return $41;
  }
  __Z16luaF_newLclosureP9lua_StateiP5Table.__index__ = Runtime.getFunctionIndex(__Z16luaF_newLclosureP9lua_StateiP5Table, "__Z16luaF_newLclosureP9lua_StateiP5Table");
  
  
  function __Z13luaF_newupvalP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $uv;
    $1 = $L;
    var $2 = $1;
    var $3 = __Z13luaM_realloc_P9lua_StatePvjj($2, 0, 0, 24);
    var $4 = $3;
    $uv = $4;
    var $5 = $1;
    var $6 = $uv;
    var $7 = $6;
    __Z9luaC_linkP9lua_StateP8GCObjecth($5, $7, 10);
    var $8 = $uv;
    var $9 = $8+12;
    var $10 = $9;
    var $11 = $uv;
    var $12 = $11+8;
    IHEAP[$12] = $10;
    var $13 = $uv;
    var $14 = $13+8;
    var $15 = IHEAP[$14];
    var $16 = $15+8;
    IHEAP[$16] = 0;
    var $17 = $uv;
    ;
    return $17;
  }
  __Z13luaF_newupvalP9lua_State.__index__ = Runtime.getFunctionIndex(__Z13luaF_newupvalP9lua_State, "__Z13luaF_newupvalP9lua_State");
  
  
  function __Z14luaF_findupvalP9lua_StateP10lua_TValue($L, $level) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $g;
    var $pp;
    var $p;
    var $uv;
    $2 = $L;
    $3 = $level;
    var $4 = $2;
    var $5 = $4+16;
    var $6 = IHEAP[$5];
    $g = $6;
    var $7 = $2;
    var $8 = $7+96;
    $pp = $8;
    ;
    $9$2: while(1) { // $9
      var $10 = $pp;
      var $11 = IHEAP[$10];
      var $12 = $11 != 0;
      ;
      if ($12) {
        __lastLabel__ = 0; ;
        var $14 = $pp;
        var $15 = IHEAP[$14];
        var $16 = $15;
        var $17 = $16;
        $p = $17;
        var $18 = $17+8;
        var $19 = IHEAP[$18];
        var $20 = $3;
        var $21 = $19 >= $20;
        __lastLabel__ = 1; ;
      }
      else {
        __lastLabel__ = 0; ;
      }
      var $23 = __lastLabel__ == 0 ? 0 : ($21);
      if (!($23)) { __label__ = 4; /* $61 */ break $9$2; }
      var $25 = $p;
      var $26 = $25+8;
      var $27 = IHEAP[$26];
      var $28 = $3;
      var $29 = $27 == $28;
      if ($29) { __label__ = 5; /* $30 */ break $9$2; }
      var $59 = $p;
      var $60 = $59;
      $pp = $60;
      __label__ = 0; /* $9 */ continue $9$2;
    }
    if (__label__ == 4) {
      var $62 = $2;
      var $63 = __Z13luaM_realloc_P9lua_StatePvjj($62, 0, 0, 24);
      var $64 = $63;
      $uv = $64;
      var $65 = $uv;
      var $66 = $65+4;
      IHEAP[$66] = 10;
      var $67 = $g;
      var $68 = $67+20;
      var $69 = IHEAP[$68];
      var $70 = $69;
      var $71 = $70 & 3;
      var $72 = $71;
      var $73 = $uv;
      var $74 = $73+5;
      IHEAP[$74] = $72;
      var $75 = $3;
      var $76 = $uv;
      var $77 = $76+8;
      IHEAP[$77] = $75;
      var $78 = $pp;
      var $79 = IHEAP[$78];
      var $80 = $uv;
      var $81 = $80;
      IHEAP[$81] = $79;
      var $82 = $uv;
      var $83 = $82;
      var $84 = $pp;
      IHEAP[$84] = $83;
      var $85 = $g;
      var $86 = $85+108;
      var $87 = $uv;
      var $88 = $87+12;
      var $89 = $88;
      var $90 = $89;
      var $91 = $90;
      IHEAP[$91] = $86;
      var $92 = $g;
      var $93 = $92+108;
      var $94 = $93+12;
      var $95 = $94;
      var $96 = $95;
      var $97 = $96+4;
      var $98 = IHEAP[$97];
      var $99 = $uv;
      var $100 = $99+12;
      var $101 = $100;
      var $102 = $101;
      var $103 = $102+4;
      IHEAP[$103] = $98;
      var $104 = $uv;
      var $105 = $uv;
      var $106 = $105+12;
      var $107 = $106;
      var $108 = $107;
      var $109 = $108+4;
      var $110 = IHEAP[$109];
      var $111 = $110+12;
      var $112 = $111;
      var $113 = $112;
      var $114 = $113;
      IHEAP[$114] = $104;
      var $115 = $uv;
      var $116 = $g;
      var $117 = $116+108;
      var $118 = $117+12;
      var $119 = $118;
      var $120 = $119;
      var $121 = $120+4;
      IHEAP[$121] = $115;
      var $122 = $uv;
      $1 = $122;
      ;
    }
    else if (__label__ == 5) {
      var $31 = $p;
      var $32 = $31;
      var $33 = $32;
      var $34 = $33;
      var $35 = $34+5;
      var $36 = IHEAP[$35];
      var $37 = $36;
      var $38 = $g;
      var $39 = $38+20;
      var $40 = IHEAP[$39];
      var $41 = $40;
      var $42 = $41 ^ 3;
      var $43 = $37 & $42;
      var $44 = $43 & 3;
      var $45 = $44 != 0;
      ;
      if ($45) {
        ;
        var $47 = $p;
        var $48 = $47;
        var $49 = $48;
        var $50 = $49;
        var $51 = $50+5;
        var $52 = IHEAP[$51];
        var $53 = $52;
        var $54 = $53 ^ 3;
        var $55 = $54;
        IHEAP[$51] = $55;
        ;
      }
      var $57 = $p;
      $1 = $57;
      ;
    }
    var $124 = $1;
    ;
    return $124;
  }
  __Z14luaF_findupvalP9lua_StateP10lua_TValue.__index__ = Runtime.getFunctionIndex(__Z14luaF_findupvalP9lua_StateP10lua_TValue, "__Z14luaF_findupvalP9lua_StateP10lua_TValue");
  
  
  function __Z14luaF_freeupvalP9lua_StateP5UpVal($L, $uv) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $L;
    $2 = $uv;
    var $3 = $2;
    var $4 = $3+8;
    var $5 = IHEAP[$4];
    var $6 = $2;
    var $7 = $6+12;
    var $8 = $7;
    var $9 = $5 != $8;
    ;
    if ($9) {
      ;
      var $11 = $2;
      __Z11unlinkupvalP5UpVal($11);
      ;
    }
    var $13 = $1;
    var $14 = $2;
    var $15 = $14;
    var $16 = __Z13luaM_realloc_P9lua_StatePvjj($13, $15, 24, 0);
    ;
    return;
  }
  __Z14luaF_freeupvalP9lua_StateP5UpVal.__index__ = Runtime.getFunctionIndex(__Z14luaF_freeupvalP9lua_StateP5UpVal, "__Z14luaF_freeupvalP9lua_StateP5UpVal");
  
  
  function __Z11unlinkupvalP5UpVal($uv) {
    ;
    var __label__;
    var $1;
    $1 = $uv;
    var $2 = $1;
    var $3 = $2+12;
    var $4 = $3;
    var $5 = $4;
    var $6 = $5;
    var $7 = IHEAP[$6];
    var $8 = $1;
    var $9 = $8+12;
    var $10 = $9;
    var $11 = $10;
    var $12 = $11+4;
    var $13 = IHEAP[$12];
    var $14 = $13+12;
    var $15 = $14;
    var $16 = $15;
    var $17 = $16;
    IHEAP[$17] = $7;
    var $18 = $1;
    var $19 = $18+12;
    var $20 = $19;
    var $21 = $20;
    var $22 = $21+4;
    var $23 = IHEAP[$22];
    var $24 = $1;
    var $25 = $24+12;
    var $26 = $25;
    var $27 = $26;
    var $28 = $27;
    var $29 = IHEAP[$28];
    var $30 = $29+12;
    var $31 = $30;
    var $32 = $31;
    var $33 = $32+4;
    IHEAP[$33] = $23;
    ;
    return;
  }
  __Z11unlinkupvalP5UpVal.__index__ = Runtime.getFunctionIndex(__Z11unlinkupvalP5UpVal, "__Z11unlinkupvalP5UpVal");
  
  
  function __Z10luaF_closeP9lua_StateP10lua_TValue($L, $level) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $uv;
    var $g;
    var $o;
    var $o2;
    var $o1;
    $1 = $L;
    $2 = $level;
    var $3 = $1;
    var $4 = $3+16;
    var $5 = IHEAP[$4];
    $g = $5;
    ;
    $6$2: while(1) { // $6
      var $7 = $1;
      var $8 = $7+96;
      var $9 = IHEAP[$8];
      var $10 = $9 != 0;
      ;
      if ($10) {
        __lastLabel__ = 0; ;
        var $12 = $1;
        var $13 = $12+96;
        var $14 = IHEAP[$13];
        var $15 = $14;
        var $16 = $15;
        $uv = $16;
        var $17 = $16+8;
        var $18 = IHEAP[$17];
        var $19 = $2;
        var $20 = $18 >= $19;
        __lastLabel__ = 1; ;
      }
      else {
        __lastLabel__ = 0; ;
      }
      var $22 = __lastLabel__ == 0 ? 0 : ($20);
      if (!($22)) { __label__ = 4; /* $75 */ break $6$2; }
      var $24 = $uv;
      var $25 = $24;
      $o = $25;
      var $26 = $uv;
      var $27 = $26;
      var $28 = IHEAP[$27];
      var $29 = $1;
      var $30 = $29+96;
      IHEAP[$30] = $28;
      var $31 = $o;
      var $32 = $31;
      var $33 = $32;
      var $34 = $33+5;
      var $35 = IHEAP[$34];
      var $36 = $35;
      var $37 = $g;
      var $38 = $37+20;
      var $39 = IHEAP[$38];
      var $40 = $39;
      var $41 = $40 ^ 3;
      var $42 = $36 & $41;
      var $43 = $42 & 3;
      var $44 = $43 != 0;
      ;
      if ($44) {
        ;
        var $46 = $1;
        var $47 = $uv;
        __Z14luaF_freeupvalP9lua_StateP5UpVal($46, $47);
        ;
      }
      else {
        ;
        var $49 = $uv;
        __Z11unlinkupvalP5UpVal($49);
        var $50 = $uv;
        var $51 = $50+8;
        var $52 = IHEAP[$51];
        $o2 = $52;
        var $53 = $uv;
        var $54 = $53+12;
        var $55 = $54;
        $o1 = $55;
        var $56 = $o1;
        var $57 = $56;
        var $58 = $o2;
        var $59 = $58;
        var $60 = $57;
        var $61 = $59;
        _llvm_memcpy_p0i8_p0i8_i32($60, $61, 8, 4, 0);
        var $62 = $o2;
        var $63 = $62+8;
        var $64 = IHEAP[$63];
        var $65 = $o1;
        var $66 = $65+8;
        IHEAP[$66] = $64;
        var $67 = $uv;
        var $68 = $67+12;
        var $69 = $68;
        var $70 = $uv;
        var $71 = $70+8;
        IHEAP[$71] = $69;
        var $72 = $1;
        var $73 = $uv;
        __Z14luaC_linkupvalP9lua_StateP5UpVal($72, $73);
        ;
      }
      __label__ = 0; /* $6 */ continue $6$2;
    }
    ;
    return;
  }
  __Z10luaF_closeP9lua_StateP10lua_TValue.__index__ = Runtime.getFunctionIndex(__Z10luaF_closeP9lua_StateP10lua_TValue, "__Z10luaF_closeP9lua_StateP10lua_TValue");
  
  
  function __Z13luaF_newprotoP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $f;
    $1 = $L;
    var $2 = $1;
    var $3 = __Z13luaM_realloc_P9lua_StatePvjj($2, 0, 0, 76);
    var $4 = $3;
    $f = $4;
    var $5 = $1;
    var $6 = $f;
    var $7 = $6;
    __Z9luaC_linkP9lua_StateP8GCObjecth($5, $7, 9);
    var $8 = $f;
    var $9 = $8+8;
    IHEAP[$9] = 0;
    var $10 = $f;
    var $11 = $10+40;
    IHEAP[$11] = 0;
    var $12 = $f;
    var $13 = $12+16;
    IHEAP[$13] = 0;
    var $14 = $f;
    var $15 = $14+52;
    IHEAP[$15] = 0;
    var $16 = $f;
    var $17 = $16+12;
    IHEAP[$17] = 0;
    var $18 = $f;
    var $19 = $18+44;
    IHEAP[$19] = 0;
    var $20 = $f;
    var $21 = $20+48;
    IHEAP[$21] = 0;
    var $22 = $f;
    var $23 = $22+36;
    IHEAP[$23] = 0;
    var $24 = $f;
    var $25 = $24+72;
    IHEAP[$25] = 0;
    var $26 = $f;
    var $27 = $26+28;
    IHEAP[$27] = 0;
    var $28 = $f;
    var $29 = $28+73;
    IHEAP[$29] = 0;
    var $30 = $f;
    var $31 = $30+74;
    IHEAP[$31] = 0;
    var $32 = $f;
    var $33 = $32+75;
    IHEAP[$33] = 0;
    var $34 = $f;
    var $35 = $34+20;
    IHEAP[$35] = 0;
    var $36 = $f;
    var $37 = $36+56;
    IHEAP[$37] = 0;
    var $38 = $f;
    var $39 = $38+24;
    IHEAP[$39] = 0;
    var $40 = $f;
    var $41 = $40+60;
    IHEAP[$41] = 0;
    var $42 = $f;
    var $43 = $42+64;
    IHEAP[$43] = 0;
    var $44 = $f;
    var $45 = $44+32;
    IHEAP[$45] = 0;
    var $46 = $f;
    ;
    return $46;
  }
  __Z13luaF_newprotoP9lua_State.__index__ = Runtime.getFunctionIndex(__Z13luaF_newprotoP9lua_State, "__Z13luaF_newprotoP9lua_State");
  
  
  function __Z14luaF_freeprotoP9lua_StateP5Proto($L, $f) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $L;
    $2 = $f;
    var $3 = $1;
    var $4 = $2;
    var $5 = $4+12;
    var $6 = IHEAP[$5];
    var $7 = $6;
    var $8 = $2;
    var $9 = $8+44;
    var $10 = IHEAP[$9];
    var $11 = $10 * 4;
    var $12 = __Z13luaM_realloc_P9lua_StatePvjj($3, $7, $11, 0);
    var $13 = $1;
    var $14 = $2;
    var $15 = $14+16;
    var $16 = IHEAP[$15];
    var $17 = $16;
    var $18 = $2;
    var $19 = $18+52;
    var $20 = IHEAP[$19];
    var $21 = $20 * 4;
    var $22 = __Z13luaM_realloc_P9lua_StatePvjj($13, $17, $21, 0);
    var $23 = $1;
    var $24 = $2;
    var $25 = $24+8;
    var $26 = IHEAP[$25];
    var $27 = $26;
    var $28 = $2;
    var $29 = $28+40;
    var $30 = IHEAP[$29];
    var $31 = $30 * 12;
    var $32 = __Z13luaM_realloc_P9lua_StatePvjj($23, $27, $31, 0);
    var $33 = $1;
    var $34 = $2;
    var $35 = $34+20;
    var $36 = IHEAP[$35];
    var $37 = $36;
    var $38 = $2;
    var $39 = $38+48;
    var $40 = IHEAP[$39];
    var $41 = $40 * 4;
    var $42 = __Z13luaM_realloc_P9lua_StatePvjj($33, $37, $41, 0);
    var $43 = $1;
    var $44 = $2;
    var $45 = $44+24;
    var $46 = IHEAP[$45];
    var $47 = $46;
    var $48 = $2;
    var $49 = $48+56;
    var $50 = IHEAP[$49];
    var $51 = $50 * 12;
    var $52 = __Z13luaM_realloc_P9lua_StatePvjj($43, $47, $51, 0);
    var $53 = $1;
    var $54 = $2;
    var $55 = $54+28;
    var $56 = IHEAP[$55];
    var $57 = $56;
    var $58 = $2;
    var $59 = $58+36;
    var $60 = IHEAP[$59];
    var $61 = $60 * 4;
    var $62 = __Z13luaM_realloc_P9lua_StatePvjj($53, $57, $61, 0);
    var $63 = $1;
    var $64 = $2;
    var $65 = $64;
    var $66 = __Z13luaM_realloc_P9lua_StatePvjj($63, $65, 76, 0);
    ;
    return;
  }
  __Z14luaF_freeprotoP9lua_StateP5Proto.__index__ = Runtime.getFunctionIndex(__Z14luaF_freeprotoP9lua_StateP5Proto, "__Z14luaF_freeprotoP9lua_StateP5Proto");
  
  
  function __Z16luaF_freeclosureP9lua_StateP7Closure($L, $c) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $size;
    $1 = $L;
    $2 = $c;
    var $3 = $2;
    var $4 = $3;
    var $5 = $4+6;
    var $6 = IHEAP[$5];
    var $7 = $6 != 0;
    ;
    if ($7) {
      ;
      var $9 = $2;
      var $10 = $9;
      var $11 = $10+7;
      var $12 = IHEAP[$11];
      var $13 = $12;
      var $14 = $13 - 1;
      var $15 = 12 * $14;
      var $16 = 32 + $15;
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $18 = $2;
      var $19 = $18;
      var $20 = $19;
      var $21 = $20+7;
      var $22 = IHEAP[$21];
      var $23 = $22;
      var $24 = $23 - 1;
      var $25 = 4 * $24;
      var $26 = 24 + $25;
      __lastLabel__ = 2; ;
    }
    var $28 = __lastLabel__ == 0 ? $16 : ($26);
    $size = $28;
    var $29 = $1;
    var $30 = $2;
    var $31 = $30;
    var $32 = $size;
    var $33 = __Z13luaM_realloc_P9lua_StatePvjj($29, $31, $32, 0);
    ;
    return;
  }
  __Z16luaF_freeclosureP9lua_StateP7Closure.__index__ = Runtime.getFunctionIndex(__Z16luaF_freeclosureP9lua_StateP7Closure, "__Z16luaF_freeclosureP9lua_StateP7Closure");
  
  
  function __Z17luaF_getlocalnamePK5Protoii($f, $local_number, $pc) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $4;
    var $i;
    $2 = $f;
    $3 = $local_number;
    $4 = $pc;
    $i = 0;
    ;
    $5$2: while(1) { // $5
      var $6 = $i;
      var $7 = $2;
      var $8 = $7+56;
      var $9 = IHEAP[$8];
      var $10 = $6 < $9;
      ;
      if ($10) {
        __lastLabel__ = 0; ;
        var $12 = $i;
        var $13 = $2;
        var $14 = $13+24;
        var $15 = IHEAP[$14];
        var $16 = $15+12*$12;
        var $17 = $16+4;
        var $18 = IHEAP[$17];
        var $19 = $4;
        var $20 = $18 <= $19;
        __lastLabel__ = 1; ;
      }
      else {
        __lastLabel__ = 0; ;
      }
      var $22 = __lastLabel__ == 0 ? 0 : ($20);
      if (!($22)) { __label__ = 4; /* $53 */ break $5$2; }
      var $24 = $4;
      var $25 = $i;
      var $26 = $2;
      var $27 = $26+24;
      var $28 = IHEAP[$27];
      var $29 = $28+12*$25;
      var $30 = $29+8;
      var $31 = IHEAP[$30];
      var $32 = $24 < $31;
      ;
      if ($32) {
        ;
        var $34 = $3;
        var $35 = $34 + -1;
        $3 = $35;
        var $36 = $3;
        var $37 = $36 == 0;
        if ($37) { __label__ = 5; /* $38 */ break $5$2; }
        ;
      }
      ;
      var $51 = $i;
      var $52 = $51 + 1;
      $i = $52;
      __label__ = 0; /* $5 */ continue $5$2;
    }
    if (__label__ == 4) {
      $1 = 0;
      ;
    }
    else if (__label__ == 5) {
      var $39 = $i;
      var $40 = $2;
      var $41 = $40+24;
      var $42 = IHEAP[$41];
      var $43 = $42+12*$39;
      var $44 = $43;
      var $45 = IHEAP[$44];
      var $46 = $45+16;
      var $47 = $46;
      $1 = $47;
      ;
    }
    var $55 = $1;
    ;
    return $55;
  }
  __Z17luaF_getlocalnamePK5Protoii.__index__ = Runtime.getFunctionIndex(__Z17luaF_getlocalnamePK5Protoii, "__Z17luaF_getlocalnamePK5Protoii");
  
  
  function __Z18luaC_separateudataP9lua_Statei($L, $all) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $g;
    var $deadmem;
    var $p;
    var $curr;
    $1 = $L;
    $2 = $all;
    var $3 = $1;
    var $4 = $3+16;
    var $5 = IHEAP[$4];
    $g = $5;
    $deadmem = 0;
    var $6 = $g;
    var $7 = $6+104;
    var $8 = IHEAP[$7];
    var $9 = $8;
    $p = $9;
    ;
    $10$2: while(1) { // $10
      var $11 = $p;
      var $12 = IHEAP[$11];
      $curr = $12;
      var $13 = $12 != 0;
      if (!($13)) { __label__ = 2; /* $158 */ break $10$2; }
      var $15 = $curr;
      var $16 = $15;
      var $17 = $16;
      var $18 = $17+5;
      var $19 = IHEAP[$18];
      var $20 = $19;
      var $21 = $20 & 3;
      var $22 = $21 != 0;
      ;
      $26$23$5: do { 
        if ($22) {
          __label__ = 3; /* $26 */ 
        }
        else {
          ;
          var $24 = $2;
          var $25 = $24 != 0;
          if ($25) { __label__ = 3; /* $26 */ break $26$23$5; } else { __label__ = 4; /* $36 */ break $26$23$5; }
        }
      } while(0);
      $26$36$7: do { 
        if (__label__ == 3) {
          var $27 = $curr;
          var $28 = $27;
          var $29 = $28;
          var $30 = $29;
          var $31 = $30+5;
          var $32 = IHEAP[$31];
          var $33 = $32;
          var $34 = $33 & 8;
          var $35 = $34 != 0;
          if ($35) { __label__ = 4; /* $36 */ break $26$36$7; }
          var $42 = $curr;
          var $43 = $42;
          var $44 = $43;
          var $45 = $44;
          var $46 = $45+8;
          var $47 = IHEAP[$46];
          var $48 = $47 == 0;
          ;
          if ($48) {
            ;
            __lastLabel__ = 7; ;
          }
          else {
            ;
            var $51 = $curr;
            var $52 = $51;
            var $53 = $52;
            var $54 = $53;
            var $55 = $54+8;
            var $56 = IHEAP[$55];
            var $57 = $56+6;
            var $58 = IHEAP[$57];
            var $59 = $58;
            var $60 = $59 & 4;
            var $61 = $60 != 0;
            ;
            if ($61) {
              ;
              __lastLabel__ = 9; ;
            }
            else {
              ;
              var $64 = $curr;
              var $65 = $64;
              var $66 = $65;
              var $67 = $66;
              var $68 = $67+8;
              var $69 = IHEAP[$68];
              var $70 = $1;
              var $71 = $70+16;
              var $72 = IHEAP[$71];
              var $73 = $72+168;
              var $74 = $73+8;
              var $75 = IHEAP[$74];
              var $76 = __Z10luaT_gettmP5Table3TMSP7TString($69, 2, $75);
              __lastLabel__ = 11; ;
            }
            var $78 = __lastLabel__ == 9 ? 0 : ($76);
            __lastLabel__ = 12; ;
          }
          var $80 = __lastLabel__ == 7 ? 0 : ($78);
          var $81 = $80 == 0;
          ;
          if ($81) {
            ;
            var $83 = $curr;
            var $84 = $83;
            var $85 = $84;
            var $86 = $85;
            var $87 = $86+5;
            var $88 = IHEAP[$87];
            var $89 = $88;
            var $90 = $89 | 8;
            var $91 = $90;
            IHEAP[$87] = $91;
            var $92 = $curr;
            var $93 = $92;
            var $94 = $93;
            var $95 = $94;
            $p = $95;
            ;
          }
          else {
            ;
            var $97 = $curr;
            var $98 = $97;
            var $99 = $98;
            var $100 = $99;
            var $101 = $100+16;
            var $102 = IHEAP[$101];
            var $103 = 20 + $102;
            var $104 = $deadmem;
            var $105 = $104 + $103;
            $deadmem = $105;
            var $106 = $curr;
            var $107 = $106;
            var $108 = $107;
            var $109 = $108;
            var $110 = $109+5;
            var $111 = IHEAP[$110];
            var $112 = $111;
            var $113 = $112 | 8;
            var $114 = $113;
            IHEAP[$110] = $114;
            var $115 = $curr;
            var $116 = $115;
            var $117 = $116;
            var $118 = $117;
            var $119 = IHEAP[$118];
            var $120 = $p;
            IHEAP[$120] = $119;
            var $121 = $g;
            var $122 = $121+48;
            var $123 = IHEAP[$122];
            var $124 = $123 == 0;
            ;
            if ($124) {
              ;
              var $126 = $curr;
              var $127 = $curr;
              var $128 = $127;
              var $129 = $128;
              var $130 = $129;
              IHEAP[$130] = $126;
              var $131 = $g;
              var $132 = $131+48;
              IHEAP[$132] = $126;
              ;
            }
            else {
              ;
              var $134 = $g;
              var $135 = $134+48;
              var $136 = IHEAP[$135];
              var $137 = $136;
              var $138 = $137;
              var $139 = $138;
              var $140 = IHEAP[$139];
              var $141 = $curr;
              var $142 = $141;
              var $143 = $142;
              var $144 = $143;
              IHEAP[$144] = $140;
              var $145 = $curr;
              var $146 = $g;
              var $147 = $146+48;
              var $148 = IHEAP[$147];
              var $149 = $148;
              var $150 = $149;
              var $151 = $150;
              IHEAP[$151] = $145;
              var $152 = $curr;
              var $153 = $g;
              var $154 = $153+48;
              IHEAP[$154] = $152;
              ;
            }
            ;
          }
          __label__ = 15; /* $157 */ break $26$36$7;
        }
      } while(0);
      if (__label__ == 4) {
        var $37 = $curr;
        var $38 = $37;
        var $39 = $38;
        var $40 = $39;
        $p = $40;
        ;
      }
      __label__ = 0; /* $10 */ continue $10$2;
    }
    var $159 = $deadmem;
    ;
    return $159;
  }
  __Z18luaC_separateudataP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z18luaC_separateudataP9lua_Statei, "__Z18luaC_separateudataP9lua_Statei");
  
  
  function __Z13luaC_callGCTMP9lua_State($L) {
    ;
    var __label__;
    var $1;
    $1 = $L;
    ;
    $2$2: while(1) { // $2
      var $3 = $1;
      var $4 = $3+16;
      var $5 = IHEAP[$4];
      var $6 = $5+48;
      var $7 = IHEAP[$6];
      var $8 = $7 != 0;
      if (!($8)) { __label__ = 2; /* $11 */ break $2$2; }
      var $10 = $1;
      __Z4GCTMP9lua_State($10);
      __label__ = 0; /* $2 */ continue $2$2;
    }
    ;
    return;
  }
  __Z13luaC_callGCTMP9lua_State.__index__ = Runtime.getFunctionIndex(__Z13luaC_callGCTMP9lua_State, "__Z13luaC_callGCTMP9lua_State");
  
  
  function __Z4GCTMP9lua_State($L) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $g;
    var $o;
    var $udata;
    var $tm;
    var $oldah;
    var $oldt;
    var $o2;
    var $o1;
    var $i_o;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+16;
    var $4 = IHEAP[$3];
    $g = $4;
    var $5 = $g;
    var $6 = $5+48;
    var $7 = IHEAP[$6];
    var $8 = $7;
    var $9 = $8;
    var $10 = $9;
    var $11 = IHEAP[$10];
    $o = $11;
    var $12 = $o;
    var $13 = $12;
    var $14 = $13;
    $udata = $14;
    var $15 = $o;
    var $16 = $g;
    var $17 = $16+48;
    var $18 = IHEAP[$17];
    var $19 = $15 == $18;
    ;
    if ($19) {
      ;
      var $21 = $g;
      var $22 = $21+48;
      IHEAP[$22] = 0;
      ;
    }
    else {
      ;
      var $24 = $udata;
      var $25 = $24;
      var $26 = $25;
      var $27 = IHEAP[$26];
      var $28 = $g;
      var $29 = $28+48;
      var $30 = IHEAP[$29];
      var $31 = $30;
      var $32 = $31;
      var $33 = $32;
      IHEAP[$33] = $27;
      ;
    }
    var $35 = $g;
    var $36 = $35+104;
    var $37 = IHEAP[$36];
    var $38 = $37;
    var $39 = IHEAP[$38];
    var $40 = $udata;
    var $41 = $40;
    var $42 = $41;
    IHEAP[$42] = $39;
    var $43 = $o;
    var $44 = $g;
    var $45 = $44+104;
    var $46 = IHEAP[$45];
    var $47 = $46;
    IHEAP[$47] = $43;
    var $48 = $o;
    var $49 = $48;
    var $50 = $49;
    var $51 = $50+5;
    var $52 = IHEAP[$51];
    var $53 = $52;
    var $54 = $53 & 248;
    var $55 = $g;
    var $56 = $55+20;
    var $57 = IHEAP[$56];
    var $58 = $57;
    var $59 = $58 & 3;
    var $60 = $59;
    var $61 = $60;
    var $62 = $54 | $61;
    var $63 = $62;
    var $64 = $o;
    var $65 = $64;
    var $66 = $65;
    var $67 = $66+5;
    IHEAP[$67] = $63;
    var $68 = $udata;
    var $69 = $68;
    var $70 = $69+8;
    var $71 = IHEAP[$70];
    var $72 = $71 == 0;
    ;
    if ($72) {
      ;
      __lastLabel__ = 1; ;
    }
    else {
      ;
      var $75 = $udata;
      var $76 = $75;
      var $77 = $76+8;
      var $78 = IHEAP[$77];
      var $79 = $78+6;
      var $80 = IHEAP[$79];
      var $81 = $80;
      var $82 = $81 & 4;
      var $83 = $82 != 0;
      ;
      if ($83) {
        ;
        __lastLabel__ = 3; ;
      }
      else {
        ;
        var $86 = $udata;
        var $87 = $86;
        var $88 = $87+8;
        var $89 = IHEAP[$88];
        var $90 = $1;
        var $91 = $90+16;
        var $92 = IHEAP[$91];
        var $93 = $92+168;
        var $94 = $93+8;
        var $95 = IHEAP[$94];
        var $96 = __Z10luaT_gettmP5Table3TMSP7TString($89, 2, $95);
        __lastLabel__ = 5; ;
      }
      var $98 = __lastLabel__ == 3 ? 0 : ($96);
      __lastLabel__ = 6; ;
    }
    var $100 = __lastLabel__ == 1 ? 0 : ($98);
    $tm = $100;
    var $101 = $tm;
    var $102 = $101 != 0;
    ;
    if ($102) {
      ;
      var $104 = $1;
      var $105 = $104+57;
      var $106 = IHEAP[$105];
      $oldah = $106;
      var $107 = $g;
      var $108 = $107+64;
      var $109 = IHEAP[$108];
      $oldt = $109;
      var $110 = $1;
      var $111 = $110+57;
      IHEAP[$111] = 0;
      var $112 = $g;
      var $113 = $112+68;
      var $114 = IHEAP[$113];
      var $115 = 2 * $114;
      var $116 = $g;
      var $117 = $116+64;
      IHEAP[$117] = $115;
      var $118 = $tm;
      $o2 = $118;
      var $119 = $1;
      var $120 = $119+8;
      var $121 = IHEAP[$120];
      $o1 = $121;
      var $122 = $o1;
      var $123 = $122;
      var $124 = $o2;
      var $125 = $124;
      var $126 = $123;
      var $127 = $125;
      _llvm_memcpy_p0i8_p0i8_i32($126, $127, 8, 4, 0);
      var $128 = $o2;
      var $129 = $128+8;
      var $130 = IHEAP[$129];
      var $131 = $o1;
      var $132 = $131+8;
      IHEAP[$132] = $130;
      var $133 = $1;
      var $134 = $133+8;
      var $135 = IHEAP[$134];
      var $136 = $135+12;
      $i_o = $136;
      var $137 = $udata;
      var $138 = $137;
      var $139 = $i_o;
      var $140 = $139;
      var $141 = $140;
      var $142 = $141;
      IHEAP[$142] = $138;
      var $143 = $i_o;
      var $144 = $143+8;
      IHEAP[$144] = 7;
      var $145 = $1;
      var $146 = $145+8;
      var $147 = IHEAP[$146];
      var $148 = $147+24;
      IHEAP[$146] = $148;
      var $149 = $1;
      var $150 = $1;
      var $151 = $150+8;
      var $152 = IHEAP[$151];
      var $153 = $152+-24;
      __Z9luaD_callP9lua_StateP10lua_TValuei($149, $153, 0);
      var $154 = $oldah;
      var $155 = $1;
      var $156 = $155+57;
      IHEAP[$156] = $154;
      var $157 = $oldt;
      var $158 = $g;
      var $159 = $158+64;
      IHEAP[$159] = $157;
      ;
    }
    ;
    return;
  }
  __Z4GCTMP9lua_State.__index__ = Runtime.getFunctionIndex(__Z4GCTMP9lua_State, "__Z4GCTMP9lua_State");
  
  
  function __Z12luaC_freeallP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $g;
    var $i;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+16;
    var $4 = IHEAP[$3];
    $g = $4;
    var $5 = $g;
    var $6 = $5+20;
    IHEAP[$6] = 67;
    var $7 = $1;
    var $8 = $g;
    var $9 = $8+28;
    var $10 = __Z9sweeplistP9lua_StatePP8GCObjectj($7, $9, -3);
    $i = 0;
    ;
    $11$2: while(1) { // $11
      var $12 = $i;
      var $13 = $g;
      var $14 = $13;
      var $15 = $14+8;
      var $16 = IHEAP[$15];
      var $17 = $12 < $16;
      if (!($17)) { __label__ = 2; /* $30 */ break $11$2; }
      var $19 = $1;
      var $20 = $i;
      var $21 = $g;
      var $22 = $21;
      var $23 = $22;
      var $24 = IHEAP[$23];
      var $25 = $24+4*$20;
      var $26 = __Z9sweeplistP9lua_StatePP8GCObjectj($19, $25, -3);
      ;
      var $28 = $i;
      var $29 = $28 + 1;
      $i = $29;
      __label__ = 0; /* $11 */ continue $11$2;
    }
    ;
    return;
  }
  __Z12luaC_freeallP9lua_State.__index__ = Runtime.getFunctionIndex(__Z12luaC_freeallP9lua_State, "__Z12luaC_freeallP9lua_State");
  
  
  function __Z9sweeplistP9lua_StatePP8GCObjectj($L, $p, $count) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $curr;
    var $g;
    var $deadmask;
    $1 = $L;
    $2 = $p;
    $3 = $count;
    var $4 = $1;
    var $5 = $4+16;
    var $6 = IHEAP[$5];
    $g = $6;
    var $7 = $g;
    var $8 = $7+20;
    var $9 = IHEAP[$8];
    var $10 = $9;
    var $11 = $10 ^ 3;
    $deadmask = $11;
    ;
    $12$2: while(1) { // $12
      var $13 = $2;
      var $14 = IHEAP[$13];
      $curr = $14;
      var $15 = $14 != 0;
      ;
      if ($15) {
        __lastLabel__ = 0; ;
        var $17 = $3;
        var $18 = $17 + -1;
        $3 = $18;
        var $19 = unSign($17, 32) > unSign(0, 32);
        __lastLabel__ = 1; ;
      }
      else {
        __lastLabel__ = 0; ;
      }
      var $21 = __lastLabel__ == 0 ? 0 : ($19);
      if (!($21)) { __label__ = 4; /* $96 */ break $12$2; }
      var $23 = $curr;
      var $24 = $23;
      var $25 = $24;
      var $26 = $25+4;
      var $27 = IHEAP[$26];
      var $28 = $27;
      var $29 = $28 == 8;
      ;
      if ($29) {
        ;
        var $31 = $1;
        var $32 = $curr;
        var $33 = $32;
        var $34 = $33+96;
        var $35 = __Z9sweeplistP9lua_StatePP8GCObjectj($31, $34, -3);
        ;
      }
      var $37 = $curr;
      var $38 = $37;
      var $39 = $38;
      var $40 = $39+5;
      var $41 = IHEAP[$40];
      var $42 = $41;
      var $43 = $42 ^ 3;
      var $44 = $deadmask;
      var $45 = $43 & $44;
      var $46 = $45 != 0;
      ;
      if ($46) {
        ;
        var $48 = $curr;
        var $49 = $48;
        var $50 = $49;
        var $51 = $50+5;
        var $52 = IHEAP[$51];
        var $53 = $52;
        var $54 = $53 & 248;
        var $55 = $g;
        var $56 = $55+20;
        var $57 = IHEAP[$56];
        var $58 = $57;
        var $59 = $58 & 3;
        var $60 = $59;
        var $61 = $60;
        var $62 = $54 | $61;
        var $63 = $62;
        var $64 = $curr;
        var $65 = $64;
        var $66 = $65;
        var $67 = $66+5;
        IHEAP[$67] = $63;
        var $68 = $curr;
        var $69 = $68;
        var $70 = $69;
        var $71 = $70;
        $2 = $71;
        ;
      }
      else {
        ;
        var $73 = $curr;
        var $74 = $73;
        var $75 = $74;
        var $76 = $75;
        var $77 = IHEAP[$76];
        var $78 = $2;
        IHEAP[$78] = $77;
        var $79 = $curr;
        var $80 = $g;
        var $81 = $80+28;
        var $82 = IHEAP[$81];
        var $83 = $79 == $82;
        ;
        if ($83) {
          ;
          var $85 = $curr;
          var $86 = $85;
          var $87 = $86;
          var $88 = $87;
          var $89 = IHEAP[$88];
          var $90 = $g;
          var $91 = $90+28;
          IHEAP[$91] = $89;
          ;
        }
        var $93 = $1;
        var $94 = $curr;
        __Z7freeobjP9lua_StateP8GCObject($93, $94);
        ;
      }
      __label__ = 0; /* $12 */ continue $12$2;
    }
    var $97 = $2;
    ;
    return $97;
  }
  __Z9sweeplistP9lua_StatePP8GCObjectj.__index__ = Runtime.getFunctionIndex(__Z9sweeplistP9lua_StatePP8GCObjectj, "__Z9sweeplistP9lua_StatePP8GCObjectj");
  
  
  function __Z9luaC_stepP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $g;
    var $lim;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+16;
    var $4 = IHEAP[$3];
    $g = $4;
    var $5 = $g;
    var $6 = $5+84;
    var $7 = IHEAP[$6];
    var $8 = 10 * $7;
    $lim = $8;
    var $9 = $lim;
    var $10 = $9 == 0;
    ;
    if ($10) {
      ;
      $lim = 2147483646;
      ;
    }
    var $13 = $g;
    var $14 = $13+68;
    var $15 = IHEAP[$14];
    var $16 = $g;
    var $17 = $16+64;
    var $18 = IHEAP[$17];
    var $19 = $15 - $18;
    var $20 = $g;
    var $21 = $20+76;
    var $22 = IHEAP[$21];
    var $23 = $22 + $19;
    IHEAP[$21] = $23;
    ;
    $24$5: while(1) { // $24
      var $25 = $1;
      var $26 = __Z10singlestepP9lua_State($25);
      var $27 = $lim;
      var $28 = $27 - $26;
      $lim = $28;
      var $29 = $g;
      var $30 = $29+21;
      var $31 = IHEAP[$30];
      var $32 = $31;
      var $33 = $32 == 0;
      if ($33) { __label__ = 2; /* $34 */ break $24$5; }
      ;
      var $37 = $lim;
      var $38 = $37 > 0;
      if ($38) { __label__ = 1; /* $24 */ continue $24$5; } else { __label__ = 6; /* $39 */ break $24$5; }
    }
    if (__label__ == 2) {
      ;
    }
    var $40 = $g;
    var $41 = $40+21;
    var $42 = IHEAP[$41];
    var $43 = $42;
    var $44 = $43 != 0;
    ;
    if ($44) {
      ;
      var $46 = $g;
      var $47 = $46+76;
      var $48 = IHEAP[$47];
      var $49 = unSign($48, 32) < unSign(1024, 32);
      ;
      if ($49) {
        ;
        var $51 = $g;
        var $52 = $51+68;
        var $53 = IHEAP[$52];
        var $54 = $53 + 1024;
        var $55 = $g;
        var $56 = $55+64;
        IHEAP[$56] = $54;
        ;
      }
      else {
        ;
        var $58 = $g;
        var $59 = $58+76;
        var $60 = IHEAP[$59];
        var $61 = $60 - 1024;
        IHEAP[$59] = $61;
        var $62 = $g;
        var $63 = $62+68;
        var $64 = IHEAP[$63];
        var $65 = $g;
        var $66 = $65+64;
        IHEAP[$66] = $64;
        ;
      }
      ;
    }
    else {
      ;
      var $69 = $g;
      var $70 = $69+72;
      var $71 = IHEAP[$70];
      var $72 = Math.floor(unSign($71, 32) / unSign(100, 32));
      var $73 = $g;
      var $74 = $73+80;
      var $75 = IHEAP[$74];
      var $76 = $72 * $75;
      var $77 = $g;
      var $78 = $77+64;
      IHEAP[$78] = $76;
      ;
    }
    ;
    return;
  }
  __Z9luaC_stepP9lua_State.__index__ = Runtime.getFunctionIndex(__Z9luaC_stepP9lua_State, "__Z9luaC_stepP9lua_State");
  
  
  function __Z10singlestepP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $2;
    var $g;
    var $old;
    var $old1;
    $2 = $L;
    var $3 = $2;
    var $4 = $3+16;
    var $5 = IHEAP[$4];
    $g = $5;
    var $6 = $g;
    var $7 = $6+21;
    var $8 = IHEAP[$7];
    var $9 = $8;
    if ($9 == 0) {
      __label__ = 4; /* $10 */ 
    }
    else if ($9 == 1) {
      __label__ = 5; /* $12 */ 
    }
    else if ($9 == 2) {
      __label__ = 6; /* $22 */ 
    }
    else if ($9 == 3) {
      __label__ = 7; /* $58 */ 
    }
    else if ($9 == 4) {
      __label__ = 8; /* $88 */ 
    }
    else {
    __label__ = 9; /* $110 */ 
    }
    
    if (__label__ == 9) {
      $1 = 0;
      ;
    }
    else if (__label__ == 4) {
      var $11 = $2;
      __Z8markrootP9lua_State($11);
      $1 = 0;
      ;
    }
    else if (__label__ == 5) {
      var $13 = $g;
      var $14 = $13+36;
      var $15 = IHEAP[$14];
      var $16 = $15 != 0;
      ;
      if ($16) {
        ;
        var $18 = $g;
        var $19 = __Z13propagatemarkP12global_State($18);
        $1 = $19;
        ;
      }
      else {
        ;
        var $21 = $2;
        __Z6atomicP9lua_State($21);
        $1 = 0;
        ;
      }
    }
    else if (__label__ == 6) {
      var $23 = $g;
      var $24 = $23+68;
      var $25 = IHEAP[$24];
      $old = $25;
      var $26 = $2;
      var $27 = $g;
      var $28 = $27+24;
      var $29 = IHEAP[$28];
      var $30 = $29 + 1;
      IHEAP[$28] = $30;
      var $31 = $g;
      var $32 = $31;
      var $33 = $32;
      var $34 = IHEAP[$33];
      var $35 = $34+4*$29;
      var $36 = __Z9sweeplistP9lua_StatePP8GCObjectj($26, $35, -3);
      var $37 = $g;
      var $38 = $37+24;
      var $39 = IHEAP[$38];
      var $40 = $g;
      var $41 = $40;
      var $42 = $41+8;
      var $43 = IHEAP[$42];
      var $44 = $39 >= $43;
      ;
      if ($44) {
        ;
        var $46 = $g;
        var $47 = $46+21;
        IHEAP[$47] = 3;
        ;
      }
      var $49 = $old;
      var $50 = $g;
      var $51 = $50+68;
      var $52 = IHEAP[$51];
      var $53 = $49 - $52;
      var $54 = $g;
      var $55 = $54+72;
      var $56 = IHEAP[$55];
      var $57 = $56 - $53;
      IHEAP[$55] = $57;
      $1 = 10;
      ;
    }
    else if (__label__ == 7) {
      var $59 = $g;
      var $60 = $59+68;
      var $61 = IHEAP[$60];
      $old1 = $61;
      var $62 = $2;
      var $63 = $g;
      var $64 = $63+32;
      var $65 = IHEAP[$64];
      var $66 = __Z9sweeplistP9lua_StatePP8GCObjectj($62, $65, 40);
      var $67 = $g;
      var $68 = $67+32;
      IHEAP[$68] = $66;
      var $69 = $g;
      var $70 = $69+32;
      var $71 = IHEAP[$70];
      var $72 = IHEAP[$71];
      var $73 = $72 == 0;
      ;
      if ($73) {
        ;
        var $75 = $2;
        __Z10checkSizesP9lua_State($75);
        var $76 = $g;
        var $77 = $76+21;
        IHEAP[$77] = 4;
        ;
      }
      var $79 = $old1;
      var $80 = $g;
      var $81 = $80+68;
      var $82 = IHEAP[$81];
      var $83 = $79 - $82;
      var $84 = $g;
      var $85 = $84+72;
      var $86 = IHEAP[$85];
      var $87 = $86 - $83;
      IHEAP[$85] = $87;
      $1 = 400;
      ;
    }
    else if (__label__ == 8) {
      var $89 = $g;
      var $90 = $89+48;
      var $91 = IHEAP[$90];
      var $92 = $91 != 0;
      ;
      if ($92) {
        ;
        var $94 = $2;
        __Z4GCTMP9lua_State($94);
        var $95 = $g;
        var $96 = $95+72;
        var $97 = IHEAP[$96];
        var $98 = unSign($97, 32) > unSign(100, 32);
        ;
        if ($98) {
          ;
          var $100 = $g;
          var $101 = $100+72;
          var $102 = IHEAP[$101];
          var $103 = $102 - 100;
          IHEAP[$101] = $103;
          ;
        }
        $1 = 100;
        ;
      }
      else {
        ;
        var $106 = $g;
        var $107 = $106+21;
        IHEAP[$107] = 0;
        var $108 = $g;
        var $109 = $108+76;
        IHEAP[$109] = 0;
        $1 = 0;
        ;
      }
    }
    var $112 = $1;
    ;
    return $112;
  }
  __Z10singlestepP9lua_State.__index__ = Runtime.getFunctionIndex(__Z10singlestepP9lua_State, "__Z10singlestepP9lua_State");
  
  
  function __Z11luaC_fullgcP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $g;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+16;
    var $4 = IHEAP[$3];
    $g = $4;
    var $5 = $g;
    var $6 = $5+21;
    var $7 = IHEAP[$6];
    var $8 = $7;
    var $9 = $8 <= 1;
    ;
    if ($9) {
      ;
      var $11 = $g;
      var $12 = $11+24;
      IHEAP[$12] = 0;
      var $13 = $g;
      var $14 = $13+28;
      var $15 = $g;
      var $16 = $15+32;
      IHEAP[$16] = $14;
      var $17 = $g;
      var $18 = $17+36;
      IHEAP[$18] = 0;
      var $19 = $g;
      var $20 = $19+40;
      IHEAP[$20] = 0;
      var $21 = $g;
      var $22 = $21+44;
      IHEAP[$22] = 0;
      var $23 = $g;
      var $24 = $23+21;
      IHEAP[$24] = 2;
      ;
    }
    ;
    $26$5: while(1) { // $26
      var $27 = $g;
      var $28 = $27+21;
      var $29 = IHEAP[$28];
      var $30 = $29;
      var $31 = $30 != 4;
      if (!($31)) { __label__ = 3; /* $35 */ break $26$5; }
      var $33 = $1;
      var $34 = __Z10singlestepP9lua_State($33);
      __label__ = 1; /* $26 */ continue $26$5;
    }
    var $36 = $1;
    __Z8markrootP9lua_State($36);
    ;
    $37$9: while(1) { // $37
      var $38 = $g;
      var $39 = $38+21;
      var $40 = IHEAP[$39];
      var $41 = $40;
      var $42 = $41 != 0;
      if (!($42)) { __label__ = 6; /* $46 */ break $37$9; }
      var $44 = $1;
      var $45 = __Z10singlestepP9lua_State($44);
      __label__ = 4; /* $37 */ continue $37$9;
    }
    var $47 = $g;
    var $48 = $47+72;
    var $49 = IHEAP[$48];
    var $50 = Math.floor(unSign($49, 32) / unSign(100, 32));
    var $51 = $g;
    var $52 = $51+80;
    var $53 = IHEAP[$52];
    var $54 = $50 * $53;
    var $55 = $g;
    var $56 = $55+64;
    IHEAP[$56] = $54;
    ;
    return;
  }
  __Z11luaC_fullgcP9lua_State.__index__ = Runtime.getFunctionIndex(__Z11luaC_fullgcP9lua_State, "__Z11luaC_fullgcP9lua_State");
  
  
  function __Z8markrootP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $g;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+16;
    var $4 = IHEAP[$3];
    $g = $4;
    var $5 = $g;
    var $6 = $5+36;
    IHEAP[$6] = 0;
    var $7 = $g;
    var $8 = $7+40;
    IHEAP[$8] = 0;
    var $9 = $g;
    var $10 = $9+44;
    IHEAP[$10] = 0;
    var $11 = $g;
    var $12 = $11+104;
    var $13 = IHEAP[$12];
    var $14 = $13;
    var $15 = $14;
    var $16 = $15;
    var $17 = $16+5;
    var $18 = IHEAP[$17];
    var $19 = $18;
    var $20 = $19 & 3;
    var $21 = $20 != 0;
    ;
    if ($21) {
      ;
      var $23 = $g;
      var $24 = $g;
      var $25 = $24+104;
      var $26 = IHEAP[$25];
      var $27 = $26;
      __Z16reallymarkobjectP12global_StateP8GCObject($23, $27);
      ;
    }
    var $29 = $g;
    var $30 = $29+104;
    var $31 = IHEAP[$30];
    var $32 = $31+72;
    var $33 = $32+8;
    var $34 = IHEAP[$33];
    var $35 = $34 >= 4;
    ;
    $36$62$5: do { 
      if ($35) {
        ;
        var $37 = $g;
        var $38 = $37+104;
        var $39 = IHEAP[$38];
        var $40 = $39+72;
        var $41 = $40;
        var $42 = $41;
        var $43 = $42;
        var $44 = IHEAP[$43];
        var $45 = $44;
        var $46 = $45;
        var $47 = $46+5;
        var $48 = IHEAP[$47];
        var $49 = $48;
        var $50 = $49 & 3;
        var $51 = $50 != 0;
        if (!($51)) { __label__ = 2; /* $62 */ break $36$62$5; }
        var $53 = $g;
        var $54 = $g;
        var $55 = $54+104;
        var $56 = IHEAP[$55];
        var $57 = $56+72;
        var $58 = $57;
        var $59 = $58;
        var $60 = $59;
        var $61 = IHEAP[$60];
        __Z16reallymarkobjectP12global_StateP8GCObject($53, $61);
        ;
      }
    } while(0);
    var $63 = $1;
    var $64 = $63+16;
    var $65 = IHEAP[$64];
    var $66 = $65+92;
    var $67 = $66+8;
    var $68 = IHEAP[$67];
    var $69 = $68 >= 4;
    ;
    $70$96$9: do { 
      if ($69) {
        ;
        var $71 = $1;
        var $72 = $71+16;
        var $73 = IHEAP[$72];
        var $74 = $73+92;
        var $75 = $74;
        var $76 = $75;
        var $77 = $76;
        var $78 = IHEAP[$77];
        var $79 = $78;
        var $80 = $79;
        var $81 = $80+5;
        var $82 = IHEAP[$81];
        var $83 = $82;
        var $84 = $83 & 3;
        var $85 = $84 != 0;
        if (!($85)) { __label__ = 5; /* $96 */ break $70$96$9; }
        var $87 = $g;
        var $88 = $1;
        var $89 = $88+16;
        var $90 = IHEAP[$89];
        var $91 = $90+92;
        var $92 = $91;
        var $93 = $92;
        var $94 = $93;
        var $95 = IHEAP[$94];
        __Z16reallymarkobjectP12global_StateP8GCObject($87, $95);
        ;
      }
    } while(0);
    var $97 = $g;
    __Z6markmtP12global_State($97);
    var $98 = $g;
    var $99 = $98+21;
    IHEAP[$99] = 1;
    ;
    return;
  }
  __Z8markrootP9lua_State.__index__ = Runtime.getFunctionIndex(__Z8markrootP9lua_State, "__Z8markrootP9lua_State");
  
  
  function __Z13luaC_barrierfP9lua_StateP8GCObjectS2_($L, $o, $v) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $g;
    $1 = $L;
    $2 = $o;
    $3 = $v;
    var $4 = $1;
    var $5 = $4+16;
    var $6 = IHEAP[$5];
    $g = $6;
    var $7 = $g;
    var $8 = $7+21;
    var $9 = IHEAP[$8];
    var $10 = $9;
    var $11 = $10 == 1;
    ;
    if ($11) {
      ;
      var $13 = $g;
      var $14 = $3;
      __Z16reallymarkobjectP12global_StateP8GCObject($13, $14);
      ;
    }
    else {
      ;
      var $16 = $2;
      var $17 = $16;
      var $18 = $17;
      var $19 = $18+5;
      var $20 = IHEAP[$19];
      var $21 = $20;
      var $22 = $21 & 248;
      var $23 = $g;
      var $24 = $23+20;
      var $25 = IHEAP[$24];
      var $26 = $25;
      var $27 = $26 & 3;
      var $28 = $27;
      var $29 = $28;
      var $30 = $22 | $29;
      var $31 = $30;
      var $32 = $2;
      var $33 = $32;
      var $34 = $33;
      var $35 = $34+5;
      IHEAP[$35] = $31;
      ;
    }
    ;
    return;
  }
  __Z13luaC_barrierfP9lua_StateP8GCObjectS2_.__index__ = Runtime.getFunctionIndex(__Z13luaC_barrierfP9lua_StateP8GCObjectS2_, "__Z13luaC_barrierfP9lua_StateP8GCObjectS2_");
  
  
  function __Z16reallymarkobjectP12global_StateP8GCObject($g, $o) {
    ;
    var __label__;
    var $1;
    var $2;
    var $mt;
    var $uv;
    $1 = $g;
    $2 = $o;
    var $3 = $2;
    var $4 = $3;
    var $5 = $4;
    var $6 = $5+5;
    var $7 = IHEAP[$6];
    var $8 = $7;
    var $9 = $8 & 252;
    var $10 = $9;
    IHEAP[$6] = $10;
    var $11 = $2;
    var $12 = $11;
    var $13 = $12;
    var $14 = $13+4;
    var $15 = IHEAP[$14];
    var $16 = $15;
    if ($16 == 4) {
      __label__ = 8; /* $17 */ 
    }
    else if ($16 == 7) {
      __label__ = 9; /* $18 */ 
    }
    else if ($16 == 10) {
      __label__ = 10; /* $75 */ 
    }
    else if ($16 == 6) {
      __label__ = 11; /* $127 */ 
    }
    else if ($16 == 5) {
      __label__ = 12; /* $139 */ 
    }
    else if ($16 == 8) {
      __label__ = 13; /* $150 */ 
    }
    else if ($16 == 9) {
      __label__ = 14; /* $160 */ 
    }
    else {
    __label__ = 15; /* $171 */ 
    }
    
    if (__label__ == 15) {
      ;
    }
    else if (__label__ == 8) {
      ;
    }
    else if (__label__ == 9) {
      var $19 = $2;
      var $20 = $19;
      var $21 = $20;
      var $22 = $21;
      var $23 = $22+8;
      var $24 = IHEAP[$23];
      $mt = $24;
      var $25 = $2;
      var $26 = $25;
      var $27 = $26;
      var $28 = $27+5;
      var $29 = IHEAP[$28];
      var $30 = $29;
      var $31 = $30 | 4;
      var $32 = $31;
      IHEAP[$28] = $32;
      var $33 = $mt;
      var $34 = $33 != 0;
      ;
      if ($34) {
        ;
        var $36 = $mt;
        var $37 = $36;
        var $38 = $37;
        var $39 = $38;
        var $40 = $39+5;
        var $41 = IHEAP[$40];
        var $42 = $41;
        var $43 = $42 & 3;
        var $44 = $43 != 0;
        ;
        if ($44) {
          ;
          var $46 = $1;
          var $47 = $mt;
          var $48 = $47;
          __Z16reallymarkobjectP12global_StateP8GCObject($46, $48);
          ;
        }
        ;
      }
      var $51 = $2;
      var $52 = $51;
      var $53 = $52;
      var $54 = $53;
      var $55 = $54+12;
      var $56 = IHEAP[$55];
      var $57 = $56;
      var $58 = $57;
      var $59 = $58;
      var $60 = $59+5;
      var $61 = IHEAP[$60];
      var $62 = $61;
      var $63 = $62 & 3;
      var $64 = $63 != 0;
      ;
      if ($64) {
        ;
        var $66 = $1;
        var $67 = $2;
        var $68 = $67;
        var $69 = $68;
        var $70 = $69;
        var $71 = $70+12;
        var $72 = IHEAP[$71];
        var $73 = $72;
        __Z16reallymarkobjectP12global_StateP8GCObject($66, $73);
        ;
      }
      ;
    }
    else if (__label__ == 10) {
      var $76 = $2;
      var $77 = $76;
      var $78 = $77;
      $uv = $78;
      var $79 = $uv;
      var $80 = $79+8;
      var $81 = IHEAP[$80];
      var $82 = $81+8;
      var $83 = IHEAP[$82];
      var $84 = $83 >= 4;
      ;
      $85$109$16: do { 
        if ($84) {
          ;
          var $86 = $uv;
          var $87 = $86+8;
          var $88 = IHEAP[$87];
          var $89 = $88;
          var $90 = $89;
          var $91 = $90;
          var $92 = IHEAP[$91];
          var $93 = $92;
          var $94 = $93;
          var $95 = $94+5;
          var $96 = IHEAP[$95];
          var $97 = $96;
          var $98 = $97 & 3;
          var $99 = $98 != 0;
          if (!($99)) { __label__ = 5; /* $109 */ break $85$109$16; }
          var $101 = $1;
          var $102 = $uv;
          var $103 = $102+8;
          var $104 = IHEAP[$103];
          var $105 = $104;
          var $106 = $105;
          var $107 = $106;
          var $108 = IHEAP[$107];
          __Z16reallymarkobjectP12global_StateP8GCObject($101, $108);
          ;
        }
      } while(0);
      var $110 = $uv;
      var $111 = $110+8;
      var $112 = IHEAP[$111];
      var $113 = $uv;
      var $114 = $113+12;
      var $115 = $114;
      var $116 = $112 == $115;
      ;
      if ($116) {
        ;
        var $118 = $2;
        var $119 = $118;
        var $120 = $119;
        var $121 = $120+5;
        var $122 = IHEAP[$121];
        var $123 = $122;
        var $124 = $123 | 4;
        var $125 = $124;
        IHEAP[$121] = $125;
        ;
      }
      ;
    }
    else if (__label__ == 11) {
      var $128 = $1;
      var $129 = $128+36;
      var $130 = IHEAP[$129];
      var $131 = $2;
      var $132 = $131;
      var $133 = $132;
      var $134 = $133;
      var $135 = $134+8;
      IHEAP[$135] = $130;
      var $136 = $2;
      var $137 = $1;
      var $138 = $137+36;
      IHEAP[$138] = $136;
      ;
    }
    else if (__label__ == 12) {
      var $140 = $1;
      var $141 = $140+36;
      var $142 = IHEAP[$141];
      var $143 = $2;
      var $144 = $143;
      var $145 = $144;
      var $146 = $145+24;
      IHEAP[$146] = $142;
      var $147 = $2;
      var $148 = $1;
      var $149 = $148+36;
      IHEAP[$149] = $147;
      ;
    }
    else if (__label__ == 13) {
      var $151 = $1;
      var $152 = $151+36;
      var $153 = IHEAP[$152];
      var $154 = $2;
      var $155 = $154;
      var $156 = $155+100;
      IHEAP[$156] = $153;
      var $157 = $2;
      var $158 = $1;
      var $159 = $158+36;
      IHEAP[$159] = $157;
      ;
    }
    else if (__label__ == 14) {
      var $161 = $1;
      var $162 = $161+36;
      var $163 = IHEAP[$162];
      var $164 = $2;
      var $165 = $164;
      var $166 = $165;
      var $167 = $166+68;
      IHEAP[$167] = $163;
      var $168 = $2;
      var $169 = $1;
      var $170 = $169+36;
      IHEAP[$170] = $168;
      ;
    }
    ;
    return;
  }
  __Z16reallymarkobjectP12global_StateP8GCObject.__index__ = Runtime.getFunctionIndex(__Z16reallymarkobjectP12global_StateP8GCObject, "__Z16reallymarkobjectP12global_StateP8GCObject");
  
  
  function __Z16luaC_barrierbackP9lua_StateP5Table($L, $t) {
    ;
    var __label__;
    var $1;
    var $2;
    var $g;
    var $o;
    $1 = $L;
    $2 = $t;
    var $3 = $1;
    var $4 = $3+16;
    var $5 = IHEAP[$4];
    $g = $5;
    var $6 = $2;
    var $7 = $6;
    $o = $7;
    var $8 = $o;
    var $9 = $8;
    var $10 = $9;
    var $11 = $10+5;
    var $12 = IHEAP[$11];
    var $13 = $12;
    var $14 = $13 & 251;
    var $15 = $14;
    IHEAP[$11] = $15;
    var $16 = $g;
    var $17 = $16+40;
    var $18 = IHEAP[$17];
    var $19 = $2;
    var $20 = $19+24;
    IHEAP[$20] = $18;
    var $21 = $o;
    var $22 = $g;
    var $23 = $22+40;
    IHEAP[$23] = $21;
    ;
    return;
  }
  __Z16luaC_barrierbackP9lua_StateP5Table.__index__ = Runtime.getFunctionIndex(__Z16luaC_barrierbackP9lua_StateP5Table, "__Z16luaC_barrierbackP9lua_StateP5Table");
  
  
  function __Z9luaC_linkP9lua_StateP8GCObjecth($L, $o, $tt) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $g;
    $1 = $L;
    $2 = $o;
    $3 = $tt;
    var $4 = $1;
    var $5 = $4+16;
    var $6 = IHEAP[$5];
    $g = $6;
    var $7 = $g;
    var $8 = $7+28;
    var $9 = IHEAP[$8];
    var $10 = $2;
    var $11 = $10;
    var $12 = $11;
    var $13 = $12;
    IHEAP[$13] = $9;
    var $14 = $2;
    var $15 = $g;
    var $16 = $15+28;
    IHEAP[$16] = $14;
    var $17 = $g;
    var $18 = $17+20;
    var $19 = IHEAP[$18];
    var $20 = $19;
    var $21 = $20 & 3;
    var $22 = $21;
    var $23 = $2;
    var $24 = $23;
    var $25 = $24;
    var $26 = $25+5;
    IHEAP[$26] = $22;
    var $27 = $3;
    var $28 = $2;
    var $29 = $28;
    var $30 = $29;
    var $31 = $30+4;
    IHEAP[$31] = $27;
    ;
    return;
  }
  __Z9luaC_linkP9lua_StateP8GCObjecth.__index__ = Runtime.getFunctionIndex(__Z9luaC_linkP9lua_StateP8GCObjecth, "__Z9luaC_linkP9lua_StateP8GCObjecth");
  
  
  function __Z14luaC_linkupvalP9lua_StateP5UpVal($L, $uv) {
    ;
    var __label__;
    var $1;
    var $2;
    var $g;
    var $o;
    $1 = $L;
    $2 = $uv;
    var $3 = $1;
    var $4 = $3+16;
    var $5 = IHEAP[$4];
    $g = $5;
    var $6 = $2;
    var $7 = $6;
    $o = $7;
    var $8 = $g;
    var $9 = $8+28;
    var $10 = IHEAP[$9];
    var $11 = $o;
    var $12 = $11;
    var $13 = $12;
    var $14 = $13;
    IHEAP[$14] = $10;
    var $15 = $o;
    var $16 = $g;
    var $17 = $16+28;
    IHEAP[$17] = $15;
    var $18 = $o;
    var $19 = $18;
    var $20 = $19;
    var $21 = $20+5;
    var $22 = IHEAP[$21];
    var $23 = $22;
    var $24 = $23 & 4;
    var $25 = $24 != 0;
    ;
    $115$26$2: do { 
      if (!$25) {
        ;
        var $27 = $o;
        var $28 = $27;
        var $29 = $28;
        var $30 = $29+5;
        var $31 = IHEAP[$30];
        var $32 = $31;
        var $33 = $32 & 3;
        var $34 = $33 != 0;
        if ($34) { __label__ = 0; /* $115 */ break $115$26$2; }
        var $36 = $g;
        var $37 = $36+21;
        var $38 = IHEAP[$37];
        var $39 = $38;
        var $40 = $39 == 1;
        ;
        if ($40) {
          ;
          var $42 = $o;
          var $43 = $42;
          var $44 = $43;
          var $45 = $44+5;
          var $46 = IHEAP[$45];
          var $47 = $46;
          var $48 = $47 | 4;
          var $49 = $48;
          IHEAP[$45] = $49;
          var $50 = $2;
          var $51 = $50+8;
          var $52 = IHEAP[$51];
          var $53 = $52+8;
          var $54 = IHEAP[$53];
          var $55 = $54 >= 4;
          ;
          $56$92$7: do { 
            if ($55) {
              ;
              var $57 = $2;
              var $58 = $57+8;
              var $59 = IHEAP[$58];
              var $60 = $59;
              var $61 = $60;
              var $62 = $61;
              var $63 = IHEAP[$62];
              var $64 = $63;
              var $65 = $64;
              var $66 = $65+5;
              var $67 = IHEAP[$66];
              var $68 = $67;
              var $69 = $68 & 3;
              var $70 = $69 != 0;
              if (!($70)) { __label__ = 3; /* $92 */ break $56$92$7; }
              var $72 = $2;
              var $73 = $72;
              var $74 = $73;
              var $75 = $74;
              var $76 = $75+5;
              var $77 = IHEAP[$76];
              var $78 = $77;
              var $79 = $78 & 4;
              var $80 = $79 != 0;
              if (!($80)) { __label__ = 3; /* $92 */ break $56$92$7; }
              var $82 = $1;
              var $83 = $2;
              var $84 = $83;
              var $85 = $2;
              var $86 = $85+8;
              var $87 = IHEAP[$86];
              var $88 = $87;
              var $89 = $88;
              var $90 = $89;
              var $91 = IHEAP[$90];
              __Z13luaC_barrierfP9lua_StateP8GCObjectS2_($82, $84, $91);
              ;
            }
          } while(0);
          ;
        }
        else {
          ;
          var $94 = $o;
          var $95 = $94;
          var $96 = $95;
          var $97 = $96+5;
          var $98 = IHEAP[$97];
          var $99 = $98;
          var $100 = $99 & 248;
          var $101 = $g;
          var $102 = $101+20;
          var $103 = IHEAP[$102];
          var $104 = $103;
          var $105 = $104 & 3;
          var $106 = $105;
          var $107 = $106;
          var $108 = $100 | $107;
          var $109 = $108;
          var $110 = $o;
          var $111 = $110;
          var $112 = $111;
          var $113 = $112+5;
          IHEAP[$113] = $109;
          ;
        }
        ;
      }
    } while(0);
    ;
    return;
  }
  __Z14luaC_linkupvalP9lua_StateP5UpVal.__index__ = Runtime.getFunctionIndex(__Z14luaC_linkupvalP9lua_StateP5UpVal, "__Z14luaC_linkupvalP9lua_StateP5UpVal");
  
  
  function __Z6markmtP12global_State($g) {
    ;
    var __label__;
    var $1;
    var $i;
    $1 = $g;
    $i = 0;
    ;
    $2$2: while(1) { // $2
      var $3 = $i;
      var $4 = $3 < 9;
      if (!($4)) { __label__ = 2; /* $39 */ break $2$2; }
      var $6 = $i;
      var $7 = $1;
      var $8 = $7+132;
      var $9 = $8+$6*4;
      var $10 = IHEAP[$9];
      var $11 = $10 != 0;
      ;
      if ($11) {
        ;
        var $13 = $i;
        var $14 = $1;
        var $15 = $14+132;
        var $16 = $15+$13*4;
        var $17 = IHEAP[$16];
        var $18 = $17;
        var $19 = $18;
        var $20 = $19;
        var $21 = $20+5;
        var $22 = IHEAP[$21];
        var $23 = $22;
        var $24 = $23 & 3;
        var $25 = $24 != 0;
        ;
        if ($25) {
          ;
          var $27 = $1;
          var $28 = $i;
          var $29 = $1;
          var $30 = $29+132;
          var $31 = $30+$28*4;
          var $32 = IHEAP[$31];
          var $33 = $32;
          __Z16reallymarkobjectP12global_StateP8GCObject($27, $33);
          ;
        }
        ;
      }
      ;
      var $37 = $i;
      var $38 = $37 + 1;
      $i = $38;
      __label__ = 0; /* $2 */ continue $2$2;
    }
    ;
    return;
  }
  __Z6markmtP12global_State.__index__ = Runtime.getFunctionIndex(__Z6markmtP12global_State, "__Z6markmtP12global_State");
  
  
  function __Z13propagatemarkP12global_State($g) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $o;
    var $h;
    var $cl;
    var $th;
    var $p;
    $2 = $g;
    var $3 = $2;
    var $4 = $3+36;
    var $5 = IHEAP[$4];
    $o = $5;
    var $6 = $o;
    var $7 = $6;
    var $8 = $7;
    var $9 = $8+5;
    var $10 = IHEAP[$9];
    var $11 = $10;
    var $12 = $11 | 4;
    var $13 = $12;
    IHEAP[$9] = $13;
    var $14 = $o;
    var $15 = $14;
    var $16 = $15;
    var $17 = $16+4;
    var $18 = IHEAP[$17];
    var $19 = $18;
    if ($19 == 5) {
      __label__ = 5; /* $20 */ 
    }
    else if ($19 == 6) {
      __label__ = 6; /* $55 */ 
    }
    else if ($19 == 8) {
      __label__ = 7; /* $93 */ 
    }
    else if ($19 == 9) {
      __label__ = 8; /* $129 */ 
    }
    else {
    __label__ = 9; /* $170 */ 
    }
    
    if (__label__ == 9) {
      $1 = 0;
      ;
    }
    else if (__label__ == 5) {
      var $21 = $o;
      var $22 = $21;
      var $23 = $22;
      $h = $23;
      var $24 = $h;
      var $25 = $24+24;
      var $26 = IHEAP[$25];
      var $27 = $2;
      var $28 = $27+36;
      IHEAP[$28] = $26;
      var $29 = $2;
      var $30 = $h;
      var $31 = __Z13traversetableP12global_StateP5Table($29, $30);
      var $32 = $31 != 0;
      ;
      if ($32) {
        ;
        var $34 = $o;
        var $35 = $34;
        var $36 = $35;
        var $37 = $36+5;
        var $38 = IHEAP[$37];
        var $39 = $38;
        var $40 = $39 & 251;
        var $41 = $40;
        IHEAP[$37] = $41;
        ;
      }
      var $43 = $h;
      var $44 = $43+28;
      var $45 = IHEAP[$44];
      var $46 = 12 * $45;
      var $47 = 32 + $46;
      var $48 = $h;
      var $49 = $48+7;
      var $50 = IHEAP[$49];
      var $51 = $50;
      var $52 = 1 << $51;
      var $53 = 28 * $52;
      var $54 = $47 + $53;
      $1 = $54;
      ;
    }
    else if (__label__ == 6) {
      var $56 = $o;
      var $57 = $56;
      var $58 = $57;
      $cl = $58;
      var $59 = $cl;
      var $60 = $59;
      var $61 = $60+8;
      var $62 = IHEAP[$61];
      var $63 = $2;
      var $64 = $63+36;
      IHEAP[$64] = $62;
      var $65 = $2;
      var $66 = $cl;
      __Z15traverseclosureP12global_StateP7Closure($65, $66);
      var $67 = $cl;
      var $68 = $67;
      var $69 = $68+6;
      var $70 = IHEAP[$69];
      var $71 = $70 != 0;
      ;
      if ($71) {
        ;
        var $73 = $cl;
        var $74 = $73;
        var $75 = $74+7;
        var $76 = IHEAP[$75];
        var $77 = $76;
        var $78 = $77 - 1;
        var $79 = 12 * $78;
        var $80 = 32 + $79;
        __lastLabel__ = 2; ;
      }
      else {
        ;
        var $82 = $cl;
        var $83 = $82;
        var $84 = $83;
        var $85 = $84+7;
        var $86 = IHEAP[$85];
        var $87 = $86;
        var $88 = $87 - 1;
        var $89 = 4 * $88;
        var $90 = 24 + $89;
        __lastLabel__ = 4; ;
      }
      var $92 = __lastLabel__ == 2 ? $80 : ($90);
      $1 = $92;
      ;
    }
    else if (__label__ == 7) {
      var $94 = $o;
      var $95 = $94;
      $th = $95;
      var $96 = $th;
      var $97 = $96+100;
      var $98 = IHEAP[$97];
      var $99 = $2;
      var $100 = $99+36;
      IHEAP[$100] = $98;
      var $101 = $2;
      var $102 = $101+40;
      var $103 = IHEAP[$102];
      var $104 = $th;
      var $105 = $104+100;
      IHEAP[$105] = $103;
      var $106 = $o;
      var $107 = $2;
      var $108 = $107+40;
      IHEAP[$108] = $106;
      var $109 = $o;
      var $110 = $109;
      var $111 = $110;
      var $112 = $111+5;
      var $113 = IHEAP[$112];
      var $114 = $113;
      var $115 = $114 & 251;
      var $116 = $115;
      IHEAP[$112] = $116;
      var $117 = $2;
      var $118 = $th;
      __Z13traversestackP12global_StateP9lua_State($117, $118);
      var $119 = $th;
      var $120 = $119+44;
      var $121 = IHEAP[$120];
      var $122 = 12 * $121;
      var $123 = 112 + $122;
      var $124 = $th;
      var $125 = $124+48;
      var $126 = IHEAP[$125];
      var $127 = 24 * $126;
      var $128 = $123 + $127;
      $1 = $128;
      ;
    }
    else if (__label__ == 8) {
      var $130 = $o;
      var $131 = $130;
      var $132 = $131;
      $p = $132;
      var $133 = $p;
      var $134 = $133+68;
      var $135 = IHEAP[$134];
      var $136 = $2;
      var $137 = $136+36;
      IHEAP[$137] = $135;
      var $138 = $2;
      var $139 = $p;
      __Z13traverseprotoP12global_StateP5Proto($138, $139);
      var $140 = $p;
      var $141 = $140+44;
      var $142 = IHEAP[$141];
      var $143 = 4 * $142;
      var $144 = 76 + $143;
      var $145 = $p;
      var $146 = $145+52;
      var $147 = IHEAP[$146];
      var $148 = 4 * $147;
      var $149 = $144 + $148;
      var $150 = $p;
      var $151 = $150+40;
      var $152 = IHEAP[$151];
      var $153 = 12 * $152;
      var $154 = $149 + $153;
      var $155 = $p;
      var $156 = $155+48;
      var $157 = IHEAP[$156];
      var $158 = 4 * $157;
      var $159 = $154 + $158;
      var $160 = $p;
      var $161 = $160+56;
      var $162 = IHEAP[$161];
      var $163 = 12 * $162;
      var $164 = $159 + $163;
      var $165 = $p;
      var $166 = $165+36;
      var $167 = IHEAP[$166];
      var $168 = 4 * $167;
      var $169 = $164 + $168;
      $1 = $169;
      ;
    }
    var $172 = $1;
    ;
    return $172;
  }
  __Z13propagatemarkP12global_State.__index__ = Runtime.getFunctionIndex(__Z13propagatemarkP12global_State, "__Z13propagatemarkP12global_State");
  
  
  function __Z6atomicP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $g;
    var $udsize;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+16;
    var $4 = IHEAP[$3];
    $g = $4;
    var $5 = $g;
    __Z12remarkupvalsP12global_State($5);
    var $6 = $g;
    var $7 = __Z12propagateallP12global_State($6);
    var $8 = $g;
    var $9 = $8+44;
    var $10 = IHEAP[$9];
    var $11 = $g;
    var $12 = $11+36;
    IHEAP[$12] = $10;
    var $13 = $g;
    var $14 = $13+44;
    IHEAP[$14] = 0;
    var $15 = $1;
    var $16 = $15;
    var $17 = $16;
    var $18 = $17;
    var $19 = $18+5;
    var $20 = IHEAP[$19];
    var $21 = $20;
    var $22 = $21 & 3;
    var $23 = $22 != 0;
    ;
    if ($23) {
      ;
      var $25 = $g;
      var $26 = $1;
      var $27 = $26;
      __Z16reallymarkobjectP12global_StateP8GCObject($25, $27);
      ;
    }
    var $29 = $g;
    __Z6markmtP12global_State($29);
    var $30 = $g;
    var $31 = __Z12propagateallP12global_State($30);
    var $32 = $g;
    var $33 = $32+40;
    var $34 = IHEAP[$33];
    var $35 = $g;
    var $36 = $35+36;
    IHEAP[$36] = $34;
    var $37 = $g;
    var $38 = $37+40;
    IHEAP[$38] = 0;
    var $39 = $g;
    var $40 = __Z12propagateallP12global_State($39);
    var $41 = $1;
    var $42 = __Z18luaC_separateudataP9lua_Statei($41, 0);
    $udsize = $42;
    var $43 = $g;
    __Z7marktmuP12global_State($43);
    var $44 = $g;
    var $45 = __Z12propagateallP12global_State($44);
    var $46 = $udsize;
    var $47 = $46 + $45;
    $udsize = $47;
    var $48 = $g;
    var $49 = $48+44;
    var $50 = IHEAP[$49];
    __Z10cleartableP8GCObject($50);
    var $51 = $g;
    var $52 = $51+20;
    var $53 = IHEAP[$52];
    var $54 = $53;
    var $55 = $54 ^ 3;
    var $56 = $55;
    var $57 = $g;
    var $58 = $57+20;
    IHEAP[$58] = $56;
    var $59 = $g;
    var $60 = $59+24;
    IHEAP[$60] = 0;
    var $61 = $g;
    var $62 = $61+28;
    var $63 = $g;
    var $64 = $63+32;
    IHEAP[$64] = $62;
    var $65 = $g;
    var $66 = $65+21;
    IHEAP[$66] = 2;
    var $67 = $g;
    var $68 = $67+68;
    var $69 = IHEAP[$68];
    var $70 = $udsize;
    var $71 = $69 - $70;
    var $72 = $g;
    var $73 = $72+72;
    IHEAP[$73] = $71;
    ;
    return;
  }
  __Z6atomicP9lua_State.__index__ = Runtime.getFunctionIndex(__Z6atomicP9lua_State, "__Z6atomicP9lua_State");
  
  
  function __Z10checkSizesP9lua_State($L) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $g;
    var $newsize;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+16;
    var $4 = IHEAP[$3];
    $g = $4;
    var $5 = $g;
    var $6 = $5;
    var $7 = $6+4;
    var $8 = IHEAP[$7];
    var $9 = $g;
    var $10 = $9;
    var $11 = $10+8;
    var $12 = IHEAP[$11];
    var $13 = Math.floor($12 / 4);
    var $14 = unSign($8, 32) < unSign($13, 32);
    ;
    $15$28$2: do { 
      if ($14) {
        ;
        var $16 = $g;
        var $17 = $16;
        var $18 = $17+8;
        var $19 = IHEAP[$18];
        var $20 = $19 > 64;
        if (!($20)) { __label__ = 1; /* $28 */ break $15$28$2; }
        var $22 = $1;
        var $23 = $g;
        var $24 = $23;
        var $25 = $24+8;
        var $26 = IHEAP[$25];
        var $27 = Math.floor($26 / 2);
        __Z11luaS_resizeP9lua_Statei($22, $27);
        ;
      }
    } while(0);
    var $29 = $g;
    var $30 = $29+52;
    var $31 = $30+8;
    var $32 = IHEAP[$31];
    var $33 = unSign($32, 32) > unSign(64, 32);
    ;
    if ($33) {
      ;
      var $35 = $g;
      var $36 = $35+52;
      var $37 = $36+8;
      var $38 = IHEAP[$37];
      var $39 = Math.floor(unSign($38, 32) / unSign(2, 32));
      $newsize = $39;
      var $40 = $newsize;
      var $41 = $40 + 1;
      var $42 = unSign($41, 32) <= unSign(-3, 32);
      ;
      if ($42) {
        ;
        var $44 = $1;
        var $45 = $g;
        var $46 = $45+52;
        var $47 = $46;
        var $48 = IHEAP[$47];
        var $49 = $g;
        var $50 = $49+52;
        var $51 = $50+8;
        var $52 = IHEAP[$51];
        var $53 = $52 * 1;
        var $54 = $newsize;
        var $55 = $54 * 1;
        var $56 = __Z13luaM_realloc_P9lua_StatePvjj($44, $48, $53, $55);
        __lastLabel__ = 3; ;
      }
      else {
        ;
        var $58 = $1;
        var $59 = __Z11luaM_toobigP9lua_State($58);
        __lastLabel__ = 5; ;
      }
      var $61 = __lastLabel__ == 3 ? $56 : ($59);
      var $62 = $g;
      var $63 = $62+52;
      var $64 = $63;
      IHEAP[$64] = $61;
      var $65 = $newsize;
      var $66 = $g;
      var $67 = $66+52;
      var $68 = $67+8;
      IHEAP[$68] = $65;
      ;
    }
    ;
    return;
  }
  __Z10checkSizesP9lua_State.__index__ = Runtime.getFunctionIndex(__Z10checkSizesP9lua_State, "__Z10checkSizesP9lua_State");
  
  
  function __Z12remarkupvalsP12global_State($g) {
    ;
    var __label__;
    var $1;
    var $uv;
    $1 = $g;
    var $2 = $1;
    var $3 = $2+108;
    var $4 = $3+12;
    var $5 = $4;
    var $6 = $5;
    var $7 = $6+4;
    var $8 = IHEAP[$7];
    $uv = $8;
    ;
    $9$2: while(1) { // $9
      var $10 = $uv;
      var $11 = $1;
      var $12 = $11+108;
      var $13 = $10 != $12;
      if (!($13)) { __label__ = 2; /* $74 */ break $9$2; }
      var $15 = $uv;
      var $16 = $15;
      var $17 = $16;
      var $18 = $17;
      var $19 = $18+5;
      var $20 = IHEAP[$19];
      var $21 = $20;
      var $22 = $21 & 4;
      var $23 = $22 != 0;
      ;
      $66$24$5: do { 
        if (!$23) {
          ;
          var $25 = $uv;
          var $26 = $25;
          var $27 = $26;
          var $28 = $27;
          var $29 = $28+5;
          var $30 = IHEAP[$29];
          var $31 = $30;
          var $32 = $31 & 3;
          var $33 = $32 != 0;
          if ($33) { __label__ = 3; /* $66 */ break $66$24$5; }
          var $35 = $uv;
          var $36 = $35+8;
          var $37 = IHEAP[$36];
          var $38 = $37+8;
          var $39 = IHEAP[$38];
          var $40 = $39 >= 4;
          ;
          $41$65$8: do { 
            if ($40) {
              ;
              var $42 = $uv;
              var $43 = $42+8;
              var $44 = IHEAP[$43];
              var $45 = $44;
              var $46 = $45;
              var $47 = $46;
              var $48 = IHEAP[$47];
              var $49 = $48;
              var $50 = $49;
              var $51 = $50+5;
              var $52 = IHEAP[$51];
              var $53 = $52;
              var $54 = $53 & 3;
              var $55 = $54 != 0;
              if (!($55)) { __label__ = 6; /* $65 */ break $41$65$8; }
              var $57 = $1;
              var $58 = $uv;
              var $59 = $58+8;
              var $60 = IHEAP[$59];
              var $61 = $60;
              var $62 = $61;
              var $63 = $62;
              var $64 = IHEAP[$63];
              __Z16reallymarkobjectP12global_StateP8GCObject($57, $64);
              ;
            }
          } while(0);
          ;
        }
      } while(0);
      ;
      var $68 = $uv;
      var $69 = $68+12;
      var $70 = $69;
      var $71 = $70;
      var $72 = $71+4;
      var $73 = IHEAP[$72];
      $uv = $73;
      __label__ = 0; /* $9 */ continue $9$2;
    }
    ;
    return;
  }
  __Z12remarkupvalsP12global_State.__index__ = Runtime.getFunctionIndex(__Z12remarkupvalsP12global_State, "__Z12remarkupvalsP12global_State");
  
  
  function __Z12propagateallP12global_State($g) {
    ;
    var __label__;
    var $1;
    var $m;
    $1 = $g;
    $m = 0;
    ;
    $2$2: while(1) { // $2
      var $3 = $1;
      var $4 = $3+36;
      var $5 = IHEAP[$4];
      var $6 = $5 != 0;
      if (!($6)) { __label__ = 2; /* $12 */ break $2$2; }
      var $8 = $1;
      var $9 = __Z13propagatemarkP12global_State($8);
      var $10 = $m;
      var $11 = $10 + $9;
      $m = $11;
      __label__ = 0; /* $2 */ continue $2$2;
    }
    var $13 = $m;
    ;
    return $13;
  }
  __Z12propagateallP12global_State.__index__ = Runtime.getFunctionIndex(__Z12propagateallP12global_State, "__Z12propagateallP12global_State");
  
  
  function __Z7marktmuP12global_State($g) {
    ;
    var __label__;
    var $1;
    var $u;
    $1 = $g;
    var $2 = $1;
    var $3 = $2+48;
    var $4 = IHEAP[$3];
    $u = $4;
    var $5 = $u;
    var $6 = $5 != 0;
    ;
    if ($6) {
      ;
      ;
      $8$4: while(1) { // $8
        var $9 = $u;
        var $10 = $9;
        var $11 = $10;
        var $12 = $11;
        var $13 = IHEAP[$12];
        $u = $13;
        var $14 = $u;
        var $15 = $14;
        var $16 = $15;
        var $17 = $16+5;
        var $18 = IHEAP[$17];
        var $19 = $18;
        var $20 = $19 & 248;
        var $21 = $1;
        var $22 = $21+20;
        var $23 = IHEAP[$22];
        var $24 = $23;
        var $25 = $24 & 3;
        var $26 = $25;
        var $27 = $26;
        var $28 = $20 | $27;
        var $29 = $28;
        var $30 = $u;
        var $31 = $30;
        var $32 = $31;
        var $33 = $32+5;
        IHEAP[$33] = $29;
        var $34 = $1;
        var $35 = $u;
        __Z16reallymarkobjectP12global_StateP8GCObject($34, $35);
        ;
        var $37 = $u;
        var $38 = $1;
        var $39 = $38+48;
        var $40 = IHEAP[$39];
        var $41 = $37 != $40;
        if ($41) { __label__ = 0; /* $8 */ continue $8$4; } else { __label__ = 2; /* $42 */ break $8$4; }
      }
      ;
    }
    ;
    return;
  }
  __Z7marktmuP12global_State.__index__ = Runtime.getFunctionIndex(__Z7marktmuP12global_State, "__Z7marktmuP12global_State");
  
  
  function __Z10cleartableP8GCObject($l) {
    ;
    var __label__;
    var $1;
    var $h;
    var $i;
    var $o;
    var $n;
    $1 = $l;
    ;
    $2$2: while(1) { // $2
      var $3 = $1;
      var $4 = $3 != 0;
      if (!($4)) { __label__ = 2; /* $80 */ break $2$2; }
      var $6 = $1;
      var $7 = $6;
      var $8 = $7;
      $h = $8;
      var $9 = $h;
      var $10 = $9+28;
      var $11 = IHEAP[$10];
      $i = $11;
      var $12 = $h;
      var $13 = $12+5;
      var $14 = IHEAP[$13];
      var $15 = $14;
      var $16 = $15 & 16;
      var $17 = $16 != 0;
      ;
      if ($17) {
        ;
        ;
        $19$7: while(1) { // $19
          var $20 = $i;
          var $21 = $20 + -1;
          $i = $21;
          var $22 = $20 != 0;
          if (!($22)) { __label__ = 5; /* $36 */ break $19$7; }
          var $24 = $i;
          var $25 = $h;
          var $26 = $25+12;
          var $27 = IHEAP[$26];
          var $28 = $27+12*$24;
          $o = $28;
          var $29 = $o;
          var $30 = __Z9isclearedPK10lua_TValuei($29, 0);
          var $31 = $30 != 0;
          ;
          if ($31) {
            ;
            var $33 = $o;
            var $34 = $33+8;
            IHEAP[$34] = 0;
            ;
          }
          __label__ = 3; /* $19 */ continue $19$7;
        }
        ;
      }
      var $38 = $h;
      var $39 = $38+7;
      var $40 = IHEAP[$39];
      var $41 = $40;
      var $42 = 1 << $41;
      $i = $42;
      ;
      $43$15: while(1) { // $43
        var $44 = $i;
        var $45 = $44 + -1;
        $i = $45;
        var $46 = $44 != 0;
        if (!($46)) { __label__ = 10; /* $76 */ break $43$15; }
        var $48 = $i;
        var $49 = $h;
        var $50 = $49+16;
        var $51 = IHEAP[$50];
        var $52 = $51+28*$48;
        $n = $52;
        var $53 = $n;
        var $54 = $53;
        var $55 = $54+8;
        var $56 = IHEAP[$55];
        var $57 = $56 == 0;
        ;
        $75$58$18: do { 
          if (!$57) {
            ;
            var $59 = $n;
            var $60 = $59+12;
            var $61 = $60;
            var $62 = $61;
            var $63 = __Z9isclearedPK10lua_TValuei($62, 1);
            var $64 = $63 != 0;
            ;
            if (!$64) {
              ;
              var $66 = $n;
              var $67 = $66;
              var $68 = __Z9isclearedPK10lua_TValuei($67, 0);
              var $69 = $68 != 0;
              if (!($69)) { __label__ = 12; /* $75 */ break $75$58$18; }
            }
            var $71 = $n;
            var $72 = $71;
            var $73 = $72+8;
            IHEAP[$73] = 0;
            var $74 = $n;
            __Z11removeentryP4Node($74);
            ;
          }
        } while(0);
        __label__ = 8; /* $43 */ continue $43$15;
      }
      var $77 = $h;
      var $78 = $77+24;
      var $79 = IHEAP[$78];
      $1 = $79;
      __label__ = 0; /* $2 */ continue $2$2;
    }
    ;
    return;
  }
  __Z10cleartableP8GCObject.__index__ = Runtime.getFunctionIndex(__Z10cleartableP8GCObject, "__Z10cleartableP8GCObject");
  
  
  function __Z9isclearedPK10lua_TValuei($o, $iskey) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    $2 = $o;
    $3 = $iskey;
    var $4 = $2;
    var $5 = $4+8;
    var $6 = IHEAP[$5];
    var $7 = $6 >= 4;
    ;
    if ($7) {
      ;
      var $10 = $2;
      var $11 = $10+8;
      var $12 = IHEAP[$11];
      var $13 = $12 == 4;
      ;
      if ($13) {
        ;
        var $15 = $2;
        var $16 = $15;
        var $17 = $16;
        var $18 = $17;
        var $19 = IHEAP[$18];
        var $20 = $19;
        var $21 = $20;
        var $22 = $21;
        var $23 = $22+5;
        var $24 = IHEAP[$23];
        var $25 = $24;
        var $26 = $25 & 252;
        var $27 = $26;
        IHEAP[$23] = $27;
        $1 = 0;
        ;
      }
      else {
        ;
        var $29 = $2;
        var $30 = $29;
        var $31 = $30;
        var $32 = $31;
        var $33 = IHEAP[$32];
        var $34 = $33;
        var $35 = $34;
        var $36 = $35+5;
        var $37 = IHEAP[$36];
        var $38 = $37;
        var $39 = $38 & 3;
        var $40 = $39 != 0;
        ;
        if ($40) {
          __lastLabel__ = 9; ;
        }
        else {
          __lastLabel__ = 9; ;
          var $42 = $2;
          var $43 = $42+8;
          var $44 = IHEAP[$43];
          var $45 = $44 == 7;
          ;
          if ($45) {
            __lastLabel__ = 8; ;
            var $47 = $3;
            var $48 = $47 != 0;
            ;
            if ($48) {
              __lastLabel__ = 7; ;
            }
            else {
              __lastLabel__ = 7; ;
              var $50 = $2;
              var $51 = $50;
              var $52 = $51;
              var $53 = $52;
              var $54 = IHEAP[$53];
              var $55 = $54;
              var $56 = $55;
              var $57 = $56;
              var $58 = $57+5;
              var $59 = IHEAP[$58];
              var $60 = $59;
              var $61 = $60 & 8;
              var $62 = $61 != 0;
              __lastLabel__ = 1; ;
            }
            var $64 = __lastLabel__ == 7 ? 0 : ($62);
            __lastLabel__ = 3; ;
          }
          else {
            __lastLabel__ = 8; ;
          }
          var $66 = __lastLabel__ == 8 ? 0 : ($64);
          __lastLabel__ = 5; ;
        }
        var $68 = __lastLabel__ == 9 ? 1 : ($66);
        var $69 = $68;
        $1 = $69;
        ;
      }
    }
    else {
      ;
      $1 = 0;
      ;
    }
    var $71 = $1;
    ;
    return $71;
  }
  __Z9isclearedPK10lua_TValuei.__index__ = Runtime.getFunctionIndex(__Z9isclearedPK10lua_TValuei, "__Z9isclearedPK10lua_TValuei");
  
  
  function __Z11removeentryP4Node($n) {
    ;
    var __label__;
    var $1;
    $1 = $n;
    var $2 = $1;
    var $3 = $2+12;
    var $4 = $3;
    var $5 = $4+8;
    var $6 = IHEAP[$5];
    var $7 = $6 >= 4;
    ;
    if ($7) {
      ;
      var $9 = $1;
      var $10 = $9+12;
      var $11 = $10;
      var $12 = $11+8;
      IHEAP[$12] = 11;
      ;
    }
    ;
    return;
  }
  __Z11removeentryP4Node.__index__ = Runtime.getFunctionIndex(__Z11removeentryP4Node, "__Z11removeentryP4Node");
  
  
  function __Z13traversetableP12global_StateP5Table($g, $h) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $i;
    var $weakkey;
    var $weakvalue;
    var $mode;
    var $n;
    $2 = $g;
    $3 = $h;
    $weakkey = 0;
    $weakvalue = 0;
    var $4 = $3;
    var $5 = $4+8;
    var $6 = IHEAP[$5];
    var $7 = $6 != 0;
    ;
    if ($7) {
      ;
      var $9 = $3;
      var $10 = $9+8;
      var $11 = IHEAP[$10];
      var $12 = $11;
      var $13 = $12;
      var $14 = $13;
      var $15 = $14+5;
      var $16 = IHEAP[$15];
      var $17 = $16;
      var $18 = $17 & 3;
      var $19 = $18 != 0;
      ;
      if ($19) {
        ;
        var $21 = $2;
        var $22 = $3;
        var $23 = $22+8;
        var $24 = IHEAP[$23];
        var $25 = $24;
        __Z16reallymarkobjectP12global_StateP8GCObject($21, $25);
        ;
      }
      ;
    }
    var $28 = $3;
    var $29 = $28+8;
    var $30 = IHEAP[$29];
    var $31 = $30 == 0;
    ;
    if ($31) {
      ;
      __lastLabel__ = 2; ;
    }
    else {
      ;
      var $34 = $3;
      var $35 = $34+8;
      var $36 = IHEAP[$35];
      var $37 = $36+6;
      var $38 = IHEAP[$37];
      var $39 = $38;
      var $40 = $39 & 8;
      var $41 = $40 != 0;
      ;
      if ($41) {
        ;
        __lastLabel__ = 4; ;
      }
      else {
        ;
        var $44 = $3;
        var $45 = $44+8;
        var $46 = IHEAP[$45];
        var $47 = $2;
        var $48 = $47+168;
        var $49 = $48+12;
        var $50 = IHEAP[$49];
        var $51 = __Z10luaT_gettmP5Table3TMSP7TString($46, 3, $50);
        __lastLabel__ = 6; ;
      }
      var $53 = __lastLabel__ == 4 ? 0 : ($51);
      __lastLabel__ = 7; ;
    }
    var $55 = __lastLabel__ == 2 ? 0 : ($53);
    $mode = $55;
    var $56 = $mode;
    var $57 = $56 != 0;
    ;
    $58$123$16: do { 
      if ($57) {
        ;
        var $59 = $mode;
        var $60 = $59+8;
        var $61 = IHEAP[$60];
        var $62 = $61 == 4;
        if (!($62)) { __label__ = 9; /* $123 */ break $58$123$16; }
        var $64 = $mode;
        var $65 = $64;
        var $66 = $65;
        var $67 = $66;
        var $68 = IHEAP[$67];
        var $69 = $68;
        var $70 = $69;
        var $71 = $70+16;
        var $72 = $71;
        var $73 = _strchr($72, 107);
        var $74 = $73 != 0;
        var $75 = $74;
        $weakkey = $75;
        var $76 = $mode;
        var $77 = $76;
        var $78 = $77;
        var $79 = $78;
        var $80 = IHEAP[$79];
        var $81 = $80;
        var $82 = $81;
        var $83 = $82+16;
        var $84 = $83;
        var $85 = _strchr($84, 118);
        var $86 = $85 != 0;
        var $87 = $86;
        $weakvalue = $87;
        var $88 = $weakkey;
        var $89 = $88 != 0;
        ;
        $93$90$19: do { 
          if ($89) {
            __label__ = 10; /* $93 */ 
          }
          else {
            ;
            var $91 = $weakvalue;
            var $92 = $91 != 0;
            if ($92) { __label__ = 10; /* $93 */ break $93$90$19; } else { __label__ = 11; /* $122 */ break $93$90$19; }
          }
        } while(0);
        if (__label__ == 10) {
          var $94 = $3;
          var $95 = $94+5;
          var $96 = IHEAP[$95];
          var $97 = $96;
          var $98 = $97 & -25;
          var $99 = $98;
          IHEAP[$95] = $99;
          var $100 = $weakkey;
          var $101 = $100 << 3;
          var $102 = $weakvalue;
          var $103 = $102 << 4;
          var $104 = $101 | $103;
          var $105 = $104;
          var $106 = $105;
          var $107 = $3;
          var $108 = $107+5;
          var $109 = IHEAP[$108];
          var $110 = $109;
          var $111 = $110 | $106;
          var $112 = $111;
          IHEAP[$108] = $112;
          var $113 = $2;
          var $114 = $113+44;
          var $115 = IHEAP[$114];
          var $116 = $3;
          var $117 = $116+24;
          IHEAP[$117] = $115;
          var $118 = $3;
          var $119 = $118;
          var $120 = $2;
          var $121 = $120+44;
          IHEAP[$121] = $119;
          ;
        }
        ;
      }
    } while(0);
    var $124 = $weakkey;
    var $125 = $124 != 0;
    ;
    $126$130$25: do { 
      if ($125) {
        ;
        var $127 = $weakvalue;
        var $128 = $127 != 0;
        if (!($128)) { __label__ = 15; /* $130 */ break $126$130$25; }
        $1 = 1;
        __label__ = 16; /* $281 */ break $126$130$25;
      }
      else {
        __label__ = 15; /* $130 */ 
      }
    } while(0);
    if (__label__ == 15) {
      var $131 = $weakvalue;
      var $132 = $131 != 0;
      ;
      if (!$132) {
        ;
        var $134 = $3;
        var $135 = $134+28;
        var $136 = IHEAP[$135];
        $i = $136;
        ;
        $137$32: while(1) { // $137
          var $138 = $i;
          var $139 = $138 + -1;
          $i = $139;
          var $140 = $138 != 0;
          if (!($140)) { __label__ = 19; /* $179 */ break $137$32; }
          var $142 = $i;
          var $143 = $3;
          var $144 = $143+12;
          var $145 = IHEAP[$144];
          var $146 = $145+12*$142;
          var $147 = $146+8;
          var $148 = IHEAP[$147];
          var $149 = $148 >= 4;
          ;
          $150$178$35: do { 
            if ($149) {
              ;
              var $151 = $i;
              var $152 = $3;
              var $153 = $152+12;
              var $154 = IHEAP[$153];
              var $155 = $154+12*$151;
              var $156 = $155;
              var $157 = $156;
              var $158 = $157;
              var $159 = IHEAP[$158];
              var $160 = $159;
              var $161 = $160;
              var $162 = $161+5;
              var $163 = IHEAP[$162];
              var $164 = $163;
              var $165 = $164 & 3;
              var $166 = $165 != 0;
              if (!($166)) { __label__ = 21; /* $178 */ break $150$178$35; }
              var $168 = $2;
              var $169 = $i;
              var $170 = $3;
              var $171 = $170+12;
              var $172 = IHEAP[$171];
              var $173 = $172+12*$169;
              var $174 = $173;
              var $175 = $174;
              var $176 = $175;
              var $177 = IHEAP[$176];
              __Z16reallymarkobjectP12global_StateP8GCObject($168, $177);
              ;
            }
          } while(0);
          __label__ = 17; /* $137 */ continue $137$32;
        }
        ;
      }
      var $181 = $3;
      var $182 = $181+7;
      var $183 = IHEAP[$182];
      var $184 = $183;
      var $185 = 1 << $184;
      $i = $185;
      ;
      $186$41: while(1) { // $186
        var $187 = $i;
        var $188 = $187 + -1;
        $i = $188;
        var $189 = $187 != 0;
        if (!($189)) { __label__ = 26; /* $272 */ break $186$41; }
        var $191 = $i;
        var $192 = $3;
        var $193 = $192+16;
        var $194 = IHEAP[$193];
        var $195 = $194+28*$191;
        $n = $195;
        var $196 = $n;
        var $197 = $196;
        var $198 = $197+8;
        var $199 = IHEAP[$198];
        var $200 = $199 == 0;
        ;
        if ($200) {
          ;
          var $202 = $n;
          __Z11removeentryP4Node($202);
          ;
        }
        else {
          ;
          var $204 = $weakkey;
          var $205 = $204 != 0;
          ;
          if (!$205) {
            ;
            var $207 = $n;
            var $208 = $207+12;
            var $209 = $208;
            var $210 = $209+8;
            var $211 = IHEAP[$210];
            var $212 = $211 >= 4;
            ;
            $213$237$49: do { 
              if ($212) {
                ;
                var $214 = $n;
                var $215 = $214+12;
                var $216 = $215;
                var $217 = $216;
                var $218 = $217;
                var $219 = $218;
                var $220 = IHEAP[$219];
                var $221 = $220;
                var $222 = $221;
                var $223 = $222+5;
                var $224 = IHEAP[$223];
                var $225 = $224;
                var $226 = $225 & 3;
                var $227 = $226 != 0;
                if (!($227)) { __label__ = 29; /* $237 */ break $213$237$49; }
                var $229 = $2;
                var $230 = $n;
                var $231 = $230+12;
                var $232 = $231;
                var $233 = $232;
                var $234 = $233;
                var $235 = $234;
                var $236 = IHEAP[$235];
                __Z16reallymarkobjectP12global_StateP8GCObject($229, $236);
                ;
              }
            } while(0);
            ;
          }
          var $239 = $weakvalue;
          var $240 = $239 != 0;
          ;
          if (!$240) {
            ;
            var $242 = $n;
            var $243 = $242;
            var $244 = $243+8;
            var $245 = IHEAP[$244];
            var $246 = $245 >= 4;
            ;
            $247$269$56: do { 
              if ($246) {
                ;
                var $248 = $n;
                var $249 = $248;
                var $250 = $249;
                var $251 = $250;
                var $252 = $251;
                var $253 = IHEAP[$252];
                var $254 = $253;
                var $255 = $254;
                var $256 = $255+5;
                var $257 = IHEAP[$256];
                var $258 = $257;
                var $259 = $258 & 3;
                var $260 = $259 != 0;
                if (!($260)) { __label__ = 33; /* $269 */ break $247$269$56; }
                var $262 = $2;
                var $263 = $n;
                var $264 = $263;
                var $265 = $264;
                var $266 = $265;
                var $267 = $266;
                var $268 = IHEAP[$267];
                __Z16reallymarkobjectP12global_StateP8GCObject($262, $268);
                ;
              }
            } while(0);
            ;
          }
          ;
        }
        __label__ = 24; /* $186 */ continue $186$41;
      }
      var $273 = $weakkey;
      var $274 = $273 != 0;
      ;
      if ($274) {
        __lastLabel__ = 26; ;
      }
      else {
        __lastLabel__ = 26; ;
        var $276 = $weakvalue;
        var $277 = $276 != 0;
        __lastLabel__ = 36; ;
      }
      var $279 = __lastLabel__ == 26 ? 1 : ($277);
      var $280 = $279;
      $1 = $280;
      ;
    }
    var $282 = $1;
    ;
    return $282;
  }
  __Z13traversetableP12global_StateP5Table.__index__ = Runtime.getFunctionIndex(__Z13traversetableP12global_StateP5Table, "__Z13traversetableP12global_StateP5Table");
  
  
  function __Z15traverseclosureP12global_StateP7Closure($g, $cl) {
    ;
    var __label__;
    var $1;
    var $2;
    var $i;
    var $i1;
    $1 = $g;
    $2 = $cl;
    var $3 = $2;
    var $4 = $3;
    var $5 = $4+12;
    var $6 = IHEAP[$5];
    var $7 = $6;
    var $8 = $7;
    var $9 = $8;
    var $10 = $9+5;
    var $11 = IHEAP[$10];
    var $12 = $11;
    var $13 = $12 & 3;
    var $14 = $13 != 0;
    ;
    if ($14) {
      ;
      var $16 = $1;
      var $17 = $2;
      var $18 = $17;
      var $19 = $18+12;
      var $20 = IHEAP[$19];
      var $21 = $20;
      __Z16reallymarkobjectP12global_StateP8GCObject($16, $21);
      ;
    }
    var $23 = $2;
    var $24 = $23;
    var $25 = $24+6;
    var $26 = IHEAP[$25];
    var $27 = $26 != 0;
    ;
    if ($27) {
      ;
      $i = 0;
      ;
      $29$7: while(1) { // $29
        var $30 = $i;
        var $31 = $2;
        var $32 = $31;
        var $33 = $32+7;
        var $34 = IHEAP[$33];
        var $35 = $34;
        var $36 = $30 < $35;
        if (!($36)) { __label__ = 3; /* $78 */ break $29$7; }
        var $38 = $i;
        var $39 = $2;
        var $40 = $39;
        var $41 = $40+20;
        var $42 = $41+$38*12;
        var $43 = $42+8;
        var $44 = IHEAP[$43];
        var $45 = $44 >= 4;
        ;
        $46$74$10: do { 
          if ($45) {
            ;
            var $47 = $i;
            var $48 = $2;
            var $49 = $48;
            var $50 = $49+20;
            var $51 = $50+$47*12;
            var $52 = $51;
            var $53 = $52;
            var $54 = $53;
            var $55 = IHEAP[$54];
            var $56 = $55;
            var $57 = $56;
            var $58 = $57+5;
            var $59 = IHEAP[$58];
            var $60 = $59;
            var $61 = $60 & 3;
            var $62 = $61 != 0;
            if (!($62)) { __label__ = 5; /* $74 */ break $46$74$10; }
            var $64 = $1;
            var $65 = $i;
            var $66 = $2;
            var $67 = $66;
            var $68 = $67+20;
            var $69 = $68+$65*12;
            var $70 = $69;
            var $71 = $70;
            var $72 = $71;
            var $73 = IHEAP[$72];
            __Z16reallymarkobjectP12global_StateP8GCObject($64, $73);
            ;
          }
        } while(0);
        ;
        var $76 = $i;
        var $77 = $76 + 1;
        $i = $77;
        __label__ = 1; /* $29 */ continue $29$7;
      }
      ;
    }
    else {
      ;
      var $80 = $2;
      var $81 = $80;
      var $82 = $81;
      var $83 = $82+16;
      var $84 = IHEAP[$83];
      var $85 = $84;
      var $86 = $85;
      var $87 = $86;
      var $88 = $87+5;
      var $89 = IHEAP[$88];
      var $90 = $89;
      var $91 = $90 & 3;
      var $92 = $91 != 0;
      ;
      if ($92) {
        ;
        var $94 = $1;
        var $95 = $2;
        var $96 = $95;
        var $97 = $96;
        var $98 = $97+16;
        var $99 = IHEAP[$98];
        var $100 = $99;
        __Z16reallymarkobjectP12global_StateP8GCObject($94, $100);
        ;
      }
      $i1 = 0;
      ;
      $102$20: while(1) { // $102
        var $103 = $i1;
        var $104 = $2;
        var $105 = $104;
        var $106 = $105;
        var $107 = $106+7;
        var $108 = IHEAP[$107];
        var $109 = $108;
        var $110 = $103 < $109;
        if (!($110)) { __label__ = 12; /* $141 */ break $102$20; }
        var $112 = $i1;
        var $113 = $2;
        var $114 = $113;
        var $115 = $114;
        var $116 = $115+20;
        var $117 = $116+$112*4;
        var $118 = IHEAP[$117];
        var $119 = $118;
        var $120 = $119;
        var $121 = $120;
        var $122 = $121+5;
        var $123 = IHEAP[$122];
        var $124 = $123;
        var $125 = $124 & 3;
        var $126 = $125 != 0;
        ;
        if ($126) {
          ;
          var $128 = $1;
          var $129 = $i1;
          var $130 = $2;
          var $131 = $130;
          var $132 = $131;
          var $133 = $132+20;
          var $134 = $133+$129*4;
          var $135 = IHEAP[$134];
          var $136 = $135;
          __Z16reallymarkobjectP12global_StateP8GCObject($128, $136);
          ;
        }
        ;
        var $139 = $i1;
        var $140 = $139 + 1;
        $i1 = $140;
        __label__ = 10; /* $102 */ continue $102$20;
      }
      ;
    }
    ;
    return;
  }
  __Z15traverseclosureP12global_StateP7Closure.__index__ = Runtime.getFunctionIndex(__Z15traverseclosureP12global_StateP7Closure, "__Z15traverseclosureP12global_StateP7Closure");
  
  
  function __Z13traversestackP12global_StateP9lua_State($g, $l) {
    ;
    var __label__;
    var $1;
    var $2;
    var $o;
    var $lim;
    var $ci;
    $1 = $g;
    $2 = $l;
    var $3 = $2;
    var $4 = $3+72;
    var $5 = $4+8;
    var $6 = IHEAP[$5];
    var $7 = $6 >= 4;
    ;
    $8$30$2: do { 
      if ($7) {
        ;
        var $9 = $2;
        var $10 = $9+72;
        var $11 = $10;
        var $12 = $11;
        var $13 = $12;
        var $14 = IHEAP[$13];
        var $15 = $14;
        var $16 = $15;
        var $17 = $16+5;
        var $18 = IHEAP[$17];
        var $19 = $18;
        var $20 = $19 & 3;
        var $21 = $20 != 0;
        if (!($21)) { __label__ = 1; /* $30 */ break $8$30$2; }
        var $23 = $1;
        var $24 = $2;
        var $25 = $24+72;
        var $26 = $25;
        var $27 = $26;
        var $28 = $27;
        var $29 = IHEAP[$28];
        __Z16reallymarkobjectP12global_StateP8GCObject($23, $29);
        ;
      }
    } while(0);
    var $31 = $2;
    var $32 = $31+8;
    var $33 = IHEAP[$32];
    $lim = $33;
    var $34 = $2;
    var $35 = $34+40;
    var $36 = IHEAP[$35];
    $ci = $36;
    ;
    $37$6: while(1) { // $37
      var $38 = $ci;
      var $39 = $2;
      var $40 = $39+20;
      var $41 = IHEAP[$40];
      var $42 = $38 <= $41;
      if (!($42)) { __label__ = 5; /* $57 */ break $37$6; }
      var $44 = $lim;
      var $45 = $ci;
      var $46 = $45+8;
      var $47 = IHEAP[$46];
      var $48 = $44 < $47;
      ;
      if ($48) {
        ;
        var $50 = $ci;
        var $51 = $50+8;
        var $52 = IHEAP[$51];
        $lim = $52;
        ;
      }
      ;
      var $55 = $ci;
      var $56 = $55+24;
      $ci = $56;
      __label__ = 3; /* $37 */ continue $37$6;
    }
    var $58 = $2;
    var $59 = $58+32;
    var $60 = IHEAP[$59];
    $o = $60;
    ;
    $61$14: while(1) { // $61
      var $62 = $o;
      var $63 = $2;
      var $64 = $63+8;
      var $65 = IHEAP[$64];
      var $66 = $62 < $65;
      if (!($66)) { __label__ = 10; /* $96 */ break $61$14; }
      var $68 = $o;
      var $69 = $68+8;
      var $70 = IHEAP[$69];
      var $71 = $70 >= 4;
      ;
      $72$92$17: do { 
        if ($71) {
          ;
          var $73 = $o;
          var $74 = $73;
          var $75 = $74;
          var $76 = $75;
          var $77 = IHEAP[$76];
          var $78 = $77;
          var $79 = $78;
          var $80 = $79+5;
          var $81 = IHEAP[$80];
          var $82 = $81;
          var $83 = $82 & 3;
          var $84 = $83 != 0;
          if (!($84)) { __label__ = 12; /* $92 */ break $72$92$17; }
          var $86 = $1;
          var $87 = $o;
          var $88 = $87;
          var $89 = $88;
          var $90 = $89;
          var $91 = IHEAP[$90];
          __Z16reallymarkobjectP12global_StateP8GCObject($86, $91);
          ;
        }
      } while(0);
      ;
      var $94 = $o;
      var $95 = $94+12;
      $o = $95;
      __label__ = 8; /* $61 */ continue $61$14;
    }
    ;
    $97$23: while(1) { // $97
      var $98 = $o;
      var $99 = $lim;
      var $100 = $98 <= $99;
      if (!($100)) { __label__ = 17; /* $107 */ break $97$23; }
      var $102 = $o;
      var $103 = $102+8;
      IHEAP[$103] = 0;
      ;
      var $105 = $o;
      var $106 = $105+12;
      $o = $106;
      __label__ = 15; /* $97 */ continue $97$23;
    }
    var $108 = $2;
    var $109 = $lim;
    __Z15checkstacksizesP9lua_StateP10lua_TValue($108, $109);
    ;
    return;
  }
  __Z13traversestackP12global_StateP9lua_State.__index__ = Runtime.getFunctionIndex(__Z13traversestackP12global_StateP9lua_State, "__Z13traversestackP12global_StateP9lua_State");
  
  
  function __Z13traverseprotoP12global_StateP5Proto($g, $f) {
    ;
    var __label__;
    var $1;
    var $2;
    var $i;
    $1 = $g;
    $2 = $f;
    var $3 = $2;
    var $4 = $3+32;
    var $5 = IHEAP[$4];
    var $6 = $5 != 0;
    ;
    if ($6) {
      ;
      var $8 = $2;
      var $9 = $8+32;
      var $10 = IHEAP[$9];
      var $11 = $10;
      var $12 = $11+5;
      var $13 = IHEAP[$12];
      var $14 = $13;
      var $15 = $14 & 252;
      var $16 = $15;
      IHEAP[$12] = $16;
      ;
    }
    $i = 0;
    ;
    $18$5: while(1) { // $18
      var $19 = $i;
      var $20 = $2;
      var $21 = $20+40;
      var $22 = IHEAP[$21];
      var $23 = $19 < $22;
      if (!($23)) { __label__ = 3; /* $65 */ break $18$5; }
      var $25 = $i;
      var $26 = $2;
      var $27 = $26+8;
      var $28 = IHEAP[$27];
      var $29 = $28+12*$25;
      var $30 = $29+8;
      var $31 = IHEAP[$30];
      var $32 = $31 >= 4;
      ;
      $33$61$8: do { 
        if ($32) {
          ;
          var $34 = $i;
          var $35 = $2;
          var $36 = $35+8;
          var $37 = IHEAP[$36];
          var $38 = $37+12*$34;
          var $39 = $38;
          var $40 = $39;
          var $41 = $40;
          var $42 = IHEAP[$41];
          var $43 = $42;
          var $44 = $43;
          var $45 = $44+5;
          var $46 = IHEAP[$45];
          var $47 = $46;
          var $48 = $47 & 3;
          var $49 = $48 != 0;
          if (!($49)) { __label__ = 5; /* $61 */ break $33$61$8; }
          var $51 = $1;
          var $52 = $i;
          var $53 = $2;
          var $54 = $53+8;
          var $55 = IHEAP[$54];
          var $56 = $55+12*$52;
          var $57 = $56;
          var $58 = $57;
          var $59 = $58;
          var $60 = IHEAP[$59];
          __Z16reallymarkobjectP12global_StateP8GCObject($51, $60);
          ;
        }
      } while(0);
      ;
      var $63 = $i;
      var $64 = $63 + 1;
      $i = $64;
      __label__ = 1; /* $18 */ continue $18$5;
    }
    $i = 0;
    ;
    $66$14: while(1) { // $66
      var $67 = $i;
      var $68 = $2;
      var $69 = $68+36;
      var $70 = IHEAP[$69];
      var $71 = $67 < $70;
      if (!($71)) { __label__ = 10; /* $97 */ break $66$14; }
      var $73 = $i;
      var $74 = $2;
      var $75 = $74+28;
      var $76 = IHEAP[$75];
      var $77 = $76+4*$73;
      var $78 = IHEAP[$77];
      var $79 = $78 != 0;
      ;
      if ($79) {
        ;
        var $81 = $i;
        var $82 = $2;
        var $83 = $82+28;
        var $84 = IHEAP[$83];
        var $85 = $84+4*$81;
        var $86 = IHEAP[$85];
        var $87 = $86;
        var $88 = $87+5;
        var $89 = IHEAP[$88];
        var $90 = $89;
        var $91 = $90 & 252;
        var $92 = $91;
        IHEAP[$88] = $92;
        ;
      }
      ;
      var $95 = $i;
      var $96 = $95 + 1;
      $i = $96;
      __label__ = 8; /* $66 */ continue $66$14;
    }
    $i = 0;
    ;
    $98$22: while(1) { // $98
      var $99 = $i;
      var $100 = $2;
      var $101 = $100+52;
      var $102 = IHEAP[$101];
      var $103 = $99 < $102;
      if (!($103)) { __label__ = 15; /* $141 */ break $98$22; }
      var $105 = $i;
      var $106 = $2;
      var $107 = $106+16;
      var $108 = IHEAP[$107];
      var $109 = $108+4*$105;
      var $110 = IHEAP[$109];
      var $111 = $110 != 0;
      ;
      if ($111) {
        ;
        var $113 = $i;
        var $114 = $2;
        var $115 = $114+16;
        var $116 = IHEAP[$115];
        var $117 = $116+4*$113;
        var $118 = IHEAP[$117];
        var $119 = $118;
        var $120 = $119;
        var $121 = $120;
        var $122 = $121+5;
        var $123 = IHEAP[$122];
        var $124 = $123;
        var $125 = $124 & 3;
        var $126 = $125 != 0;
        ;
        if ($126) {
          ;
          var $128 = $1;
          var $129 = $i;
          var $130 = $2;
          var $131 = $130+16;
          var $132 = IHEAP[$131];
          var $133 = $132+4*$129;
          var $134 = IHEAP[$133];
          var $135 = $134;
          __Z16reallymarkobjectP12global_StateP8GCObject($128, $135);
          ;
        }
        ;
      }
      ;
      var $139 = $i;
      var $140 = $139 + 1;
      $i = $140;
      __label__ = 13; /* $98 */ continue $98$22;
    }
    $i = 0;
    ;
    $142$33: while(1) { // $142
      var $143 = $i;
      var $144 = $2;
      var $145 = $144+56;
      var $146 = IHEAP[$145];
      var $147 = $143 < $146;
      if (!($147)) { __label__ = 21; /* $175 */ break $142$33; }
      var $149 = $i;
      var $150 = $2;
      var $151 = $150+24;
      var $152 = IHEAP[$151];
      var $153 = $152+12*$149;
      var $154 = $153;
      var $155 = IHEAP[$154];
      var $156 = $155 != 0;
      ;
      if ($156) {
        ;
        var $158 = $i;
        var $159 = $2;
        var $160 = $159+24;
        var $161 = IHEAP[$160];
        var $162 = $161+12*$158;
        var $163 = $162;
        var $164 = IHEAP[$163];
        var $165 = $164;
        var $166 = $165+5;
        var $167 = IHEAP[$166];
        var $168 = $167;
        var $169 = $168 & 252;
        var $170 = $169;
        IHEAP[$166] = $170;
        ;
      }
      ;
      var $173 = $i;
      var $174 = $173 + 1;
      $i = $174;
      __label__ = 19; /* $142 */ continue $142$33;
    }
    ;
    return;
  }
  __Z13traverseprotoP12global_StateP5Proto.__index__ = Runtime.getFunctionIndex(__Z13traverseprotoP12global_StateP5Proto, "__Z13traverseprotoP12global_StateP5Proto");
  
  
  function __Z15checkstacksizesP9lua_StateP10lua_TValue($L, $max) {
    ;
    var __label__;
    var $1;
    var $2;
    var $ci_used;
    var $s_used;
    $1 = $L;
    $2 = $max;
    var $3 = $1;
    var $4 = $3+20;
    var $5 = IHEAP[$4];
    var $6 = $1;
    var $7 = $6+40;
    var $8 = IHEAP[$7];
    var $9 = $5;
    var $10 = $8;
    var $11 = $9 - $10;
    var $12 = Math.floor($11 / 24);
    $ci_used = $12;
    var $13 = $2;
    var $14 = $1;
    var $15 = $14+32;
    var $16 = IHEAP[$15];
    var $17 = $13;
    var $18 = $16;
    var $19 = $17 - $18;
    var $20 = Math.floor($19 / 12);
    $s_used = $20;
    var $21 = $1;
    var $22 = $21+48;
    var $23 = IHEAP[$22];
    var $24 = $23 > 20000;
    ;
    $25$26$2: do { 
      if ($24) {
        ;
        ;
      }
      else {
        ;
        var $27 = $ci_used;
        var $28 = 4 * $27;
        var $29 = $1;
        var $30 = $29+48;
        var $31 = IHEAP[$30];
        var $32 = $28 < $31;
        ;
        $33$44$5: do { 
          if ($32) {
            ;
            var $34 = $1;
            var $35 = $34+48;
            var $36 = IHEAP[$35];
            var $37 = 16 < $36;
            if (!($37)) { __label__ = 2; /* $44 */ break $33$44$5; }
            var $39 = $1;
            var $40 = $1;
            var $41 = $40+48;
            var $42 = IHEAP[$41];
            var $43 = Math.floor($42 / 2);
            __Z14luaD_reallocCIP9lua_Statei($39, $43);
            ;
          }
        } while(0);
        var $45 = $s_used;
        var $46 = 4 * $45;
        var $47 = $1;
        var $48 = $47+44;
        var $49 = IHEAP[$48];
        var $50 = $46 < $49;
        if (!($50)) { __label__ = 5; /* $62 */ break $25$26$2; }
        var $52 = $1;
        var $53 = $52+44;
        var $54 = IHEAP[$53];
        var $55 = 90 < $54;
        if (!($55)) { __label__ = 5; /* $62 */ break $25$26$2; }
        var $57 = $1;
        var $58 = $1;
        var $59 = $58+44;
        var $60 = IHEAP[$59];
        var $61 = Math.floor($60 / 2);
        __Z17luaD_reallocstackP9lua_Statei($57, $61);
        ;
      }
    } while(0);
    ;
    return;
  }
  __Z15checkstacksizesP9lua_StateP10lua_TValue.__index__ = Runtime.getFunctionIndex(__Z15checkstacksizesP9lua_StateP10lua_TValue, "__Z15checkstacksizesP9lua_StateP10lua_TValue");
  
  
  function __Z7freeobjP9lua_StateP8GCObject($L, $o) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $L;
    $2 = $o;
    var $3 = $2;
    var $4 = $3;
    var $5 = $4;
    var $6 = $5+4;
    var $7 = IHEAP[$6];
    var $8 = $7;
    if ($8 == 9) {
      __label__ = 1; /* $9 */ 
    }
    else if ($8 == 6) {
      __label__ = 2; /* $14 */ 
    }
    else if ($8 == 10) {
      __label__ = 3; /* $19 */ 
    }
    else if ($8 == 5) {
      __label__ = 4; /* $24 */ 
    }
    else if ($8 == 8) {
      __label__ = 5; /* $29 */ 
    }
    else if ($8 == 4) {
      __label__ = 6; /* $33 */ 
    }
    else if ($8 == 7) {
      __label__ = 7; /* $54 */ 
    }
    else {
    __label__ = 8; /* $66 */ 
    }
    
    if (__label__ == 8) {
      ;
    }
    else if (__label__ == 1) {
      var $10 = $1;
      var $11 = $2;
      var $12 = $11;
      var $13 = $12;
      __Z14luaF_freeprotoP9lua_StateP5Proto($10, $13);
      ;
    }
    else if (__label__ == 2) {
      var $15 = $1;
      var $16 = $2;
      var $17 = $16;
      var $18 = $17;
      __Z16luaF_freeclosureP9lua_StateP7Closure($15, $18);
      ;
    }
    else if (__label__ == 3) {
      var $20 = $1;
      var $21 = $2;
      var $22 = $21;
      var $23 = $22;
      __Z14luaF_freeupvalP9lua_StateP5UpVal($20, $23);
      ;
    }
    else if (__label__ == 4) {
      var $25 = $1;
      var $26 = $2;
      var $27 = $26;
      var $28 = $27;
      __Z9luaH_freeP9lua_StateP5Table($25, $28);
      ;
    }
    else if (__label__ == 5) {
      var $30 = $1;
      var $31 = $2;
      var $32 = $31;
      __Z15luaE_freethreadP9lua_StateS0_($30, $32);
      ;
    }
    else if (__label__ == 6) {
      var $34 = $1;
      var $35 = $34+16;
      var $36 = IHEAP[$35];
      var $37 = $36;
      var $38 = $37+4;
      var $39 = IHEAP[$38];
      var $40 = $39 + -1;
      IHEAP[$38] = $40;
      var $41 = $1;
      var $42 = $2;
      var $43 = $42;
      var $44 = $2;
      var $45 = $44;
      var $46 = $45;
      var $47 = $46;
      var $48 = $47+12;
      var $49 = IHEAP[$48];
      var $50 = $49 + 1;
      var $51 = $50 * 1;
      var $52 = 16 + $51;
      var $53 = __Z13luaM_realloc_P9lua_StatePvjj($41, $43, $52, 0);
      ;
    }
    else if (__label__ == 7) {
      var $55 = $1;
      var $56 = $2;
      var $57 = $56;
      var $58 = $2;
      var $59 = $58;
      var $60 = $59;
      var $61 = $60;
      var $62 = $61+16;
      var $63 = IHEAP[$62];
      var $64 = 20 + $63;
      var $65 = __Z13luaM_realloc_P9lua_StatePvjj($55, $57, $64, 0);
      ;
    }
    ;
    return;
  }
  __Z7freeobjP9lua_StateP8GCObject.__index__ = Runtime.getFunctionIndex(__Z7freeobjP9lua_StateP8GCObject, "__Z7freeobjP9lua_StateP8GCObject");
  
  
  function __Z9luaX_initP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $i;
    var $ts;
    $1 = $L;
    $i = 0;
    ;
    $2$2: while(1) { // $2
      var $3 = $i;
      var $4 = $3 < 21;
      if (!($4)) { __label__ = 2; /* $31 */ break $2$2; }
      var $6 = $1;
      var $7 = $i;
      var $8 = _luaX_tokens+$7*4;
      var $9 = IHEAP[$8];
      var $10 = $i;
      var $11 = _luaX_tokens+$10*4;
      var $12 = IHEAP[$11];
      var $13 = _strlen($12);
      var $14 = __Z12luaS_newlstrP9lua_StatePKcj($6, $9, $13);
      $ts = $14;
      var $15 = $ts;
      var $16 = $15;
      var $17 = $16+5;
      var $18 = IHEAP[$17];
      var $19 = $18;
      var $20 = $19 | 32;
      var $21 = $20;
      IHEAP[$17] = $21;
      var $22 = $i;
      var $23 = $22 + 1;
      var $24 = $23;
      var $25 = $ts;
      var $26 = $25;
      var $27 = $26+6;
      IHEAP[$27] = $24;
      ;
      var $29 = $i;
      var $30 = $29 + 1;
      $i = $30;
      __label__ = 0; /* $2 */ continue $2$2;
    }
    ;
    return;
  }
  __Z9luaX_initP9lua_State.__index__ = Runtime.getFunctionIndex(__Z9luaX_initP9lua_State, "__Z9luaX_initP9lua_State");
  
  
  function __Z14luaX_token2strP8LexStatei($ls, $token) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    $2 = $ls;
    $3 = $token;
    var $4 = $3;
    var $5 = $4 < 257;
    ;
    if ($5) {
      ;
      var $7 = $3;
      var $8 = _iscntrl($7);
      var $9 = $8 != 0;
      ;
      if ($9) {
        ;
        var $11 = $2;
        var $12 = $11+40;
        var $13 = IHEAP[$12];
        var $14 = $3;
        var $15 = __Z16luaO_pushfstringP9lua_StatePKcz($13, __str31, Pointer_make([$14,0,0,0], 0, ALLOC_STACK));
        __lastLabel__ = 0; ;
      }
      else {
        ;
        var $17 = $2;
        var $18 = $17+40;
        var $19 = IHEAP[$18];
        var $20 = $3;
        var $21 = __Z16luaO_pushfstringP9lua_StatePKcz($19, __str32, Pointer_make([$20,0,0,0], 0, ALLOC_STACK));
        __lastLabel__ = 2; ;
      }
      var $23 = __lastLabel__ == 0 ? $15 : ($21);
      $1 = $23;
      ;
    }
    else {
      ;
      var $25 = $3;
      var $26 = $25 - 257;
      var $27 = _luaX_tokens+$26*4;
      var $28 = IHEAP[$27];
      $1 = $28;
      ;
    }
    var $30 = $1;
    ;
    return $30;
  }
  __Z14luaX_token2strP8LexStatei.__index__ = Runtime.getFunctionIndex(__Z14luaX_token2strP8LexStatei, "__Z14luaX_token2strP8LexStatei");
  
  
  function __Z13luaX_lexerrorP8LexStatePKci($ls, $msg, $token) {
    var __stackBase__  = STACKTOP; STACKTOP += 80; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $buff = __stackBase__;
    $1 = $ls;
    $2 = $msg;
    $3 = $token;
    var $4 = $buff;
    var $5 = $1;
    var $6 = $5+52;
    var $7 = IHEAP[$6];
    var $8 = $7+16;
    var $9 = $8;
    __Z12luaO_chunkidPcPKcj($4, $9, 80);
    var $10 = $1;
    var $11 = $10+40;
    var $12 = IHEAP[$11];
    var $13 = $buff;
    var $14 = $1;
    var $15 = $14+4;
    var $16 = IHEAP[$15];
    var $17 = $2;
    var $18 = __Z16luaO_pushfstringP9lua_StatePKcz($12, __str33, Pointer_make([$13,0,0,0,$16,0,0,0,$17,0,0,0], 0, ALLOC_STACK));
    $2 = $18;
    var $19 = $3;
    var $20 = $19 != 0;
    ;
    if ($20) {
      ;
      var $22 = $1;
      var $23 = $22+40;
      var $24 = IHEAP[$23];
      var $25 = $2;
      var $26 = $1;
      var $27 = $3;
      var $28 = __Z8txtTokenP8LexStatei($26, $27);
      var $29 = __Z16luaO_pushfstringP9lua_StatePKcz($24, __str34, Pointer_make([$25,0,0,0,$28,0,0,0], 0, ALLOC_STACK));
      ;
    }
    var $31 = $1;
    var $32 = $31+40;
    var $33 = IHEAP[$32];
    __Z10luaD_throwP9lua_Statei($33, 3);
    STACKTOP = __stackBase__;
    return;
  }
  __Z13luaX_lexerrorP8LexStatePKci.__index__ = Runtime.getFunctionIndex(__Z13luaX_lexerrorP8LexStatePKci, "__Z13luaX_lexerrorP8LexStatePKci");
  
  
  function __Z8txtTokenP8LexStatei($ls, $token) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    $2 = $ls;
    $3 = $token;
    var $4 = $3;
    if ($4 == 285) {
      __label__ = 1; /* $5 */ 
    }
    else if ($4 == 286) {
      __label__ = 1; /* $5 */ 
    }
    else if ($4 == 284) {
      __label__ = 1; /* $5 */ 
    }
    else {
    __label__ = 2; /* $12 */ 
    }
    
    if (__label__ == 2) {
      var $13 = $2;
      var $14 = $3;
      var $15 = __Z14luaX_token2strP8LexStatei($13, $14);
      $1 = $15;
      ;
    }
    else if (__label__ == 1) {
      var $6 = $2;
      __Z4saveP8LexStatei($6, 0);
      var $7 = $2;
      var $8 = $7+48;
      var $9 = IHEAP[$8];
      var $10 = $9;
      var $11 = IHEAP[$10];
      $1 = $11;
      ;
    }
    var $17 = $1;
    ;
    return $17;
  }
  __Z8txtTokenP8LexStatei.__index__ = Runtime.getFunctionIndex(__Z8txtTokenP8LexStatei, "__Z8txtTokenP8LexStatei");
  
  
  function __Z16luaX_syntaxerrorP8LexStatePKc($ls, $msg) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $ls;
    $2 = $msg;
    var $3 = $1;
    var $4 = $2;
    var $5 = $1;
    var $6 = $5+12;
    var $7 = $6;
    var $8 = IHEAP[$7];
    __Z13luaX_lexerrorP8LexStatePKci($3, $4, $8);
    ;
    return;
  }
  __Z16luaX_syntaxerrorP8LexStatePKc.__index__ = Runtime.getFunctionIndex(__Z16luaX_syntaxerrorP8LexStatePKc, "__Z16luaX_syntaxerrorP8LexStatePKc");
  
  
  function __Z14luaX_newstringP8LexStatePKcj($ls, $str, $l) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $L;
    var $ts;
    var $o;
    var $i_o;
    $1 = $ls;
    $2 = $str;
    $3 = $l;
    var $4 = $1;
    var $5 = $4+40;
    var $6 = IHEAP[$5];
    $L = $6;
    var $7 = $L;
    var $8 = $2;
    var $9 = $3;
    var $10 = __Z12luaS_newlstrP9lua_StatePKcj($7, $8, $9);
    $ts = $10;
    var $11 = $L;
    var $12 = $1;
    var $13 = $12+36;
    var $14 = IHEAP[$13];
    var $15 = $14+4;
    var $16 = IHEAP[$15];
    var $17 = $ts;
    var $18 = __Z11luaH_setstrP9lua_StateP5TableP7TString($11, $16, $17);
    $o = $18;
    var $19 = $o;
    var $20 = $19+8;
    var $21 = IHEAP[$20];
    var $22 = $21 == 0;
    ;
    if ($22) {
      ;
      var $24 = $o;
      $i_o = $24;
      var $25 = $i_o;
      var $26 = $25;
      var $27 = $26;
      var $28 = $27;
      IHEAP[$28] = 1;
      var $29 = $i_o;
      var $30 = $29+8;
      IHEAP[$30] = 1;
      ;
    }
    var $32 = $ts;
    ;
    return $32;
  }
  __Z14luaX_newstringP8LexStatePKcj.__index__ = Runtime.getFunctionIndex(__Z14luaX_newstringP8LexStatePKcj, "__Z14luaX_newstringP8LexStatePKcj");
  
  
  function __Z13luaX_setinputP9lua_StateP8LexStateP3ZioP7TString($L, $ls, $z, $source) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $4;
    $1 = $L;
    $2 = $ls;
    $3 = $z;
    $4 = $source;
    var $5 = $2;
    var $6 = $5+56;
    IHEAP[$6] = 46;
    var $7 = $1;
    var $8 = $2;
    var $9 = $8+40;
    IHEAP[$9] = $7;
    var $10 = $2;
    var $11 = $10+24;
    var $12 = $11;
    IHEAP[$12] = 287;
    var $13 = $3;
    var $14 = $2;
    var $15 = $14+44;
    IHEAP[$15] = $13;
    var $16 = $2;
    var $17 = $16+36;
    IHEAP[$17] = 0;
    var $18 = $2;
    var $19 = $18+4;
    IHEAP[$19] = 1;
    var $20 = $2;
    var $21 = $20+8;
    IHEAP[$21] = 1;
    var $22 = $4;
    var $23 = $2;
    var $24 = $23+52;
    IHEAP[$24] = $22;
    var $25 = $2;
    var $26 = $25+40;
    var $27 = IHEAP[$26];
    var $28 = $2;
    var $29 = $28+48;
    var $30 = IHEAP[$29];
    var $31 = $30;
    var $32 = IHEAP[$31];
    var $33 = $2;
    var $34 = $33+48;
    var $35 = IHEAP[$34];
    var $36 = $35+8;
    var $37 = IHEAP[$36];
    var $38 = $37 * 1;
    var $39 = __Z13luaM_realloc_P9lua_StatePvjj($27, $32, $38, 32);
    var $40 = $2;
    var $41 = $40+48;
    var $42 = IHEAP[$41];
    var $43 = $42;
    IHEAP[$43] = $39;
    var $44 = $2;
    var $45 = $44+48;
    var $46 = IHEAP[$45];
    var $47 = $46+8;
    IHEAP[$47] = 32;
    var $48 = $2;
    var $49 = $48+44;
    var $50 = IHEAP[$49];
    var $51 = $50;
    var $52 = IHEAP[$51];
    var $53 = $52 + -1;
    IHEAP[$51] = $53;
    var $54 = unSign($52, 32) > unSign(0, 32);
    ;
    if ($54) {
      ;
      var $56 = $2;
      var $57 = $56+44;
      var $58 = IHEAP[$57];
      var $59 = $58+4;
      var $60 = IHEAP[$59];
      var $61 = $60+1;
      IHEAP[$59] = $61;
      var $62 = IHEAP[$60];
      var $63 = $62;
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $65 = $2;
      var $66 = $65+44;
      var $67 = IHEAP[$66];
      var $68 = __Z9luaZ_fillP3Zio($67);
      __lastLabel__ = 2; ;
    }
    var $70 = __lastLabel__ == 0 ? $63 : ($68);
    var $71 = $2;
    var $72 = $71;
    IHEAP[$72] = $70;
    ;
    return;
  }
  __Z13luaX_setinputP9lua_StateP8LexStateP3ZioP7TString.__index__ = Runtime.getFunctionIndex(__Z13luaX_setinputP9lua_StateP8LexStateP3ZioP7TString, "__Z13luaX_setinputP9lua_StateP8LexStateP3ZioP7TString");
  
  
  function __Z9luaX_nextP8LexState($ls) {
    ;
    var __label__;
    var $1;
    $1 = $ls;
    var $2 = $1;
    var $3 = $2+4;
    var $4 = IHEAP[$3];
    var $5 = $1;
    var $6 = $5+8;
    IHEAP[$6] = $4;
    var $7 = $1;
    var $8 = $7+24;
    var $9 = $8;
    var $10 = IHEAP[$9];
    var $11 = $10 != 287;
    ;
    if ($11) {
      ;
      var $13 = $1;
      var $14 = $13+12;
      var $15 = $1;
      var $16 = $15+24;
      var $17 = $14;
      var $18 = $16;
      _llvm_memcpy_p0i8_p0i8_i32($17, $18, 12, 4, 0);
      var $19 = $1;
      var $20 = $19+24;
      var $21 = $20;
      IHEAP[$21] = 287;
      ;
    }
    else {
      ;
      var $23 = $1;
      var $24 = $1;
      var $25 = $24+12;
      var $26 = $25+4;
      var $27 = __Z4llexP8LexStateP7SemInfo($23, $26);
      var $28 = $1;
      var $29 = $28+12;
      var $30 = $29;
      IHEAP[$30] = $27;
      ;
    }
    ;
    return;
  }
  __Z9luaX_nextP8LexState.__index__ = Runtime.getFunctionIndex(__Z9luaX_nextP8LexState, "__Z9luaX_nextP8LexState");
  
  
  function __Z4llexP8LexStateP7SemInfo($ls, $seminfo) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $sep;
    var $sep1;
    var $ts;
    var $c;
    $2 = $ls;
    $3 = $seminfo;
    var $4 = $2;
    var $5 = $4+48;
    var $6 = IHEAP[$5];
    var $7 = $6+4;
    IHEAP[$7] = 0;
    ;
    $8$2: while(1) { // $8
      var $9 = $2;
      var $10 = $9;
      var $11 = IHEAP[$10];
      if ($11 == 10) {
        __label__ = 70; /* $12 */ 
      }
      else if ($11 == 13) {
        __label__ = 70; /* $12 */ 
      }
      else if ($11 == 45) {
        __label__ = 71; /* $14 */ 
      }
      else if ($11 == 91) {
        __label__ = 72; /* $137 */ break $8$2;
      }
      else if ($11 == 61) {
        __label__ = 23; /* $154 */ break $8$2;
      }
      else if ($11 == 60) {
        __label__ = 73; /* $211 */ break $8$2;
      }
      else if ($11 == 62) {
        __label__ = 74; /* $268 */ break $8$2;
      }
      else if ($11 == 126) {
        __label__ = 75; /* $325 */ break $8$2;
      }
      else if ($11 == 34) {
        __label__ = 76; /* $382 */ break $8$2;
      }
      else if ($11 == 39) {
        __label__ = 76; /* $382 */ break $8$2;
      }
      else if ($11 == 46) {
        __label__ = 77; /* $388 */ break $8$2;
      }
      else if ($11 == -1) {
        __label__ = 78; /* $437 */ break $8$2;
      }
      else {
      __label__ = 79; /* $438 */ 
      }
      
      if (__label__ == 79) {
        var $439 = $2;
        var $440 = $439;
        var $441 = IHEAP[$440];
        var $442 = _isspace($441);
        var $443 = $442 != 0;
        if (!($443)) { __label__ = 53; /* $470 */ break $8$2; }
        var $445 = $2;
        var $446 = $445+44;
        var $447 = IHEAP[$446];
        var $448 = $447;
        var $449 = IHEAP[$448];
        var $450 = $449 + -1;
        IHEAP[$448] = $450;
        var $451 = unSign($449, 32) > unSign(0, 32);
        ;
        if ($451) {
          ;
          var $453 = $2;
          var $454 = $453+44;
          var $455 = IHEAP[$454];
          var $456 = $455+4;
          var $457 = IHEAP[$456];
          var $458 = $457+1;
          IHEAP[$456] = $458;
          var $459 = IHEAP[$457];
          var $460 = $459;
          __lastLabel__ = 54; ;
        }
        else {
          ;
          var $462 = $2;
          var $463 = $462+44;
          var $464 = IHEAP[$463];
          var $465 = __Z9luaZ_fillP3Zio($464);
          __lastLabel__ = 56; ;
        }
        var $467 = __lastLabel__ == 54 ? $460 : ($465);
        var $468 = $2;
        var $469 = $468;
        IHEAP[$469] = $467;
        __label__ = 0; /* $8 */ continue $8$2;
      }
      else if (__label__ == 70) {
        var $13 = $2;
        __Z13inclinenumberP8LexState($13);
        __label__ = 0; /* $8 */ continue $8$2;
      }
      else if (__label__ == 71) {
        var $15 = $2;
        var $16 = $15+44;
        var $17 = IHEAP[$16];
        var $18 = $17;
        var $19 = IHEAP[$18];
        var $20 = $19 + -1;
        IHEAP[$18] = $20;
        var $21 = unSign($19, 32) > unSign(0, 32);
        ;
        if ($21) {
          ;
          var $23 = $2;
          var $24 = $23+44;
          var $25 = IHEAP[$24];
          var $26 = $25+4;
          var $27 = IHEAP[$26];
          var $28 = $27+1;
          IHEAP[$26] = $28;
          var $29 = IHEAP[$27];
          var $30 = $29;
          __lastLabel__ = 1; ;
        }
        else {
          ;
          var $32 = $2;
          var $33 = $32+44;
          var $34 = IHEAP[$33];
          var $35 = __Z9luaZ_fillP3Zio($34);
          __lastLabel__ = 3; ;
        }
        var $37 = __lastLabel__ == 1 ? $30 : ($35);
        var $38 = $2;
        var $39 = $38;
        IHEAP[$39] = $37;
        var $40 = $2;
        var $41 = $40;
        var $42 = IHEAP[$41];
        var $43 = $42 != 45;
        if ($43) { __label__ = 4; /* $44 */ break $8$2; }
        var $46 = $2;
        var $47 = $46+44;
        var $48 = IHEAP[$47];
        var $49 = $48;
        var $50 = IHEAP[$49];
        var $51 = $50 + -1;
        IHEAP[$49] = $51;
        var $52 = unSign($50, 32) > unSign(0, 32);
        ;
        if ($52) {
          ;
          var $54 = $2;
          var $55 = $54+44;
          var $56 = IHEAP[$55];
          var $57 = $56+4;
          var $58 = IHEAP[$57];
          var $59 = $58+1;
          IHEAP[$57] = $59;
          var $60 = IHEAP[$58];
          var $61 = $60;
          __lastLabel__ = 7; ;
        }
        else {
          ;
          var $63 = $2;
          var $64 = $63+44;
          var $65 = IHEAP[$64];
          var $66 = __Z9luaZ_fillP3Zio($65);
          __lastLabel__ = 9; ;
        }
        var $68 = __lastLabel__ == 7 ? $61 : ($66);
        var $69 = $2;
        var $70 = $69;
        IHEAP[$70] = $68;
        var $71 = $2;
        var $72 = $71;
        var $73 = IHEAP[$72];
        var $74 = $73 == 91;
        ;
        if ($74) {
          ;
          var $76 = $2;
          var $77 = __Z8skip_sepP8LexState($76);
          $sep = $77;
          var $78 = $2;
          var $79 = $78+48;
          var $80 = IHEAP[$79];
          var $81 = $80+4;
          IHEAP[$81] = 0;
          var $82 = $sep;
          var $83 = $82 >= 0;
          ;
          if ($83) {
            ;
            var $85 = $2;
            var $86 = $sep;
            __Z16read_long_stringP8LexStateP7SemInfoi($85, 0, $86);
            var $87 = $2;
            var $88 = $87+48;
            var $89 = IHEAP[$88];
            var $90 = $89+4;
            IHEAP[$90] = 0;
            __label__ = 0; /* $8 */ continue $8$2;
          }
          else {
            ;
            ;
          }
        }
        ;
        $93$28: while(1) { // $93
          var $94 = $2;
          var $95 = $94;
          var $96 = IHEAP[$95];
          var $97 = $96 == 10;
          ;
          $108$98$30: do { 
            if ($97) {
              __lastLabel__ = 11; ;
            }
            else {
              __lastLabel__ = 11; ;
              var $99 = $2;
              var $100 = $99;
              var $101 = IHEAP[$100];
              var $102 = $101 == 13;
              if ($102) { __lastLabel__ = 12; __label__ = 13; /* $108 */ break $108$98$30; } else { __lastLabel__ = 12; ; }
              var $104 = $2;
              var $105 = $104;
              var $106 = IHEAP[$105];
              var $107 = $106 != -1;
              __lastLabel__ = 14; ;
            }
          } while(0);
          var $109 = __lastLabel__ == 12 ? 0 : (__lastLabel__ == 11 ? 0 : ($107));
          if (!($109)) { __label__ = 17; /* $136 */ break $93$28; }
          var $111 = $2;
          var $112 = $111+44;
          var $113 = IHEAP[$112];
          var $114 = $113;
          var $115 = IHEAP[$114];
          var $116 = $115 + -1;
          IHEAP[$114] = $116;
          var $117 = unSign($115, 32) > unSign(0, 32);
          ;
          if ($117) {
            ;
            var $119 = $2;
            var $120 = $119+44;
            var $121 = IHEAP[$120];
            var $122 = $121+4;
            var $123 = IHEAP[$122];
            var $124 = $123+1;
            IHEAP[$122] = $124;
            var $125 = IHEAP[$123];
            var $126 = $125;
            __lastLabel__ = 18; ;
          }
          else {
            ;
            var $128 = $2;
            var $129 = $128+44;
            var $130 = IHEAP[$129];
            var $131 = __Z9luaZ_fillP3Zio($130);
            __lastLabel__ = 20; ;
          }
          var $133 = __lastLabel__ == 18 ? $126 : ($131);
          var $134 = $2;
          var $135 = $134;
          IHEAP[$135] = $133;
          __label__ = 11; /* $93 */ continue $93$28;
        }
        __label__ = 0; /* $8 */ continue $8$2;
      }
    }
    $137$154$211$268$325$382$388$437$44$470$40: do { 
      if (__label__ == 72) {
        var $138 = $2;
        var $139 = __Z8skip_sepP8LexState($138);
        $sep1 = $139;
        var $140 = $sep1;
        var $141 = $140 >= 0;
        ;
        if ($141) {
          ;
          var $143 = $2;
          var $144 = $3;
          var $145 = $sep1;
          __Z16read_long_stringP8LexStateP7SemInfoi($143, $144, $145);
          $1 = 286;
          __label__ = 6; /* $596 */ break $137$154$211$268$325$382$388$437$44$470$40;
        }
        else {
          ;
          var $147 = $sep1;
          var $148 = $147 == -1;
          ;
          if ($148) {
            ;
            $1 = 91;
            __label__ = 6; /* $596 */ break $137$154$211$268$325$382$388$437$44$470$40;
          }
          else {
            ;
            var $151 = $2;
            __Z13luaX_lexerrorP8LexStatePKci($151, __str35, 286);
            ;
            ;
            __label__ = 23; /* $154 */ break $137$154$211$268$325$382$388$437$44$470$40;
          }
        }
      }
      else if (__label__ == 73) {
        var $212 = $2;
        var $213 = $212+44;
        var $214 = IHEAP[$213];
        var $215 = $214;
        var $216 = IHEAP[$215];
        var $217 = $216 + -1;
        IHEAP[$215] = $217;
        var $218 = unSign($216, 32) > unSign(0, 32);
        ;
        if ($218) {
          ;
          var $220 = $2;
          var $221 = $220+44;
          var $222 = IHEAP[$221];
          var $223 = $222+4;
          var $224 = IHEAP[$223];
          var $225 = $224+1;
          IHEAP[$223] = $225;
          var $226 = IHEAP[$224];
          var $227 = $226;
          __lastLabel__ = 31; ;
        }
        else {
          ;
          var $229 = $2;
          var $230 = $229+44;
          var $231 = IHEAP[$230];
          var $232 = __Z9luaZ_fillP3Zio($231);
          __lastLabel__ = 33; ;
        }
        var $234 = __lastLabel__ == 31 ? $227 : ($232);
        var $235 = $2;
        var $236 = $235;
        IHEAP[$236] = $234;
        var $237 = $2;
        var $238 = $237;
        var $239 = IHEAP[$238];
        var $240 = $239 != 61;
        ;
        if ($240) {
          ;
          $1 = 60;
          __label__ = 6; /* $596 */ break $137$154$211$268$325$382$388$437$44$470$40;
        }
        else {
          ;
          var $243 = $2;
          var $244 = $243+44;
          var $245 = IHEAP[$244];
          var $246 = $245;
          var $247 = IHEAP[$246];
          var $248 = $247 + -1;
          IHEAP[$246] = $248;
          var $249 = unSign($247, 32) > unSign(0, 32);
          ;
          if ($249) {
            ;
            var $251 = $2;
            var $252 = $251+44;
            var $253 = IHEAP[$252];
            var $254 = $253+4;
            var $255 = IHEAP[$254];
            var $256 = $255+1;
            IHEAP[$254] = $256;
            var $257 = IHEAP[$255];
            var $258 = $257;
            __lastLabel__ = 34; ;
          }
          else {
            ;
            var $260 = $2;
            var $261 = $260+44;
            var $262 = IHEAP[$261];
            var $263 = __Z9luaZ_fillP3Zio($262);
            __lastLabel__ = 36; ;
          }
          var $265 = __lastLabel__ == 34 ? $258 : ($263);
          var $266 = $2;
          var $267 = $266;
          IHEAP[$267] = $265;
          $1 = 282;
          __label__ = 6; /* $596 */ break $137$154$211$268$325$382$388$437$44$470$40;
        }
      }
      else if (__label__ == 74) {
        var $269 = $2;
        var $270 = $269+44;
        var $271 = IHEAP[$270];
        var $272 = $271;
        var $273 = IHEAP[$272];
        var $274 = $273 + -1;
        IHEAP[$272] = $274;
        var $275 = unSign($273, 32) > unSign(0, 32);
        ;
        if ($275) {
          ;
          var $277 = $2;
          var $278 = $277+44;
          var $279 = IHEAP[$278];
          var $280 = $279+4;
          var $281 = IHEAP[$280];
          var $282 = $281+1;
          IHEAP[$280] = $282;
          var $283 = IHEAP[$281];
          var $284 = $283;
          __lastLabel__ = 37; ;
        }
        else {
          ;
          var $286 = $2;
          var $287 = $286+44;
          var $288 = IHEAP[$287];
          var $289 = __Z9luaZ_fillP3Zio($288);
          __lastLabel__ = 39; ;
        }
        var $291 = __lastLabel__ == 37 ? $284 : ($289);
        var $292 = $2;
        var $293 = $292;
        IHEAP[$293] = $291;
        var $294 = $2;
        var $295 = $294;
        var $296 = IHEAP[$295];
        var $297 = $296 != 61;
        ;
        if ($297) {
          ;
          $1 = 62;
          __label__ = 6; /* $596 */ break $137$154$211$268$325$382$388$437$44$470$40;
        }
        else {
          ;
          var $300 = $2;
          var $301 = $300+44;
          var $302 = IHEAP[$301];
          var $303 = $302;
          var $304 = IHEAP[$303];
          var $305 = $304 + -1;
          IHEAP[$303] = $305;
          var $306 = unSign($304, 32) > unSign(0, 32);
          ;
          if ($306) {
            ;
            var $308 = $2;
            var $309 = $308+44;
            var $310 = IHEAP[$309];
            var $311 = $310+4;
            var $312 = IHEAP[$311];
            var $313 = $312+1;
            IHEAP[$311] = $313;
            var $314 = IHEAP[$312];
            var $315 = $314;
            __lastLabel__ = 40; ;
          }
          else {
            ;
            var $317 = $2;
            var $318 = $317+44;
            var $319 = IHEAP[$318];
            var $320 = __Z9luaZ_fillP3Zio($319);
            __lastLabel__ = 42; ;
          }
          var $322 = __lastLabel__ == 40 ? $315 : ($320);
          var $323 = $2;
          var $324 = $323;
          IHEAP[$324] = $322;
          $1 = 281;
          __label__ = 6; /* $596 */ break $137$154$211$268$325$382$388$437$44$470$40;
        }
      }
      else if (__label__ == 75) {
        var $326 = $2;
        var $327 = $326+44;
        var $328 = IHEAP[$327];
        var $329 = $328;
        var $330 = IHEAP[$329];
        var $331 = $330 + -1;
        IHEAP[$329] = $331;
        var $332 = unSign($330, 32) > unSign(0, 32);
        ;
        if ($332) {
          ;
          var $334 = $2;
          var $335 = $334+44;
          var $336 = IHEAP[$335];
          var $337 = $336+4;
          var $338 = IHEAP[$337];
          var $339 = $338+1;
          IHEAP[$337] = $339;
          var $340 = IHEAP[$338];
          var $341 = $340;
          __lastLabel__ = 43; ;
        }
        else {
          ;
          var $343 = $2;
          var $344 = $343+44;
          var $345 = IHEAP[$344];
          var $346 = __Z9luaZ_fillP3Zio($345);
          __lastLabel__ = 45; ;
        }
        var $348 = __lastLabel__ == 43 ? $341 : ($346);
        var $349 = $2;
        var $350 = $349;
        IHEAP[$350] = $348;
        var $351 = $2;
        var $352 = $351;
        var $353 = IHEAP[$352];
        var $354 = $353 != 61;
        ;
        if ($354) {
          ;
          $1 = 126;
          __label__ = 6; /* $596 */ break $137$154$211$268$325$382$388$437$44$470$40;
        }
        else {
          ;
          var $357 = $2;
          var $358 = $357+44;
          var $359 = IHEAP[$358];
          var $360 = $359;
          var $361 = IHEAP[$360];
          var $362 = $361 + -1;
          IHEAP[$360] = $362;
          var $363 = unSign($361, 32) > unSign(0, 32);
          ;
          if ($363) {
            ;
            var $365 = $2;
            var $366 = $365+44;
            var $367 = IHEAP[$366];
            var $368 = $367+4;
            var $369 = IHEAP[$368];
            var $370 = $369+1;
            IHEAP[$368] = $370;
            var $371 = IHEAP[$369];
            var $372 = $371;
            __lastLabel__ = 46; ;
          }
          else {
            ;
            var $374 = $2;
            var $375 = $374+44;
            var $376 = IHEAP[$375];
            var $377 = __Z9luaZ_fillP3Zio($376);
            __lastLabel__ = 48; ;
          }
          var $379 = __lastLabel__ == 46 ? $372 : ($377);
          var $380 = $2;
          var $381 = $380;
          IHEAP[$381] = $379;
          $1 = 283;
          __label__ = 6; /* $596 */ break $137$154$211$268$325$382$388$437$44$470$40;
        }
      }
      else if (__label__ == 76) {
        var $383 = $2;
        var $384 = $2;
        var $385 = $384;
        var $386 = IHEAP[$385];
        var $387 = $3;
        __Z11read_stringP8LexStateiP7SemInfo($383, $386, $387);
        $1 = 286;
        __label__ = 6; /* $596 */ break $137$154$211$268$325$382$388$437$44$470$40;
      }
      else if (__label__ == 77) {
        var $389 = $2;
        var $390 = $2;
        var $391 = $390;
        var $392 = IHEAP[$391];
        __Z4saveP8LexStatei($389, $392);
        var $393 = $2;
        var $394 = $393+44;
        var $395 = IHEAP[$394];
        var $396 = $395;
        var $397 = IHEAP[$396];
        var $398 = $397 + -1;
        IHEAP[$396] = $398;
        var $399 = unSign($397, 32) > unSign(0, 32);
        ;
        if ($399) {
          ;
          var $401 = $2;
          var $402 = $401+44;
          var $403 = IHEAP[$402];
          var $404 = $403+4;
          var $405 = IHEAP[$404];
          var $406 = $405+1;
          IHEAP[$404] = $406;
          var $407 = IHEAP[$405];
          var $408 = $407;
          __lastLabel__ = 49; ;
        }
        else {
          ;
          var $410 = $2;
          var $411 = $410+44;
          var $412 = IHEAP[$411];
          var $413 = __Z9luaZ_fillP3Zio($412);
          __lastLabel__ = 51; ;
        }
        var $415 = __lastLabel__ == 49 ? $408 : ($413);
        var $416 = $2;
        var $417 = $416;
        IHEAP[$417] = $415;
        var $418 = $2;
        var $419 = __Z10check_nextP8LexStatePKc($418, __str36);
        var $420 = $419 != 0;
        ;
        if ($420) {
          ;
          var $422 = $2;
          var $423 = __Z10check_nextP8LexStatePKc($422, __str36);
          var $424 = $423 != 0;
          ;
          if ($424) {
            ;
            $1 = 279;
            __label__ = 6; /* $596 */ break $137$154$211$268$325$382$388$437$44$470$40;
          }
          else {
            ;
            $1 = 278;
            __label__ = 6; /* $596 */ break $137$154$211$268$325$382$388$437$44$470$40;
          }
        }
        else {
          ;
          var $428 = $2;
          var $429 = $428;
          var $430 = IHEAP[$429];
          var $431 = _isdigit($430);
          var $432 = $431 != 0;
          ;
          if ($432) {
            ;
            var $435 = $2;
            var $436 = $3;
            __Z12read_numeralP8LexStateP7SemInfo($435, $436);
            $1 = 284;
            __label__ = 6; /* $596 */ break $137$154$211$268$325$382$388$437$44$470$40;
          }
          else {
            ;
            $1 = 46;
            __label__ = 6; /* $596 */ break $137$154$211$268$325$382$388$437$44$470$40;
          }
        }
      }
      else if (__label__ == 78) {
        $1 = 287;
        __label__ = 6; /* $596 */ break $137$154$211$268$325$382$388$437$44$470$40;
      }
      else if (__label__ == 4) {
        $1 = 45;
        __label__ = 6; /* $596 */ break $137$154$211$268$325$382$388$437$44$470$40;
      }
      else if (__label__ == 53) {
        var $471 = $2;
        var $472 = $471;
        var $473 = IHEAP[$472];
        var $474 = _isdigit($473);
        var $475 = $474 != 0;
        ;
        if ($475) {
          ;
          var $477 = $2;
          var $478 = $3;
          __Z12read_numeralP8LexStateP7SemInfo($477, $478);
          $1 = 284;
          __label__ = 6; /* $596 */ break $137$154$211$268$325$382$388$437$44$470$40;
        }
        else {
          ;
          var $480 = $2;
          var $481 = $480;
          var $482 = IHEAP[$481];
          var $483 = _isalpha($482);
          var $484 = $483 != 0;
          ;
          $490$485$107: do { 
            if (!$484) {
              ;
              var $486 = $2;
              var $487 = $486;
              var $488 = IHEAP[$487];
              var $489 = $488 == 95;
              if ($489) { __label__ = 57; /* $490 */ break $490$485$107; }
              var $567 = $2;
              var $568 = $567;
              var $569 = IHEAP[$568];
              $c = $569;
              var $570 = $2;
              var $571 = $570+44;
              var $572 = IHEAP[$571];
              var $573 = $572;
              var $574 = IHEAP[$573];
              var $575 = $574 + -1;
              IHEAP[$573] = $575;
              var $576 = unSign($574, 32) > unSign(0, 32);
              ;
              if ($576) {
                ;
                var $578 = $2;
                var $579 = $578+44;
                var $580 = IHEAP[$579];
                var $581 = $580+4;
                var $582 = IHEAP[$581];
                var $583 = $582+1;
                IHEAP[$581] = $583;
                var $584 = IHEAP[$582];
                var $585 = $584;
                __lastLabel__ = 67; ;
              }
              else {
                ;
                var $587 = $2;
                var $588 = $587+44;
                var $589 = IHEAP[$588];
                var $590 = __Z9luaZ_fillP3Zio($589);
                __lastLabel__ = 69; ;
              }
              var $592 = __lastLabel__ == 67 ? $585 : ($590);
              var $593 = $2;
              var $594 = $593;
              IHEAP[$594] = $592;
              var $595 = $c;
              $1 = $595;
              __label__ = 6; /* $596 */ break $137$154$211$268$325$382$388$437$44$470$40;
            }
          } while(0);
          ;
          $491$115: while(1) { // $491
            var $492 = $2;
            var $493 = $2;
            var $494 = $493;
            var $495 = IHEAP[$494];
            __Z4saveP8LexStatei($492, $495);
            var $496 = $2;
            var $497 = $496+44;
            var $498 = IHEAP[$497];
            var $499 = $498;
            var $500 = IHEAP[$499];
            var $501 = $500 + -1;
            IHEAP[$499] = $501;
            var $502 = unSign($500, 32) > unSign(0, 32);
            ;
            if ($502) {
              ;
              var $504 = $2;
              var $505 = $504+44;
              var $506 = IHEAP[$505];
              var $507 = $506+4;
              var $508 = IHEAP[$507];
              var $509 = $508+1;
              IHEAP[$507] = $509;
              var $510 = IHEAP[$508];
              var $511 = $510;
              __lastLabel__ = 60; ;
            }
            else {
              ;
              var $513 = $2;
              var $514 = $513+44;
              var $515 = IHEAP[$514];
              var $516 = __Z9luaZ_fillP3Zio($515);
              __lastLabel__ = 62; ;
            }
            var $518 = __lastLabel__ == 60 ? $511 : ($516);
            var $519 = $2;
            var $520 = $519;
            IHEAP[$520] = $518;
            ;
            var $522 = $2;
            var $523 = $522;
            var $524 = IHEAP[$523];
            var $525 = _isalnum($524);
            var $526 = $525 != 0;
            ;
            if ($526) {
              __lastLabel__ = 63; ;
            }
            else {
              __lastLabel__ = 63; ;
              var $528 = $2;
              var $529 = $528;
              var $530 = IHEAP[$529];
              var $531 = $530 == 95;
              __lastLabel__ = 64; ;
            }
            var $533 = __lastLabel__ == 63 ? 1 : ($531);
            if ($533) { __label__ = 59; /* $491 */ continue $491$115; } else { __label__ = 66; /* $534 */ break $491$115; }
          }
          var $535 = $2;
          var $536 = $2;
          var $537 = $536+48;
          var $538 = IHEAP[$537];
          var $539 = $538;
          var $540 = IHEAP[$539];
          var $541 = $2;
          var $542 = $541+48;
          var $543 = IHEAP[$542];
          var $544 = $543+4;
          var $545 = IHEAP[$544];
          var $546 = __Z14luaX_newstringP8LexStatePKcj($535, $540, $545);
          $ts = $546;
          var $547 = $ts;
          var $548 = $547;
          var $549 = $548+6;
          var $550 = IHEAP[$549];
          var $551 = $550;
          var $552 = $551 > 0;
          ;
          if ($552) {
            ;
            var $554 = $ts;
            var $555 = $554;
            var $556 = $555+6;
            var $557 = IHEAP[$556];
            var $558 = $557;
            var $559 = $558 - 1;
            var $560 = $559 + 257;
            $1 = $560;
            __label__ = 6; /* $596 */ break $137$154$211$268$325$382$388$437$44$470$40;
          }
          else {
            ;
            var $562 = $ts;
            var $563 = $3;
            var $564 = $563;
            var $565 = $564;
            IHEAP[$565] = $562;
            $1 = 285;
            __label__ = 6; /* $596 */ break $137$154$211$268$325$382$388$437$44$470$40;
          }
        }
      }
    } while(0);
    if (__label__ == 23) {
      var $155 = $2;
      var $156 = $155+44;
      var $157 = IHEAP[$156];
      var $158 = $157;
      var $159 = IHEAP[$158];
      var $160 = $159 + -1;
      IHEAP[$158] = $160;
      var $161 = unSign($159, 32) > unSign(0, 32);
      ;
      if ($161) {
        ;
        var $163 = $2;
        var $164 = $163+44;
        var $165 = IHEAP[$164];
        var $166 = $165+4;
        var $167 = IHEAP[$166];
        var $168 = $167+1;
        IHEAP[$166] = $168;
        var $169 = IHEAP[$167];
        var $170 = $169;
        __lastLabel__ = 24; ;
      }
      else {
        ;
        var $172 = $2;
        var $173 = $172+44;
        var $174 = IHEAP[$173];
        var $175 = __Z9luaZ_fillP3Zio($174);
        __lastLabel__ = 26; ;
      }
      var $177 = __lastLabel__ == 24 ? $170 : ($175);
      var $178 = $2;
      var $179 = $178;
      IHEAP[$179] = $177;
      var $180 = $2;
      var $181 = $180;
      var $182 = IHEAP[$181];
      var $183 = $182 != 61;
      ;
      if ($183) {
        ;
        $1 = 61;
        ;
      }
      else {
        ;
        var $186 = $2;
        var $187 = $186+44;
        var $188 = IHEAP[$187];
        var $189 = $188;
        var $190 = IHEAP[$189];
        var $191 = $190 + -1;
        IHEAP[$189] = $191;
        var $192 = unSign($190, 32) > unSign(0, 32);
        ;
        if ($192) {
          ;
          var $194 = $2;
          var $195 = $194+44;
          var $196 = IHEAP[$195];
          var $197 = $196+4;
          var $198 = IHEAP[$197];
          var $199 = $198+1;
          IHEAP[$197] = $199;
          var $200 = IHEAP[$198];
          var $201 = $200;
          __lastLabel__ = 28; ;
        }
        else {
          ;
          var $203 = $2;
          var $204 = $203+44;
          var $205 = IHEAP[$204];
          var $206 = __Z9luaZ_fillP3Zio($205);
          __lastLabel__ = 30; ;
        }
        var $208 = __lastLabel__ == 28 ? $201 : ($206);
        var $209 = $2;
        var $210 = $209;
        IHEAP[$210] = $208;
        $1 = 280;
        ;
      }
    }
    var $597 = $1;
    ;
    return $597;
  }
  __Z4llexP8LexStateP7SemInfo.__index__ = Runtime.getFunctionIndex(__Z4llexP8LexStateP7SemInfo, "__Z4llexP8LexStateP7SemInfo");
  
  
  function __Z14luaX_lookaheadP8LexState($ls) {
    ;
    var __label__;
    var $1;
    $1 = $ls;
    var $2 = $1;
    var $3 = $1;
    var $4 = $3+24;
    var $5 = $4+4;
    var $6 = __Z4llexP8LexStateP7SemInfo($2, $5);
    var $7 = $1;
    var $8 = $7+24;
    var $9 = $8;
    IHEAP[$9] = $6;
    ;
    return;
  }
  __Z14luaX_lookaheadP8LexState.__index__ = Runtime.getFunctionIndex(__Z14luaX_lookaheadP8LexState, "__Z14luaX_lookaheadP8LexState");
  
  
  function __Z13inclinenumberP8LexState($ls) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $old;
    $1 = $ls;
    var $2 = $1;
    var $3 = $2;
    var $4 = IHEAP[$3];
    $old = $4;
    var $5 = $1;
    var $6 = $5+44;
    var $7 = IHEAP[$6];
    var $8 = $7;
    var $9 = IHEAP[$8];
    var $10 = $9 + -1;
    IHEAP[$8] = $10;
    var $11 = unSign($9, 32) > unSign(0, 32);
    ;
    if ($11) {
      ;
      var $13 = $1;
      var $14 = $13+44;
      var $15 = IHEAP[$14];
      var $16 = $15+4;
      var $17 = IHEAP[$16];
      var $18 = $17+1;
      IHEAP[$16] = $18;
      var $19 = IHEAP[$17];
      var $20 = $19;
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $22 = $1;
      var $23 = $22+44;
      var $24 = IHEAP[$23];
      var $25 = __Z9luaZ_fillP3Zio($24);
      __lastLabel__ = 2; ;
    }
    var $27 = __lastLabel__ == 0 ? $20 : ($25);
    var $28 = $1;
    var $29 = $28;
    IHEAP[$29] = $27;
    var $30 = $1;
    var $31 = $30;
    var $32 = IHEAP[$31];
    var $33 = $32 == 10;
    ;
    $39$34$6: do { 
      if ($33) {
        __label__ = 3; /* $39 */ 
      }
      else {
        ;
        var $35 = $1;
        var $36 = $35;
        var $37 = IHEAP[$36];
        var $38 = $37 == 13;
        if ($38) { __label__ = 3; /* $39 */ break $39$34$6; } else { __label__ = 4; /* $71 */ break $39$34$6; }
      }
    } while(0);
    $39$71$8: do { 
      if (__label__ == 3) {
        var $40 = $1;
        var $41 = $40;
        var $42 = IHEAP[$41];
        var $43 = $old;
        var $44 = $42 != $43;
        if (!($44)) { __label__ = 4; /* $71 */ break $39$71$8; }
        var $46 = $1;
        var $47 = $46+44;
        var $48 = IHEAP[$47];
        var $49 = $48;
        var $50 = IHEAP[$49];
        var $51 = $50 + -1;
        IHEAP[$49] = $51;
        var $52 = unSign($50, 32) > unSign(0, 32);
        ;
        if ($52) {
          ;
          var $54 = $1;
          var $55 = $54+44;
          var $56 = IHEAP[$55];
          var $57 = $56+4;
          var $58 = IHEAP[$57];
          var $59 = $58+1;
          IHEAP[$57] = $59;
          var $60 = IHEAP[$58];
          var $61 = $60;
          __lastLabel__ = 6; ;
        }
        else {
          ;
          var $63 = $1;
          var $64 = $63+44;
          var $65 = IHEAP[$64];
          var $66 = __Z9luaZ_fillP3Zio($65);
          __lastLabel__ = 8; ;
        }
        var $68 = __lastLabel__ == 6 ? $61 : ($66);
        var $69 = $1;
        var $70 = $69;
        IHEAP[$70] = $68;
        ;
      }
    } while(0);
    var $72 = $1;
    var $73 = $72+4;
    var $74 = IHEAP[$73];
    var $75 = $74 + 1;
    IHEAP[$73] = $75;
    var $76 = $75 >= 2147483645;
    ;
    if ($76) {
      ;
      var $78 = $1;
      __Z16luaX_syntaxerrorP8LexStatePKc($78, __str46);
      ;
    }
    ;
    return;
  }
  __Z13inclinenumberP8LexState.__index__ = Runtime.getFunctionIndex(__Z13inclinenumberP8LexState, "__Z13inclinenumberP8LexState");
  
  
  function __Z8skip_sepP8LexState($ls) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $count;
    var $s;
    $1 = $ls;
    $count = 0;
    var $2 = $1;
    var $3 = $2;
    var $4 = IHEAP[$3];
    $s = $4;
    var $5 = $1;
    var $6 = $1;
    var $7 = $6;
    var $8 = IHEAP[$7];
    __Z4saveP8LexStatei($5, $8);
    var $9 = $1;
    var $10 = $9+44;
    var $11 = IHEAP[$10];
    var $12 = $11;
    var $13 = IHEAP[$12];
    var $14 = $13 + -1;
    IHEAP[$12] = $14;
    var $15 = unSign($13, 32) > unSign(0, 32);
    ;
    if ($15) {
      ;
      var $17 = $1;
      var $18 = $17+44;
      var $19 = IHEAP[$18];
      var $20 = $19+4;
      var $21 = IHEAP[$20];
      var $22 = $21+1;
      IHEAP[$20] = $22;
      var $23 = IHEAP[$21];
      var $24 = $23;
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $26 = $1;
      var $27 = $26+44;
      var $28 = IHEAP[$27];
      var $29 = __Z9luaZ_fillP3Zio($28);
      __lastLabel__ = 2; ;
    }
    var $31 = __lastLabel__ == 0 ? $24 : ($29);
    var $32 = $1;
    var $33 = $32;
    IHEAP[$33] = $31;
    ;
    $34$6: while(1) { // $34
      var $35 = $1;
      var $36 = $35;
      var $37 = IHEAP[$36];
      var $38 = $37 == 61;
      if (!($38)) { __label__ = 5; /* $71 */ break $34$6; }
      var $40 = $1;
      var $41 = $1;
      var $42 = $41;
      var $43 = IHEAP[$42];
      __Z4saveP8LexStatei($40, $43);
      var $44 = $1;
      var $45 = $44+44;
      var $46 = IHEAP[$45];
      var $47 = $46;
      var $48 = IHEAP[$47];
      var $49 = $48 + -1;
      IHEAP[$47] = $49;
      var $50 = unSign($48, 32) > unSign(0, 32);
      ;
      if ($50) {
        ;
        var $52 = $1;
        var $53 = $52+44;
        var $54 = IHEAP[$53];
        var $55 = $54+4;
        var $56 = IHEAP[$55];
        var $57 = $56+1;
        IHEAP[$55] = $57;
        var $58 = IHEAP[$56];
        var $59 = $58;
        __lastLabel__ = 6; ;
      }
      else {
        ;
        var $61 = $1;
        var $62 = $61+44;
        var $63 = IHEAP[$62];
        var $64 = __Z9luaZ_fillP3Zio($63);
        __lastLabel__ = 8; ;
      }
      var $66 = __lastLabel__ == 6 ? $59 : ($64);
      var $67 = $1;
      var $68 = $67;
      IHEAP[$68] = $66;
      var $69 = $count;
      var $70 = $69 + 1;
      $count = $70;
      __label__ = 3; /* $34 */ continue $34$6;
    }
    var $72 = $1;
    var $73 = $72;
    var $74 = IHEAP[$73];
    var $75 = $s;
    var $76 = $74 == $75;
    ;
    if ($76) {
      ;
      var $78 = $count;
      __lastLabel__ = 9; ;
    }
    else {
      ;
      var $80 = $count;
      var $81 = 0 - $80;
      var $82 = $81 - 1;
      __lastLabel__ = 11; ;
    }
    var $84 = __lastLabel__ == 9 ? $78 : ($82);
    ;
    return $84;
  }
  __Z8skip_sepP8LexState.__index__ = Runtime.getFunctionIndex(__Z8skip_sepP8LexState, "__Z8skip_sepP8LexState");
  
  
  function __Z16read_long_stringP8LexStateP7SemInfoi($ls, $seminfo, $sep) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $cont;
    $1 = $ls;
    $2 = $seminfo;
    $3 = $sep;
    $cont = 0;
    var $4 = $1;
    var $5 = $1;
    var $6 = $5;
    var $7 = IHEAP[$6];
    __Z4saveP8LexStatei($4, $7);
    var $8 = $1;
    var $9 = $8+44;
    var $10 = IHEAP[$9];
    var $11 = $10;
    var $12 = IHEAP[$11];
    var $13 = $12 + -1;
    IHEAP[$11] = $13;
    var $14 = unSign($12, 32) > unSign(0, 32);
    ;
    if ($14) {
      ;
      var $16 = $1;
      var $17 = $16+44;
      var $18 = IHEAP[$17];
      var $19 = $18+4;
      var $20 = IHEAP[$19];
      var $21 = $20+1;
      IHEAP[$19] = $21;
      var $22 = IHEAP[$20];
      var $23 = $22;
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $25 = $1;
      var $26 = $25+44;
      var $27 = IHEAP[$26];
      var $28 = __Z9luaZ_fillP3Zio($27);
      __lastLabel__ = 2; ;
    }
    var $30 = __lastLabel__ == 0 ? $23 : ($28);
    var $31 = $1;
    var $32 = $31;
    IHEAP[$32] = $30;
    var $33 = $1;
    var $34 = $33;
    var $35 = IHEAP[$34];
    var $36 = $35 == 10;
    ;
    $42$37$6: do { 
      if ($36) {
        __label__ = 3; /* $42 */ 
      }
      else {
        ;
        var $38 = $1;
        var $39 = $38;
        var $40 = IHEAP[$39];
        var $41 = $40 == 13;
        if ($41) { __label__ = 3; /* $42 */ break $42$37$6; } else { __label__ = 4; /* $44 */ break $42$37$6; }
      }
    } while(0);
    if (__label__ == 3) {
      var $43 = $1;
      __Z13inclinenumberP8LexState($43);
      ;
    }
    ;
    $45$11: while(1) { // $45
      var $46 = $1;
      var $47 = $46;
      var $48 = IHEAP[$47];
      if ($48 == -1) {
        __label__ = 31; /* $49 */ 
      }
      else if ($48 == 91) {
        __label__ = 32; /* $57 */ 
      }
      else if ($48 == 93) {
        __label__ = 33; /* $100 */ 
      }
      else if ($48 == 10) {
        __label__ = 34; /* $136 */ 
      }
      else if ($48 == 13) {
        __label__ = 34; /* $136 */ 
      }
      else {
      __label__ = 35; /* $147 */ 
      }
      
      if (__label__ == 35) {
        var $148 = $2;
        var $149 = $148 != 0;
        ;
        if ($149) {
          ;
          var $151 = $1;
          var $152 = $1;
          var $153 = $152;
          var $154 = IHEAP[$153];
          __Z4saveP8LexStatei($151, $154);
          var $155 = $1;
          var $156 = $155+44;
          var $157 = IHEAP[$156];
          var $158 = $157;
          var $159 = IHEAP[$158];
          var $160 = $159 + -1;
          IHEAP[$158] = $160;
          var $161 = unSign($159, 32) > unSign(0, 32);
          ;
          if ($161) {
            ;
            var $163 = $1;
            var $164 = $163+44;
            var $165 = IHEAP[$164];
            var $166 = $165+4;
            var $167 = IHEAP[$166];
            var $168 = $167+1;
            IHEAP[$166] = $168;
            var $169 = IHEAP[$167];
            var $170 = $169;
            __lastLabel__ = 23; ;
          }
          else {
            ;
            var $172 = $1;
            var $173 = $172+44;
            var $174 = IHEAP[$173];
            var $175 = __Z9luaZ_fillP3Zio($174);
            __lastLabel__ = 25; ;
          }
          var $177 = __lastLabel__ == 23 ? $170 : ($175);
          var $178 = $1;
          var $179 = $178;
          IHEAP[$179] = $177;
          ;
        }
        else {
          ;
          var $181 = $1;
          var $182 = $181+44;
          var $183 = IHEAP[$182];
          var $184 = $183;
          var $185 = IHEAP[$184];
          var $186 = $185 + -1;
          IHEAP[$184] = $186;
          var $187 = unSign($185, 32) > unSign(0, 32);
          ;
          if ($187) {
            ;
            var $189 = $1;
            var $190 = $189+44;
            var $191 = IHEAP[$190];
            var $192 = $191+4;
            var $193 = IHEAP[$192];
            var $194 = $193+1;
            IHEAP[$192] = $194;
            var $195 = IHEAP[$193];
            var $196 = $195;
            __lastLabel__ = 27; ;
          }
          else {
            ;
            var $198 = $1;
            var $199 = $198+44;
            var $200 = IHEAP[$199];
            var $201 = __Z9luaZ_fillP3Zio($200);
            __lastLabel__ = 29; ;
          }
          var $203 = __lastLabel__ == 27 ? $196 : ($201);
          var $204 = $1;
          var $205 = $204;
          IHEAP[$205] = $203;
          ;
        }
        ;
      }
      else if (__label__ == 31) {
        var $50 = $1;
        var $51 = $2;
        var $52 = $51 != 0;
        ;
        if ($52) {
          ;
          __lastLabel__ = 7; ;
        }
        else {
          ;
          __lastLabel__ = 9; ;
        }
        var $56 = __lastLabel__ == 7 ? __str43 : (__str44);
        __Z13luaX_lexerrorP8LexStatePKci($50, $56, 287);
        ;
      }
      else if (__label__ == 32) {
        var $58 = $1;
        var $59 = __Z8skip_sepP8LexState($58);
        var $60 = $3;
        var $61 = $59 == $60;
        ;
        if ($61) {
          ;
          var $63 = $1;
          var $64 = $1;
          var $65 = $64;
          var $66 = IHEAP[$65];
          __Z4saveP8LexStatei($63, $66);
          var $67 = $1;
          var $68 = $67+44;
          var $69 = IHEAP[$68];
          var $70 = $69;
          var $71 = IHEAP[$70];
          var $72 = $71 + -1;
          IHEAP[$70] = $72;
          var $73 = unSign($71, 32) > unSign(0, 32);
          ;
          if ($73) {
            ;
            var $75 = $1;
            var $76 = $75+44;
            var $77 = IHEAP[$76];
            var $78 = $77+4;
            var $79 = IHEAP[$78];
            var $80 = $79+1;
            IHEAP[$78] = $80;
            var $81 = IHEAP[$79];
            var $82 = $81;
            __lastLabel__ = 11; ;
          }
          else {
            ;
            var $84 = $1;
            var $85 = $84+44;
            var $86 = IHEAP[$85];
            var $87 = __Z9luaZ_fillP3Zio($86);
            __lastLabel__ = 13; ;
          }
          var $89 = __lastLabel__ == 11 ? $82 : ($87);
          var $90 = $1;
          var $91 = $90;
          IHEAP[$91] = $89;
          var $92 = $cont;
          var $93 = $92 + 1;
          $cont = $93;
          var $94 = $3;
          var $95 = $94 == 0;
          ;
          if ($95) {
            ;
            var $97 = $1;
            __Z13luaX_lexerrorP8LexStatePKci($97, __str45, 91);
            ;
          }
          ;
        }
        ;
      }
      else if (__label__ == 33) {
        var $101 = $1;
        var $102 = __Z8skip_sepP8LexState($101);
        var $103 = $3;
        var $104 = $102 == $103;
        if ($104) { __label__ = 16; /* $105 */ break $45$11; }
        ;
      }
      else if (__label__ == 34) {
        var $137 = $1;
        __Z4saveP8LexStatei($137, 10);
        var $138 = $1;
        __Z13inclinenumberP8LexState($138);
        var $139 = $2;
        var $140 = $139 != 0;
        ;
        if (!$140) {
          ;
          var $142 = $1;
          var $143 = $142+48;
          var $144 = IHEAP[$143];
          var $145 = $144+4;
          IHEAP[$145] = 0;
          ;
        }
        ;
      }
      __label__ = 6; /* $45 */ continue $45$11;
    }
    var $106 = $1;
    var $107 = $1;
    var $108 = $107;
    var $109 = IHEAP[$108];
    __Z4saveP8LexStatei($106, $109);
    var $110 = $1;
    var $111 = $110+44;
    var $112 = IHEAP[$111];
    var $113 = $112;
    var $114 = IHEAP[$113];
    var $115 = $114 + -1;
    IHEAP[$113] = $115;
    var $116 = unSign($114, 32) > unSign(0, 32);
    ;
    if ($116) {
      ;
      var $118 = $1;
      var $119 = $118+44;
      var $120 = IHEAP[$119];
      var $121 = $120+4;
      var $122 = IHEAP[$121];
      var $123 = $122+1;
      IHEAP[$121] = $123;
      var $124 = IHEAP[$122];
      var $125 = $124;
      __lastLabel__ = 18; ;
    }
    else {
      ;
      var $127 = $1;
      var $128 = $127+44;
      var $129 = IHEAP[$128];
      var $130 = __Z9luaZ_fillP3Zio($129);
      __lastLabel__ = 20; ;
    }
    var $132 = __lastLabel__ == 18 ? $125 : ($130);
    var $133 = $1;
    var $134 = $133;
    IHEAP[$134] = $132;
    ;
    var $209 = $2;
    var $210 = $209 != 0;
    ;
    if ($210) {
      ;
      var $212 = $1;
      var $213 = $1;
      var $214 = $213+48;
      var $215 = IHEAP[$214];
      var $216 = $215;
      var $217 = IHEAP[$216];
      var $218 = $3;
      var $219 = 2 + $218;
      var $220 = $217+$219;
      var $221 = $1;
      var $222 = $221+48;
      var $223 = IHEAP[$222];
      var $224 = $223+4;
      var $225 = IHEAP[$224];
      var $226 = $3;
      var $227 = 2 + $226;
      var $228 = 2 * $227;
      var $229 = $225 - $228;
      var $230 = __Z14luaX_newstringP8LexStatePKcj($212, $220, $229);
      var $231 = $2;
      var $232 = $231;
      var $233 = $232;
      IHEAP[$233] = $230;
      ;
    }
    ;
    return;
  }
  __Z16read_long_stringP8LexStateP7SemInfoi.__index__ = Runtime.getFunctionIndex(__Z16read_long_stringP8LexStateP7SemInfoi, "__Z16read_long_stringP8LexStateP7SemInfoi");
  
  
  function __Z11read_stringP8LexStateiP7SemInfo($ls, $del, $seminfo) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $c;
    var $i;
    $1 = $ls;
    $2 = $del;
    $3 = $seminfo;
    var $4 = $1;
    var $5 = $1;
    var $6 = $5;
    var $7 = IHEAP[$6];
    __Z4saveP8LexStatei($4, $7);
    var $8 = $1;
    var $9 = $8+44;
    var $10 = IHEAP[$9];
    var $11 = $10;
    var $12 = IHEAP[$11];
    var $13 = $12 + -1;
    IHEAP[$11] = $13;
    var $14 = unSign($12, 32) > unSign(0, 32);
    ;
    if ($14) {
      ;
      var $16 = $1;
      var $17 = $16+44;
      var $18 = IHEAP[$17];
      var $19 = $18+4;
      var $20 = IHEAP[$19];
      var $21 = $20+1;
      IHEAP[$19] = $21;
      var $22 = IHEAP[$20];
      var $23 = $22;
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $25 = $1;
      var $26 = $25+44;
      var $27 = IHEAP[$26];
      var $28 = __Z9luaZ_fillP3Zio($27);
      __lastLabel__ = 2; ;
    }
    var $30 = __lastLabel__ == 0 ? $23 : ($28);
    var $31 = $1;
    var $32 = $31;
    IHEAP[$32] = $30;
    ;
    $33$6: while(1) { // $33
      var $34 = $1;
      var $35 = $34;
      var $36 = IHEAP[$35];
      var $37 = $2;
      var $38 = $36 != $37;
      if (!($38)) { __label__ = 5; /* $237 */ break $33$6; }
      var $40 = $1;
      var $41 = $40;
      var $42 = IHEAP[$41];
      if ($42 == -1) {
        __label__ = 33; /* $43 */ 
      }
      else if ($42 == 10) {
        __label__ = 34; /* $45 */ 
      }
      else if ($42 == 13) {
        __label__ = 34; /* $45 */ 
      }
      else if ($42 == 92) {
        __label__ = 35; /* $47 */ 
      }
      else {
      __label__ = 36; /* $206 */ 
      }
      
      if (__label__ == 36) {
        var $207 = $1;
        var $208 = $1;
        var $209 = $208;
        var $210 = IHEAP[$209];
        __Z4saveP8LexStatei($207, $210);
        var $211 = $1;
        var $212 = $211+44;
        var $213 = IHEAP[$212];
        var $214 = $213;
        var $215 = IHEAP[$214];
        var $216 = $215 + -1;
        IHEAP[$214] = $216;
        var $217 = unSign($215, 32) > unSign(0, 32);
        ;
        if ($217) {
          ;
          var $219 = $1;
          var $220 = $219+44;
          var $221 = IHEAP[$220];
          var $222 = $221+4;
          var $223 = IHEAP[$222];
          var $224 = $223+1;
          IHEAP[$222] = $224;
          var $225 = IHEAP[$223];
          var $226 = $225;
          __lastLabel__ = 26; ;
        }
        else {
          ;
          var $228 = $1;
          var $229 = $228+44;
          var $230 = IHEAP[$229];
          var $231 = __Z9luaZ_fillP3Zio($230);
          __lastLabel__ = 28; ;
        }
        var $233 = __lastLabel__ == 26 ? $226 : ($231);
        var $234 = $1;
        var $235 = $234;
        IHEAP[$235] = $233;
        ;
        __label__ = 3; /* $33 */ continue $33$6;
      }
      else if (__label__ == 33) {
        var $44 = $1;
        __Z13luaX_lexerrorP8LexStatePKci($44, __str41, 287);
        __label__ = 3; /* $33 */ continue $33$6;
      }
      else if (__label__ == 34) {
        var $46 = $1;
        __Z13luaX_lexerrorP8LexStatePKci($46, __str41, 286);
        __label__ = 3; /* $33 */ continue $33$6;
      }
      else if (__label__ == 35) {
        var $48 = $1;
        var $49 = $48+44;
        var $50 = IHEAP[$49];
        var $51 = $50;
        var $52 = IHEAP[$51];
        var $53 = $52 + -1;
        IHEAP[$51] = $53;
        var $54 = unSign($52, 32) > unSign(0, 32);
        ;
        if ($54) {
          ;
          var $56 = $1;
          var $57 = $56+44;
          var $58 = IHEAP[$57];
          var $59 = $58+4;
          var $60 = IHEAP[$59];
          var $61 = $60+1;
          IHEAP[$59] = $61;
          var $62 = IHEAP[$60];
          var $63 = $62;
          __lastLabel__ = 6; ;
        }
        else {
          ;
          var $65 = $1;
          var $66 = $65+44;
          var $67 = IHEAP[$66];
          var $68 = __Z9luaZ_fillP3Zio($67);
          __lastLabel__ = 8; ;
        }
        var $70 = __lastLabel__ == 6 ? $63 : ($68);
        var $71 = $1;
        var $72 = $71;
        IHEAP[$72] = $70;
        var $73 = $1;
        var $74 = $73;
        var $75 = IHEAP[$74];
        if ($75 == 97) {
          __label__ = 37; /* $76 */ 
        }
        else if ($75 == 98) {
          __label__ = 38; /* $77 */ 
        }
        else if ($75 == 102) {
          __label__ = 39; /* $78 */ 
        }
        else if ($75 == 110) {
          __label__ = 40; /* $79 */ 
        }
        else if ($75 == 114) {
          __label__ = 41; /* $80 */ 
        }
        else if ($75 == 116) {
          __label__ = 42; /* $81 */ 
        }
        else if ($75 == 118) {
          __label__ = 43; /* $82 */ 
        }
        else if ($75 == 10) {
          __label__ = 44; /* $83 */ 
        }
        else if ($75 == 13) {
          __label__ = 44; /* $83 */ 
        }
        else if ($75 == -1) {
          __label__ = 45; /* $86 */ 
        }
        else {
        __label__ = 46; /* $87 */ 
        }
        
        if (__label__ == 46) {
          var $88 = $1;
          var $89 = $88;
          var $90 = IHEAP[$89];
          var $91 = _isdigit($90);
          var $92 = $91 != 0;
          ;
          if ($92) {
            ;
            $i = 0;
            $c = 0;
            ;
            $124$27: while(1) { // $124
              var $125 = $c;
              var $126 = 10 * $125;
              var $127 = $1;
              var $128 = $127;
              var $129 = IHEAP[$128];
              var $130 = $129 - 48;
              var $131 = $126 + $130;
              $c = $131;
              var $132 = $1;
              var $133 = $132+44;
              var $134 = IHEAP[$133];
              var $135 = $134;
              var $136 = IHEAP[$135];
              var $137 = $136 + -1;
              IHEAP[$135] = $137;
              var $138 = unSign($136, 32) > unSign(0, 32);
              ;
              if ($138) {
                ;
                var $140 = $1;
                var $141 = $140+44;
                var $142 = IHEAP[$141];
                var $143 = $142+4;
                var $144 = IHEAP[$143];
                var $145 = $144+1;
                IHEAP[$143] = $145;
                var $146 = IHEAP[$144];
                var $147 = $146;
                __lastLabel__ = 15; ;
              }
              else {
                ;
                var $149 = $1;
                var $150 = $149+44;
                var $151 = IHEAP[$150];
                var $152 = __Z9luaZ_fillP3Zio($151);
                __lastLabel__ = 17; ;
              }
              var $154 = __lastLabel__ == 15 ? $147 : ($152);
              var $155 = $1;
              var $156 = $155;
              IHEAP[$156] = $154;
              ;
              var $158 = $i;
              var $159 = $158 + 1;
              $i = $159;
              var $160 = $159 < 3;
              ;
              if ($160) {
                __lastLabel__ = 18; ;
                var $162 = $1;
                var $163 = $162;
                var $164 = IHEAP[$163];
                var $165 = _isdigit($164);
                var $166 = $165 != 0;
                __lastLabel__ = 19; ;
              }
              else {
                __lastLabel__ = 18; ;
              }
              var $168 = __lastLabel__ == 18 ? 0 : ($166);
              if ($168) { __label__ = 14; /* $124 */ continue $124$27; } else { __label__ = 21; /* $169 */ break $124$27; }
            }
            var $170 = $c;
            var $171 = $170 > 255;
            ;
            if ($171) {
              ;
              var $173 = $1;
              __Z13luaX_lexerrorP8LexStatePKci($173, __str42, 286);
              ;
            }
            var $175 = $1;
            var $176 = $c;
            __Z4saveP8LexStatei($175, $176);
            ;
          }
          else {
            ;
            var $94 = $1;
            var $95 = $1;
            var $96 = $95;
            var $97 = IHEAP[$96];
            __Z4saveP8LexStatei($94, $97);
            var $98 = $1;
            var $99 = $98+44;
            var $100 = IHEAP[$99];
            var $101 = $100;
            var $102 = IHEAP[$101];
            var $103 = $102 + -1;
            IHEAP[$101] = $103;
            var $104 = unSign($102, 32) > unSign(0, 32);
            ;
            if ($104) {
              ;
              var $106 = $1;
              var $107 = $106+44;
              var $108 = IHEAP[$107];
              var $109 = $108+4;
              var $110 = IHEAP[$109];
              var $111 = $110+1;
              IHEAP[$109] = $111;
              var $112 = IHEAP[$110];
              var $113 = $112;
              __lastLabel__ = 10; ;
            }
            else {
              ;
              var $115 = $1;
              var $116 = $115+44;
              var $117 = IHEAP[$116];
              var $118 = __Z9luaZ_fillP3Zio($117);
              __lastLabel__ = 12; ;
            }
            var $120 = __lastLabel__ == 10 ? $113 : ($118);
            var $121 = $1;
            var $122 = $121;
            IHEAP[$122] = $120;
            ;
          }
          __label__ = 3; /* $33 */ continue $33$6;
        }
        else if (__label__ == 37) {
          $c = 7;
          ;
        }
        else if (__label__ == 38) {
          $c = 8;
          ;
        }
        else if (__label__ == 39) {
          $c = 12;
          ;
        }
        else if (__label__ == 40) {
          $c = 10;
          ;
        }
        else if (__label__ == 41) {
          $c = 13;
          ;
        }
        else if (__label__ == 42) {
          $c = 9;
          ;
        }
        else if (__label__ == 43) {
          $c = 11;
          ;
        }
        else if (__label__ == 44) {
          var $84 = $1;
          __Z4saveP8LexStatei($84, 10);
          var $85 = $1;
          __Z13inclinenumberP8LexState($85);
          __label__ = 3; /* $33 */ continue $33$6;
        }
        else if (__label__ == 45) {
          __label__ = 3; /* $33 */ continue $33$6;
        }
        var $179 = $1;
        var $180 = $c;
        __Z4saveP8LexStatei($179, $180);
        var $181 = $1;
        var $182 = $181+44;
        var $183 = IHEAP[$182];
        var $184 = $183;
        var $185 = IHEAP[$184];
        var $186 = $185 + -1;
        IHEAP[$184] = $186;
        var $187 = unSign($185, 32) > unSign(0, 32);
        ;
        if ($187) {
          ;
          var $189 = $1;
          var $190 = $189+44;
          var $191 = IHEAP[$190];
          var $192 = $191+4;
          var $193 = IHEAP[$192];
          var $194 = $193+1;
          IHEAP[$192] = $194;
          var $195 = IHEAP[$193];
          var $196 = $195;
          __lastLabel__ = 23; ;
        }
        else {
          ;
          var $198 = $1;
          var $199 = $198+44;
          var $200 = IHEAP[$199];
          var $201 = __Z9luaZ_fillP3Zio($200);
          __lastLabel__ = 25; ;
        }
        var $203 = __lastLabel__ == 23 ? $196 : ($201);
        var $204 = $1;
        var $205 = $204;
        IHEAP[$205] = $203;
        __label__ = 3; /* $33 */ continue $33$6;
      }
    }
    var $238 = $1;
    var $239 = $1;
    var $240 = $239;
    var $241 = IHEAP[$240];
    __Z4saveP8LexStatei($238, $241);
    var $242 = $1;
    var $243 = $242+44;
    var $244 = IHEAP[$243];
    var $245 = $244;
    var $246 = IHEAP[$245];
    var $247 = $246 + -1;
    IHEAP[$245] = $247;
    var $248 = unSign($246, 32) > unSign(0, 32);
    ;
    if ($248) {
      ;
      var $250 = $1;
      var $251 = $250+44;
      var $252 = IHEAP[$251];
      var $253 = $252+4;
      var $254 = IHEAP[$253];
      var $255 = $254+1;
      IHEAP[$253] = $255;
      var $256 = IHEAP[$254];
      var $257 = $256;
      __lastLabel__ = 30; ;
    }
    else {
      ;
      var $259 = $1;
      var $260 = $259+44;
      var $261 = IHEAP[$260];
      var $262 = __Z9luaZ_fillP3Zio($261);
      __lastLabel__ = 32; ;
    }
    var $264 = __lastLabel__ == 30 ? $257 : ($262);
    var $265 = $1;
    var $266 = $265;
    IHEAP[$266] = $264;
    var $267 = $1;
    var $268 = $1;
    var $269 = $268+48;
    var $270 = IHEAP[$269];
    var $271 = $270;
    var $272 = IHEAP[$271];
    var $273 = $272+1;
    var $274 = $1;
    var $275 = $274+48;
    var $276 = IHEAP[$275];
    var $277 = $276+4;
    var $278 = IHEAP[$277];
    var $279 = $278 - 2;
    var $280 = __Z14luaX_newstringP8LexStatePKcj($267, $273, $279);
    var $281 = $3;
    var $282 = $281;
    var $283 = $282;
    IHEAP[$283] = $280;
    ;
    return;
  }
  __Z11read_stringP8LexStateiP7SemInfo.__index__ = Runtime.getFunctionIndex(__Z11read_stringP8LexStateiP7SemInfo, "__Z11read_stringP8LexStateiP7SemInfo");
  
  
  function __Z4saveP8LexStatei($ls, $c) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $b;
    var $newsize;
    $1 = $ls;
    $2 = $c;
    var $3 = $1;
    var $4 = $3+48;
    var $5 = IHEAP[$4];
    $b = $5;
    var $6 = $b;
    var $7 = $6+4;
    var $8 = IHEAP[$7];
    var $9 = $8 + 1;
    var $10 = $b;
    var $11 = $10+8;
    var $12 = IHEAP[$11];
    var $13 = unSign($9, 32) > unSign($12, 32);
    ;
    if ($13) {
      ;
      var $15 = $b;
      var $16 = $15+8;
      var $17 = IHEAP[$16];
      var $18 = unSign($17, 32) >= unSign(2147483646, 32);
      ;
      if ($18) {
        ;
        var $20 = $1;
        __Z13luaX_lexerrorP8LexStatePKci($20, __str40, 0);
        ;
      }
      var $22 = $b;
      var $23 = $22+8;
      var $24 = IHEAP[$23];
      var $25 = $24 * 2;
      $newsize = $25;
      var $26 = $newsize;
      var $27 = $26 + 1;
      var $28 = unSign($27, 32) <= unSign(-3, 32);
      ;
      if ($28) {
        ;
        var $30 = $1;
        var $31 = $30+40;
        var $32 = IHEAP[$31];
        var $33 = $b;
        var $34 = $33;
        var $35 = IHEAP[$34];
        var $36 = $b;
        var $37 = $36+8;
        var $38 = IHEAP[$37];
        var $39 = $38 * 1;
        var $40 = $newsize;
        var $41 = $40 * 1;
        var $42 = __Z13luaM_realloc_P9lua_StatePvjj($32, $35, $39, $41);
        __lastLabel__ = 1; ;
      }
      else {
        ;
        var $44 = $1;
        var $45 = $44+40;
        var $46 = IHEAP[$45];
        var $47 = __Z11luaM_toobigP9lua_State($46);
        __lastLabel__ = 3; ;
      }
      var $49 = __lastLabel__ == 1 ? $42 : ($47);
      var $50 = $b;
      var $51 = $50;
      IHEAP[$51] = $49;
      var $52 = $newsize;
      var $53 = $b;
      var $54 = $53+8;
      IHEAP[$54] = $52;
      ;
    }
    var $56 = $2;
    var $57 = $56;
    var $58 = $b;
    var $59 = $58+4;
    var $60 = IHEAP[$59];
    var $61 = $60 + 1;
    IHEAP[$59] = $61;
    var $62 = $b;
    var $63 = $62;
    var $64 = IHEAP[$63];
    var $65 = $64+$60;
    IHEAP[$65] = $57;
    ;
    return;
  }
  __Z4saveP8LexStatei.__index__ = Runtime.getFunctionIndex(__Z4saveP8LexStatei, "__Z4saveP8LexStatei");
  
  
  function __Z10check_nextP8LexStatePKc($ls, $set) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    $2 = $ls;
    $3 = $set;
    var $4 = $3;
    var $5 = $2;
    var $6 = $5;
    var $7 = IHEAP[$6];
    var $8 = _strchr($4, $7);
    var $9 = $8 != 0;
    ;
    if ($9) {
      ;
      var $12 = $2;
      var $13 = $2;
      var $14 = $13;
      var $15 = IHEAP[$14];
      __Z4saveP8LexStatei($12, $15);
      var $16 = $2;
      var $17 = $16+44;
      var $18 = IHEAP[$17];
      var $19 = $18;
      var $20 = IHEAP[$19];
      var $21 = $20 + -1;
      IHEAP[$19] = $21;
      var $22 = unSign($20, 32) > unSign(0, 32);
      ;
      if ($22) {
        ;
        var $24 = $2;
        var $25 = $24+44;
        var $26 = IHEAP[$25];
        var $27 = $26+4;
        var $28 = IHEAP[$27];
        var $29 = $28+1;
        IHEAP[$27] = $29;
        var $30 = IHEAP[$28];
        var $31 = $30;
        __lastLabel__ = 1; ;
      }
      else {
        ;
        var $33 = $2;
        var $34 = $33+44;
        var $35 = IHEAP[$34];
        var $36 = __Z9luaZ_fillP3Zio($35);
        __lastLabel__ = 3; ;
      }
      var $38 = __lastLabel__ == 1 ? $31 : ($36);
      var $39 = $2;
      var $40 = $39;
      IHEAP[$40] = $38;
      $1 = 1;
      ;
    }
    else {
      ;
      $1 = 0;
      ;
    }
    var $42 = $1;
    ;
    return $42;
  }
  __Z10check_nextP8LexStatePKc.__index__ = Runtime.getFunctionIndex(__Z10check_nextP8LexStatePKc, "__Z10check_nextP8LexStatePKc");
  
  
  function __Z12read_numeralP8LexStateP7SemInfo($ls, $seminfo) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    $1 = $ls;
    $2 = $seminfo;
    ;
    $3$2: while(1) { // $3
      var $4 = $1;
      var $5 = $1;
      var $6 = $5;
      var $7 = IHEAP[$6];
      __Z4saveP8LexStatei($4, $7);
      var $8 = $1;
      var $9 = $8+44;
      var $10 = IHEAP[$9];
      var $11 = $10;
      var $12 = IHEAP[$11];
      var $13 = $12 + -1;
      IHEAP[$11] = $13;
      var $14 = unSign($12, 32) > unSign(0, 32);
      ;
      if ($14) {
        ;
        var $16 = $1;
        var $17 = $16+44;
        var $18 = IHEAP[$17];
        var $19 = $18+4;
        var $20 = IHEAP[$19];
        var $21 = $20+1;
        IHEAP[$19] = $21;
        var $22 = IHEAP[$20];
        var $23 = $22;
        __lastLabel__ = 1; ;
      }
      else {
        ;
        var $25 = $1;
        var $26 = $25+44;
        var $27 = IHEAP[$26];
        var $28 = __Z9luaZ_fillP3Zio($27);
        __lastLabel__ = 3; ;
      }
      var $30 = __lastLabel__ == 1 ? $23 : ($28);
      var $31 = $1;
      var $32 = $31;
      IHEAP[$32] = $30;
      ;
      var $34 = $1;
      var $35 = $34;
      var $36 = IHEAP[$35];
      var $37 = _isdigit($36);
      var $38 = $37 != 0;
      ;
      if ($38) {
        __lastLabel__ = 4; ;
      }
      else {
        __lastLabel__ = 4; ;
        var $40 = $1;
        var $41 = $40;
        var $42 = IHEAP[$41];
        var $43 = $42 == 46;
        __lastLabel__ = 5; ;
      }
      var $45 = __lastLabel__ == 4 ? 1 : ($43);
      if ($45) { __label__ = 0; /* $3 */ continue $3$2; } else { __label__ = 7; /* $46 */ break $3$2; }
    }
    var $47 = $1;
    var $48 = __Z10check_nextP8LexStatePKc($47, __str3770);
    var $49 = $48 != 0;
    ;
    if ($49) {
      ;
      var $51 = $1;
      var $52 = __Z10check_nextP8LexStatePKc($51, __str38);
      ;
    }
    ;
    $54$16: while(1) { // $54
      var $55 = $1;
      var $56 = $55;
      var $57 = IHEAP[$56];
      var $58 = _isalnum($57);
      var $59 = $58 != 0;
      ;
      if ($59) {
        __lastLabel__ = 9; ;
      }
      else {
        __lastLabel__ = 9; ;
        var $61 = $1;
        var $62 = $61;
        var $63 = IHEAP[$62];
        var $64 = $63 == 95;
        __lastLabel__ = 10; ;
      }
      var $66 = __lastLabel__ == 9 ? 1 : ($64);
      if (!($66)) { __label__ = 13; /* $97 */ break $54$16; }
      var $68 = $1;
      var $69 = $1;
      var $70 = $69;
      var $71 = IHEAP[$70];
      __Z4saveP8LexStatei($68, $71);
      var $72 = $1;
      var $73 = $72+44;
      var $74 = IHEAP[$73];
      var $75 = $74;
      var $76 = IHEAP[$75];
      var $77 = $76 + -1;
      IHEAP[$75] = $77;
      var $78 = unSign($76, 32) > unSign(0, 32);
      ;
      if ($78) {
        ;
        var $80 = $1;
        var $81 = $80+44;
        var $82 = IHEAP[$81];
        var $83 = $82+4;
        var $84 = IHEAP[$83];
        var $85 = $84+1;
        IHEAP[$83] = $85;
        var $86 = IHEAP[$84];
        var $87 = $86;
        __lastLabel__ = 14; ;
      }
      else {
        ;
        var $89 = $1;
        var $90 = $89+44;
        var $91 = IHEAP[$90];
        var $92 = __Z9luaZ_fillP3Zio($91);
        __lastLabel__ = 16; ;
      }
      var $94 = __lastLabel__ == 14 ? $87 : ($92);
      var $95 = $1;
      var $96 = $95;
      IHEAP[$96] = $94;
      __label__ = 9; /* $54 */ continue $54$16;
    }
    var $98 = $1;
    __Z4saveP8LexStatei($98, 0);
    var $99 = $1;
    var $100 = $1;
    var $101 = $100+56;
    var $102 = IHEAP[$101];
    __Z11buffreplaceP8LexStatecc($99, 46, $102);
    var $103 = $1;
    var $104 = $103+48;
    var $105 = IHEAP[$104];
    var $106 = $105;
    var $107 = IHEAP[$106];
    var $108 = $2;
    var $109 = $108;
    var $110 = __Z10luaO_str2dPKcPd($107, $109);
    var $111 = $110 != 0;
    ;
    if (!$111) {
      ;
      var $113 = $1;
      var $114 = $2;
      __Z11trydecpointP8LexStateP7SemInfo($113, $114);
      ;
    }
    ;
    return;
  }
  __Z12read_numeralP8LexStateP7SemInfo.__index__ = Runtime.getFunctionIndex(__Z12read_numeralP8LexStateP7SemInfo, "__Z12read_numeralP8LexStateP7SemInfo");
  
  
  function __Z11buffreplaceP8LexStatecc($ls, $from, $to) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $n;
    var $p;
    $1 = $ls;
    $2 = $from;
    $3 = $to;
    var $4 = $1;
    var $5 = $4+48;
    var $6 = IHEAP[$5];
    var $7 = $6+4;
    var $8 = IHEAP[$7];
    $n = $8;
    var $9 = $1;
    var $10 = $9+48;
    var $11 = IHEAP[$10];
    var $12 = $11;
    var $13 = IHEAP[$12];
    $p = $13;
    ;
    $14$2: while(1) { // $14
      var $15 = $n;
      var $16 = $15 + -1;
      $n = $16;
      var $17 = $15 != 0;
      if (!($17)) { __label__ = 2; /* $33 */ break $14$2; }
      var $19 = $n;
      var $20 = $p;
      var $21 = $20+$19;
      var $22 = IHEAP[$21];
      var $23 = $22;
      var $24 = $2;
      var $25 = $24;
      var $26 = $23 == $25;
      ;
      if ($26) {
        ;
        var $28 = $3;
        var $29 = $n;
        var $30 = $p;
        var $31 = $30+$29;
        IHEAP[$31] = $28;
        ;
      }
      __label__ = 0; /* $14 */ continue $14$2;
    }
    ;
    return;
  }
  __Z11buffreplaceP8LexStatecc.__index__ = Runtime.getFunctionIndex(__Z11buffreplaceP8LexStatecc, "__Z11buffreplaceP8LexStatecc");
  
  
  function __Z11trydecpointP8LexStateP7SemInfo($ls, $seminfo) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $cv;
    var $old;
    $1 = $ls;
    $2 = $seminfo;
    var $3 = _localeconv();
    $cv = $3;
    var $4 = $1;
    var $5 = $4+56;
    var $6 = IHEAP[$5];
    $old = $6;
    var $7 = $cv;
    var $8 = $7 != 0;
    ;
    if ($8) {
      ;
      var $10 = $cv;
      var $11 = $10;
      var $12 = IHEAP[$11];
      var $13 = $12;
      var $14 = IHEAP[$13];
      __lastLabel__ = 0; ;
    }
    else {
      ;
      __lastLabel__ = 2; ;
    }
    var $17 = __lastLabel__ == 0 ? $14 : (46);
    var $18 = $1;
    var $19 = $18+56;
    IHEAP[$19] = $17;
    var $20 = $1;
    var $21 = $old;
    var $22 = $1;
    var $23 = $22+56;
    var $24 = IHEAP[$23];
    __Z11buffreplaceP8LexStatecc($20, $21, $24);
    var $25 = $1;
    var $26 = $25+48;
    var $27 = IHEAP[$26];
    var $28 = $27;
    var $29 = IHEAP[$28];
    var $30 = $2;
    var $31 = $30;
    var $32 = __Z10luaO_str2dPKcPd($29, $31);
    var $33 = $32 != 0;
    ;
    if (!$33) {
      ;
      var $35 = $1;
      var $36 = $1;
      var $37 = $36+56;
      var $38 = IHEAP[$37];
      __Z11buffreplaceP8LexStatecc($35, $38, 46);
      var $39 = $1;
      __Z13luaX_lexerrorP8LexStatePKci($39, __str39, 284);
      ;
    }
    ;
    return;
  }
  __Z11trydecpointP8LexStateP7SemInfo.__index__ = Runtime.getFunctionIndex(__Z11trydecpointP8LexStateP7SemInfo, "__Z11trydecpointP8LexStateP7SemInfo");
  
  
  function __Z13luaM_growaux_P9lua_StatePvPijiPKc($L, $block, $size, $size_elems, $limit, $errormsg) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $4;
    var $5;
    var $6;
    var $newblock;
    var $newsize;
    $1 = $L;
    $2 = $block;
    $3 = $size;
    $4 = $size_elems;
    $5 = $limit;
    $6 = $errormsg;
    var $7 = $3;
    var $8 = IHEAP[$7];
    var $9 = $5;
    var $10 = Math.floor($9 / 2);
    var $11 = $8 >= $10;
    ;
    if ($11) {
      ;
      var $13 = $3;
      var $14 = IHEAP[$13];
      var $15 = $5;
      var $16 = $14 >= $15;
      ;
      if ($16) {
        ;
        var $18 = $1;
        var $19 = $6;
        __Z13luaG_runerrorP9lua_StatePKcz($18, $19);
        ;
      }
      var $21 = $5;
      $newsize = $21;
      ;
    }
    else {
      ;
      var $23 = $3;
      var $24 = IHEAP[$23];
      var $25 = $24 * 2;
      $newsize = $25;
      var $26 = $newsize;
      var $27 = $26 < 4;
      ;
      if ($27) {
        ;
        $newsize = 4;
        ;
      }
      ;
    }
    var $31 = $newsize;
    var $32 = $31 + 1;
    var $33 = $4;
    var $34 = Math.floor(unSign(-3, 32) / unSign($33, 32));
    var $35 = unSign($32, 32) <= unSign($34, 32);
    ;
    if ($35) {
      ;
      var $37 = $1;
      var $38 = $2;
      var $39 = $3;
      var $40 = IHEAP[$39];
      var $41 = $4;
      var $42 = $40 * $41;
      var $43 = $newsize;
      var $44 = $4;
      var $45 = $43 * $44;
      var $46 = __Z13luaM_realloc_P9lua_StatePvjj($37, $38, $42, $45);
      __lastLabel__ = 3; ;
    }
    else {
      ;
      var $48 = $1;
      var $49 = __Z11luaM_toobigP9lua_State($48);
      __lastLabel__ = 5; ;
    }
    var $51 = __lastLabel__ == 3 ? $46 : ($49);
    $newblock = $51;
    var $52 = $newsize;
    var $53 = $3;
    IHEAP[$53] = $52;
    var $54 = $newblock;
    ;
    return $54;
  }
  __Z13luaM_growaux_P9lua_StatePvPijiPKc.__index__ = Runtime.getFunctionIndex(__Z13luaM_growaux_P9lua_StatePvPijiPKc, "__Z13luaM_growaux_P9lua_StatePvPijiPKc");
  
  
  function __Z13luaM_realloc_P9lua_StatePvjj($L, $block, $osize, $nsize) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $g;
    $1 = $L;
    $2 = $block;
    $3 = $osize;
    $4 = $nsize;
    var $5 = $1;
    var $6 = $5+16;
    var $7 = IHEAP[$6];
    $g = $7;
    var $8 = $g;
    var $9 = $8+12;
    var $10 = IHEAP[$9];
    var $11 = $g;
    var $12 = $11+16;
    var $13 = IHEAP[$12];
    var $14 = $2;
    var $15 = $3;
    var $16 = $4;
    var $17 = FUNCTION_TABLE[$10]($13, $14, $15, $16);
    $2 = $17;
    var $18 = $2;
    var $19 = $18 == 0;
    ;
    $20$25$2: do { 
      if ($19) {
        ;
        var $21 = $4;
        var $22 = unSign($21, 32) > unSign(0, 32);
        if (!($22)) { __label__ = 1; /* $25 */ break $20$25$2; }
        var $24 = $1;
        __Z10luaD_throwP9lua_Statei($24, 4);
        ;
      }
    } while(0);
    var $26 = $g;
    var $27 = $26+68;
    var $28 = IHEAP[$27];
    var $29 = $3;
    var $30 = $28 - $29;
    var $31 = $4;
    var $32 = $30 + $31;
    var $33 = $g;
    var $34 = $33+68;
    IHEAP[$34] = $32;
    var $35 = $2;
    ;
    return $35;
  }
  __Z13luaM_realloc_P9lua_StatePvjj.__index__ = Runtime.getFunctionIndex(__Z13luaM_realloc_P9lua_StatePvjj, "__Z13luaM_realloc_P9lua_StatePvjj");
  
  
  function __Z11luaM_toobigP9lua_State($L) {
    ;
    var __label__;
    var $1;
    $1 = $L;
    var $2 = $1;
    __Z13luaG_runerrorP9lua_StatePKcz($2, __str72);
    ;
    return 0;
  }
  __Z11luaM_toobigP9lua_State.__index__ = Runtime.getFunctionIndex(__Z11luaM_toobigP9lua_State, "__Z11luaM_toobigP9lua_State");
  
  
  function __Z11luaO_int2fbj($x) {
    ;
    var __label__;
    var $1;
    var $2;
    var $e;
    $2 = $x;
    $e = 0;
    ;
    $3$2: while(1) { // $3
      var $4 = $2;
      var $5 = unSign($4, 32) >= unSign(16, 32);
      if (!($5)) { __label__ = 2; /* $12 */ break $3$2; }
      var $7 = $2;
      var $8 = $7 + 1;
      var $9 = $8 >> 1;
      $2 = $9;
      var $10 = $e;
      var $11 = $10 + 1;
      $e = $11;
      __label__ = 0; /* $3 */ continue $3$2;
    }
    var $13 = $2;
    var $14 = unSign($13, 32) < unSign(8, 32);
    ;
    if ($14) {
      ;
      var $16 = $2;
      $1 = $16;
      ;
    }
    else {
      ;
      var $18 = $e;
      var $19 = $18 + 1;
      var $20 = $19 << 3;
      var $21 = $2;
      var $22 = $21 - 8;
      var $23 = $20 | $22;
      $1 = $23;
      ;
    }
    var $25 = $1;
    ;
    return $25;
  }
  __Z11luaO_int2fbj.__index__ = Runtime.getFunctionIndex(__Z11luaO_int2fbj, "__Z11luaO_int2fbj");
  
  
  function __Z11luaO_fb2inti($x) {
    ;
    var __label__;
    var $1;
    var $2;
    var $e;
    $2 = $x;
    var $3 = $2;
    var $4 = $3 >> 3;
    var $5 = $4 & 31;
    $e = $5;
    var $6 = $e;
    var $7 = $6 == 0;
    ;
    if ($7) {
      ;
      var $9 = $2;
      $1 = $9;
      ;
    }
    else {
      ;
      var $11 = $2;
      var $12 = $11 & 7;
      var $13 = $12 + 8;
      var $14 = $e;
      var $15 = $14 - 1;
      var $16 = $13 << $15;
      $1 = $16;
      ;
    }
    var $18 = $1;
    ;
    return $18;
  }
  __Z11luaO_fb2inti.__index__ = Runtime.getFunctionIndex(__Z11luaO_fb2inti, "__Z11luaO_fb2inti");
  
  
  function __Z9luaO_log2j($x) {
    ;
    var __label__;
    var $1;
    var $l;
    $1 = $x;
    $l = -1;
    ;
    $2$2: while(1) { // $2
      var $3 = $1;
      var $4 = unSign($3, 32) >= unSign(256, 32);
      if (!($4)) { __label__ = 2; /* $10 */ break $2$2; }
      var $6 = $l;
      var $7 = $6 + 8;
      $l = $7;
      var $8 = $1;
      var $9 = $8 >> 8;
      $1 = $9;
      __label__ = 0; /* $2 */ continue $2$2;
    }
    var $11 = $l;
    var $12 = $1;
    var $13 = __ZZ9luaO_log2jE5log_2+$12;
    var $14 = IHEAP[$13];
    var $15 = $14;
    var $16 = $11 + $15;
    ;
    return $16;
  }
  __Z9luaO_log2j.__index__ = Runtime.getFunctionIndex(__Z9luaO_log2j, "__Z9luaO_log2j");
  
  
  function __Z16luaO_rawequalObjPK10lua_TValueS1_($t1, $t2) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    $2 = $t1;
    $3 = $t2;
    var $4 = $2;
    var $5 = $4+8;
    var $6 = IHEAP[$5];
    var $7 = $3;
    var $8 = $7+8;
    var $9 = IHEAP[$8];
    var $10 = $6 != $9;
    ;
    if ($10) {
      ;
      $1 = 0;
      ;
    }
    else {
      ;
      var $13 = $2;
      var $14 = $13+8;
      var $15 = IHEAP[$14];
      if ($15 == 0) {
        __label__ = 1; /* $16 */ 
      }
      else if ($15 == 3) {
        __label__ = 2; /* $17 */ 
      }
      else if ($15 == 1) {
        __label__ = 3; /* $28 */ 
      }
      else if ($15 == 2) {
        __label__ = 4; /* $41 */ 
      }
      else {
      __label__ = 5; /* $54 */ 
      }
      
      if (__label__ == 5) {
        var $55 = $2;
        var $56 = $55;
        var $57 = $56;
        var $58 = $57;
        var $59 = IHEAP[$58];
        var $60 = $3;
        var $61 = $60;
        var $62 = $61;
        var $63 = $62;
        var $64 = IHEAP[$63];
        var $65 = $59 == $64;
        var $66 = $65;
        $1 = $66;
        ;
      }
      else if (__label__ == 1) {
        $1 = 1;
        ;
      }
      else if (__label__ == 2) {
        var $18 = $2;
        var $19 = $18;
        var $20 = $19;
        var $21 = FHEAP[$20];
        var $22 = $3;
        var $23 = $22;
        var $24 = $23;
        var $25 = FHEAP[$24];
        var $26 = $21 == $25;
        var $27 = $26;
        $1 = $27;
        ;
      }
      else if (__label__ == 3) {
        var $29 = $2;
        var $30 = $29;
        var $31 = $30;
        var $32 = $31;
        var $33 = IHEAP[$32];
        var $34 = $3;
        var $35 = $34;
        var $36 = $35;
        var $37 = $36;
        var $38 = IHEAP[$37];
        var $39 = $33 == $38;
        var $40 = $39;
        $1 = $40;
        ;
      }
      else if (__label__ == 4) {
        var $42 = $2;
        var $43 = $42;
        var $44 = $43;
        var $45 = $44;
        var $46 = IHEAP[$45];
        var $47 = $3;
        var $48 = $47;
        var $49 = $48;
        var $50 = $49;
        var $51 = IHEAP[$50];
        var $52 = $46 == $51;
        var $53 = $52;
        $1 = $53;
        ;
      }
    }
    var $68 = $1;
    ;
    return $68;
  }
  __Z16luaO_rawequalObjPK10lua_TValueS1_.__index__ = Runtime.getFunctionIndex(__Z16luaO_rawequalObjPK10lua_TValueS1_, "__Z16luaO_rawequalObjPK10lua_TValueS1_");
  
  
  function __Z10luaO_str2dPKcPd($s, $result) {
    var __stackBase__  = STACKTOP; STACKTOP += 4; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $endptr = __stackBase__;
    $2 = $s;
    $3 = $result;
    var $4 = $2;
    var $5 = _strtod($4, $endptr);
    var $6 = $3;
    FHEAP[$6] = $5;
    var $7 = IHEAP[$endptr];
    var $8 = $2;
    var $9 = $7 == $8;
    ;
    if ($9) {
      ;
      $1 = 0;
      ;
    }
    else {
      ;
      var $12 = IHEAP[$endptr];
      var $13 = IHEAP[$12];
      var $14 = $13;
      var $15 = $14 == 120;
      ;
      $21$16$5: do { 
        if ($15) {
          __label__ = 1; /* $21 */ 
        }
        else {
          ;
          var $17 = IHEAP[$endptr];
          var $18 = IHEAP[$17];
          var $19 = $18;
          var $20 = $19 == 88;
          if ($20) { __label__ = 1; /* $21 */ break $21$16$5; } else { __label__ = 2; /* $26 */ break $21$16$5; }
        }
      } while(0);
      if (__label__ == 1) {
        var $22 = $2;
        var $23 = _strtoul($22, $endptr, 16);
        var $24 = unSign($23, 32);
        var $25 = $3;
        FHEAP[$25] = $24;
        ;
      }
      var $27 = IHEAP[$endptr];
      var $28 = IHEAP[$27];
      var $29 = $28;
      var $30 = $29 == 0;
      ;
      if ($30) {
        ;
        $1 = 1;
        ;
      }
      else {
        ;
        ;
        $33$13: while(1) { // $33
          var $34 = IHEAP[$endptr];
          var $35 = IHEAP[$34];
          var $36 = $35;
          var $37 = _isspace($36);
          var $38 = $37 != 0;
          if (!($38)) { __label__ = 6; /* $42 */ break $33$13; }
          var $40 = IHEAP[$endptr];
          var $41 = $40+1;
          IHEAP[$endptr] = $41;
          __label__ = 4; /* $33 */ continue $33$13;
        }
        var $43 = IHEAP[$endptr];
        var $44 = IHEAP[$43];
        var $45 = $44;
        var $46 = $45 != 0;
        ;
        if ($46) {
          ;
          $1 = 0;
          ;
        }
        else {
          ;
          $1 = 1;
          ;
        }
      }
    }
    var $50 = $1;
    STACKTOP = __stackBase__;
    return $50;
  }
  __Z10luaO_str2dPKcPd.__index__ = Runtime.getFunctionIndex(__Z10luaO_str2dPKcPd, "__Z10luaO_str2dPKcPd");
  
  
  function __Z17luaO_pushvfstringP9lua_StatePKcPc($L, $fmt, $argp) {
    var __stackBase__  = STACKTOP; STACKTOP += 29; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $n;
    var $e;
    var $i_o;
    var $s;
    var $buff = __stackBase__;
    var $i_o1;
    var $i_o2;
    var $buff3 = __stackBase__+2;
    var $buff4 = __stackBase__+26;
    $1 = $L;
    $2 = $fmt;
    $3 = $argp;
    $n = 1;
    var $4 = $1;
    __Z7pushstrP9lua_StatePKc($4, __str77);
    ;
    $5$2: while(1) { // $5
      var $6 = $2;
      var $7 = _strchr($6, 37);
      $e = $7;
      var $8 = $e;
      var $9 = $8 == 0;
      if ($9) { __label__ = 1; /* $10 */ break $5$2; }
      var $12 = $1;
      var $13 = $12+8;
      var $14 = IHEAP[$13];
      $i_o = $14;
      var $15 = $1;
      var $16 = $2;
      var $17 = $e;
      var $18 = $2;
      var $19 = $17;
      var $20 = $18;
      var $21 = $19 - $20;
      var $22 = __Z12luaS_newlstrP9lua_StatePKcj($15, $16, $21);
      var $23 = $22;
      var $24 = $i_o;
      var $25 = $24;
      var $26 = $25;
      var $27 = $26;
      IHEAP[$27] = $23;
      var $28 = $i_o;
      var $29 = $28+8;
      IHEAP[$29] = 4;
      var $30 = $1;
      var $31 = $30+28;
      var $32 = IHEAP[$31];
      var $33 = $32;
      var $34 = $1;
      var $35 = $34+8;
      var $36 = IHEAP[$35];
      var $37 = $36;
      var $38 = $33;
      var $39 = $37;
      var $40 = $38 - $39;
      var $41 = $40 <= 12;
      ;
      if ($41) {
        ;
        var $43 = $1;
        __Z14luaD_growstackP9lua_Statei($43, 1);
        ;
      }
      else {
        ;
        ;
      }
      var $46 = $1;
      var $47 = $46+8;
      var $48 = IHEAP[$47];
      var $49 = $48+12;
      IHEAP[$47] = $49;
      var $50 = $e;
      var $51 = $50+1;
      var $52 = IHEAP[$51];
      var $53 = $52;
      if ($53 == 115) {
        __label__ = 9; /* $54 */ 
      }
      else if ($53 == 99) {
        __label__ = 10; /* $65 */ 
      }
      else if ($53 == 100) {
        __label__ = 11; /* $75 */ 
      }
      else if ($53 == 102) {
        __label__ = 12; /* $109 */ 
      }
      else if ($53 == 112) {
        __label__ = 13; /* $142 */ 
      }
      else if ($53 == 37) {
        __label__ = 14; /* $151 */ 
      }
      else {
      __label__ = 15; /* $153 */ 
      }
      
      if (__label__ == 15) {
        var $154 = $buff4;
        IHEAP[$154] = 37;
        var $155 = $e;
        var $156 = $155+1;
        var $157 = IHEAP[$156];
        var $158 = $buff4+1;
        IHEAP[$158] = $157;
        var $159 = $buff4+2;
        IHEAP[$159] = 0;
        var $160 = $1;
        var $161 = $buff4;
        __Z7pushstrP9lua_StatePKc($160, $161);
        ;
      }
      else if (__label__ == 9) {
        var $55 = $3;
        var $56 = $55;
        var $57 = $55+4;
        $3 = $57;
        var $58 = IHEAP[$56];
        $s = $58;
        var $59 = $s;
        var $60 = $59 == 0;
        ;
        if ($60) {
          ;
          $s = __str178;
          ;
        }
        var $63 = $1;
        var $64 = $s;
        __Z7pushstrP9lua_StatePKc($63, $64);
        ;
      }
      else if (__label__ == 10) {
        var $66 = $3;
        var $67 = $66;
        var $68 = $66+4;
        $3 = $68;
        var $69 = IHEAP[$67];
        var $70 = $69;
        var $71 = $buff;
        IHEAP[$71] = $70;
        var $72 = $buff+1;
        IHEAP[$72] = 0;
        var $73 = $1;
        var $74 = $buff;
        __Z7pushstrP9lua_StatePKc($73, $74);
        ;
      }
      else if (__label__ == 11) {
        var $76 = $1;
        var $77 = $76+8;
        var $78 = IHEAP[$77];
        $i_o1 = $78;
        var $79 = $3;
        var $80 = $79;
        var $81 = $79+4;
        $3 = $81;
        var $82 = IHEAP[$80];
        var $83 = $82;
        var $84 = $i_o1;
        var $85 = $84;
        var $86 = $85;
        FHEAP[$86] = $83;
        var $87 = $i_o1;
        var $88 = $87+8;
        IHEAP[$88] = 3;
        var $89 = $1;
        var $90 = $89+28;
        var $91 = IHEAP[$90];
        var $92 = $91;
        var $93 = $1;
        var $94 = $93+8;
        var $95 = IHEAP[$94];
        var $96 = $95;
        var $97 = $92;
        var $98 = $96;
        var $99 = $97 - $98;
        var $100 = $99 <= 12;
        ;
        if ($100) {
          ;
          var $102 = $1;
          __Z14luaD_growstackP9lua_Statei($102, 1);
          ;
        }
        else {
          ;
          ;
        }
        var $105 = $1;
        var $106 = $105+8;
        var $107 = IHEAP[$106];
        var $108 = $107+12;
        IHEAP[$106] = $108;
        ;
      }
      else if (__label__ == 12) {
        var $110 = $1;
        var $111 = $110+8;
        var $112 = IHEAP[$111];
        $i_o2 = $112;
        var $113 = $3;
        var $114 = $113;
        var $115 = $113+8;
        $3 = $115;
        var $116 = FHEAP[$114];
        var $117 = $i_o2;
        var $118 = $117;
        var $119 = $118;
        FHEAP[$119] = $116;
        var $120 = $i_o2;
        var $121 = $120+8;
        IHEAP[$121] = 3;
        var $122 = $1;
        var $123 = $122+28;
        var $124 = IHEAP[$123];
        var $125 = $124;
        var $126 = $1;
        var $127 = $126+8;
        var $128 = IHEAP[$127];
        var $129 = $128;
        var $130 = $125;
        var $131 = $129;
        var $132 = $130 - $131;
        var $133 = $132 <= 12;
        ;
        if ($133) {
          ;
          var $135 = $1;
          __Z14luaD_growstackP9lua_Statei($135, 1);
          ;
        }
        else {
          ;
          ;
        }
        var $138 = $1;
        var $139 = $138+8;
        var $140 = IHEAP[$139];
        var $141 = $140+12;
        IHEAP[$139] = $141;
        ;
      }
      else if (__label__ == 13) {
        var $143 = $buff3;
        var $144 = $3;
        var $145 = $144;
        var $146 = $144+4;
        $3 = $146;
        var $147 = IHEAP[$145];
        var $148 = _sprintf($143, __str279, $147);
        var $149 = $1;
        var $150 = $buff3;
        __Z7pushstrP9lua_StatePKc($149, $150);
        ;
      }
      else if (__label__ == 14) {
        var $152 = $1;
        __Z7pushstrP9lua_StatePKc($152, __str380);
        ;
      }
      var $163 = $n;
      var $164 = $163 + 2;
      $n = $164;
      var $165 = $e;
      var $166 = $165+2;
      $2 = $166;
      __label__ = 0; /* $5 */ continue $5$2;
    }
    ;
    var $168 = $1;
    var $169 = $2;
    __Z7pushstrP9lua_StatePKc($168, $169);
    var $170 = $1;
    var $171 = $n;
    var $172 = $171 + 1;
    var $173 = $1;
    var $174 = $173+8;
    var $175 = IHEAP[$174];
    var $176 = $1;
    var $177 = $176+12;
    var $178 = IHEAP[$177];
    var $179 = $175;
    var $180 = $178;
    var $181 = $179 - $180;
    var $182 = Math.floor($181 / 12);
    var $183 = $182 - 1;
    __Z11luaV_concatP9lua_Stateii($170, $172, $183);
    var $184 = $n;
    var $185 = $1;
    var $186 = $185+8;
    var $187 = IHEAP[$186];
    var $188 = 0 - $184;
    var $189 = $187+12*$188;
    IHEAP[$186] = $189;
    var $190 = $1;
    var $191 = $190+8;
    var $192 = IHEAP[$191];
    var $193 = $192+-12;
    var $194 = $193;
    var $195 = $194;
    var $196 = $195;
    var $197 = IHEAP[$196];
    var $198 = $197;
    var $199 = $198;
    var $200 = $199+16;
    var $201 = $200;
    STACKTOP = __stackBase__;
    return $201;
  }
  __Z17luaO_pushvfstringP9lua_StatePKcPc.__index__ = Runtime.getFunctionIndex(__Z17luaO_pushvfstringP9lua_StatePKcPc, "__Z17luaO_pushvfstringP9lua_StatePKcPc");
  
  
  function __Z7pushstrP9lua_StatePKc($L, $str) {
    ;
    var __label__;
    var $1;
    var $2;
    var $i_o;
    $1 = $L;
    $2 = $str;
    var $3 = $1;
    var $4 = $3+8;
    var $5 = IHEAP[$4];
    $i_o = $5;
    var $6 = $1;
    var $7 = $2;
    var $8 = $2;
    var $9 = _strlen($8);
    var $10 = __Z12luaS_newlstrP9lua_StatePKcj($6, $7, $9);
    var $11 = $10;
    var $12 = $i_o;
    var $13 = $12;
    var $14 = $13;
    var $15 = $14;
    IHEAP[$15] = $11;
    var $16 = $i_o;
    var $17 = $16+8;
    IHEAP[$17] = 4;
    var $18 = $1;
    var $19 = $18+28;
    var $20 = IHEAP[$19];
    var $21 = $20;
    var $22 = $1;
    var $23 = $22+8;
    var $24 = IHEAP[$23];
    var $25 = $24;
    var $26 = $21;
    var $27 = $25;
    var $28 = $26 - $27;
    var $29 = $28 <= 12;
    ;
    if ($29) {
      ;
      var $31 = $1;
      __Z14luaD_growstackP9lua_Statei($31, 1);
      ;
    }
    else {
      ;
      ;
    }
    var $34 = $1;
    var $35 = $34+8;
    var $36 = IHEAP[$35];
    var $37 = $36+12;
    IHEAP[$35] = $37;
    ;
    return;
  }
  __Z7pushstrP9lua_StatePKc.__index__ = Runtime.getFunctionIndex(__Z7pushstrP9lua_StatePKc, "__Z7pushstrP9lua_StatePKc");
  
  
  function __Z16luaO_pushfstringP9lua_StatePKcz($L, $fmt) {
    var __stackBase__  = STACKTOP; STACKTOP += 4; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var __numArgs__ = 2;
    var $1;
    var $2;
    var $msg;
    var $argp = __stackBase__;
    $1 = $L;
    $2 = $fmt;
    var $3 = $argp;
    IHEAP[$3] = arguments[__numArgs__];
    var $4 = $1;
    var $5 = $2;
    var $6 = IHEAP[$argp];
    var $7 = __Z17luaO_pushvfstringP9lua_StatePKcPc($4, $5, $6);
    $msg = $7;
    var $8 = $argp;
    ;;
    var $9 = $msg;
    STACKTOP = __stackBase__;
    return $9;
  }
  __Z16luaO_pushfstringP9lua_StatePKcz.__index__ = Runtime.getFunctionIndex(__Z16luaO_pushfstringP9lua_StatePKcz, "__Z16luaO_pushfstringP9lua_StatePKcz");
  
  
  function __Z12luaO_chunkidPcPKcj($out, $source, $bufflen) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $l;
    var $len;
    $1 = $out;
    $2 = $source;
    $3 = $bufflen;
    var $4 = $2;
    var $5 = IHEAP[$4];
    var $6 = $5;
    var $7 = $6 == 61;
    ;
    if ($7) {
      ;
      var $9 = $1;
      var $10 = $2;
      var $11 = $10+1;
      var $12 = $3;
      var $13 = _strncpy($9, $11, $12);
      var $14 = $3;
      var $15 = $14 - 1;
      var $16 = $1;
      var $17 = $16+$15;
      IHEAP[$17] = 0;
      ;
    }
    else {
      ;
      var $19 = $2;
      var $20 = IHEAP[$19];
      var $21 = $20;
      var $22 = $21 == 64;
      ;
      if ($22) {
        ;
        var $24 = $2;
        var $25 = $24+1;
        $2 = $25;
        var $26 = $3;
        var $27 = $26 - 8;
        $3 = $27;
        var $28 = $2;
        var $29 = _strlen($28);
        $l = $29;
        var $30 = $1;
        var $31 = _strcpy($30, __str77);
        var $32 = $l;
        var $33 = $3;
        var $34 = unSign($32, 32) > unSign($33, 32);
        ;
        if ($34) {
          ;
          var $36 = $l;
          var $37 = $3;
          var $38 = $36 - $37;
          var $39 = $2;
          var $40 = $39+$38;
          $2 = $40;
          var $41 = $1;
          var $42 = _strcat($41, __str481);
          ;
        }
        var $44 = $1;
        var $45 = $2;
        var $46 = _strcat($44, $45);
        ;
      }
      else {
        ;
        var $48 = $2;
        var $49 = _strcspn($48, __str582);
        $len = $49;
        var $50 = $3;
        var $51 = $50 - 17;
        $3 = $51;
        var $52 = $len;
        var $53 = $3;
        var $54 = unSign($52, 32) > unSign($53, 32);
        ;
        if ($54) {
          ;
          var $56 = $3;
          $len = $56;
          ;
        }
        var $58 = $1;
        var $59 = _strcpy($58, __str683);
        var $60 = $len;
        var $61 = $2;
        var $62 = $61+$60;
        var $63 = IHEAP[$62];
        var $64 = $63;
        var $65 = $64 != 0;
        ;
        if ($65) {
          ;
          var $67 = $1;
          var $68 = $2;
          var $69 = $len;
          var $70 = _strncat($67, $68, $69);
          var $71 = $1;
          var $72 = _strcat($71, __str481);
          ;
        }
        else {
          ;
          var $74 = $1;
          var $75 = $2;
          var $76 = _strcat($74, $75);
          ;
        }
        var $78 = $1;
        var $79 = _strcat($78, __str784);
        ;
      }
      ;
    }
    ;
    return;
  }
  __Z12luaO_chunkidPcPKcj.__index__ = Runtime.getFunctionIndex(__Z12luaO_chunkidPcPKcj, "__Z12luaO_chunkidPcPKcj");
  
  
  function __Z11luaY_parserP9lua_StateP3ZioP7MbufferPKc($L, $z, $buff, $name) {
    var __stackBase__  = STACKTOP; STACKTOP += 632; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $lexstate = __stackBase__;
    var $funcstate = __stackBase__+60;
    $1 = $L;
    $2 = $z;
    $3 = $buff;
    $4 = $name;
    var $5 = $3;
    var $6 = $lexstate+48;
    IHEAP[$6] = $5;
    var $7 = $1;
    var $8 = $2;
    var $9 = $1;
    var $10 = $4;
    var $11 = $4;
    var $12 = _strlen($11);
    var $13 = __Z12luaS_newlstrP9lua_StatePKcj($9, $10, $12);
    __Z13luaX_setinputP9lua_StateP8LexStateP3ZioP7TString($7, $lexstate, $8, $13);
    __Z9open_funcP8LexStateP9FuncState($lexstate, $funcstate);
    var $14 = $funcstate;
    var $15 = IHEAP[$14];
    var $16 = $15+74;
    IHEAP[$16] = 2;
    __Z9luaX_nextP8LexState($lexstate);
    __Z5chunkP8LexState($lexstate);
    __Z5checkP8LexStatei($lexstate, 287);
    __Z10close_funcP8LexState($lexstate);
    var $17 = $funcstate;
    var $18 = IHEAP[$17];
    STACKTOP = __stackBase__;
    return $18;
  }
  __Z11luaY_parserP9lua_StateP3ZioP7MbufferPKc.__index__ = Runtime.getFunctionIndex(__Z11luaY_parserP9lua_StateP3ZioP7MbufferPKc, "__Z11luaY_parserP9lua_StateP3ZioP7MbufferPKc");
  
  
  function __Z9open_funcP8LexStateP9FuncState($ls, $fs) {
    ;
    var __label__;
    var $1;
    var $2;
    var $L;
    var $f;
    var $i_o;
    var $i_o1;
    $1 = $ls;
    $2 = $fs;
    var $3 = $1;
    var $4 = $3+40;
    var $5 = IHEAP[$4];
    $L = $5;
    var $6 = $L;
    var $7 = __Z13luaF_newprotoP9lua_State($6);
    $f = $7;
    var $8 = $f;
    var $9 = $2;
    var $10 = $9;
    IHEAP[$10] = $8;
    var $11 = $1;
    var $12 = $11+36;
    var $13 = IHEAP[$12];
    var $14 = $2;
    var $15 = $14+8;
    IHEAP[$15] = $13;
    var $16 = $1;
    var $17 = $2;
    var $18 = $17+12;
    IHEAP[$18] = $16;
    var $19 = $L;
    var $20 = $2;
    var $21 = $20+16;
    IHEAP[$21] = $19;
    var $22 = $2;
    var $23 = $1;
    var $24 = $23+36;
    IHEAP[$24] = $22;
    var $25 = $2;
    var $26 = $25+24;
    IHEAP[$26] = 0;
    var $27 = $2;
    var $28 = $27+28;
    IHEAP[$28] = -1;
    var $29 = $2;
    var $30 = $29+32;
    IHEAP[$30] = -1;
    var $31 = $2;
    var $32 = $31+36;
    IHEAP[$32] = 0;
    var $33 = $2;
    var $34 = $33+40;
    IHEAP[$34] = 0;
    var $35 = $2;
    var $36 = $35+44;
    IHEAP[$36] = 0;
    var $37 = $2;
    var $38 = $37+48;
    IHEAP[$38] = 0;
    var $39 = $2;
    var $40 = $39+50;
    IHEAP[$40] = 0;
    var $41 = $2;
    var $42 = $41+20;
    IHEAP[$42] = 0;
    var $43 = $1;
    var $44 = $43+52;
    var $45 = IHEAP[$44];
    var $46 = $f;
    var $47 = $46+32;
    IHEAP[$47] = $45;
    var $48 = $f;
    var $49 = $48+75;
    IHEAP[$49] = 2;
    var $50 = $L;
    var $51 = __Z8luaH_newP9lua_Stateii($50, 0, 0);
    var $52 = $2;
    var $53 = $52+4;
    IHEAP[$53] = $51;
    var $54 = $L;
    var $55 = $54+8;
    var $56 = IHEAP[$55];
    $i_o = $56;
    var $57 = $2;
    var $58 = $57+4;
    var $59 = IHEAP[$58];
    var $60 = $59;
    var $61 = $i_o;
    var $62 = $61;
    var $63 = $62;
    var $64 = $63;
    IHEAP[$64] = $60;
    var $65 = $i_o;
    var $66 = $65+8;
    IHEAP[$66] = 5;
    var $67 = $L;
    var $68 = $67+28;
    var $69 = IHEAP[$68];
    var $70 = $69;
    var $71 = $L;
    var $72 = $71+8;
    var $73 = IHEAP[$72];
    var $74 = $73;
    var $75 = $70;
    var $76 = $74;
    var $77 = $75 - $76;
    var $78 = $77 <= 12;
    ;
    if ($78) {
      ;
      var $80 = $L;
      __Z14luaD_growstackP9lua_Statei($80, 1);
      ;
    }
    else {
      ;
      ;
    }
    var $83 = $L;
    var $84 = $83+8;
    var $85 = IHEAP[$84];
    var $86 = $85+12;
    IHEAP[$84] = $86;
    var $87 = $L;
    var $88 = $87+8;
    var $89 = IHEAP[$88];
    $i_o1 = $89;
    var $90 = $f;
    var $91 = $90;
    var $92 = $i_o1;
    var $93 = $92;
    var $94 = $93;
    var $95 = $94;
    IHEAP[$95] = $91;
    var $96 = $i_o1;
    var $97 = $96+8;
    IHEAP[$97] = 9;
    var $98 = $L;
    var $99 = $98+28;
    var $100 = IHEAP[$99];
    var $101 = $100;
    var $102 = $L;
    var $103 = $102+8;
    var $104 = IHEAP[$103];
    var $105 = $104;
    var $106 = $101;
    var $107 = $105;
    var $108 = $106 - $107;
    var $109 = $108 <= 12;
    ;
    if ($109) {
      ;
      var $111 = $L;
      __Z14luaD_growstackP9lua_Statei($111, 1);
      ;
    }
    else {
      ;
      ;
    }
    var $114 = $L;
    var $115 = $114+8;
    var $116 = IHEAP[$115];
    var $117 = $116+12;
    IHEAP[$115] = $117;
    ;
    return;
  }
  __Z9open_funcP8LexStateP9FuncState.__index__ = Runtime.getFunctionIndex(__Z9open_funcP8LexStateP9FuncState, "__Z9open_funcP8LexStateP9FuncState");
  
  
  function __Z5chunkP8LexState($ls) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $islast;
    $1 = $ls;
    $islast = 0;
    var $2 = $1;
    __Z10enterlevelP8LexState($2);
    ;
    $3$2: while(1) { // $3
      var $4 = $islast;
      var $5 = $4 != 0;
      ;
      if ($5) {
        __lastLabel__ = 0; ;
      }
      else {
        __lastLabel__ = 0; ;
        var $7 = $1;
        var $8 = $7+12;
        var $9 = $8;
        var $10 = IHEAP[$9];
        var $11 = __Z12block_followi($10);
        var $12 = $11 != 0;
        var $13 = $12 ^ 1;
        __lastLabel__ = 1; ;
      }
      var $15 = __lastLabel__ == 0 ? 0 : ($13);
      if (!($15)) { __label__ = 4; /* $31 */ break $3$2; }
      var $17 = $1;
      var $18 = __Z9statementP8LexState($17);
      $islast = $18;
      var $19 = $1;
      var $20 = __Z8testnextP8LexStatei($19, 59);
      var $21 = $1;
      var $22 = $21+36;
      var $23 = IHEAP[$22];
      var $24 = $23+50;
      var $25 = IHEAP[$24];
      var $26 = $25;
      var $27 = $1;
      var $28 = $27+36;
      var $29 = IHEAP[$28];
      var $30 = $29+36;
      IHEAP[$30] = $26;
      __label__ = 0; /* $3 */ continue $3$2;
    }
    var $32 = $1;
    var $33 = $32+40;
    var $34 = IHEAP[$33];
    var $35 = $34+52;
    var $36 = IHEAP[$35];
    var $37 = $36 + -1;
    IHEAP[$35] = $37;
    ;
    return;
  }
  __Z5chunkP8LexState.__index__ = Runtime.getFunctionIndex(__Z5chunkP8LexState, "__Z5chunkP8LexState");
  
  
  function __Z5checkP8LexStatei($ls, $c) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $ls;
    $2 = $c;
    var $3 = $1;
    var $4 = $3+12;
    var $5 = $4;
    var $6 = IHEAP[$5];
    var $7 = $2;
    var $8 = $6 != $7;
    ;
    if ($8) {
      ;
      var $10 = $1;
      var $11 = $2;
      __Z14error_expectedP8LexStatei($10, $11);
      ;
    }
    ;
    return;
  }
  __Z5checkP8LexStatei.__index__ = Runtime.getFunctionIndex(__Z5checkP8LexStatei, "__Z5checkP8LexStatei");
  
  
  function __Z10close_funcP8LexState($ls) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $L;
    var $fs;
    var $f;
    $1 = $ls;
    var $2 = $1;
    var $3 = $2+40;
    var $4 = IHEAP[$3];
    $L = $4;
    var $5 = $1;
    var $6 = $5+36;
    var $7 = IHEAP[$6];
    $fs = $7;
    var $8 = $fs;
    var $9 = $8;
    var $10 = IHEAP[$9];
    $f = $10;
    var $11 = $1;
    __Z10removevarsP8LexStatei($11, 0);
    var $12 = $fs;
    __Z8luaK_retP9FuncStateii($12, 0, 0);
    var $13 = $fs;
    var $14 = $13+24;
    var $15 = IHEAP[$14];
    var $16 = $15 + 1;
    var $17 = unSign($16, 32) <= unSign(1073741823, 32);
    ;
    if ($17) {
      ;
      var $19 = $L;
      var $20 = $f;
      var $21 = $20+12;
      var $22 = IHEAP[$21];
      var $23 = $22;
      var $24 = $f;
      var $25 = $24+44;
      var $26 = IHEAP[$25];
      var $27 = $26 * 4;
      var $28 = $fs;
      var $29 = $28+24;
      var $30 = IHEAP[$29];
      var $31 = $30 * 4;
      var $32 = __Z13luaM_realloc_P9lua_StatePvjj($19, $23, $27, $31);
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $34 = $L;
      var $35 = __Z11luaM_toobigP9lua_State($34);
      __lastLabel__ = 2; ;
    }
    var $37 = __lastLabel__ == 0 ? $32 : ($35);
    var $38 = $37;
    var $39 = $f;
    var $40 = $39+12;
    IHEAP[$40] = $38;
    var $41 = $fs;
    var $42 = $41+24;
    var $43 = IHEAP[$42];
    var $44 = $f;
    var $45 = $44+44;
    IHEAP[$45] = $43;
    var $46 = $fs;
    var $47 = $46+24;
    var $48 = IHEAP[$47];
    var $49 = $48 + 1;
    var $50 = unSign($49, 32) <= unSign(1073741823, 32);
    ;
    if ($50) {
      ;
      var $52 = $L;
      var $53 = $f;
      var $54 = $53+20;
      var $55 = IHEAP[$54];
      var $56 = $55;
      var $57 = $f;
      var $58 = $57+48;
      var $59 = IHEAP[$58];
      var $60 = $59 * 4;
      var $61 = $fs;
      var $62 = $61+24;
      var $63 = IHEAP[$62];
      var $64 = $63 * 4;
      var $65 = __Z13luaM_realloc_P9lua_StatePvjj($52, $56, $60, $64);
      __lastLabel__ = 3; ;
    }
    else {
      ;
      var $67 = $L;
      var $68 = __Z11luaM_toobigP9lua_State($67);
      __lastLabel__ = 5; ;
    }
    var $70 = __lastLabel__ == 3 ? $65 : ($68);
    var $71 = $70;
    var $72 = $f;
    var $73 = $72+20;
    IHEAP[$73] = $71;
    var $74 = $fs;
    var $75 = $74+24;
    var $76 = IHEAP[$75];
    var $77 = $f;
    var $78 = $77+48;
    IHEAP[$78] = $76;
    var $79 = $fs;
    var $80 = $79+40;
    var $81 = IHEAP[$80];
    var $82 = $81 + 1;
    var $83 = unSign($82, 32) <= unSign(357913941, 32);
    ;
    if ($83) {
      ;
      var $85 = $L;
      var $86 = $f;
      var $87 = $86+8;
      var $88 = IHEAP[$87];
      var $89 = $88;
      var $90 = $f;
      var $91 = $90+40;
      var $92 = IHEAP[$91];
      var $93 = $92 * 12;
      var $94 = $fs;
      var $95 = $94+40;
      var $96 = IHEAP[$95];
      var $97 = $96 * 12;
      var $98 = __Z13luaM_realloc_P9lua_StatePvjj($85, $89, $93, $97);
      __lastLabel__ = 6; ;
    }
    else {
      ;
      var $100 = $L;
      var $101 = __Z11luaM_toobigP9lua_State($100);
      __lastLabel__ = 8; ;
    }
    var $103 = __lastLabel__ == 6 ? $98 : ($101);
    var $104 = $103;
    var $105 = $f;
    var $106 = $105+8;
    IHEAP[$106] = $104;
    var $107 = $fs;
    var $108 = $107+40;
    var $109 = IHEAP[$108];
    var $110 = $f;
    var $111 = $110+40;
    IHEAP[$111] = $109;
    var $112 = $fs;
    var $113 = $112+44;
    var $114 = IHEAP[$113];
    var $115 = $114 + 1;
    var $116 = unSign($115, 32) <= unSign(1073741823, 32);
    ;
    if ($116) {
      ;
      var $118 = $L;
      var $119 = $f;
      var $120 = $119+16;
      var $121 = IHEAP[$120];
      var $122 = $121;
      var $123 = $f;
      var $124 = $123+52;
      var $125 = IHEAP[$124];
      var $126 = $125 * 4;
      var $127 = $fs;
      var $128 = $127+44;
      var $129 = IHEAP[$128];
      var $130 = $129 * 4;
      var $131 = __Z13luaM_realloc_P9lua_StatePvjj($118, $122, $126, $130);
      __lastLabel__ = 9; ;
    }
    else {
      ;
      var $133 = $L;
      var $134 = __Z11luaM_toobigP9lua_State($133);
      __lastLabel__ = 11; ;
    }
    var $136 = __lastLabel__ == 9 ? $131 : ($134);
    var $137 = $136;
    var $138 = $f;
    var $139 = $138+16;
    IHEAP[$139] = $137;
    var $140 = $fs;
    var $141 = $140+44;
    var $142 = IHEAP[$141];
    var $143 = $f;
    var $144 = $143+52;
    IHEAP[$144] = $142;
    var $145 = $fs;
    var $146 = $145+48;
    var $147 = IHEAP[$146];
    var $148 = $147;
    var $149 = $148 + 1;
    var $150 = unSign($149, 32) <= unSign(357913941, 32);
    ;
    if ($150) {
      ;
      var $152 = $L;
      var $153 = $f;
      var $154 = $153+24;
      var $155 = IHEAP[$154];
      var $156 = $155;
      var $157 = $f;
      var $158 = $157+56;
      var $159 = IHEAP[$158];
      var $160 = $159 * 12;
      var $161 = $fs;
      var $162 = $161+48;
      var $163 = IHEAP[$162];
      var $164 = $163;
      var $165 = $164 * 12;
      var $166 = __Z13luaM_realloc_P9lua_StatePvjj($152, $156, $160, $165);
      __lastLabel__ = 12; ;
    }
    else {
      ;
      var $168 = $L;
      var $169 = __Z11luaM_toobigP9lua_State($168);
      __lastLabel__ = 14; ;
    }
    var $171 = __lastLabel__ == 12 ? $166 : ($169);
    var $172 = $171;
    var $173 = $f;
    var $174 = $173+24;
    IHEAP[$174] = $172;
    var $175 = $fs;
    var $176 = $175+48;
    var $177 = IHEAP[$176];
    var $178 = $177;
    var $179 = $f;
    var $180 = $179+56;
    IHEAP[$180] = $178;
    var $181 = $f;
    var $182 = $181+72;
    var $183 = IHEAP[$182];
    var $184 = $183;
    var $185 = $184 + 1;
    var $186 = unSign($185, 32) <= unSign(1073741823, 32);
    ;
    if ($186) {
      ;
      var $188 = $L;
      var $189 = $f;
      var $190 = $189+28;
      var $191 = IHEAP[$190];
      var $192 = $191;
      var $193 = $f;
      var $194 = $193+36;
      var $195 = IHEAP[$194];
      var $196 = $195 * 4;
      var $197 = $f;
      var $198 = $197+72;
      var $199 = IHEAP[$198];
      var $200 = $199;
      var $201 = $200 * 4;
      var $202 = __Z13luaM_realloc_P9lua_StatePvjj($188, $192, $196, $201);
      __lastLabel__ = 15; ;
    }
    else {
      ;
      var $204 = $L;
      var $205 = __Z11luaM_toobigP9lua_State($204);
      __lastLabel__ = 17; ;
    }
    var $207 = __lastLabel__ == 15 ? $202 : ($205);
    var $208 = $207;
    var $209 = $f;
    var $210 = $209+28;
    IHEAP[$210] = $208;
    var $211 = $f;
    var $212 = $211+72;
    var $213 = IHEAP[$212];
    var $214 = $213;
    var $215 = $f;
    var $216 = $215+36;
    IHEAP[$216] = $214;
    var $217 = $fs;
    var $218 = $217+8;
    var $219 = IHEAP[$218];
    var $220 = $1;
    var $221 = $220+36;
    IHEAP[$221] = $219;
    var $222 = $L;
    var $223 = $222+8;
    var $224 = IHEAP[$223];
    var $225 = $224+-24;
    IHEAP[$223] = $225;
    var $226 = $fs;
    var $227 = $226 != 0;
    ;
    if ($227) {
      ;
      var $229 = $1;
      __Z12anchor_tokenP8LexState($229);
      ;
    }
    ;
    return;
  }
  __Z10close_funcP8LexState.__index__ = Runtime.getFunctionIndex(__Z10close_funcP8LexState, "__Z10close_funcP8LexState");
  
  
  function __Z10enterlevelP8LexState($ls) {
    ;
    var __label__;
    var $1;
    $1 = $ls;
    var $2 = $1;
    var $3 = $2+40;
    var $4 = IHEAP[$3];
    var $5 = $4+52;
    var $6 = IHEAP[$5];
    var $7 = $6 + 1;
    IHEAP[$5] = $7;
    var $8 = $7;
    var $9 = $8 > 200;
    ;
    if ($9) {
      ;
      var $11 = $1;
      __Z13luaX_lexerrorP8LexStatePKci($11, __str27156, 0);
      ;
    }
    ;
    return;
  }
  __Z10enterlevelP8LexState.__index__ = Runtime.getFunctionIndex(__Z10enterlevelP8LexState, "__Z10enterlevelP8LexState");
  
  
  function __Z12block_followi($token) {
    ;
    var __label__;
    var $1;
    var $2;
    $2 = $token;
    var $3 = $2;
    if ($3 == 260) {
      __label__ = 1; /* $4 */ 
    }
    else if ($3 == 261) {
      __label__ = 1; /* $4 */ 
    }
    else if ($3 == 262) {
      __label__ = 1; /* $4 */ 
    }
    else if ($3 == 276) {
      __label__ = 1; /* $4 */ 
    }
    else if ($3 == 287) {
      __label__ = 1; /* $4 */ 
    }
    else {
    __label__ = 2; /* $5 */ 
    }
    
    if (__label__ == 2) {
      $1 = 0;
      ;
    }
    else if (__label__ == 1) {
      $1 = 1;
      ;
    }
    var $7 = $1;
    ;
    return $7;
  }
  __Z12block_followi.__index__ = Runtime.getFunctionIndex(__Z12block_followi, "__Z12block_followi");
  
  
  function __Z9statementP8LexState($ls) {
    ;
    var __label__;
    var $1;
    var $2;
    var $line;
    $2 = $ls;
    var $3 = $2;
    var $4 = $3+4;
    var $5 = IHEAP[$4];
    $line = $5;
    var $6 = $2;
    var $7 = $6+12;
    var $8 = $7;
    var $9 = IHEAP[$8];
    if ($9 == 266) {
      __label__ = 2; /* $10 */ 
    }
    else if ($9 == 277) {
      __label__ = 3; /* $13 */ 
    }
    else if ($9 == 259) {
      __label__ = 4; /* $16 */ 
    }
    else if ($9 == 264) {
      __label__ = 5; /* $21 */ 
    }
    else if ($9 == 272) {
      __label__ = 6; /* $24 */ 
    }
    else if ($9 == 265) {
      __label__ = 7; /* $27 */ 
    }
    else if ($9 == 268) {
      __label__ = 8; /* $30 */ 
    }
    else if ($9 == 273) {
      __label__ = 9; /* $40 */ 
    }
    else if ($9 == 258) {
      __label__ = 10; /* $42 */ 
    }
    else {
    __label__ = 11; /* $45 */ 
    }
    
    if (__label__ == 11) {
      var $46 = $2;
      __Z8exprstatP8LexState($46);
      $1 = 0;
      ;
    }
    else if (__label__ == 2) {
      var $11 = $2;
      var $12 = $line;
      __Z6ifstatP8LexStatei($11, $12);
      $1 = 0;
      ;
    }
    else if (__label__ == 3) {
      var $14 = $2;
      var $15 = $line;
      __Z9whilestatP8LexStatei($14, $15);
      $1 = 0;
      ;
    }
    else if (__label__ == 4) {
      var $17 = $2;
      __Z9luaX_nextP8LexState($17);
      var $18 = $2;
      __Z5blockP8LexState($18);
      var $19 = $2;
      var $20 = $line;
      __Z11check_matchP8LexStateiii($19, 262, 259, $20);
      $1 = 0;
      ;
    }
    else if (__label__ == 5) {
      var $22 = $2;
      var $23 = $line;
      __Z7forstatP8LexStatei($22, $23);
      $1 = 0;
      ;
    }
    else if (__label__ == 6) {
      var $25 = $2;
      var $26 = $line;
      __Z10repeatstatP8LexStatei($25, $26);
      $1 = 0;
      ;
    }
    else if (__label__ == 7) {
      var $28 = $2;
      var $29 = $line;
      __Z8funcstatP8LexStatei($28, $29);
      $1 = 0;
      ;
    }
    else if (__label__ == 8) {
      var $31 = $2;
      __Z9luaX_nextP8LexState($31);
      var $32 = $2;
      var $33 = __Z8testnextP8LexStatei($32, 265);
      var $34 = $33 != 0;
      ;
      if ($34) {
        ;
        var $36 = $2;
        __Z9localfuncP8LexState($36);
        ;
      }
      else {
        ;
        var $38 = $2;
        __Z9localstatP8LexState($38);
        ;
      }
      $1 = 0;
      ;
    }
    else if (__label__ == 9) {
      var $41 = $2;
      __Z7retstatP8LexState($41);
      $1 = 1;
      ;
    }
    else if (__label__ == 10) {
      var $43 = $2;
      __Z9luaX_nextP8LexState($43);
      var $44 = $2;
      __Z9breakstatP8LexState($44);
      $1 = 1;
      ;
    }
    var $48 = $1;
    ;
    return $48;
  }
  __Z9statementP8LexState.__index__ = Runtime.getFunctionIndex(__Z9statementP8LexState, "__Z9statementP8LexState");
  
  
  function __Z8testnextP8LexStatei($ls, $c) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    $2 = $ls;
    $3 = $c;
    var $4 = $2;
    var $5 = $4+12;
    var $6 = $5;
    var $7 = IHEAP[$6];
    var $8 = $3;
    var $9 = $7 == $8;
    ;
    if ($9) {
      ;
      var $11 = $2;
      __Z9luaX_nextP8LexState($11);
      $1 = 1;
      ;
    }
    else {
      ;
      $1 = 0;
      ;
    }
    var $14 = $1;
    ;
    return $14;
  }
  __Z8testnextP8LexStatei.__index__ = Runtime.getFunctionIndex(__Z8testnextP8LexStatei, "__Z8testnextP8LexStatei");
  
  
  function __Z6ifstatP8LexStatei($ls, $line) {
    var __stackBase__  = STACKTOP; STACKTOP += 4; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $fs;
    var $flist;
    var $escapelist = __stackBase__;
    $1 = $ls;
    $2 = $line;
    var $3 = $1;
    var $4 = $3+36;
    var $5 = IHEAP[$4];
    $fs = $5;
    IHEAP[$escapelist] = -1;
    var $6 = $1;
    var $7 = __Z15test_then_blockP8LexState($6);
    $flist = $7;
    ;
    $8$2: while(1) { // $8
      var $9 = $1;
      var $10 = $9+12;
      var $11 = $10;
      var $12 = IHEAP[$11];
      var $13 = $12 == 261;
      if (!($13)) { __label__ = 2; /* $22 */ break $8$2; }
      var $15 = $fs;
      var $16 = $fs;
      var $17 = __Z9luaK_jumpP9FuncState($16);
      __Z11luaK_concatP9FuncStatePii($15, $escapelist, $17);
      var $18 = $fs;
      var $19 = $flist;
      __Z16luaK_patchtohereP9FuncStatei($18, $19);
      var $20 = $1;
      var $21 = __Z15test_then_blockP8LexState($20);
      $flist = $21;
      __label__ = 0; /* $8 */ continue $8$2;
    }
    var $23 = $1;
    var $24 = $23+12;
    var $25 = $24;
    var $26 = IHEAP[$25];
    var $27 = $26 == 260;
    ;
    if ($27) {
      ;
      var $29 = $fs;
      var $30 = $fs;
      var $31 = __Z9luaK_jumpP9FuncState($30);
      __Z11luaK_concatP9FuncStatePii($29, $escapelist, $31);
      var $32 = $fs;
      var $33 = $flist;
      __Z16luaK_patchtohereP9FuncStatei($32, $33);
      var $34 = $1;
      __Z9luaX_nextP8LexState($34);
      var $35 = $1;
      __Z5blockP8LexState($35);
      ;
    }
    else {
      ;
      var $37 = $fs;
      var $38 = $flist;
      __Z11luaK_concatP9FuncStatePii($37, $escapelist, $38);
      ;
    }
    var $40 = $fs;
    var $41 = IHEAP[$escapelist];
    __Z16luaK_patchtohereP9FuncStatei($40, $41);
    var $42 = $1;
    var $43 = $2;
    __Z11check_matchP8LexStateiii($42, 262, 266, $43);
    STACKTOP = __stackBase__;
    return;
  }
  __Z6ifstatP8LexStatei.__index__ = Runtime.getFunctionIndex(__Z6ifstatP8LexStatei, "__Z6ifstatP8LexStatei");
  
  
  function __Z9whilestatP8LexStatei($ls, $line) {
    var __stackBase__  = STACKTOP; STACKTOP += 12; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $fs;
    var $whileinit;
    var $condexit;
    var $bl = __stackBase__;
    $1 = $ls;
    $2 = $line;
    var $3 = $1;
    var $4 = $3+36;
    var $5 = IHEAP[$4];
    $fs = $5;
    var $6 = $1;
    __Z9luaX_nextP8LexState($6);
    var $7 = $fs;
    var $8 = __Z13luaK_getlabelP9FuncState($7);
    $whileinit = $8;
    var $9 = $1;
    var $10 = __Z4condP8LexState($9);
    $condexit = $10;
    var $11 = $fs;
    __Z10enterblockP9FuncStateP8BlockCnth($11, $bl, 1);
    var $12 = $1;
    __Z9checknextP8LexStatei($12, 259);
    var $13 = $1;
    __Z5blockP8LexState($13);
    var $14 = $fs;
    var $15 = $fs;
    var $16 = __Z9luaK_jumpP9FuncState($15);
    var $17 = $whileinit;
    __Z14luaK_patchlistP9FuncStateii($14, $16, $17);
    var $18 = $1;
    var $19 = $2;
    __Z11check_matchP8LexStateiii($18, 262, 277, $19);
    var $20 = $fs;
    __Z10leaveblockP9FuncState($20);
    var $21 = $fs;
    var $22 = $condexit;
    __Z16luaK_patchtohereP9FuncStatei($21, $22);
    STACKTOP = __stackBase__;
    return;
  }
  __Z9whilestatP8LexStatei.__index__ = Runtime.getFunctionIndex(__Z9whilestatP8LexStatei, "__Z9whilestatP8LexStatei");
  
  
  function __Z5blockP8LexState($ls) {
    var __stackBase__  = STACKTOP; STACKTOP += 12; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $fs;
    var $bl = __stackBase__;
    $1 = $ls;
    var $2 = $1;
    var $3 = $2+36;
    var $4 = IHEAP[$3];
    $fs = $4;
    var $5 = $fs;
    __Z10enterblockP9FuncStateP8BlockCnth($5, $bl, 0);
    var $6 = $1;
    __Z5chunkP8LexState($6);
    var $7 = $fs;
    __Z10leaveblockP9FuncState($7);
    STACKTOP = __stackBase__;
    return;
  }
  __Z5blockP8LexState.__index__ = Runtime.getFunctionIndex(__Z5blockP8LexState, "__Z5blockP8LexState");
  
  
  function __Z11check_matchP8LexStateiii($ls, $what, $who, $where) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    $1 = $ls;
    $2 = $what;
    $3 = $who;
    $4 = $where;
    var $5 = $1;
    var $6 = $2;
    var $7 = __Z8testnextP8LexStatei($5, $6);
    var $8 = $7 != 0;
    ;
    if (!$8) {
      ;
      var $10 = $4;
      var $11 = $1;
      var $12 = $11+4;
      var $13 = IHEAP[$12];
      var $14 = $10 == $13;
      ;
      if ($14) {
        ;
        var $16 = $1;
        var $17 = $2;
        __Z14error_expectedP8LexStatei($16, $17);
        ;
      }
      else {
        ;
        var $19 = $1;
        var $20 = $1;
        var $21 = $20+40;
        var $22 = IHEAP[$21];
        var $23 = $1;
        var $24 = $2;
        var $25 = __Z14luaX_token2strP8LexStatei($23, $24);
        var $26 = $1;
        var $27 = $3;
        var $28 = __Z14luaX_token2strP8LexStatei($26, $27);
        var $29 = $4;
        var $30 = __Z16luaO_pushfstringP9lua_StatePKcz($22, __str25154, Pointer_make([$25,0,0,0,$28,0,0,0,$29,0,0,0], 0, ALLOC_STACK));
        __Z16luaX_syntaxerrorP8LexStatePKc($19, $30);
        ;
      }
      ;
    }
    ;
    return;
  }
  __Z11check_matchP8LexStateiii.__index__ = Runtime.getFunctionIndex(__Z11check_matchP8LexStateiii, "__Z11check_matchP8LexStateiii");
  
  
  function __Z7forstatP8LexStatei($ls, $line) {
    var __stackBase__  = STACKTOP; STACKTOP += 12; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $fs;
    var $varname;
    var $bl = __stackBase__;
    $1 = $ls;
    $2 = $line;
    var $3 = $1;
    var $4 = $3+36;
    var $5 = IHEAP[$4];
    $fs = $5;
    var $6 = $fs;
    __Z10enterblockP9FuncStateP8BlockCnth($6, $bl, 1);
    var $7 = $1;
    __Z9luaX_nextP8LexState($7);
    var $8 = $1;
    var $9 = __Z13str_checknameP8LexState($8);
    $varname = $9;
    var $10 = $1;
    var $11 = $10+12;
    var $12 = $11;
    var $13 = IHEAP[$12];
    if ($13 == 61) {
      __label__ = 1; /* $14 */ 
    }
    else if ($13 == 44) {
      __label__ = 2; /* $18 */ 
    }
    else if ($13 == 267) {
      __label__ = 2; /* $18 */ 
    }
    else {
    __label__ = 3; /* $21 */ 
    }
    
    if (__label__ == 3) {
      var $22 = $1;
      __Z16luaX_syntaxerrorP8LexStatePKc($22, __str18147);
      ;
    }
    else if (__label__ == 1) {
      var $15 = $1;
      var $16 = $varname;
      var $17 = $2;
      __Z6fornumP8LexStateP7TStringi($15, $16, $17);
      ;
    }
    else if (__label__ == 2) {
      var $19 = $1;
      var $20 = $varname;
      __Z7forlistP8LexStateP7TString($19, $20);
      ;
    }
    var $24 = $1;
    var $25 = $2;
    __Z11check_matchP8LexStateiii($24, 262, 264, $25);
    var $26 = $fs;
    __Z10leaveblockP9FuncState($26);
    STACKTOP = __stackBase__;
    return;
  }
  __Z7forstatP8LexStatei.__index__ = Runtime.getFunctionIndex(__Z7forstatP8LexStatei, "__Z7forstatP8LexStatei");
  
  
  function __Z10repeatstatP8LexStatei($ls, $line) {
    var __stackBase__  = STACKTOP; STACKTOP += 24; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $condexit;
    var $fs;
    var $repeat_init;
    var $bl1 = __stackBase__;
    var $bl2 = __stackBase__+12;
    $1 = $ls;
    $2 = $line;
    var $3 = $1;
    var $4 = $3+36;
    var $5 = IHEAP[$4];
    $fs = $5;
    var $6 = $fs;
    var $7 = __Z13luaK_getlabelP9FuncState($6);
    $repeat_init = $7;
    var $8 = $fs;
    __Z10enterblockP9FuncStateP8BlockCnth($8, $bl1, 1);
    var $9 = $fs;
    __Z10enterblockP9FuncStateP8BlockCnth($9, $bl2, 0);
    var $10 = $1;
    __Z9luaX_nextP8LexState($10);
    var $11 = $1;
    __Z5chunkP8LexState($11);
    var $12 = $1;
    var $13 = $2;
    __Z11check_matchP8LexStateiii($12, 276, 272, $13);
    var $14 = $1;
    var $15 = __Z4condP8LexState($14);
    $condexit = $15;
    var $16 = $bl2+9;
    var $17 = IHEAP[$16];
    var $18 = $17 != 0;
    ;
    if ($18) {
      ;
      var $27 = $1;
      __Z9breakstatP8LexState($27);
      var $28 = $1;
      var $29 = $28+36;
      var $30 = IHEAP[$29];
      var $31 = $condexit;
      __Z16luaK_patchtohereP9FuncStatei($30, $31);
      var $32 = $fs;
      __Z10leaveblockP9FuncState($32);
      var $33 = $1;
      var $34 = $33+36;
      var $35 = IHEAP[$34];
      var $36 = $fs;
      var $37 = __Z9luaK_jumpP9FuncState($36);
      var $38 = $repeat_init;
      __Z14luaK_patchlistP9FuncStateii($35, $37, $38);
      ;
    }
    else {
      ;
      var $20 = $fs;
      __Z10leaveblockP9FuncState($20);
      var $21 = $1;
      var $22 = $21+36;
      var $23 = IHEAP[$22];
      var $24 = $condexit;
      var $25 = $repeat_init;
      __Z14luaK_patchlistP9FuncStateii($23, $24, $25);
      ;
    }
    var $40 = $fs;
    __Z10leaveblockP9FuncState($40);
    STACKTOP = __stackBase__;
    return;
  }
  __Z10repeatstatP8LexStatei.__index__ = Runtime.getFunctionIndex(__Z10repeatstatP8LexStatei, "__Z10repeatstatP8LexStatei");
  
  
  function __Z8funcstatP8LexStatei($ls, $line) {
    var __stackBase__  = STACKTOP; STACKTOP += 40; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $needself;
    var $v = __stackBase__;
    var $b = __stackBase__+20;
    $1 = $ls;
    $2 = $line;
    var $3 = $1;
    __Z9luaX_nextP8LexState($3);
    var $4 = $1;
    var $5 = __Z8funcnameP8LexStateP7expdesc($4, $v);
    $needself = $5;
    var $6 = $1;
    var $7 = $needself;
    var $8 = $2;
    __Z4bodyP8LexStateP7expdescii($6, $b, $7, $8);
    var $9 = $1;
    var $10 = $9+36;
    var $11 = IHEAP[$10];
    __Z13luaK_storevarP9FuncStateP7expdescS2_($11, $v, $b);
    var $12 = $1;
    var $13 = $12+36;
    var $14 = IHEAP[$13];
    var $15 = $2;
    __Z12luaK_fixlineP9FuncStatei($14, $15);
    STACKTOP = __stackBase__;
    return;
  }
  __Z8funcstatP8LexStatei.__index__ = Runtime.getFunctionIndex(__Z8funcstatP8LexStatei, "__Z8funcstatP8LexStatei");
  
  
  function __Z9localfuncP8LexState($ls) {
    var __stackBase__  = STACKTOP; STACKTOP += 40; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $v = __stackBase__;
    var $b = __stackBase__+20;
    var $fs;
    $1 = $ls;
    var $2 = $1;
    var $3 = $2+36;
    var $4 = IHEAP[$3];
    $fs = $4;
    var $5 = $1;
    var $6 = $1;
    var $7 = __Z13str_checknameP8LexState($6);
    __Z12new_localvarP8LexStateP7TStringi($5, $7, 0);
    var $8 = $fs;
    var $9 = $8+36;
    var $10 = IHEAP[$9];
    __Z8init_expP7expdesc7expkindi($v, 6, $10);
    var $11 = $fs;
    __Z16luaK_reserveregsP9FuncStatei($11, 1);
    var $12 = $1;
    __Z15adjustlocalvarsP8LexStatei($12, 1);
    var $13 = $1;
    var $14 = $1;
    var $15 = $14+4;
    var $16 = IHEAP[$15];
    __Z4bodyP8LexStateP7expdescii($13, $b, 0, $16);
    var $17 = $fs;
    __Z13luaK_storevarP9FuncStateP7expdescS2_($17, $v, $b);
    var $18 = $fs;
    var $19 = $18+24;
    var $20 = IHEAP[$19];
    var $21 = $fs;
    var $22 = $21+50;
    var $23 = IHEAP[$22];
    var $24 = $23;
    var $25 = $24 - 1;
    var $26 = $fs;
    var $27 = $26+172;
    var $28 = $27+$25*2;
    var $29 = IHEAP[$28];
    var $30 = $29;
    var $31 = $fs;
    var $32 = $31;
    var $33 = IHEAP[$32];
    var $34 = $33+24;
    var $35 = IHEAP[$34];
    var $36 = $35+12*$30;
    var $37 = $36+4;
    IHEAP[$37] = $20;
    STACKTOP = __stackBase__;
    return;
  }
  __Z9localfuncP8LexState.__index__ = Runtime.getFunctionIndex(__Z9localfuncP8LexState, "__Z9localfuncP8LexState");
  
  
  function __Z9localstatP8LexState($ls) {
    var __stackBase__  = STACKTOP; STACKTOP += 20; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $nvars;
    var $nexps;
    var $e = __stackBase__;
    $1 = $ls;
    $nvars = 0;
    ;
    $2$2: while(1) { // $2
      var $3 = $1;
      var $4 = $1;
      var $5 = __Z13str_checknameP8LexState($4);
      var $6 = $nvars;
      var $7 = $6 + 1;
      $nvars = $7;
      __Z12new_localvarP8LexStateP7TStringi($3, $5, $6);
      ;
      var $9 = $1;
      var $10 = __Z8testnextP8LexStatei($9, 44);
      var $11 = $10 != 0;
      if ($11) { __label__ = 0; /* $2 */ continue $2$2; } else { __label__ = 2; /* $12 */ break $2$2; }
    }
    var $13 = $1;
    var $14 = __Z8testnextP8LexStatei($13, 61);
    var $15 = $14 != 0;
    ;
    if ($15) {
      ;
      var $17 = $1;
      var $18 = __Z8explist1P8LexStateP7expdesc($17, $e);
      $nexps = $18;
      ;
    }
    else {
      ;
      var $20 = $e;
      IHEAP[$20] = 0;
      $nexps = 0;
      ;
    }
    var $22 = $1;
    var $23 = $nvars;
    var $24 = $nexps;
    __Z13adjust_assignP8LexStateiiP7expdesc($22, $23, $24, $e);
    var $25 = $1;
    var $26 = $nvars;
    __Z15adjustlocalvarsP8LexStatei($25, $26);
    STACKTOP = __stackBase__;
    return;
  }
  __Z9localstatP8LexState.__index__ = Runtime.getFunctionIndex(__Z9localstatP8LexState, "__Z9localstatP8LexState");
  
  
  function __Z7retstatP8LexState($ls) {
    var __stackBase__  = STACKTOP; STACKTOP += 20; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $fs;
    var $e = __stackBase__;
    var $first;
    var $nret;
    $1 = $ls;
    var $2 = $1;
    var $3 = $2+36;
    var $4 = IHEAP[$3];
    $fs = $4;
    var $5 = $1;
    __Z9luaX_nextP8LexState($5);
    var $6 = $1;
    var $7 = $6+12;
    var $8 = $7;
    var $9 = IHEAP[$8];
    var $10 = __Z12block_followi($9);
    var $11 = $10 != 0;
    ;
    $18$12$2: do { 
      if ($11) {
        __label__ = 0; /* $18 */ 
      }
      else {
        ;
        var $13 = $1;
        var $14 = $13+12;
        var $15 = $14;
        var $16 = IHEAP[$15];
        var $17 = $16 == 59;
        if ($17) { __label__ = 0; /* $18 */ break $18$12$2; }
        var $20 = $1;
        var $21 = __Z8explist1P8LexStateP7expdesc($20, $e);
        $nret = $21;
        var $22 = $e;
        var $23 = IHEAP[$22];
        var $24 = $23 == 13;
        ;
        $29$25$5: do { 
          if ($24) {
            __label__ = 3; /* $29 */ 
          }
          else {
            ;
            var $26 = $e;
            var $27 = IHEAP[$26];
            var $28 = $27 == 14;
            if ($28) { __label__ = 3; /* $29 */ break $29$25$5; }
            var $67 = $nret;
            var $68 = $67 == 1;
            ;
            if ($68) {
              ;
              var $70 = $fs;
              var $71 = __Z15luaK_exp2anyregP9FuncStateP7expdesc($70, $e);
              $first = $71;
              ;
            }
            else {
              ;
              var $73 = $fs;
              __Z16luaK_exp2nextregP9FuncStateP7expdesc($73, $e);
              var $74 = $fs;
              var $75 = $74+50;
              var $76 = IHEAP[$75];
              var $77 = $76;
              $first = $77;
              ;
            }
            __label__ = 10; /* $79 */ break $29$25$5;
          }
        } while(0);
        if (__label__ == 3) {
          var $30 = $fs;
          __Z15luaK_setreturnsP9FuncStateP7expdesci($30, $e, -1);
          var $31 = $e;
          var $32 = IHEAP[$31];
          var $33 = $32 == 13;
          ;
          $34$61$14: do { 
            if ($33) {
              ;
              var $35 = $nret;
              var $36 = $35 == 1;
              if (!($36)) { __label__ = 6; /* $61 */ break $34$61$14; }
              var $38 = $e+4;
              var $39 = $38;
              var $40 = $39;
              var $41 = IHEAP[$40];
              var $42 = $fs;
              var $43 = $42;
              var $44 = IHEAP[$43];
              var $45 = $44+12;
              var $46 = IHEAP[$45];
              var $47 = $46+4*$41;
              var $48 = IHEAP[$47];
              var $49 = $48 & -64;
              var $50 = $49 | 29;
              var $51 = $e+4;
              var $52 = $51;
              var $53 = $52;
              var $54 = IHEAP[$53];
              var $55 = $fs;
              var $56 = $55;
              var $57 = IHEAP[$56];
              var $58 = $57+12;
              var $59 = IHEAP[$58];
              var $60 = $59+4*$54;
              IHEAP[$60] = $50;
              ;
            }
          } while(0);
          var $62 = $fs;
          var $63 = $62+50;
          var $64 = IHEAP[$63];
          var $65 = $64;
          $first = $65;
          $nret = -1;
          ;
        }
        __label__ = 11; /* $80 */ break $18$12$2;
      }
    } while(0);
    if (__label__ == 0) {
      $nret = 0;
      $first = 0;
      ;
    }
    var $81 = $fs;
    var $82 = $first;
    var $83 = $nret;
    __Z8luaK_retP9FuncStateii($81, $82, $83);
    STACKTOP = __stackBase__;
    return;
  }
  __Z7retstatP8LexState.__index__ = Runtime.getFunctionIndex(__Z7retstatP8LexState, "__Z7retstatP8LexState");
  
  
  function __Z9breakstatP8LexState($ls) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $fs;
    var $bl;
    var $upval;
    $1 = $ls;
    var $2 = $1;
    var $3 = $2+36;
    var $4 = IHEAP[$3];
    $fs = $4;
    var $5 = $fs;
    var $6 = $5+20;
    var $7 = IHEAP[$6];
    $bl = $7;
    $upval = 0;
    ;
    $8$2: while(1) { // $8
      var $9 = $bl;
      var $10 = $9 != 0;
      ;
      if ($10) {
        __lastLabel__ = 0; ;
        var $12 = $bl;
        var $13 = $12+10;
        var $14 = IHEAP[$13];
        var $15 = $14 != 0;
        var $16 = $15 ^ 1;
        __lastLabel__ = 1; ;
      }
      else {
        __lastLabel__ = 0; ;
      }
      var $18 = __lastLabel__ == 0 ? 0 : ($16);
      if (!($18)) { __label__ = 4; /* $29 */ break $8$2; }
      var $20 = $bl;
      var $21 = $20+9;
      var $22 = IHEAP[$21];
      var $23 = $22;
      var $24 = $upval;
      var $25 = $24 | $23;
      $upval = $25;
      var $26 = $bl;
      var $27 = $26;
      var $28 = IHEAP[$27];
      $bl = $28;
      __label__ = 0; /* $8 */ continue $8$2;
    }
    var $30 = $bl;
    var $31 = $30 != 0;
    ;
    if (!$31) {
      ;
      var $33 = $1;
      __Z16luaX_syntaxerrorP8LexStatePKc($33, __str17146);
      ;
    }
    var $35 = $upval;
    var $36 = $35 != 0;
    ;
    if ($36) {
      ;
      var $38 = $fs;
      var $39 = $bl;
      var $40 = $39+8;
      var $41 = IHEAP[$40];
      var $42 = $41;
      var $43 = __Z12luaK_codeABCP9FuncState6OpCodeiii($38, 35, $42, 0, 0);
      ;
    }
    var $45 = $fs;
    var $46 = $bl;
    var $47 = $46+4;
    var $48 = $fs;
    var $49 = __Z9luaK_jumpP9FuncState($48);
    __Z11luaK_concatP9FuncStatePii($45, $47, $49);
    ;
    return;
  }
  __Z9breakstatP8LexState.__index__ = Runtime.getFunctionIndex(__Z9breakstatP8LexState, "__Z9breakstatP8LexState");
  
  
  function __Z8exprstatP8LexState($ls) {
    var __stackBase__  = STACKTOP; STACKTOP += 24; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $fs;
    var $v = __stackBase__;
    $1 = $ls;
    var $2 = $1;
    var $3 = $2+36;
    var $4 = IHEAP[$3];
    $fs = $4;
    var $5 = $1;
    var $6 = $v+4;
    __Z10primaryexpP8LexStateP7expdesc($5, $6);
    var $7 = $v+4;
    var $8 = $7;
    var $9 = IHEAP[$8];
    var $10 = $9 == 13;
    ;
    if ($10) {
      ;
      var $12 = $v+4;
      var $13 = $12+4;
      var $14 = $13;
      var $15 = $14;
      var $16 = IHEAP[$15];
      var $17 = $fs;
      var $18 = $17;
      var $19 = IHEAP[$18];
      var $20 = $19+12;
      var $21 = IHEAP[$20];
      var $22 = $21+4*$16;
      var $23 = IHEAP[$22];
      var $24 = $23 & -8372225;
      var $25 = $24 | 16384;
      var $26 = $v+4;
      var $27 = $26+4;
      var $28 = $27;
      var $29 = $28;
      var $30 = IHEAP[$29];
      var $31 = $fs;
      var $32 = $31;
      var $33 = IHEAP[$32];
      var $34 = $33+12;
      var $35 = IHEAP[$34];
      var $36 = $35+4*$30;
      IHEAP[$36] = $25;
      ;
    }
    else {
      ;
      var $38 = $v;
      IHEAP[$38] = 0;
      var $39 = $1;
      __Z10assignmentP8LexStateP10LHS_assigni($39, $v, 1);
      ;
    }
    STACKTOP = __stackBase__;
    return;
  }
  __Z8exprstatP8LexState.__index__ = Runtime.getFunctionIndex(__Z8exprstatP8LexState, "__Z8exprstatP8LexState");
  
  
  function __Z10primaryexpP8LexStateP7expdesc($ls, $v) {
    var __stackBase__  = STACKTOP; STACKTOP += 40; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $fs;
    var $key = __stackBase__;
    var $key1 = __stackBase__+20;
    $1 = $ls;
    $2 = $v;
    var $3 = $1;
    var $4 = $3+36;
    var $5 = IHEAP[$4];
    $fs = $5;
    var $6 = $1;
    var $7 = $2;
    __Z9prefixexpP8LexStateP7expdesc($6, $7);
    ;
    $8$2: while(1) { // $8
      var $9 = $1;
      var $10 = $9+12;
      var $11 = $10;
      var $12 = IHEAP[$11];
      if ($12 == 46) {
        __label__ = 2; /* $13 */ 
      }
      else if ($12 == 91) {
        __label__ = 3; /* $16 */ 
      }
      else if ($12 == 58) {
        __label__ = 4; /* $23 */ 
      }
      else if ($12 == 40) {
        __label__ = 5; /* $30 */ 
      }
      else if ($12 == 286) {
        __label__ = 5; /* $30 */ 
      }
      else if ($12 == 123) {
        __label__ = 5; /* $30 */ 
      }
      else {
      __label__ = 6; /* $35 */ break $8$2;
      }
      
      if (__label__ == 2) {
        var $14 = $1;
        var $15 = $2;
        __Z5fieldP8LexStateP7expdesc($14, $15);
        ;
      }
      else if (__label__ == 3) {
        var $17 = $fs;
        var $18 = $2;
        var $19 = __Z15luaK_exp2anyregP9FuncStateP7expdesc($17, $18);
        var $20 = $1;
        __Z6yindexP8LexStateP7expdesc($20, $key);
        var $21 = $fs;
        var $22 = $2;
        __Z12luaK_indexedP9FuncStateP7expdescS2_($21, $22, $key);
        ;
      }
      else if (__label__ == 4) {
        var $24 = $1;
        __Z9luaX_nextP8LexState($24);
        var $25 = $1;
        __Z9checknameP8LexStateP7expdesc($25, $key1);
        var $26 = $fs;
        var $27 = $2;
        __Z9luaK_selfP9FuncStateP7expdescS2_($26, $27, $key1);
        var $28 = $1;
        var $29 = $2;
        __Z8funcargsP8LexStateP7expdesc($28, $29);
        ;
      }
      else if (__label__ == 5) {
        var $31 = $fs;
        var $32 = $2;
        __Z16luaK_exp2nextregP9FuncStateP7expdesc($31, $32);
        var $33 = $1;
        var $34 = $2;
        __Z8funcargsP8LexStateP7expdesc($33, $34);
        ;
      }
      __label__ = 0; /* $8 */ continue $8$2;
    }
    STACKTOP = __stackBase__;
    return;
  }
  __Z10primaryexpP8LexStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z10primaryexpP8LexStateP7expdesc, "__Z10primaryexpP8LexStateP7expdesc");
  
  
  function __Z10assignmentP8LexStateP10LHS_assigni($ls, $lh, $nvars) {
    var __stackBase__  = STACKTOP; STACKTOP += 44; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $e = __stackBase__;
    var $nv = __stackBase__+20;
    var $nexps;
    $1 = $ls;
    $2 = $lh;
    $3 = $nvars;
    var $4 = $2;
    var $5 = $4+4;
    var $6 = $5;
    var $7 = IHEAP[$6];
    var $8 = 6 <= $7;
    ;
    $9$15$2: do { 
      if ($8) {
        ;
        var $10 = $2;
        var $11 = $10+4;
        var $12 = $11;
        var $13 = IHEAP[$12];
        var $14 = $13 <= 9;
        if ($14) { __label__ = 0; /* $17 */ break $9$15$2; } else { __label__ = 1; /* $15 */ break $9$15$2; }
      }
      else {
        __label__ = 1; /* $15 */ 
      }
    } while(0);
    if (__label__ == 1) {
      var $16 = $1;
      __Z16luaX_syntaxerrorP8LexStatePKc($16, __str12957);
      ;
    }
    var $18 = $1;
    var $19 = __Z8testnextP8LexStatei($18, 44);
    var $20 = $19 != 0;
    ;
    $21$59$7: do { 
      if ($20) {
        ;
        var $22 = $2;
        var $23 = $nv;
        IHEAP[$23] = $22;
        var $24 = $1;
        var $25 = $nv+4;
        __Z10primaryexpP8LexStateP7expdesc($24, $25);
        var $26 = $nv+4;
        var $27 = $26;
        var $28 = IHEAP[$27];
        var $29 = $28 == 6;
        ;
        if ($29) {
          ;
          var $31 = $1;
          var $32 = $2;
          var $33 = $nv+4;
          __Z14check_conflictP8LexStateP10LHS_assignP7expdesc($31, $32, $33);
          ;
        }
        var $35 = $3;
        var $36 = $1;
        var $37 = $36+40;
        var $38 = IHEAP[$37];
        var $39 = $38+52;
        var $40 = IHEAP[$39];
        var $41 = $40;
        var $42 = 200 - $41;
        var $43 = $35 > $42;
        ;
        if ($43) {
          ;
          var $45 = $1;
          var $46 = $45+36;
          var $47 = IHEAP[$46];
          var $48 = $1;
          var $49 = $48+40;
          var $50 = IHEAP[$49];
          var $51 = $50+52;
          var $52 = IHEAP[$51];
          var $53 = $52;
          var $54 = 200 - $53;
          __Z10errorlimitP9FuncStateiPKc($47, $54, __str1130);
          ;
        }
        var $56 = $1;
        var $57 = $3;
        var $58 = $57 + 1;
        __Z10assignmentP8LexStateP10LHS_assigni($56, $nv, $58);
        __label__ = 5; /* $94 */ break $21$59$7;
      }
      else {
        ;
        var $60 = $1;
        __Z9checknextP8LexStatei($60, 61);
        var $61 = $1;
        var $62 = __Z8explist1P8LexStateP7expdesc($61, $e);
        $nexps = $62;
        var $63 = $nexps;
        var $64 = $3;
        var $65 = $63 != $64;
        ;
        if ($65) {
          ;
          var $67 = $1;
          var $68 = $3;
          var $69 = $nexps;
          __Z13adjust_assignP8LexStateiiP7expdesc($67, $68, $69, $e);
          var $70 = $nexps;
          var $71 = $3;
          var $72 = $70 > $71;
          ;
          if ($72) {
            ;
            var $74 = $nexps;
            var $75 = $3;
            var $76 = $74 - $75;
            var $77 = $1;
            var $78 = $77+36;
            var $79 = IHEAP[$78];
            var $80 = $79+36;
            var $81 = IHEAP[$80];
            var $82 = $81 - $76;
            IHEAP[$80] = $82;
            ;
          }
          ;
          __label__ = 5; /* $94 */ break $21$59$7;
        }
        else {
          ;
          var $85 = $1;
          var $86 = $85+36;
          var $87 = IHEAP[$86];
          __Z14luaK_setoneretP9FuncStateP7expdesc($87, $e);
          var $88 = $1;
          var $89 = $88+36;
          var $90 = IHEAP[$89];
          var $91 = $2;
          var $92 = $91+4;
          __Z13luaK_storevarP9FuncStateP7expdescS2_($90, $92, $e);
          __label__ = 8; /* $106 */ break $21$59$7;
        }
      }
    } while(0);
    if (__label__ == 5) {
      var $95 = $1;
      var $96 = $95+36;
      var $97 = IHEAP[$96];
      var $98 = $97+36;
      var $99 = IHEAP[$98];
      var $100 = $99 - 1;
      __Z8init_expP7expdesc7expkindi($e, 12, $100);
      var $101 = $1;
      var $102 = $101+36;
      var $103 = IHEAP[$102];
      var $104 = $2;
      var $105 = $104+4;
      __Z13luaK_storevarP9FuncStateP7expdescS2_($103, $105, $e);
      ;
    }
    STACKTOP = __stackBase__;
    return;
  }
  __Z10assignmentP8LexStateP10LHS_assigni.__index__ = Runtime.getFunctionIndex(__Z10assignmentP8LexStateP10LHS_assigni, "__Z10assignmentP8LexStateP10LHS_assigni");
  
  
  function __Z14check_conflictP8LexStateP10LHS_assignP7expdesc($ls, $lh, $v) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $fs;
    var $extra;
    var $conflict;
    $1 = $ls;
    $2 = $lh;
    $3 = $v;
    var $4 = $1;
    var $5 = $4+36;
    var $6 = IHEAP[$5];
    $fs = $6;
    var $7 = $fs;
    var $8 = $7+36;
    var $9 = IHEAP[$8];
    $extra = $9;
    $conflict = 0;
    ;
    $10$2: while(1) { // $10
      var $11 = $2;
      var $12 = $11 != 0;
      if (!($12)) { __label__ = 2; /* $65 */ break $10$2; }
      var $14 = $2;
      var $15 = $14+4;
      var $16 = $15;
      var $17 = IHEAP[$16];
      var $18 = $17 == 9;
      ;
      if ($18) {
        ;
        var $20 = $2;
        var $21 = $20+4;
        var $22 = $21+4;
        var $23 = $22;
        var $24 = $23;
        var $25 = IHEAP[$24];
        var $26 = $3;
        var $27 = $26+4;
        var $28 = $27;
        var $29 = $28;
        var $30 = IHEAP[$29];
        var $31 = $25 == $30;
        ;
        if ($31) {
          ;
          $conflict = 1;
          var $33 = $extra;
          var $34 = $2;
          var $35 = $34+4;
          var $36 = $35+4;
          var $37 = $36;
          var $38 = $37;
          IHEAP[$38] = $33;
          ;
        }
        var $40 = $2;
        var $41 = $40+4;
        var $42 = $41+4;
        var $43 = $42;
        var $44 = $43+4;
        var $45 = IHEAP[$44];
        var $46 = $3;
        var $47 = $46+4;
        var $48 = $47;
        var $49 = $48;
        var $50 = IHEAP[$49];
        var $51 = $45 == $50;
        ;
        if ($51) {
          ;
          $conflict = 1;
          var $53 = $extra;
          var $54 = $2;
          var $55 = $54+4;
          var $56 = $55+4;
          var $57 = $56;
          var $58 = $57+4;
          IHEAP[$58] = $53;
          ;
        }
        ;
      }
      ;
      var $62 = $2;
      var $63 = $62;
      var $64 = IHEAP[$63];
      $2 = $64;
      __label__ = 0; /* $10 */ continue $10$2;
    }
    var $66 = $conflict;
    var $67 = $66 != 0;
    ;
    if ($67) {
      ;
      var $69 = $fs;
      var $70 = $fs;
      var $71 = $70+36;
      var $72 = IHEAP[$71];
      var $73 = $3;
      var $74 = $73+4;
      var $75 = $74;
      var $76 = $75;
      var $77 = IHEAP[$76];
      var $78 = __Z12luaK_codeABCP9FuncState6OpCodeiii($69, 0, $72, $77, 0);
      var $79 = $fs;
      __Z16luaK_reserveregsP9FuncStatei($79, 1);
      ;
    }
    ;
    return;
  }
  __Z14check_conflictP8LexStateP10LHS_assignP7expdesc.__index__ = Runtime.getFunctionIndex(__Z14check_conflictP8LexStateP10LHS_assignP7expdesc, "__Z14check_conflictP8LexStateP10LHS_assignP7expdesc");
  
  
  function __Z10errorlimitP9FuncStateiPKc($fs, $limit, $what) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $msg;
    $1 = $fs;
    $2 = $limit;
    $3 = $what;
    var $4 = $1;
    var $5 = $4;
    var $6 = IHEAP[$5];
    var $7 = $6+60;
    var $8 = IHEAP[$7];
    var $9 = $8 == 0;
    ;
    if ($9) {
      ;
      var $11 = $1;
      var $12 = $11+16;
      var $13 = IHEAP[$12];
      var $14 = $2;
      var $15 = $3;
      var $16 = __Z16luaO_pushfstringP9lua_StatePKcz($13, __str10139, Pointer_make([$14,0,0,0,$15,0,0,0], 0, ALLOC_STACK));
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $18 = $1;
      var $19 = $18+16;
      var $20 = IHEAP[$19];
      var $21 = $1;
      var $22 = $21;
      var $23 = IHEAP[$22];
      var $24 = $23+60;
      var $25 = IHEAP[$24];
      var $26 = $2;
      var $27 = $3;
      var $28 = __Z16luaO_pushfstringP9lua_StatePKcz($20, __str11140, Pointer_make([$25,0,0,0,$26,0,0,0,$27,0,0,0], 0, ALLOC_STACK));
      __lastLabel__ = 2; ;
    }
    var $30 = __lastLabel__ == 0 ? $16 : ($28);
    $msg = $30;
    var $31 = $1;
    var $32 = $31+12;
    var $33 = IHEAP[$32];
    var $34 = $msg;
    __Z13luaX_lexerrorP8LexStatePKci($33, $34, 0);
    ;
    return;
  }
  __Z10errorlimitP9FuncStateiPKc.__index__ = Runtime.getFunctionIndex(__Z10errorlimitP9FuncStateiPKc, "__Z10errorlimitP9FuncStateiPKc");
  
  
  function __Z9checknextP8LexStatei($ls, $c) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $ls;
    $2 = $c;
    var $3 = $1;
    var $4 = $2;
    __Z5checkP8LexStatei($3, $4);
    var $5 = $1;
    __Z9luaX_nextP8LexState($5);
    ;
    return;
  }
  __Z9checknextP8LexStatei.__index__ = Runtime.getFunctionIndex(__Z9checknextP8LexStatei, "__Z9checknextP8LexStatei");
  
  
  function __Z8explist1P8LexStateP7expdesc($ls, $v) {
    ;
    var __label__;
    var $1;
    var $2;
    var $n;
    $1 = $ls;
    $2 = $v;
    $n = 1;
    var $3 = $1;
    var $4 = $2;
    __Z4exprP8LexStateP7expdesc($3, $4);
    ;
    $5$2: while(1) { // $5
      var $6 = $1;
      var $7 = __Z8testnextP8LexStatei($6, 44);
      var $8 = $7 != 0;
      if (!($8)) { __label__ = 2; /* $18 */ break $5$2; }
      var $10 = $1;
      var $11 = $10+36;
      var $12 = IHEAP[$11];
      var $13 = $2;
      __Z16luaK_exp2nextregP9FuncStateP7expdesc($12, $13);
      var $14 = $1;
      var $15 = $2;
      __Z4exprP8LexStateP7expdesc($14, $15);
      var $16 = $n;
      var $17 = $16 + 1;
      $n = $17;
      __label__ = 0; /* $5 */ continue $5$2;
    }
    var $19 = $n;
    ;
    return $19;
  }
  __Z8explist1P8LexStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z8explist1P8LexStateP7expdesc, "__Z8explist1P8LexStateP7expdesc");
  
  
  function __Z13adjust_assignP8LexStateiiP7expdesc($ls, $nvars, $nexps, $e) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $fs;
    var $extra;
    var $reg;
    $1 = $ls;
    $2 = $nvars;
    $3 = $nexps;
    $4 = $e;
    var $5 = $1;
    var $6 = $5+36;
    var $7 = IHEAP[$6];
    $fs = $7;
    var $8 = $2;
    var $9 = $3;
    var $10 = $8 - $9;
    $extra = $10;
    var $11 = $4;
    var $12 = $11;
    var $13 = IHEAP[$12];
    var $14 = $13 == 13;
    ;
    $20$15$2: do { 
      if ($14) {
        __label__ = 0; /* $20 */ 
      }
      else {
        ;
        var $16 = $4;
        var $17 = $16;
        var $18 = IHEAP[$17];
        var $19 = $18 == 14;
        if ($19) { __label__ = 0; /* $20 */ break $20$15$2; }
        var $38 = $4;
        var $39 = $38;
        var $40 = IHEAP[$39];
        var $41 = $40 != 0;
        ;
        if ($41) {
          ;
          var $43 = $fs;
          var $44 = $4;
          __Z16luaK_exp2nextregP9FuncStateP7expdesc($43, $44);
          ;
        }
        var $46 = $extra;
        var $47 = $46 > 0;
        ;
        if ($47) {
          ;
          var $49 = $fs;
          var $50 = $49+36;
          var $51 = IHEAP[$50];
          $reg = $51;
          var $52 = $fs;
          var $53 = $extra;
          __Z16luaK_reserveregsP9FuncStatei($52, $53);
          var $54 = $fs;
          var $55 = $reg;
          var $56 = $extra;
          __Z8luaK_nilP9FuncStateii($54, $55, $56);
          ;
        }
        __label__ = 7; /* $58 */ break $20$15$2;
      }
    } while(0);
    if (__label__ == 0) {
      var $21 = $extra;
      var $22 = $21 + 1;
      $extra = $22;
      var $23 = $extra;
      var $24 = $23 < 0;
      ;
      if ($24) {
        ;
        $extra = 0;
        ;
      }
      var $27 = $fs;
      var $28 = $4;
      var $29 = $extra;
      __Z15luaK_setreturnsP9FuncStateP7expdesci($27, $28, $29);
      var $30 = $extra;
      var $31 = $30 > 1;
      ;
      if ($31) {
        ;
        var $33 = $fs;
        var $34 = $extra;
        var $35 = $34 - 1;
        __Z16luaK_reserveregsP9FuncStatei($33, $35);
        ;
      }
      ;
    }
    ;
    return;
  }
  __Z13adjust_assignP8LexStateiiP7expdesc.__index__ = Runtime.getFunctionIndex(__Z13adjust_assignP8LexStateiiP7expdesc, "__Z13adjust_assignP8LexStateiiP7expdesc");
  
  
  function __Z8init_expP7expdesc7expkindi($e, $k, $i) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    $1 = $e;
    $2 = $k;
    $3 = $i;
    var $4 = $1;
    var $5 = $4+12;
    IHEAP[$5] = -1;
    var $6 = $1;
    var $7 = $6+16;
    IHEAP[$7] = -1;
    var $8 = $2;
    var $9 = $1;
    var $10 = $9;
    IHEAP[$10] = $8;
    var $11 = $3;
    var $12 = $1;
    var $13 = $12+4;
    var $14 = $13;
    var $15 = $14;
    IHEAP[$15] = $11;
    ;
    return;
  }
  __Z8init_expP7expdesc7expkindi.__index__ = Runtime.getFunctionIndex(__Z8init_expP7expdesc7expkindi, "__Z8init_expP7expdesc7expkindi");
  
  
  function __Z4exprP8LexStateP7expdesc($ls, $v) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $ls;
    $2 = $v;
    var $3 = $1;
    var $4 = $2;
    var $5 = __Z7subexprP8LexStateP7expdescj($3, $4, 0);
    ;
    return;
  }
  __Z4exprP8LexStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z4exprP8LexStateP7expdesc, "__Z4exprP8LexStateP7expdesc");
  
  
  function __Z7subexprP8LexStateP7expdescj($ls, $v, $limit) {
    var __stackBase__  = STACKTOP; STACKTOP += 20; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $op;
    var $uop;
    var $v2 = __stackBase__;
    var $nextop;
    $1 = $ls;
    $2 = $v;
    $3 = $limit;
    var $4 = $1;
    __Z10enterlevelP8LexState($4);
    var $5 = $1;
    var $6 = $5+12;
    var $7 = $6;
    var $8 = IHEAP[$7];
    var $9 = __Z8getunopri($8);
    $uop = $9;
    var $10 = $uop;
    var $11 = $10 != 3;
    ;
    if ($11) {
      ;
      var $13 = $1;
      __Z9luaX_nextP8LexState($13);
      var $14 = $1;
      var $15 = $2;
      var $16 = __Z7subexprP8LexStateP7expdescj($14, $15, 8);
      var $17 = $1;
      var $18 = $17+36;
      var $19 = IHEAP[$18];
      var $20 = $uop;
      var $21 = $2;
      __Z11luaK_prefixP9FuncState5UnOprP7expdesc($19, $20, $21);
      ;
    }
    else {
      ;
      var $23 = $1;
      var $24 = $2;
      __Z9simpleexpP8LexStateP7expdesc($23, $24);
      ;
    }
    var $26 = $1;
    var $27 = $26+12;
    var $28 = $27;
    var $29 = IHEAP[$28];
    var $30 = __Z9getbinopri($29);
    $op = $30;
    ;
    $31$6: while(1) { // $31
      var $32 = $op;
      var $33 = $32 != 15;
      ;
      if ($33) {
        __lastLabel__ = 1; ;
        var $35 = $op;
        var $36 = __ZL8priority+$35*2;
        var $37 = $36;
        var $38 = IHEAP[$37];
        var $39 = $38;
        var $40 = $3;
        var $41 = unSign($39, 32) > unSign($40, 32);
        __lastLabel__ = 2; ;
      }
      else {
        __lastLabel__ = 1; ;
      }
      var $43 = __lastLabel__ == 1 ? 0 : ($41);
      if (!($43)) { __label__ = 5; /* $64 */ break $31$6; }
      var $45 = $1;
      __Z9luaX_nextP8LexState($45);
      var $46 = $1;
      var $47 = $46+36;
      var $48 = IHEAP[$47];
      var $49 = $op;
      var $50 = $2;
      __Z10luaK_infixP9FuncState6BinOprP7expdesc($48, $49, $50);
      var $51 = $1;
      var $52 = $op;
      var $53 = __ZL8priority+$52*2;
      var $54 = $53+1;
      var $55 = IHEAP[$54];
      var $56 = $55;
      var $57 = __Z7subexprP8LexStateP7expdescj($51, $v2, $56);
      $nextop = $57;
      var $58 = $1;
      var $59 = $58+36;
      var $60 = IHEAP[$59];
      var $61 = $op;
      var $62 = $2;
      __Z11luaK_posfixP9FuncState6BinOprP7expdescS3_($60, $61, $62, $v2);
      var $63 = $nextop;
      $op = $63;
      __label__ = 1; /* $31 */ continue $31$6;
    }
    var $65 = $1;
    var $66 = $65+40;
    var $67 = IHEAP[$66];
    var $68 = $67+52;
    var $69 = IHEAP[$68];
    var $70 = $69 + -1;
    IHEAP[$68] = $70;
    var $71 = $op;
    STACKTOP = __stackBase__;
    return $71;
  }
  __Z7subexprP8LexStateP7expdescj.__index__ = Runtime.getFunctionIndex(__Z7subexprP8LexStateP7expdescj, "__Z7subexprP8LexStateP7expdescj");
  
  
  function __Z8getunopri($op) {
    ;
    var __label__;
    var $1;
    var $2;
    $2 = $op;
    var $3 = $2;
    if ($3 == 270) {
      __label__ = 1; /* $4 */ 
    }
    else if ($3 == 45) {
      __label__ = 2; /* $5 */ 
    }
    else if ($3 == 35) {
      __label__ = 3; /* $6 */ 
    }
    else {
    __label__ = 4; /* $7 */ 
    }
    
    if (__label__ == 4) {
      $1 = 3;
      ;
    }
    else if (__label__ == 1) {
      $1 = 1;
      ;
    }
    else if (__label__ == 2) {
      $1 = 0;
      ;
    }
    else if (__label__ == 3) {
      $1 = 2;
      ;
    }
    var $9 = $1;
    ;
    return $9;
  }
  __Z8getunopri.__index__ = Runtime.getFunctionIndex(__Z8getunopri, "__Z8getunopri");
  
  
  function __Z9simpleexpP8LexStateP7expdesc($ls, $v) {
    ;
    var __label__;
    var $1;
    var $2;
    var $fs;
    $1 = $ls;
    $2 = $v;
    var $3 = $1;
    var $4 = $3+12;
    var $5 = $4;
    var $6 = IHEAP[$5];
    if ($6 == 284) {
      __label__ = 4; /* $7 */ 
    }
    else if ($6 == 286) {
      __label__ = 5; /* $18 */ 
    }
    else if ($6 == 269) {
      __label__ = 6; /* $27 */ 
    }
    else if ($6 == 275) {
      __label__ = 7; /* $29 */ 
    }
    else if ($6 == 263) {
      __label__ = 8; /* $31 */ 
    }
    else if ($6 == 279) {
      __label__ = 9; /* $33 */ 
    }
    else if ($6 == 123) {
      __label__ = 10; /* $57 */ 
    }
    else if ($6 == 265) {
      __label__ = 11; /* $60 */ 
    }
    else {
    __label__ = 12; /* $67 */ 
    }
    
    $67$7$18$27$29$31$33$57$60$2: do { 
      if (__label__ == 12) {
        var $68 = $1;
        var $69 = $2;
        __Z10primaryexpP8LexStateP7expdesc($68, $69);
        __label__ = 2; /* $72 */ break $67$7$18$27$29$31$33$57$60$2;
      }
      else if (__label__ == 4) {
        var $8 = $2;
        __Z8init_expP7expdesc7expkindi($8, 5, 0);
        var $9 = $1;
        var $10 = $9+12;
        var $11 = $10+4;
        var $12 = $11;
        var $13 = FHEAP[$12];
        var $14 = $2;
        var $15 = $14+4;
        var $16 = $15;
        var $17 = $16;
        FHEAP[$17] = $13;
        __label__ = 0; /* $70 */ break $67$7$18$27$29$31$33$57$60$2;
      }
      else if (__label__ == 5) {
        var $19 = $1;
        var $20 = $2;
        var $21 = $1;
        var $22 = $21+12;
        var $23 = $22+4;
        var $24 = $23;
        var $25 = $24;
        var $26 = IHEAP[$25];
        __Z10codestringP8LexStateP7expdescP7TString($19, $20, $26);
        __label__ = 0; /* $70 */ break $67$7$18$27$29$31$33$57$60$2;
      }
      else if (__label__ == 6) {
        var $28 = $2;
        __Z8init_expP7expdesc7expkindi($28, 1, 0);
        __label__ = 0; /* $70 */ break $67$7$18$27$29$31$33$57$60$2;
      }
      else if (__label__ == 7) {
        var $30 = $2;
        __Z8init_expP7expdesc7expkindi($30, 2, 0);
        __label__ = 0; /* $70 */ break $67$7$18$27$29$31$33$57$60$2;
      }
      else if (__label__ == 8) {
        var $32 = $2;
        __Z8init_expP7expdesc7expkindi($32, 3, 0);
        __label__ = 0; /* $70 */ break $67$7$18$27$29$31$33$57$60$2;
      }
      else if (__label__ == 9) {
        var $34 = $1;
        var $35 = $34+36;
        var $36 = IHEAP[$35];
        $fs = $36;
        var $37 = $fs;
        var $38 = $37;
        var $39 = IHEAP[$38];
        var $40 = $39+74;
        var $41 = IHEAP[$40];
        var $42 = $41 != 0;
        ;
        if (!$42) {
          ;
          var $44 = $1;
          __Z16luaX_syntaxerrorP8LexStatePKc($44, __str2131);
          ;
        }
        var $46 = $fs;
        var $47 = $46;
        var $48 = IHEAP[$47];
        var $49 = $48+74;
        var $50 = IHEAP[$49];
        var $51 = $50;
        var $52 = $51 & -5;
        var $53 = $52;
        IHEAP[$49] = $53;
        var $54 = $2;
        var $55 = $fs;
        var $56 = __Z12luaK_codeABCP9FuncState6OpCodeiii($55, 37, 0, 1, 0);
        __Z8init_expP7expdesc7expkindi($54, 14, $56);
        __label__ = 0; /* $70 */ break $67$7$18$27$29$31$33$57$60$2;
      }
      else if (__label__ == 10) {
        var $58 = $1;
        var $59 = $2;
        __Z11constructorP8LexStateP7expdesc($58, $59);
        __label__ = 2; /* $72 */ break $67$7$18$27$29$31$33$57$60$2;
      }
      else if (__label__ == 11) {
        var $61 = $1;
        __Z9luaX_nextP8LexState($61);
        var $62 = $1;
        var $63 = $2;
        var $64 = $1;
        var $65 = $64+4;
        var $66 = IHEAP[$65];
        __Z4bodyP8LexStateP7expdescii($62, $63, 0, $66);
        __label__ = 2; /* $72 */ break $67$7$18$27$29$31$33$57$60$2;
      }
    } while(0);
    if (__label__ == 0) {
      var $71 = $1;
      __Z9luaX_nextP8LexState($71);
      ;
    }
    ;
    return;
  }
  __Z9simpleexpP8LexStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z9simpleexpP8LexStateP7expdesc, "__Z9simpleexpP8LexStateP7expdesc");
  
  
  function __Z9getbinopri($op) {
    ;
    var __label__;
    var $1;
    var $2;
    $2 = $op;
    var $3 = $2;
    if ($3 == 43) {
      __label__ = 1; /* $4 */ 
    }
    else if ($3 == 45) {
      __label__ = 2; /* $5 */ 
    }
    else if ($3 == 42) {
      __label__ = 3; /* $6 */ 
    }
    else if ($3 == 47) {
      __label__ = 4; /* $7 */ 
    }
    else if ($3 == 37) {
      __label__ = 5; /* $8 */ 
    }
    else if ($3 == 94) {
      __label__ = 6; /* $9 */ 
    }
    else if ($3 == 278) {
      __label__ = 7; /* $10 */ 
    }
    else if ($3 == 283) {
      __label__ = 8; /* $11 */ 
    }
    else if ($3 == 280) {
      __label__ = 9; /* $12 */ 
    }
    else if ($3 == 60) {
      __label__ = 10; /* $13 */ 
    }
    else if ($3 == 282) {
      __label__ = 11; /* $14 */ 
    }
    else if ($3 == 62) {
      __label__ = 12; /* $15 */ 
    }
    else if ($3 == 281) {
      __label__ = 13; /* $16 */ 
    }
    else if ($3 == 257) {
      __label__ = 14; /* $17 */ 
    }
    else if ($3 == 271) {
      __label__ = 15; /* $18 */ 
    }
    else {
    __label__ = 16; /* $19 */ 
    }
    
    if (__label__ == 16) {
      $1 = 15;
      ;
    }
    else if (__label__ == 1) {
      $1 = 0;
      ;
    }
    else if (__label__ == 2) {
      $1 = 1;
      ;
    }
    else if (__label__ == 3) {
      $1 = 2;
      ;
    }
    else if (__label__ == 4) {
      $1 = 3;
      ;
    }
    else if (__label__ == 5) {
      $1 = 4;
      ;
    }
    else if (__label__ == 6) {
      $1 = 5;
      ;
    }
    else if (__label__ == 7) {
      $1 = 6;
      ;
    }
    else if (__label__ == 8) {
      $1 = 7;
      ;
    }
    else if (__label__ == 9) {
      $1 = 8;
      ;
    }
    else if (__label__ == 10) {
      $1 = 9;
      ;
    }
    else if (__label__ == 11) {
      $1 = 10;
      ;
    }
    else if (__label__ == 12) {
      $1 = 11;
      ;
    }
    else if (__label__ == 13) {
      $1 = 12;
      ;
    }
    else if (__label__ == 14) {
      $1 = 13;
      ;
    }
    else if (__label__ == 15) {
      $1 = 14;
      ;
    }
    var $21 = $1;
    ;
    return $21;
  }
  __Z9getbinopri.__index__ = Runtime.getFunctionIndex(__Z9getbinopri, "__Z9getbinopri");
  
  
  function __Z10codestringP8LexStateP7expdescP7TString($ls, $e, $s) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    $1 = $ls;
    $2 = $e;
    $3 = $s;
    var $4 = $2;
    var $5 = $1;
    var $6 = $5+36;
    var $7 = IHEAP[$6];
    var $8 = $3;
    var $9 = __Z12luaK_stringKP9FuncStateP7TString($7, $8);
    __Z8init_expP7expdesc7expkindi($4, 4, $9);
    ;
    return;
  }
  __Z10codestringP8LexStateP7expdescP7TString.__index__ = Runtime.getFunctionIndex(__Z10codestringP8LexStateP7expdescP7TString, "__Z10codestringP8LexStateP7expdescP7TString");
  
  
  function __Z11constructorP8LexStateP7expdesc($ls, $t) {
    var __stackBase__  = STACKTOP; STACKTOP += 36; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $fs;
    var $line;
    var $pc;
    var $cc = __stackBase__;
    $1 = $ls;
    $2 = $t;
    var $3 = $1;
    var $4 = $3+36;
    var $5 = IHEAP[$4];
    $fs = $5;
    var $6 = $1;
    var $7 = $6+4;
    var $8 = IHEAP[$7];
    $line = $8;
    var $9 = $fs;
    var $10 = __Z12luaK_codeABCP9FuncState6OpCodeiii($9, 10, 0, 0, 0);
    $pc = $10;
    var $11 = $cc+32;
    IHEAP[$11] = 0;
    var $12 = $cc+24;
    IHEAP[$12] = 0;
    var $13 = $cc+28;
    IHEAP[$13] = 0;
    var $14 = $2;
    var $15 = $cc+20;
    IHEAP[$15] = $14;
    var $16 = $2;
    var $17 = $pc;
    __Z8init_expP7expdesc7expkindi($16, 11, $17);
    var $18 = $cc;
    __Z8init_expP7expdesc7expkindi($18, 0, 0);
    var $19 = $1;
    var $20 = $19+36;
    var $21 = IHEAP[$20];
    var $22 = $2;
    __Z16luaK_exp2nextregP9FuncStateP7expdesc($21, $22);
    var $23 = $1;
    __Z9checknextP8LexStatei($23, 123);
    ;
    $24$2: while(1) { // $24
      var $25 = $1;
      var $26 = $25+12;
      var $27 = $26;
      var $28 = IHEAP[$27];
      var $29 = $28 == 125;
      if ($29) { __label__ = 1; /* $30 */ break $24$2; }
      var $32 = $fs;
      __Z14closelistfieldP9FuncStateP11ConsControl($32, $cc);
      var $33 = $1;
      var $34 = $33+12;
      var $35 = $34;
      var $36 = IHEAP[$35];
      if ($36 == 285) {
        __label__ = 10; /* $37 */ 
      }
      else if ($36 == 91) {
        __label__ = 11; /* $49 */ 
      }
      else {
      __label__ = 12; /* $51 */ 
      }
      
      if (__label__ == 12) {
        var $52 = $1;
        __Z9listfieldP8LexStateP11ConsControl($52, $cc);
        ;
      }
      else if (__label__ == 10) {
        var $38 = $1;
        __Z14luaX_lookaheadP8LexState($38);
        var $39 = $1;
        var $40 = $39+24;
        var $41 = $40;
        var $42 = IHEAP[$41];
        var $43 = $42 != 61;
        ;
        if ($43) {
          ;
          var $45 = $1;
          __Z9listfieldP8LexStateP11ConsControl($45, $cc);
          ;
        }
        else {
          ;
          var $47 = $1;
          __Z8recfieldP8LexStateP11ConsControl($47, $cc);
          ;
        }
        ;
      }
      else if (__label__ == 11) {
        var $50 = $1;
        __Z8recfieldP8LexStateP11ConsControl($50, $cc);
        ;
      }
      ;
      var $55 = $1;
      var $56 = __Z8testnextP8LexStatei($55, 44);
      var $57 = $56 != 0;
      ;
      if ($57) {
        __lastLabel__ = 6; ;
      }
      else {
        __lastLabel__ = 6; ;
        var $59 = $1;
        var $60 = __Z8testnextP8LexStatei($59, 59);
        var $61 = $60 != 0;
        __lastLabel__ = 7; ;
      }
      var $63 = __lastLabel__ == 6 ? 1 : ($61);
      if ($63) { __label__ = 0; /* $24 */ continue $24$2; } else { __label__ = 9; /* $64 */ break $24$2; }
    }
    if (__label__ == 1) {
      ;
    }
    var $65 = $1;
    var $66 = $line;
    __Z11check_matchP8LexStateiii($65, 125, 123, $66);
    var $67 = $fs;
    __Z13lastlistfieldP9FuncStateP11ConsControl($67, $cc);
    var $68 = $pc;
    var $69 = $fs;
    var $70 = $69;
    var $71 = IHEAP[$70];
    var $72 = $71+12;
    var $73 = IHEAP[$72];
    var $74 = $73+4*$68;
    var $75 = IHEAP[$74];
    var $76 = $75 & 8388607;
    var $77 = $cc+28;
    var $78 = IHEAP[$77];
    var $79 = __Z11luaO_int2fbj($78);
    var $80 = $79 << 23;
    var $81 = $80 & -8388608;
    var $82 = $76 | $81;
    var $83 = $pc;
    var $84 = $fs;
    var $85 = $84;
    var $86 = IHEAP[$85];
    var $87 = $86+12;
    var $88 = IHEAP[$87];
    var $89 = $88+4*$83;
    IHEAP[$89] = $82;
    var $90 = $pc;
    var $91 = $fs;
    var $92 = $91;
    var $93 = IHEAP[$92];
    var $94 = $93+12;
    var $95 = IHEAP[$94];
    var $96 = $95+4*$90;
    var $97 = IHEAP[$96];
    var $98 = $97 & -8372225;
    var $99 = $cc+24;
    var $100 = IHEAP[$99];
    var $101 = __Z11luaO_int2fbj($100);
    var $102 = $101 << 14;
    var $103 = $102 & 8372224;
    var $104 = $98 | $103;
    var $105 = $pc;
    var $106 = $fs;
    var $107 = $106;
    var $108 = IHEAP[$107];
    var $109 = $108+12;
    var $110 = IHEAP[$109];
    var $111 = $110+4*$105;
    IHEAP[$111] = $104;
    STACKTOP = __stackBase__;
    return;
  }
  __Z11constructorP8LexStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z11constructorP8LexStateP7expdesc, "__Z11constructorP8LexStateP7expdesc");
  
  
  function __Z4bodyP8LexStateP7expdescii($ls, $e, $needself, $line) {
    var __stackBase__  = STACKTOP; STACKTOP += 572; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $new_fs = __stackBase__;
    $1 = $ls;
    $2 = $e;
    $3 = $needself;
    $4 = $line;
    var $5 = $1;
    __Z9open_funcP8LexStateP9FuncState($5, $new_fs);
    var $6 = $4;
    var $7 = $new_fs;
    var $8 = IHEAP[$7];
    var $9 = $8+60;
    IHEAP[$9] = $6;
    var $10 = $1;
    __Z9checknextP8LexStatei($10, 40);
    var $11 = $3;
    var $12 = $11 != 0;
    ;
    if ($12) {
      ;
      var $14 = $1;
      var $15 = $1;
      var $16 = __Z14luaX_newstringP8LexStatePKcj($15, __str3132, 4);
      __Z12new_localvarP8LexStateP7TStringi($14, $16, 0);
      var $17 = $1;
      __Z15adjustlocalvarsP8LexStatei($17, 1);
      ;
    }
    var $19 = $1;
    __Z7parlistP8LexState($19);
    var $20 = $1;
    __Z9checknextP8LexStatei($20, 41);
    var $21 = $1;
    __Z5chunkP8LexState($21);
    var $22 = $1;
    var $23 = $22+4;
    var $24 = IHEAP[$23];
    var $25 = $new_fs;
    var $26 = IHEAP[$25];
    var $27 = $26+64;
    IHEAP[$27] = $24;
    var $28 = $1;
    var $29 = $4;
    __Z11check_matchP8LexStateiii($28, 262, 265, $29);
    var $30 = $1;
    __Z10close_funcP8LexState($30);
    var $31 = $1;
    var $32 = $2;
    __Z11pushclosureP8LexStateP9FuncStateP7expdesc($31, $new_fs, $32);
    STACKTOP = __stackBase__;
    return;
  }
  __Z4bodyP8LexStateP7expdescii.__index__ = Runtime.getFunctionIndex(__Z4bodyP8LexStateP7expdescii, "__Z4bodyP8LexStateP7expdescii");
  
  
  function __Z12new_localvarP8LexStateP7TStringi($ls, $name, $n) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $fs;
    $1 = $ls;
    $2 = $name;
    $3 = $n;
    var $4 = $1;
    var $5 = $4+36;
    var $6 = IHEAP[$5];
    $fs = $6;
    var $7 = $fs;
    var $8 = $7+50;
    var $9 = IHEAP[$8];
    var $10 = $9;
    var $11 = $3;
    var $12 = $10 + $11;
    var $13 = $12 + 1;
    var $14 = $13 > 200;
    ;
    if ($14) {
      ;
      var $16 = $fs;
      __Z10errorlimitP9FuncStateiPKc($16, 200, __str7136);
      ;
    }
    var $18 = $1;
    var $19 = $2;
    var $20 = __Z16registerlocalvarP8LexStateP7TString($18, $19);
    var $21 = $20;
    var $22 = $fs;
    var $23 = $22+50;
    var $24 = IHEAP[$23];
    var $25 = $24;
    var $26 = $3;
    var $27 = $25 + $26;
    var $28 = $fs;
    var $29 = $28+172;
    var $30 = $29+$27*2;
    IHEAP[$30] = $21;
    ;
    return;
  }
  __Z12new_localvarP8LexStateP7TStringi.__index__ = Runtime.getFunctionIndex(__Z12new_localvarP8LexStateP7TStringi, "__Z12new_localvarP8LexStateP7TStringi");
  
  
  function __Z15adjustlocalvarsP8LexStatei($ls, $nvars) {
    ;
    var __label__;
    var $1;
    var $2;
    var $fs;
    $1 = $ls;
    $2 = $nvars;
    var $3 = $1;
    var $4 = $3+36;
    var $5 = IHEAP[$4];
    $fs = $5;
    var $6 = $fs;
    var $7 = $6+50;
    var $8 = IHEAP[$7];
    var $9 = $8;
    var $10 = $2;
    var $11 = $9 + $10;
    var $12 = $11;
    var $13 = $fs;
    var $14 = $13+50;
    IHEAP[$14] = $12;
    ;
    $15$2: while(1) { // $15
      var $16 = $2;
      var $17 = $16 != 0;
      if (!($17)) { __label__ = 2; /* $43 */ break $15$2; }
      var $19 = $fs;
      var $20 = $19+24;
      var $21 = IHEAP[$20];
      var $22 = $fs;
      var $23 = $22+50;
      var $24 = IHEAP[$23];
      var $25 = $24;
      var $26 = $2;
      var $27 = $25 - $26;
      var $28 = $fs;
      var $29 = $28+172;
      var $30 = $29+$27*2;
      var $31 = IHEAP[$30];
      var $32 = $31;
      var $33 = $fs;
      var $34 = $33;
      var $35 = IHEAP[$34];
      var $36 = $35+24;
      var $37 = IHEAP[$36];
      var $38 = $37+12*$32;
      var $39 = $38+4;
      IHEAP[$39] = $21;
      ;
      var $41 = $2;
      var $42 = $41 + -1;
      $2 = $42;
      __label__ = 0; /* $15 */ continue $15$2;
    }
    ;
    return;
  }
  __Z15adjustlocalvarsP8LexStatei.__index__ = Runtime.getFunctionIndex(__Z15adjustlocalvarsP8LexStatei, "__Z15adjustlocalvarsP8LexStatei");
  
  
  function __Z7parlistP8LexState($ls) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $fs;
    var $f;
    var $nparams;
    $1 = $ls;
    var $2 = $1;
    var $3 = $2+36;
    var $4 = IHEAP[$3];
    $fs = $4;
    var $5 = $fs;
    var $6 = $5;
    var $7 = IHEAP[$6];
    $f = $7;
    $nparams = 0;
    var $8 = $f;
    var $9 = $8+74;
    IHEAP[$9] = 0;
    var $10 = $1;
    var $11 = $10+12;
    var $12 = $11;
    var $13 = IHEAP[$12];
    var $14 = $13 != 41;
    ;
    if ($14) {
      ;
      ;
      $16$4: while(1) { // $16
        var $17 = $1;
        var $18 = $17+12;
        var $19 = $18;
        var $20 = IHEAP[$19];
        if ($20 == 285) {
          __label__ = 7; /* $21 */ 
        }
        else if ($20 == 279) {
          __label__ = 8; /* $27 */ 
        }
        else {
        __label__ = 9; /* $42 */ 
        }
        
        if (__label__ == 9) {
          var $43 = $1;
          __Z16luaX_syntaxerrorP8LexStatePKc($43, __str6135);
          ;
        }
        else if (__label__ == 7) {
          var $22 = $1;
          var $23 = $1;
          var $24 = __Z13str_checknameP8LexState($23);
          var $25 = $nparams;
          var $26 = $25 + 1;
          $nparams = $26;
          __Z12new_localvarP8LexStateP7TStringi($22, $24, $25);
          ;
        }
        else if (__label__ == 8) {
          var $28 = $1;
          __Z9luaX_nextP8LexState($28);
          var $29 = $1;
          var $30 = $1;
          var $31 = __Z14luaX_newstringP8LexStatePKcj($30, __str5134, 3);
          var $32 = $nparams;
          var $33 = $32 + 1;
          $nparams = $33;
          __Z12new_localvarP8LexStateP7TStringi($29, $31, $32);
          var $34 = $f;
          var $35 = $34+74;
          IHEAP[$35] = 5;
          var $36 = $f;
          var $37 = $36+74;
          var $38 = IHEAP[$37];
          var $39 = $38;
          var $40 = $39 | 2;
          var $41 = $40;
          IHEAP[$37] = $41;
          ;
        }
        ;
        var $46 = $f;
        var $47 = $46+74;
        var $48 = IHEAP[$47];
        var $49 = $48 != 0;
        ;
        if ($49) {
          __lastLabel__ = 2; ;
        }
        else {
          __lastLabel__ = 2; ;
          var $51 = $1;
          var $52 = __Z8testnextP8LexStatei($51, 44);
          var $53 = $52 != 0;
          __lastLabel__ = 3; ;
        }
        var $55 = __lastLabel__ == 2 ? 0 : ($53);
        if ($55) { __label__ = 0; /* $16 */ continue $16$4; } else { __label__ = 5; /* $56 */ break $16$4; }
      }
      ;
    }
    var $58 = $1;
    var $59 = $nparams;
    __Z15adjustlocalvarsP8LexStatei($58, $59);
    var $60 = $fs;
    var $61 = $60+50;
    var $62 = IHEAP[$61];
    var $63 = $62;
    var $64 = $f;
    var $65 = $64+74;
    var $66 = IHEAP[$65];
    var $67 = $66;
    var $68 = $67 & 1;
    var $69 = $63 - $68;
    var $70 = $69;
    var $71 = $f;
    var $72 = $71+73;
    IHEAP[$72] = $70;
    var $73 = $fs;
    var $74 = $fs;
    var $75 = $74+50;
    var $76 = IHEAP[$75];
    var $77 = $76;
    __Z16luaK_reserveregsP9FuncStatei($73, $77);
    ;
    return;
  }
  __Z7parlistP8LexState.__index__ = Runtime.getFunctionIndex(__Z7parlistP8LexState, "__Z7parlistP8LexState");
  
  
  function __Z11pushclosureP8LexStateP9FuncStateP7expdesc($ls, $func, $v) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $fs;
    var $f;
    var $oldsize;
    var $i;
    var $o;
    $1 = $ls;
    $2 = $func;
    $3 = $v;
    var $4 = $1;
    var $5 = $4+36;
    var $6 = IHEAP[$5];
    $fs = $6;
    var $7 = $fs;
    var $8 = $7;
    var $9 = IHEAP[$8];
    $f = $9;
    var $10 = $f;
    var $11 = $10+52;
    var $12 = IHEAP[$11];
    $oldsize = $12;
    var $13 = $fs;
    var $14 = $13+44;
    var $15 = IHEAP[$14];
    var $16 = $15 + 1;
    var $17 = $f;
    var $18 = $17+52;
    var $19 = IHEAP[$18];
    var $20 = $16 > $19;
    ;
    if ($20) {
      ;
      var $22 = $1;
      var $23 = $22+40;
      var $24 = IHEAP[$23];
      var $25 = $f;
      var $26 = $25+16;
      var $27 = IHEAP[$26];
      var $28 = $27;
      var $29 = $f;
      var $30 = $29+52;
      var $31 = __Z13luaM_growaux_P9lua_StatePvPijiPKc($24, $28, $30, 4, 262143, __str4133);
      var $32 = $31;
      var $33 = $f;
      var $34 = $33+16;
      IHEAP[$34] = $32;
      ;
    }
    ;
    $36$5: while(1) { // $36
      var $37 = $oldsize;
      var $38 = $f;
      var $39 = $38+52;
      var $40 = IHEAP[$39];
      var $41 = $37 < $40;
      if (!($41)) { __label__ = 3; /* $49 */ break $36$5; }
      var $43 = $oldsize;
      var $44 = $43 + 1;
      $oldsize = $44;
      var $45 = $f;
      var $46 = $45+16;
      var $47 = IHEAP[$46];
      var $48 = $47+4*$43;
      IHEAP[$48] = 0;
      __label__ = 1; /* $36 */ continue $36$5;
    }
    var $50 = $2;
    var $51 = $50;
    var $52 = IHEAP[$51];
    var $53 = $fs;
    var $54 = $53+44;
    var $55 = IHEAP[$54];
    var $56 = $55 + 1;
    IHEAP[$54] = $56;
    var $57 = $f;
    var $58 = $57+16;
    var $59 = IHEAP[$58];
    var $60 = $59+4*$55;
    IHEAP[$60] = $52;
    var $61 = $2;
    var $62 = $61;
    var $63 = IHEAP[$62];
    var $64 = $63;
    var $65 = $64;
    var $66 = $65;
    var $67 = $66+5;
    var $68 = IHEAP[$67];
    var $69 = $68;
    var $70 = $69 & 3;
    var $71 = $70 != 0;
    ;
    $72$92$9: do { 
      if ($71) {
        ;
        var $73 = $f;
        var $74 = $73;
        var $75 = $74;
        var $76 = $75;
        var $77 = $76+5;
        var $78 = IHEAP[$77];
        var $79 = $78;
        var $80 = $79 & 4;
        var $81 = $80 != 0;
        if (!($81)) { __label__ = 5; /* $92 */ break $72$92$9; }
        var $83 = $1;
        var $84 = $83+40;
        var $85 = IHEAP[$84];
        var $86 = $f;
        var $87 = $86;
        var $88 = $2;
        var $89 = $88;
        var $90 = IHEAP[$89];
        var $91 = $90;
        __Z13luaC_barrierfP9lua_StateP8GCObjectS2_($85, $87, $91);
        ;
      }
    } while(0);
    var $93 = $3;
    var $94 = $fs;
    var $95 = $fs;
    var $96 = $95+44;
    var $97 = IHEAP[$96];
    var $98 = $97 - 1;
    var $99 = __Z12luaK_codeABxP9FuncState6OpCodeij($94, 36, 0, $98);
    __Z8init_expP7expdesc7expkindi($93, 11, $99);
    $i = 0;
    ;
    $100$13: while(1) { // $100
      var $101 = $i;
      var $102 = $2;
      var $103 = $102;
      var $104 = IHEAP[$103];
      var $105 = $104+72;
      var $106 = IHEAP[$105];
      var $107 = $106;
      var $108 = $101 < $107;
      if (!($108)) { __label__ = 9; /* $135 */ break $100$13; }
      var $110 = $i;
      var $111 = $2;
      var $112 = $111+52;
      var $113 = $112+$110*2;
      var $114 = $113;
      var $115 = IHEAP[$114];
      var $116 = $115;
      var $117 = $116 == 6;
      ;
      if ($117) {
        ;
        __lastLabel__ = 10; ;
      }
      else {
        ;
        __lastLabel__ = 12; ;
      }
      var $121 = __lastLabel__ == 10 ? 0 : (4);
      $o = $121;
      var $122 = $fs;
      var $123 = $o;
      var $124 = $i;
      var $125 = $2;
      var $126 = $125+52;
      var $127 = $126+$124*2;
      var $128 = $127+1;
      var $129 = IHEAP[$128];
      var $130 = $129;
      var $131 = __Z12luaK_codeABCP9FuncState6OpCodeiii($122, $123, 0, $130, 0);
      ;
      var $133 = $i;
      var $134 = $133 + 1;
      $i = $134;
      __label__ = 7; /* $100 */ continue $100$13;
    }
    ;
    return;
  }
  __Z11pushclosureP8LexStateP9FuncStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z11pushclosureP8LexStateP9FuncStateP7expdesc, "__Z11pushclosureP8LexStateP9FuncStateP7expdesc");
  
  
  function __Z13str_checknameP8LexState($ls) {
    ;
    var __label__;
    var $1;
    var $ts;
    $1 = $ls;
    var $2 = $1;
    __Z5checkP8LexStatei($2, 285);
    var $3 = $1;
    var $4 = $3+12;
    var $5 = $4+4;
    var $6 = $5;
    var $7 = $6;
    var $8 = IHEAP[$7];
    $ts = $8;
    var $9 = $1;
    __Z9luaX_nextP8LexState($9);
    var $10 = $ts;
    ;
    return $10;
  }
  __Z13str_checknameP8LexState.__index__ = Runtime.getFunctionIndex(__Z13str_checknameP8LexState, "__Z13str_checknameP8LexState");
  
  
  function __Z16registerlocalvarP8LexStateP7TString($ls, $varname) {
    ;
    var __label__;
    var $1;
    var $2;
    var $fs;
    var $f;
    var $oldsize;
    $1 = $ls;
    $2 = $varname;
    var $3 = $1;
    var $4 = $3+36;
    var $5 = IHEAP[$4];
    $fs = $5;
    var $6 = $fs;
    var $7 = $6;
    var $8 = IHEAP[$7];
    $f = $8;
    var $9 = $f;
    var $10 = $9+56;
    var $11 = IHEAP[$10];
    $oldsize = $11;
    var $12 = $fs;
    var $13 = $12+48;
    var $14 = IHEAP[$13];
    var $15 = $14;
    var $16 = $15 + 1;
    var $17 = $f;
    var $18 = $17+56;
    var $19 = IHEAP[$18];
    var $20 = $16 > $19;
    ;
    if ($20) {
      ;
      var $22 = $1;
      var $23 = $22+40;
      var $24 = IHEAP[$23];
      var $25 = $f;
      var $26 = $25+24;
      var $27 = IHEAP[$26];
      var $28 = $27;
      var $29 = $f;
      var $30 = $29+56;
      var $31 = __Z13luaM_growaux_P9lua_StatePvPijiPKc($24, $28, $30, 12, 32767, __str8137);
      var $32 = $31;
      var $33 = $f;
      var $34 = $33+24;
      IHEAP[$34] = $32;
      ;
    }
    ;
    $36$5: while(1) { // $36
      var $37 = $oldsize;
      var $38 = $f;
      var $39 = $38+56;
      var $40 = IHEAP[$39];
      var $41 = $37 < $40;
      if (!($41)) { __label__ = 3; /* $50 */ break $36$5; }
      var $43 = $oldsize;
      var $44 = $43 + 1;
      $oldsize = $44;
      var $45 = $f;
      var $46 = $45+24;
      var $47 = IHEAP[$46];
      var $48 = $47+12*$43;
      var $49 = $48;
      IHEAP[$49] = 0;
      __label__ = 1; /* $36 */ continue $36$5;
    }
    var $51 = $2;
    var $52 = $fs;
    var $53 = $52+48;
    var $54 = IHEAP[$53];
    var $55 = $54;
    var $56 = $f;
    var $57 = $56+24;
    var $58 = IHEAP[$57];
    var $59 = $58+12*$55;
    var $60 = $59;
    IHEAP[$60] = $51;
    var $61 = $2;
    var $62 = $61;
    var $63 = $62;
    var $64 = $63;
    var $65 = $64+5;
    var $66 = IHEAP[$65];
    var $67 = $66;
    var $68 = $67 & 3;
    var $69 = $68 != 0;
    ;
    $70$88$9: do { 
      if ($69) {
        ;
        var $71 = $f;
        var $72 = $71;
        var $73 = $72;
        var $74 = $73;
        var $75 = $74+5;
        var $76 = IHEAP[$75];
        var $77 = $76;
        var $78 = $77 & 4;
        var $79 = $78 != 0;
        if (!($79)) { __label__ = 5; /* $88 */ break $70$88$9; }
        var $81 = $1;
        var $82 = $81+40;
        var $83 = IHEAP[$82];
        var $84 = $f;
        var $85 = $84;
        var $86 = $2;
        var $87 = $86;
        __Z13luaC_barrierfP9lua_StateP8GCObjectS2_($83, $85, $87);
        ;
      }
    } while(0);
    var $89 = $fs;
    var $90 = $89+48;
    var $91 = IHEAP[$90];
    var $92 = $91 + 1;
    IHEAP[$90] = $92;
    var $93 = $91;
    ;
    return $93;
  }
  __Z16registerlocalvarP8LexStateP7TString.__index__ = Runtime.getFunctionIndex(__Z16registerlocalvarP8LexStateP7TString, "__Z16registerlocalvarP8LexStateP7TString");
  
  
  function __Z14closelistfieldP9FuncStateP11ConsControl($fs, $cc) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $fs;
    $2 = $cc;
    var $3 = $2;
    var $4 = $3;
    var $5 = $4;
    var $6 = IHEAP[$5];
    var $7 = $6 == 0;
    ;
    $8$9$2: do { 
      if ($7) {
        ;
        ;
      }
      else {
        ;
        var $10 = $1;
        var $11 = $2;
        var $12 = $11;
        __Z16luaK_exp2nextregP9FuncStateP7expdesc($10, $12);
        var $13 = $2;
        var $14 = $13;
        var $15 = $14;
        IHEAP[$15] = 0;
        var $16 = $2;
        var $17 = $16+32;
        var $18 = IHEAP[$17];
        var $19 = $18 == 50;
        if (!($19)) { __label__ = 2; /* $37 */ break $8$9$2; }
        var $21 = $1;
        var $22 = $2;
        var $23 = $22+20;
        var $24 = IHEAP[$23];
        var $25 = $24+4;
        var $26 = $25;
        var $27 = $26;
        var $28 = IHEAP[$27];
        var $29 = $2;
        var $30 = $29+28;
        var $31 = IHEAP[$30];
        var $32 = $2;
        var $33 = $32+32;
        var $34 = IHEAP[$33];
        __Z12luaK_setlistP9FuncStateiii($21, $28, $31, $34);
        var $35 = $2;
        var $36 = $35+32;
        IHEAP[$36] = 0;
        ;
      }
    } while(0);
    ;
    return;
  }
  __Z14closelistfieldP9FuncStateP11ConsControl.__index__ = Runtime.getFunctionIndex(__Z14closelistfieldP9FuncStateP11ConsControl, "__Z14closelistfieldP9FuncStateP11ConsControl");
  
  
  function __Z9listfieldP8LexStateP11ConsControl($ls, $cc) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $ls;
    $2 = $cc;
    var $3 = $1;
    var $4 = $2;
    var $5 = $4;
    __Z4exprP8LexStateP7expdesc($3, $5);
    var $6 = $2;
    var $7 = $6+28;
    var $8 = IHEAP[$7];
    var $9 = $8 > 2147483645;
    ;
    if ($9) {
      ;
      var $11 = $1;
      var $12 = $11+36;
      var $13 = IHEAP[$12];
      __Z10errorlimitP9FuncStateiPKc($13, 2147483645, __str9138);
      ;
    }
    var $15 = $2;
    var $16 = $15+28;
    var $17 = IHEAP[$16];
    var $18 = $17 + 1;
    IHEAP[$16] = $18;
    var $19 = $2;
    var $20 = $19+32;
    var $21 = IHEAP[$20];
    var $22 = $21 + 1;
    IHEAP[$20] = $22;
    ;
    return;
  }
  __Z9listfieldP8LexStateP11ConsControl.__index__ = Runtime.getFunctionIndex(__Z9listfieldP8LexStateP11ConsControl, "__Z9listfieldP8LexStateP11ConsControl");
  
  
  function __Z8recfieldP8LexStateP11ConsControl($ls, $cc) {
    var __stackBase__  = STACKTOP; STACKTOP += 40; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $fs;
    var $reg;
    var $key = __stackBase__;
    var $val = __stackBase__+20;
    var $rkkey;
    $1 = $ls;
    $2 = $cc;
    var $3 = $1;
    var $4 = $3+36;
    var $5 = IHEAP[$4];
    $fs = $5;
    var $6 = $1;
    var $7 = $6+36;
    var $8 = IHEAP[$7];
    var $9 = $8+36;
    var $10 = IHEAP[$9];
    $reg = $10;
    var $11 = $1;
    var $12 = $11+12;
    var $13 = $12;
    var $14 = IHEAP[$13];
    var $15 = $14 == 285;
    ;
    if ($15) {
      ;
      var $17 = $2;
      var $18 = $17+24;
      var $19 = IHEAP[$18];
      var $20 = $19 > 2147483645;
      ;
      if ($20) {
        ;
        var $22 = $fs;
        __Z10errorlimitP9FuncStateiPKc($22, 2147483645, __str9138);
        ;
      }
      var $24 = $1;
      __Z9checknameP8LexStateP7expdesc($24, $key);
      ;
    }
    else {
      ;
      var $26 = $1;
      __Z6yindexP8LexStateP7expdesc($26, $key);
      ;
    }
    var $28 = $2;
    var $29 = $28+24;
    var $30 = IHEAP[$29];
    var $31 = $30 + 1;
    IHEAP[$29] = $31;
    var $32 = $1;
    __Z9checknextP8LexStatei($32, 61);
    var $33 = $fs;
    var $34 = __Z11luaK_exp2RKP9FuncStateP7expdesc($33, $key);
    $rkkey = $34;
    var $35 = $1;
    __Z4exprP8LexStateP7expdesc($35, $val);
    var $36 = $fs;
    var $37 = $2;
    var $38 = $37+20;
    var $39 = IHEAP[$38];
    var $40 = $39+4;
    var $41 = $40;
    var $42 = $41;
    var $43 = IHEAP[$42];
    var $44 = $rkkey;
    var $45 = $fs;
    var $46 = __Z11luaK_exp2RKP9FuncStateP7expdesc($45, $val);
    var $47 = __Z12luaK_codeABCP9FuncState6OpCodeiii($36, 9, $43, $44, $46);
    var $48 = $reg;
    var $49 = $fs;
    var $50 = $49+36;
    IHEAP[$50] = $48;
    STACKTOP = __stackBase__;
    return;
  }
  __Z8recfieldP8LexStateP11ConsControl.__index__ = Runtime.getFunctionIndex(__Z8recfieldP8LexStateP11ConsControl, "__Z8recfieldP8LexStateP11ConsControl");
  
  
  function __Z13lastlistfieldP9FuncStateP11ConsControl($fs, $cc) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $fs;
    $2 = $cc;
    var $3 = $2;
    var $4 = $3+32;
    var $5 = IHEAP[$4];
    var $6 = $5 == 0;
    ;
    $7$8$2: do { 
      if ($6) {
        ;
        ;
      }
      else {
        ;
        var $9 = $2;
        var $10 = $9;
        var $11 = $10;
        var $12 = IHEAP[$11];
        var $13 = $12 == 13;
        ;
        $20$14$5: do { 
          if (!$13) {
            ;
            var $15 = $2;
            var $16 = $15;
            var $17 = $16;
            var $18 = IHEAP[$17];
            var $19 = $18 == 14;
            if ($19) { __label__ = 1; /* $20 */ break $20$14$5; }
            var $40 = $2;
            var $41 = $40;
            var $42 = $41;
            var $43 = IHEAP[$42];
            var $44 = $43 != 0;
            ;
            if ($44) {
              ;
              var $46 = $1;
              var $47 = $2;
              var $48 = $47;
              __Z16luaK_exp2nextregP9FuncStateP7expdesc($46, $48);
              ;
            }
            var $50 = $1;
            var $51 = $2;
            var $52 = $51+20;
            var $53 = IHEAP[$52];
            var $54 = $53+4;
            var $55 = $54;
            var $56 = $55;
            var $57 = IHEAP[$56];
            var $58 = $2;
            var $59 = $58+28;
            var $60 = IHEAP[$59];
            var $61 = $2;
            var $62 = $61+32;
            var $63 = IHEAP[$62];
            __Z12luaK_setlistP9FuncStateiii($50, $57, $60, $63);
            __label__ = 4; /* $64 */ break $7$8$2;
          }
        } while(0);
        var $21 = $1;
        var $22 = $2;
        var $23 = $22;
        __Z15luaK_setreturnsP9FuncStateP7expdesci($21, $23, -1);
        var $24 = $1;
        var $25 = $2;
        var $26 = $25+20;
        var $27 = IHEAP[$26];
        var $28 = $27+4;
        var $29 = $28;
        var $30 = $29;
        var $31 = IHEAP[$30];
        var $32 = $2;
        var $33 = $32+28;
        var $34 = IHEAP[$33];
        __Z12luaK_setlistP9FuncStateiii($24, $31, $34, -1);
        var $35 = $2;
        var $36 = $35+28;
        var $37 = IHEAP[$36];
        var $38 = $37 + -1;
        IHEAP[$36] = $38;
        ;
      }
    } while(0);
    ;
    return;
  }
  __Z13lastlistfieldP9FuncStateP11ConsControl.__index__ = Runtime.getFunctionIndex(__Z13lastlistfieldP9FuncStateP11ConsControl, "__Z13lastlistfieldP9FuncStateP11ConsControl");
  
  
  function __Z9checknameP8LexStateP7expdesc($ls, $e) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $ls;
    $2 = $e;
    var $3 = $1;
    var $4 = $2;
    var $5 = $1;
    var $6 = __Z13str_checknameP8LexState($5);
    __Z10codestringP8LexStateP7expdescP7TString($3, $4, $6);
    ;
    return;
  }
  __Z9checknameP8LexStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z9checknameP8LexStateP7expdesc, "__Z9checknameP8LexStateP7expdesc");
  
  
  function __Z6yindexP8LexStateP7expdesc($ls, $v) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $ls;
    $2 = $v;
    var $3 = $1;
    __Z9luaX_nextP8LexState($3);
    var $4 = $1;
    var $5 = $2;
    __Z4exprP8LexStateP7expdesc($4, $5);
    var $6 = $1;
    var $7 = $6+36;
    var $8 = IHEAP[$7];
    var $9 = $2;
    __Z12luaK_exp2valP9FuncStateP7expdesc($8, $9);
    var $10 = $1;
    __Z9checknextP8LexStatei($10, 93);
    ;
    return;
  }
  __Z6yindexP8LexStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z6yindexP8LexStateP7expdesc, "__Z6yindexP8LexStateP7expdesc");
  
  
  function __Z9prefixexpP8LexStateP7expdesc($ls, $v) {
    ;
    var __label__;
    var $1;
    var $2;
    var $line;
    $1 = $ls;
    $2 = $v;
    var $3 = $1;
    var $4 = $3+12;
    var $5 = $4;
    var $6 = IHEAP[$5];
    if ($6 == 40) {
      __label__ = 1; /* $7 */ 
    }
    else if ($6 == 285) {
      __label__ = 2; /* $20 */ 
    }
    else {
    __label__ = 3; /* $23 */ 
    }
    
    if (__label__ == 3) {
      var $24 = $1;
      __Z16luaX_syntaxerrorP8LexStatePKc($24, __str14143);
      ;
    }
    else if (__label__ == 1) {
      var $8 = $1;
      var $9 = $8+4;
      var $10 = IHEAP[$9];
      $line = $10;
      var $11 = $1;
      __Z9luaX_nextP8LexState($11);
      var $12 = $1;
      var $13 = $2;
      __Z4exprP8LexStateP7expdesc($12, $13);
      var $14 = $1;
      var $15 = $line;
      __Z11check_matchP8LexStateiii($14, 41, 40, $15);
      var $16 = $1;
      var $17 = $16+36;
      var $18 = IHEAP[$17];
      var $19 = $2;
      __Z18luaK_dischargevarsP9FuncStateP7expdesc($18, $19);
      ;
    }
    else if (__label__ == 2) {
      var $21 = $1;
      var $22 = $2;
      __Z9singlevarP8LexStateP7expdesc($21, $22);
      ;
    }
    ;
    return;
  }
  __Z9prefixexpP8LexStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z9prefixexpP8LexStateP7expdesc, "__Z9prefixexpP8LexStateP7expdesc");
  
  
  function __Z5fieldP8LexStateP7expdesc($ls, $v) {
    var __stackBase__  = STACKTOP; STACKTOP += 20; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $fs;
    var $key = __stackBase__;
    $1 = $ls;
    $2 = $v;
    var $3 = $1;
    var $4 = $3+36;
    var $5 = IHEAP[$4];
    $fs = $5;
    var $6 = $fs;
    var $7 = $2;
    var $8 = __Z15luaK_exp2anyregP9FuncStateP7expdesc($6, $7);
    var $9 = $1;
    __Z9luaX_nextP8LexState($9);
    var $10 = $1;
    __Z9checknameP8LexStateP7expdesc($10, $key);
    var $11 = $fs;
    var $12 = $2;
    __Z12luaK_indexedP9FuncStateP7expdescS2_($11, $12, $key);
    STACKTOP = __stackBase__;
    return;
  }
  __Z5fieldP8LexStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z5fieldP8LexStateP7expdesc, "__Z5fieldP8LexStateP7expdesc");
  
  
  function __Z8funcargsP8LexStateP7expdesc($ls, $f) {
    var __stackBase__  = STACKTOP; STACKTOP += 20; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $fs;
    var $args = __stackBase__;
    var $base;
    var $nparams;
    var $line;
    $1 = $ls;
    $2 = $f;
    var $3 = $1;
    var $4 = $3+36;
    var $5 = IHEAP[$4];
    $fs = $5;
    var $6 = $1;
    var $7 = $6+4;
    var $8 = IHEAP[$7];
    $line = $8;
    var $9 = $1;
    var $10 = $9+12;
    var $11 = $10;
    var $12 = IHEAP[$11];
    if ($12 == 40) {
      __label__ = 10; /* $13 */ 
    }
    else if ($12 == 123) {
      __label__ = 11; /* $37 */ 
    }
    else if ($12 == 286) {
      __label__ = 12; /* $39 */ 
    }
    else {
    __label__ = 13; /* $48 */ 
    }
    
    $48$13$37$39$2: do { 
      if (__label__ == 13) {
        var $49 = $1;
        __Z16luaX_syntaxerrorP8LexStatePKc($49, __str13142);
        __label__ = 3; /* $90 */ break $48$13$37$39$2;
      }
      else if (__label__ == 10) {
        var $14 = $line;
        var $15 = $1;
        var $16 = $15+8;
        var $17 = IHEAP[$16];
        var $18 = $14 != $17;
        ;
        if ($18) {
          ;
          var $20 = $1;
          __Z16luaX_syntaxerrorP8LexStatePKc($20, __str12141);
          ;
        }
        var $22 = $1;
        __Z9luaX_nextP8LexState($22);
        var $23 = $1;
        var $24 = $23+12;
        var $25 = $24;
        var $26 = IHEAP[$25];
        var $27 = $26 == 41;
        ;
        if ($27) {
          ;
          var $29 = $args;
          IHEAP[$29] = 0;
          ;
        }
        else {
          ;
          var $31 = $1;
          var $32 = __Z8explist1P8LexStateP7expdesc($31, $args);
          var $33 = $fs;
          __Z15luaK_setreturnsP9FuncStateP7expdesci($33, $args, -1);
          ;
        }
        var $35 = $1;
        var $36 = $line;
        __Z11check_matchP8LexStateiii($35, 41, 40, $36);
        __label__ = 2; /* $50 */ break $48$13$37$39$2;
      }
      else if (__label__ == 11) {
        var $38 = $1;
        __Z11constructorP8LexStateP7expdesc($38, $args);
        __label__ = 2; /* $50 */ break $48$13$37$39$2;
      }
      else if (__label__ == 12) {
        var $40 = $1;
        var $41 = $1;
        var $42 = $41+12;
        var $43 = $42+4;
        var $44 = $43;
        var $45 = $44;
        var $46 = IHEAP[$45];
        __Z10codestringP8LexStateP7expdescP7TString($40, $args, $46);
        var $47 = $1;
        __Z9luaX_nextP8LexState($47);
        __label__ = 2; /* $50 */ break $48$13$37$39$2;
      }
    } while(0);
    if (__label__ == 2) {
      var $51 = $2;
      var $52 = $51+4;
      var $53 = $52;
      var $54 = $53;
      var $55 = IHEAP[$54];
      $base = $55;
      var $56 = $args;
      var $57 = IHEAP[$56];
      var $58 = $57 == 13;
      ;
      $63$59$16: do { 
        if ($58) {
          __label__ = 4; /* $63 */ 
        }
        else {
          ;
          var $60 = $args;
          var $61 = IHEAP[$60];
          var $62 = $61 == 14;
          if ($62) { __label__ = 4; /* $63 */ break $63$59$16; }
          var $65 = $args;
          var $66 = IHEAP[$65];
          var $67 = $66 != 0;
          ;
          if ($67) {
            ;
            var $69 = $fs;
            __Z16luaK_exp2nextregP9FuncStateP7expdesc($69, $args);
            ;
          }
          var $71 = $fs;
          var $72 = $71+36;
          var $73 = IHEAP[$72];
          var $74 = $base;
          var $75 = $74 + 1;
          var $76 = $73 - $75;
          $nparams = $76;
          __label__ = 8; /* $77 */ break $63$59$16;
        }
      } while(0);
      if (__label__ == 4) {
        $nparams = -1;
        ;
      }
      var $78 = $2;
      var $79 = $fs;
      var $80 = $base;
      var $81 = $nparams;
      var $82 = $81 + 1;
      var $83 = __Z12luaK_codeABCP9FuncState6OpCodeiii($79, 28, $80, $82, 2);
      __Z8init_expP7expdesc7expkindi($78, 13, $83);
      var $84 = $fs;
      var $85 = $line;
      __Z12luaK_fixlineP9FuncStatei($84, $85);
      var $86 = $base;
      var $87 = $86 + 1;
      var $88 = $fs;
      var $89 = $88+36;
      IHEAP[$89] = $87;
      ;
    }
    STACKTOP = __stackBase__;
    return;
  }
  __Z8funcargsP8LexStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z8funcargsP8LexStateP7expdesc, "__Z8funcargsP8LexStateP7expdesc");
  
  
  function __Z9singlevarP8LexStateP7expdesc($ls, $var) {
    ;
    var __label__;
    var $1;
    var $2;
    var $varname;
    var $fs;
    $1 = $ls;
    $2 = $var;
    var $3 = $1;
    var $4 = __Z13str_checknameP8LexState($3);
    $varname = $4;
    var $5 = $1;
    var $6 = $5+36;
    var $7 = IHEAP[$6];
    $fs = $7;
    var $8 = $fs;
    var $9 = $varname;
    var $10 = $2;
    var $11 = __Z12singlevarauxP9FuncStateP7TStringP7expdesci($8, $9, $10, 1);
    var $12 = $11 == 8;
    ;
    if ($12) {
      ;
      var $14 = $fs;
      var $15 = $varname;
      var $16 = __Z12luaK_stringKP9FuncStateP7TString($14, $15);
      var $17 = $2;
      var $18 = $17+4;
      var $19 = $18;
      var $20 = $19;
      IHEAP[$20] = $16;
      ;
    }
    ;
    return;
  }
  __Z9singlevarP8LexStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z9singlevarP8LexStateP7expdesc, "__Z9singlevarP8LexStateP7expdesc");
  
  
  function __Z12singlevarauxP9FuncStateP7TStringP7expdesci($fs, $n, $var, $base) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $5;
    var $v;
    $2 = $fs;
    $3 = $n;
    $4 = $var;
    $5 = $base;
    var $6 = $2;
    var $7 = $6 == 0;
    ;
    if ($7) {
      ;
      var $9 = $4;
      __Z8init_expP7expdesc7expkindi($9, 8, 255);
      $1 = 8;
      ;
    }
    else {
      ;
      var $11 = $2;
      var $12 = $3;
      var $13 = __Z9searchvarP9FuncStateP7TString($11, $12);
      $v = $13;
      var $14 = $v;
      var $15 = $14 >= 0;
      ;
      if ($15) {
        ;
        var $17 = $4;
        var $18 = $v;
        __Z8init_expP7expdesc7expkindi($17, 6, $18);
        var $19 = $5;
        var $20 = $19 != 0;
        ;
        if (!$20) {
          ;
          var $22 = $2;
          var $23 = $v;
          __Z9markupvalP9FuncStatei($22, $23);
          ;
        }
        $1 = 6;
        ;
      }
      else {
        ;
        var $26 = $2;
        var $27 = $26+8;
        var $28 = IHEAP[$27];
        var $29 = $3;
        var $30 = $4;
        var $31 = __Z12singlevarauxP9FuncStateP7TStringP7expdesci($28, $29, $30, 0);
        var $32 = $31 == 8;
        ;
        if ($32) {
          ;
          $1 = 8;
          ;
        }
        else {
          ;
          var $35 = $2;
          var $36 = $3;
          var $37 = $4;
          var $38 = __Z12indexupvalueP9FuncStateP7TStringP7expdesc($35, $36, $37);
          var $39 = $4;
          var $40 = $39+4;
          var $41 = $40;
          var $42 = $41;
          IHEAP[$42] = $38;
          var $43 = $4;
          var $44 = $43;
          IHEAP[$44] = 7;
          $1 = 7;
          ;
        }
      }
    }
    var $46 = $1;
    ;
    return $46;
  }
  __Z12singlevarauxP9FuncStateP7TStringP7expdesci.__index__ = Runtime.getFunctionIndex(__Z12singlevarauxP9FuncStateP7TStringP7expdesci, "__Z12singlevarauxP9FuncStateP7TStringP7expdesci");
  
  
  function __Z9searchvarP9FuncStateP7TString($fs, $n) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $i;
    $2 = $fs;
    $3 = $n;
    var $4 = $2;
    var $5 = $4+50;
    var $6 = IHEAP[$5];
    var $7 = $6;
    var $8 = $7 - 1;
    $i = $8;
    ;
    $9$2: while(1) { // $9
      var $10 = $i;
      var $11 = $10 >= 0;
      if (!($11)) { __label__ = 2; /* $35 */ break $9$2; }
      var $13 = $3;
      var $14 = $i;
      var $15 = $2;
      var $16 = $15+172;
      var $17 = $16+$14*2;
      var $18 = IHEAP[$17];
      var $19 = $18;
      var $20 = $2;
      var $21 = $20;
      var $22 = IHEAP[$21];
      var $23 = $22+24;
      var $24 = IHEAP[$23];
      var $25 = $24+12*$19;
      var $26 = $25;
      var $27 = IHEAP[$26];
      var $28 = $13 == $27;
      if ($28) { __label__ = 3; /* $29 */ break $9$2; }
      ;
      var $33 = $i;
      var $34 = $33 + -1;
      $i = $34;
      __label__ = 0; /* $9 */ continue $9$2;
    }
    if (__label__ == 2) {
      $1 = -1;
      ;
    }
    else if (__label__ == 3) {
      var $30 = $i;
      $1 = $30;
      ;
    }
    var $37 = $1;
    ;
    return $37;
  }
  __Z9searchvarP9FuncStateP7TString.__index__ = Runtime.getFunctionIndex(__Z9searchvarP9FuncStateP7TString, "__Z9searchvarP9FuncStateP7TString");
  
  
  function __Z9markupvalP9FuncStatei($fs, $level) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $bl;
    $1 = $fs;
    $2 = $level;
    var $3 = $1;
    var $4 = $3+20;
    var $5 = IHEAP[$4];
    $bl = $5;
    ;
    $6$2: while(1) { // $6
      var $7 = $bl;
      var $8 = $7 != 0;
      ;
      if ($8) {
        __lastLabel__ = 0; ;
        var $10 = $bl;
        var $11 = $10+8;
        var $12 = IHEAP[$11];
        var $13 = $12;
        var $14 = $2;
        var $15 = $13 > $14;
        __lastLabel__ = 1; ;
      }
      else {
        __lastLabel__ = 0; ;
      }
      var $17 = __lastLabel__ == 0 ? 0 : ($15);
      if (!($17)) { __label__ = 4; /* $22 */ break $6$2; }
      var $19 = $bl;
      var $20 = $19;
      var $21 = IHEAP[$20];
      $bl = $21;
      __label__ = 0; /* $6 */ continue $6$2;
    }
    var $23 = $bl;
    var $24 = $23 != 0;
    ;
    if ($24) {
      ;
      var $26 = $bl;
      var $27 = $26+9;
      IHEAP[$27] = 1;
      ;
    }
    ;
    return;
  }
  __Z9markupvalP9FuncStatei.__index__ = Runtime.getFunctionIndex(__Z9markupvalP9FuncStatei, "__Z9markupvalP9FuncStatei");
  
  
  function __Z12indexupvalueP9FuncStateP7TStringP7expdesc($fs, $name, $v) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $i;
    var $f;
    var $oldsize;
    $2 = $fs;
    $3 = $name;
    $4 = $v;
    var $5 = $2;
    var $6 = $5;
    var $7 = IHEAP[$6];
    $f = $7;
    var $8 = $f;
    var $9 = $8+36;
    var $10 = IHEAP[$9];
    $oldsize = $10;
    $i = 0;
    ;
    $11$2: while(1) { // $11
      var $12 = $i;
      var $13 = $f;
      var $14 = $13+72;
      var $15 = IHEAP[$14];
      var $16 = $15;
      var $17 = $12 < $16;
      if (!($17)) { __label__ = 2; /* $50 */ break $11$2; }
      var $19 = $i;
      var $20 = $2;
      var $21 = $20+52;
      var $22 = $21+$19*2;
      var $23 = $22;
      var $24 = IHEAP[$23];
      var $25 = $24;
      var $26 = $4;
      var $27 = $26;
      var $28 = IHEAP[$27];
      var $29 = $25 == $28;
      ;
      if ($29) {
        ;
        var $31 = $i;
        var $32 = $2;
        var $33 = $32+52;
        var $34 = $33+$31*2;
        var $35 = $34+1;
        var $36 = IHEAP[$35];
        var $37 = $36;
        var $38 = $4;
        var $39 = $38+4;
        var $40 = $39;
        var $41 = $40;
        var $42 = IHEAP[$41];
        var $43 = $37 == $42;
        if ($43) { __label__ = 3; /* $44 */ break $11$2; }
      }
      ;
      var $48 = $i;
      var $49 = $48 + 1;
      $i = $49;
      __label__ = 0; /* $11 */ continue $11$2;
    }
    if (__label__ == 2) {
      var $51 = $f;
      var $52 = $51+72;
      var $53 = IHEAP[$52];
      var $54 = $53;
      var $55 = $54 + 1;
      var $56 = $55 > 60;
      ;
      if ($56) {
        ;
        var $58 = $2;
        __Z10errorlimitP9FuncStateiPKc($58, 60, __str15144);
        ;
      }
      var $60 = $f;
      var $61 = $60+72;
      var $62 = IHEAP[$61];
      var $63 = $62;
      var $64 = $63 + 1;
      var $65 = $f;
      var $66 = $65+36;
      var $67 = IHEAP[$66];
      var $68 = $64 > $67;
      ;
      if ($68) {
        ;
        var $70 = $2;
        var $71 = $70+16;
        var $72 = IHEAP[$71];
        var $73 = $f;
        var $74 = $73+28;
        var $75 = IHEAP[$74];
        var $76 = $75;
        var $77 = $f;
        var $78 = $77+36;
        var $79 = __Z13luaM_growaux_P9lua_StatePvPijiPKc($72, $76, $78, 4, 2147483645, __str16145);
        var $80 = $79;
        var $81 = $f;
        var $82 = $81+28;
        IHEAP[$82] = $80;
        ;
      }
      ;
      $84$17: while(1) { // $84
        var $85 = $oldsize;
        var $86 = $f;
        var $87 = $86+36;
        var $88 = IHEAP[$87];
        var $89 = $85 < $88;
        if (!($89)) { __label__ = 11; /* $97 */ break $84$17; }
        var $91 = $oldsize;
        var $92 = $91 + 1;
        $oldsize = $92;
        var $93 = $f;
        var $94 = $93+28;
        var $95 = IHEAP[$94];
        var $96 = $95+4*$91;
        IHEAP[$96] = 0;
        __label__ = 9; /* $84 */ continue $84$17;
      }
      var $98 = $3;
      var $99 = $f;
      var $100 = $99+72;
      var $101 = IHEAP[$100];
      var $102 = $101;
      var $103 = $f;
      var $104 = $103+28;
      var $105 = IHEAP[$104];
      var $106 = $105+4*$102;
      IHEAP[$106] = $98;
      var $107 = $3;
      var $108 = $107;
      var $109 = $108;
      var $110 = $109;
      var $111 = $110+5;
      var $112 = IHEAP[$111];
      var $113 = $112;
      var $114 = $113 & 3;
      var $115 = $114 != 0;
      ;
      $116$134$21: do { 
        if ($115) {
          ;
          var $117 = $f;
          var $118 = $117;
          var $119 = $118;
          var $120 = $119;
          var $121 = $120+5;
          var $122 = IHEAP[$121];
          var $123 = $122;
          var $124 = $123 & 4;
          var $125 = $124 != 0;
          if (!($125)) { __label__ = 13; /* $134 */ break $116$134$21; }
          var $127 = $2;
          var $128 = $127+16;
          var $129 = IHEAP[$128];
          var $130 = $f;
          var $131 = $130;
          var $132 = $3;
          var $133 = $132;
          __Z13luaC_barrierfP9lua_StateP8GCObjectS2_($129, $131, $133);
          ;
        }
      } while(0);
      var $135 = $4;
      var $136 = $135;
      var $137 = IHEAP[$136];
      var $138 = $137;
      var $139 = $f;
      var $140 = $139+72;
      var $141 = IHEAP[$140];
      var $142 = $141;
      var $143 = $2;
      var $144 = $143+52;
      var $145 = $144+$142*2;
      var $146 = $145;
      IHEAP[$146] = $138;
      var $147 = $4;
      var $148 = $147+4;
      var $149 = $148;
      var $150 = $149;
      var $151 = IHEAP[$150];
      var $152 = $151;
      var $153 = $f;
      var $154 = $153+72;
      var $155 = IHEAP[$154];
      var $156 = $155;
      var $157 = $2;
      var $158 = $157+52;
      var $159 = $158+$156*2;
      var $160 = $159+1;
      IHEAP[$160] = $152;
      var $161 = $f;
      var $162 = $161+72;
      var $163 = IHEAP[$162];
      var $164 = $163 + 1;
      IHEAP[$162] = $164;
      var $165 = $163;
      $1 = $165;
      ;
    }
    else if (__label__ == 3) {
      var $45 = $i;
      $1 = $45;
      ;
    }
    var $167 = $1;
    ;
    return $167;
  }
  __Z12indexupvalueP9FuncStateP7TStringP7expdesc.__index__ = Runtime.getFunctionIndex(__Z12indexupvalueP9FuncStateP7TStringP7expdesc, "__Z12indexupvalueP9FuncStateP7TStringP7expdesc");
  
  
  function __Z8funcnameP8LexStateP7expdesc($ls, $v) {
    ;
    var __label__;
    var $1;
    var $2;
    var $needself;
    $1 = $ls;
    $2 = $v;
    $needself = 0;
    var $3 = $1;
    var $4 = $2;
    __Z9singlevarP8LexStateP7expdesc($3, $4);
    ;
    $5$2: while(1) { // $5
      var $6 = $1;
      var $7 = $6+12;
      var $8 = $7;
      var $9 = IHEAP[$8];
      var $10 = $9 == 46;
      if (!($10)) { __label__ = 2; /* $14 */ break $5$2; }
      var $12 = $1;
      var $13 = $2;
      __Z5fieldP8LexStateP7expdesc($12, $13);
      __label__ = 0; /* $5 */ continue $5$2;
    }
    var $15 = $1;
    var $16 = $15+12;
    var $17 = $16;
    var $18 = IHEAP[$17];
    var $19 = $18 == 58;
    ;
    if ($19) {
      ;
      $needself = 1;
      var $21 = $1;
      var $22 = $2;
      __Z5fieldP8LexStateP7expdesc($21, $22);
      ;
    }
    var $24 = $needself;
    ;
    return $24;
  }
  __Z8funcnameP8LexStateP7expdesc.__index__ = Runtime.getFunctionIndex(__Z8funcnameP8LexStateP7expdesc, "__Z8funcnameP8LexStateP7expdesc");
  
  
  function __Z10enterblockP9FuncStateP8BlockCnth($fs, $bl, $isbreakable) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    $1 = $fs;
    $2 = $bl;
    $3 = $isbreakable;
    var $4 = $2;
    var $5 = $4+4;
    IHEAP[$5] = -1;
    var $6 = $3;
    var $7 = $2;
    var $8 = $7+10;
    IHEAP[$8] = $6;
    var $9 = $1;
    var $10 = $9+50;
    var $11 = IHEAP[$10];
    var $12 = $2;
    var $13 = $12+8;
    IHEAP[$13] = $11;
    var $14 = $2;
    var $15 = $14+9;
    IHEAP[$15] = 0;
    var $16 = $1;
    var $17 = $16+20;
    var $18 = IHEAP[$17];
    var $19 = $2;
    var $20 = $19;
    IHEAP[$20] = $18;
    var $21 = $2;
    var $22 = $1;
    var $23 = $22+20;
    IHEAP[$23] = $21;
    ;
    return;
  }
  __Z10enterblockP9FuncStateP8BlockCnth.__index__ = Runtime.getFunctionIndex(__Z10enterblockP9FuncStateP8BlockCnth, "__Z10enterblockP9FuncStateP8BlockCnth");
  
  
  function __Z4condP8LexState($ls) {
    var __stackBase__  = STACKTOP; STACKTOP += 20; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $v = __stackBase__;
    $1 = $ls;
    var $2 = $1;
    __Z4exprP8LexStateP7expdesc($2, $v);
    var $3 = $v;
    var $4 = IHEAP[$3];
    var $5 = $4 == 1;
    ;
    if ($5) {
      ;
      var $7 = $v;
      IHEAP[$7] = 3;
      ;
    }
    var $9 = $1;
    var $10 = $9+36;
    var $11 = IHEAP[$10];
    __Z13luaK_goiftrueP9FuncStateP7expdesc($11, $v);
    var $12 = $v+16;
    var $13 = IHEAP[$12];
    STACKTOP = __stackBase__;
    return $13;
  }
  __Z4condP8LexState.__index__ = Runtime.getFunctionIndex(__Z4condP8LexState, "__Z4condP8LexState");
  
  
  function __Z10leaveblockP9FuncState($fs) {
    ;
    var __label__;
    var $1;
    var $bl;
    $1 = $fs;
    var $2 = $1;
    var $3 = $2+20;
    var $4 = IHEAP[$3];
    $bl = $4;
    var $5 = $bl;
    var $6 = $5;
    var $7 = IHEAP[$6];
    var $8 = $1;
    var $9 = $8+20;
    IHEAP[$9] = $7;
    var $10 = $1;
    var $11 = $10+12;
    var $12 = IHEAP[$11];
    var $13 = $bl;
    var $14 = $13+8;
    var $15 = IHEAP[$14];
    var $16 = $15;
    __Z10removevarsP8LexStatei($12, $16);
    var $17 = $bl;
    var $18 = $17+9;
    var $19 = IHEAP[$18];
    var $20 = $19 != 0;
    ;
    if ($20) {
      ;
      var $22 = $1;
      var $23 = $bl;
      var $24 = $23+8;
      var $25 = IHEAP[$24];
      var $26 = $25;
      var $27 = __Z12luaK_codeABCP9FuncState6OpCodeiii($22, 35, $26, 0, 0);
      ;
    }
    var $29 = $1;
    var $30 = $29+50;
    var $31 = IHEAP[$30];
    var $32 = $31;
    var $33 = $1;
    var $34 = $33+36;
    IHEAP[$34] = $32;
    var $35 = $1;
    var $36 = $bl;
    var $37 = $36+4;
    var $38 = IHEAP[$37];
    __Z16luaK_patchtohereP9FuncStatei($35, $38);
    ;
    return;
  }
  __Z10leaveblockP9FuncState.__index__ = Runtime.getFunctionIndex(__Z10leaveblockP9FuncState, "__Z10leaveblockP9FuncState");
  
  
  function __Z10removevarsP8LexStatei($ls, $tolevel) {
    ;
    var __label__;
    var $1;
    var $2;
    var $fs;
    $1 = $ls;
    $2 = $tolevel;
    var $3 = $1;
    var $4 = $3+36;
    var $5 = IHEAP[$4];
    $fs = $5;
    ;
    $6$2: while(1) { // $6
      var $7 = $fs;
      var $8 = $7+50;
      var $9 = IHEAP[$8];
      var $10 = $9;
      var $11 = $2;
      var $12 = $10 > $11;
      if (!($12)) { __label__ = 2; /* $34 */ break $6$2; }
      var $14 = $fs;
      var $15 = $14+24;
      var $16 = IHEAP[$15];
      var $17 = $fs;
      var $18 = $17+50;
      var $19 = IHEAP[$18];
      var $20 = $19 + -1;
      IHEAP[$18] = $20;
      var $21 = $20;
      var $22 = $fs;
      var $23 = $22+172;
      var $24 = $23+$21*2;
      var $25 = IHEAP[$24];
      var $26 = $25;
      var $27 = $fs;
      var $28 = $27;
      var $29 = IHEAP[$28];
      var $30 = $29+24;
      var $31 = IHEAP[$30];
      var $32 = $31+12*$26;
      var $33 = $32+8;
      IHEAP[$33] = $16;
      __label__ = 0; /* $6 */ continue $6$2;
    }
    ;
    return;
  }
  __Z10removevarsP8LexStatei.__index__ = Runtime.getFunctionIndex(__Z10removevarsP8LexStatei, "__Z10removevarsP8LexStatei");
  
  
  function __Z6fornumP8LexStateP7TStringi($ls, $varname, $line) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $fs;
    var $base;
    $1 = $ls;
    $2 = $varname;
    $3 = $line;
    var $4 = $1;
    var $5 = $4+36;
    var $6 = IHEAP[$5];
    $fs = $6;
    var $7 = $fs;
    var $8 = $7+36;
    var $9 = IHEAP[$8];
    $base = $9;
    var $10 = $1;
    var $11 = $1;
    var $12 = __Z14luaX_newstringP8LexStatePKcj($11, __str22151, 11);
    __Z12new_localvarP8LexStateP7TStringi($10, $12, 0);
    var $13 = $1;
    var $14 = $1;
    var $15 = __Z14luaX_newstringP8LexStatePKcj($14, __str23152, 11);
    __Z12new_localvarP8LexStateP7TStringi($13, $15, 1);
    var $16 = $1;
    var $17 = $1;
    var $18 = __Z14luaX_newstringP8LexStatePKcj($17, __str24153, 10);
    __Z12new_localvarP8LexStateP7TStringi($16, $18, 2);
    var $19 = $1;
    var $20 = $2;
    __Z12new_localvarP8LexStateP7TStringi($19, $20, 3);
    var $21 = $1;
    __Z9checknextP8LexStatei($21, 61);
    var $22 = $1;
    var $23 = __Z4exp1P8LexState($22);
    var $24 = $1;
    __Z9checknextP8LexStatei($24, 44);
    var $25 = $1;
    var $26 = __Z4exp1P8LexState($25);
    var $27 = $1;
    var $28 = __Z8testnextP8LexStatei($27, 44);
    var $29 = $28 != 0;
    ;
    if ($29) {
      ;
      var $31 = $1;
      var $32 = __Z4exp1P8LexState($31);
      ;
    }
    else {
      ;
      var $34 = $fs;
      var $35 = $fs;
      var $36 = $35+36;
      var $37 = IHEAP[$36];
      var $38 = $fs;
      var $39 = __Z12luaK_numberKP9FuncStated($38, 1);
      var $40 = __Z12luaK_codeABxP9FuncState6OpCodeij($34, 1, $37, $39);
      var $41 = $fs;
      __Z16luaK_reserveregsP9FuncStatei($41, 1);
      ;
    }
    var $43 = $1;
    var $44 = $base;
    var $45 = $3;
    __Z7forbodyP8LexStateiiii($43, $44, $45, 1, 1);
    ;
    return;
  }
  __Z6fornumP8LexStateP7TStringi.__index__ = Runtime.getFunctionIndex(__Z6fornumP8LexStateP7TStringi, "__Z6fornumP8LexStateP7TStringi");
  
  
  function __Z7forlistP8LexStateP7TString($ls, $indexname) {
    var __stackBase__  = STACKTOP; STACKTOP += 20; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $fs;
    var $e = __stackBase__;
    var $nvars;
    var $line;
    var $base;
    $1 = $ls;
    $2 = $indexname;
    var $3 = $1;
    var $4 = $3+36;
    var $5 = IHEAP[$4];
    $fs = $5;
    $nvars = 0;
    var $6 = $fs;
    var $7 = $6+36;
    var $8 = IHEAP[$7];
    $base = $8;
    var $9 = $1;
    var $10 = $1;
    var $11 = __Z14luaX_newstringP8LexStatePKcj($10, __str19148, 15);
    var $12 = $nvars;
    var $13 = $12 + 1;
    $nvars = $13;
    __Z12new_localvarP8LexStateP7TStringi($9, $11, $12);
    var $14 = $1;
    var $15 = $1;
    var $16 = __Z14luaX_newstringP8LexStatePKcj($15, __str20149, 11);
    var $17 = $nvars;
    var $18 = $17 + 1;
    $nvars = $18;
    __Z12new_localvarP8LexStateP7TStringi($14, $16, $17);
    var $19 = $1;
    var $20 = $1;
    var $21 = __Z14luaX_newstringP8LexStatePKcj($20, __str21150, 13);
    var $22 = $nvars;
    var $23 = $22 + 1;
    $nvars = $23;
    __Z12new_localvarP8LexStateP7TStringi($19, $21, $22);
    var $24 = $1;
    var $25 = $2;
    var $26 = $nvars;
    var $27 = $26 + 1;
    $nvars = $27;
    __Z12new_localvarP8LexStateP7TStringi($24, $25, $26);
    ;
    $28$2: while(1) { // $28
      var $29 = $1;
      var $30 = __Z8testnextP8LexStatei($29, 44);
      var $31 = $30 != 0;
      if (!($31)) { __label__ = 2; /* $38 */ break $28$2; }
      var $33 = $1;
      var $34 = $1;
      var $35 = __Z13str_checknameP8LexState($34);
      var $36 = $nvars;
      var $37 = $36 + 1;
      $nvars = $37;
      __Z12new_localvarP8LexStateP7TStringi($33, $35, $36);
      __label__ = 0; /* $28 */ continue $28$2;
    }
    var $39 = $1;
    __Z9checknextP8LexStatei($39, 267);
    var $40 = $1;
    var $41 = $40+4;
    var $42 = IHEAP[$41];
    $line = $42;
    var $43 = $1;
    var $44 = $1;
    var $45 = __Z8explist1P8LexStateP7expdesc($44, $e);
    __Z13adjust_assignP8LexStateiiP7expdesc($43, 3, $45, $e);
    var $46 = $fs;
    __Z15luaK_checkstackP9FuncStatei($46, 3);
    var $47 = $1;
    var $48 = $base;
    var $49 = $line;
    var $50 = $nvars;
    var $51 = $50 - 3;
    __Z7forbodyP8LexStateiiii($47, $48, $49, $51, 0);
    STACKTOP = __stackBase__;
    return;
  }
  __Z7forlistP8LexStateP7TString.__index__ = Runtime.getFunctionIndex(__Z7forlistP8LexStateP7TString, "__Z7forlistP8LexStateP7TString");
  
  
  function __Z7forbodyP8LexStateiiii($ls, $base, $line, $nvars, $isnum) {
    var __stackBase__  = STACKTOP; STACKTOP += 12; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $4;
    var $5;
    var $bl = __stackBase__;
    var $fs;
    var $prep;
    var $endfor;
    $1 = $ls;
    $2 = $base;
    $3 = $line;
    $4 = $nvars;
    $5 = $isnum;
    var $6 = $1;
    var $7 = $6+36;
    var $8 = IHEAP[$7];
    $fs = $8;
    var $9 = $1;
    __Z15adjustlocalvarsP8LexStatei($9, 3);
    var $10 = $1;
    __Z9checknextP8LexStatei($10, 259);
    var $11 = $5;
    var $12 = $11 != 0;
    ;
    if ($12) {
      ;
      var $14 = $fs;
      var $15 = $2;
      var $16 = __Z12luaK_codeABxP9FuncState6OpCodeij($14, 32, $15, 131070);
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $18 = $fs;
      var $19 = __Z9luaK_jumpP9FuncState($18);
      __lastLabel__ = 2; ;
    }
    var $21 = __lastLabel__ == 0 ? $16 : ($19);
    $prep = $21;
    var $22 = $fs;
    __Z10enterblockP9FuncStateP8BlockCnth($22, $bl, 0);
    var $23 = $1;
    var $24 = $4;
    __Z15adjustlocalvarsP8LexStatei($23, $24);
    var $25 = $fs;
    var $26 = $4;
    __Z16luaK_reserveregsP9FuncStatei($25, $26);
    var $27 = $1;
    __Z5blockP8LexState($27);
    var $28 = $fs;
    __Z10leaveblockP9FuncState($28);
    var $29 = $fs;
    var $30 = $prep;
    __Z16luaK_patchtohereP9FuncStatei($29, $30);
    var $31 = $5;
    var $32 = $31 != 0;
    ;
    if ($32) {
      ;
      var $34 = $fs;
      var $35 = $2;
      var $36 = __Z12luaK_codeABxP9FuncState6OpCodeij($34, 31, $35, 131070);
      __lastLabel__ = 3; ;
    }
    else {
      ;
      var $38 = $fs;
      var $39 = $2;
      var $40 = $4;
      var $41 = __Z12luaK_codeABCP9FuncState6OpCodeiii($38, 33, $39, 0, $40);
      __lastLabel__ = 5; ;
    }
    var $43 = __lastLabel__ == 3 ? $36 : ($41);
    $endfor = $43;
    var $44 = $fs;
    var $45 = $3;
    __Z12luaK_fixlineP9FuncStatei($44, $45);
    var $46 = $fs;
    var $47 = $5;
    var $48 = $47 != 0;
    ;
    if ($48) {
      ;
      var $50 = $endfor;
      __lastLabel__ = 6; ;
    }
    else {
      ;
      var $52 = $fs;
      var $53 = __Z9luaK_jumpP9FuncState($52);
      __lastLabel__ = 8; ;
    }
    var $55 = __lastLabel__ == 6 ? $50 : ($53);
    var $56 = $prep;
    var $57 = $56 + 1;
    __Z14luaK_patchlistP9FuncStateii($46, $55, $57);
    STACKTOP = __stackBase__;
    return;
  }
  __Z7forbodyP8LexStateiiii.__index__ = Runtime.getFunctionIndex(__Z7forbodyP8LexStateiiii, "__Z7forbodyP8LexStateiiii");
  
  
  function __Z4exp1P8LexState($ls) {
    var __stackBase__  = STACKTOP; STACKTOP += 20; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $e = __stackBase__;
    var $k;
    $1 = $ls;
    var $2 = $1;
    __Z4exprP8LexStateP7expdesc($2, $e);
    var $3 = $e;
    var $4 = IHEAP[$3];
    $k = $4;
    var $5 = $1;
    var $6 = $5+36;
    var $7 = IHEAP[$6];
    __Z16luaK_exp2nextregP9FuncStateP7expdesc($7, $e);
    var $8 = $k;
    STACKTOP = __stackBase__;
    return $8;
  }
  __Z4exp1P8LexState.__index__ = Runtime.getFunctionIndex(__Z4exp1P8LexState, "__Z4exp1P8LexState");
  
  
  function __Z14error_expectedP8LexStatei($ls, $token) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $ls;
    $2 = $token;
    var $3 = $1;
    var $4 = $1;
    var $5 = $4+40;
    var $6 = IHEAP[$5];
    var $7 = $1;
    var $8 = $2;
    var $9 = __Z14luaX_token2strP8LexStatei($7, $8);
    var $10 = __Z16luaO_pushfstringP9lua_StatePKcz($6, __str26155, Pointer_make([$9,0,0,0], 0, ALLOC_STACK));
    __Z16luaX_syntaxerrorP8LexStatePKc($3, $10);
    ;
    return;
  }
  __Z14error_expectedP8LexStatei.__index__ = Runtime.getFunctionIndex(__Z14error_expectedP8LexStatei, "__Z14error_expectedP8LexStatei");
  
  
  function __Z15test_then_blockP8LexState($ls) {
    ;
    var __label__;
    var $1;
    var $condexit;
    $1 = $ls;
    var $2 = $1;
    __Z9luaX_nextP8LexState($2);
    var $3 = $1;
    var $4 = __Z4condP8LexState($3);
    $condexit = $4;
    var $5 = $1;
    __Z9checknextP8LexStatei($5, 274);
    var $6 = $1;
    __Z5blockP8LexState($6);
    var $7 = $condexit;
    ;
    return $7;
  }
  __Z15test_then_blockP8LexState.__index__ = Runtime.getFunctionIndex(__Z15test_then_blockP8LexState, "__Z15test_then_blockP8LexState");
  
  
  function __Z12anchor_tokenP8LexState($ls) {
    ;
    var __label__;
    var $1;
    var $ts;
    $1 = $ls;
    var $2 = $1;
    var $3 = $2+12;
    var $4 = $3;
    var $5 = IHEAP[$4];
    var $6 = $5 == 285;
    ;
    $13$7$2: do { 
      if ($6) {
        __label__ = 0; /* $13 */ 
      }
      else {
        ;
        var $8 = $1;
        var $9 = $8+12;
        var $10 = $9;
        var $11 = IHEAP[$10];
        var $12 = $11 == 286;
        if ($12) { __label__ = 0; /* $13 */ break $13$7$2; } else { __label__ = 1; /* $29 */ break $13$7$2; }
      }
    } while(0);
    if (__label__ == 0) {
      var $14 = $1;
      var $15 = $14+12;
      var $16 = $15+4;
      var $17 = $16;
      var $18 = $17;
      var $19 = IHEAP[$18];
      $ts = $19;
      var $20 = $1;
      var $21 = $ts;
      var $22 = $21+16;
      var $23 = $22;
      var $24 = $ts;
      var $25 = $24;
      var $26 = $25+12;
      var $27 = IHEAP[$26];
      var $28 = __Z14luaX_newstringP8LexStatePKcj($20, $23, $27);
      ;
    }
    ;
    return;
  }
  __Z12anchor_tokenP8LexState.__index__ = Runtime.getFunctionIndex(__Z12anchor_tokenP8LexState, "__Z12anchor_tokenP8LexState");
  
  
  function __Z14luaE_newthreadP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $L1;
    var $o2;
    var $o1;
    $1 = $L;
    var $2 = $1;
    var $3 = __Z13luaM_realloc_P9lua_StatePvjj($2, 0, 0, 112);
    var $4 = $3;
    var $5 = $4;
    $L1 = $5;
    var $6 = $1;
    var $7 = $L1;
    var $8 = $7;
    __Z9luaC_linkP9lua_StateP8GCObjecth($6, $8, 8);
    var $9 = $L1;
    var $10 = $1;
    var $11 = $10+16;
    var $12 = IHEAP[$11];
    __Z13preinit_stateP9lua_StateP12global_State($9, $12);
    var $13 = $L1;
    var $14 = $1;
    __Z10stack_initP9lua_StateS0_($13, $14);
    var $15 = $1;
    var $16 = $15+72;
    $o2 = $16;
    var $17 = $L1;
    var $18 = $17+72;
    $o1 = $18;
    var $19 = $o1;
    var $20 = $19;
    var $21 = $o2;
    var $22 = $21;
    var $23 = $20;
    var $24 = $22;
    _llvm_memcpy_p0i8_p0i8_i32($23, $24, 8, 4, 0);
    var $25 = $o2;
    var $26 = $25+8;
    var $27 = IHEAP[$26];
    var $28 = $o1;
    var $29 = $28+8;
    IHEAP[$29] = $27;
    var $30 = $1;
    var $31 = $30+56;
    var $32 = IHEAP[$31];
    var $33 = $L1;
    var $34 = $33+56;
    IHEAP[$34] = $32;
    var $35 = $1;
    var $36 = $35+60;
    var $37 = IHEAP[$36];
    var $38 = $L1;
    var $39 = $38+60;
    IHEAP[$39] = $37;
    var $40 = $1;
    var $41 = $40+68;
    var $42 = IHEAP[$41];
    var $43 = $L1;
    var $44 = $43+68;
    IHEAP[$44] = $42;
    var $45 = $L1;
    var $46 = $45+60;
    var $47 = IHEAP[$46];
    var $48 = $L1;
    var $49 = $48+64;
    IHEAP[$49] = $47;
    var $50 = $L1;
    ;
    return $50;
  }
  __Z14luaE_newthreadP9lua_State.__index__ = Runtime.getFunctionIndex(__Z14luaE_newthreadP9lua_State, "__Z14luaE_newthreadP9lua_State");
  
  
  function __Z13preinit_stateP9lua_StateP12global_State($L, $g) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $L;
    $2 = $g;
    var $3 = $2;
    var $4 = $1;
    var $5 = $4+16;
    IHEAP[$5] = $3;
    var $6 = $1;
    var $7 = $6+32;
    IHEAP[$7] = 0;
    var $8 = $1;
    var $9 = $8+44;
    IHEAP[$9] = 0;
    var $10 = $1;
    var $11 = $10+104;
    IHEAP[$11] = 0;
    var $12 = $1;
    var $13 = $12+68;
    IHEAP[$13] = 0;
    var $14 = $1;
    var $15 = $14+56;
    IHEAP[$15] = 0;
    var $16 = $1;
    var $17 = $16+60;
    IHEAP[$17] = 0;
    var $18 = $1;
    var $19 = $18+57;
    IHEAP[$19] = 1;
    var $20 = $1;
    var $21 = $20+60;
    var $22 = IHEAP[$21];
    var $23 = $1;
    var $24 = $23+64;
    IHEAP[$24] = $22;
    var $25 = $1;
    var $26 = $25+96;
    IHEAP[$26] = 0;
    var $27 = $1;
    var $28 = $27+48;
    IHEAP[$28] = 0;
    var $29 = $1;
    var $30 = $29+54;
    IHEAP[$30] = 0;
    var $31 = $1;
    var $32 = $31+52;
    IHEAP[$32] = 0;
    var $33 = $1;
    var $34 = $33+6;
    IHEAP[$34] = 0;
    var $35 = $1;
    var $36 = $35+20;
    IHEAP[$36] = 0;
    var $37 = $1;
    var $38 = $37+40;
    IHEAP[$38] = 0;
    var $39 = $1;
    var $40 = $39+24;
    IHEAP[$40] = 0;
    var $41 = $1;
    var $42 = $41+108;
    IHEAP[$42] = 0;
    var $43 = $1;
    var $44 = $43+72;
    var $45 = $44+8;
    IHEAP[$45] = 0;
    ;
    return;
  }
  __Z13preinit_stateP9lua_StateP12global_State.__index__ = Runtime.getFunctionIndex(__Z13preinit_stateP9lua_StateP12global_State, "__Z13preinit_stateP9lua_StateP12global_State");
  
  
  function __Z10stack_initP9lua_StateS0_($L1, $L) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $L1;
    $2 = $L;
    var $3 = $2;
    var $4 = __Z13luaM_realloc_P9lua_StatePvjj($3, 0, 0, 192);
    var $5 = $4;
    var $6 = $1;
    var $7 = $6+40;
    IHEAP[$7] = $5;
    var $8 = $1;
    var $9 = $8+40;
    var $10 = IHEAP[$9];
    var $11 = $1;
    var $12 = $11+20;
    IHEAP[$12] = $10;
    var $13 = $1;
    var $14 = $13+48;
    IHEAP[$14] = 8;
    var $15 = $1;
    var $16 = $15+40;
    var $17 = IHEAP[$16];
    var $18 = $1;
    var $19 = $18+48;
    var $20 = IHEAP[$19];
    var $21 = $17+24*$20;
    var $22 = $21+-24;
    var $23 = $1;
    var $24 = $23+36;
    IHEAP[$24] = $22;
    var $25 = $2;
    var $26 = __Z13luaM_realloc_P9lua_StatePvjj($25, 0, 0, 540);
    var $27 = $26;
    var $28 = $1;
    var $29 = $28+32;
    IHEAP[$29] = $27;
    var $30 = $1;
    var $31 = $30+44;
    IHEAP[$31] = 45;
    var $32 = $1;
    var $33 = $32+32;
    var $34 = IHEAP[$33];
    var $35 = $1;
    var $36 = $35+8;
    IHEAP[$36] = $34;
    var $37 = $1;
    var $38 = $37+32;
    var $39 = IHEAP[$38];
    var $40 = $1;
    var $41 = $40+44;
    var $42 = IHEAP[$41];
    var $43 = $42 - 5;
    var $44 = $39+12*$43;
    var $45 = $44+-12;
    var $46 = $1;
    var $47 = $46+28;
    IHEAP[$47] = $45;
    var $48 = $1;
    var $49 = $48+8;
    var $50 = IHEAP[$49];
    var $51 = $1;
    var $52 = $51+20;
    var $53 = IHEAP[$52];
    var $54 = $53+4;
    IHEAP[$54] = $50;
    var $55 = $1;
    var $56 = $55+8;
    var $57 = IHEAP[$56];
    var $58 = $57+12;
    IHEAP[$56] = $58;
    var $59 = $57+8;
    IHEAP[$59] = 0;
    var $60 = $1;
    var $61 = $60+8;
    var $62 = IHEAP[$61];
    var $63 = $1;
    var $64 = $63+20;
    var $65 = IHEAP[$64];
    var $66 = $65;
    IHEAP[$66] = $62;
    var $67 = $1;
    var $68 = $67+12;
    IHEAP[$68] = $62;
    var $69 = $1;
    var $70 = $69+8;
    var $71 = IHEAP[$70];
    var $72 = $71+240;
    var $73 = $1;
    var $74 = $73+20;
    var $75 = IHEAP[$74];
    var $76 = $75+8;
    IHEAP[$76] = $72;
    ;
    return;
  }
  __Z10stack_initP9lua_StateS0_.__index__ = Runtime.getFunctionIndex(__Z10stack_initP9lua_StateS0_, "__Z10stack_initP9lua_StateS0_");
  
  
  function __Z15luaE_freethreadP9lua_StateS0_($L, $L1) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $L;
    $2 = $L1;
    var $3 = $2;
    var $4 = $2;
    var $5 = $4+32;
    var $6 = IHEAP[$5];
    __Z10luaF_closeP9lua_StateP10lua_TValue($3, $6);
    var $7 = $1;
    var $8 = $2;
    __Z9freestackP9lua_StateS0_($7, $8);
    var $9 = $1;
    var $10 = $2;
    var $11 = $10;
    var $12 = $11;
    var $13 = __Z13luaM_realloc_P9lua_StatePvjj($9, $12, 112, 0);
    ;
    return;
  }
  __Z15luaE_freethreadP9lua_StateS0_.__index__ = Runtime.getFunctionIndex(__Z15luaE_freethreadP9lua_StateS0_, "__Z15luaE_freethreadP9lua_StateS0_");
  
  
  function __Z9freestackP9lua_StateS0_($L, $L1) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $L;
    $2 = $L1;
    var $3 = $1;
    var $4 = $2;
    var $5 = $4+40;
    var $6 = IHEAP[$5];
    var $7 = $6;
    var $8 = $2;
    var $9 = $8+48;
    var $10 = IHEAP[$9];
    var $11 = $10 * 24;
    var $12 = __Z13luaM_realloc_P9lua_StatePvjj($3, $7, $11, 0);
    var $13 = $1;
    var $14 = $2;
    var $15 = $14+32;
    var $16 = IHEAP[$15];
    var $17 = $16;
    var $18 = $2;
    var $19 = $18+44;
    var $20 = IHEAP[$19];
    var $21 = $20 * 12;
    var $22 = __Z13luaM_realloc_P9lua_StatePvjj($13, $17, $21, 0);
    ;
    return;
  }
  __Z9freestackP9lua_StateS0_.__index__ = Runtime.getFunctionIndex(__Z9freestackP9lua_StateS0_, "__Z9freestackP9lua_StateS0_");
  
  
  function __Z12lua_newstatePFPvS_S_jjES_($f, $ud) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $i;
    var $L;
    var $g;
    var $l;
    $2 = $f;
    $3 = $ud;
    var $4 = $2;
    var $5 = $3;
    var $6 = FUNCTION_TABLE[$4]($5, 0, 0, 348);
    $l = $6;
    var $7 = $l;
    var $8 = $7 == 0;
    ;
    if ($8) {
      ;
      $1 = 0;
      ;
    }
    else {
      ;
      var $11 = $l;
      var $12 = $11;
      var $13 = $12;
      $L = $13;
      var $14 = $L;
      var $15 = $14;
      var $16 = $15+112;
      $g = $16;
      var $17 = $L;
      var $18 = $17;
      IHEAP[$18] = 0;
      var $19 = $L;
      var $20 = $19+4;
      IHEAP[$20] = 8;
      var $21 = $g;
      var $22 = $21+20;
      IHEAP[$22] = 33;
      var $23 = $g;
      var $24 = $23+20;
      var $25 = IHEAP[$24];
      var $26 = $25;
      var $27 = $26 & 3;
      var $28 = $27;
      var $29 = $L;
      var $30 = $29+5;
      IHEAP[$30] = $28;
      var $31 = $L;
      var $32 = $31+5;
      var $33 = IHEAP[$32];
      var $34 = $33;
      var $35 = $34 | 96;
      var $36 = $35;
      IHEAP[$32] = $36;
      var $37 = $L;
      var $38 = $g;
      __Z13preinit_stateP9lua_StateP12global_State($37, $38);
      var $39 = $2;
      var $40 = $g;
      var $41 = $40+12;
      IHEAP[$41] = $39;
      var $42 = $3;
      var $43 = $g;
      var $44 = $43+16;
      IHEAP[$44] = $42;
      var $45 = $L;
      var $46 = $g;
      var $47 = $46+104;
      IHEAP[$47] = $45;
      var $48 = $g;
      var $49 = $48+108;
      var $50 = $g;
      var $51 = $50+108;
      var $52 = $51+12;
      var $53 = $52;
      var $54 = $53;
      var $55 = $54;
      IHEAP[$55] = $49;
      var $56 = $g;
      var $57 = $56+108;
      var $58 = $g;
      var $59 = $58+108;
      var $60 = $59+12;
      var $61 = $60;
      var $62 = $61;
      var $63 = $62+4;
      IHEAP[$63] = $57;
      var $64 = $g;
      var $65 = $64+64;
      IHEAP[$65] = 0;
      var $66 = $g;
      var $67 = $66;
      var $68 = $67+8;
      IHEAP[$68] = 0;
      var $69 = $g;
      var $70 = $69;
      var $71 = $70+4;
      IHEAP[$71] = 0;
      var $72 = $g;
      var $73 = $72;
      var $74 = $73;
      IHEAP[$74] = 0;
      var $75 = $L;
      var $76 = $75+16;
      var $77 = IHEAP[$76];
      var $78 = $77+92;
      var $79 = $78+8;
      IHEAP[$79] = 0;
      var $80 = $g;
      var $81 = $80+52;
      var $82 = $81;
      IHEAP[$82] = 0;
      var $83 = $g;
      var $84 = $83+52;
      var $85 = $84+8;
      IHEAP[$85] = 0;
      var $86 = $g;
      var $87 = $86+88;
      IHEAP[$87] = 0;
      var $88 = $g;
      var $89 = $88+21;
      IHEAP[$89] = 0;
      var $90 = $L;
      var $91 = $90;
      var $92 = $g;
      var $93 = $92+28;
      IHEAP[$93] = $91;
      var $94 = $g;
      var $95 = $94+24;
      IHEAP[$95] = 0;
      var $96 = $g;
      var $97 = $96+28;
      var $98 = $g;
      var $99 = $98+32;
      IHEAP[$99] = $97;
      var $100 = $g;
      var $101 = $100+36;
      IHEAP[$101] = 0;
      var $102 = $g;
      var $103 = $102+40;
      IHEAP[$103] = 0;
      var $104 = $g;
      var $105 = $104+44;
      IHEAP[$105] = 0;
      var $106 = $g;
      var $107 = $106+48;
      IHEAP[$107] = 0;
      var $108 = $g;
      var $109 = $108+68;
      IHEAP[$109] = 348;
      var $110 = $g;
      var $111 = $110+80;
      IHEAP[$111] = 200;
      var $112 = $g;
      var $113 = $112+84;
      IHEAP[$113] = 200;
      var $114 = $g;
      var $115 = $114+76;
      IHEAP[$115] = 0;
      $i = 0;
      ;
      $116$5: while(1) { // $116
        var $117 = $i;
        var $118 = $117 < 9;
        if (!($118)) { __label__ = 3; /* $127 */ break $116$5; }
        var $120 = $i;
        var $121 = $g;
        var $122 = $121+132;
        var $123 = $122+$120*4;
        IHEAP[$123] = 0;
        ;
        var $125 = $i;
        var $126 = $125 + 1;
        $i = $126;
        __label__ = 1; /* $116 */ continue $116$5;
      }
      var $128 = $L;
      var $129 = __Z20luaD_rawrunprotectedP9lua_StatePFvS0_PvES1_($128, __Z9f_luaopenP9lua_StatePv.__index__, 0);
      var $130 = $129 != 0;
      ;
      if ($130) {
        ;
        var $132 = $L;
        __Z11close_stateP9lua_State($132);
        $L = 0;
        ;
      }
      else {
        ;
        ;
      }
      var $135 = $L;
      $1 = $135;
      ;
    }
    var $137 = $1;
    ;
    return $137;
  }
  __Z12lua_newstatePFPvS_S_jjES_.__index__ = Runtime.getFunctionIndex(__Z12lua_newstatePFPvS_S_jjES_, "__Z12lua_newstatePFPvS_S_jjES_");
  
  
  function __Z9f_luaopenP9lua_StatePv($L, $ud) {
    ;
    var __label__;
    var $1;
    var $2;
    var $g;
    var $i_o;
    var $i_o1;
    $1 = $L;
    $2 = $ud;
    var $3 = $1;
    var $4 = $3+16;
    var $5 = IHEAP[$4];
    $g = $5;
    var $6 = $1;
    var $7 = $1;
    __Z10stack_initP9lua_StateS0_($6, $7);
    var $8 = $1;
    var $9 = $8+72;
    $i_o = $9;
    var $10 = $1;
    var $11 = __Z8luaH_newP9lua_Stateii($10, 0, 2);
    var $12 = $11;
    var $13 = $i_o;
    var $14 = $13;
    var $15 = $14;
    var $16 = $15;
    IHEAP[$16] = $12;
    var $17 = $i_o;
    var $18 = $17+8;
    IHEAP[$18] = 5;
    var $19 = $1;
    var $20 = $19+16;
    var $21 = IHEAP[$20];
    var $22 = $21+92;
    $i_o1 = $22;
    var $23 = $1;
    var $24 = __Z8luaH_newP9lua_Stateii($23, 0, 2);
    var $25 = $24;
    var $26 = $i_o1;
    var $27 = $26;
    var $28 = $27;
    var $29 = $28;
    IHEAP[$29] = $25;
    var $30 = $i_o1;
    var $31 = $30+8;
    IHEAP[$31] = 5;
    var $32 = $1;
    __Z11luaS_resizeP9lua_Statei($32, 32);
    var $33 = $1;
    __Z9luaT_initP9lua_State($33);
    var $34 = $1;
    __Z9luaX_initP9lua_State($34);
    var $35 = $1;
    var $36 = __Z12luaS_newlstrP9lua_StatePKcj($35, __str158, 17);
    var $37 = $36;
    var $38 = $37+5;
    var $39 = IHEAP[$38];
    var $40 = $39;
    var $41 = $40 | 32;
    var $42 = $41;
    IHEAP[$38] = $42;
    var $43 = $g;
    var $44 = $43+68;
    var $45 = IHEAP[$44];
    var $46 = 4 * $45;
    var $47 = $g;
    var $48 = $47+64;
    IHEAP[$48] = $46;
    ;
    return;
  }
  __Z9f_luaopenP9lua_StatePv.__index__ = Runtime.getFunctionIndex(__Z9f_luaopenP9lua_StatePv, "__Z9f_luaopenP9lua_StatePv");
  
  
  function __Z11close_stateP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $g;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+16;
    var $4 = IHEAP[$3];
    $g = $4;
    var $5 = $1;
    var $6 = $1;
    var $7 = $6+32;
    var $8 = IHEAP[$7];
    __Z10luaF_closeP9lua_StateP10lua_TValue($5, $8);
    var $9 = $1;
    __Z12luaC_freeallP9lua_State($9);
    var $10 = $1;
    var $11 = $1;
    var $12 = $11+16;
    var $13 = IHEAP[$12];
    var $14 = $13;
    var $15 = $14;
    var $16 = IHEAP[$15];
    var $17 = $16;
    var $18 = $1;
    var $19 = $18+16;
    var $20 = IHEAP[$19];
    var $21 = $20;
    var $22 = $21+8;
    var $23 = IHEAP[$22];
    var $24 = $23 * 4;
    var $25 = __Z13luaM_realloc_P9lua_StatePvjj($10, $17, $24, 0);
    var $26 = $1;
    var $27 = $g;
    var $28 = $27+52;
    var $29 = $28;
    var $30 = IHEAP[$29];
    var $31 = $g;
    var $32 = $31+52;
    var $33 = $32+8;
    var $34 = IHEAP[$33];
    var $35 = $34 * 1;
    var $36 = __Z13luaM_realloc_P9lua_StatePvjj($26, $30, $35, 0);
    var $37 = $g;
    var $38 = $37+52;
    var $39 = $38;
    IHEAP[$39] = $36;
    var $40 = $g;
    var $41 = $40+52;
    var $42 = $41+8;
    IHEAP[$42] = 0;
    var $43 = $1;
    var $44 = $1;
    __Z9freestackP9lua_StateS0_($43, $44);
    var $45 = $g;
    var $46 = $45+12;
    var $47 = IHEAP[$46];
    var $48 = $g;
    var $49 = $48+16;
    var $50 = IHEAP[$49];
    var $51 = $1;
    var $52 = $51;
    var $53 = $52;
    var $54 = FUNCTION_TABLE[$47]($50, $53, 348, 0);
    ;
    return;
  }
  __Z11close_stateP9lua_State.__index__ = Runtime.getFunctionIndex(__Z11close_stateP9lua_State, "__Z11close_stateP9lua_State");
  
  
  function __Z9lua_closeP9lua_State($L) {
    ;
    var __label__;
    var $1;
    $1 = $L;
    var $2 = $1;
    var $3 = $2+16;
    var $4 = IHEAP[$3];
    var $5 = $4+104;
    var $6 = IHEAP[$5];
    $1 = $6;
    var $7 = $1;
    var $8 = $1;
    var $9 = $8+32;
    var $10 = IHEAP[$9];
    __Z10luaF_closeP9lua_StateP10lua_TValue($7, $10);
    var $11 = $1;
    var $12 = __Z18luaC_separateudataP9lua_Statei($11, 1);
    var $13 = $1;
    var $14 = $13+108;
    IHEAP[$14] = 0;
    ;
    $15$2: while(1) { // $15
      var $16 = $1;
      var $17 = $16+40;
      var $18 = IHEAP[$17];
      var $19 = $1;
      var $20 = $19+20;
      IHEAP[$20] = $18;
      var $21 = $1;
      var $22 = $21+20;
      var $23 = IHEAP[$22];
      var $24 = $23;
      var $25 = IHEAP[$24];
      var $26 = $1;
      var $27 = $26+8;
      IHEAP[$27] = $25;
      var $28 = $1;
      var $29 = $28+12;
      IHEAP[$29] = $25;
      var $30 = $1;
      var $31 = $30+54;
      IHEAP[$31] = 0;
      var $32 = $1;
      var $33 = $32+52;
      IHEAP[$33] = 0;
      ;
      var $35 = $1;
      var $36 = __Z20luaD_rawrunprotectedP9lua_StatePFvS0_PvES1_($35, __Z11callallgcTMP9lua_StatePv.__index__, 0);
      var $37 = $36 != 0;
      if ($37) { __label__ = 0; /* $15 */ continue $15$2; } else { __label__ = 2; /* $38 */ break $15$2; }
    }
    var $39 = $1;
    __Z11close_stateP9lua_State($39);
    ;
    return;
  }
  __Z9lua_closeP9lua_State.__index__ = Runtime.getFunctionIndex(__Z9lua_closeP9lua_State, "__Z9lua_closeP9lua_State");
  
  
  function __Z11callallgcTMP9lua_StatePv($L, $ud) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $L;
    $2 = $ud;
    var $3 = $1;
    __Z13luaC_callGCTMP9lua_State($3);
    ;
    return;
  }
  __Z11callallgcTMP9lua_StatePv.__index__ = Runtime.getFunctionIndex(__Z11callallgcTMP9lua_StatePv, "__Z11callallgcTMP9lua_StatePv");
  
  
  function __Z11luaS_resizeP9lua_Statei($L, $newsize) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $newhash;
    var $tb;
    var $i;
    var $p;
    var $next;
    var $h;
    var $h1;
    $1 = $L;
    $2 = $newsize;
    var $3 = $1;
    var $4 = $3+16;
    var $5 = IHEAP[$4];
    var $6 = $5+21;
    var $7 = IHEAP[$6];
    var $8 = $7;
    var $9 = $8 == 2;
    ;
    if ($9) {
      ;
      ;
    }
    else {
      ;
      var $12 = $2;
      var $13 = $12 + 1;
      var $14 = unSign($13, 32) <= unSign(1073741823, 32);
      ;
      if ($14) {
        ;
        var $16 = $1;
        var $17 = $2;
        var $18 = $17 * 4;
        var $19 = __Z13luaM_realloc_P9lua_StatePvjj($16, 0, 0, $18);
        __lastLabel__ = 1; ;
      }
      else {
        ;
        var $21 = $1;
        var $22 = __Z11luaM_toobigP9lua_State($21);
        __lastLabel__ = 3; ;
      }
      var $24 = __lastLabel__ == 1 ? $19 : ($22);
      var $25 = $24;
      $newhash = $25;
      var $26 = $1;
      var $27 = $26+16;
      var $28 = IHEAP[$27];
      var $29 = $28;
      $tb = $29;
      $i = 0;
      ;
      $30$9: while(1) { // $30
        var $31 = $i;
        var $32 = $2;
        var $33 = $31 < $32;
        if (!($33)) { __label__ = 6; /* $41 */ break $30$9; }
        var $35 = $i;
        var $36 = $newhash;
        var $37 = $36+4*$35;
        IHEAP[$37] = 0;
        ;
        var $39 = $i;
        var $40 = $39 + 1;
        $i = $40;
        __label__ = 4; /* $30 */ continue $30$9;
      }
      $i = 0;
      ;
      $42$14: while(1) { // $42
        var $43 = $i;
        var $44 = $tb;
        var $45 = $44+8;
        var $46 = IHEAP[$45];
        var $47 = $43 < $46;
        if (!($47)) { __label__ = 10; /* $91 */ break $42$14; }
        var $49 = $i;
        var $50 = $tb;
        var $51 = $50;
        var $52 = IHEAP[$51];
        var $53 = $52+4*$49;
        var $54 = IHEAP[$53];
        $p = $54;
        ;
        $55$17: while(1) { // $55
          var $56 = $p;
          var $57 = $56 != 0;
          if (!($57)) { __label__ = 13; /* $87 */ break $55$17; }
          var $59 = $p;
          var $60 = $59;
          var $61 = $60;
          var $62 = $61;
          var $63 = IHEAP[$62];
          $next = $63;
          var $64 = $p;
          var $65 = $64;
          var $66 = $65;
          var $67 = $66;
          var $68 = $67+8;
          var $69 = IHEAP[$68];
          $h = $69;
          var $70 = $h;
          var $71 = $2;
          var $72 = $71 - 1;
          var $73 = $70 & $72;
          $h1 = $73;
          var $74 = $h1;
          var $75 = $newhash;
          var $76 = $75+4*$74;
          var $77 = IHEAP[$76];
          var $78 = $p;
          var $79 = $78;
          var $80 = $79;
          var $81 = $80;
          IHEAP[$81] = $77;
          var $82 = $p;
          var $83 = $h1;
          var $84 = $newhash;
          var $85 = $84+4*$83;
          IHEAP[$85] = $82;
          var $86 = $next;
          $p = $86;
          __label__ = 11; /* $55 */ continue $55$17;
        }
        ;
        var $89 = $i;
        var $90 = $89 + 1;
        $i = $90;
        __label__ = 8; /* $42 */ continue $42$14;
      }
      var $92 = $1;
      var $93 = $tb;
      var $94 = $93;
      var $95 = IHEAP[$94];
      var $96 = $95;
      var $97 = $tb;
      var $98 = $97+8;
      var $99 = IHEAP[$98];
      var $100 = $99 * 4;
      var $101 = __Z13luaM_realloc_P9lua_StatePvjj($92, $96, $100, 0);
      var $102 = $2;
      var $103 = $tb;
      var $104 = $103+8;
      IHEAP[$104] = $102;
      var $105 = $newhash;
      var $106 = $tb;
      var $107 = $106;
      IHEAP[$107] = $105;
      ;
    }
    ;
    return;
  }
  __Z11luaS_resizeP9lua_Statei.__index__ = Runtime.getFunctionIndex(__Z11luaS_resizeP9lua_Statei, "__Z11luaS_resizeP9lua_Statei");
  
  
  function __Z12luaS_newlstrP9lua_StatePKcj($L, $str, $l) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $o;
    var $h;
    var $step;
    var $l1;
    var $ts;
    $2 = $L;
    $3 = $str;
    $4 = $l;
    var $5 = $4;
    $h = $5;
    var $6 = $4;
    var $7 = $6 >> 5;
    var $8 = $7 + 1;
    $step = $8;
    var $9 = $4;
    $l1 = $9;
    ;
    $10$2: while(1) { // $10
      var $11 = $l1;
      var $12 = $step;
      var $13 = unSign($11, 32) >= unSign($12, 32);
      if (!($13)) { __label__ = 2; /* $33 */ break $10$2; }
      var $15 = $h;
      var $16 = $h;
      var $17 = $16 << 5;
      var $18 = $h;
      var $19 = $18 >> 2;
      var $20 = $17 + $19;
      var $21 = $l1;
      var $22 = $21 - 1;
      var $23 = $3;
      var $24 = $23+$22;
      var $25 = IHEAP[$24];
      var $26 = $25;
      var $27 = $20 + $26;
      var $28 = $15 ^ $27;
      $h = $28;
      ;
      var $30 = $step;
      var $31 = $l1;
      var $32 = $31 - $30;
      $l1 = $32;
      __label__ = 0; /* $10 */ continue $10$2;
    }
    var $34 = $h;
    var $35 = $2;
    var $36 = $35+16;
    var $37 = IHEAP[$36];
    var $38 = $37;
    var $39 = $38+8;
    var $40 = IHEAP[$39];
    var $41 = $40 - 1;
    var $42 = $34 & $41;
    var $43 = $2;
    var $44 = $43+16;
    var $45 = IHEAP[$44];
    var $46 = $45;
    var $47 = $46;
    var $48 = IHEAP[$47];
    var $49 = $48+4*$42;
    var $50 = IHEAP[$49];
    $o = $50;
    ;
    $51$7: while(1) { // $51
      var $52 = $o;
      var $53 = $52 != 0;
      if (!($53)) { __label__ = 6; /* $107 */ break $51$7; }
      var $55 = $o;
      var $56 = $55;
      var $57 = $56;
      $ts = $57;
      var $58 = $ts;
      var $59 = $58;
      var $60 = $59+12;
      var $61 = IHEAP[$60];
      var $62 = $4;
      var $63 = $61 == $62;
      ;
      if ($63) {
        ;
        var $65 = $3;
        var $66 = $ts;
        var $67 = $66+16;
        var $68 = $67;
        var $69 = $4;
        var $70 = _memcmp($65, $68, $69);
        var $71 = $70 == 0;
        if ($71) { __label__ = 7; /* $72 */ break $51$7; }
      }
      ;
      var $102 = $o;
      var $103 = $102;
      var $104 = $103;
      var $105 = $104;
      var $106 = IHEAP[$105];
      $o = $106;
      __label__ = 4; /* $51 */ continue $51$7;
    }
    if (__label__ == 6) {
      var $108 = $2;
      var $109 = $3;
      var $110 = $4;
      var $111 = $h;
      var $112 = __Z7newlstrP9lua_StatePKcjj($108, $109, $110, $111);
      $1 = $112;
      ;
    }
    else if (__label__ == 7) {
      var $73 = $o;
      var $74 = $73;
      var $75 = $74;
      var $76 = $75+5;
      var $77 = IHEAP[$76];
      var $78 = $77;
      var $79 = $2;
      var $80 = $79+16;
      var $81 = IHEAP[$80];
      var $82 = $81+20;
      var $83 = IHEAP[$82];
      var $84 = $83;
      var $85 = $84 ^ 3;
      var $86 = $78 & $85;
      var $87 = $86 & 3;
      var $88 = $87 != 0;
      ;
      if ($88) {
        ;
        var $90 = $o;
        var $91 = $90;
        var $92 = $91;
        var $93 = $92+5;
        var $94 = IHEAP[$93];
        var $95 = $94;
        var $96 = $95 ^ 3;
        var $97 = $96;
        IHEAP[$93] = $97;
        ;
      }
      var $99 = $ts;
      $1 = $99;
      ;
    }
    var $114 = $1;
    ;
    return $114;
  }
  __Z12luaS_newlstrP9lua_StatePKcj.__index__ = Runtime.getFunctionIndex(__Z12luaS_newlstrP9lua_StatePKcj, "__Z12luaS_newlstrP9lua_StatePKcj");
  
  
  function __Z7newlstrP9lua_StatePKcjj($L, $str, $l, $h) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $ts;
    var $tb;
    $1 = $L;
    $2 = $str;
    $3 = $l;
    $4 = $h;
    var $5 = $3;
    var $6 = $5 + 1;
    var $7 = unSign($6, 32) > unSign(-19, 32);
    ;
    if ($7) {
      ;
      var $9 = $1;
      var $10 = __Z11luaM_toobigP9lua_State($9);
      ;
    }
    var $12 = $1;
    var $13 = $3;
    var $14 = $13 + 1;
    var $15 = $14 * 1;
    var $16 = $15 + 16;
    var $17 = __Z13luaM_realloc_P9lua_StatePvjj($12, 0, 0, $16);
    var $18 = $17;
    $ts = $18;
    var $19 = $3;
    var $20 = $ts;
    var $21 = $20;
    var $22 = $21+12;
    IHEAP[$22] = $19;
    var $23 = $4;
    var $24 = $ts;
    var $25 = $24;
    var $26 = $25+8;
    IHEAP[$26] = $23;
    var $27 = $1;
    var $28 = $27+16;
    var $29 = IHEAP[$28];
    var $30 = $29+20;
    var $31 = IHEAP[$30];
    var $32 = $31;
    var $33 = $32 & 3;
    var $34 = $33;
    var $35 = $ts;
    var $36 = $35;
    var $37 = $36+5;
    IHEAP[$37] = $34;
    var $38 = $ts;
    var $39 = $38;
    var $40 = $39+4;
    IHEAP[$40] = 4;
    var $41 = $ts;
    var $42 = $41;
    var $43 = $42+6;
    IHEAP[$43] = 0;
    var $44 = $ts;
    var $45 = $44+16;
    var $46 = $45;
    var $47 = $2;
    var $48 = $3;
    var $49 = $48 * 1;
    _llvm_memcpy_p0i8_p0i8_i32($46, $47, $49, 1, 0);
    var $50 = $3;
    var $51 = $ts;
    var $52 = $51+16;
    var $53 = $52;
    var $54 = $53+$50;
    IHEAP[$54] = 0;
    var $55 = $1;
    var $56 = $55+16;
    var $57 = IHEAP[$56];
    var $58 = $57;
    $tb = $58;
    var $59 = $4;
    var $60 = $tb;
    var $61 = $60+8;
    var $62 = IHEAP[$61];
    var $63 = $62 - 1;
    var $64 = $59 & $63;
    $4 = $64;
    var $65 = $4;
    var $66 = $tb;
    var $67 = $66;
    var $68 = IHEAP[$67];
    var $69 = $68+4*$65;
    var $70 = IHEAP[$69];
    var $71 = $ts;
    var $72 = $71;
    var $73 = $72;
    IHEAP[$73] = $70;
    var $74 = $ts;
    var $75 = $74;
    var $76 = $4;
    var $77 = $tb;
    var $78 = $77;
    var $79 = IHEAP[$78];
    var $80 = $79+4*$76;
    IHEAP[$80] = $75;
    var $81 = $tb;
    var $82 = $81+4;
    var $83 = IHEAP[$82];
    var $84 = $83 + 1;
    IHEAP[$82] = $84;
    var $85 = $tb;
    var $86 = $85+4;
    var $87 = IHEAP[$86];
    var $88 = $tb;
    var $89 = $88+8;
    var $90 = IHEAP[$89];
    var $91 = unSign($87, 32) > unSign($90, 32);
    ;
    $92$103$5: do { 
      if ($91) {
        ;
        var $93 = $tb;
        var $94 = $93+8;
        var $95 = IHEAP[$94];
        var $96 = $95 <= 1073741822;
        if (!($96)) { __label__ = 2; /* $103 */ break $92$103$5; }
        var $98 = $1;
        var $99 = $tb;
        var $100 = $99+8;
        var $101 = IHEAP[$100];
        var $102 = $101 * 2;
        __Z11luaS_resizeP9lua_Statei($98, $102);
        ;
      }
    } while(0);
    var $104 = $ts;
    ;
    return $104;
  }
  __Z7newlstrP9lua_StatePKcjj.__index__ = Runtime.getFunctionIndex(__Z7newlstrP9lua_StatePKcjj, "__Z7newlstrP9lua_StatePKcjj");
  
  
  function __Z13luaS_newudataP9lua_StatejP5Table($L, $s, $e) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $u;
    $1 = $L;
    $2 = $s;
    $3 = $e;
    var $4 = $2;
    var $5 = unSign($4, 32) > unSign(-23, 32);
    ;
    if ($5) {
      ;
      var $7 = $1;
      var $8 = __Z11luaM_toobigP9lua_State($7);
      ;
    }
    var $10 = $1;
    var $11 = $2;
    var $12 = $11 + 20;
    var $13 = __Z13luaM_realloc_P9lua_StatePvjj($10, 0, 0, $12);
    var $14 = $13;
    $u = $14;
    var $15 = $1;
    var $16 = $15+16;
    var $17 = IHEAP[$16];
    var $18 = $17+20;
    var $19 = IHEAP[$18];
    var $20 = $19;
    var $21 = $20 & 3;
    var $22 = $21;
    var $23 = $u;
    var $24 = $23;
    var $25 = $24+5;
    IHEAP[$25] = $22;
    var $26 = $u;
    var $27 = $26;
    var $28 = $27+4;
    IHEAP[$28] = 7;
    var $29 = $2;
    var $30 = $u;
    var $31 = $30;
    var $32 = $31+16;
    IHEAP[$32] = $29;
    var $33 = $u;
    var $34 = $33;
    var $35 = $34+8;
    IHEAP[$35] = 0;
    var $36 = $3;
    var $37 = $u;
    var $38 = $37;
    var $39 = $38+12;
    IHEAP[$39] = $36;
    var $40 = $1;
    var $41 = $40+16;
    var $42 = IHEAP[$41];
    var $43 = $42+104;
    var $44 = IHEAP[$43];
    var $45 = $44;
    var $46 = IHEAP[$45];
    var $47 = $u;
    var $48 = $47;
    var $49 = $48;
    IHEAP[$49] = $46;
    var $50 = $u;
    var $51 = $50;
    var $52 = $1;
    var $53 = $52+16;
    var $54 = IHEAP[$53];
    var $55 = $54+104;
    var $56 = IHEAP[$55];
    var $57 = $56;
    IHEAP[$57] = $51;
    var $58 = $u;
    ;
    return $58;
  }
  __Z13luaS_newudataP9lua_StatejP5Table.__index__ = Runtime.getFunctionIndex(__Z13luaS_newudataP9lua_StatejP5Table, "__Z13luaS_newudataP9lua_StatejP5Table");
  
  
  function __Z9luaH_nextP9lua_StateP5TableP10lua_TValue($L, $t, $key) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $i;
    var $i_o;
    var $o2;
    var $o1;
    var $o21;
    var $o12;
    var $o23;
    var $o14;
    $2 = $L;
    $3 = $t;
    $4 = $key;
    var $5 = $2;
    var $6 = $3;
    var $7 = $4;
    var $8 = __Z9findindexP9lua_StateP5TableP10lua_TValue($5, $6, $7);
    $i = $8;
    var $9 = $i;
    var $10 = $9 + 1;
    $i = $10;
    ;
    $11$2: while(1) { // $11
      var $12 = $i;
      var $13 = $3;
      var $14 = $13+28;
      var $15 = IHEAP[$14];
      var $16 = $12 < $15;
      if (!($16)) { __label__ = 2; /* $58 */ break $11$2; }
      var $18 = $i;
      var $19 = $3;
      var $20 = $19+12;
      var $21 = IHEAP[$20];
      var $22 = $21+12*$18;
      var $23 = $22+8;
      var $24 = IHEAP[$23];
      var $25 = $24 == 0;
      if (!($25)) { __label__ = 4; /* $26 */ break $11$2; }
      ;
      var $56 = $i;
      var $57 = $56 + 1;
      $i = $57;
      __label__ = 0; /* $11 */ continue $11$2;
    }
    if (__label__ == 2) {
      var $59 = $3;
      var $60 = $59+28;
      var $61 = IHEAP[$60];
      var $62 = $i;
      var $63 = $62 - $61;
      $i = $63;
      ;
      $64$9: while(1) { // $64
        var $65 = $i;
        var $66 = $3;
        var $67 = $66+7;
        var $68 = IHEAP[$67];
        var $69 = $68;
        var $70 = 1 << $69;
        var $71 = $65 < $70;
        if (!($71)) { __label__ = 9; /* $126 */ break $64$9; }
        var $73 = $i;
        var $74 = $3;
        var $75 = $74+16;
        var $76 = IHEAP[$75];
        var $77 = $76+28*$73;
        var $78 = $77;
        var $79 = $78+8;
        var $80 = IHEAP[$79];
        var $81 = $80 == 0;
        if (!($81)) { __label__ = 11; /* $82 */ break $64$9; }
        ;
        var $124 = $i;
        var $125 = $124 + 1;
        $i = $125;
        __label__ = 7; /* $64 */ continue $64$9;
      }
      if (__label__ == 9) {
        $1 = 0;
        ;
      }
      else if (__label__ == 11) {
        var $83 = $i;
        var $84 = $3;
        var $85 = $84+16;
        var $86 = IHEAP[$85];
        var $87 = $86+28*$83;
        var $88 = $87+12;
        var $89 = $88;
        var $90 = $89;
        $o21 = $90;
        var $91 = $4;
        $o12 = $91;
        var $92 = $o12;
        var $93 = $92;
        var $94 = $o21;
        var $95 = $94;
        var $96 = $93;
        var $97 = $95;
        _llvm_memcpy_p0i8_p0i8_i32($96, $97, 8, 4, 0);
        var $98 = $o21;
        var $99 = $98+8;
        var $100 = IHEAP[$99];
        var $101 = $o12;
        var $102 = $101+8;
        IHEAP[$102] = $100;
        var $103 = $i;
        var $104 = $3;
        var $105 = $104+16;
        var $106 = IHEAP[$105];
        var $107 = $106+28*$103;
        var $108 = $107;
        $o23 = $108;
        var $109 = $4;
        var $110 = $109+12;
        $o14 = $110;
        var $111 = $o14;
        var $112 = $111;
        var $113 = $o23;
        var $114 = $113;
        var $115 = $112;
        var $116 = $114;
        _llvm_memcpy_p0i8_p0i8_i32($115, $116, 8, 4, 0);
        var $117 = $o23;
        var $118 = $117+8;
        var $119 = IHEAP[$118];
        var $120 = $o14;
        var $121 = $120+8;
        IHEAP[$121] = $119;
        $1 = 1;
        ;
      }
    }
    else if (__label__ == 4) {
      var $27 = $4;
      $i_o = $27;
      var $28 = $i;
      var $29 = $28 + 1;
      var $30 = $29;
      var $31 = $i_o;
      var $32 = $31;
      var $33 = $32;
      FHEAP[$33] = $30;
      var $34 = $i_o;
      var $35 = $34+8;
      IHEAP[$35] = 3;
      var $36 = $i;
      var $37 = $3;
      var $38 = $37+12;
      var $39 = IHEAP[$38];
      var $40 = $39+12*$36;
      $o2 = $40;
      var $41 = $4;
      var $42 = $41+12;
      $o1 = $42;
      var $43 = $o1;
      var $44 = $43;
      var $45 = $o2;
      var $46 = $45;
      var $47 = $44;
      var $48 = $46;
      _llvm_memcpy_p0i8_p0i8_i32($47, $48, 8, 4, 0);
      var $49 = $o2;
      var $50 = $49+8;
      var $51 = IHEAP[$50];
      var $52 = $o1;
      var $53 = $52+8;
      IHEAP[$53] = $51;
      $1 = 1;
      ;
    }
    var $128 = $1;
    ;
    return $128;
  }
  __Z9luaH_nextP9lua_StateP5TableP10lua_TValue.__index__ = Runtime.getFunctionIndex(__Z9luaH_nextP9lua_StateP5TableP10lua_TValue, "__Z9luaH_nextP9lua_StateP5TableP10lua_TValue");
  
  
  function __Z9findindexP9lua_StateP5TableP10lua_TValue($L, $t, $key) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $i;
    var $n;
    $2 = $L;
    $3 = $t;
    $4 = $key;
    var $5 = $4;
    var $6 = $5+8;
    var $7 = IHEAP[$6];
    var $8 = $7 == 0;
    ;
    $9$10$2: do { 
      if ($8) {
        ;
        $1 = -1;
        ;
      }
      else {
        ;
        var $11 = $4;
        var $12 = __Z10arrayindexPK10lua_TValue($11);
        $i = $12;
        var $13 = $i;
        var $14 = 0 < $13;
        ;
        $15$24$5: do { 
          if ($14) {
            ;
            var $16 = $i;
            var $17 = $3;
            var $18 = $17+28;
            var $19 = IHEAP[$18];
            var $20 = $16 <= $19;
            if (!($20)) { __label__ = 2; /* $24 */ break $15$24$5; }
            var $22 = $i;
            var $23 = $22 - 1;
            $1 = $23;
            __label__ = 3; /* $89 */ break $9$10$2;
          }
        } while(0);
        var $25 = $3;
        var $26 = $4;
        var $27 = __Z12mainpositionPK5TablePK10lua_TValue($25, $26);
        $n = $27;
        ;
        $28$9: while(1) { // $28
          var $29 = $n;
          var $30 = $29+12;
          var $31 = $30;
          var $32 = $31;
          var $33 = $4;
          var $34 = __Z16luaO_rawequalObjPK10lua_TValueS1_($32, $33);
          var $35 = $34 != 0;
          if ($35) { __label__ = 5; /* $62 */ break $28$9; }
          var $37 = $n;
          var $38 = $37+12;
          var $39 = $38;
          var $40 = $39+8;
          var $41 = IHEAP[$40];
          var $42 = $41 == 11;
          ;
          $43$77$12: do { 
            if ($42) {
              ;
              var $44 = $4;
              var $45 = $44+8;
              var $46 = IHEAP[$45];
              var $47 = $46 >= 4;
              if (!($47)) { __label__ = 8; /* $77 */ break $43$77$12; }
              var $49 = $n;
              var $50 = $49+12;
              var $51 = $50;
              var $52 = $51;
              var $53 = $52;
              var $54 = $53;
              var $55 = IHEAP[$54];
              var $56 = $4;
              var $57 = $56;
              var $58 = $57;
              var $59 = $58;
              var $60 = IHEAP[$59];
              var $61 = $55 == $60;
              if ($61) { __label__ = 5; /* $62 */ break $28$9; }
            }
          } while(0);
          var $78 = $n;
          var $79 = $78+12;
          var $80 = $79;
          var $81 = $80+12;
          var $82 = IHEAP[$81];
          $n = $82;
          ;
          ;
          var $85 = $n;
          var $86 = $85 != 0;
          if ($86) { __label__ = 4; /* $28 */ continue $28$9; } else { __label__ = 12; /* $87 */ break $28$9; }
        }
        if (__label__ == 5) {
          var $63 = $n;
          var $64 = $3;
          var $65 = $64+16;
          var $66 = IHEAP[$65];
          var $67 = $66;
          var $68 = $63;
          var $69 = $67;
          var $70 = $68 - $69;
          var $71 = Math.floor($70 / 28);
          $i = $71;
          var $72 = $i;
          var $73 = $3;
          var $74 = $73+28;
          var $75 = IHEAP[$74];
          var $76 = $72 + $75;
          $1 = $76;
          ;
        }
        else if (__label__ == 12) {
          var $88 = $2;
          __Z13luaG_runerrorP9lua_StatePKcz($88, __str3167);
          $1 = 0;
          ;
        }
      }
    } while(0);
    var $90 = $1;
    ;
    return $90;
  }
  __Z9findindexP9lua_StateP5TableP10lua_TValue.__index__ = Runtime.getFunctionIndex(__Z9findindexP9lua_StateP5TableP10lua_TValue, "__Z9findindexP9lua_StateP5TableP10lua_TValue");
  
  
  function __Z16luaH_resizearrayP9lua_StateP5Tablei($L, $t, $nasize) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $nsize;
    $1 = $L;
    $2 = $t;
    $3 = $nasize;
    var $4 = $2;
    var $5 = $4+16;
    var $6 = IHEAP[$5];
    var $7 = $6 == __ZL10dummynode_;
    ;
    if ($7) {
      ;
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $10 = $2;
      var $11 = $10+7;
      var $12 = IHEAP[$11];
      var $13 = $12;
      var $14 = 1 << $13;
      __lastLabel__ = 2; ;
    }
    var $16 = __lastLabel__ == 0 ? 0 : ($14);
    $nsize = $16;
    var $17 = $1;
    var $18 = $2;
    var $19 = $3;
    var $20 = $nsize;
    __Z6resizeP9lua_StateP5Tableii($17, $18, $19, $20);
    ;
    return;
  }
  __Z16luaH_resizearrayP9lua_StateP5Tablei.__index__ = Runtime.getFunctionIndex(__Z16luaH_resizearrayP9lua_StateP5Tablei, "__Z16luaH_resizearrayP9lua_StateP5Tablei");
  
  
  function __Z6resizeP9lua_StateP5Tableii($L, $t, $nasize, $nhsize) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $4;
    var $i;
    var $oldasize;
    var $oldhsize;
    var $nold;
    var $o2;
    var $o1;
    var $old;
    var $o21;
    var $o12;
    $1 = $L;
    $2 = $t;
    $3 = $nasize;
    $4 = $nhsize;
    var $5 = $2;
    var $6 = $5+28;
    var $7 = IHEAP[$6];
    $oldasize = $7;
    var $8 = $2;
    var $9 = $8+7;
    var $10 = IHEAP[$9];
    var $11 = $10;
    $oldhsize = $11;
    var $12 = $2;
    var $13 = $12+16;
    var $14 = IHEAP[$13];
    $nold = $14;
    var $15 = $3;
    var $16 = $oldasize;
    var $17 = $15 > $16;
    ;
    if ($17) {
      ;
      var $19 = $1;
      var $20 = $2;
      var $21 = $3;
      __Z14setarrayvectorP9lua_StateP5Tablei($19, $20, $21);
      ;
    }
    var $23 = $1;
    var $24 = $2;
    var $25 = $4;
    __Z13setnodevectorP9lua_StateP5Tablei($23, $24, $25);
    var $26 = $3;
    var $27 = $oldasize;
    var $28 = $26 < $27;
    ;
    if ($28) {
      ;
      var $30 = $3;
      var $31 = $2;
      var $32 = $31+28;
      IHEAP[$32] = $30;
      var $33 = $3;
      $i = $33;
      ;
      $34$7: while(1) { // $34
        var $35 = $i;
        var $36 = $oldasize;
        var $37 = $35 < $36;
        if (!($37)) { __label__ = 3; /* $73 */ break $34$7; }
        var $39 = $i;
        var $40 = $2;
        var $41 = $40+12;
        var $42 = IHEAP[$41];
        var $43 = $42+12*$39;
        var $44 = $43+8;
        var $45 = IHEAP[$44];
        var $46 = $45 == 0;
        ;
        if (!$46) {
          ;
          var $48 = $i;
          var $49 = $2;
          var $50 = $49+12;
          var $51 = IHEAP[$50];
          var $52 = $51+12*$48;
          $o2 = $52;
          var $53 = $1;
          var $54 = $2;
          var $55 = $i;
          var $56 = $55 + 1;
          var $57 = __Z11luaH_setnumP9lua_StateP5Tablei($53, $54, $56);
          $o1 = $57;
          var $58 = $o1;
          var $59 = $58;
          var $60 = $o2;
          var $61 = $60;
          var $62 = $59;
          var $63 = $61;
          _llvm_memcpy_p0i8_p0i8_i32($62, $63, 8, 4, 0);
          var $64 = $o2;
          var $65 = $64+8;
          var $66 = IHEAP[$65];
          var $67 = $o1;
          var $68 = $67+8;
          IHEAP[$68] = $66;
          ;
        }
        ;
        var $71 = $i;
        var $72 = $71 + 1;
        $i = $72;
        __label__ = 1; /* $34 */ continue $34$7;
      }
      var $74 = $3;
      var $75 = $74 + 1;
      var $76 = unSign($75, 32) <= unSign(357913941, 32);
      ;
      if ($76) {
        ;
        var $78 = $1;
        var $79 = $2;
        var $80 = $79+12;
        var $81 = IHEAP[$80];
        var $82 = $81;
        var $83 = $oldasize;
        var $84 = $83 * 12;
        var $85 = $3;
        var $86 = $85 * 12;
        var $87 = __Z13luaM_realloc_P9lua_StatePvjj($78, $82, $84, $86);
        __lastLabel__ = 6; ;
      }
      else {
        ;
        var $89 = $1;
        var $90 = __Z11luaM_toobigP9lua_State($89);
        __lastLabel__ = 8; ;
      }
      var $92 = __lastLabel__ == 6 ? $87 : ($90);
      var $93 = $92;
      var $94 = $2;
      var $95 = $94+12;
      IHEAP[$95] = $93;
      ;
    }
    var $97 = $oldhsize;
    var $98 = 1 << $97;
    var $99 = $98 - 1;
    $i = $99;
    ;
    $100$20: while(1) { // $100
      var $101 = $i;
      var $102 = $101 >= 0;
      if (!($102)) { __label__ = 12; /* $137 */ break $100$20; }
      var $104 = $nold;
      var $105 = $i;
      var $106 = $104+28*$105;
      $old = $106;
      var $107 = $old;
      var $108 = $107;
      var $109 = $108+8;
      var $110 = IHEAP[$109];
      var $111 = $110 == 0;
      ;
      if (!$111) {
        ;
        var $113 = $old;
        var $114 = $113;
        $o21 = $114;
        var $115 = $1;
        var $116 = $2;
        var $117 = $old;
        var $118 = $117+12;
        var $119 = $118;
        var $120 = $119;
        var $121 = __Z8luaH_setP9lua_StateP5TablePK10lua_TValue($115, $116, $120);
        $o12 = $121;
        var $122 = $o12;
        var $123 = $122;
        var $124 = $o21;
        var $125 = $124;
        var $126 = $123;
        var $127 = $125;
        _llvm_memcpy_p0i8_p0i8_i32($126, $127, 8, 4, 0);
        var $128 = $o21;
        var $129 = $128+8;
        var $130 = IHEAP[$129];
        var $131 = $o12;
        var $132 = $131+8;
        IHEAP[$132] = $130;
        ;
      }
      ;
      var $135 = $i;
      var $136 = $135 + -1;
      $i = $136;
      __label__ = 10; /* $100 */ continue $100$20;
    }
    var $138 = $nold;
    var $139 = $138 != __ZL10dummynode_;
    ;
    if ($139) {
      ;
      var $141 = $1;
      var $142 = $nold;
      var $143 = $142;
      var $144 = $oldhsize;
      var $145 = 1 << $144;
      var $146 = $145 * 28;
      var $147 = __Z13luaM_realloc_P9lua_StatePvjj($141, $143, $146, 0);
      ;
    }
    ;
    return;
  }
  __Z6resizeP9lua_StateP5Tableii.__index__ = Runtime.getFunctionIndex(__Z6resizeP9lua_StateP5Tableii, "__Z6resizeP9lua_StateP5Tableii");
  
  
  function __Z8luaH_newP9lua_Stateii($L, $narray, $nhash) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $t;
    $1 = $L;
    $2 = $narray;
    $3 = $nhash;
    var $4 = $1;
    var $5 = __Z13luaM_realloc_P9lua_StatePvjj($4, 0, 0, 32);
    var $6 = $5;
    $t = $6;
    var $7 = $1;
    var $8 = $t;
    var $9 = $8;
    __Z9luaC_linkP9lua_StateP8GCObjecth($7, $9, 5);
    var $10 = $t;
    var $11 = $10+8;
    IHEAP[$11] = 0;
    var $12 = $t;
    var $13 = $12+6;
    IHEAP[$13] = -1;
    var $14 = $t;
    var $15 = $14+12;
    IHEAP[$15] = 0;
    var $16 = $t;
    var $17 = $16+28;
    IHEAP[$17] = 0;
    var $18 = $t;
    var $19 = $18+7;
    IHEAP[$19] = 0;
    var $20 = $t;
    var $21 = $20+16;
    IHEAP[$21] = __ZL10dummynode_;
    var $22 = $1;
    var $23 = $t;
    var $24 = $2;
    __Z14setarrayvectorP9lua_StateP5Tablei($22, $23, $24);
    var $25 = $1;
    var $26 = $t;
    var $27 = $3;
    __Z13setnodevectorP9lua_StateP5Tablei($25, $26, $27);
    var $28 = $t;
    ;
    return $28;
  }
  __Z8luaH_newP9lua_Stateii.__index__ = Runtime.getFunctionIndex(__Z8luaH_newP9lua_Stateii, "__Z8luaH_newP9lua_Stateii");
  
  
  function __Z14setarrayvectorP9lua_StateP5Tablei($L, $t, $size) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $i;
    $1 = $L;
    $2 = $t;
    $3 = $size;
    var $4 = $3;
    var $5 = $4 + 1;
    var $6 = unSign($5, 32) <= unSign(357913941, 32);
    ;
    if ($6) {
      ;
      var $8 = $1;
      var $9 = $2;
      var $10 = $9+12;
      var $11 = IHEAP[$10];
      var $12 = $11;
      var $13 = $2;
      var $14 = $13+28;
      var $15 = IHEAP[$14];
      var $16 = $15 * 12;
      var $17 = $3;
      var $18 = $17 * 12;
      var $19 = __Z13luaM_realloc_P9lua_StatePvjj($8, $12, $16, $18);
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $21 = $1;
      var $22 = __Z11luaM_toobigP9lua_State($21);
      __lastLabel__ = 2; ;
    }
    var $24 = __lastLabel__ == 0 ? $19 : ($22);
    var $25 = $24;
    var $26 = $2;
    var $27 = $26+12;
    IHEAP[$27] = $25;
    var $28 = $2;
    var $29 = $28+28;
    var $30 = IHEAP[$29];
    $i = $30;
    ;
    $31$6: while(1) { // $31
      var $32 = $i;
      var $33 = $3;
      var $34 = $32 < $33;
      if (!($34)) { __label__ = 5; /* $45 */ break $31$6; }
      var $36 = $i;
      var $37 = $2;
      var $38 = $37+12;
      var $39 = IHEAP[$38];
      var $40 = $39+12*$36;
      var $41 = $40+8;
      IHEAP[$41] = 0;
      ;
      var $43 = $i;
      var $44 = $43 + 1;
      $i = $44;
      __label__ = 3; /* $31 */ continue $31$6;
    }
    var $46 = $3;
    var $47 = $2;
    var $48 = $47+28;
    IHEAP[$48] = $46;
    ;
    return;
  }
  __Z14setarrayvectorP9lua_StateP5Tablei.__index__ = Runtime.getFunctionIndex(__Z14setarrayvectorP9lua_StateP5Tablei, "__Z14setarrayvectorP9lua_StateP5Tablei");
  
  
  function __Z13setnodevectorP9lua_StateP5Tablei($L, $t, $size) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $lsize;
    var $i;
    var $n;
    $1 = $L;
    $2 = $t;
    $3 = $size;
    var $4 = $3;
    var $5 = $4 == 0;
    ;
    if ($5) {
      ;
      var $7 = $2;
      var $8 = $7+16;
      IHEAP[$8] = __ZL10dummynode_;
      $lsize = 0;
      ;
    }
    else {
      ;
      var $10 = $3;
      var $11 = $10 - 1;
      var $12 = __Z9luaO_log2j($11);
      var $13 = $12 + 1;
      $lsize = $13;
      var $14 = $lsize;
      var $15 = $14 > 26;
      ;
      if ($15) {
        ;
        var $17 = $1;
        __Z13luaG_runerrorP9lua_StatePKcz($17, __str2166);
        ;
      }
      var $19 = $lsize;
      var $20 = 1 << $19;
      $3 = $20;
      var $21 = $3;
      var $22 = $21 + 1;
      var $23 = unSign($22, 32) <= unSign(153391689, 32);
      ;
      if ($23) {
        ;
        var $25 = $1;
        var $26 = $3;
        var $27 = $26 * 28;
        var $28 = __Z13luaM_realloc_P9lua_StatePvjj($25, 0, 0, $27);
        __lastLabel__ = 2; ;
      }
      else {
        ;
        var $30 = $1;
        var $31 = __Z11luaM_toobigP9lua_State($30);
        __lastLabel__ = 4; ;
      }
      var $33 = __lastLabel__ == 2 ? $28 : ($31);
      var $34 = $33;
      var $35 = $2;
      var $36 = $35+16;
      IHEAP[$36] = $34;
      $i = 0;
      ;
      $37$12: while(1) { // $37
        var $38 = $i;
        var $39 = $3;
        var $40 = $38 < $39;
        if (!($40)) { __label__ = 7; /* $61 */ break $37$12; }
        var $42 = $i;
        var $43 = $2;
        var $44 = $43+16;
        var $45 = IHEAP[$44];
        var $46 = $45+28*$42;
        $n = $46;
        var $47 = $n;
        var $48 = $47+12;
        var $49 = $48;
        var $50 = $49+12;
        IHEAP[$50] = 0;
        var $51 = $n;
        var $52 = $51+12;
        var $53 = $52;
        var $54 = $53+8;
        IHEAP[$54] = 0;
        var $55 = $n;
        var $56 = $55;
        var $57 = $56+8;
        IHEAP[$57] = 0;
        ;
        var $59 = $i;
        var $60 = $59 + 1;
        $i = $60;
        __label__ = 5; /* $37 */ continue $37$12;
      }
      ;
    }
    var $63 = $lsize;
    var $64 = $63;
    var $65 = $2;
    var $66 = $65+7;
    IHEAP[$66] = $64;
    var $67 = $3;
    var $68 = $2;
    var $69 = $68+16;
    var $70 = IHEAP[$69];
    var $71 = $70+28*$67;
    var $72 = $2;
    var $73 = $72+20;
    IHEAP[$73] = $71;
    ;
    return;
  }
  __Z13setnodevectorP9lua_StateP5Tablei.__index__ = Runtime.getFunctionIndex(__Z13setnodevectorP9lua_StateP5Tablei, "__Z13setnodevectorP9lua_StateP5Tablei");
  
  
  function __Z9luaH_freeP9lua_StateP5Table($L, $t) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $L;
    $2 = $t;
    var $3 = $2;
    var $4 = $3+16;
    var $5 = IHEAP[$4];
    var $6 = $5 != __ZL10dummynode_;
    ;
    if ($6) {
      ;
      var $8 = $1;
      var $9 = $2;
      var $10 = $9+16;
      var $11 = IHEAP[$10];
      var $12 = $11;
      var $13 = $2;
      var $14 = $13+7;
      var $15 = IHEAP[$14];
      var $16 = $15;
      var $17 = 1 << $16;
      var $18 = $17 * 28;
      var $19 = __Z13luaM_realloc_P9lua_StatePvjj($8, $12, $18, 0);
      ;
    }
    var $21 = $1;
    var $22 = $2;
    var $23 = $22+12;
    var $24 = IHEAP[$23];
    var $25 = $24;
    var $26 = $2;
    var $27 = $26+28;
    var $28 = IHEAP[$27];
    var $29 = $28 * 12;
    var $30 = __Z13luaM_realloc_P9lua_StatePvjj($21, $25, $29, 0);
    var $31 = $1;
    var $32 = $2;
    var $33 = $32;
    var $34 = __Z13luaM_realloc_P9lua_StatePvjj($31, $33, 32, 0);
    ;
    return;
  }
  __Z9luaH_freeP9lua_StateP5Table.__index__ = Runtime.getFunctionIndex(__Z9luaH_freeP9lua_StateP5Table, "__Z9luaH_freeP9lua_StateP5Table");
  
  
  function __Z11luaH_getnumP5Tablei($t, $key) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $nk;
    var $n;
    $2 = $t;
    $3 = $key;
    var $4 = $3;
    var $5 = $4 - 1;
    var $6 = $2;
    var $7 = $6+28;
    var $8 = IHEAP[$7];
    var $9 = unSign($5, 32) < unSign($8, 32);
    ;
    if ($9) {
      ;
      var $11 = $3;
      var $12 = $11 - 1;
      var $13 = $2;
      var $14 = $13+12;
      var $15 = IHEAP[$14];
      var $16 = $15+12*$12;
      $1 = $16;
      ;
    }
    else {
      ;
      var $18 = $3;
      var $19 = $18;
      $nk = $19;
      var $20 = $2;
      var $21 = $nk;
      var $22 = __Z7hashnumPK5Tabled($20, $21);
      $n = $22;
      ;
      $23$5: while(1) { // $23
        var $24 = $n;
        var $25 = $24+12;
        var $26 = $25;
        var $27 = $26+8;
        var $28 = IHEAP[$27];
        var $29 = $28 == 3;
        ;
        if ($29) {
          ;
          var $31 = $n;
          var $32 = $31+12;
          var $33 = $32;
          var $34 = $33;
          var $35 = $34;
          var $36 = FHEAP[$35];
          var $37 = $nk;
          var $38 = $36 == $37;
          if ($38) { __label__ = 2; /* $39 */ break $23$5; }
        }
        var $43 = $n;
        var $44 = $43+12;
        var $45 = $44;
        var $46 = $45+12;
        var $47 = IHEAP[$46];
        $n = $47;
        ;
        ;
        var $50 = $n;
        var $51 = $50 != 0;
        if ($51) { __label__ = 1; /* $23 */ continue $23$5; } else { __label__ = 6; /* $52 */ break $23$5; }
      }
      if (__label__ == 2) {
        var $40 = $n;
        var $41 = $40;
        $1 = $41;
        ;
      }
      else if (__label__ == 6) {
        $1 = _luaO_nilobject_;
        ;
      }
    }
    var $54 = $1;
    ;
    return $54;
  }
  __Z11luaH_getnumP5Tablei.__index__ = Runtime.getFunctionIndex(__Z11luaH_getnumP5Tablei, "__Z11luaH_getnumP5Tablei");
  
  
  function __Z7hashnumPK5Tabled($t, $n) {
    var __stackBase__  = STACKTOP; STACKTOP += 16; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3 = __stackBase__;
    var $a = __stackBase__+8;
    var $i;
    $2 = $t;
    FHEAP[$3] = $n;
    var $4 = FHEAP[$3];
    var $5 = $4 == 0;
    ;
    if ($5) {
      ;
      var $7 = $2;
      var $8 = $7+16;
      var $9 = IHEAP[$8];
      var $10 = $9;
      $1 = $10;
      ;
    }
    else {
      ;
      var $12 = $a;
      var $13 = $12;
      var $14 = $3;
      _llvm_memcpy_p0i8_p0i8_i32($13, $14, 8, 1, 0);
      $i = 1;
      ;
      $15$5: while(1) { // $15
        var $16 = $i;
        var $17 = $16 < 2;
        if (!($17)) { __label__ = 3; /* $28 */ break $15$5; }
        var $19 = $i;
        var $20 = $a+$19*4;
        var $21 = IHEAP[$20];
        var $22 = $a;
        var $23 = IHEAP[$22];
        var $24 = $23 + $21;
        IHEAP[$22] = $24;
        ;
        var $26 = $i;
        var $27 = $26 + 1;
        $i = $27;
        __label__ = 1; /* $15 */ continue $15$5;
      }
      var $29 = $a;
      var $30 = IHEAP[$29];
      var $31 = $2;
      var $32 = $31+7;
      var $33 = IHEAP[$32];
      var $34 = $33;
      var $35 = 1 << $34;
      var $36 = $35 - 1;
      var $37 = $36 | 1;
      var $38 = Math.floor(unSign($30, 32) % unSign($37, 32));
      var $39 = $2;
      var $40 = $39+16;
      var $41 = IHEAP[$40];
      var $42 = $41+28*$38;
      $1 = $42;
      ;
    }
    var $44 = $1;
    STACKTOP = __stackBase__;
    return $44;
  }
  __Z7hashnumPK5Tabled.__index__ = Runtime.getFunctionIndex(__Z7hashnumPK5Tabled, "__Z7hashnumPK5Tabled");
  
  
  function __Z11luaH_getstrP5TableP7TString($t, $key) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $n;
    $2 = $t;
    $3 = $key;
    var $4 = $3;
    var $5 = $4;
    var $6 = $5+8;
    var $7 = IHEAP[$6];
    var $8 = $2;
    var $9 = $8+7;
    var $10 = IHEAP[$9];
    var $11 = $10;
    var $12 = 1 << $11;
    var $13 = $12 - 1;
    var $14 = $7 & $13;
    var $15 = $2;
    var $16 = $15+16;
    var $17 = IHEAP[$16];
    var $18 = $17+28*$14;
    $n = $18;
    ;
    $19$2: while(1) { // $19
      var $20 = $n;
      var $21 = $20+12;
      var $22 = $21;
      var $23 = $22+8;
      var $24 = IHEAP[$23];
      var $25 = $24 == 4;
      ;
      if ($25) {
        ;
        var $27 = $n;
        var $28 = $27+12;
        var $29 = $28;
        var $30 = $29;
        var $31 = $30;
        var $32 = $31;
        var $33 = IHEAP[$32];
        var $34 = $33;
        var $35 = $34;
        var $36 = $3;
        var $37 = $35 == $36;
        if ($37) { __label__ = 1; /* $38 */ break $19$2; }
      }
      var $42 = $n;
      var $43 = $42+12;
      var $44 = $43;
      var $45 = $44+12;
      var $46 = IHEAP[$45];
      $n = $46;
      ;
      ;
      var $49 = $n;
      var $50 = $49 != 0;
      if ($50) { __label__ = 0; /* $19 */ continue $19$2; } else { __label__ = 6; /* $51 */ break $19$2; }
    }
    if (__label__ == 1) {
      var $39 = $n;
      var $40 = $39;
      $1 = $40;
      ;
    }
    else if (__label__ == 6) {
      $1 = _luaO_nilobject_;
      ;
    }
    var $53 = $1;
    ;
    return $53;
  }
  __Z11luaH_getstrP5TableP7TString.__index__ = Runtime.getFunctionIndex(__Z11luaH_getstrP5TableP7TString, "__Z11luaH_getstrP5TableP7TString");
  
  
  function __Z8luaH_getP5TablePK10lua_TValue($t, $key) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $k;
    var $n;
    var $n1;
    $2 = $t;
    $3 = $key;
    var $4 = $3;
    var $5 = $4+8;
    var $6 = IHEAP[$5];
    if ($6 == 0) {
      __label__ = 9; /* $7 */ 
    }
    else if ($6 == 4) {
      __label__ = 10; /* $8 */ 
    }
    else if ($6 == 3) {
      __label__ = 11; /* $18 */ 
    }
    else {
    __label__ = 1; /* $37 */ 
    }
    
    $37$7$8$18$2: do { 
      if (__label__ == 9) {
        $1 = _luaO_nilobject_;
        __label__ = 0; /* $63 */ break $37$7$8$18$2;
      }
      else if (__label__ == 10) {
        var $9 = $2;
        var $10 = $3;
        var $11 = $10;
        var $12 = $11;
        var $13 = $12;
        var $14 = IHEAP[$13];
        var $15 = $14;
        var $16 = $15;
        var $17 = __Z11luaH_getstrP5TableP7TString($9, $16);
        $1 = $17;
        __label__ = 0; /* $63 */ break $37$7$8$18$2;
      }
      else if (__label__ == 11) {
        var $19 = $3;
        var $20 = $19;
        var $21 = $20;
        var $22 = FHEAP[$21];
        $n = $22;
        var $23 = $n;
        var $24 = Math.floor($23);
        $k = $24;
        var $25 = $k;
        var $26 = $25;
        var $27 = $3;
        var $28 = $27;
        var $29 = $28;
        var $30 = FHEAP[$29];
        var $31 = $26 == $30;
        ;
        if ($31) {
          ;
          var $33 = $2;
          var $34 = $k;
          var $35 = __Z11luaH_getnumP5Tablei($33, $34);
          $1 = $35;
          __label__ = 0; /* $63 */ break $37$7$8$18$2;
        }
        else {
          ;
          __label__ = 1; /* $37 */ break $37$7$8$18$2;
        }
      }
    } while(0);
    if (__label__ == 1) {
      var $38 = $2;
      var $39 = $3;
      var $40 = __Z12mainpositionPK5TablePK10lua_TValue($38, $39);
      $n1 = $40;
      ;
      $41$11: while(1) { // $41
        var $42 = $n1;
        var $43 = $42+12;
        var $44 = $43;
        var $45 = $44;
        var $46 = $3;
        var $47 = __Z16luaO_rawequalObjPK10lua_TValueS1_($45, $46);
        var $48 = $47 != 0;
        if ($48) { __label__ = 3; /* $49 */ break $41$11; }
        var $53 = $n1;
        var $54 = $53+12;
        var $55 = $54;
        var $56 = $55+12;
        var $57 = IHEAP[$56];
        $n1 = $57;
        ;
        ;
        var $60 = $n1;
        var $61 = $60 != 0;
        if ($61) { __label__ = 2; /* $41 */ continue $41$11; } else { __label__ = 8; /* $62 */ break $41$11; }
      }
      if (__label__ == 3) {
        var $50 = $n1;
        var $51 = $50;
        $1 = $51;
        ;
      }
      else if (__label__ == 8) {
        $1 = _luaO_nilobject_;
        ;
      }
    }
    var $64 = $1;
    ;
    return $64;
  }
  __Z8luaH_getP5TablePK10lua_TValue.__index__ = Runtime.getFunctionIndex(__Z8luaH_getP5TablePK10lua_TValue, "__Z8luaH_getP5TablePK10lua_TValue");
  
  
  function __Z12mainpositionPK5TablePK10lua_TValue($t, $key) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    $2 = $t;
    $3 = $key;
    var $4 = $3;
    var $5 = $4+8;
    var $6 = IHEAP[$5];
    if ($6 == 3) {
      __label__ = 1; /* $7 */ 
    }
    else if ($6 == 4) {
      __label__ = 2; /* $14 */ 
    }
    else if ($6 == 1) {
      __label__ = 3; /* $36 */ 
    }
    else if ($6 == 2) {
      __label__ = 4; /* $53 */ 
    }
    else {
    __label__ = 5; /* $72 */ 
    }
    
    if (__label__ == 5) {
      var $73 = $3;
      var $74 = $73;
      var $75 = $74;
      var $76 = $75;
      var $77 = IHEAP[$76];
      var $78 = $77;
      var $79 = $2;
      var $80 = $79+7;
      var $81 = IHEAP[$80];
      var $82 = $81;
      var $83 = 1 << $82;
      var $84 = $83 - 1;
      var $85 = $84 | 1;
      var $86 = Math.floor(unSign($78, 32) % unSign($85, 32));
      var $87 = $2;
      var $88 = $87+16;
      var $89 = IHEAP[$88];
      var $90 = $89+28*$86;
      $1 = $90;
      ;
    }
    else if (__label__ == 1) {
      var $8 = $2;
      var $9 = $3;
      var $10 = $9;
      var $11 = $10;
      var $12 = FHEAP[$11];
      var $13 = __Z7hashnumPK5Tabled($8, $12);
      $1 = $13;
      ;
    }
    else if (__label__ == 2) {
      var $15 = $3;
      var $16 = $15;
      var $17 = $16;
      var $18 = $17;
      var $19 = IHEAP[$18];
      var $20 = $19;
      var $21 = $20;
      var $22 = $21;
      var $23 = $22+8;
      var $24 = IHEAP[$23];
      var $25 = $2;
      var $26 = $25+7;
      var $27 = IHEAP[$26];
      var $28 = $27;
      var $29 = 1 << $28;
      var $30 = $29 - 1;
      var $31 = $24 & $30;
      var $32 = $2;
      var $33 = $32+16;
      var $34 = IHEAP[$33];
      var $35 = $34+28*$31;
      $1 = $35;
      ;
    }
    else if (__label__ == 3) {
      var $37 = $3;
      var $38 = $37;
      var $39 = $38;
      var $40 = $39;
      var $41 = IHEAP[$40];
      var $42 = $2;
      var $43 = $42+7;
      var $44 = IHEAP[$43];
      var $45 = $44;
      var $46 = 1 << $45;
      var $47 = $46 - 1;
      var $48 = $41 & $47;
      var $49 = $2;
      var $50 = $49+16;
      var $51 = IHEAP[$50];
      var $52 = $51+28*$48;
      $1 = $52;
      ;
    }
    else if (__label__ == 4) {
      var $54 = $3;
      var $55 = $54;
      var $56 = $55;
      var $57 = $56;
      var $58 = IHEAP[$57];
      var $59 = $58;
      var $60 = $2;
      var $61 = $60+7;
      var $62 = IHEAP[$61];
      var $63 = $62;
      var $64 = 1 << $63;
      var $65 = $64 - 1;
      var $66 = $65 | 1;
      var $67 = Math.floor(unSign($59, 32) % unSign($66, 32));
      var $68 = $2;
      var $69 = $68+16;
      var $70 = IHEAP[$69];
      var $71 = $70+28*$67;
      $1 = $71;
      ;
    }
    var $92 = $1;
    ;
    return $92;
  }
  __Z12mainpositionPK5TablePK10lua_TValue.__index__ = Runtime.getFunctionIndex(__Z12mainpositionPK5TablePK10lua_TValue, "__Z12mainpositionPK5TablePK10lua_TValue");
  
  
  function __Z8luaH_setP9lua_StateP5TablePK10lua_TValue($L, $t, $key) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $p;
    $2 = $L;
    $3 = $t;
    $4 = $key;
    var $5 = $3;
    var $6 = $4;
    var $7 = __Z8luaH_getP5TablePK10lua_TValue($5, $6);
    $p = $7;
    var $8 = $3;
    var $9 = $8+6;
    IHEAP[$9] = 0;
    var $10 = $p;
    var $11 = $10 != _luaO_nilobject_;
    ;
    if ($11) {
      ;
      var $13 = $p;
      $1 = $13;
      ;
    }
    else {
      ;
      var $15 = $4;
      var $16 = $15+8;
      var $17 = IHEAP[$16];
      var $18 = $17 == 0;
      ;
      if ($18) {
        ;
        var $20 = $2;
        __Z13luaG_runerrorP9lua_StatePKcz($20, __str164);
        ;
      }
      else {
        ;
        var $22 = $4;
        var $23 = $22+8;
        var $24 = IHEAP[$23];
        var $25 = $24 == 3;
        ;
        $26$38$8: do { 
          if ($25) {
            ;
            var $27 = $4;
            var $28 = $27;
            var $29 = $28;
            var $30 = FHEAP[$29];
            var $31 = $4;
            var $32 = $31;
            var $33 = $32;
            var $34 = FHEAP[$33];
            var $35 = $30 == $34;
            if ($35) { __label__ = 2; /* $38 */ break $26$38$8; }
            var $37 = $2;
            __Z13luaG_runerrorP9lua_StatePKcz($37, __str1165);
            ;
          }
        } while(0);
        ;
      }
      var $40 = $2;
      var $41 = $3;
      var $42 = $4;
      var $43 = __Z6newkeyP9lua_StateP5TablePK10lua_TValue($40, $41, $42);
      $1 = $43;
      ;
    }
    var $45 = $1;
    ;
    return $45;
  }
  __Z8luaH_setP9lua_StateP5TablePK10lua_TValue.__index__ = Runtime.getFunctionIndex(__Z8luaH_setP9lua_StateP5TablePK10lua_TValue, "__Z8luaH_setP9lua_StateP5TablePK10lua_TValue");
  
  
  function __Z6newkeyP9lua_StateP5TablePK10lua_TValue($L, $t, $key) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $mp;
    var $othern;
    var $n;
    $2 = $L;
    $3 = $t;
    $4 = $key;
    var $5 = $3;
    var $6 = $4;
    var $7 = __Z12mainpositionPK5TablePK10lua_TValue($5, $6);
    $mp = $7;
    var $8 = $mp;
    var $9 = $8;
    var $10 = $9+8;
    var $11 = IHEAP[$10];
    var $12 = $11 == 0;
    ;
    $13$16$2: do { 
      if ($12) {
        ;
        var $14 = $mp;
        var $15 = $14 == __ZL10dummynode_;
        if ($15) { __label__ = 0; /* $16 */ break $13$16$2; } else { __label__ = 1; /* $88 */ break $13$16$2; }
      }
      else {
        __label__ = 0; /* $16 */ 
      }
    } while(0);
    $16$88$4: do { 
      if (__label__ == 0) {
        var $17 = $3;
        var $18 = __Z10getfreeposP5Table($17);
        $n = $18;
        var $19 = $n;
        var $20 = $19 == 0;
        ;
        if ($20) {
          ;
          var $22 = $2;
          var $23 = $3;
          var $24 = $4;
          __Z6rehashP9lua_StateP5TablePK10lua_TValue($22, $23, $24);
          var $25 = $2;
          var $26 = $3;
          var $27 = $4;
          var $28 = __Z8luaH_setP9lua_StateP5TablePK10lua_TValue($25, $26, $27);
          $1 = $28;
          __label__ = 2; /* $137 */ break $16$88$4;
        }
        else {
          ;
          var $30 = $3;
          var $31 = $mp;
          var $32 = $31+12;
          var $33 = $32;
          var $34 = $33;
          var $35 = __Z12mainpositionPK5TablePK10lua_TValue($30, $34);
          $othern = $35;
          var $36 = $othern;
          var $37 = $mp;
          var $38 = $36 != $37;
          ;
          if ($38) {
            ;
            ;
            $40$11: while(1) { // $40
              var $41 = $othern;
              var $42 = $41+12;
              var $43 = $42;
              var $44 = $43+12;
              var $45 = IHEAP[$44];
              var $46 = $mp;
              var $47 = $45 != $46;
              if (!($47)) { __label__ = 5; /* $54 */ break $40$11; }
              var $49 = $othern;
              var $50 = $49+12;
              var $51 = $50;
              var $52 = $51+12;
              var $53 = IHEAP[$52];
              $othern = $53;
              __label__ = 3; /* $40 */ continue $40$11;
            }
            var $55 = $n;
            var $56 = $othern;
            var $57 = $56+12;
            var $58 = $57;
            var $59 = $58+12;
            IHEAP[$59] = $55;
            var $60 = $n;
            var $61 = $mp;
            var $62 = $60;
            var $63 = $61;
            _llvm_memcpy_p0i8_p0i8_i32($62, $63, 28, 4, 0);
            var $64 = $mp;
            var $65 = $64+12;
            var $66 = $65;
            var $67 = $66+12;
            IHEAP[$67] = 0;
            var $68 = $mp;
            var $69 = $68;
            var $70 = $69+8;
            IHEAP[$70] = 0;
            ;
          }
          else {
            ;
            var $72 = $mp;
            var $73 = $72+12;
            var $74 = $73;
            var $75 = $74+12;
            var $76 = IHEAP[$75];
            var $77 = $n;
            var $78 = $77+12;
            var $79 = $78;
            var $80 = $79+12;
            IHEAP[$80] = $76;
            var $81 = $n;
            var $82 = $mp;
            var $83 = $82+12;
            var $84 = $83;
            var $85 = $84+12;
            IHEAP[$85] = $81;
            var $86 = $n;
            $mp = $86;
            ;
          }
          __label__ = 1; /* $88 */ break $16$88$4;
        }
      }
    } while(0);
    if (__label__ == 1) {
      var $89 = $mp;
      var $90 = $89+12;
      var $91 = $90;
      var $92 = $91;
      var $93 = $4;
      var $94 = $93;
      var $95 = $92;
      var $96 = $94;
      _llvm_memcpy_p0i8_p0i8_i32($95, $96, 8, 4, 0);
      var $97 = $4;
      var $98 = $97+8;
      var $99 = IHEAP[$98];
      var $100 = $mp;
      var $101 = $100+12;
      var $102 = $101;
      var $103 = $102+8;
      IHEAP[$103] = $99;
      var $104 = $4;
      var $105 = $104+8;
      var $106 = IHEAP[$105];
      var $107 = $106 >= 4;
      ;
      $108$134$19: do { 
        if ($107) {
          ;
          var $109 = $4;
          var $110 = $109;
          var $111 = $110;
          var $112 = $111;
          var $113 = IHEAP[$112];
          var $114 = $113;
          var $115 = $114;
          var $116 = $115+5;
          var $117 = IHEAP[$116];
          var $118 = $117;
          var $119 = $118 & 3;
          var $120 = $119 != 0;
          if (!($120)) { __label__ = 8; /* $134 */ break $108$134$19; }
          var $122 = $3;
          var $123 = $122;
          var $124 = $123;
          var $125 = $124;
          var $126 = $125+5;
          var $127 = IHEAP[$126];
          var $128 = $127;
          var $129 = $128 & 4;
          var $130 = $129 != 0;
          if (!($130)) { __label__ = 8; /* $134 */ break $108$134$19; }
          var $132 = $2;
          var $133 = $3;
          __Z16luaC_barrierbackP9lua_StateP5Table($132, $133);
          ;
        }
      } while(0);
      var $135 = $mp;
      var $136 = $135;
      $1 = $136;
      ;
    }
    var $138 = $1;
    ;
    return $138;
  }
  __Z6newkeyP9lua_StateP5TablePK10lua_TValue.__index__ = Runtime.getFunctionIndex(__Z6newkeyP9lua_StateP5TablePK10lua_TValue, "__Z6newkeyP9lua_StateP5TablePK10lua_TValue");
  
  
  function __Z11luaH_setnumP9lua_StateP5Tablei($L, $t, $key) {
    var __stackBase__  = STACKTOP; STACKTOP += 12; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $p;
    var $k = __stackBase__;
    var $i_o;
    $2 = $L;
    $3 = $t;
    $4 = $key;
    var $5 = $3;
    var $6 = $4;
    var $7 = __Z11luaH_getnumP5Tablei($5, $6);
    $p = $7;
    var $8 = $p;
    var $9 = $8 != _luaO_nilobject_;
    ;
    if ($9) {
      ;
      var $11 = $p;
      $1 = $11;
      ;
    }
    else {
      ;
      $i_o = $k;
      var $13 = $4;
      var $14 = $13;
      var $15 = $i_o;
      var $16 = $15;
      var $17 = $16;
      FHEAP[$17] = $14;
      var $18 = $i_o;
      var $19 = $18+8;
      IHEAP[$19] = 3;
      var $20 = $2;
      var $21 = $3;
      var $22 = __Z6newkeyP9lua_StateP5TablePK10lua_TValue($20, $21, $k);
      $1 = $22;
      ;
    }
    var $24 = $1;
    STACKTOP = __stackBase__;
    return $24;
  }
  __Z11luaH_setnumP9lua_StateP5Tablei.__index__ = Runtime.getFunctionIndex(__Z11luaH_setnumP9lua_StateP5Tablei, "__Z11luaH_setnumP9lua_StateP5Tablei");
  
  
  function __Z11luaH_setstrP9lua_StateP5TableP7TString($L, $t, $key) {
    var __stackBase__  = STACKTOP; STACKTOP += 12; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $p;
    var $k = __stackBase__;
    var $i_o;
    $2 = $L;
    $3 = $t;
    $4 = $key;
    var $5 = $3;
    var $6 = $4;
    var $7 = __Z11luaH_getstrP5TableP7TString($5, $6);
    $p = $7;
    var $8 = $p;
    var $9 = $8 != _luaO_nilobject_;
    ;
    if ($9) {
      ;
      var $11 = $p;
      $1 = $11;
      ;
    }
    else {
      ;
      $i_o = $k;
      var $13 = $4;
      var $14 = $13;
      var $15 = $i_o;
      var $16 = $15;
      var $17 = $16;
      var $18 = $17;
      IHEAP[$18] = $14;
      var $19 = $i_o;
      var $20 = $19+8;
      IHEAP[$20] = 4;
      var $21 = $2;
      var $22 = $3;
      var $23 = __Z6newkeyP9lua_StateP5TablePK10lua_TValue($21, $22, $k);
      $1 = $23;
      ;
    }
    var $25 = $1;
    STACKTOP = __stackBase__;
    return $25;
  }
  __Z11luaH_setstrP9lua_StateP5TableP7TString.__index__ = Runtime.getFunctionIndex(__Z11luaH_setstrP9lua_StateP5TableP7TString, "__Z11luaH_setstrP9lua_StateP5TableP7TString");
  
  
  function __Z9luaH_getnP5Table($t) {
    ;
    var __label__;
    var $1;
    var $2;
    var $j;
    var $i;
    var $m;
    $2 = $t;
    var $3 = $2;
    var $4 = $3+28;
    var $5 = IHEAP[$4];
    $j = $5;
    var $6 = $j;
    var $7 = unSign($6, 32) > unSign(0, 32);
    ;
    $8$45$2: do { 
      if ($7) {
        ;
        var $9 = $j;
        var $10 = $9 - 1;
        var $11 = $2;
        var $12 = $11+12;
        var $13 = IHEAP[$12];
        var $14 = $13+12*$10;
        var $15 = $14+8;
        var $16 = IHEAP[$15];
        var $17 = $16 == 0;
        if (!($17)) { __label__ = 1; /* $45 */ break $8$45$2; }
        $i = 0;
        ;
        $19$5: while(1) { // $19
          var $20 = $j;
          var $21 = $i;
          var $22 = $20 - $21;
          var $23 = unSign($22, 32) > unSign(1, 32);
          if (!($23)) { __label__ = 4; /* $43 */ break $19$5; }
          var $25 = $i;
          var $26 = $j;
          var $27 = $25 + $26;
          var $28 = Math.floor(unSign($27, 32) / unSign(2, 32));
          $m = $28;
          var $29 = $m;
          var $30 = $29 - 1;
          var $31 = $2;
          var $32 = $31+12;
          var $33 = IHEAP[$32];
          var $34 = $33+12*$30;
          var $35 = $34+8;
          var $36 = IHEAP[$35];
          var $37 = $36 == 0;
          ;
          if ($37) {
            ;
            var $39 = $m;
            $j = $39;
            ;
          }
          else {
            ;
            var $41 = $m;
            $i = $41;
            ;
          }
          __label__ = 2; /* $19 */ continue $19$5;
        }
        var $44 = $i;
        $1 = $44;
        __label__ = 6; /* $56 */ break $8$45$2;
      }
      else {
        __label__ = 1; /* $45 */ 
      }
    } while(0);
    if (__label__ == 1) {
      var $46 = $2;
      var $47 = $46+16;
      var $48 = IHEAP[$47];
      var $49 = $48 == __ZL10dummynode_;
      ;
      if ($49) {
        ;
        var $51 = $j;
        $1 = $51;
        ;
      }
      else {
        ;
        var $53 = $2;
        var $54 = $j;
        var $55 = __Z14unbound_searchP5Tablej($53, $54);
        $1 = $55;
        ;
      }
    }
    var $57 = $1;
    ;
    return $57;
  }
  __Z9luaH_getnP5Table.__index__ = Runtime.getFunctionIndex(__Z9luaH_getnP5Table, "__Z9luaH_getnP5Table");
  
  
  function __Z14unbound_searchP5Tablej($t, $j) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $i;
    var $m;
    $2 = $t;
    $3 = $j;
    var $4 = $3;
    $i = $4;
    var $5 = $3;
    var $6 = $5 + 1;
    $3 = $6;
    ;
    $7$2: while(1) { // $7
      var $8 = $2;
      var $9 = $3;
      var $10 = __Z11luaH_getnumP5Tablei($8, $9);
      var $11 = $10+8;
      var $12 = IHEAP[$11];
      var $13 = $12 == 0;
      var $14 = $13 ^ 1;
      if (!($14)) { __label__ = 2; /* $37 */ break $7$2; }
      var $16 = $3;
      $i = $16;
      var $17 = $3;
      var $18 = $17 * 2;
      $3 = $18;
      var $19 = $3;
      var $20 = unSign($19, 32) > unSign(2147483645, 32);
      if ($20) { __label__ = 3; /* $21 */ break $7$2; }
      __label__ = 0; /* $7 */ continue $7$2;
    }
    if (__label__ == 2) {
      ;
      $38$8: while(1) { // $38
        var $39 = $3;
        var $40 = $i;
        var $41 = $39 - $40;
        var $42 = unSign($41, 32) > unSign(1, 32);
        if (!($42)) { __label__ = 11; /* $59 */ break $38$8; }
        var $44 = $i;
        var $45 = $3;
        var $46 = $44 + $45;
        var $47 = Math.floor(unSign($46, 32) / unSign(2, 32));
        $m = $47;
        var $48 = $2;
        var $49 = $m;
        var $50 = __Z11luaH_getnumP5Tablei($48, $49);
        var $51 = $50+8;
        var $52 = IHEAP[$51];
        var $53 = $52 == 0;
        ;
        if ($53) {
          ;
          var $55 = $m;
          $3 = $55;
          ;
        }
        else {
          ;
          var $57 = $m;
          $i = $57;
          ;
        }
        __label__ = 9; /* $38 */ continue $38$8;
      }
      var $60 = $i;
      $1 = $60;
      ;
    }
    else if (__label__ == 3) {
      $i = 1;
      ;
      $22$17: while(1) { // $22
        var $23 = $2;
        var $24 = $i;
        var $25 = __Z11luaH_getnumP5Tablei($23, $24);
        var $26 = $25+8;
        var $27 = IHEAP[$26];
        var $28 = $27 == 0;
        var $29 = $28 ^ 1;
        if (!($29)) { __label__ = 7; /* $33 */ break $22$17; }
        var $31 = $i;
        var $32 = $31 + 1;
        $i = $32;
        __label__ = 5; /* $22 */ continue $22$17;
      }
      var $34 = $i;
      var $35 = $34 - 1;
      $1 = $35;
      ;
    }
    var $62 = $1;
    ;
    return $62;
  }
  __Z14unbound_searchP5Tablej.__index__ = Runtime.getFunctionIndex(__Z14unbound_searchP5Tablej, "__Z14unbound_searchP5Tablej");
  
  
  function __Z10getfreeposP5Table($t) {
    ;
    var __label__;
    var $1;
    var $2;
    $2 = $t;
    ;
    $3$2: while(1) { // $3
      var $4 = $2;
      var $5 = $4+20;
      var $6 = IHEAP[$5];
      var $7 = $6+-28;
      IHEAP[$5] = $7;
      var $8 = $2;
      var $9 = $8+16;
      var $10 = IHEAP[$9];
      var $11 = $6 > $10;
      if (!($11)) { __label__ = 2; /* $26 */ break $3$2; }
      var $13 = $2;
      var $14 = $13+20;
      var $15 = IHEAP[$14];
      var $16 = $15+12;
      var $17 = $16;
      var $18 = $17+8;
      var $19 = IHEAP[$18];
      var $20 = $19 == 0;
      if ($20) { __label__ = 3; /* $21 */ break $3$2; }
      __label__ = 0; /* $3 */ continue $3$2;
    }
    if (__label__ == 2) {
      $1 = 0;
      ;
    }
    else if (__label__ == 3) {
      var $22 = $2;
      var $23 = $22+20;
      var $24 = IHEAP[$23];
      $1 = $24;
      ;
    }
    var $28 = $1;
    ;
    return $28;
  }
  __Z10getfreeposP5Table.__index__ = Runtime.getFunctionIndex(__Z10getfreeposP5Table, "__Z10getfreeposP5Table");
  
  
  function __Z6rehashP9lua_StateP5TablePK10lua_TValue($L, $t, $ek) {
    var __stackBase__  = STACKTOP; STACKTOP += 112; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $nasize = __stackBase__;
    var $na;
    var $nums = __stackBase__+4;
    var $i;
    var $totaluse;
    $1 = $L;
    $2 = $t;
    $3 = $ek;
    $i = 0;
    ;
    $4$2: while(1) { // $4
      var $5 = $i;
      var $6 = $5 <= 26;
      if (!($6)) { __label__ = 2; /* $13 */ break $4$2; }
      var $8 = $i;
      var $9 = $nums+$8*4;
      IHEAP[$9] = 0;
      ;
      var $11 = $i;
      var $12 = $11 + 1;
      $i = $12;
      __label__ = 0; /* $4 */ continue $4$2;
    }
    var $14 = $2;
    var $15 = $nums;
    var $16 = __Z11numusearrayPK5TablePi($14, $15);
    IHEAP[$nasize] = $16;
    var $17 = IHEAP[$nasize];
    $totaluse = $17;
    var $18 = $2;
    var $19 = $nums;
    var $20 = __Z10numusehashPK5TablePiS2_($18, $19, $nasize);
    var $21 = $totaluse;
    var $22 = $21 + $20;
    $totaluse = $22;
    var $23 = $3;
    var $24 = $nums;
    var $25 = __Z8countintPK10lua_TValuePi($23, $24);
    var $26 = IHEAP[$nasize];
    var $27 = $26 + $25;
    IHEAP[$nasize] = $27;
    var $28 = $totaluse;
    var $29 = $28 + 1;
    $totaluse = $29;
    var $30 = $nums;
    var $31 = __Z12computesizesPiS_($30, $nasize);
    $na = $31;
    var $32 = $1;
    var $33 = $2;
    var $34 = IHEAP[$nasize];
    var $35 = $totaluse;
    var $36 = $na;
    var $37 = $35 - $36;
    __Z6resizeP9lua_StateP5Tableii($32, $33, $34, $37);
    STACKTOP = __stackBase__;
    return;
  }
  __Z6rehashP9lua_StateP5TablePK10lua_TValue.__index__ = Runtime.getFunctionIndex(__Z6rehashP9lua_StateP5TablePK10lua_TValue, "__Z6rehashP9lua_StateP5TablePK10lua_TValue");
  
  
  function __Z11numusearrayPK5TablePi($t, $nums) {
    ;
    var __label__;
    var $1;
    var $2;
    var $lg;
    var $ttlg;
    var $ause;
    var $i;
    var $lc;
    var $lim;
    $1 = $t;
    $2 = $nums;
    $ause = 0;
    $i = 1;
    $lg = 0;
    $ttlg = 1;
    ;
    $3$2: while(1) { // $3
      var $4 = $lg;
      var $5 = $4 <= 26;
      if (!($5)) { __label__ = 2; /* $59 */ break $3$2; }
      $lc = 0;
      var $7 = $ttlg;
      $lim = $7;
      var $8 = $lim;
      var $9 = $1;
      var $10 = $9+28;
      var $11 = IHEAP[$10];
      var $12 = $8 > $11;
      ;
      if ($12) {
        ;
        var $14 = $1;
        var $15 = $14+28;
        var $16 = IHEAP[$15];
        $lim = $16;
        var $17 = $i;
        var $18 = $lim;
        var $19 = $17 > $18;
        if ($19) { __label__ = 3; /* $20 */ break $3$2; }
        ;
      }
      ;
      $23$9: while(1) { // $23
        var $24 = $i;
        var $25 = $lim;
        var $26 = $24 <= $25;
        if (!($26)) { __label__ = 9; /* $44 */ break $23$9; }
        var $28 = $i;
        var $29 = $28 - 1;
        var $30 = $1;
        var $31 = $30+12;
        var $32 = IHEAP[$31];
        var $33 = $32+12*$29;
        var $34 = $33+8;
        var $35 = IHEAP[$34];
        var $36 = $35 == 0;
        ;
        if (!$36) {
          ;
          var $38 = $lc;
          var $39 = $38 + 1;
          $lc = $39;
          ;
        }
        ;
        var $42 = $i;
        var $43 = $42 + 1;
        $i = $43;
        __label__ = 7; /* $23 */ continue $23$9;
      }
      var $45 = $lc;
      var $46 = $lg;
      var $47 = $2;
      var $48 = $47+4*$46;
      var $49 = IHEAP[$48];
      var $50 = $49 + $45;
      IHEAP[$48] = $50;
      var $51 = $lc;
      var $52 = $ause;
      var $53 = $52 + $51;
      $ause = $53;
      ;
      var $55 = $lg;
      var $56 = $55 + 1;
      $lg = $56;
      var $57 = $ttlg;
      var $58 = $57 * 2;
      $ttlg = $58;
      __label__ = 0; /* $3 */ continue $3$2;
    }
    if (__label__ == 3) {
      ;
    }
    var $60 = $ause;
    ;
    return $60;
  }
  __Z11numusearrayPK5TablePi.__index__ = Runtime.getFunctionIndex(__Z11numusearrayPK5TablePi, "__Z11numusearrayPK5TablePi");
  
  
  function __Z10numusehashPK5TablePiS2_($t, $nums, $pnasize) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $totaluse;
    var $ause;
    var $i;
    var $n;
    $1 = $t;
    $2 = $nums;
    $3 = $pnasize;
    $totaluse = 0;
    $ause = 0;
    var $4 = $1;
    var $5 = $4+7;
    var $6 = IHEAP[$5];
    var $7 = $6;
    var $8 = 1 << $7;
    $i = $8;
    ;
    $9$2: while(1) { // $9
      var $10 = $i;
      var $11 = $10 + -1;
      $i = $11;
      var $12 = $10 != 0;
      if (!($12)) { __label__ = 2; /* $36 */ break $9$2; }
      var $14 = $i;
      var $15 = $1;
      var $16 = $15+16;
      var $17 = IHEAP[$16];
      var $18 = $17+28*$14;
      $n = $18;
      var $19 = $n;
      var $20 = $19;
      var $21 = $20+8;
      var $22 = IHEAP[$21];
      var $23 = $22 == 0;
      ;
      if (!$23) {
        ;
        var $25 = $n;
        var $26 = $25+12;
        var $27 = $26;
        var $28 = $27;
        var $29 = $2;
        var $30 = __Z8countintPK10lua_TValuePi($28, $29);
        var $31 = $ause;
        var $32 = $31 + $30;
        $ause = $32;
        var $33 = $totaluse;
        var $34 = $33 + 1;
        $totaluse = $34;
        ;
      }
      __label__ = 0; /* $9 */ continue $9$2;
    }
    var $37 = $ause;
    var $38 = $3;
    var $39 = IHEAP[$38];
    var $40 = $39 + $37;
    IHEAP[$38] = $40;
    var $41 = $totaluse;
    ;
    return $41;
  }
  __Z10numusehashPK5TablePiS2_.__index__ = Runtime.getFunctionIndex(__Z10numusehashPK5TablePiS2_, "__Z10numusehashPK5TablePiS2_");
  
  
  function __Z8countintPK10lua_TValuePi($key, $nums) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $k;
    $2 = $key;
    $3 = $nums;
    var $4 = $2;
    var $5 = __Z10arrayindexPK10lua_TValue($4);
    $k = $5;
    var $6 = $k;
    var $7 = 0 < $6;
    ;
    $8$20$2: do { 
      if ($7) {
        ;
        var $9 = $k;
        var $10 = $9 <= 67108864;
        if (!($10)) { __label__ = 1; /* $20 */ break $8$20$2; }
        var $12 = $k;
        var $13 = $12 - 1;
        var $14 = __Z9luaO_log2j($13);
        var $15 = $14 + 1;
        var $16 = $3;
        var $17 = $16+4*$15;
        var $18 = IHEAP[$17];
        var $19 = $18 + 1;
        IHEAP[$17] = $19;
        $1 = 1;
        __label__ = 2; /* $21 */ break $8$20$2;
      }
      else {
        __label__ = 1; /* $20 */ 
      }
    } while(0);
    if (__label__ == 1) {
      $1 = 0;
      ;
    }
    var $22 = $1;
    ;
    return $22;
  }
  __Z8countintPK10lua_TValuePi.__index__ = Runtime.getFunctionIndex(__Z8countintPK10lua_TValuePi, "__Z8countintPK10lua_TValuePi");
  
  
  function __Z12computesizesPiS_($nums, $narray) {
    ;
    var __label__;
    var $1;
    var $2;
    var $i;
    var $twotoi;
    var $a;
    var $na;
    var $n;
    $1 = $nums;
    $2 = $narray;
    $a = 0;
    $na = 0;
    $n = 0;
    $i = 0;
    $twotoi = 1;
    ;
    $3$2: while(1) { // $3
      var $4 = $twotoi;
      var $5 = Math.floor($4 / 2);
      var $6 = $2;
      var $7 = IHEAP[$6];
      var $8 = $5 < $7;
      if (!($8)) { __label__ = 2; /* $42 */ break $3$2; }
      var $10 = $i;
      var $11 = $1;
      var $12 = $11+4*$10;
      var $13 = IHEAP[$12];
      var $14 = $13 > 0;
      ;
      if ($14) {
        ;
        var $16 = $i;
        var $17 = $1;
        var $18 = $17+4*$16;
        var $19 = IHEAP[$18];
        var $20 = $a;
        var $21 = $20 + $19;
        $a = $21;
        var $22 = $a;
        var $23 = $twotoi;
        var $24 = Math.floor($23 / 2);
        var $25 = $22 > $24;
        ;
        if ($25) {
          ;
          var $27 = $twotoi;
          $n = $27;
          var $28 = $a;
          $na = $28;
          ;
        }
        ;
      }
      var $31 = $a;
      var $32 = $2;
      var $33 = IHEAP[$32];
      var $34 = $31 == $33;
      if ($34) { __label__ = 5; /* $35 */ break $3$2; }
      ;
      var $38 = $i;
      var $39 = $38 + 1;
      $i = $39;
      var $40 = $twotoi;
      var $41 = $40 * 2;
      $twotoi = $41;
      __label__ = 0; /* $3 */ continue $3$2;
    }
    if (__label__ == 5) {
      ;
    }
    var $43 = $n;
    var $44 = $2;
    IHEAP[$44] = $43;
    var $45 = $na;
    ;
    return $45;
  }
  __Z12computesizesPiS_.__index__ = Runtime.getFunctionIndex(__Z12computesizesPiS_, "__Z12computesizesPiS_");
  
  
  function __Z10arrayindexPK10lua_TValue($key) {
    ;
    var __label__;
    var $1;
    var $2;
    var $n;
    var $k;
    $2 = $key;
    var $3 = $2;
    var $4 = $3+8;
    var $5 = IHEAP[$4];
    var $6 = $5 == 3;
    ;
    $7$21$2: do { 
      if ($6) {
        ;
        var $8 = $2;
        var $9 = $8;
        var $10 = $9;
        var $11 = FHEAP[$10];
        $n = $11;
        var $12 = $n;
        var $13 = Math.floor($12);
        $k = $13;
        var $14 = $k;
        var $15 = $14;
        var $16 = $n;
        var $17 = $15 == $16;
        ;
        if ($17) {
          ;
          var $19 = $k;
          $1 = $19;
          __label__ = 0; /* $22 */ break $7$21$2;
        }
        else {
          ;
          __label__ = 1; /* $21 */ break $7$21$2;
        }
      }
      else {
        __label__ = 1; /* $21 */ 
      }
    } while(0);
    if (__label__ == 1) {
      $1 = -1;
      ;
    }
    var $23 = $1;
    ;
    return $23;
  }
  __Z10arrayindexPK10lua_TValue.__index__ = Runtime.getFunctionIndex(__Z10arrayindexPK10lua_TValue, "__Z10arrayindexPK10lua_TValue");
  
  
  function __Z9luaT_initP9lua_State($L) {
    ;
    var __label__;
    var $1;
    var $i;
    $1 = $L;
    $i = 0;
    ;
    $2$2: while(1) { // $2
      var $3 = $i;
      var $4 = $3 < 17;
      if (!($4)) { __label__ = 2; /* $37 */ break $2$2; }
      var $6 = $1;
      var $7 = $i;
      var $8 = __ZZ9luaT_initP9lua_StateE14luaT_eventname+$7*4;
      var $9 = IHEAP[$8];
      var $10 = $i;
      var $11 = __ZZ9luaT_initP9lua_StateE14luaT_eventname+$10*4;
      var $12 = IHEAP[$11];
      var $13 = _strlen($12);
      var $14 = __Z12luaS_newlstrP9lua_StatePKcj($6, $9, $13);
      var $15 = $i;
      var $16 = $1;
      var $17 = $16+16;
      var $18 = IHEAP[$17];
      var $19 = $18+168;
      var $20 = $19+$15*4;
      IHEAP[$20] = $14;
      var $21 = $i;
      var $22 = $1;
      var $23 = $22+16;
      var $24 = IHEAP[$23];
      var $25 = $24+168;
      var $26 = $25+$21*4;
      var $27 = IHEAP[$26];
      var $28 = $27;
      var $29 = $28+5;
      var $30 = IHEAP[$29];
      var $31 = $30;
      var $32 = $31 | 32;
      var $33 = $32;
      IHEAP[$29] = $33;
      ;
      var $35 = $i;
      var $36 = $35 + 1;
      $i = $36;
      __label__ = 0; /* $2 */ continue $2$2;
    }
    ;
    return;
  }
  __Z9luaT_initP9lua_State.__index__ = Runtime.getFunctionIndex(__Z9luaT_initP9lua_State, "__Z9luaT_initP9lua_State");
  
  
  function __Z10luaT_gettmP5Table3TMSP7TString($events, $event, $ename) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $tm;
    $2 = $events;
    $3 = $event;
    $4 = $ename;
    var $5 = $2;
    var $6 = $4;
    var $7 = __Z11luaH_getstrP5TableP7TString($5, $6);
    $tm = $7;
    var $8 = $tm;
    var $9 = $8+8;
    var $10 = IHEAP[$9];
    var $11 = $10 == 0;
    ;
    if ($11) {
      ;
      var $13 = $3;
      var $14 = 1 << $13;
      var $15 = $14;
      var $16 = $15;
      var $17 = $2;
      var $18 = $17+6;
      var $19 = IHEAP[$18];
      var $20 = $19;
      var $21 = $20 | $16;
      var $22 = $21;
      IHEAP[$18] = $22;
      $1 = 0;
      ;
    }
    else {
      ;
      var $24 = $tm;
      $1 = $24;
      ;
    }
    var $26 = $1;
    ;
    return $26;
  }
  __Z10luaT_gettmP5Table3TMSP7TString.__index__ = Runtime.getFunctionIndex(__Z10luaT_gettmP5Table3TMSP7TString, "__Z10luaT_gettmP5Table3TMSP7TString");
  
  
  function __Z15luaT_gettmbyobjP9lua_StatePK10lua_TValue3TMS($L, $o, $event) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $mt;
    $1 = $L;
    $2 = $o;
    $3 = $event;
    var $4 = $2;
    var $5 = $4+8;
    var $6 = IHEAP[$5];
    if ($6 == 5) {
      __label__ = 4; /* $7 */ 
    }
    else if ($6 == 7) {
      __label__ = 5; /* $17 */ 
    }
    else {
    __label__ = 6; /* $28 */ 
    }
    
    if (__label__ == 6) {
      var $29 = $2;
      var $30 = $29+8;
      var $31 = IHEAP[$30];
      var $32 = $1;
      var $33 = $32+16;
      var $34 = IHEAP[$33];
      var $35 = $34+132;
      var $36 = $35+$31*4;
      var $37 = IHEAP[$36];
      $mt = $37;
      ;
    }
    else if (__label__ == 4) {
      var $8 = $2;
      var $9 = $8;
      var $10 = $9;
      var $11 = $10;
      var $12 = IHEAP[$11];
      var $13 = $12;
      var $14 = $13;
      var $15 = $14+8;
      var $16 = IHEAP[$15];
      $mt = $16;
      ;
    }
    else if (__label__ == 5) {
      var $18 = $2;
      var $19 = $18;
      var $20 = $19;
      var $21 = $20;
      var $22 = IHEAP[$21];
      var $23 = $22;
      var $24 = $23;
      var $25 = $24;
      var $26 = $25+8;
      var $27 = IHEAP[$26];
      $mt = $27;
      ;
    }
    var $39 = $mt;
    var $40 = $39 != 0;
    ;
    if ($40) {
      ;
      var $42 = $mt;
      var $43 = $3;
      var $44 = $1;
      var $45 = $44+16;
      var $46 = IHEAP[$45];
      var $47 = $46+168;
      var $48 = $47+$43*4;
      var $49 = IHEAP[$48];
      var $50 = __Z11luaH_getstrP5TableP7TString($42, $49);
      __lastLabel__ = 1; ;
    }
    else {
      ;
      __lastLabel__ = 3; ;
    }
    var $53 = __lastLabel__ == 1 ? $50 : (_luaO_nilobject_);
    ;
    return $53;
  }
  __Z15luaT_gettmbyobjP9lua_StatePK10lua_TValue3TMS.__index__ = Runtime.getFunctionIndex(__Z15luaT_gettmbyobjP9lua_StatePK10lua_TValue3TMS, "__Z15luaT_gettmbyobjP9lua_StatePK10lua_TValue3TMS");
  
  
  function __Z11luaU_undumpP9lua_StateP3ZioP7MbufferPKc($L, $Z, $buff, $name) {
    var __stackBase__  = STACKTOP; STACKTOP += 16; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $S = __stackBase__;
    $1 = $L;
    $2 = $Z;
    $3 = $buff;
    $4 = $name;
    var $5 = $4;
    var $6 = IHEAP[$5];
    var $7 = $6;
    var $8 = $7 == 64;
    ;
    $14$9$2: do { 
      if ($8) {
        __label__ = 0; /* $14 */ 
      }
      else {
        ;
        var $10 = $4;
        var $11 = IHEAP[$10];
        var $12 = $11;
        var $13 = $12 == 61;
        if ($13) { __label__ = 0; /* $14 */ break $14$9$2; }
        var $19 = $4;
        var $20 = IHEAP[$19];
        var $21 = $20;
        var $22 = IHEAP[__str208];
        var $23 = $22;
        var $24 = $21 == $23;
        ;
        if ($24) {
          ;
          var $26 = $S+12;
          IHEAP[$26] = __str1209;
          ;
        }
        else {
          ;
          var $28 = $4;
          var $29 = $S+12;
          IHEAP[$29] = $28;
          ;
        }
        __label__ = 4; /* $31 */ break $14$9$2;
      }
    } while(0);
    if (__label__ == 0) {
      var $15 = $4;
      var $16 = $15+1;
      var $17 = $S+12;
      IHEAP[$17] = $16;
      ;
    }
    var $32 = $1;
    var $33 = $S;
    IHEAP[$33] = $32;
    var $34 = $2;
    var $35 = $S+4;
    IHEAP[$35] = $34;
    var $36 = $3;
    var $37 = $S+8;
    IHEAP[$37] = $36;
    __Z10LoadHeaderP9LoadState($S);
    var $38 = $1;
    var $39 = __Z12luaS_newlstrP9lua_StatePKcj($38, __str2210, 2);
    var $40 = __Z12LoadFunctionP9LoadStateP7TString($S, $39);
    STACKTOP = __stackBase__;
    return $40;
  }
  __Z11luaU_undumpP9lua_StateP3ZioP7MbufferPKc.__index__ = Runtime.getFunctionIndex(__Z11luaU_undumpP9lua_StateP3ZioP7MbufferPKc, "__Z11luaU_undumpP9lua_StateP3ZioP7MbufferPKc");
  
  
  function __Z10LoadHeaderP9LoadState($S) {
    var __stackBase__  = STACKTOP; STACKTOP += 24; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $h = __stackBase__;
    var $s = __stackBase__+12;
    $1 = $S;
    var $2 = $h;
    __Z11luaU_headerPc($2);
    var $3 = $1;
    var $4 = $s;
    __Z9LoadBlockP9LoadStatePvj($3, $4, 12);
    var $5 = $h;
    var $6 = $s;
    var $7 = _memcmp($5, $6, 12);
    var $8 = $7 != 0;
    ;
    if ($8) {
      ;
      var $10 = $1;
      __Z5errorP9LoadStatePKc($10, __str9217);
      ;
    }
    STACKTOP = __stackBase__;
    return;
  }
  __Z10LoadHeaderP9LoadState.__index__ = Runtime.getFunctionIndex(__Z10LoadHeaderP9LoadState, "__Z10LoadHeaderP9LoadState");
  
  
  function __Z12LoadFunctionP9LoadStateP7TString($S, $p) {
    ;
    var __label__;
    var $1;
    var $2;
    var $f;
    var $i_o;
    $1 = $S;
    $2 = $p;
    var $3 = $1;
    var $4 = $3;
    var $5 = IHEAP[$4];
    var $6 = $5+52;
    var $7 = IHEAP[$6];
    var $8 = $7 + 1;
    IHEAP[$6] = $8;
    var $9 = $8;
    var $10 = $9 > 200;
    ;
    if ($10) {
      ;
      var $12 = $1;
      __Z5errorP9LoadStatePKc($12, __str3211);
      ;
    }
    var $14 = $1;
    var $15 = $14;
    var $16 = IHEAP[$15];
    var $17 = __Z13luaF_newprotoP9lua_State($16);
    $f = $17;
    var $18 = $1;
    var $19 = $18;
    var $20 = IHEAP[$19];
    var $21 = $20+8;
    var $22 = IHEAP[$21];
    $i_o = $22;
    var $23 = $f;
    var $24 = $23;
    var $25 = $i_o;
    var $26 = $25;
    var $27 = $26;
    var $28 = $27;
    IHEAP[$28] = $24;
    var $29 = $i_o;
    var $30 = $29+8;
    IHEAP[$30] = 9;
    var $31 = $1;
    var $32 = $31;
    var $33 = IHEAP[$32];
    var $34 = $33+28;
    var $35 = IHEAP[$34];
    var $36 = $35;
    var $37 = $1;
    var $38 = $37;
    var $39 = IHEAP[$38];
    var $40 = $39+8;
    var $41 = IHEAP[$40];
    var $42 = $41;
    var $43 = $36;
    var $44 = $42;
    var $45 = $43 - $44;
    var $46 = $45 <= 12;
    ;
    if ($46) {
      ;
      var $48 = $1;
      var $49 = $48;
      var $50 = IHEAP[$49];
      __Z14luaD_growstackP9lua_Statei($50, 1);
      ;
    }
    else {
      ;
      ;
    }
    var $53 = $1;
    var $54 = $53;
    var $55 = IHEAP[$54];
    var $56 = $55+8;
    var $57 = IHEAP[$56];
    var $58 = $57+12;
    IHEAP[$56] = $58;
    var $59 = $1;
    var $60 = __Z10LoadStringP9LoadState($59);
    var $61 = $f;
    var $62 = $61+32;
    IHEAP[$62] = $60;
    var $63 = $f;
    var $64 = $63+32;
    var $65 = IHEAP[$64];
    var $66 = $65 == 0;
    ;
    if ($66) {
      ;
      var $68 = $2;
      var $69 = $f;
      var $70 = $69+32;
      IHEAP[$70] = $68;
      ;
    }
    var $72 = $1;
    var $73 = __Z7LoadIntP9LoadState($72);
    var $74 = $f;
    var $75 = $74+60;
    IHEAP[$75] = $73;
    var $76 = $1;
    var $77 = __Z7LoadIntP9LoadState($76);
    var $78 = $f;
    var $79 = $78+64;
    IHEAP[$79] = $77;
    var $80 = $1;
    var $81 = __Z8LoadCharP9LoadState($80);
    var $82 = $81;
    var $83 = $f;
    var $84 = $83+72;
    IHEAP[$84] = $82;
    var $85 = $1;
    var $86 = __Z8LoadCharP9LoadState($85);
    var $87 = $86;
    var $88 = $f;
    var $89 = $88+73;
    IHEAP[$89] = $87;
    var $90 = $1;
    var $91 = __Z8LoadCharP9LoadState($90);
    var $92 = $91;
    var $93 = $f;
    var $94 = $93+74;
    IHEAP[$94] = $92;
    var $95 = $1;
    var $96 = __Z8LoadCharP9LoadState($95);
    var $97 = $96;
    var $98 = $f;
    var $99 = $98+75;
    IHEAP[$99] = $97;
    var $100 = $1;
    var $101 = $f;
    __Z8LoadCodeP9LoadStateP5Proto($100, $101);
    var $102 = $1;
    var $103 = $f;
    __Z13LoadConstantsP9LoadStateP5Proto($102, $103);
    var $104 = $1;
    var $105 = $f;
    __Z9LoadDebugP9LoadStateP5Proto($104, $105);
    var $106 = $f;
    var $107 = __Z14luaG_checkcodePK5Proto($106);
    var $108 = $107 != 0;
    ;
    if (!$108) {
      ;
      var $110 = $1;
      __Z5errorP9LoadStatePKc($110, __str4212);
      ;
    }
    var $112 = $1;
    var $113 = $112;
    var $114 = IHEAP[$113];
    var $115 = $114+8;
    var $116 = IHEAP[$115];
    var $117 = $116+-12;
    IHEAP[$115] = $117;
    var $118 = $1;
    var $119 = $118;
    var $120 = IHEAP[$119];
    var $121 = $120+52;
    var $122 = IHEAP[$121];
    var $123 = $122 + -1;
    IHEAP[$121] = $123;
    var $124 = $f;
    ;
    return $124;
  }
  __Z12LoadFunctionP9LoadStateP7TString.__index__ = Runtime.getFunctionIndex(__Z12LoadFunctionP9LoadStateP7TString, "__Z12LoadFunctionP9LoadStateP7TString");
  
  
  function __Z11luaU_headerPc($h) {
    var __stackBase__  = STACKTOP; STACKTOP += 4; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $x = __stackBase__;
    $1 = $h;
    IHEAP[$x] = 1;
    var $2 = $1;
    _llvm_memcpy_p0i8_p0i8_i32($2, __str208, 4, 1, 0);
    var $3 = $1;
    var $4 = $3+4;
    $1 = $4;
    var $5 = $1;
    var $6 = $5+1;
    $1 = $6;
    IHEAP[$5] = 81;
    var $7 = $1;
    var $8 = $7+1;
    $1 = $8;
    IHEAP[$7] = 0;
    var $9 = $x;
    var $10 = IHEAP[$9];
    var $11 = $1;
    var $12 = $11+1;
    $1 = $12;
    IHEAP[$11] = $10;
    var $13 = $1;
    var $14 = $13+1;
    $1 = $14;
    IHEAP[$13] = 4;
    var $15 = $1;
    var $16 = $15+1;
    $1 = $16;
    IHEAP[$15] = 4;
    var $17 = $1;
    var $18 = $17+1;
    $1 = $18;
    IHEAP[$17] = 4;
    var $19 = $1;
    var $20 = $19+1;
    $1 = $20;
    IHEAP[$19] = 8;
    var $21 = $1;
    var $22 = $21+1;
    $1 = $22;
    IHEAP[$21] = 0;
    STACKTOP = __stackBase__;
    return;
  }
  __Z11luaU_headerPc.__index__ = Runtime.getFunctionIndex(__Z11luaU_headerPc, "__Z11luaU_headerPc");
  
  
  function __Z5errorP9LoadStatePKc($S, $why) {
    ;
    var __label__;
    var $1;
    var $2;
    $1 = $S;
    $2 = $why;
    var $3 = $1;
    var $4 = $3;
    var $5 = IHEAP[$4];
    var $6 = $1;
    var $7 = $6+12;
    var $8 = IHEAP[$7];
    var $9 = $2;
    var $10 = __Z16luaO_pushfstringP9lua_StatePKcz($5, __str8216, Pointer_make([$8,0,0,0,$9,0,0,0], 0, ALLOC_STACK));
    var $11 = $1;
    var $12 = $11;
    var $13 = IHEAP[$12];
    __Z10luaD_throwP9lua_Statei($13, 3);
    ;
    return;
  }
  __Z5errorP9LoadStatePKc.__index__ = Runtime.getFunctionIndex(__Z5errorP9LoadStatePKc, "__Z5errorP9LoadStatePKc");
  
  
  function __Z10LoadStringP9LoadState($S) {
    var __stackBase__  = STACKTOP; STACKTOP += 4; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $size = __stackBase__;
    var $s;
    $2 = $S;
    var $3 = $2;
    var $4 = $size;
    __Z9LoadBlockP9LoadStatePvj($3, $4, 4);
    var $5 = IHEAP[$size];
    var $6 = $5 == 0;
    ;
    if ($6) {
      ;
      $1 = 0;
      ;
    }
    else {
      ;
      var $9 = $2;
      var $10 = $9;
      var $11 = IHEAP[$10];
      var $12 = $2;
      var $13 = $12+8;
      var $14 = IHEAP[$13];
      var $15 = IHEAP[$size];
      var $16 = __Z14luaZ_openspaceP9lua_StateP7Mbufferj($11, $14, $15);
      $s = $16;
      var $17 = $2;
      var $18 = $s;
      var $19 = IHEAP[$size];
      __Z9LoadBlockP9LoadStatePvj($17, $18, $19);
      var $20 = $2;
      var $21 = $20;
      var $22 = IHEAP[$21];
      var $23 = $s;
      var $24 = IHEAP[$size];
      var $25 = $24 - 1;
      var $26 = __Z12luaS_newlstrP9lua_StatePKcj($22, $23, $25);
      $1 = $26;
      ;
    }
    var $28 = $1;
    STACKTOP = __stackBase__;
    return $28;
  }
  __Z10LoadStringP9LoadState.__index__ = Runtime.getFunctionIndex(__Z10LoadStringP9LoadState, "__Z10LoadStringP9LoadState");
  
  
  function __Z7LoadIntP9LoadState($S) {
    var __stackBase__  = STACKTOP; STACKTOP += 4; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $x = __stackBase__;
    $1 = $S;
    var $2 = $1;
    var $3 = $x;
    __Z9LoadBlockP9LoadStatePvj($2, $3, 4);
    var $4 = IHEAP[$x];
    var $5 = $4 < 0;
    ;
    if ($5) {
      ;
      var $7 = $1;
      __Z5errorP9LoadStatePKc($7, __str7215);
      ;
    }
    var $9 = IHEAP[$x];
    STACKTOP = __stackBase__;
    return $9;
  }
  __Z7LoadIntP9LoadState.__index__ = Runtime.getFunctionIndex(__Z7LoadIntP9LoadState, "__Z7LoadIntP9LoadState");
  
  
  function __Z8LoadCharP9LoadState($S) {
    var __stackBase__  = STACKTOP; STACKTOP += 1; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $x = __stackBase__;
    $1 = $S;
    var $2 = $1;
    __Z9LoadBlockP9LoadStatePvj($2, $x, 1);
    var $3 = IHEAP[$x];
    var $4 = $3;
    STACKTOP = __stackBase__;
    return $4;
  }
  __Z8LoadCharP9LoadState.__index__ = Runtime.getFunctionIndex(__Z8LoadCharP9LoadState, "__Z8LoadCharP9LoadState");
  
  
  function __Z8LoadCodeP9LoadStateP5Proto($S, $f) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $n;
    $1 = $S;
    $2 = $f;
    var $3 = $1;
    var $4 = __Z7LoadIntP9LoadState($3);
    $n = $4;
    var $5 = $n;
    var $6 = $5 + 1;
    var $7 = unSign($6, 32) <= unSign(1073741823, 32);
    ;
    if ($7) {
      ;
      var $9 = $1;
      var $10 = $9;
      var $11 = IHEAP[$10];
      var $12 = $n;
      var $13 = $12 * 4;
      var $14 = __Z13luaM_realloc_P9lua_StatePvjj($11, 0, 0, $13);
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $16 = $1;
      var $17 = $16;
      var $18 = IHEAP[$17];
      var $19 = __Z11luaM_toobigP9lua_State($18);
      __lastLabel__ = 2; ;
    }
    var $21 = __lastLabel__ == 0 ? $14 : ($19);
    var $22 = $21;
    var $23 = $2;
    var $24 = $23+12;
    IHEAP[$24] = $22;
    var $25 = $n;
    var $26 = $2;
    var $27 = $26+44;
    IHEAP[$27] = $25;
    var $28 = $1;
    var $29 = $2;
    var $30 = $29+12;
    var $31 = IHEAP[$30];
    var $32 = $31;
    var $33 = $n;
    var $34 = $33 * 4;
    __Z9LoadBlockP9LoadStatePvj($28, $32, $34);
    ;
    return;
  }
  __Z8LoadCodeP9LoadStateP5Proto.__index__ = Runtime.getFunctionIndex(__Z8LoadCodeP9LoadStateP5Proto, "__Z8LoadCodeP9LoadStateP5Proto");
  
  
  function __Z13LoadConstantsP9LoadStateP5Proto($S, $f) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $i;
    var $n;
    var $o;
    var $t;
    var $i_o;
    var $i_o1;
    var $i_o2;
    $1 = $S;
    $2 = $f;
    var $3 = $1;
    var $4 = __Z7LoadIntP9LoadState($3);
    $n = $4;
    var $5 = $n;
    var $6 = $5 + 1;
    var $7 = unSign($6, 32) <= unSign(357913941, 32);
    ;
    if ($7) {
      ;
      var $9 = $1;
      var $10 = $9;
      var $11 = IHEAP[$10];
      var $12 = $n;
      var $13 = $12 * 12;
      var $14 = __Z13luaM_realloc_P9lua_StatePvjj($11, 0, 0, $13);
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $16 = $1;
      var $17 = $16;
      var $18 = IHEAP[$17];
      var $19 = __Z11luaM_toobigP9lua_State($18);
      __lastLabel__ = 2; ;
    }
    var $21 = __lastLabel__ == 0 ? $14 : ($19);
    var $22 = $21;
    var $23 = $2;
    var $24 = $23+8;
    IHEAP[$24] = $22;
    var $25 = $n;
    var $26 = $2;
    var $27 = $26+40;
    IHEAP[$27] = $25;
    $i = 0;
    ;
    $28$6: while(1) { // $28
      var $29 = $i;
      var $30 = $n;
      var $31 = $29 < $30;
      if (!($31)) { __label__ = 5; /* $42 */ break $28$6; }
      var $33 = $i;
      var $34 = $2;
      var $35 = $34+8;
      var $36 = IHEAP[$35];
      var $37 = $36+12*$33;
      var $38 = $37+8;
      IHEAP[$38] = 0;
      ;
      var $40 = $i;
      var $41 = $40 + 1;
      $i = $41;
      __label__ = 3; /* $28 */ continue $28$6;
    }
    $i = 0;
    ;
    $43$11: while(1) { // $43
      var $44 = $i;
      var $45 = $n;
      var $46 = $44 < $45;
      if (!($46)) { __label__ = 9; /* $97 */ break $43$11; }
      var $48 = $i;
      var $49 = $2;
      var $50 = $49+8;
      var $51 = IHEAP[$50];
      var $52 = $51+12*$48;
      $o = $52;
      var $53 = $1;
      var $54 = __Z8LoadCharP9LoadState($53);
      $t = $54;
      var $55 = $t;
      if ($55 == 0) {
        __label__ = 23; /* $56 */ 
      }
      else if ($55 == 1) {
        __label__ = 24; /* $59 */ 
      }
      else if ($55 == 3) {
        __label__ = 25; /* $71 */ 
      }
      else if ($55 == 4) {
        __label__ = 26; /* $80 */ 
      }
      else {
      __label__ = 27; /* $91 */ 
      }
      
      if (__label__ == 27) {
        var $92 = $1;
        __Z5errorP9LoadStatePKc($92, __str6214);
        ;
      }
      else if (__label__ == 23) {
        var $57 = $o;
        var $58 = $57+8;
        IHEAP[$58] = 0;
        ;
      }
      else if (__label__ == 24) {
        var $60 = $o;
        $i_o = $60;
        var $61 = $1;
        var $62 = __Z8LoadCharP9LoadState($61);
        var $63 = $62 != 0;
        var $64 = $63;
        var $65 = $i_o;
        var $66 = $65;
        var $67 = $66;
        var $68 = $67;
        IHEAP[$68] = $64;
        var $69 = $i_o;
        var $70 = $69+8;
        IHEAP[$70] = 1;
        ;
      }
      else if (__label__ == 25) {
        var $72 = $o;
        $i_o1 = $72;
        var $73 = $1;
        var $74 = __Z10LoadNumberP9LoadState($73);
        var $75 = $i_o1;
        var $76 = $75;
        var $77 = $76;
        FHEAP[$77] = $74;
        var $78 = $i_o1;
        var $79 = $78+8;
        IHEAP[$79] = 3;
        ;
      }
      else if (__label__ == 26) {
        var $81 = $o;
        $i_o2 = $81;
        var $82 = $1;
        var $83 = __Z10LoadStringP9LoadState($82);
        var $84 = $83;
        var $85 = $i_o2;
        var $86 = $85;
        var $87 = $86;
        var $88 = $87;
        IHEAP[$88] = $84;
        var $89 = $i_o2;
        var $90 = $89+8;
        IHEAP[$90] = 4;
        ;
      }
      ;
      var $95 = $i;
      var $96 = $95 + 1;
      $i = $96;
      __label__ = 7; /* $43 */ continue $43$11;
    }
    var $98 = $1;
    var $99 = __Z7LoadIntP9LoadState($98);
    $n = $99;
    var $100 = $n;
    var $101 = $100 + 1;
    var $102 = unSign($101, 32) <= unSign(1073741823, 32);
    ;
    if ($102) {
      ;
      var $104 = $1;
      var $105 = $104;
      var $106 = IHEAP[$105];
      var $107 = $n;
      var $108 = $107 * 4;
      var $109 = __Z13luaM_realloc_P9lua_StatePvjj($106, 0, 0, $108);
      __lastLabel__ = 12; ;
    }
    else {
      ;
      var $111 = $1;
      var $112 = $111;
      var $113 = IHEAP[$112];
      var $114 = __Z11luaM_toobigP9lua_State($113);
      __lastLabel__ = 14; ;
    }
    var $116 = __lastLabel__ == 12 ? $109 : ($114);
    var $117 = $116;
    var $118 = $2;
    var $119 = $118+16;
    IHEAP[$119] = $117;
    var $120 = $n;
    var $121 = $2;
    var $122 = $121+52;
    IHEAP[$122] = $120;
    $i = 0;
    ;
    $123$27: while(1) { // $123
      var $124 = $i;
      var $125 = $n;
      var $126 = $124 < $125;
      if (!($126)) { __label__ = 17; /* $136 */ break $123$27; }
      var $128 = $i;
      var $129 = $2;
      var $130 = $129+16;
      var $131 = IHEAP[$130];
      var $132 = $131+4*$128;
      IHEAP[$132] = 0;
      ;
      var $134 = $i;
      var $135 = $134 + 1;
      $i = $135;
      __label__ = 15; /* $123 */ continue $123$27;
    }
    $i = 0;
    ;
    $137$32: while(1) { // $137
      var $138 = $i;
      var $139 = $n;
      var $140 = $138 < $139;
      if (!($140)) { __label__ = 21; /* $155 */ break $137$32; }
      var $142 = $1;
      var $143 = $2;
      var $144 = $143+32;
      var $145 = IHEAP[$144];
      var $146 = __Z12LoadFunctionP9LoadStateP7TString($142, $145);
      var $147 = $i;
      var $148 = $2;
      var $149 = $148+16;
      var $150 = IHEAP[$149];
      var $151 = $150+4*$147;
      IHEAP[$151] = $146;
      ;
      var $153 = $i;
      var $154 = $153 + 1;
      $i = $154;
      __label__ = 19; /* $137 */ continue $137$32;
    }
    ;
    return;
  }
  __Z13LoadConstantsP9LoadStateP5Proto.__index__ = Runtime.getFunctionIndex(__Z13LoadConstantsP9LoadStateP5Proto, "__Z13LoadConstantsP9LoadStateP5Proto");
  
  
  function __Z9LoadDebugP9LoadStateP5Proto($S, $f) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $i;
    var $n;
    $1 = $S;
    $2 = $f;
    var $3 = $1;
    var $4 = __Z7LoadIntP9LoadState($3);
    $n = $4;
    var $5 = $n;
    var $6 = $5 + 1;
    var $7 = unSign($6, 32) <= unSign(1073741823, 32);
    ;
    if ($7) {
      ;
      var $9 = $1;
      var $10 = $9;
      var $11 = IHEAP[$10];
      var $12 = $n;
      var $13 = $12 * 4;
      var $14 = __Z13luaM_realloc_P9lua_StatePvjj($11, 0, 0, $13);
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $16 = $1;
      var $17 = $16;
      var $18 = IHEAP[$17];
      var $19 = __Z11luaM_toobigP9lua_State($18);
      __lastLabel__ = 2; ;
    }
    var $21 = __lastLabel__ == 0 ? $14 : ($19);
    var $22 = $21;
    var $23 = $2;
    var $24 = $23+20;
    IHEAP[$24] = $22;
    var $25 = $n;
    var $26 = $2;
    var $27 = $26+48;
    IHEAP[$27] = $25;
    var $28 = $1;
    var $29 = $2;
    var $30 = $29+20;
    var $31 = IHEAP[$30];
    var $32 = $31;
    var $33 = $n;
    var $34 = $33 * 4;
    __Z9LoadBlockP9LoadStatePvj($28, $32, $34);
    var $35 = $1;
    var $36 = __Z7LoadIntP9LoadState($35);
    $n = $36;
    var $37 = $n;
    var $38 = $37 + 1;
    var $39 = unSign($38, 32) <= unSign(357913941, 32);
    ;
    if ($39) {
      ;
      var $41 = $1;
      var $42 = $41;
      var $43 = IHEAP[$42];
      var $44 = $n;
      var $45 = $44 * 12;
      var $46 = __Z13luaM_realloc_P9lua_StatePvjj($43, 0, 0, $45);
      __lastLabel__ = 3; ;
    }
    else {
      ;
      var $48 = $1;
      var $49 = $48;
      var $50 = IHEAP[$49];
      var $51 = __Z11luaM_toobigP9lua_State($50);
      __lastLabel__ = 5; ;
    }
    var $53 = __lastLabel__ == 3 ? $46 : ($51);
    var $54 = $53;
    var $55 = $2;
    var $56 = $55+24;
    IHEAP[$56] = $54;
    var $57 = $n;
    var $58 = $2;
    var $59 = $58+56;
    IHEAP[$59] = $57;
    $i = 0;
    ;
    $60$10: while(1) { // $60
      var $61 = $i;
      var $62 = $n;
      var $63 = $61 < $62;
      if (!($63)) { __label__ = 8; /* $74 */ break $60$10; }
      var $65 = $i;
      var $66 = $2;
      var $67 = $66+24;
      var $68 = IHEAP[$67];
      var $69 = $68+12*$65;
      var $70 = $69;
      IHEAP[$70] = 0;
      ;
      var $72 = $i;
      var $73 = $72 + 1;
      $i = $73;
      __label__ = 6; /* $60 */ continue $60$10;
    }
    $i = 0;
    ;
    $75$15: while(1) { // $75
      var $76 = $i;
      var $77 = $n;
      var $78 = $76 < $77;
      if (!($78)) { __label__ = 12; /* $107 */ break $75$15; }
      var $80 = $1;
      var $81 = __Z10LoadStringP9LoadState($80);
      var $82 = $i;
      var $83 = $2;
      var $84 = $83+24;
      var $85 = IHEAP[$84];
      var $86 = $85+12*$82;
      var $87 = $86;
      IHEAP[$87] = $81;
      var $88 = $1;
      var $89 = __Z7LoadIntP9LoadState($88);
      var $90 = $i;
      var $91 = $2;
      var $92 = $91+24;
      var $93 = IHEAP[$92];
      var $94 = $93+12*$90;
      var $95 = $94+4;
      IHEAP[$95] = $89;
      var $96 = $1;
      var $97 = __Z7LoadIntP9LoadState($96);
      var $98 = $i;
      var $99 = $2;
      var $100 = $99+24;
      var $101 = IHEAP[$100];
      var $102 = $101+12*$98;
      var $103 = $102+8;
      IHEAP[$103] = $97;
      ;
      var $105 = $i;
      var $106 = $105 + 1;
      $i = $106;
      __label__ = 10; /* $75 */ continue $75$15;
    }
    var $108 = $1;
    var $109 = __Z7LoadIntP9LoadState($108);
    $n = $109;
    var $110 = $n;
    var $111 = $110 + 1;
    var $112 = unSign($111, 32) <= unSign(1073741823, 32);
    ;
    if ($112) {
      ;
      var $114 = $1;
      var $115 = $114;
      var $116 = IHEAP[$115];
      var $117 = $n;
      var $118 = $117 * 4;
      var $119 = __Z13luaM_realloc_P9lua_StatePvjj($116, 0, 0, $118);
      __lastLabel__ = 14; ;
    }
    else {
      ;
      var $121 = $1;
      var $122 = $121;
      var $123 = IHEAP[$122];
      var $124 = __Z11luaM_toobigP9lua_State($123);
      __lastLabel__ = 16; ;
    }
    var $126 = __lastLabel__ == 14 ? $119 : ($124);
    var $127 = $126;
    var $128 = $2;
    var $129 = $128+28;
    IHEAP[$129] = $127;
    var $130 = $n;
    var $131 = $2;
    var $132 = $131+36;
    IHEAP[$132] = $130;
    $i = 0;
    ;
    $133$24: while(1) { // $133
      var $134 = $i;
      var $135 = $n;
      var $136 = $134 < $135;
      if (!($136)) { __label__ = 19; /* $146 */ break $133$24; }
      var $138 = $i;
      var $139 = $2;
      var $140 = $139+28;
      var $141 = IHEAP[$140];
      var $142 = $141+4*$138;
      IHEAP[$142] = 0;
      ;
      var $144 = $i;
      var $145 = $144 + 1;
      $i = $145;
      __label__ = 17; /* $133 */ continue $133$24;
    }
    $i = 0;
    ;
    $147$29: while(1) { // $147
      var $148 = $i;
      var $149 = $n;
      var $150 = $148 < $149;
      if (!($150)) { __label__ = 23; /* $162 */ break $147$29; }
      var $152 = $1;
      var $153 = __Z10LoadStringP9LoadState($152);
      var $154 = $i;
      var $155 = $2;
      var $156 = $155+28;
      var $157 = IHEAP[$156];
      var $158 = $157+4*$154;
      IHEAP[$158] = $153;
      ;
      var $160 = $i;
      var $161 = $160 + 1;
      $i = $161;
      __label__ = 21; /* $147 */ continue $147$29;
    }
    ;
    return;
  }
  __Z9LoadDebugP9LoadStateP5Proto.__index__ = Runtime.getFunctionIndex(__Z9LoadDebugP9LoadStateP5Proto, "__Z9LoadDebugP9LoadStateP5Proto");
  
  
  function __Z9LoadBlockP9LoadStatePvj($S, $b, $size) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $r;
    $1 = $S;
    $2 = $b;
    $3 = $size;
    var $4 = $1;
    var $5 = $4+4;
    var $6 = IHEAP[$5];
    var $7 = $2;
    var $8 = $3;
    var $9 = __Z9luaZ_readP3ZioPvj($6, $7, $8);
    $r = $9;
    var $10 = $r;
    var $11 = $10 != 0;
    ;
    if ($11) {
      ;
      var $13 = $1;
      __Z5errorP9LoadStatePKc($13, __str5213);
      ;
    }
    ;
    return;
  }
  __Z9LoadBlockP9LoadStatePvj.__index__ = Runtime.getFunctionIndex(__Z9LoadBlockP9LoadStatePvj, "__Z9LoadBlockP9LoadStatePvj");
  
  
  function __Z10LoadNumberP9LoadState($S) {
    var __stackBase__  = STACKTOP; STACKTOP += 8; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $x = __stackBase__;
    $1 = $S;
    var $2 = $1;
    var $3 = $x;
    __Z9LoadBlockP9LoadStatePvj($2, $3, 8);
    var $4 = FHEAP[$x];
    STACKTOP = __stackBase__;
    return $4;
  }
  __Z10LoadNumberP9LoadState.__index__ = Runtime.getFunctionIndex(__Z10LoadNumberP9LoadState, "__Z10LoadNumberP9LoadState");
  
  
  function __Z13luaV_tonumberPK10lua_TValuePS_($obj, $n) {
    var __stackBase__  = STACKTOP; STACKTOP += 8; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $num = __stackBase__;
    var $i_o;
    $2 = $obj;
    $3 = $n;
    var $4 = $2;
    var $5 = $4+8;
    var $6 = IHEAP[$5];
    var $7 = $6 == 3;
    ;
    $8$10$2: do { 
      if ($7) {
        ;
        var $9 = $2;
        $1 = $9;
        ;
      }
      else {
        ;
        var $11 = $2;
        var $12 = $11+8;
        var $13 = IHEAP[$12];
        var $14 = $13 == 4;
        ;
        $15$36$5: do { 
          if ($14) {
            ;
            var $16 = $2;
            var $17 = $16;
            var $18 = $17;
            var $19 = $18;
            var $20 = IHEAP[$19];
            var $21 = $20;
            var $22 = $21;
            var $23 = $22+16;
            var $24 = $23;
            var $25 = __Z10luaO_str2dPKcPd($24, $num);
            var $26 = $25 != 0;
            if (!($26)) { __label__ = 2; /* $36 */ break $15$36$5; }
            var $28 = $3;
            $i_o = $28;
            var $29 = FHEAP[$num];
            var $30 = $i_o;
            var $31 = $30;
            var $32 = $31;
            FHEAP[$32] = $29;
            var $33 = $i_o;
            var $34 = $33+8;
            IHEAP[$34] = 3;
            var $35 = $3;
            $1 = $35;
            __label__ = 3; /* $37 */ break $8$10$2;
          }
        } while(0);
        $1 = 0;
        ;
      }
    } while(0);
    var $38 = $1;
    STACKTOP = __stackBase__;
    return $38;
  }
  __Z13luaV_tonumberPK10lua_TValuePS_.__index__ = Runtime.getFunctionIndex(__Z13luaV_tonumberPK10lua_TValuePS_, "__Z13luaV_tonumberPK10lua_TValuePS_");
  
  
  function __Z13luaV_tostringP9lua_StateP10lua_TValue($L, $obj) {
    var __stackBase__  = STACKTOP; STACKTOP += 32; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $s = __stackBase__;
    var $n;
    var $i_o;
    $2 = $L;
    $3 = $obj;
    var $4 = $3;
    var $5 = $4+8;
    var $6 = IHEAP[$5];
    var $7 = $6 == 3;
    ;
    if ($7) {
      ;
      var $10 = $3;
      var $11 = $10;
      var $12 = $11;
      var $13 = FHEAP[$12];
      $n = $13;
      var $14 = $s;
      var $15 = $n;
      var $16 = _sprintf($14, __str220, $15);
      var $17 = $3;
      $i_o = $17;
      var $18 = $2;
      var $19 = $s;
      var $20 = $s;
      var $21 = _strlen($20);
      var $22 = __Z12luaS_newlstrP9lua_StatePKcj($18, $19, $21);
      var $23 = $22;
      var $24 = $i_o;
      var $25 = $24;
      var $26 = $25;
      var $27 = $26;
      IHEAP[$27] = $23;
      var $28 = $i_o;
      var $29 = $28+8;
      IHEAP[$29] = 4;
      $1 = 1;
      ;
    }
    else {
      ;
      $1 = 0;
      ;
    }
    var $31 = $1;
    STACKTOP = __stackBase__;
    return $31;
  }
  __Z13luaV_tostringP9lua_StateP10lua_TValue.__index__ = Runtime.getFunctionIndex(__Z13luaV_tostringP9lua_StateP10lua_TValue, "__Z13luaV_tostringP9lua_StateP10lua_TValue");
  
  
  function __Z13luaV_gettableP9lua_StatePK10lua_TValuePS1_S4_($L, $t, $key, $val) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $4;
    var $loop;
    var $tm;
    var $h;
    var $res;
    var $o2;
    var $o1;
    $1 = $L;
    $2 = $t;
    $3 = $key;
    $4 = $val;
    $loop = 0;
    ;
    $5$2: while(1) { // $5
      var $6 = $loop;
      var $7 = $6 < 100;
      if (!($7)) { __label__ = 2; /* $102 */ break $5$2; }
      var $9 = $2;
      var $10 = $9+8;
      var $11 = IHEAP[$10];
      var $12 = $11 == 5;
      ;
      if ($12) {
        ;
        var $14 = $2;
        var $15 = $14;
        var $16 = $15;
        var $17 = $16;
        var $18 = IHEAP[$17];
        var $19 = $18;
        var $20 = $19;
        $h = $20;
        var $21 = $h;
        var $22 = $3;
        var $23 = __Z8luaH_getP5TablePK10lua_TValue($21, $22);
        $res = $23;
        var $24 = $res;
        var $25 = $24+8;
        var $26 = IHEAP[$25];
        var $27 = $26 == 0;
        if (!($27)) { __label__ = 4; /* $60 */ break $5$2; }
        var $29 = $h;
        var $30 = $29+8;
        var $31 = IHEAP[$30];
        var $32 = $31 == 0;
        ;
        if ($32) {
          ;
          __lastLabel__ = 5; ;
        }
        else {
          ;
          var $35 = $h;
          var $36 = $35+8;
          var $37 = IHEAP[$36];
          var $38 = $37+6;
          var $39 = IHEAP[$38];
          var $40 = $39;
          var $41 = $40 & 1;
          var $42 = $41 != 0;
          ;
          if ($42) {
            ;
            __lastLabel__ = 7; ;
          }
          else {
            ;
            var $45 = $h;
            var $46 = $45+8;
            var $47 = IHEAP[$46];
            var $48 = $1;
            var $49 = $48+16;
            var $50 = IHEAP[$49];
            var $51 = $50+168;
            var $52 = $51;
            var $53 = IHEAP[$52];
            var $54 = __Z10luaT_gettmP5Table3TMSP7TString($47, 0, $53);
            __lastLabel__ = 9; ;
          }
          var $56 = __lastLabel__ == 7 ? 0 : ($54);
          __lastLabel__ = 10; ;
        }
        var $58 = __lastLabel__ == 5 ? 0 : ($56);
        $tm = $58;
        var $59 = $58 == 0;
        if ($59) { __label__ = 4; /* $60 */ break $5$2; }
        ;
      }
      else {
        ;
        var $76 = $1;
        var $77 = $2;
        var $78 = __Z15luaT_gettmbyobjP9lua_StatePK10lua_TValue3TMS($76, $77, 0);
        $tm = $78;
        var $79 = $78+8;
        var $80 = IHEAP[$79];
        var $81 = $80 == 0;
        ;
        if ($81) {
          ;
          var $83 = $1;
          var $84 = $2;
          __Z14luaG_typeerrorP9lua_StatePK10lua_TValuePKc($83, $84, __str1221);
          ;
        }
        ;
      }
      var $87 = $tm;
      var $88 = $87+8;
      var $89 = IHEAP[$88];
      var $90 = $89 == 6;
      if ($90) { __label__ = 15; /* $91 */ break $5$2; }
      var $98 = $tm;
      $2 = $98;
      ;
      var $100 = $loop;
      var $101 = $100 + 1;
      $loop = $101;
      __label__ = 0; /* $5 */ continue $5$2;
    }
    if (__label__ == 2) {
      var $103 = $1;
      __Z13luaG_runerrorP9lua_StatePKcz($103, __str2222);
      ;
    }
    else if (__label__ == 4) {
      var $61 = $res;
      $o2 = $61;
      var $62 = $4;
      $o1 = $62;
      var $63 = $o1;
      var $64 = $63;
      var $65 = $o2;
      var $66 = $65;
      var $67 = $64;
      var $68 = $66;
      _llvm_memcpy_p0i8_p0i8_i32($67, $68, 8, 4, 0);
      var $69 = $o2;
      var $70 = $69+8;
      var $71 = IHEAP[$70];
      var $72 = $o1;
      var $73 = $72+8;
      IHEAP[$73] = $71;
      ;
    }
    else if (__label__ == 15) {
      var $92 = $1;
      var $93 = $4;
      var $94 = $tm;
      var $95 = $2;
      var $96 = $3;
      __Z9callTMresP9lua_StateP10lua_TValuePKS1_S4_S4_($92, $93, $94, $95, $96);
      ;
    }
    ;
    return;
  }
  __Z13luaV_gettableP9lua_StatePK10lua_TValuePS1_S4_.__index__ = Runtime.getFunctionIndex(__Z13luaV_gettableP9lua_StatePK10lua_TValuePS1_S4_, "__Z13luaV_gettableP9lua_StatePK10lua_TValuePS1_S4_");
  
  
  function __Z9callTMresP9lua_StateP10lua_TValuePKS1_S4_S4_($L, $res, $f, $p1, $p2) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $5;
    var $result;
    var $o2;
    var $o1;
    var $o21;
    var $o12;
    var $o23;
    var $o14;
    var $o25;
    var $o16;
    $1 = $L;
    $2 = $res;
    $3 = $f;
    $4 = $p1;
    $5 = $p2;
    var $6 = $2;
    var $7 = $6;
    var $8 = $1;
    var $9 = $8+32;
    var $10 = IHEAP[$9];
    var $11 = $10;
    var $12 = $7;
    var $13 = $11;
    var $14 = $12 - $13;
    $result = $14;
    var $15 = $3;
    $o2 = $15;
    var $16 = $1;
    var $17 = $16+8;
    var $18 = IHEAP[$17];
    $o1 = $18;
    var $19 = $o1;
    var $20 = $19;
    var $21 = $o2;
    var $22 = $21;
    var $23 = $20;
    var $24 = $22;
    _llvm_memcpy_p0i8_p0i8_i32($23, $24, 8, 4, 0);
    var $25 = $o2;
    var $26 = $25+8;
    var $27 = IHEAP[$26];
    var $28 = $o1;
    var $29 = $28+8;
    IHEAP[$29] = $27;
    var $30 = $4;
    $o21 = $30;
    var $31 = $1;
    var $32 = $31+8;
    var $33 = IHEAP[$32];
    var $34 = $33+12;
    $o12 = $34;
    var $35 = $o12;
    var $36 = $35;
    var $37 = $o21;
    var $38 = $37;
    var $39 = $36;
    var $40 = $38;
    _llvm_memcpy_p0i8_p0i8_i32($39, $40, 8, 4, 0);
    var $41 = $o21;
    var $42 = $41+8;
    var $43 = IHEAP[$42];
    var $44 = $o12;
    var $45 = $44+8;
    IHEAP[$45] = $43;
    var $46 = $5;
    $o23 = $46;
    var $47 = $1;
    var $48 = $47+8;
    var $49 = IHEAP[$48];
    var $50 = $49+24;
    $o14 = $50;
    var $51 = $o14;
    var $52 = $51;
    var $53 = $o23;
    var $54 = $53;
    var $55 = $52;
    var $56 = $54;
    _llvm_memcpy_p0i8_p0i8_i32($55, $56, 8, 4, 0);
    var $57 = $o23;
    var $58 = $57+8;
    var $59 = IHEAP[$58];
    var $60 = $o14;
    var $61 = $60+8;
    IHEAP[$61] = $59;
    var $62 = $1;
    var $63 = $62+28;
    var $64 = IHEAP[$63];
    var $65 = $64;
    var $66 = $1;
    var $67 = $66+8;
    var $68 = IHEAP[$67];
    var $69 = $68;
    var $70 = $65;
    var $71 = $69;
    var $72 = $70 - $71;
    var $73 = $72 <= 36;
    ;
    if ($73) {
      ;
      var $75 = $1;
      __Z14luaD_growstackP9lua_Statei($75, 3);
      ;
    }
    else {
      ;
      ;
    }
    var $78 = $1;
    var $79 = $78+8;
    var $80 = IHEAP[$79];
    var $81 = $80+36;
    IHEAP[$79] = $81;
    var $82 = $1;
    var $83 = $1;
    var $84 = $83+8;
    var $85 = IHEAP[$84];
    var $86 = $85+-36;
    __Z9luaD_callP9lua_StateP10lua_TValuei($82, $86, 1);
    var $87 = $1;
    var $88 = $87+32;
    var $89 = IHEAP[$88];
    var $90 = $89;
    var $91 = $result;
    var $92 = $90+$91;
    var $93 = $92;
    $2 = $93;
    var $94 = $1;
    var $95 = $94+8;
    var $96 = IHEAP[$95];
    var $97 = $96+-12;
    IHEAP[$95] = $97;
    var $98 = $1;
    var $99 = $98+8;
    var $100 = IHEAP[$99];
    $o25 = $100;
    var $101 = $2;
    $o16 = $101;
    var $102 = $o16;
    var $103 = $102;
    var $104 = $o25;
    var $105 = $104;
    var $106 = $103;
    var $107 = $105;
    _llvm_memcpy_p0i8_p0i8_i32($106, $107, 8, 4, 0);
    var $108 = $o25;
    var $109 = $108+8;
    var $110 = IHEAP[$109];
    var $111 = $o16;
    var $112 = $111+8;
    IHEAP[$112] = $110;
    ;
    return;
  }
  __Z9callTMresP9lua_StateP10lua_TValuePKS1_S4_S4_.__index__ = Runtime.getFunctionIndex(__Z9callTMresP9lua_StateP10lua_TValuePKS1_S4_S4_, "__Z9callTMresP9lua_StateP10lua_TValuePKS1_S4_S4_");
  
  
  function __Z13luaV_settableP9lua_StatePK10lua_TValuePS1_S4_($L, $t, $key, $val) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $4;
    var $loop;
    var $tm;
    var $h;
    var $oldval;
    var $o2;
    var $o1;
    $1 = $L;
    $2 = $t;
    $3 = $key;
    $4 = $val;
    $loop = 0;
    ;
    $5$2: while(1) { // $5
      var $6 = $loop;
      var $7 = $6 < 100;
      if (!($7)) { __label__ = 2; /* $134 */ break $5$2; }
      var $9 = $2;
      var $10 = $9+8;
      var $11 = IHEAP[$10];
      var $12 = $11 == 5;
      ;
      if ($12) {
        ;
        var $14 = $2;
        var $15 = $14;
        var $16 = $15;
        var $17 = $16;
        var $18 = IHEAP[$17];
        var $19 = $18;
        var $20 = $19;
        $h = $20;
        var $21 = $1;
        var $22 = $h;
        var $23 = $3;
        var $24 = __Z8luaH_setP9lua_StateP5TablePK10lua_TValue($21, $22, $23);
        $oldval = $24;
        var $25 = $oldval;
        var $26 = $25+8;
        var $27 = IHEAP[$26];
        var $28 = $27 == 0;
        if (!($28)) { __label__ = 4; /* $61 */ break $5$2; }
        var $30 = $h;
        var $31 = $30+8;
        var $32 = IHEAP[$31];
        var $33 = $32 == 0;
        ;
        if ($33) {
          ;
          __lastLabel__ = 5; ;
        }
        else {
          ;
          var $36 = $h;
          var $37 = $36+8;
          var $38 = IHEAP[$37];
          var $39 = $38+6;
          var $40 = IHEAP[$39];
          var $41 = $40;
          var $42 = $41 & 2;
          var $43 = $42 != 0;
          ;
          if ($43) {
            ;
            __lastLabel__ = 7; ;
          }
          else {
            ;
            var $46 = $h;
            var $47 = $46+8;
            var $48 = IHEAP[$47];
            var $49 = $1;
            var $50 = $49+16;
            var $51 = IHEAP[$50];
            var $52 = $51+168;
            var $53 = $52+4;
            var $54 = IHEAP[$53];
            var $55 = __Z10luaT_gettmP5Table3TMSP7TString($48, 1, $54);
            __lastLabel__ = 9; ;
          }
          var $57 = __lastLabel__ == 7 ? 0 : ($55);
          __lastLabel__ = 10; ;
        }
        var $59 = __lastLabel__ == 5 ? 0 : ($57);
        $tm = $59;
        var $60 = $59 == 0;
        if ($60) { __label__ = 4; /* $61 */ break $5$2; }
        ;
      }
      else {
        ;
        var $108 = $1;
        var $109 = $2;
        var $110 = __Z15luaT_gettmbyobjP9lua_StatePK10lua_TValue3TMS($108, $109, 1);
        $tm = $110;
        var $111 = $110+8;
        var $112 = IHEAP[$111];
        var $113 = $112 == 0;
        ;
        if ($113) {
          ;
          var $115 = $1;
          var $116 = $2;
          __Z14luaG_typeerrorP9lua_StatePK10lua_TValuePKc($115, $116, __str1221);
          ;
        }
        ;
      }
      var $119 = $tm;
      var $120 = $119+8;
      var $121 = IHEAP[$120];
      var $122 = $121 == 6;
      if ($122) { __label__ = 19; /* $123 */ break $5$2; }
      var $130 = $tm;
      $2 = $130;
      ;
      var $132 = $loop;
      var $133 = $132 + 1;
      $loop = $133;
      __label__ = 0; /* $5 */ continue $5$2;
    }
    if (__label__ == 2) {
      var $135 = $1;
      __Z13luaG_runerrorP9lua_StatePKcz($135, __str3223);
      ;
    }
    else if (__label__ == 4) {
      var $62 = $4;
      $o2 = $62;
      var $63 = $oldval;
      $o1 = $63;
      var $64 = $o1;
      var $65 = $64;
      var $66 = $o2;
      var $67 = $66;
      var $68 = $65;
      var $69 = $67;
      _llvm_memcpy_p0i8_p0i8_i32($68, $69, 8, 4, 0);
      var $70 = $o2;
      var $71 = $70+8;
      var $72 = IHEAP[$71];
      var $73 = $o1;
      var $74 = $73+8;
      IHEAP[$74] = $72;
      var $75 = $4;
      var $76 = $75+8;
      var $77 = IHEAP[$76];
      var $78 = $77 >= 4;
      ;
      $79$105$27: do { 
        if ($78) {
          ;
          var $80 = $4;
          var $81 = $80;
          var $82 = $81;
          var $83 = $82;
          var $84 = IHEAP[$83];
          var $85 = $84;
          var $86 = $85;
          var $87 = $86+5;
          var $88 = IHEAP[$87];
          var $89 = $88;
          var $90 = $89 & 3;
          var $91 = $90 != 0;
          if (!($91)) { __label__ = 13; /* $105 */ break $79$105$27; }
          var $93 = $h;
          var $94 = $93;
          var $95 = $94;
          var $96 = $95;
          var $97 = $96+5;
          var $98 = IHEAP[$97];
          var $99 = $98;
          var $100 = $99 & 4;
          var $101 = $100 != 0;
          if (!($101)) { __label__ = 13; /* $105 */ break $79$105$27; }
          var $103 = $1;
          var $104 = $h;
          __Z16luaC_barrierbackP9lua_StateP5Table($103, $104);
          ;
        }
      } while(0);
      ;
    }
    else if (__label__ == 19) {
      var $124 = $1;
      var $125 = $tm;
      var $126 = $2;
      var $127 = $3;
      var $128 = $4;
      __Z6callTMP9lua_StatePK10lua_TValueS3_S3_S3_($124, $125, $126, $127, $128);
      ;
    }
    ;
    return;
  }
  __Z13luaV_settableP9lua_StatePK10lua_TValuePS1_S4_.__index__ = Runtime.getFunctionIndex(__Z13luaV_settableP9lua_StatePK10lua_TValuePS1_S4_, "__Z13luaV_settableP9lua_StatePK10lua_TValuePS1_S4_");
  
  
  function __Z6callTMP9lua_StatePK10lua_TValueS3_S3_S3_($L, $f, $p1, $p2, $p3) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $5;
    var $o2;
    var $o1;
    var $o21;
    var $o12;
    var $o23;
    var $o14;
    var $o25;
    var $o16;
    $1 = $L;
    $2 = $f;
    $3 = $p1;
    $4 = $p2;
    $5 = $p3;
    var $6 = $2;
    $o2 = $6;
    var $7 = $1;
    var $8 = $7+8;
    var $9 = IHEAP[$8];
    $o1 = $9;
    var $10 = $o1;
    var $11 = $10;
    var $12 = $o2;
    var $13 = $12;
    var $14 = $11;
    var $15 = $13;
    _llvm_memcpy_p0i8_p0i8_i32($14, $15, 8, 4, 0);
    var $16 = $o2;
    var $17 = $16+8;
    var $18 = IHEAP[$17];
    var $19 = $o1;
    var $20 = $19+8;
    IHEAP[$20] = $18;
    var $21 = $3;
    $o21 = $21;
    var $22 = $1;
    var $23 = $22+8;
    var $24 = IHEAP[$23];
    var $25 = $24+12;
    $o12 = $25;
    var $26 = $o12;
    var $27 = $26;
    var $28 = $o21;
    var $29 = $28;
    var $30 = $27;
    var $31 = $29;
    _llvm_memcpy_p0i8_p0i8_i32($30, $31, 8, 4, 0);
    var $32 = $o21;
    var $33 = $32+8;
    var $34 = IHEAP[$33];
    var $35 = $o12;
    var $36 = $35+8;
    IHEAP[$36] = $34;
    var $37 = $4;
    $o23 = $37;
    var $38 = $1;
    var $39 = $38+8;
    var $40 = IHEAP[$39];
    var $41 = $40+24;
    $o14 = $41;
    var $42 = $o14;
    var $43 = $42;
    var $44 = $o23;
    var $45 = $44;
    var $46 = $43;
    var $47 = $45;
    _llvm_memcpy_p0i8_p0i8_i32($46, $47, 8, 4, 0);
    var $48 = $o23;
    var $49 = $48+8;
    var $50 = IHEAP[$49];
    var $51 = $o14;
    var $52 = $51+8;
    IHEAP[$52] = $50;
    var $53 = $5;
    $o25 = $53;
    var $54 = $1;
    var $55 = $54+8;
    var $56 = IHEAP[$55];
    var $57 = $56+36;
    $o16 = $57;
    var $58 = $o16;
    var $59 = $58;
    var $60 = $o25;
    var $61 = $60;
    var $62 = $59;
    var $63 = $61;
    _llvm_memcpy_p0i8_p0i8_i32($62, $63, 8, 4, 0);
    var $64 = $o25;
    var $65 = $64+8;
    var $66 = IHEAP[$65];
    var $67 = $o16;
    var $68 = $67+8;
    IHEAP[$68] = $66;
    var $69 = $1;
    var $70 = $69+28;
    var $71 = IHEAP[$70];
    var $72 = $71;
    var $73 = $1;
    var $74 = $73+8;
    var $75 = IHEAP[$74];
    var $76 = $75;
    var $77 = $72;
    var $78 = $76;
    var $79 = $77 - $78;
    var $80 = $79 <= 48;
    ;
    if ($80) {
      ;
      var $82 = $1;
      __Z14luaD_growstackP9lua_Statei($82, 4);
      ;
    }
    else {
      ;
      ;
    }
    var $85 = $1;
    var $86 = $85+8;
    var $87 = IHEAP[$86];
    var $88 = $87+48;
    IHEAP[$86] = $88;
    var $89 = $1;
    var $90 = $1;
    var $91 = $90+8;
    var $92 = IHEAP[$91];
    var $93 = $92+-48;
    __Z9luaD_callP9lua_StateP10lua_TValuei($89, $93, 0);
    ;
    return;
  }
  __Z6callTMP9lua_StatePK10lua_TValueS3_S3_S3_.__index__ = Runtime.getFunctionIndex(__Z6callTMP9lua_StatePK10lua_TValueS3_S3_S3_, "__Z6callTMP9lua_StatePK10lua_TValueS3_S3_S3_");
  
  
  function __Z13luaV_lessthanP9lua_StatePK10lua_TValueS3_($L, $l, $r) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $res;
    $2 = $L;
    $3 = $l;
    $4 = $r;
    var $5 = $3;
    var $6 = $5+8;
    var $7 = IHEAP[$6];
    var $8 = $4;
    var $9 = $8+8;
    var $10 = IHEAP[$9];
    var $11 = $7 != $10;
    ;
    if ($11) {
      ;
      var $13 = $2;
      var $14 = $3;
      var $15 = $4;
      var $16 = __Z15luaG_ordererrorP9lua_StatePK10lua_TValueS3_($13, $14, $15);
      $1 = $16;
      ;
    }
    else {
      ;
      var $18 = $3;
      var $19 = $18+8;
      var $20 = IHEAP[$19];
      var $21 = $20 == 3;
      ;
      if ($21) {
        ;
        var $23 = $3;
        var $24 = $23;
        var $25 = $24;
        var $26 = FHEAP[$25];
        var $27 = $4;
        var $28 = $27;
        var $29 = $28;
        var $30 = FHEAP[$29];
        var $31 = $26 < $30;
        var $32 = $31;
        $1 = $32;
        ;
      }
      else {
        ;
        var $34 = $3;
        var $35 = $34+8;
        var $36 = IHEAP[$35];
        var $37 = $36 == 4;
        ;
        if ($37) {
          ;
          var $39 = $3;
          var $40 = $39;
          var $41 = $40;
          var $42 = $41;
          var $43 = IHEAP[$42];
          var $44 = $43;
          var $45 = $44;
          var $46 = $4;
          var $47 = $46;
          var $48 = $47;
          var $49 = $48;
          var $50 = IHEAP[$49];
          var $51 = $50;
          var $52 = $51;
          var $53 = __Z8l_strcmpPK7TStringS1_($45, $52);
          var $54 = $53 < 0;
          var $55 = $54;
          $1 = $55;
          ;
        }
        else {
          ;
          var $57 = $2;
          var $58 = $3;
          var $59 = $4;
          var $60 = __Z12call_orderTMP9lua_StatePK10lua_TValueS3_3TMS($57, $58, $59, 13);
          $res = $60;
          var $61 = $60 != -1;
          ;
          if ($61) {
            ;
            var $63 = $res;
            $1 = $63;
            ;
          }
          else {
            ;
            ;
            ;
            ;
            var $68 = $2;
            var $69 = $3;
            var $70 = $4;
            var $71 = __Z15luaG_ordererrorP9lua_StatePK10lua_TValueS3_($68, $69, $70);
            $1 = $71;
            ;
          }
        }
      }
    }
    var $73 = $1;
    ;
    return $73;
  }
  __Z13luaV_lessthanP9lua_StatePK10lua_TValueS3_.__index__ = Runtime.getFunctionIndex(__Z13luaV_lessthanP9lua_StatePK10lua_TValueS3_, "__Z13luaV_lessthanP9lua_StatePK10lua_TValueS3_");
  
  
  function __Z8l_strcmpPK7TStringS1_($ls, $rs) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $l;
    var $ll;
    var $r;
    var $lr;
    var $temp;
    var $len;
    $2 = $ls;
    $3 = $rs;
    var $4 = $2;
    var $5 = $4+16;
    var $6 = $5;
    $l = $6;
    var $7 = $2;
    var $8 = $7;
    var $9 = $8+12;
    var $10 = IHEAP[$9];
    $ll = $10;
    var $11 = $3;
    var $12 = $11+16;
    var $13 = $12;
    $r = $13;
    var $14 = $3;
    var $15 = $14;
    var $16 = $15+12;
    var $17 = IHEAP[$16];
    $lr = $17;
    ;
    $18$2: while(1) { // $18
      var $19 = $l;
      var $20 = $r;
      var $21 = _strcoll($19, $20);
      $temp = $21;
      var $22 = $temp;
      var $23 = $22 != 0;
      if ($23) { __label__ = 1; /* $24 */ break $18$2; }
      var $27 = $l;
      var $28 = _strlen($27);
      $len = $28;
      var $29 = $len;
      var $30 = $lr;
      var $31 = $29 == $30;
      if ($31) { __label__ = 4; /* $32 */ break $18$2; }
      var $38 = $len;
      var $39 = $ll;
      var $40 = $38 == $39;
      if ($40) { __label__ = 6; /* $41 */ break $18$2; }
      ;
      var $44 = $len;
      var $45 = $44 + 1;
      $len = $45;
      var $46 = $len;
      var $47 = $l;
      var $48 = $47+$46;
      $l = $48;
      var $49 = $len;
      var $50 = $ll;
      var $51 = $50 - $49;
      $ll = $51;
      var $52 = $len;
      var $53 = $r;
      var $54 = $53+$52;
      $r = $54;
      var $55 = $len;
      var $56 = $lr;
      var $57 = $56 - $55;
      $lr = $57;
      ;
      __label__ = 0; /* $18 */ continue $18$2;
    }
    if (__label__ == 1) {
      var $25 = $temp;
      $1 = $25;
      ;
    }
    else if (__label__ == 4) {
      var $33 = $len;
      var $34 = $ll;
      var $35 = $33 == $34;
      var $36 = $35 ? 0 : 1;
      $1 = $36;
      ;
    }
    else if (__label__ == 6) {
      $1 = -1;
      ;
    }
    var $60 = $1;
    ;
    return $60;
  }
  __Z8l_strcmpPK7TStringS1_.__index__ = Runtime.getFunctionIndex(__Z8l_strcmpPK7TStringS1_, "__Z8l_strcmpPK7TStringS1_");
  
  
  function __Z12call_orderTMP9lua_StatePK10lua_TValueS3_3TMS($L, $p1, $p2, $event) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $4;
    var $5;
    var $tm1;
    var $tm2;
    $2 = $L;
    $3 = $p1;
    $4 = $p2;
    $5 = $event;
    var $6 = $2;
    var $7 = $3;
    var $8 = $5;
    var $9 = __Z15luaT_gettmbyobjP9lua_StatePK10lua_TValue3TMS($6, $7, $8);
    $tm1 = $9;
    var $10 = $tm1;
    var $11 = $10+8;
    var $12 = IHEAP[$11];
    var $13 = $12 == 0;
    ;
    if ($13) {
      ;
      $1 = -1;
      ;
    }
    else {
      ;
      var $16 = $2;
      var $17 = $4;
      var $18 = $5;
      var $19 = __Z15luaT_gettmbyobjP9lua_StatePK10lua_TValue3TMS($16, $17, $18);
      $tm2 = $19;
      var $20 = $tm1;
      var $21 = $tm2;
      var $22 = __Z16luaO_rawequalObjPK10lua_TValueS1_($20, $21);
      var $23 = $22 != 0;
      ;
      if ($23) {
        ;
        var $26 = $2;
        var $27 = $2;
        var $28 = $27+8;
        var $29 = IHEAP[$28];
        var $30 = $tm1;
        var $31 = $3;
        var $32 = $4;
        __Z9callTMresP9lua_StateP10lua_TValuePKS1_S4_S4_($26, $29, $30, $31, $32);
        var $33 = $2;
        var $34 = $33+8;
        var $35 = IHEAP[$34];
        var $36 = $35+8;
        var $37 = IHEAP[$36];
        var $38 = $37 == 0;
        ;
        if ($38) {
          __lastLabel__ = 6; ;
        }
        else {
          __lastLabel__ = 6; ;
          var $40 = $2;
          var $41 = $40+8;
          var $42 = IHEAP[$41];
          var $43 = $42+8;
          var $44 = IHEAP[$43];
          var $45 = $44 == 1;
          ;
          if ($45) {
            __lastLabel__ = 5; ;
            var $47 = $2;
            var $48 = $47+8;
            var $49 = IHEAP[$48];
            var $50 = $49;
            var $51 = $50;
            var $52 = $51;
            var $53 = IHEAP[$52];
            var $54 = $53 == 0;
            __lastLabel__ = 1; ;
          }
          else {
            __lastLabel__ = 5; ;
          }
          var $56 = __lastLabel__ == 5 ? 0 : ($54);
          __lastLabel__ = 3; ;
        }
        var $58 = __lastLabel__ == 6 ? 1 : ($56);
        var $59 = $58 ^ 1;
        var $60 = $59;
        $1 = $60;
        ;
      }
      else {
        ;
        $1 = -1;
        ;
      }
    }
    var $62 = $1;
    ;
    return $62;
  }
  __Z12call_orderTMP9lua_StatePK10lua_TValueS3_3TMS.__index__ = Runtime.getFunctionIndex(__Z12call_orderTMP9lua_StatePK10lua_TValueS3_3TMS, "__Z12call_orderTMP9lua_StatePK10lua_TValueS3_3TMS");
  
  
  function __Z13luaV_equalvalP9lua_StatePK10lua_TValueS3_($L, $t1, $t2) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $4;
    var $tm;
    $2 = $L;
    $3 = $t1;
    $4 = $t2;
    var $5 = $3;
    var $6 = $5+8;
    var $7 = IHEAP[$6];
    if ($7 == 0) {
      __label__ = 7; /* $8 */ 
    }
    else if ($7 == 3) {
      __label__ = 8; /* $9 */ 
    }
    else if ($7 == 1) {
      __label__ = 9; /* $20 */ 
    }
    else if ($7 == 2) {
      __label__ = 10; /* $33 */ 
    }
    else if ($7 == 7) {
      __label__ = 11; /* $46 */ 
    }
    else if ($7 == 5) {
      __label__ = 12; /* $88 */ 
    }
    else {
    __label__ = 13; /* $126 */ 
    }
    
    $126$8$9$20$33$46$88$2: do { 
      if (__label__ == 13) {
        var $127 = $3;
        var $128 = $127;
        var $129 = $128;
        var $130 = $129;
        var $131 = IHEAP[$130];
        var $132 = $4;
        var $133 = $132;
        var $134 = $133;
        var $135 = $134;
        var $136 = IHEAP[$135];
        var $137 = $131 == $136;
        var $138 = $137;
        $1 = $138;
        __label__ = 0; /* $179 */ break $126$8$9$20$33$46$88$2;
      }
      else if (__label__ == 7) {
        $1 = 1;
        __label__ = 0; /* $179 */ break $126$8$9$20$33$46$88$2;
      }
      else if (__label__ == 8) {
        var $10 = $3;
        var $11 = $10;
        var $12 = $11;
        var $13 = FHEAP[$12];
        var $14 = $4;
        var $15 = $14;
        var $16 = $15;
        var $17 = FHEAP[$16];
        var $18 = $13 == $17;
        var $19 = $18;
        $1 = $19;
        __label__ = 0; /* $179 */ break $126$8$9$20$33$46$88$2;
      }
      else if (__label__ == 9) {
        var $21 = $3;
        var $22 = $21;
        var $23 = $22;
        var $24 = $23;
        var $25 = IHEAP[$24];
        var $26 = $4;
        var $27 = $26;
        var $28 = $27;
        var $29 = $28;
        var $30 = IHEAP[$29];
        var $31 = $25 == $30;
        var $32 = $31;
        $1 = $32;
        __label__ = 0; /* $179 */ break $126$8$9$20$33$46$88$2;
      }
      else if (__label__ == 10) {
        var $34 = $3;
        var $35 = $34;
        var $36 = $35;
        var $37 = $36;
        var $38 = IHEAP[$37];
        var $39 = $4;
        var $40 = $39;
        var $41 = $40;
        var $42 = $41;
        var $43 = IHEAP[$42];
        var $44 = $38 == $43;
        var $45 = $44;
        $1 = $45;
        __label__ = 0; /* $179 */ break $126$8$9$20$33$46$88$2;
      }
      else if (__label__ == 11) {
        var $47 = $3;
        var $48 = $47;
        var $49 = $48;
        var $50 = $49;
        var $51 = IHEAP[$50];
        var $52 = $51;
        var $53 = $52;
        var $54 = $53;
        var $55 = $4;
        var $56 = $55;
        var $57 = $56;
        var $58 = $57;
        var $59 = IHEAP[$58];
        var $60 = $59;
        var $61 = $60;
        var $62 = $61;
        var $63 = $54 == $62;
        ;
        if ($63) {
          ;
          $1 = 1;
          __label__ = 0; /* $179 */ break $126$8$9$20$33$46$88$2;
        }
        else {
          ;
          var $66 = $2;
          var $67 = $3;
          var $68 = $67;
          var $69 = $68;
          var $70 = $69;
          var $71 = IHEAP[$70];
          var $72 = $71;
          var $73 = $72;
          var $74 = $73;
          var $75 = $74+8;
          var $76 = IHEAP[$75];
          var $77 = $4;
          var $78 = $77;
          var $79 = $78;
          var $80 = $79;
          var $81 = IHEAP[$80];
          var $82 = $81;
          var $83 = $82;
          var $84 = $83;
          var $85 = $84+8;
          var $86 = IHEAP[$85];
          var $87 = __Z10get_compTMP9lua_StateP5TableS2_3TMS($66, $76, $86, 4);
          $tm = $87;
          __label__ = 1; /* $139 */ break $126$8$9$20$33$46$88$2;
        }
      }
      else if (__label__ == 12) {
        var $89 = $3;
        var $90 = $89;
        var $91 = $90;
        var $92 = $91;
        var $93 = IHEAP[$92];
        var $94 = $93;
        var $95 = $94;
        var $96 = $4;
        var $97 = $96;
        var $98 = $97;
        var $99 = $98;
        var $100 = IHEAP[$99];
        var $101 = $100;
        var $102 = $101;
        var $103 = $95 == $102;
        ;
        if ($103) {
          ;
          $1 = 1;
          __label__ = 0; /* $179 */ break $126$8$9$20$33$46$88$2;
        }
        else {
          ;
          var $106 = $2;
          var $107 = $3;
          var $108 = $107;
          var $109 = $108;
          var $110 = $109;
          var $111 = IHEAP[$110];
          var $112 = $111;
          var $113 = $112;
          var $114 = $113+8;
          var $115 = IHEAP[$114];
          var $116 = $4;
          var $117 = $116;
          var $118 = $117;
          var $119 = $118;
          var $120 = IHEAP[$119];
          var $121 = $120;
          var $122 = $121;
          var $123 = $122+8;
          var $124 = IHEAP[$123];
          var $125 = __Z10get_compTMP9lua_StateP5TableS2_3TMS($106, $115, $124, 4);
          $tm = $125;
          __label__ = 1; /* $139 */ break $126$8$9$20$33$46$88$2;
        }
      }
    } while(0);
    if (__label__ == 1) {
      var $140 = $tm;
      var $141 = $140 == 0;
      ;
      if ($141) {
        ;
        $1 = 0;
        ;
      }
      else {
        ;
        var $144 = $2;
        var $145 = $2;
        var $146 = $145+8;
        var $147 = IHEAP[$146];
        var $148 = $tm;
        var $149 = $3;
        var $150 = $4;
        __Z9callTMresP9lua_StateP10lua_TValuePKS1_S4_S4_($144, $147, $148, $149, $150);
        var $151 = $2;
        var $152 = $151+8;
        var $153 = IHEAP[$152];
        var $154 = $153+8;
        var $155 = IHEAP[$154];
        var $156 = $155 == 0;
        ;
        if ($156) {
          __lastLabel__ = 15; ;
        }
        else {
          __lastLabel__ = 15; ;
          var $158 = $2;
          var $159 = $158+8;
          var $160 = IHEAP[$159];
          var $161 = $160+8;
          var $162 = IHEAP[$161];
          var $163 = $162 == 1;
          ;
          if ($163) {
            __lastLabel__ = 14; ;
            var $165 = $2;
            var $166 = $165+8;
            var $167 = IHEAP[$166];
            var $168 = $167;
            var $169 = $168;
            var $170 = $169;
            var $171 = IHEAP[$170];
            var $172 = $171 == 0;
            __lastLabel__ = 3; ;
          }
          else {
            __lastLabel__ = 14; ;
          }
          var $174 = __lastLabel__ == 14 ? 0 : ($172);
          __lastLabel__ = 5; ;
        }
        var $176 = __lastLabel__ == 15 ? 1 : ($174);
        var $177 = $176 ^ 1;
        var $178 = $177;
        $1 = $178;
        ;
      }
    }
    var $180 = $1;
    ;
    return $180;
  }
  __Z13luaV_equalvalP9lua_StatePK10lua_TValueS3_.__index__ = Runtime.getFunctionIndex(__Z13luaV_equalvalP9lua_StatePK10lua_TValueS3_, "__Z13luaV_equalvalP9lua_StatePK10lua_TValueS3_");
  
  
  function __Z10get_compTMP9lua_StateP5TableS2_3TMS($L, $mt1, $mt2, $event) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $4;
    var $5;
    var $tm1;
    var $tm2;
    $2 = $L;
    $3 = $mt1;
    $4 = $mt2;
    $5 = $event;
    var $6 = $3;
    var $7 = $6 == 0;
    ;
    if ($7) {
      ;
      __lastLabel__ = 0; ;
    }
    else {
      ;
      var $10 = $3;
      var $11 = $10+6;
      var $12 = IHEAP[$11];
      var $13 = $12;
      var $14 = $5;
      var $15 = 1 << $14;
      var $16 = $13 & $15;
      var $17 = $16 != 0;
      ;
      if ($17) {
        ;
        __lastLabel__ = 2; ;
      }
      else {
        ;
        var $20 = $3;
        var $21 = $5;
        var $22 = $5;
        var $23 = $2;
        var $24 = $23+16;
        var $25 = IHEAP[$24];
        var $26 = $25+168;
        var $27 = $26+$22*4;
        var $28 = IHEAP[$27];
        var $29 = __Z10luaT_gettmP5Table3TMSP7TString($20, $21, $28);
        __lastLabel__ = 4; ;
      }
      var $31 = __lastLabel__ == 2 ? 0 : ($29);
      __lastLabel__ = 5; ;
    }
    var $33 = __lastLabel__ == 0 ? 0 : ($31);
    $tm1 = $33;
    var $34 = $tm1;
    var $35 = $34 == 0;
    ;
    if ($35) {
      ;
      $1 = 0;
      ;
    }
    else {
      ;
      var $38 = $3;
      var $39 = $4;
      var $40 = $38 == $39;
      ;
      if ($40) {
        ;
        var $42 = $tm1;
        $1 = $42;
        ;
      }
      else {
        ;
        var $44 = $4;
        var $45 = $44 == 0;
        ;
        if ($45) {
          ;
          __lastLabel__ = 7; ;
        }
        else {
          ;
          var $48 = $4;
          var $49 = $48+6;
          var $50 = IHEAP[$49];
          var $51 = $50;
          var $52 = $5;
          var $53 = 1 << $52;
          var $54 = $51 & $53;
          var $55 = $54 != 0;
          ;
          if ($55) {
            ;
            __lastLabel__ = 9; ;
          }
          else {
            ;
            var $58 = $4;
            var $59 = $5;
            var $60 = $5;
            var $61 = $2;
            var $62 = $61+16;
            var $63 = IHEAP[$62];
            var $64 = $63+168;
            var $65 = $64+$60*4;
            var $66 = IHEAP[$65];
            var $67 = __Z10luaT_gettmP5Table3TMSP7TString($58, $59, $66);
            __lastLabel__ = 11; ;
          }
          var $69 = __lastLabel__ == 9 ? 0 : ($67);
          __lastLabel__ = 12; ;
        }
        var $71 = __lastLabel__ == 7 ? 0 : ($69);
        $tm2 = $71;
        var $72 = $tm2;
        var $73 = $72 == 0;
        ;
        if ($73) {
          ;
          $1 = 0;
          ;
        }
        else {
          ;
          var $76 = $tm1;
          var $77 = $tm2;
          var $78 = __Z16luaO_rawequalObjPK10lua_TValueS1_($76, $77);
          var $79 = $78 != 0;
          ;
          if ($79) {
            ;
            var $81 = $tm1;
            $1 = $81;
            ;
          }
          else {
            ;
            $1 = 0;
            ;
          }
        }
      }
    }
    var $84 = $1;
    ;
    return $84;
  }
  __Z10get_compTMP9lua_StateP5TableS2_3TMS.__index__ = Runtime.getFunctionIndex(__Z10get_compTMP9lua_StateP5TableS2_3TMS, "__Z10get_compTMP9lua_StateP5TableS2_3TMS");
  
  
  function __Z11luaV_concatP9lua_Stateii($L, $total, $last) {
    ;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $3;
    var $top;
    var $n;
    var $tl;
    var $buffer;
    var $i;
    var $l;
    var $l1;
    var $i_o;
    $1 = $L;
    $2 = $total;
    $3 = $last;
    ;
    $4$2: while(1) { // $4
      var $5 = $1;
      var $6 = $5+12;
      var $7 = IHEAP[$6];
      var $8 = $3;
      var $9 = $7+12*$8;
      var $10 = $9+12;
      $top = $10;
      $n = 2;
      var $11 = $top;
      var $12 = $11+-24;
      var $13 = $12+8;
      var $14 = IHEAP[$13];
      var $15 = $14 == 4;
      ;
      $22$16$4: do { 
        if ($15) {
          __label__ = 1; /* $22 */ 
        }
        else {
          ;
          var $17 = $top;
          var $18 = $17+-24;
          var $19 = $18+8;
          var $20 = IHEAP[$19];
          var $21 = $20 == 3;
          if ($21) { __label__ = 1; /* $22 */ break $22$16$4; } else { __label__ = 2; /* $34 */ break $22$16$4; }
        }
      } while(0);
      $22$34$6: do { 
        if (__label__ == 1) {
          var $23 = $top;
          var $24 = $23+-12;
          var $25 = $24+8;
          var $26 = IHEAP[$25];
          var $27 = $26 == 4;
          ;
          if (!$27) {
            ;
            var $29 = $1;
            var $30 = $top;
            var $31 = $30+-12;
            var $32 = __Z13luaV_tostringP9lua_StateP10lua_TValue($29, $31);
            var $33 = $32 != 0;
            if (!($33)) { __label__ = 2; /* $34 */ break $22$34$6; }
          }
          var $52 = $top;
          var $53 = $52+-12;
          var $54 = $53;
          var $55 = $54;
          var $56 = $55;
          var $57 = IHEAP[$56];
          var $58 = $57;
          var $59 = $58;
          var $60 = $59;
          var $61 = $60+12;
          var $62 = IHEAP[$61];
          var $63 = $62 == 0;
          ;
          if ($63) {
            ;
            var $65 = $top;
            var $66 = $65+-24;
            var $67 = $66+8;
            var $68 = IHEAP[$67];
            var $69 = $68 == 4;
            ;
            if ($69) {
              __lastLabel__ = 25; ;
            }
            else {
              __lastLabel__ = 25; ;
              var $71 = $1;
              var $72 = $top;
              var $73 = $72+-24;
              var $74 = __Z13luaV_tostringP9lua_StateP10lua_TValue($71, $73);
              var $75 = $74 != 0;
              __lastLabel__ = 6; ;
            }
            var $77 = __lastLabel__ == 25 ? 1 : ($75);
            ;
          }
          else {
            ;
            var $79 = $top;
            var $80 = $79+-12;
            var $81 = $80;
            var $82 = $81;
            var $83 = $82;
            var $84 = IHEAP[$83];
            var $85 = $84;
            var $86 = $85;
            var $87 = $86;
            var $88 = $87+12;
            var $89 = IHEAP[$88];
            $tl = $89;
            $n = 1;
            ;
            $90$17: while(1) { // $90
              var $91 = $n;
              var $92 = $2;
              var $93 = $91 < $92;
              ;
              if ($93) {
                __lastLabel__ = 9; ;
                var $95 = $top;
                var $96 = $n;
                var $97 = 0 - $96;
                var $98 = $95+12*$97;
                var $99 = $98+-12;
                var $100 = $99+8;
                var $101 = IHEAP[$100];
                var $102 = $101 == 4;
                ;
                if ($102) {
                  __lastLabel__ = 26; ;
                }
                else {
                  __lastLabel__ = 26; ;
                  var $104 = $1;
                  var $105 = $top;
                  var $106 = $n;
                  var $107 = 0 - $106;
                  var $108 = $105+12*$107;
                  var $109 = $108+-12;
                  var $110 = __Z13luaV_tostringP9lua_StateP10lua_TValue($104, $109);
                  var $111 = $110 != 0;
                  __lastLabel__ = 10; ;
                }
                var $113 = __lastLabel__ == 26 ? 1 : ($111);
                __lastLabel__ = 12; ;
              }
              else {
                __lastLabel__ = 9; ;
              }
              var $115 = __lastLabel__ == 9 ? 0 : ($113);
              if (!($115)) { __label__ = 15; /* $144 */ break $90$17; }
              var $117 = $top;
              var $118 = $n;
              var $119 = 0 - $118;
              var $120 = $117+12*$119;
              var $121 = $120+-12;
              var $122 = $121;
              var $123 = $122;
              var $124 = $123;
              var $125 = IHEAP[$124];
              var $126 = $125;
              var $127 = $126;
              var $128 = $127;
              var $129 = $128+12;
              var $130 = IHEAP[$129];
              $l = $130;
              var $131 = $l;
              var $132 = $tl;
              var $133 = -3 - $132;
              var $134 = unSign($131, 32) >= unSign($133, 32);
              ;
              if ($134) {
                ;
                var $136 = $1;
                __Z13luaG_runerrorP9lua_StatePKcz($136, __str4224);
                ;
              }
              var $138 = $l;
              var $139 = $tl;
              var $140 = $139 + $138;
              $tl = $140;
              ;
              var $142 = $n;
              var $143 = $142 + 1;
              $n = $143;
              __label__ = 9; /* $90 */ continue $90$17;
            }
            var $145 = $1;
            var $146 = $1;
            var $147 = $146+16;
            var $148 = IHEAP[$147];
            var $149 = $148+52;
            var $150 = $tl;
            var $151 = __Z14luaZ_openspaceP9lua_StateP7Mbufferj($145, $149, $150);
            $buffer = $151;
            $tl = 0;
            var $152 = $n;
            $i = $152;
            ;
            $153$31: while(1) { // $153
              var $154 = $i;
              var $155 = $154 > 0;
              if (!($155)) { __label__ = 20; /* $192 */ break $153$31; }
              var $157 = $top;
              var $158 = $i;
              var $159 = 0 - $158;
              var $160 = $157+12*$159;
              var $161 = $160;
              var $162 = $161;
              var $163 = $162;
              var $164 = IHEAP[$163];
              var $165 = $164;
              var $166 = $165;
              var $167 = $166;
              var $168 = $167+12;
              var $169 = IHEAP[$168];
              $l1 = $169;
              var $170 = $buffer;
              var $171 = $tl;
              var $172 = $170+$171;
              var $173 = $top;
              var $174 = $i;
              var $175 = 0 - $174;
              var $176 = $173+12*$175;
              var $177 = $176;
              var $178 = $177;
              var $179 = $178;
              var $180 = IHEAP[$179];
              var $181 = $180;
              var $182 = $181;
              var $183 = $182+16;
              var $184 = $183;
              var $185 = $l1;
              _llvm_memcpy_p0i8_p0i8_i32($172, $184, $185, 1, 0);
              var $186 = $l1;
              var $187 = $tl;
              var $188 = $187 + $186;
              $tl = $188;
              ;
              var $190 = $i;
              var $191 = $190 + -1;
              $i = $191;
              __label__ = 18; /* $153 */ continue $153$31;
            }
            var $193 = $top;
            var $194 = $n;
            var $195 = 0 - $194;
            var $196 = $193+12*$195;
            $i_o = $196;
            var $197 = $1;
            var $198 = $buffer;
            var $199 = $tl;
            var $200 = __Z12luaS_newlstrP9lua_StatePKcj($197, $198, $199);
            var $201 = $200;
            var $202 = $i_o;
            var $203 = $202;
            var $204 = $203;
            var $205 = $204;
            IHEAP[$205] = $201;
            var $206 = $i_o;
            var $207 = $206+8;
            IHEAP[$207] = 4;
            ;
          }
          __label__ = 22; /* $209 */ break $22$34$6;
        }
      } while(0);
      if (__label__ == 2) {
        var $35 = $1;
        var $36 = $top;
        var $37 = $36+-24;
        var $38 = $top;
        var $39 = $38+-12;
        var $40 = $top;
        var $41 = $40+-24;
        var $42 = __Z10call_binTMP9lua_StatePK10lua_TValueS3_PS1_3TMS($35, $37, $39, $41, 15);
        var $43 = $42 != 0;
        ;
        if (!$43) {
          ;
          var $45 = $1;
          var $46 = $top;
          var $47 = $46+-24;
          var $48 = $top;
          var $49 = $48+-12;
          __Z16luaG_concaterrorP9lua_StateP10lua_TValueS2_($45, $47, $49);
          ;
        }
        ;
      }
      var $210 = $n;
      var $211 = $210 - 1;
      var $212 = $2;
      var $213 = $212 - $211;
      $2 = $213;
      var $214 = $n;
      var $215 = $214 - 1;
      var $216 = $3;
      var $217 = $216 - $215;
      $3 = $217;
      ;
      var $219 = $2;
      var $220 = $219 > 1;
      if ($220) { __label__ = 0; /* $4 */ continue $4$2; } else { __label__ = 24; /* $221 */ break $4$2; }
    }
    ;
    return;
  }
  __Z11luaV_concatP9lua_Stateii.__index__ = Runtime.getFunctionIndex(__Z11luaV_concatP9lua_Stateii, "__Z11luaV_concatP9lua_Stateii");
  
  
  function __Z10call_binTMP9lua_StatePK10lua_TValueS3_PS1_3TMS($L, $p1, $p2, $res, $event) {
    ;
    var __label__;
    var $1;
    var $2;
    var $3;
    var $4;
    var $5;
    var $6;
    var $tm;
    $2 = $L;
    $3 = $p1;
    $4 = $p2;
    $5 = $res;
    $6 = $event;
    var $7 = $2;
    var $8 = $3;
    var $9 = $6;
    var $10 = __Z15luaT_gettmbyobjP9lua_StatePK10lua_TValue3TMS($7, $8, $9);
    $tm = $10;
    var $11 = $tm;
    var $12 = $11+8;
    var $13 = IHEAP[$12];
    var $14 = $13 == 0;
    ;
    if ($14) {
      ;
      var $16 = $2;
      var $17 = $4;
      var $18 = $6;
      var $19 = __Z15luaT_gettmbyobjP9lua_StatePK10lua_TValue3TMS($16, $17, $18);
      $tm = $19;
      ;
    }
    var $21 = $tm;
    var $22 = $21+8;
    var $23 = IHEAP[$22];
    var $24 = $23 == 0;
    ;
    if ($24) {
      ;
      $1 = 0;
      ;
    }
    else {
      ;
      var $27 = $2;
      var $28 = $5;
      var $29 = $tm;
      var $30 = $3;
      var $31 = $4;
      __Z9callTMresP9lua_StateP10lua_TValuePKS1_S4_S4_($27, $28, $29, $30, $31);
      $1 = 1;
      ;
    }
    var $33 = $1;
    ;
    return $33;
  }
  __Z10call_binTMP9lua_StatePK10lua_TValueS3_PS1_3TMS.__index__ = Runtime.getFunctionIndex(__Z10call_binTMP9lua_StatePK10lua_TValueS3_PS1_3TMS, "__Z10call_binTMP9lua_StatePK10lua_TValueS3_PS1_3TMS");
  
  
  function __Z12luaV_executeP9lua_Statei($L, $nexeccalls) {
    var __stackBase__  = STACKTOP; STACKTOP += 24; for (var i = __stackBase__; i < STACKTOP; i++) IHEAP[i] = FHEAP[i] = 0;
    var __label__;
    var __lastLabel__ = null;
    var $1;
    var $2;
    var $cl;
    var $base;
    var $k;
    var $pc;
    var $i;
    var $ra;
    var $o2;
    var $o1;
    var $o21;
    var $o12;
    var $i_o;
    var $rb;
    var $b;
    var $o23;
    var $o14;
    var $g = __stackBase__;
    var $rb5;
    var $i_o6;
    var $g7 = __stackBase__+12;
    var $i_o8;
    var $uv;
    var $o29;
    var $o110;
    var $b11;
    var $c;
    var $i_o12;
    var $rb13;
    var $o214;
    var $o115;
    var $rb16;
    var $rc;
    var $nb;
    var $nc;
    var $i_o17;
    var $rb18;
    var $rc19;
    var $nb20;
    var $nc21;
    var $i_o22;
    var $rb23;
    var $rc24;
    var $nb25;
    var $nc26;
    var $i_o27;
    var $rb28;
    var $rc29;
    var $nb30;
    var $nc31;
    var $i_o32;
    var $rb33;
    var $rc34;
    var $nb35;
    var $nc36;
    var $i_o37;
    var $rb38;
    var $rc39;
    var $nb40;
    var $nc41;
    var $i_o42;
    var $rb43;
    var $nb44;
    var $i_o45;
    var $res;
    var $i_o46;
    var $rb47;
    var $i_o48;
    var $i_o49;
    var $b50;
    var $c51;
    var $o252;
    var $o153;
    var $rb54;
    var $rc55;
    var $rb56;
    var $o257;
    var $o158;
    var $b59;
    var $nresults;
    var $b60;
    var $ci;
    var $aux;
    var $func;
    var $pfunc;
    var $o261;
    var $o162;
    var $b63;
    var $step;
    var $idx;
    var $limit;
    var $i_o64;
    var $i_o65;
    var $init;
    var $plimit;
    var $pstep;
    var $i_o66;
    var $cb;
    var $o267;
    var $o168;
    var $o269;
    var $o170;
    var $o271;
    var $o172;
    var $o273;
    var $o174;
    var $n;
    var $c75;
    var $last;
    var $h;
    var $val;
    var $o276;
    var $o177;
    var $p;
    var $ncl;
    var $nup;
    var $j;
    var $i_o78;
    var $b79;
    var $j80;
    var $ci81;
    var $n82;
    var $o283;
    var $o184;
    $1 = $L;
    $2 = $nexeccalls;
    ;
    $3$2: while(1) { // $3
      var $4 = $1;
      var $5 = $4+24;
      var $6 = IHEAP[$5];
      $pc = $6;
      var $7 = $1;
      var $8 = $7+20;
      var $9 = IHEAP[$8];
      var $10 = $9+4;
      var $11 = IHEAP[$10];
      var $12 = $11;
      var $13 = $12;
      var $14 = $13;
      var $15 = IHEAP[$14];
      var $16 = $15;
      var $17 = $16;
      var $18 = $17;
      var $19 = $18;
      $cl = $19;
      var $20 = $1;
      var $21 = $20+12;
      var $22 = IHEAP[$21];
      $base = $22;
      var $23 = $cl;
      var $24 = $23+16;
      var $25 = IHEAP[$24];
      var $26 = $25+8;
      var $27 = IHEAP[$26];
      $k = $27;
      ;
      $28$4: while(1) { // $28
        var $29 = $pc;
        var $30 = $29+4;
        $pc = $30;
        var $31 = IHEAP[$29];
        $i = $31;
        var $32 = $1;
        var $33 = $32+56;
        var $34 = IHEAP[$33];
        var $35 = $34;
        var $36 = $35 & 12;
        var $37 = $36 != 0;
        ;
        $38$68$6: do { 
          if ($37) {
            ;
            var $39 = $1;
            var $40 = $39+64;
            var $41 = IHEAP[$40];
            var $42 = $41 + -1;
            IHEAP[$40] = $42;
            var $43 = $42 == 0;
            ;
            if (!$43) {
              ;
              var $45 = $1;
              var $46 = $45+56;
              var $47 = IHEAP[$46];
              var $48 = $47;
              var $49 = $48 & 4;
              var $50 = $49 != 0;
              if (!($50)) { __label__ = 3; /* $68 */ break $38$68$6; }
            }
            var $52 = $1;
            var $53 = $pc;
            __Z9traceexecP9lua_StatePKj($52, $53);
            var $54 = $1;
            var $55 = $54+6;
            var $56 = IHEAP[$55];
            var $57 = $56;
            var $58 = $57 == 1;
            if ($58) { __label__ = 4; /* $59 */ break $3$2; }
            var $65 = $1;
            var $66 = $65+12;
            var $67 = IHEAP[$66];
            $base = $67;
            ;
          }
        } while(0);
        var $69 = $base;
        var $70 = $i;
        var $71 = $70 >> 6;
        var $72 = $71 & 255;
        var $73 = $69+12*$72;
        $ra = $73;
        var $74 = $i;
        var $75 = $74 >> 0;
        var $76 = $75 & 63;
        if ($76 == 0) {
          __label__ = 183; /* $77 */ 
        }
        else if ($76 == 1) {
          __label__ = 184; /* $95 */ 
        }
        else if ($76 == 2) {
          __label__ = 185; /* $113 */ 
        }
        else if ($76 == 3) {
          __label__ = 186; /* $132 */ 
        }
        else if ($76 == 4) {
          __label__ = 187; /* $147 */ 
        }
        else if ($76 == 5) {
          __label__ = 188; /* $170 */ 
        }
        else if ($76 == 6) {
          __label__ = 189; /* $195 */ 
        }
        else if ($76 == 7) {
          __label__ = 190; /* $229 */ 
        }
        else if ($76 == 8) {
          __label__ = 191; /* $253 */ 
        }
        else if ($76 == 9) {
          __label__ = 192; /* $313 */ 
        }
        else if ($76 == 10) {
          __label__ = 193; /* $362 */ 
        }
        else if ($76 == 11) {
          __label__ = 194; /* $403 */ 
        }
        else if ($76 == 12) {
          __label__ = 195; /* $452 */ 
        }
        else if ($76 == 13) {
          __label__ = 196; /* $532 */ 
        }
        else if ($76 == 14) {
          __label__ = 197; /* $612 */ 
        }
        else if ($76 == 15) {
          __label__ = 198; /* $692 */ 
        }
        else if ($76 == 16) {
          __label__ = 199; /* $772 */ 
        }
        else if ($76 == 17) {
          __label__ = 200; /* $857 */ 
        }
        else if ($76 == 18) {
          __label__ = 201; /* $937 */ 
        }
        else if ($76 == 19) {
          __label__ = 202; /* $972 */ 
        }
        else if ($76 == 20) {
          __label__ = 203; /* $1014 */ 
        }
        else if ($76 == 21) {
          __label__ = 204; /* $1074 */ 
        }
        else if ($76 == 22) {
          __label__ = 205; /* $1126 */ 
        }
        else if ($76 == 23) {
          __label__ = 206; /* $1133 */ 
        }
        else if ($76 == 24) {
          __label__ = 207; /* $1211 */ 
        }
        else if ($76 == 25) {
          __label__ = 208; /* $1275 */ 
        }
        else if ($76 == 26) {
          __label__ = 209; /* $1339 */ 
        }
        else if ($76 == 27) {
          __label__ = 210; /* $1376 */ 
        }
        else if ($76 == 28) {
          __label__ = 211; /* $1431 */ 
        }
        else if ($76 == 29) {
          __label__ = 212; /* $1474 */ 
        }
        else if ($76 == 30) {
          __label__ = 213; /* $1587 */ break $28$4;
        }
        else if ($76 == 31) {
          __label__ = 214; /* $1631 */ 
        }
        else if ($76 == 32) {
          __label__ = 215; /* $1681 */ 
        }
        else if ($76 == 33) {
          __label__ = 216; /* $1751 */ 
        }
        else if ($76 == 34) {
          __label__ = 217; /* $1854 */ 
        }
        else if ($76 == 35) {
          __label__ = 218; /* $1975 */ 
        }
        else if ($76 == 36) {
          __label__ = 219; /* $1978 */ 
        }
        else if ($76 == 37) {
          __label__ = 220; /* $2080 */ 
        }
        else {
        __label__ = 221; /* $2187 */ 
        }
        
        if (__label__ == 183) {
          var $78 = $base;
          var $79 = $i;
          var $80 = $79 >> 23;
          var $81 = $80 & 511;
          var $82 = $78+12*$81;
          $o2 = $82;
          var $83 = $ra;
          $o1 = $83;
          var $84 = $o1;
          var $85 = $84;
          var $86 = $o2;
          var $87 = $86;
          var $88 = $85;
          var $89 = $87;
          _llvm_memcpy_p0i8_p0i8_i32($88, $89, 8, 4, 0);
          var $90 = $o2;
          var $91 = $90+8;
          var $92 = IHEAP[$91];
          var $93 = $o1;
          var $94 = $93+8;
          IHEAP[$94] = $92;
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 184) {
          var $96 = $k;
          var $97 = $i;
          var $98 = $97 >> 14;
          var $99 = $98 & 262143;
          var $100 = $96+12*$99;
          $o21 = $100;
          var $101 = $ra;
          $o12 = $101;
          var $102 = $o12;
          var $103 = $102;
          var $104 = $o21;
          var $105 = $104;
          var $106 = $103;
          var $107 = $105;
          _llvm_memcpy_p0i8_p0i8_i32($106, $107, 8, 4, 0);
          var $108 = $o21;
          var $109 = $108+8;
          var $110 = IHEAP[$109];
          var $111 = $o12;
          var $112 = $111+8;
          IHEAP[$112] = $110;
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 185) {
          var $114 = $ra;
          $i_o = $114;
          var $115 = $i;
          var $116 = $115 >> 23;
          var $117 = $116 & 511;
          var $118 = $i_o;
          var $119 = $118;
          var $120 = $119;
          var $121 = $120;
          IHEAP[$121] = $117;
          var $122 = $i_o;
          var $123 = $122+8;
          IHEAP[$123] = 1;
          var $124 = $i;
          var $125 = $124 >> 14;
          var $126 = $125 & 511;
          var $127 = $126 != 0;
          ;
          if ($127) {
            ;
            var $129 = $pc;
            var $130 = $129+4;
            $pc = $130;
            ;
          }
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 186) {
          var $133 = $base;
          var $134 = $i;
          var $135 = $134 >> 23;
          var $136 = $135 & 511;
          var $137 = $133+12*$136;
          $rb = $137;
          ;
          $138$21: while(1) { // $138
            var $139 = $rb;
            var $140 = $139+-12;
            $rb = $140;
            var $141 = $139+8;
            IHEAP[$141] = 0;
            ;
            var $143 = $rb;
            var $144 = $ra;
            var $145 = $143 >= $144;
            if ($145) { __label__ = 9; /* $138 */ continue $138$21; } else { __label__ = 11; /* $146 */ break $138$21; }
          }
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 187) {
          var $148 = $i;
          var $149 = $148 >> 23;
          var $150 = $149 & 511;
          $b = $150;
          var $151 = $b;
          var $152 = $cl;
          var $153 = $152+20;
          var $154 = $153+$151*4;
          var $155 = IHEAP[$154];
          var $156 = $155+8;
          var $157 = IHEAP[$156];
          $o23 = $157;
          var $158 = $ra;
          $o14 = $158;
          var $159 = $o14;
          var $160 = $159;
          var $161 = $o23;
          var $162 = $161;
          var $163 = $160;
          var $164 = $162;
          _llvm_memcpy_p0i8_p0i8_i32($163, $164, 8, 4, 0);
          var $165 = $o23;
          var $166 = $165+8;
          var $167 = IHEAP[$166];
          var $168 = $o14;
          var $169 = $168+8;
          IHEAP[$169] = $167;
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 188) {
          var $171 = $k;
          var $172 = $i;
          var $173 = $172 >> 14;
          var $174 = $173 & 262143;
          var $175 = $171+12*$174;
          $rb5 = $175;
          $i_o6 = $g;
          var $176 = $cl;
          var $177 = $176+12;
          var $178 = IHEAP[$177];
          var $179 = $178;
          var $180 = $i_o6;
          var $181 = $180;
          var $182 = $181;
          var $183 = $182;
          IHEAP[$183] = $179;
          var $184 = $i_o6;
          var $185 = $184+8;
          IHEAP[$185] = 5;
          var $186 = $pc;
          var $187 = $1;
          var $188 = $187+24;
          IHEAP[$188] = $186;
          var $189 = $1;
          var $190 = $rb5;
          var $191 = $ra;
          __Z13luaV_gettableP9lua_StatePK10lua_TValuePS1_S4_($189, $g, $190, $191);
          var $192 = $1;
          var $193 = $192+12;
          var $194 = IHEAP[$193];
          $base = $194;
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 189) {
          var $196 = $pc;
          var $197 = $1;
          var $198 = $197+24;
          IHEAP[$198] = $196;
          var $199 = $1;
          var $200 = $base;
          var $201 = $i;
          var $202 = $201 >> 23;
          var $203 = $202 & 511;
          var $204 = $200+12*$203;
          var $205 = $i;
          var $206 = $205 >> 14;
          var $207 = $206 & 511;
          var $208 = $207 & 256;
          var $209 = $208 != 0;
          ;
          if ($209) {
            ;
            var $211 = $k;
            var $212 = $i;
            var $213 = $212 >> 14;
            var $214 = $213 & 511;
            var $215 = $214 & -257;
            var $216 = $211+12*$215;
            __lastLabel__ = 12; ;
          }
          else {
            ;
            var $218 = $base;
            var $219 = $i;
            var $220 = $219 >> 14;
            var $221 = $220 & 511;
            var $222 = $218+12*$221;
            __lastLabel__ = 14; ;
          }
          var $224 = __lastLabel__ == 12 ? $216 : ($222);
          var $225 = $ra;
          __Z13luaV_gettableP9lua_StatePK10lua_TValuePS1_S4_($199, $204, $224, $225);
          var $226 = $1;
          var $227 = $226+12;
          var $228 = IHEAP[$227];
          $base = $228;
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 190) {
          $i_o8 = $g7;
          var $230 = $cl;
          var $231 = $230+12;
          var $232 = IHEAP[$231];
          var $233 = $232;
          var $234 = $i_o8;
          var $235 = $234;
          var $236 = $235;
          var $237 = $236;
          IHEAP[$237] = $233;
          var $238 = $i_o8;
          var $239 = $238+8;
          IHEAP[$239] = 5;
          var $240 = $pc;
          var $241 = $1;
          var $242 = $241+24;
          IHEAP[$242] = $240;
          var $243 = $1;
          var $244 = $k;
          var $245 = $i;
          var $246 = $245 >> 14;
          var $247 = $246 & 262143;
          var $248 = $244+12*$247;
          var $249 = $ra;
          __Z13luaV_settableP9lua_StatePK10lua_TValuePS1_S4_($243, $g7, $248, $249);
          var $250 = $1;
          var $251 = $250+12;
          var $252 = IHEAP[$251];
          $base = $252;
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 191) {
          var $254 = $i;
          var $255 = $254 >> 23;
          var $256 = $255 & 511;
          var $257 = $cl;
          var $258 = $257+20;
          var $259 = $258+$256*4;
          var $260 = IHEAP[$259];
          $uv = $260;
          var $261 = $ra;
          $o29 = $261;
          var $262 = $uv;
          var $263 = $262+8;
          var $264 = IHEAP[$263];
          $o110 = $264;
          var $265 = $o110;
          var $266 = $265;
          var $267 = $o29;
          var $268 = $267;
          var $269 = $266;
          var $270 = $268;
          _llvm_memcpy_p0i8_p0i8_i32($269, $270, 8, 4, 0);
          var $271 = $o29;
          var $272 = $271+8;
          var $273 = IHEAP[$272];
          var $274 = $o110;
          var $275 = $274+8;
          IHEAP[$275] = $273;
          var $276 = $ra;
          var $277 = $276+8;
          var $278 = IHEAP[$277];
          var $279 = $278 >= 4;
          ;
          $280$312$34: do { 
            if ($279) {
              ;
              var $281 = $ra;
              var $282 = $281;
              var $283 = $282;
              var $284 = $283;
              var $285 = IHEAP[$284];
              var $286 = $285;
              var $287 = $286;
              var $288 = $287+5;
              var $289 = IHEAP[$288];
              var $290 = $289;
              var $291 = $290 & 3;
              var $292 = $291 != 0;
              if (!($292)) { __label__ = 16; /* $312 */ break $280$312$34; }
              var $294 = $uv;
              var $295 = $294;
              var $296 = $295;
              var $297 = $296;
              var $298 = $297+5;
              var $299 = IHEAP[$298];
              var $300 = $299;
              var $301 = $300 & 4;
              var $302 = $301 != 0;
              if (!($302)) { __label__ = 16; /* $312 */ break $280$312$34; }
              var $304 = $1;
              var $305 = $uv;
              var $306 = $305;
              var $307 = $ra;
              var $308 = $307;
              var $309 = $308;
              var $310 = $309;
              var $311 = IHEAP[$310];
              __Z13luaC_barrierfP9lua_StateP8GCObjectS2_($304, $306, $311);
              ;
            }
          } while(0);
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 192) {
          var $314 = $pc;
          var $315 = $1;
          var $316 = $315+24;
          IHEAP[$316] = $314;
          var $317 = $1;
          var $318 = $ra;
          var $319 = $i;
          var $320 = $319 >> 23;
          var $321 = $320 & 511;
          var $322 = $321 & 256;
          var $323 = $322 != 0;
          ;
          if ($323) {
            ;
            var $325 = $k;
            var $326 = $i;
            var $327 = $326 >> 23;
            var $328 = $327 & 511;
            var $329 = $328 & -257;
            var $330 = $325+12*$329;
            __lastLabel__ = 19; ;
          }
          else {
            ;
            var $332 = $base;
            var $333 = $i;
            var $334 = $333 >> 23;
            var $335 = $334 & 511;
            var $336 = $332+12*$335;
            __lastLabel__ = 21; ;
          }
          var $338 = __lastLabel__ == 19 ? $330 : ($336);
          var $339 = $i;
          var $340 = $339 >> 14;
          var $341 = $340 & 511;
          var $342 = $341 & 256;
          var $343 = $342 != 0;
          ;
          if ($343) {
            ;
            var $345 = $k;
            var $346 = $i;
            var $347 = $346 >> 14;
            var $348 = $347 & 511;
            var $349 = $348 & -257;
            var $350 = $345+12*$349;
            __lastLabel__ = 22; ;
          }
          else {
            ;
            var $352 = $base;
            var $353 = $i;
            var $354 = $353 >> 14;
            var $355 = $354 & 511;
            var $356 = $352+12*$355;
            __lastLabel__ = 24; ;
          }
          var $358 = __lastLabel__ == 22 ? $350 : ($356);
          __Z13luaV_settableP9lua_StatePK10lua_TValuePS1_S4_($317, $318, $338, $358);
          var $359 = $1;
          var $360 = $359+12;
          var $361 = IHEAP[$360];
          $base = $361;
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 193) {
          var $363 = $i;
          var $364 = $363 >> 23;
          var $365 = $364 & 511;
          $b11 = $365;
          var $366 = $i;
          var $367 = $366 >> 14;
          var $368 = $367 & 511;
          $c = $368;
          var $369 = $ra;
          $i_o12 = $369;
          var $370 = $1;
          var $371 = $b11;
          var $372 = __Z11luaO_fb2inti($371);
          var $373 = $c;
          var $374 = __Z11luaO_fb2inti($373);
          var $375 = __Z8luaH_newP9lua_Stateii($370, $372, $374);
          var $376 = $375;
          var $377 = $i_o12;
          var $378 = $377;
          var $379 = $378;
          var $380 = $379;
          IHEAP[$380] = $376;
          var $381 = $i_o12;
          var $382 = $381+8;
          IHEAP[$382] = 5;
          var $383 = $pc;
          var $384 = $1;
          var $385 = $384+24;
          IHEAP[$385] = $383;
          var $386 = $1;
          var $387 = $386+16;
          var $388 = IHEAP[$387];
          var $389 = $388+68;
          var $390 = IHEAP[$389];
          var $391 = $1;
          var $392 = $391+16;
          var $393 = IHEAP[$392];
          var $394 = $393+64;
          var $395 = IHEAP[$394];
          var $396 = unSign($390, 32) >= unSign($395, 32);
          ;
          if ($396) {
            ;
            var $398 = $1;
            __Z9luaC_stepP9lua_State($398);
            ;
          }
          var $400 = $1;
          var $401 = $400+12;
          var $402 = IHEAP[$401];
          $base = $402;
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 194) {
          var $404 = $base;
          var $405 = $i;
          var $406 = $405 >> 23;
          var $407 = $406 & 511;
          var $408 = $404+12*$407;
          $rb13 = $408;
          var $409 = $rb13;
          $o214 = $409;
          var $410 = $ra;
          var $411 = $410+12;
          $o115 = $411;
          var $412 = $o115;
          var $413 = $412;
          var $414 = $o214;
          var $415 = $414;
          var $416 = $413;
          var $417 = $415;
          _llvm_memcpy_p0i8_p0i8_i32($416, $417, 8, 4, 0);
          var $418 = $o214;
          var $419 = $418+8;
          var $420 = IHEAP[$419];
          var $421 = $o115;
          var $422 = $421+8;
          IHEAP[$422] = $420;
          var $423 = $pc;
          var $424 = $1;
          var $425 = $424+24;
          IHEAP[$425] = $423;
          var $426 = $1;
          var $427 = $rb13;
          var $428 = $i;
          var $429 = $428 >> 14;
          var $430 = $429 & 511;
          var $431 = $430 & 256;
          var $432 = $431 != 0;
          ;
          if ($432) {
            ;
            var $434 = $k;
            var $435 = $i;
            var $436 = $435 >> 14;
            var $437 = $436 & 511;
            var $438 = $437 & -257;
            var $439 = $434+12*$438;
            __lastLabel__ = 26; ;
          }
          else {
            ;
            var $441 = $base;
            var $442 = $i;
            var $443 = $442 >> 14;
            var $444 = $443 & 511;
            var $445 = $441+12*$444;
            __lastLabel__ = 28; ;
          }
          var $447 = __lastLabel__ == 26 ? $439 : ($445);
          var $448 = $ra;
          __Z13luaV_gettableP9lua_StatePK10lua_TValuePS1_S4_($426, $427, $447, $448);
          var $449 = $1;
          var $450 = $449+12;
          var $451 = IHEAP[$450];
          $base = $451;
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 195) {
          var $453 = $i;
          var $454 = $453 >> 23;
          var $455 = $454 & 511;
          var $456 = $455 & 256;
          var $457 = $456 != 0;
          ;
          if ($457) {
            ;
            var $459 = $k;
            var $460 = $i;
            var $461 = $460 >> 23;
            var $462 = $461 & 511;
            var $463 = $462 & -257;
            var $464 = $459+12*$463;
            __lastLabel__ = 29; ;
          }
          else {
            ;
            var $466 = $base;
            var $467 = $i;
            var $468 = $467 >> 23;
            var $469 = $468 & 511;
            var $470 = $466+12*$469;
            __lastLabel__ = 31; ;
          }
          var $472 = __lastLabel__ == 29 ? $464 : ($470);
          $rb16 = $472;
          var $473 = $i;
          var $474 = $473 >> 14;
          var $475 = $474 & 511;
          var $476 = $475 & 256;
          var $477 = $476 != 0;
          ;
          if ($477) {
            ;
            var $479 = $k;
            var $480 = $i;
            var $481 = $480 >> 14;
            var $482 = $481 & 511;
            var $483 = $482 & -257;
            var $484 = $479+12*$483;
            __lastLabel__ = 32; ;
          }
          else {
            ;
            var $486 = $base;
            var $487 = $i;
            var $488 = $487 >> 14;
            var $489 = $488 & 511;
            var $490 = $486+12*$489;
            __lastLabel__ = 34; ;
          }
          var $492 = __lastLabel__ == 32 ? $484 : ($490);
          $rc = $492;
          var $493 = $rb16;
          var $494 = $493+8;
          var $495 = IHEAP[$494];
          var $496 = $495 == 3;
          ;
          $497$520$66: do { 
            if ($496) {
              ;
              var $498 = $rc;
              var $499 = $498+8;
              var $500 = IHEAP[$499];
              var $501 = $500 == 3;
              if (!($501)) { __label__ = 36; /* $520 */ break $497$520$66; }
              var $503 = $rb16;
              var $504 = $503;
              var $505 = $504;
              var $506 = FHEAP[$505];
              $nb = $506;
              var $507 = $rc;
              var $508 = $507;
              var $509 = $508;
              var $510 = FHEAP[$509];
              $nc = $510;
              var $511 = $ra;
              $i_o17 = $511;
              var $512 = $nb;
              var $513 = $nc;
              var $514 = $512 + $513;
              var $515 = $i_o17;
              var $516 = $515;
              var $517 = $516;
              FHEAP[$517] = $514;
              var $518 = $i_o17;
              var $519 = $518+8;
              IHEAP[$519] = 3;
              __label__ = 37; /* $531 */ break $497$520$66;
            }
            else {
              __label__ = 36; /* $520 */ 
            }
          } while(0);
          if (__label__ == 36) {
            var $521 = $pc;
            var $522 = $1;
            var $523 = $522+24;
            IHEAP[$523] = $521;
            var $524 = $1;
            var $525 = $ra;
            var $526 = $rb16;
            var $527 = $rc;
            __Z5ArithP9lua_StateP10lua_TValuePKS1_S4_3TMS($524, $525, $526, $527, 5);
            var $528 = $1;
            var $529 = $528+12;
            var $530 = IHEAP[$529];
            $base = $530;
            ;
          }
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 196) {
          var $533 = $i;
          var $534 = $533 >> 23;
          var $535 = $534 & 511;
          var $536 = $535 & 256;
          var $537 = $536 != 0;
          ;
          if ($537) {
            ;
            var $539 = $k;
            var $540 = $i;
            var $541 = $540 >> 23;
            var $542 = $541 & 511;
            var $543 = $542 & -257;
            var $544 = $539+12*$543;
            __lastLabel__ = 39; ;
          }
          else {
            ;
            var $546 = $base;
            var $547 = $i;
            var $548 = $547 >> 23;
            var $549 = $548 & 511;
            var $550 = $546+12*$549;
            __lastLabel__ = 41; ;
          }
          var $552 = __lastLabel__ == 39 ? $544 : ($550);
          $rb18 = $552;
          var $553 = $i;
          var $554 = $553 >> 14;
          var $555 = $554 & 511;
          var $556 = $555 & 256;
          var $557 = $556 != 0;
          ;
          if ($557) {
            ;
            var $559 = $k;
            var $560 = $i;
            var $561 = $560 >> 14;
            var $562 = $561 & 511;
            var $563 = $562 & -257;
            var $564 = $559+12*$563;
            __lastLabel__ = 42; ;
          }
          else {
            ;
            var $566 = $base;
            var $567 = $i;
            var $568 = $567 >> 14;
            var $569 = $568 & 511;
            var $570 = $566+12*$569;
            __lastLabel__ = 44; ;
          }
          var $572 = __lastLabel__ == 42 ? $564 : ($570);
          $rc19 = $572;
          var $573 = $rb18;
          var $574 = $573+8;
          var $575 = IHEAP[$574];
          var $576 = $575 == 3;
          ;
          $577$600$81: do { 
            if ($576) {
              ;
              var $578 = $rc19;
              var $579 = $578+8;
              var $580 = IHEAP[$579];
              var $581 = $580 == 3;
              if (!($581)) { __label__ = 46; /* $600 */ break $577$600$81; }
              var $583 = $rb18;
              var $584 = $583;
              var $585 = $584;
              var $586 = FHEAP[$585];
              $nb20 = $586;
              var $587 = $rc19;
              var $588 = $587;
              var $589 = $588;
              var $590 = FHEAP[$589];
              $nc21 = $590;
              var $591 = $ra;
              $i_o22 = $591;
              var $592 = $nb20;
              var $593 = $nc21;
              var $594 = $592 - $593;
              var $595 = $i_o22;
              var $596 = $595;
              var $597 = $596;
              FHEAP[$597] = $594;
              var $598 = $i_o22;
              var $599 = $598+8;
              IHEAP[$599] = 3;
              __label__ = 47; /* $611 */ break $577$600$81;
            }
            else {
              __label__ = 46; /* $600 */ 
            }
          } while(0);
          if (__label__ == 46) {
            var $601 = $pc;
            var $602 = $1;
            var $603 = $602+24;
            IHEAP[$603] = $601;
            var $604 = $1;
            var $605 = $ra;
            var $606 = $rb18;
            var $607 = $rc19;
            __Z5ArithP9lua_StateP10lua_TValuePKS1_S4_3TMS($604, $605, $606, $607, 6);
            var $608 = $1;
            var $609 = $608+12;
            var $610 = IHEAP[$609];
            $base = $610;
            ;
          }
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 197) {
          var $613 = $i;
          var $614 = $613 >> 23;
          var $615 = $614 & 511;
          var $616 = $615 & 256;
          var $617 = $616 != 0;
          ;
          if ($617) {
            ;
            var $619 = $k;
            var $620 = $i;
            var $621 = $620 >> 23;
            var $622 = $621 & 511;
            var $623 = $622 & -257;
            var $624 = $619+12*$623;
            __lastLabel__ = 49; ;
          }
          else {
            ;
            var $626 = $base;
            var $627 = $i;
            var $628 = $627 >> 23;
            var $629 = $628 & 511;
            var $630 = $626+12*$629;
            __lastLabel__ = 51; ;
          }
          var $632 = __lastLabel__ == 49 ? $624 : ($630);
          $rb23 = $632;
          var $633 = $i;
          var $634 = $633 >> 14;
          var $635 = $634 & 511;
          var $636 = $635 & 256;
          var $637 = $636 != 0;
          ;
          if ($637) {
            ;
            var $639 = $k;
            var $640 = $i;
            var $641 = $640 >> 14;
            var $642 = $641 & 511;
            var $643 = $642 & -257;
            var $644 = $639+12*$643;
            __lastLabel__ = 52; ;
          }
          else {
            ;
            var $646 = $base;
            var $647 = $i;
            var $648 = $647 >> 14;
            var $649 = $648 & 511;
            var $650 = $646+12*$649;
            __lastLabel__ = 54; ;
          }
          var $652 = __lastLabel__ == 52 ? $644 : ($650);
          $rc24 = $652;
          var $653 = $rb23;
          var $654 = $653+8;
          var $655 = IHEAP[$654];
          var $656 = $655 == 3;
          ;
          $657$680$96: do { 
            if ($656) {
              ;
              var $658 = $rc24;
              var $659 = $658+8;
              var $660 = IHEAP[$659];
              var $661 = $660 == 3;
              if (!($661)) { __label__ = 56; /* $680 */ break $657$680$96; }
              var $663 = $rb23;
              var $664 = $663;
              var $665 = $664;
              var $666 = FHEAP[$665];
              $nb25 = $666;
              var $667 = $rc24;
              var $668 = $667;
              var $669 = $668;
              var $670 = FHEAP[$669];
              $nc26 = $670;
              var $671 = $ra;
              $i_o27 = $671;
              var $672 = $nb25;
              var $673 = $nc26;
              var $674 = $672 * $673;
              var $675 = $i_o27;
              var $676 = $675;
              var $677 = $676;
              FHEAP[$677] = $674;
              var $678 = $i_o27;
              var $679 = $678+8;
              IHEAP[$679] = 3;
              __label__ = 57; /* $691 */ break $657$680$96;
            }
            else {
              __label__ = 56; /* $680 */ 
            }
          } while(0);
          if (__label__ == 56) {
            var $681 = $pc;
            var $682 = $1;
            var $683 = $682+24;
            IHEAP[$683] = $681;
            var $684 = $1;
            var $685 = $ra;
            var $686 = $rb23;
            var $687 = $rc24;
            __Z5ArithP9lua_StateP10lua_TValuePKS1_S4_3TMS($684, $685, $686, $687, 7);
            var $688 = $1;
            var $689 = $688+12;
            var $690 = IHEAP[$689];
            $base = $690;
            ;
          }
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 198) {
          var $693 = $i;
          var $694 = $693 >> 23;
          var $695 = $694 & 511;
          var $696 = $695 & 256;
          var $697 = $696 != 0;
          ;
          if ($697) {
            ;
            var $699 = $k;
            var $700 = $i;
            var $701 = $700 >> 23;
            var $702 = $701 & 511;
            var $703 = $702 & -257;
            var $704 = $699+12*$703;
            __lastLabel__ = 59; ;
          }
          else {
            ;
            var $706 = $base;
            var $707 = $i;
            var $708 = $707 >> 23;
            var $709 = $708 & 511;
            var $710 = $706+12*$709;
            __lastLabel__ = 61; ;
          }
          var $712 = __lastLabel__ == 59 ? $704 : ($710);
          $rb28 = $712;
          var $713 = $i;
          var $714 = $713 >> 14;
          var $715 = $714 & 511;
          var $716 = $715 & 256;
          var $717 = $716 != 0;
          ;
          if ($717) {
            ;
            var $719 = $k;
            var $720 = $i;
            var $721 = $720 >> 14;
            var $722 = $721 & 511;
            var $723 = $722 & -257;
            var $724 = $719+12*$723;
            __lastLabel__ = 62; ;
          }
          else {
            ;
            var $726 = $base;
            var $727 = $i;
            var $728 = $727 >> 14;
            var $729 = $728 & 511;
            var $730 = $726+12*$729;
            __lastLabel__ = 64; ;
          }
          var $732 = __lastLabel__ == 62 ? $724 : ($730);
          $rc29 = $732;
          var $733 = $rb28;
          var $734 = $733+8;
          var $735 = IHEAP[$734];
          var $736 = $735 == 3;
          ;
          $737$760$111: do { 
            if ($736) {
              ;
              var $738 = $rc29;
              var $739 = $738+8;
              var $740 = IHEAP[$739];
              var $741 = $740 == 3;
              if (!($741)) { __label__ = 66; /* $760 */ break $737$760$111; }
              var $743 = $rb28;
              var $744 = $743;
              var $745 = $744;
              var $746 = FHEAP[$745];
              $nb30 = $746;
              var $747 = $rc29;
              var $748 = $747;
              var $749 = $748;
              var $750 = FHEAP[$749];
              $nc31 = $750;
              var $751 = $ra;
              $i_o32 = $751;
              var $752 = $nb30;
              var $753 = $nc31;
              var $754 = $752 / $753;
              var $755 = $i_o32;
              var $756 = $755;
              var $757 = $756;
              FHEAP[$757] = $754;
              var $758 = $i_o32;
              var $759 = $758+8;
              IHEAP[$759] = 3;
              __label__ = 67; /* $771 */ break $737$760$111;
            }
            else {
              __label__ = 66; /* $760 */ 
            }
          } while(0);
          if (__label__ == 66) {
            var $761 = $pc;
            var $762 = $1;
            var $763 = $762+24;
            IHEAP[$763] = $761;
            var $764 = $1;
            var $765 = $ra;
            var $766 = $rb28;
            var $767 = $rc29;
            __Z5ArithP9lua_StateP10lua_TValuePKS1_S4_3TMS($764, $765, $766, $767, 8);
            var $768 = $1;
            var $769 = $768+12;
            var $770 = IHEAP[$769];
            $base = $770;
            ;
          }
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 199) {
          var $773 = $i;
          var $774 = $773 >> 23;
          var $775 = $774 & 511;
          var $776 = $775 & 256;
          var $777 = $776 != 0;
          ;
          if ($777) {
            ;
            var $779 = $k;
            var $780 = $i;
            var $781 = $780 >> 23;
            var $782 = $781 & 511;
            var $783 = $782 & -257;
            var $784 = $779+12*$783;
            __lastLabel__ = 69; ;
          }
          else {
            ;
            var $786 = $base;
            var $787 = $i;
            var $788 = $787 >> 23;
            var $789 = $788 & 511;
            var $790 = $786+12*$789;
            __lastLabel__ = 71; ;
          }
          var $792 = __lastLabel__ == 69 ? $784 : ($790);
          $rb33 = $792;
          var $793 = $i;
          var $794 = $793 >> 14;
          var $795 = $794 & 511;
          var $796 = $795 & 256;
          var $797 = $796 != 0;
          ;
          if ($797) {
            ;
            var $799 = $k;
            var $800 = $i;
            var $801 = $800 >> 14;
            var $802 = $801 & 511;
            var $803 = $802 & -257;
            var $804 = $799+12*$803;
            __lastLabel__ = 72; ;
          }
          else {
            ;
            var $806 = $base;
            var $807 = $i;
            var $808 = $807 >> 14;
            var $809 = $808 & 511;
            var $810 = $806+12*$809;
            __lastLabel__ = 74; ;
          }
          var $812 = __lastLabel__ == 72 ? $804 : ($810);
          $rc34 = $812;
          var $813 = $rb33;
          var $814 = $813+8;
          var $815 = IHEAP[$814];
          var $816 = $815 == 3;
          ;
          $817$845$126: do { 
            if ($816) {
              ;
              var $818 = $rc34;
              var $819 = $818+8;
              var $820 = IHEAP[$819];
              var $821 = $820 == 3;
              if (!($821)) { __label__ = 76; /* $845 */ break $817$845$126; }
              var $823 = $rb33;
              var $824 = $823;
              var $825 = $824;
              var $826 = FHEAP[$825];
              $nb35 = $826;
              var $827 = $rc34;
              var $828 = $827;
              var $829 = $828;
              var $830 = FHEAP[$829];
              $nc36 = $830;
              var $831 = $ra;
              $i_o37 = $831;
              var $832 = $nb35;
              var $833 = $nb35;
              var $834 = $nc36;
              var $835 = $833 / $834;
              var $836 = _floor($835);
              var $837 = $nc36;
              var $838 = $836 * $837;
              var $839 = $832 - $838;
              var $840 = $i_o37;
              var $841 = $840;
              var $842 = $841;
              FHEAP[$842] = $839;
              var $843 = $i_o37;
              var $844 = $843+8;
              IHEAP[$844] = 3;
              __label__ = 77; /* $856 */ break $817$845$126;
            }
            else {
              __label__ = 76; /* $845 */ 
            }
          } while(0);
          if (__label__ == 76) {
            var $846 = $pc;
            var $847 = $1;
            var $848 = $847+24;
            IHEAP[$848] = $846;
            var $849 = $1;
            var $850 = $ra;
            var $851 = $rb33;
            var $852 = $rc34;
            __Z5ArithP9lua_StateP10lua_TValuePKS1_S4_3TMS($849, $850, $851, $852, 9);
            var $853 = $1;
            var $854 = $853+12;
            var $855 = IHEAP[$854];
            $base = $855;
            ;
          }
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 200) {
          var $858 = $i;
          var $859 = $858 >> 23;
          var $860 = $859 & 511;
          var $861 = $860 & 256;
          var $862 = $861 != 0;
          ;
          if ($862) {
            ;
            var $864 = $k;
            var $865 = $i;
            var $866 = $865 >> 23;
            var $867 = $866 & 511;
            var $868 = $867 & -257;
            var $869 = $864+12*$868;
            __lastLabel__ = 79; ;
          }
          else {
            ;
            var $871 = $base;
            var $872 = $i;
            var $873 = $872 >> 23;
            var $874 = $873 & 511;
            var $875 = $871+12*$874;
            __lastLabel__ = 81; ;
          }
          var $877 = __lastLabel__ == 79 ? $869 : ($875);
          $rb38 = $877;
          var $878 = $i;
          var $879 = $878 >> 14;
          var $880 = $879 & 511;
          var $881 = $880 & 256;
          var $882 = $881 != 0;
          ;
          if ($882) {
            ;
            var $884 = $k;
            var $885 = $i;
            var $886 = $885 >> 14;
            var $887 = $886 & 511;
            var $888 = $887 & -257;
            var $889 = $884+12*$888;
            __lastLabel__ = 82; ;
          }
          else {
            ;
            var $891 = $base;
            var $892 = $i;
            var $893 = $892 >> 14;
            var $894 = $893 & 511;
            var $895 = $891+12*$894;
            __lastLabel__ = 84; ;
          }
          var $897 = __lastLabel__ == 82 ? $889 : ($895);
          $rc39 = $897;
          var $898 = $rb38;
          var $899 = $898+8;
          var $900 = IHEAP[$899];
          var $901 = $900 == 3;
          ;
          $902$925$141: do { 
            if ($901) {
              ;
              var $903 = $rc39;
              var $904 = $903+8;
              var $905 = IHEAP[$904];
              var $906 = $905 == 3;
              if (!($906)) { __label__ = 86; /* $925 */ break $902$925$141; }
              var $908 = $rb38;
              var $909 = $908;
              var $910 = $909;
              var $911 = FHEAP[$910];
              $nb40 = $911;
              var $912 = $rc39;
              var $913 = $912;
              var $914 = $913;
              var $915 = FHEAP[$914];
              $nc41 = $915;
              var $916 = $ra;
              $i_o42 = $916;
              var $917 = $nb40;
              var $918 = $nc41;
              var $919 = _llvm_pow_f64($917, $918);
              var $920 = $i_o42;
              var $921 = $920;
              var $922 = $921;
              FHEAP[$922] = $919;
              var $923 = $i_o42;
              var $924 = $923+8;
              IHEAP[$924] = 3;
              __label__ = 87; /* $936 */ break $902$925$141;
            }
            else {
              __label__ = 86; /* $925 */ 
            }
          } while(0);
          if (__label__ == 86) {
            var $926 = $pc;
            var $927 = $1;
            var $928 = $927+24;
            IHEAP[$928] = $926;
            var $929 = $1;
            var $930 = $ra;
            var $931 = $rb38;
            var $932 = $rc39;
            __Z5ArithP9lua_StateP10lua_TValuePKS1_S4_3TMS($929, $930, $931, $932, 10);
            var $933 = $1;
            var $934 = $933+12;
            var $935 = IHEAP[$934];
            $base = $935;
            ;
          }
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 201) {
          var $938 = $base;
          var $939 = $i;
          var $940 = $939 >> 23;
          var $941 = $940 & 511;
          var $942 = $938+12*$941;
          $rb43 = $942;
          var $943 = $rb43;
          var $944 = $943+8;
          var $945 = IHEAP[$944];
          var $946 = $945 == 3;
          ;
          if ($946) {
            ;
            var $948 = $rb43;
            var $949 = $948;
            var $950 = $949;
            var $951 = FHEAP[$950];
            $nb44 = $951;
            var $952 = $ra;
            $i_o45 = $952;
            var $953 = $nb44;
            var $954 = 0 - $953;
            var $955 = $i_o45;
            var $956 = $955;
            var $957 = $956;
            FHEAP[$957] = $954;
            var $958 = $i_o45;
            var $959 = $958+8;
            IHEAP[$959] = 3;
            ;
          }
          else {
            ;
            var $961 = $pc;
            var $962 = $1;
            var $963 = $962+24;
            IHEAP[$963] = $961;
            var $964 = $1;
            var $965 = $ra;
            var $966 = $rb43;
            var $967 = $rb43;
            __Z5ArithP9lua_StateP10lua_TValuePKS1_S4_3TMS($964, $965, $966, $967, 11);
            var $968 = $1;
            var $969 = $968+12;
            var $970 = IHEAP[$969];
            $base = $970;
            ;
          }
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 202) {
          var $973 = $base;
          var $974 = $i;
          var $975 = $974 >> 23;
          var $976 = $975 & 511;
          var $977 = $973+12*$976;
          var $978 = $977+8;
          var $979 = IHEAP[$978];
          var $980 = $979 == 0;
          ;
          if ($980) {
            __lastLabel__ = 202; ;
          }
          else {
            __lastLabel__ = 202; ;
            var $982 = $base;
            var $983 = $i;
            var $984 = $983 >> 23;
            var $985 = $984 & 511;
            var $986 = $982+12*$985;
            var $987 = $986+8;
            var $988 = IHEAP[$987];
            var $989 = $988 == 1;
            ;
            if ($989) {
              __lastLabel__ = 231; ;
              var $991 = $base;
              var $992 = $i;
              var $993 = $992 >> 23;
              var $994 = $993 & 511;
              var $995 = $991+12*$994;
              var $996 = $995;
              var $997 = $996;
              var $998 = $997;
              var $999 = IHEAP[$998];
              var $1000 = $999 == 0;
              __lastLabel__ = 90; ;
            }
            else {
              __lastLabel__ = 231; ;
            }
            var $1002 = __lastLabel__ == 231 ? 0 : ($1000);
            __lastLabel__ = 92; ;
          }
          var $1004 = __lastLabel__ == 202 ? 1 : ($1002);
          var $1005 = $1004;
          $res = $1005;
          var $1006 = $ra;
          $i_o46 = $1006;
          var $1007 = $res;
          var $1008 = $i_o46;
          var $1009 = $1008;
          var $1010 = $1009;
          var $1011 = $1010;
          IHEAP[$1011] = $1007;
          var $1012 = $i_o46;
          var $1013 = $1012+8;
          IHEAP[$1013] = 1;
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 203) {
          var $1015 = $base;
          var $1016 = $i;
          var $1017 = $1016 >> 23;
          var $1018 = $1017 & 511;
          var $1019 = $1015+12*$1018;
          $rb47 = $1019;
          var $1020 = $rb47;
          var $1021 = $1020+8;
          var $1022 = IHEAP[$1021];
          if ($1022 == 5) {
            __label__ = 222; /* $1023 */ 
          }
          else if ($1022 == 4) {
            __label__ = 223; /* $1039 */ 
          }
          else {
          __label__ = 224; /* $1057 */ 
          }
          
          if (__label__ == 224) {
            var $1058 = $pc;
            var $1059 = $1;
            var $1060 = $1059+24;
            IHEAP[$1060] = $1058;
            var $1061 = $1;
            var $1062 = $rb47;
            var $1063 = $ra;
            var $1064 = __Z10call_binTMP9lua_StatePK10lua_TValueS3_PS1_3TMS($1061, $1062, _luaO_nilobject_, $1063, 12);
            var $1065 = $1064 != 0;
            ;
            if (!$1065) {
              ;
              var $1067 = $1;
              var $1068 = $rb47;
              __Z14luaG_typeerrorP9lua_StatePK10lua_TValuePKc($1067, $1068, __str5225);
              ;
            }
            var $1070 = $1;
            var $1071 = $1070+12;
            var $1072 = IHEAP[$1071];
            $base = $1072;
            ;
          }
          else if (__label__ == 222) {
            var $1024 = $ra;
            $i_o48 = $1024;
            var $1025 = $rb47;
            var $1026 = $1025;
            var $1027 = $1026;
            var $1028 = $1027;
            var $1029 = IHEAP[$1028];
            var $1030 = $1029;
            var $1031 = $1030;
            var $1032 = __Z9luaH_getnP5Table($1031);
            var $1033 = $1032;
            var $1034 = $i_o48;
            var $1035 = $1034;
            var $1036 = $1035;
            FHEAP[$1036] = $1033;
            var $1037 = $i_o48;
            var $1038 = $1037+8;
            IHEAP[$1038] = 3;
            ;
          }
          else if (__label__ == 223) {
            var $1040 = $ra;
            $i_o49 = $1040;
            var $1041 = $rb47;
            var $1042 = $1041;
            var $1043 = $1042;
            var $1044 = $1043;
            var $1045 = IHEAP[$1044];
            var $1046 = $1045;
            var $1047 = $1046;
            var $1048 = $1047;
            var $1049 = $1048+12;
            var $1050 = IHEAP[$1049];
            var $1051 = unSign($1050, 32);
            var $1052 = $i_o49;
            var $1053 = $1052;
            var $1054 = $1053;
            FHEAP[$1054] = $1051;
            var $1055 = $i_o49;
            var $1056 = $1055+8;
            IHEAP[$1056] = 3;
            ;
          }
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 204) {
          var $1075 = $i;
          var $1076 = $1075 >> 23;
          var $1077 = $1076 & 511;
          $b50 = $1077;
          var $1078 = $i;
          var $1079 = $1078 >> 14;
          var $1080 = $1079 & 511;
          $c51 = $1080;
          var $1081 = $pc;
          var $1082 = $1;
          var $1083 = $1082+24;
          IHEAP[$1083] = $1081;
          var $1084 = $1;
          var $1085 = $c51;
          var $1086 = $b50;
          var $1087 = $1085 - $1086;
          var $1088 = $1087 + 1;
          var $1089 = $c51;
          __Z11luaV_concatP9lua_Stateii($1084, $1088, $1089);
          var $1090 = $1;
          var $1091 = $1090+16;
          var $1092 = IHEAP[$1091];
          var $1093 = $1092+68;
          var $1094 = IHEAP[$1093];
          var $1095 = $1;
          var $1096 = $1095+16;
          var $1097 = IHEAP[$1096];
          var $1098 = $1097+64;
          var $1099 = IHEAP[$1098];
          var $1100 = unSign($1094, 32) >= unSign($1099, 32);
          ;
          if ($1100) {
            ;
            var $1102 = $1;
            __Z9luaC_stepP9lua_State($1102);
            ;
          }
          var $1104 = $1;
          var $1105 = $1104+12;
          var $1106 = IHEAP[$1105];
          $base = $1106;
          var $1107 = $base;
          var $1108 = $b50;
          var $1109 = $1107+12*$1108;
          $o252 = $1109;
          var $1110 = $base;
          var $1111 = $i;
          var $1112 = $1111 >> 6;
          var $1113 = $1112 & 255;
          var $1114 = $1110+12*$1113;
          $o153 = $1114;
          var $1115 = $o153;
          var $1116 = $1115;
          var $1117 = $o252;
          var $1118 = $1117;
          var $1119 = $1116;
          var $1120 = $1118;
          _llvm_memcpy_p0i8_p0i8_i32($1119, $1120, 8, 4, 0);
          var $1121 = $o252;
          var $1122 = $1121+8;
          var $1123 = IHEAP[$1122];
          var $1124 = $o153;
          var $1125 = $1124+8;
          IHEAP[$1125] = $1123;
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 205) {
          var $1127 = $i;
          var $1128 = $1127 >> 14;
          var $1129 = $1128 & 262143;
          var $1130 = $1129 - 131071;
          var $1131 = $pc;
          var $1132 = $1131+4*$1130;
          $pc = $1132;
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 206) {
          var $1134 = $i;
          var $1135 = $1134 >> 23;
          var $1136 = $1135 & 511;
          var $1137 = $1136 & 256;
          var $1138 = $1137 != 0;
          ;
          if ($1138) {
            ;
            var $1140 = $k;
            var $1141 = $i;
            var $1142 = $1141 >> 23;
            var $1143 = $1142 & 511;
            var $1144 = $1143 & -257;
            var $1145 = $1140+12*$1144;
            __lastLabel__ = 97; ;
          }
          else {
            ;
            var $1147 = $base;
            var $1148 = $i;
            var $1149 = $1148 >> 23;
            var $1150 = $1149 & 511;
            var $1151 = $1147+12*$1150;
            __lastLabel__ = 99; ;
          }
          var $1153 = __lastLabel__ == 97 ? $1145 : ($1151);
          $rb54 = $1153;
          var $1154 = $i;
          var $1155 = $1154 >> 14;
          var $1156 = $1155 & 511;
          var $1157 = $1156 & 256;
          var $1158 = $1157 != 0;
          ;
          if ($1158) {
            ;
            var $1160 = $k;
            var $1161 = $i;
            var $1162 = $1161 >> 14;
            var $1163 = $1162 & 511;
            var $1164 = $1163 & -257;
            var $1165 = $1160+12*$1164;
            __lastLabel__ = 100; ;
          }
          else {
            ;
            var $1167 = $base;
            var $1168 = $i;
            var $1169 = $1168 >> 14;
            var $1170 = $1169 & 511;
            var $1171 = $1167+12*$1170;
            __lastLabel__ = 102; ;
          }
          var $1173 = __lastLabel__ == 100 ? $1165 : ($1171);
          $rc55 = $1173;
          var $1174 = $pc;
          var $1175 = $1;
          var $1176 = $1175+24;
          IHEAP[$1176] = $1174;
          var $1177 = $rb54;
          var $1178 = $1177+8;
          var $1179 = IHEAP[$1178];
          var $1180 = $rc55;
          var $1181 = $1180+8;
          var $1182 = IHEAP[$1181];
          var $1183 = $1179 == $1182;
          ;
          if ($1183) {
            __lastLabel__ = 232; ;
            var $1185 = $1;
            var $1186 = $rb54;
            var $1187 = $rc55;
            var $1188 = __Z13luaV_equalvalP9lua_StatePK10lua_TValueS3_($1185, $1186, $1187);
            var $1189 = $1188 != 0;
            __lastLabel__ = 103; ;
          }
          else {
            __lastLabel__ = 232; ;
          }
          var $1191 = __lastLabel__ == 232 ? 0 : ($1189);
          var $1192 = $1191;
          var $1193 = $i;
          var $1194 = $1193 >> 6;
          var $1195 = $1194 & 255;
          var $1196 = $1192 == $1195;
          ;
          if ($1196) {
            ;
            var $1198 = $pc;
            var $1199 = IHEAP[$1198];
            var $1200 = $1199 >> 14;
            var $1201 = $1200 & 262143;
            var $1202 = $1201 - 131071;
            var $1203 = $pc;
            var $1204 = $1203+4*$1202;
            $pc = $1204;
            ;
          }
          var $1206 = $1;
          var $1207 = $1206+12;
          var $1208 = IHEAP[$1207];
          $base = $1208;
          var $1209 = $pc;
          var $1210 = $1209+4;
          $pc = $1210;
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 207) {
          var $1212 = $pc;
          var $1213 = $1;
          var $1214 = $1213+24;
          IHEAP[$1214] = $1212;
          var $1215 = $1;
          var $1216 = $i;
          var $1217 = $1216 >> 23;
          var $1218 = $1217 & 511;
          var $1219 = $1218 & 256;
          var $1220 = $1219 != 0;
          ;
          if ($1220) {
            ;
            var $1222 = $k;
            var $1223 = $i;
            var $1224 = $1223 >> 23;
            var $1225 = $1224 & 511;
            var $1226 = $1225 & -257;
            var $1227 = $1222+12*$1226;
            __lastLabel__ = 106; ;
          }
          else {
            ;
            var $1229 = $base;
            var $1230 = $i;
            var $1231 = $1230 >> 23;
            var $1232 = $1231 & 511;
            var $1233 = $1229+12*$1232;
            __lastLabel__ = 108; ;
          }
          var $1235 = __lastLabel__ == 106 ? $1227 : ($1233);
          var $1236 = $i;
          var $1237 = $1236 >> 14;
          var $1238 = $1237 & 511;
          var $1239 = $1238 & 256;
          var $1240 = $1239 != 0;
          ;
          if ($1240) {
            ;
            var $1242 = $k;
            var $1243 = $i;
            var $1244 = $1243 >> 14;
            var $1245 = $1244 & 511;
            var $1246 = $1245 & -257;
            var $1247 = $1242+12*$1246;
            __lastLabel__ = 109; ;
          }
          else {
            ;
            var $1249 = $base;
            var $1250 = $i;
            var $1251 = $1250 >> 14;
            var $1252 = $1251 & 511;
            var $1253 = $1249+12*$1252;
            __lastLabel__ = 111; ;
          }
          var $1255 = __lastLabel__ == 109 ? $1247 : ($1253);
          var $1256 = __Z13luaV_lessthanP9lua_StatePK10lua_TValueS3_($1215, $1235, $1255);
          var $1257 = $i;
          var $1258 = $1257 >> 6;
          var $1259 = $1258 & 255;
          var $1260 = $1256 == $1259;
          ;
          if ($1260) {
            ;
            var $1262 = $pc;
            var $1263 = IHEAP[$1262];
            var $1264 = $1263 >> 14;
            var $1265 = $1264 & 262143;
            var $1266 = $1265 - 131071;
            var $1267 = $pc;
            var $1268 = $1267+4*$1266;
            $pc = $1268;
            ;
          }
          var $1270 = $1;
          var $1271 = $1270+12;
          var $1272 = IHEAP[$1271];
          $base = $1272;
          var $1273 = $pc;
          var $1274 = $1273+4;
          $pc = $1274;
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 208) {
          var $1276 = $pc;
          var $1277 = $1;
          var $1278 = $1277+24;
          IHEAP[$1278] = $1276;
          var $1279 = $1;
          var $1280 = $i;
          var $1281 = $1280 >> 23;
          var $1282 = $1281 & 511;
          var $1283 = $1282 & 256;
          var $1284 = $1283 != 0;
          ;
          if ($1284) {
            ;
            var $1286 = $k;
            var $1287 = $i;
            var $1288 = $1287 >> 23;
            var $1289 = $1288 & 511;
            var $1290 = $1289 & -257;
            var $1291 = $1286+12*$1290;
            __lastLabel__ = 113; ;
          }
          else {
            ;
            var $1293 = $base;
            var $1294 = $i;
            var $1295 = $1294 >> 23;
            var $1296 = $1295 & 511;
            var $1297 = $1293+12*$1296;
            __lastLabel__ = 115; ;
          }
          var $1299 = __lastLabel__ == 113 ? $1291 : ($1297);
          var $1300 = $i;
          var $1301 = $1300 >> 14;
          var $1302 = $1301 & 511;
          var $1303 = $1302 & 256;
          var $1304 = $1303 != 0;
          ;
          if ($1304) {
            ;
            var $1306 = $k;
            var $1307 = $i;
            var $1308 = $1307 >> 14;
            var $1309 = $1308 & 511;
            var $1310 = $1309 & -257;
            var $1311 = $1306+12*$1310;
            __lastLabel__ = 116; ;
          }
          else {
            ;
            var $1313 = $base;
            var $1314 = $i;
            var $1315 = $1314 >> 14;
            var $1316 = $1315 & 511;
            var $1317 = $1313+12*$1316;
            __lastLabel__ = 118; ;
          }
          var $1319 = __lastLabel__ == 116 ? $1311 : ($1317);
          var $1320 = __Z9lessequalP9lua_StatePK10lua_TValueS3_($1279, $1299, $1319);
          var $1321 = $i;
          var $1322 = $1321 >> 6;
          var $1323 = $1322 & 255;
          var $1324 = $1320 == $1323;
          ;
          if ($1324) {
            ;
            var $1326 = $pc;
            var $1327 = IHEAP[$1326];
            var $1328 = $1327 >> 14;
            var $1329 = $1328 & 262143;
            var $1330 = $1329 - 131071;
            var $1331 = $pc;
            var $1332 = $1331+4*$1330;
            $pc = $1332;
            ;
          }
          var $1334 = $1;
          var $1335 = $1334+12;
          var $1336 = IHEAP[$1335];
          $base = $1336;
          var $1337 = $pc;
          var $1338 = $1337+4;
          $pc = $1338;
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 209) {
          var $1340 = $ra;
          var $1341 = $1340+8;
          var $1342 = IHEAP[$1341];
          var $1343 = $1342 == 0;
          ;
          if ($1343) {
            __lastLabel__ = 209; ;
          }
          else {
            __lastLabel__ = 209; ;
            var $1345 = $ra;
            var $1346 = $1345+8;
            var $1347 = IHEAP[$1346];
            var $1348 = $1347 == 1;
            ;
            if ($1348) {
              __lastLabel__ = 233; ;
              var $1350 = $ra;
              var $1351 = $1350;
              var $1352 = $1351;
              var $1353 = $1352;
              var $1354 = IHEAP[$1353];
              var $1355 = $1354 == 0;
              __lastLabel__ = 120; ;
            }
            else {
              __lastLabel__ = 233; ;
            }
            var $1357 = __lastLabel__ == 233 ? 0 : ($1355);
            __lastLabel__ = 122; ;
          }
          var $1359 = __lastLabel__ == 209 ? 1 : ($1357);
          var $1360 = $1359;
          var $1361 = $i;
          var $1362 = $1361 >> 14;
          var $1363 = $1362 & 511;
          var $1364 = $1360 != $1363;
          ;
          if ($1364) {
            ;
            var $1366 = $pc;
            var $1367 = IHEAP[$1366];
            var $1368 = $1367 >> 14;
            var $1369 = $1368 & 262143;
            var $1370 = $1369 - 131071;
            var $1371 = $pc;
            var $1372 = $1371+4*$1370;
            $pc = $1372;
            ;
          }
          var $1374 = $pc;
          var $1375 = $1374+4;
          $pc = $1375;
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 210) {
          var $1377 = $base;
          var $1378 = $i;
          var $1379 = $1378 >> 23;
          var $1380 = $1379 & 511;
          var $1381 = $1377+12*$1380;
          $rb56 = $1381;
          var $1382 = $rb56;
          var $1383 = $1382+8;
          var $1384 = IHEAP[$1383];
          var $1385 = $1384 == 0;
          ;
          if ($1385) {
            __lastLabel__ = 210; ;
          }
          else {
            __lastLabel__ = 210; ;
            var $1387 = $rb56;
            var $1388 = $1387+8;
            var $1389 = IHEAP[$1388];
            var $1390 = $1389 == 1;
            ;
            if ($1390) {
              __lastLabel__ = 234; ;
              var $1392 = $rb56;
              var $1393 = $1392;
              var $1394 = $1393;
              var $1395 = $1394;
              var $1396 = IHEAP[$1395];
              var $1397 = $1396 == 0;
              __lastLabel__ = 125; ;
            }
            else {
              __lastLabel__ = 234; ;
            }
            var $1399 = __lastLabel__ == 234 ? 0 : ($1397);
            __lastLabel__ = 127; ;
          }
          var $1401 = __lastLabel__ == 210 ? 1 : ($1399);
          var $1402 = $1401;
          var $1403 = $i;
          var $1404 = $1403 >> 14;
          var $1405 = $1404 & 511;
          var $1406 = $1402 != $1405;
          ;
          if ($1406) {
            ;
            var $1408 = $rb56;
            $o257 = $1408;
            var $1409 = $ra;
            $o158 = $1409;
            var $1410 = $o158;
            var $1411 = $1410;
            var $1412 = $o257;
            var $1413 = $1412;
            var $1414 = $1411;
            var $1415 = $1413;
            _llvm_memcpy_p0i8_p0i8_i32($1414, $1415, 8, 4, 0);
            var $1416 = $o257;
            var $1417 = $1416+8;
            var $1418 = IHEAP[$1417];
            var $1419 = $o158;
            var $1420 = $1419+8;
            IHEAP[$1420] = $1418;
            var $1421 = $pc;
            var $1422 = IHEAP[$1421];
            var $1423 = $1422 >> 14;
            var $1424 = $1423 & 262143;
            var $1425 = $1424 - 131071;
            var $1426 = $pc;
            var $1427 = $1426+4*$1425;
            $pc = $1427;
            ;
          }
          var $1429 = $pc;
          var $1430 = $1429+4;
          $pc = $1430;
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 211) {
          var $1432 = $i;
          var $1433 = $1432 >> 23;
          var $1434 = $1433 & 511;
          $b59 = $1434;
          var $1435 = $i;
          var $1436 = $1435 >> 14;
          var $1437 = $1436 & 511;
          var $1438 = $1437 - 1;
          $nresults = $1438;
          var $1439 = $b59;
          var $1440 = $1439 != 0;
          ;
          if ($1440) {
            ;
            var $1442 = $ra;
            var $1443 = $b59;
            var $1444 = $1442+12*$1443;
            var $1445 = $1;
            var $1446 = $1445+8;
            IHEAP[$1446] = $1444;
            ;
          }
          var $1448 = $pc;
          var $1449 = $1;
          var $1450 = $1449+24;
          IHEAP[$1450] = $1448;
          var $1451 = $1;
          var $1452 = $ra;
          var $1453 = $nresults;
          var $1454 = __Z12luaD_precallP9lua_StateP10lua_TValuei($1451, $1452, $1453);
          if ($1454 == 0) {
            __label__ = 225; /* $1455 */ break $28$4;
          }
          else if ($1454 == 1) {
            ;
          }
          else {
          __label__ = 227; /* $1473 */ break $3$2;
          }
          
          var $1459 = $nresults;
          var $1460 = $1459 >= 0;
          ;
          if ($1460) {
            ;
            var $1462 = $1;
            var $1463 = $1462+20;
            var $1464 = IHEAP[$1463];
            var $1465 = $1464+8;
            var $1466 = IHEAP[$1465];
            var $1467 = $1;
            var $1468 = $1467+8;
            IHEAP[$1468] = $1466;
            ;
          }
          var $1470 = $1;
          var $1471 = $1470+12;
          var $1472 = IHEAP[$1471];
          $base = $1472;
          __label__ = 1; /* $28 */ continue $28$4;
        }
        else if (__label__ == 212) {
          var $1475 = $i;
          var $1476 = $1475 >> 23;
          var $1477 = $1476 & 511;
          $b60 = $1477;
          var $1478 = $b60;
          var $1479 = $1478 != 0;
          ;
          if ($1479) {
            ;
            var $1481 = $ra;
            var $1482 = $b60;
            var $1483 = $1481+12*$1482;
            var $1484 = $1;
            var $1485 = $1484+8;
            IHEAP[$1485] = $1483;
            ;
          }
          var $1487 = $pc;
          var $1488 = $1;
          var $1489 = $1488+24;
          IHEAP[$1489] = $1487;
          var $1490 = $1;
          var $1491 = $ra;
          var $1492 = __Z12luaD_precallP9lua_StateP10lua_TValuei($1490, $1491, -1);
          if ($1492 == 0) {
            __label__ = 228; /* $1493 */ break $28$4;
          }
          else if ($1492 == 1) {
            ;
          }
          else {
          __label__ = 230; /* $1586 */ break $3$2;
          }
          
          var $1583 = $1;
          var $1584 = $1583+12;
          var $1585 = IHEAP[$1584];
          $base = $