/** Copyright © 2007 eMusic.com Inc.
 
This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or (at your option) any later version.  The GNU Lesser General Public License can be viewed by clicking on the following link:  http://www.gnu.org/licenses/lgpl.html#SEC4.  
 
This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**/

// nsIWebProgressListener implementation to monitor activity in the browser.
function WebProgressListener() {
  this.init();
}

WebProgressListener.prototype = {
  // Stored Status, Link and Loading values
  status: "",
  defaultStatus: "",
  jsStatus: "",
  jsDefaultStatus: "",
  overLink: "",

  _requestsStarted: 0,
  _requestsFinished: 0,

  // We need to advertize that we support weak references.  This is done simply
  // by saying that we QI to nsISupportsWeakReference.  XPConnect will take
  // care of actually implementing that interface on our behalf.
  QueryInterface: function(iid) {
    if (iid.equals(Components.interfaces.nsIWebProgressListener) ||
        iid.equals(Components.interfaces.nsISupportsWeakReference) ||
        iid.equals(Components.interfaces.nsIXULBrowserWindow) ||
        iid.equals(Components.interfaces.nsISupports))
      return this;
    throw Components.results.NS_NOINTERFACE;
  },

  init: function() {
    this.urlBar          = document.getElementById("urlbar");
    this.throbberElement = document.getElementById("navigator-throbber");
    this.statusMeter     = document.getElementById("statusbar-icon");
    this.statusTextField = document.getElementById("statusbar-display");
    this.stop            = document.getElementById("eBrowserStopReload");
    this.security        = document.getElementById("security-button");
  },

  destroy: function() {
    // XXXjag to avoid leaks :-/, see bug 60729
    this.urlBar          = null;
    this.throbberElement = null;
    this.statusMeter     = null;
    this.statusTextField = null;
    this.stop            = null;
    this.security        = null;
  },
  
  setJSStatus: function(status) {
    this.jsStatus = status;
    this.updateStatusField();
  },

  setJSDefaultStatus: function(status) {
    this.jsDefaultStatus = status;
    this.updateStatusField();
  },

  setDefaultStatus: function(status) {
    this.defaultStatus = status;
    this.updateStatusField();
  },

  setOverLink: function(link) {
    this.overLink = link;
    // clear out 'Done' (or other message) on first hover
    if (this.defaultStatus)
      this.defaultStatus = "";
    this.updateStatusField();
    if (link)
      this.statusTextField.setAttribute('crop', 'center');
    else
      this.statusTextField.setAttribute('crop', 'end');
  },

  updateStatusField: function() {
    var text = this.overLink || this.status || this.jsStatus || this.jsDefaultStatus || this.defaultStatus;

    // check the current value so we don't trigger an attribute change
    // and cause needless (slow!) UI updates
    if (this.statusTextField.label != text)
      this.statusTextField.label = text;
  },

  // This method is called to indicate state changes.
  onStateChange: function(webProgress, webRequest, webStateFlags, webStatus) {
    const WPL = Components.interfaces.nsIWebProgressListener;

    if (webStateFlags & WPL.STATE_IS_REQUEST) {
      if (webStateFlags & WPL.STATE_START) {
        this._requestsStarted++;
      } else if (webStateFlags & WPL.STATE_STOP) {
        this._requestsFinished++;
      }
      if (this._requestsStarted > 1) {
        var value = (100 * this._requestsFinished) / this._requestsStarted;
        this.statusMeter.setAttribute("mode", "determined");
        this.statusMeter.setAttribute("value", value + "%");
        
        if (value >= 100) {
          this.statusMeter.setAttribute("value", 0);
          this.onStatusChange(webProgress, webRequest, 0, "Done");
          this._requestsStarted = this._requestsFinished = 0;
        }
      }
    }

    if (webStateFlags & WPL.STATE_IS_NETWORK) {
      if (webStateFlags & WPL.STATE_START) {
        this.throbberElement.setAttribute("busy", "true");

        this.stop.setAttribute("busy", "true");
        this.stop.setAttribute("label", "Stop");

        this.statusMeter.setAttribute("style", "");

      } else if (webStateFlags & WPL.STATE_STOP) {
        this.throbberElement.setAttribute("busy", "false");

        this.stop.setAttribute("busy", "false");
        this.stop.setAttribute("label", "Reload");

        this.statusMeter.setAttribute("value", 0);

        this.onStatusChange(webProgress, webRequest, 0, "Done");

        this._requestsStarted = this._requestsFinished = 0;

        eBrowser.updateTitlebar();

/*        var domDocument = webProgress.DOMWindow.document;
        if (domDocument.title && domDocument.title.length > 0) {
          document.title = domDocument.title;
          
          
          
          //setTimeout(function() {eBrowser.selectedTab.label = document.title;}, 250);
          //debug(eBrowser.selectedTab.label)
          //eBrowser.mCurrentTab.label = document.title;
          //setTimeout(function() {eBrowser.browsers[0].label = document.title;}, 250);
      
          //eBrowser.mCurrentTab.label
          //setTimeout(function() {eBrowser.browsers[0].label = domDocument.title;}, 250);
        }
*/
      }
    }
  },

  // This method is called to indicate progress changes for the currently
  // loading page.
  onProgressChange: function(webProgress, request, curSelf, maxSelf,
                             curTotal, maxTotal) {
    if (this._requestsStarted == 1) {
      if (maxSelf == -1) {
        this.statusMeter.setAttribute("mode", "undetermined");
      } else {
        this.statusMeter.setAttribute("mode", "determined");
        this.statusMeter.setAttribute("value", ((100 * curSelf) / maxSelf) + "%");
      }
    }
  },

  // This method is called to indicate a change to the current location.
  onLocationChange: function(webProgress, request, location) {

    /*if (!onWhiteList(location.spec)) {
      eBrowser.stop();
      eBrowser.goBack()
      return false;
    }*/
    
    this.urlBar.value = location.spec;

    //var browser = dlm_web.getBrowser();
    setTimeout(function() {
    var back = document.getElementById("eBrowserBack");
    var forward = document.getElementById("eBrowserForward");

    back.setAttribute("disabled", !eBrowser.canGoBack);
    forward.setAttribute("disabled", !eBrowser.canGoForward);}, 250);
    
    return true;
  },

  // This method is called to indicate a status changes for the currently
  // loading page.  The message is already formatted for display.
  onStatusChange: function(webProgress, webRequest, webStatus, webMessage) {
    this.statusTextField.setAttribute("label", webMessage);
  },

  // This method is called when the security state of the browser changes.
  onSecurityChange: function(webProgress, webRequest, webState) {
    const WPL = Components.interfaces.nsIWebProgressListener;

    var level = "Unknown";
    if (webState & WPL.STATE_IS_INSECURE) {
    } else {
      if (webState & WPL.STATE_IS_SECURE) {
        if (webState & WPL.STATE_SECURE_HIGH)
          level = "High";
        else if (webState & WPL.STATE_SECURE_MED)
          level = "Medium";
        else if (webState & WPL.STATE_SECURE_LOW)
          level = "Low";
      } else if (webState & WPL.STATE_IS_BROKEN) {
        level = "Mixed";
      }
    }

    this.security.setAttribute("tooltiptext", "Security: " + level);
    this.security.setAttribute("level", level);
  },

  startDocumentLoad : function(aRequest) {
  },

  endDocumentLoad : function(aRequest, aStatus) {
  }
};

function onWhiteList(thisURL) {
  var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                    .getService(Components.interfaces.nsIIOService);

  var thisURIObject = ioService.newURI(thisURL, null, null);

  var gPref = Components.classes["@mozilla.org/preferences-service;1"]
                    .getService(Components.interfaces.nsIPrefBranch2);
  var defaultPrefs = gPref.QueryInterface(Components.interfaces.nsIPrefService)
                   .getDefaultBranch("eMusic.");

  var sIgnoreList = defaultPrefs.getCharPref("domain_whitelist");
  
  var regEx_IgnoreList = new RegExp(sIgnoreList, "ig")
  
  var retVal = true
  
  try {
    var thisScheme = thisURIObject.scheme.toLowerCase()

    switch (thisScheme) {
      case "http":
      case "https":
        if (!regEx_IgnoreList.test(thisURIObject.host)) {
          openExternal(thisURL);
          retVal = false;
        }
        break;
      case "feed":
      case "emusic":
      case "javascript":
        retVal = false;
        break;
      case "about":
      case "chrome":
      case "moz-icon":
        if (!gDebugMode) {
          retVal = false;
        }
        break;
      default:
        var myURLExtension = dlm_base.getFileExtension(thisURL); //thisURL.split(".").pop().toLowerCase();
        if (myURLExtension && (/^(emp)|^(emx)/.test(myURLExtension))) {
          nsPreferences.setUnicharPref("eMusic.cmdLineValue", thisURL);
          retVal = false;
        }

        openExternal(thisURL);
        retVal = false;
    }
  } catch(ex) {
    debug(ex)
    retVal = false;
  }

  return retVal;
}

var dlm_web = {
  getBrowser: function() {
    var browserWindow = dlm_base.mostRecentWindow("emusic:window");

    return browserWindow.document.getElementById("content");
  },

  goThere: function(thisURL, bAppendFREF) {
    var browserWindow = dlm_base.mostRecentWindow("emusic:window");

    if (bAppendFREF) {
      if (thisURL.indexOf("?") == -1) {
        thisURL += "?fref="
      } else {
        thisURL += "&fref="
      }

      thisURL += nsPreferences.copyUnicharPref("eMusic.defaultFREF");
    }

    try {
      var gURIFixup = Components.classes["@mozilla.org/docshell/urifixup;1"]
                          .getService(Components.interfaces.nsIURIFixup);
      var fixedUpURI = gURIFixup.createFixupURI(thisURL, 0);
      
      thisURL = fixedUpURI.spec;
    } catch (ex) {
    }

    /*if (!onWhiteList(thisURL)) {
      return false;
    }*/

    var thisReferrer = null;
    
    try {
      var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                        .getService(Components.interfaces.nsIIOService);

      thisReferrer = ioService.newURI(nsPreferences.copyUnicharPref("eMusic.lastUrl"), null, null);
      //thisReferrer = ioService.newURI(referrerPage, null, null);
    } catch (ex) {
    }

    var mySysInfo = Components.classes["@mozilla.org/system-info;1"]
                      .getService(Components.interfaces.nsIPropertyBag2);

    var myOSVersion = encodeURIComponent(mySysInfo.getProperty("name") + "_" +  
                                    mySysInfo.getProperty("version"));

    var myAppVars  = Components.classes["@mozilla.org/xre/app-info;1"]
                       .getService(Components.interfaces.nsIXULAppInfo)
                       .QueryInterface(Components.interfaces.nsIXULRuntime);
    var myABI = myAppVars.XPCOMABI

    if (eMusicPlatform.ident == "Darwin") {
      var macutils = Components.classes["@mozilla.org/xpcom/mac-utils;1"]
                            .getService(Components.interfaces.nsIMacUtils);

      if (macutils.isUniversalBinary) {
        myABI = "Universal-gcc3";
      }
    }

    thisURL = thisURL.replace("%OS%", myOSVersion)
    thisURL = thisURL.replace("%TARGET%", myABI)

    var formatter = Components.classes["@mozilla.org/toolkit/URLFormatterService;1"]
                      .getService(Components.interfaces.nsIURLFormatter);
    thisURL = formatter.formatURL(thisURL);

    eBrowser.loadURI(thisURL, thisReferrer, null);
 
    browserWindow.document.getElementById("urlbar").value = thisURL

    var myURLExtension = dlm_base.getFileExtension(thisURL); //thisURL.split(".").pop().toLowerCase();

    if (!(/^(exe)|^(gz)|^(jar)|^(xpi)|^(mp3)|^(m3u)|^(emp)|^(emx)/.test(myURLExtension)) &&
        dlm_base.getFileScheme(thisURL) != "chrome") {
      nsPreferences.setUnicharPref("eMusic.lastUrl", thisURL);
    }

    browserWindow.showThisDeck(0);
    
    return true;
  },
  
  go: function() {
    var urlBar = document.getElementById("urlbar");
    dlm_web.goThere(urlBar.value);
  },
  
  back: function() {
    eBrowser.stop();
    eBrowser.goBack();
  },
  
  forward: function() {
    eBrowser.stop();
    eBrowser.goForward();
  },
  
  StopReload: function() {
    var stopreload = document.getElementById("eBrowserStopReload");

    if (stopreload.getAttribute("busy") == "true") {
      eBrowser.stop();
    } else {
      eBrowser.reload();
    }
  },

  goHome: function() {
    if (!gDebugMode) {
      var thisHomepage = nsPreferences.copyUnicharPref("eMusic.defaultHomePage")
      dlm_web.goThere(thisHomepage);
    } else {
      dlm_web.goThere("chrome://emusic/locale/debug_loading.html")
    }
  },
  
  closeTab: function() {
    if (eBrowser.tabContainer.childNodes.length > 1) {
      eBrowser.removeCurrentTab();
    }
  },
  
  BrowserOpenTab: function() {
    eBrowser.loadOneTab(nsPreferences.copyUnicharPref('eMusic.eDefaultHomePage'), null, null, null, false, false);
    if (eURLBar)
      setTimeout(function() { eURLBar.focus(); }, 0);
  },
  
  updateURL: function() {
    var browserWindow = dlm_base.mostRecentWindow("emusic:window");
    browserWindow.document.getElementById("urlbar").value =
      gBrowser.getBrowserForTab(gBrowser.mCurrentTab).currentURI.spec; //contentDocument.title
  }
}

function BrowserCustomizeToolbar() {
//@line 3428 "/cygdrive/c/builds/tinderbox/Fx-Mozilla1.8-release/WINNT_5.2_Depend/mozilla/browser/base/content/browser.js"
  window.openDialog("chrome://global/content/customizeToolbar.xul",
                    "CustomizeToolbar",
                    "chrome,all,dependent",
                    eNavToolbox);
//@line 3433 "/cygdrive/c/builds/tinderbox/Fx-Mozilla1.8-release/WINNT_5.2_Depend/mozilla/browser/base/content/browser.js"
}

function onViewToolbarsPopupShowing(aEvent) {
  var popup = aEvent.target;
  var i;

  // Empty the menu
  for (i = popup.childNodes.length-1; i >= 0; --i) {
    var deadItem = popup.childNodes[i];
    if (deadItem.hasAttribute("toolbarindex"))
      popup.removeChild(deadItem);
  }

  var firstMenuItem = popup.firstChild;

  var toolbox = eNavToolbox;

  if (toolbox.hasChildNodes()) {
    document.getElementById("view_CustomizeToolbars").disabled = false;
  } else {
    document.getElementById("view_CustomizeToolbars").disabled = true;
  }

  for (i = 0; i < toolbox.childNodes.length; ++i) {
    var toolbar = toolbox.childNodes[i];
    var toolbarName = toolbar.getAttribute("toolbarname");
    var type = toolbar.getAttribute("type");
    if (toolbarName && type != "menubar") {
      var menuItem = document.createElement("menuitem");
      menuItem.setAttribute("toolbarindex", i);
      menuItem.setAttribute("type", "checkbox");
      menuItem.setAttribute("label", toolbarName);
      menuItem.setAttribute("accesskey", toolbar.getAttribute("accesskey"));
      menuItem.setAttribute("checked", toolbar.getAttribute("collapsed") != "true");
      popup.insertBefore(menuItem, firstMenuItem);

      menuItem.addEventListener("command", onViewToolbarCommand, false);
    }
    toolbar = toolbar.nextSibling;
  }
}

function onViewToolbarCommand(aEvent) {
  var toolbox = eNavToolbox;
  var index = aEvent.originalTarget.getAttribute("toolbarindex");
  var toolbar = toolbox.childNodes[index];

  toolbar.collapsed = aEvent.originalTarget.getAttribute("checked") != "true";
  toolbar.removeAttribute("hidden")
  document.persist(toolbar.id, "collapsed");
}

function goToggleToolbar( id, elementID ) {
  var toolbar = document.getElementById(id);
  var element = document.getElementById(elementID);
  toolbar.removeAttribute("hidden")

  if (toolbar) {
    var isCollapsed = toolbar.collapsed;
    toolbar.collapsed = !isCollapsed;
    document.persist(id, 'collapsed');
    if (element) {
      element.setAttribute("checked", isCollapsed ? "true" : "false");
      document.persist(elementID, 'checked');
    }
  }
}

function toggleSidebar(aCommandID, forceOpen) {
  // |forceOpen| is a bool that indicates that the sidebar should be forced open.
  // In other words the toggle won't be allowed to close the sidebar.

  var sidebarBox = document.getElementById("sidebar-box");
  if (!aCommandID)
    aCommandID = sidebarBox.getAttribute("sidebarcommand");

  var elt = document.getElementById(aCommandID);
  var sidebar = document.getElementById("sidebar");
  var sidebarTitle = document.getElementById("sidebar-title");
  var sidebarSplitter = document.getElementById("sidebar-splitter");
  var navBrowserTrackBox = document.getElementById("navBrowserTrackBox");

  if (!forceOpen && elt.getAttribute("checked") == "true") {
    elt.removeAttribute("checked");
    sidebarBox.setAttribute("sidebarcommand", "");
    sidebarTitle.setAttribute("value", "");
    sidebarBox.hidden = true;
    sidebarSplitter.hidden = true;
    eTrackPreview.setAttribute("height", "100%");
    eTrackPreview.collapsed = false;
    navBrowserTrackBox.collapsed = false;
    content.focus();
    return;
  }

  var elts = document.getElementsByAttribute("group", "sidebar");
  for (var i = 0; i < elts.length; ++i)
    elts[i].removeAttribute("checked");

  elt.setAttribute("checked", "true");;

  if (document.getElementById("showSidebar").getAttribute("checked") != "true") {
    toggleNavGrid();
  }

  if (sidebarBox.hidden) {
    sidebarBox.hidden = false;
    sidebarSplitter.hidden = false;
  }

  var url = elt.getAttribute("sidebarurl");
  var title = elt.getAttribute("sidebartitle");
  if (!title)
    title = elt.getAttribute("label");
  sidebar.setAttribute("src", url);
  sidebarBox.setAttribute("src", url);
  sidebarBox.setAttribute("sidebarcommand", elt.id);
  sidebarTitle.setAttribute("value", title);
  if (aCommandID != "viewWebPanelsSidebar") { // no searchbox there
    // if the sidebar we want is already constructed, focus the searchbox
    if ((aCommandID == "viewBookmarksSidebar" && sidebar.contentDocument.getElementById("bookmarksPanel"))
    || (aCommandID == "viewHistorySidebar" && sidebar.contentDocument.getElementById("history-panel")))
      sidebar.contentDocument.getElementById("search-box").focus();
    // otherwiese, attach an onload handler
    else
      sidebar.addEventListener("load", asyncFocusSearchBox, true);
  }
}

function TriggerInstall(aEvent, aType, aFileName) {
  var params = new Array() 
  params[aFileName] = { URL: aEvent.target.href,
                      toString: function () { return this.URL; }
  };

  if (aType == "xpi") {
    InstallTrigger.install(params);
  } else {
    InstallTrigger.installChrome(InstallTrigger.SKIN, aEvent.target.href, aFileName);
  }

  return true;
}

///////////////////////////////////////////////////////////////////////////////
// modified verion of FillInHTMLTooltip
// http://lxr.mozilla.org/mozilla1.8/source/browser/base/content/browser.js#2646
///////////////////////////////////////////////////////////////////////////////
function FillInHTMLTooltip(tipElement) {
  var retVal = false;
  if (tipElement.namespaceURI == "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul")
    return retVal;

  const XLinkNS = "http://www.w3.org/1999/xlink";

  var titleText = null;
  var titleURL = null
  var XLinkTitleText = null;

  /*while (!(titleText && titleURL) && !XLinkTitleText && tipElement) {*/
  while (!(titleText) && !XLinkTitleText && tipElement) {
    if (tipElement.nodeType == Node.ELEMENT_NODE) {
      titleText = tipElement.getAttribute("title");
      XLinkTitleText = tipElement.getAttributeNS(XLinkNS, "title");

      /*if (tipElement.href) {
        titleURL = tipElement.href;
      };*/
    }
    tipElement = tipElement.parentNode;
  }
  
  var texts = [titleText, XLinkTitleText];
  var tipNode = document.getElementById("tooltip_text");
  var tipURL = document.getElementById("tooltip_url");

  for (var i = 0; i < texts.length; ++i) {
    var t = texts[i];
    if (t && t.search(/\S/) >= 0) {
      // XXX - Short-term fix to bug 67127: collapse whitespace here
      tipNode.setAttribute("value", t.replace(/\s+/g, " ") );
      retVal = true;
    }
  }

  return retVal;
}

///////////////////////////////////////////////////////////////////////////////
// Drag and Drop
///////////////////////////////////////////////////////////////////////////////
var addonsDNDObserver = {
  _ioServ: null,
  _canDrop: false,
  
  _ensureServices: function () {
    if (!this._ioServ)
      this._ioServ = Components.classes["@mozilla.org/network/io-service;1"]
                               .getService(Components.interfaces.nsIIOService);
  },

  // returns a JS object whose properties are used by xpinstall
  _getDataFromDragSession: function (aDragSession, aPosition) {
    var fileData = { };
    // if this fails we do not have valid data to drop
    try {
      var xfer = Components.classes["@mozilla.org/widget/transferable;1"]
                           .createInstance(Components.interfaces.nsITransferable);
      xfer.addDataFlavor("text/x-moz-url");
      xfer.addDataFlavor("application/x-moz-file", "nsIFile");
      aDragSession.getData(xfer, aPosition);

      var flavour = { }, data = { }, length = { };
      xfer.getAnyTransferData(flavour, data, length);
      var selectedFlavour = this.getSupportedFlavours().flavourTable[flavour.value];
      var xferData = new FlavourData(data.value, length.value, selectedFlavour);

      var fileURL = transferUtils.retrieveURLFromData(xferData.data,
                                                      xferData.flavour.contentType);
      fileData.fileURL = fileURL;

      var uri = this._ioServ.newURI(fileURL, null, null);
      var url = uri.QueryInterface(Components.interfaces.nsIURL);
      fileData.fileName = url.fileName;

      switch (url.fileExtension) {
        case "xpi":
          fileData.type = Components.interfaces.nsIUpdateItem.TYPE_EXTENSION;
          break;
        case "jar":
          fileData.type = Components.interfaces.nsIUpdateItem.TYPE_THEME;
          break;
        default:
          return null;
      }
    } catch (e) {
      debug(e)
      return null;
    }

    return fileData;
  },

  canDrop: function (aEvent, aDragSession) { return this._canDrop; },

  onDragEnter: function (aEvent, aDragSession) {

    // XXXrstrong - bug 269568, GTK2 drag and drop is returning invalid data for
    // dragenter and dragover. To workaround this we always set canDrop to true
    // and just use the xfer data returned in ondrop which is valid.
//@line 1134 "/cygdrive/c/builds/tinderbox/Fx-Mozilla1.8/WINNT_5.2_Depend/mozilla/toolkit/mozapps/extensions/content/extensions.js"
    this._ensureServices();

    var count = aDragSession.numDropItems;

    for (var i = 0; i < count; ++i) {
      var fileData = this._getDataFromDragSession(aDragSession, i);
      if (!fileData) {
        this._canDrop = false;
        return;
      }
    }
//@line 1145 "/cygdrive/c/builds/tinderbox/Fx-Mozilla1.8/WINNT_5.2_Depend/mozilla/toolkit/mozapps/extensions/content/extensions.js"
    this._canDrop = true;
  },

  onDragOver: function (aEvent, aFlavor, aDragSession) { },

  onDrop: function(aEvent, aXferData, aDragSession) {

    this._ensureServices();
    
    var xpinstallObj = { };
    var themes = { };
    var xpiCount = 0;
    var themeCount = 0;
    
    var count = aDragSession.numDropItems;
    for (var i = 0; i < count; ++i) {
      var fileData = this._getDataFromDragSession(aDragSession, i);
      if (!fileData)
        continue;

      if (fileData.type == Components.interfaces.nsIUpdateItem.TYPE_EXTENSION) {
        xpinstallObj[fileData.fileName] = fileData.fileURL;
        ++xpiCount;
      } else if (fileData.type == Components.interfaces.nsIUpdateItem.TYPE_THEME) {
        themes[fileData.fileName] = fileData.fileURL;
        ++themeCount;
      }
    }

    if (xpiCount > 0) 
      InstallTrigger.install(xpinstallObj);
    if (themeCount > 0) {
      // XXXrstrong Only allow the install of one theme due to bug 257992
      for (var fileName in themes) {
        InstallTrigger.installChrome(InstallTrigger.SKIN, themes[fileName], fileName);
        break;
      }
    }
  },

  _flavourSet: null,  

  getSupportedFlavours: function () {
    if (!this._flavourSet) {
      this._flavourSet = new FlavourSet();
      this._flavourSet.appendFlavour("text/x-moz-url");
      this._flavourSet.appendFlavour("application/x-moz-file", "nsIFile");
    }
    return this._flavourSet;
  }
};
