/** Copyright © 2007 eMusic.com Inc.
 
This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or (at your option) any later version.  The GNU Lesser General Public License can be viewed by clicking on the following link:  http://www.gnu.org/licenses/lgpl.html#SEC4.  
 
This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**/

const NC_NS = "http://home.netscape.com/NC-rdf#"
const dlmgrContractID = "@mozilla.org/download-manager;1"
const dlmgrIID = Components.interfaces.nsIDownloadManager
const rdfRes = Components.interfaces.nsIRDFResource
const rdfLit = Components.interfaces.nsIRDFLiteral
const rdfInt = Components.interfaces.nsIRDFInt
const rdfDate = Components.interfaces.nsIRDFDate

const nsIThread = Components.interfaces.nsIThread;
const ThreadContractID = "@mozilla.org/thread;1";

const nsCI  = Components.interfaces;
const nsIWebNavigation = nsCI.nsIWebNavigation;

var eStringBundleService = Components.classes["@mozilla.org/intl/stringbundle;1"]
      .getService(Components.interfaces.nsIStringBundleService);

var gDebugMode = nsPreferences.getBoolPref("eMusic.debugMode");
var gHadDownloadErrors = false;

var dlm_base = {
  toStartup: function() {
    var topWindow = dlm_base.mostRecentWindow("emusic:window");
  
    if (topWindow) {
      topWindow.focus();
    } else {
      var params = "dialog=no,toolbar=yes,location=yes,scrollbars=yes,titlebar=no,status=yes,all"
      
      /*if (eMusicPlatform.ident != "Darwin") {
        params += ",all"
      } else {
        
      }*/

      window.openDialog('chrome://emusic/content/startup.xul', 'emusic:window', params)
    }
  },

  toOpenWindowByType: function(inType, uri, features) {
    var topWindow = dlm_base.mostRecentWindow(inType);
  
    if (topWindow)
      topWindow.focus();
    else if (features)
      window.open(uri, "_blank", features);
    else
      window.open(uri, "_blank", "chrome,extrachrome,menubar,resizable,scrollbars,status,toolbar");
  },

  toErrorConsole: function() {
    toOpenWindowByType("global:console", "chrome://global/content/console.xul");
  },

  toConfig: function() {
    toOpenWindowByType("Preferences:ConfigManager", "chrome://global/content/config.xul", "chrome,titlebar,centerscreen,resizable,dialog=no");
  },
  
  toAbout: function() {
    toOpenWindowByType("eMusic:about", "chrome://emusic/content/about.xul", "modal,chrome,titlebar,centerscreen");
  },

  toAddons: function() {
    toOpenWindowByType("Extension:Manager", "chrome://mozapps/content/extensions/extensions.xul" , "chrome,menubar,extra-chrome,toolbar,dialog=no,resizable");
  },

  toAbout: function() {
    toOpenWindowByType("eMusic:about", "chrome://emusic/content/about.xul", "modal,chrome,titlebar,centerscreen");
  },
  
  toOptions: function() {
    toOpenWindowByType("Browser:Preferences", "chrome://browser/content/preferences/preferences.xul");
  },
  
  toDownloads: function() {
    toOpenWindowByType("Download:Manager", "chrome://mozapps/content/downloads/downloads.xul");
  },
  
  toViewSource: function() {
    window.openDialog("chrome://global/content/viewSource.xul", "_blank", "all,dialog=no", document.getElementById("urlbar").value);
  },
  
  mostRecentWindow: function(windowType) {
  
    windowType = (windowType) ? windowType : "emusic:window"
  
    var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"].
               getService(Components.interfaces.nsIWindowMediator);
    return wm.getMostRecentWindow(windowType);
  },
  
  loadExternalURL: function(url) {
    if (url) {
      var uri = Components.classes["@mozilla.org/network/io-service;1"].
                    getService(Components.interfaces.nsIIOService)
      try {
        uri = uri.newURI(url, null, null);
      } catch (ex) {
        uri = uri.newFileURI(url);
      }
      var protocolSvc = Components.classes["@mozilla.org/uriloader/external-protocol-service;1"].
                          getService(Components.interfaces.nsIExternalProtocolService);
      protocolSvc.loadUrl(uri);
    }
  },
  
  getLocalFileInterface: function(thisPath) {
    try {
      var localFileInterface = Components.classes["@mozilla.org/file/local;1"].
                                 createInstance(Components.interfaces.nsILocalFile);

      localFileInterface.initWithPath(thisPath);

      return localFileInterface;
    } catch (ex) {
      return null;
    }
  },

  fileExists: function(thisPath) {
    try {
      thisPath = dlm_base.scrubPath(thisPath)
      
  		var obj_TargetFile = dlm_base.getLocalFileInterface(thisPath)
  
      return obj_TargetFile.exists()
    } catch (ex) {
      //debug(ex)
      return false;
    }
  },
  
  removeFile: function(thisPath) {
    try {
      thisPath = dlm_base.scrubPath(thisPath)

  		var obj_TargetFile = dlm_base.getLocalFileInterface(thisPath)
  
      if (obj_TargetFile.exists()) {
        obj_TargetFile.remove(false)
      }
    } catch (ex) {
      //debug(ex)
    }
  },

  showThisPath: function(thisPath) {

    if (!thisPath) return false;

    thisPath = dlm_base.scrubPath(thisPath)

    var iPath = this.getLocalFileInterface(thisPath);

    try {
      iPath.reveal();
    } catch (ex) {
      // if reveal failed for some reason (eg on unix it's not currently
      // implemented), send the file: URL to the OS handler for that protocol
      var thisURI = Components.classes["@mozilla.org/network/io-service;1"]
                    .getService(Components.interfaces.nsIIOService)
      try {
        thisURI = thisURI.newURI(iPath, null, null);
      } catch (ex) {
        try {
          thisURI = thisURI.newFileURI(iPath);
        } catch (ex) {
          thisURI = thisURI.newURI(thisPath, null, null);
        }
      }

      var protocolSvc = Components.classes["@mozilla.org/uriloader/external-protocol-service;1"]
                                  .getService(Components.interfaces.nsIExternalProtocolService);
      protocolSvc.loadUrl(thisURI);
    }
    return true;
  },

  clearCache: function() {
    var cacheClass = Components.classes["@mozilla.org/network/cache-service;1"];
    var cacheService = cacheClass.getService(Components.interfaces.nsICacheService);
  
    try {
      cacheService.evictEntries(Components.interfaces.nsICache.STORE_ON_DISK);
      cacheService.evictEntries(Components.interfaces.nsICache.STORE_IN_MEMORY);
    } catch(ex) {
    }
  },
  
  getContents: function(aURL){
    try {
      var content = "";
      var data = {};

      //http://developer.mozilla.org/en/docs/Reading_textual_data
      var file = this.getLocalFileInterface(aURL);
    
      var fstream = Components.classes["@mozilla.org/network/file-input-stream;1"]
                      .createInstance(Components.interfaces.nsIFileInputStream);
      fstream.init(file, 0x01, 0, 0);
  
      var cstream = Components.classes["@mozilla.org/intl/converter-input-stream;1"].
                     createInstance(Components.interfaces.nsIConverterInputStream);
      cstream.init(fstream, "UTF-8", 1024, Components.interfaces.nsIConverterInputStream.DEFAULT_REPLACEMENT_CHARACTER);
      
      while (cstream.readString(4096, data)) {
        content += data.value;
      }
  
      cstream.close();
      fstream.close();
    } catch (ex) {
      debug(ex)
    }
    return content;
  },

  writeContents: function(aFile, aContent) {
    var os = Components.classes["@mozilla.org/intl/converter-output-stream;1"]
                       .createInstance(Components.interfaces.nsIConverterOutputStream);

    var fos = Components.classes['@mozilla.org/network/file-output-stream;1']
                 .createInstance(Components.interfaces.nsIFileOutputStream);

    fos.init(aFile, 0x20|0x02|0x08, 0755, 0);
    
    os.init(fos, "UTF-8", 4096, 0x0000);

    os.writeString(aContent);

    os.close();
  },

  quit: function(aForceQuit) {
    if (eAudiobooksQueue.length == 0 && typeof canQuitApplication == "function" && canQuitApplication()) {

      // Store these into the window attributes (for persistence).
/*      var win = dlm_base.mostRecentWindow("emusic:window").document.getElementById("main-window");;
      win.setAttribute( "x", window.screenX);
      win.setAttribute( "y", window.screenY);
      win.setAttribute( "height", window.outerHeight);
      win.setAttribute( "width", window.outerWidth);
      win.setAttribute( "laststate", eMusicPlatform.windowState);
*/
      try {
        dlm_base.mostRecentWindow().trayIcon['eMusicTrayIcon'].hideIcon();
      } catch(ex) {
      }

      var appStartup = Components.classes['@mozilla.org/toolkit/app-startup;1'].
        getService(Components.interfaces.nsIAppStartup);
    
      // eAttemptQuit will try to close each XUL window, but the XUL window can cancel the quit
      // process if there is unsaved data. eForceQuit will quit no matter what.
      var quitSeverity = aForceQuit ? Components.interfaces.nsIAppStartup.eForceQuit :
                                      Components.interfaces.nsIAppStartup.eAttemptQuit;
      appStartup.quit(quitSeverity);

      return true;
    }

    return false;
  },

  scrub: function(txt) {
    try {
      txt = unescape(txt);

      // Remove specific characters first
      var myRegEx = new RegExp(/[\:|_|>|<|\||?|\"]/g);
      txt = txt.replace(myRegEx, " ");
  
      myRegEx = new RegExp(/[*|\/|\\|\#|]/g);
      txt = txt.replace(myRegEx, "-");
  
      // fix extended characters and older emp formats
      myRegEx = new RegExp(/\’/g)
      txt = txt.replace(myRegEx, "'");
      
      // Trim any trialing periods
      myRegEx = new RegExp(/\.+$/g) // /\.{1,}$/g;
      txt = txt.replace(myRegEx, " ");

      // final pass to remove multiple spaces, dashes and underscores
      // that might have been created by previous regex
      myRegEx = new RegExp(/\s+/g) // /\s{2,}/g;
      txt = txt.replace(myRegEx, " ");

      myRegEx = new RegExp(/\-+/g)
      txt = txt.replace(myRegEx, "-");

      txt = dlm_base.trim(txt);
      
    } catch (ex) {
    }
    return txt;
  },
  
  scrubPath: function(thisURL) {
    thisURL = thisURL.replace('file://localhost', '') // mac hack
    thisURL = thisURL.replace('file://', '') // linux hack

    try {
      thisURL = decodeURI(thisURL);
      thisURL = unescape(thisURL);
    } catch(ex) {
      thisURL = unescape(thisURL);
    }

    if (eMusicPlatform.ident == "WINNT" && thisURL.indexOf("http") != 0) {
      thisURL = thisURL.replace(/\//g, "\\") // fix slashes on Windows for local files
    }

    return thisURL;
  },
  
  trim: function(thisString) {
    var myRegEx = new RegExp(/^\s+|\s+$/)
    return thisString.replace(myRegEx, "");
  },

  padZero: function(thisString, thisLength) {

    thisString = thisString.toString();

    if (thisLength == 1) thisLength = 2

    var numZeros = thisLength - thisString.length

    if (numZeros > 0) {
      for (var i = 1; i <= numZeros; i++) {
         thisString = "0" + thisString
      }
    }
    return thisString
  },
  
  getFileExtension: function(thisURL) {
    var urlObj = Components.classes['@mozilla.org/network/standard-url;1']
                   .createInstance(Components.interfaces.nsIURL);
    urlObj.spec = thisURL;

    return urlObj.fileExtension.toLowerCase();
  },

  getFileScheme: function(thisURL) {
    var urlObj = Components.classes['@mozilla.org/network/standard-url;1']
                   .createInstance(Components.interfaces.nsIURL);
    urlObj.spec = thisURL;

    return urlObj.scheme.toLowerCase();
  },

  getSpecialFolder: function(thisType){
  // http://developer.mozilla.org/en/docs/Code_snippets:File_I/O
    var ds = Components.classes["@mozilla.org/file/directory_service;1"].
                 getService(Components.interfaces.nsIProperties);
    return ds.get(thisType, Components.interfaces.nsILocalFile);
  },
  
  getVendor: function() {
    return Components.classes['@mozilla.org/xre/app-info;1'].getService(Components.interfaces.nsIXULAppInfo).vendor;
  },

  getName: function() {
    var myLocalStrings = eStringBundleService
                           .createBundle("chrome://emusic/locale/emusic.properties");
    return myLocalStrings.GetStringFromName("appName")
    //return Components.classes['@mozilla.org/xre/app-info;1'].getService(Components.interfaces.nsIXULAppInfo).name;
  },

  getBuildID: function() {
    return Components.classes['@mozilla.org/xre/app-info;1'].getService(Components.interfaces.nsIXULAppInfo).appBuildID;
  },

  getAppID: function() {
    return Components.classes['@mozilla.org/xre/app-info;1'].getService(Components.interfaces.nsIXULAppInfo).ID;
  },

  getAppVersion: function() {
    return Components.classes['@mozilla.org/xre/app-info;1']
             .getService(Components.interfaces.nsIXULAppInfo).version;
  },
  
  getMozIcon: function(thisPath, thisSize) {

    thisSize = (!thisSize) ? "16" : thisSize

    var tmpMozIcon = dlm_base.getLocalFileInterface(thisPath)

    var ioServ = Components.classes["@mozilla.org/network/io-service;1"].
                   getService(Components.interfaces.nsIIOService);

    var fph    = ioServ.getProtocolHandler("file").
                   QueryInterface(Components.interfaces.nsIFileProtocolHandler);

    try {
      return "moz-icon://" +  fph.getURLSpecFromFile(tmpMozIcon) + "?size=" + thisSize;
    } catch (ex) {
      return null
    }
  },
  
  popup: function(thisMessage) {
    var thisPage = "chrome://emusic/content/newalert.xul"
    var thisChrome = "chrome,dialog=yes,titlebar=no,popup=yes"

    window.openDialog(thisPage, "alert:alert", thisChrome, thisMessage);
  },
  
  secondsToTime: function(thisSeconds) {
    var S = thisSeconds % 60;
    var M = (thisSeconds - S) / 60 ;

    S = dlm_base.padZero(S, 2);

    return(M + ":" + S);
  },

  browseForApp: function(thisCheckbox, thisCurrentPath) {
    var mDirPicker = Components.classes['@mozilla.org/filepicker;1']
                       .createInstance(Components.interfaces.nsIFilePicker)

    mDirPicker.init(window, "", mDirPicker.modeOpen);
  
    var mlocationCheckBox = document.getElementById(thisCheckbox)
    var mlocationField = document.getElementById(thisCurrentPath)

    try {
      var mLocation = mlocationField.value;

      if (mLocation.length > 0) {
        var currentLocation = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile)
        currentLocation.initWithPath(mLocation);
        mDirPicker.displayDirectory = currentLocation;
      }

      mLocation = null;
    } catch (e) {
      debug(ex);
    }
    
    mDirPicker.appendFilters(Components.interfaces.nsIFilePicker.filterApps);
    var retVal = mDirPicker.show();

    if(retVal == mDirPicker.returnOK) {
      var file = mDirPicker.file.QueryInterface(Components.interfaces.nsILocalFile);

      mlocationField.value = file.path //mDirPicker.file.persistentDescriptor;

      mlocationCheckBox.checked = true;

      dlm_base.updateCustomPlayer()
    }
  },
  
  updateCustomPlayer: function() {
    var mlocationField = document.getElementById("player-CustomPlayerPath").value
  
    if (mlocationField.length > 0) {
      var thisPath = dlm_base.getLocalFileInterface(mlocationField);

      nsPreferences.mPrefService
        .setComplexValue("eMusic.defaultMediaPlayer", Components.interfaces.nsILocalFile, thisPath);

      nsPreferences.setUnicharPref("eMusic.defaultMediaPlayerObj", "CustomPlayer");
    } else {
      dlm_base.browseForApp('player-CustomPlayer', 'player-CustomPlayerPath');
    }
  },
  
  buildLink: function(thisPath) {
    //nsPreferences.copyUnicharPref('eMusic.defaultServer') + "?show"
  }
}

function BrowserStartup() {
}

function getBrowserURL() {
  return "chrome://emusic/content/startup.xul";
}

function debug(aLogString) {
  var mConsoleService = Components.classes["@mozilla.org/consoleservice;1"]
         .getService(Components.interfaces.nsIConsoleService)
  mConsoleService.logStringMessage("eMusic_DLM: " + aLogString + "\n");
}

function reportError(aLogString) {
  Components.utils.reportError(aLogString);
}

if (typeof toErrorConsole == "undefined")       var toErrorConsole = dlm_base.toErrorConsole; 
if (typeof toJavaScriptConsole == "undefined")  var toJavaScriptConsole = dlm_base.toErrorConsole; 
if (typeof toOpenWindowByType == "undefined")   var toOpenWindowByType = dlm_base.toOpenWindowByType;
if (typeof toAddons == "undefined")             var toAddons = dlm_base.toAddons;
if (typeof openAddonsMgr == "undefined")        var openAddonsMgr = dlm_base.toAddons;
if (typeof openExternal == "undefined")         var openExternal = dlm_base.loadExternalURL;
if (typeof gContextMenu == "undefined")         var gContextMenu = null
if (typeof gPrefService == "undefined")         var gPrefService = Components.classes["@mozilla.org/preferences-service;1"]
                                                                      .getService( Components.interfaces.nsIPrefBranch);

if (typeof dlm_web == "object") {
  //if (typeof openUILinkIn == "undefined")       var openUILinkIn = dlm_web.goThere;
  if (typeof openUILink == "undefined")         var openUILink = dlm_web.goThere;
  if (typeof getBrowser == "undefined")         var getBrowser = dlm_web.getBrowser;
  if (typeof BrowserOpenTab == "undefined")     var BrowserOpenTab = dlm_web.BrowserOpenTab;
}

function openUILinkIn(myURL, where, allowThirdPartyFixup, postData) {

  var thisWindow = dlm_web.getBrowser();

  if (where == "save") {
    saveURL(myURL, null, null, true);
    return;
  }

  var loadInBackground = nsPreferences.getBoolPref("browser.tabs.loadInBackground", false);

  switch (where) {
    case "tabshifted":
      loadInBackground = !loadInBackground;
      // fall through
    case "tab":
      var newTab = thisWindow.addTab(myURL, null, null);
      if (!loadInBackground) thisWindow.selectedTab = newTab;

      //browser.loadOneTab(url, null, null, postData, loadInBackground,
      //                   allowThirdPartyFixup || false);
      break;
    default:
      dlm_web.goThere(myURL);
      break;
  }
}

function setPopupHandler() {
  document.getElementById('content').open = function()  {
    dlm_web.goThere(arguments[0]);
  }
}

function assocSort(oAssoc) {
  var idx; var key; var arVal = []; var arValKey = []; var oRes = {};

  for (key in oAssoc) {
    arVal[arVal.length] = oAssoc[key];
    arValKey[oAssoc[key]] = key;
  }

  arVal.sort();

  for (idx in arVal)
    oRes[arValKey[arVal[idx]]] = arVal[idx];
  return oRes;
}

function prepMediaManagers(iconSize) {
  var tblBody = document.getElementById("mediaTbl")

  var thisMediaSync = nsPreferences.copyUnicharPref("eMusic.defaultMediaSync")

  if (!iconSize) iconSize = 32
  
  if (tblBody) {
    tblBody = tblBody.tBodies[0];
  }

  var tmpMediaManagers = new Array()
  for (key in mediaManagers) {
    tmpMediaManagers.push(key);
  }

  tmpMediaManagers.sort();

  var alternateBars = 0

  for (thisManager in tmpMediaManagers) {
      thisManager = tmpMediaManagers[thisManager]
      //debug(thisManager)
    try {
      var tmpInit = mediaManagers[thisManager].init();
      
      if (!tmpInit) continue
      
      //debug(mediaManagers[thisManager].getAppName() + ": " + tmpInit)
      //debug(mediaManagers[thisManager].getAppPath())
      
      if (tblBody) {
        var mozIconPath = dlm_base.getMozIcon(mediaManagers[thisManager].getAppPath(), iconSize)

        var newRow = tblBody.insertRow(1);
        if (alternateBars%2) {
          newRow.setAttribute("class", "rOdd")
        } else {
          newRow.setAttribute("class", "rEven")
        }
        

        var newCell = newRow.insertCell(0);
        newCell.setAttribute("class", "mediaTitle")
        newCell.setAttribute("width", iconSize)
        newCell.setAttribute("align", "center")
        var newInput = document.createElement("image");
        newInput.setAttribute("src", mozIconPath)
        newInput.setAttribute("height", iconSize)
        newInput.setAttribute("width", iconSize)
        newInput.setAttribute("alt", "")
        newInput.setAttribute("onclick", "mediaManagers['" + thisManager + "'].launch(); event.stopPropagation();")
        newCell.appendChild(newInput)

        var HTMLNS = "http://www.w3.org/1999/xhtml";

        newCell = newRow.insertCell(1)
        newCell.setAttribute("class", "mediaTitle")
        newCell.setAttribute("align", "center")
        newInput = document.createElementNS(HTMLNS, "html:input")
        newInput.setAttribute("type", "radio")
        newInput.setAttribute("id", "sync-" + thisManager)
        newInput.setAttribute("name", "sync")
        newInput.setAttribute("onclick", "mediaManagers['" + thisManager + "'].setAsDefaultSync();")
        if (thisManager == thisMediaSync) {
          newInput.setAttribute("checked", "")
        }
        newCell.appendChild(newInput)

        newCell = newRow.insertCell(2);
        newCell.setAttribute("class", "mediaTitle")
        newCell.setAttribute("onclick", "mediaManagers['" + thisManager + "'].setAsDefaultSync();")
        newCell.appendChild(document.createTextNode(mediaManagers[thisManager].getAppName()));

        newCell = newRow.insertCell(3);
        //newCell.setAttribute("width", "10")
        newCell.setAttribute("class", "mediaTitleCenterCell")

        var newCell = newRow.insertCell(4);
        newCell.setAttribute("class", "mediaTitle")
        newCell.setAttribute("width", iconSize)
        newCell.setAttribute("align", "center")
        var newInput = document.createElement("image");
        newInput.setAttribute("src", mozIconPath)
        newInput.setAttribute("height", iconSize)
        newInput.setAttribute("width", iconSize)
        newInput.setAttribute("alt", "")
        newInput.setAttribute("onclick", "mediaManagers['" + thisManager + "'].launch(); event.stopPropagation();")
        newCell.appendChild(newInput)

        newCell = newRow.insertCell(5)
        newCell.setAttribute("class", "mediaTitle")
        newCell.setAttribute("align", "center")
        newInput = document.createElementNS(HTMLNS, "html:input")
        newInput.setAttribute("type", "radio")
        newInput.setAttribute("name", "player")
        newInput.setAttribute("id", "player-" + thisManager)
        newInput.setAttribute("onclick", "mediaManagers['" + thisManager + "'].setAsDefaultPlayer();")
        if (thisManager == nsPreferences.copyUnicharPref('eMusic.defaultMediaPlayerObj')) {
          newInput.setAttribute("checked", "")
        }
        newCell.appendChild(newInput);

        newCell = newRow.insertCell(6);
        newCell.setAttribute("class", "mediaTitle")
        newCell.setAttribute("onclick", "mediaManagers['" + thisManager + "'].setAsDefaultPlayer();")
        newCell.appendChild(document.createTextNode(mediaManagers[thisManager].getAppName()));

        alternateBars++
      }
    } catch (ex) {
      debug(ex);
    }
  }
}


function setRDFRoot(aID, aRoot) {
  var rdf = Components.classes["@mozilla.org/rdf/rdf-service;1"]
              .getService(Components.interfaces.nsIRDFService);

  eDownloadManager.datasource.RemoveObserver(dlm_dlds_observer);

  //eDownloadManager.saveState();

  eDownloadManager.datasource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();      //document.getElementById('eWizard').goTo("player")

  var ds = eDownloadManager.datasource;

  var rdfContainer = Components.classes["@mozilla.org/rdf/container;1"]
                       .createInstance(Components.interfaces.nsIRDFContainer);

  aRoot = (aRoot) ? aRoot : "NC:DownloadsRoot";

  var dbRootNode = rdf.GetResource(aRoot);

  try {
    rdfContainer.Init(ds, dbRootNode);
  } catch (ex) {
    var rdfUtils = Components.classes["@mozilla.org/rdf/container-utils;1"]
                     .getService(Components.interfaces.nsIRDFContainerUtils);
    rdfUtils.MakeSeq(ds, dbRootNode);
    rdfContainer.Init(ds, dbRootNode);
  }

//debug(aID)
  var newRes = rdf.GetResource(aID);
//debug(rdfContainer.IndexOf(newRes))
  if (rdfContainer.IndexOf(newRes) == -1) {
    rdfContainer.AppendElement(newRes);
    //rdfContainer.InsertElementAt(newRes, 0, false);
  }

  eDownloadManager.datasource.AddObserver(dlm_dlds_observer);

	/*var remoteDS = ds.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
  remoteDS.Flush();*/
}

function setRDFProperty(aID, aProperty, aValue, aMultiple, aType) {
  var rdf = Components.classes["@mozilla.org/rdf/rdf-service;1"]
              .getService(Components.interfaces.nsIRDFService);

  var aDS = eDownloadManager.datasource
  
  aValue = (!aValue) ? "" : aValue;

  var propertyArc = rdf.GetResource(NC_NS + aProperty);
  
  var res = rdf.GetResource(aID);
  var node = aDS.GetTarget(res, propertyArc, true);

  if (aMultiple) {
    node = null;
  }

  var myRDFValue
  
  try {
    switch (aType) {
      case rdfRes:
        myRDFValue = rdf.GetResource(aValue);
        break;
      case rdfInt:
        myRDFValue = rdf.GetIntLiteral(aValue);
        break;
      case rdfDate:
        myRDFValue = rdf.GetDateLiteral(aValue);
        break;
      default:
        myRDFValue = rdf.GetLiteral(aValue);
        break;
    }
  } catch(ex) {
    debug(ex + " | " + aID + "|" + aProperty + "|" + aValue)
  }

  try {
    if (node) {
      aDS.Change(res, propertyArc, node, myRDFValue);
    } else {
      aDS.Assert(res, propertyArc, myRDFValue, true);
    }
  } catch(ex) {
    debug(ex + " | " + aID + "|" + aProperty + "|" + aValue)
  }

	/*var remoteDS = aDS.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
  remoteDS.Flush();*/
}

function getRDFProperty(aID, aProperty, aDS) {
  
  if (!aID) return ""

  var rdf = Components.classes["@mozilla.org/rdf/rdf-service;1"]
              .getService(Components.interfaces.nsIRDFService);

  if (!aDS) {
    aDS = eDownloadManager.datasource;
  }

  var propertyArc = rdf.GetResource(NC_NS + aProperty);
  
  var res = rdf.GetResource(aID);
  var node = aDS.GetTarget(res, propertyArc, true);

  if (!node) return "";

  try {
    node = node.QueryInterface(Components.interfaces.nsIRDFLiteral);
    return node.Value;
  } catch (ex) {
    try {
      node = node.QueryInterface(Components.interfaces.nsIRDFInt);
      return node.Value;
    } catch (ex) {
      try {
        node = node.QueryInterface(Components.interfaces.nsIRDFDate);
        return node.Value;
      } catch (ex) {
        node = node.QueryInterface(Components.interfaces.nsIRDFResource);
        return node.Value;
      }
    }
  }
  return "";
}

var dlm_dlds_observer = {
  onAssert            : function(ds, source, predicate, target) {},
  onMove              : function(ds, oldSource, newSource, predicate, target) {},
  onBeginUpdateBatch  : function(ds) {},
  onEndUpdateBatch    : function(ds) {},
  onChange: function() {},

  onUnassert: function(dataSource, source, property, target) {
    // Only process removed album resource assertions.
    var rdf = Components.classes["@mozilla.org/rdf/rdf-service;1"]
                .getService(Components.interfaces.nsIRDFService);
    var albumRsrcProp = rdf.GetResource("http://home.netscape.com/NC-rdf#albumRsrc");
    if (!property.EqualsNode(albumRsrcProp))
      return;

    // Get the removed album and track resources.
    var albumRsrc = target.QueryInterface(nsCI.nsIRDFResource);
    var trackRsrc = source;

    // Do nothing if any assertions exist between the album and track.
    if (dataSource.HasAssertion(trackRsrc, albumRsrcProp, albumRsrc, true))
      return;

    // Remove track assertion from album.
    var trackRsrcProp = rdf.GetResource("http://home.netscape.com/NC-rdf#trackRsrc");
    dataSource.Unassert(albumRsrc, trackRsrcProp, source);

    // Remove album if it has no track assertions.
    if (!dataSource.hasArcOut(albumRsrc, trackRsrcProp)) {
      var arcs = dataSource.ArcLabelsOut(albumRsrc);
      while (arcs.hasMoreElements()) {
        var arc = arcs.getNext().QueryInterface(nsCI.nsIRDFResource);
        var targets = dataSource.GetTargets(albumRsrc, arc, true);
        while (targets.hasMoreElements()) {
          var thisTarget = targets.getNext();
          dataSource.Unassert(albumRsrc, arc, thisTarget);
        }
      }

      var rdfContainer = Components.classes["@mozilla.org/rdf/container;1"]
                           .createInstance(Components.interfaces.nsIRDFContainer);
      var dbRootNode = rdf.GetResource("NC:DownloadAlbumsRoot");
      rdfContainer.Init(dataSource, dbRootNode);
      rdfContainer.RemoveElement(albumRsrc, true);
    }
  }
};

function addDownloadAlbum(aAlbumURI) {
  var rdf = Components.classes["@mozilla.org/rdf/rdf-service;1"]
              .getService(Components.interfaces.nsIRDFService);

  var downloadAlbumsRootNode = rdf.GetResource("NC:DownloadAlbumsRoot");

  var rdfContainer = Components.classes["@mozilla.org/rdf/container;1"]
                       .createInstance(Components.interfaces.nsIRDFContainer);
  var ds = eDownloadManager.datasource;

  try {
    rdfContainer.Init(ds, downloadAlbumsRootNode);
  } catch (ex) {
    var rdfUtils = Components.classes["@mozilla.org/rdf/container-utils;1"]
                     .getService(Components.interfaces.nsIRDFContainerUtils);
    rdfUtils.MakeSeq(ds, downloadAlbumsRootNode);
    rdfContainer.Init(ds, downloadAlbumsRootNode);
  }

  var albumNode = rdf.GetResource(aAlbumURI);

  if (rdfContainer.IndexOf(albumNode) == -1) {
    rdfContainer.AppendElement(albumNode);
  }
}

function BrowserFullScreen() {
  window.fullScreen = !window.fullScreen;
}

function getWebNavigation() {
  try {
    return eBrowser.webNavigation;
  } catch (ex) {
    return null;
  }
}

function DefaultPlayer() {
  this.corePlayerObj = "DefaultPlayer"  // must match constructor name
  this.arrRegAppPath = new Array  // registry keys to try to find install base and/or exe name
  this.arrFileAppPath = new Array // hardcoded uri to do dumb look up if registries or other lookups fail
  this.arrRegMediaLibraryPath = new Array  // registry keys to search for music library
  this.arrRegAppVersion= new Array // registry keys to find app version (if needed)
  this.arrAppName = new Array
  this.appName = "System Default" // default name can be overwritten by getAppName()
  this.appPath = null
}

DefaultPlayer.prototype = {
  init: function() {
    // initialize all settings
    return false;
  },
  
  launch: function() {
  },
  
  syncMedia: function(thisFile) {
  },
  
  setAsDefaultPlayer: function() {
    nsPreferences.setUnicharPref("eMusic.defaultMediaPlayer", this.corePlayerObj)
    nsPreferences.setUnicharPref("eMusic.defaultMediaPlayerObj", this.corePlayerObj)
    debug(this.appName + " set as default playa")
  },
  
  setAsDefaultSync: function(){
    nsPreferences.setUnicharPref("eMusic.defaultMediaSync", "NoSync")
    debug("syncing disabled")
  },
  
  isInstalled: function() {
    return true;
  },
  
  getAppName: function() {
    return this.appName;
  },
  
  getMediaFolder: function() {
    return null;
  },

  canSync: function() {
  },
  
  canPlay: function() {
  },
  
  getAppPath: function() { // just in case we need to do customize
    return this.appPath
  },
  
  getAppExecFilename: function() {
  },
  
  getAppVersion: function() {
    return null;
  }
  
}




if (typeof mediaManagers == "undefined") {
  var mediaManagers = new Array
  mediaManagers["DefaultPlayer"] = new DefaultPlayer
}

var eDownloadManager
var eAudiobooksQueue = new Array

// Attempt fixing legacy importing of download queue
try {
  eDownloadManager = Components.classes[dlmgrContractID].getService(dlmgrIID)
} catch(ex) {
  var profileRDFPath = dlm_base.getSpecialFolder("ProfD")
  profileRDFPath.append("downloads.rdf")

  try {
    var downloadsRDFcontents = dlm_base.getContents(profileRDFPath.path)
  
    var myRegEx = new RegExp(/[â€™||\`]/g);
    downloadsRDFcontents = downloadsRDFcontents.replace(myRegEx, "'");
    
    dlm_base.writeContents(profileRDFPath, downloadsRDFcontents)

  } catch(ex) {
    dlm_base.removeFile(profileRDFPath.path)
    eDownloadManager = Components.classes[dlmgrContractID].getService(dlmgrIID)
    eDownloadManager.saveState();
  }
}
