var prefs = nsPreferences.mPrefService;

var eWizard = {

  firstTime: false,

  importLegacy: false,

  init: function() {

    if (typeof legacyImport == "object") {
      legacyImport.init()

      if (!eWizard.importLegacy) {
        document.getElementById('eWizard').getPageById("welcome").setAttribute("next", "folder")
      }
    }
    
    var buttonNext = document.getElementById('eWizard').getButton("next")
    var buttonBack = document.getElementById('eWizard').getButton("back")
    var buttonFinish = document.getElementById('eWizard').getButton("finish")
    var buttonCancel = document.getElementById('eWizard').getButton("cancel")

    var osPlatform = eMusicPlatform.ident
    var thisTagList = document.getElementsByTagName("button");

    // workaround for linux button issue, button.css, tags buttons with osname
    for (var i = 0; i < thisTagList.length; i++) {
      thisTagList[i].setAttribute("platform", osPlatform);
    }

    buttonNext.setAttribute("platform", osPlatform);
    buttonNext.setAttribute("disabled", "false");
    buttonNext.setAttribute("label", "NEXT");

    buttonBack.setAttribute("platform", osPlatform);
    buttonBack.setAttribute("label", "BACK");
    buttonBack.setAttribute("collapsed", "true");

    buttonFinish.setAttribute("platform", osPlatform);
    buttonFinish.setAttribute("label", "FINISH");

    buttonCancel.setAttribute("platform", osPlatform);
    buttonCancel.setAttribute("label", "CANCEL");

    if (window.arguments && window.arguments[0]) {
      document.getElementById('eWizard').setAttribute("onwizardfinish", "")
      document.getElementById('eWizard').setAttribute("onwizardcancel", "")
    }

  },
  
  populateMediaManagers: function() {
    if (!eWizard.firstTime) {
      var branchService = Components.classes["@mozilla.org/preferences-service;1"]
                                   .getService(Components.interfaces.nsIPrefBranch);

      if (!branchService.prefHasUserValue("eMusic.defaultMediaSync")) {
        if (mediaManagers["WMP"] && mediaManagers["WMP"].init()) {
          nsPreferences.setUnicharPref("eMusic.defaultMediaSync", "WMP")
        }
        if (mediaManagers["Winamp"] && mediaManagers["Winamp"].init()) {
          nsPreferences.setUnicharPref("eMusic.defaultMediaSync", "Winamp")
        }
        if (mediaManagers["iTunes"] && mediaManagers["iTunes"].init()) {
          nsPreferences.setUnicharPref("eMusic.defaultMediaSync", "iTunes")
        }
        if (eMusicPlatform.ident == "Linux") {
          nsPreferences.setUnicharPref("eMusic.defaultMediaSync", "NoSync")
        }
      }
      prepMediaManagers(16);
      eWizard.firstTime = true;
    }
  },

  disableNext: function() {
    document.getElementById('eWizard').getButton("next").setAttribute("disabled", "true");
    document.getElementById('eWizard').getButton("back").setAttribute("collapsed", "false");
  },
  
  skipImport: function() {
    document.getElementById('eWizard').getButton("next").setAttribute("disabled", "false");
    document.getElementById('eWizard').advance();
  },

  skipFinishPage: function() {
    if (window.arguments && window.arguments[0]) {
      document.getElementById('eWizard').getPageById("player").removeAttribute("next");
      document.getElementById('eWizard').setAttribute("firstpage", "false");
      document.getElementById('eWizard').setAttribute("lastpage", "true");
    }
  },
  
  readDownloadDirPref: function () {
    /**
     * Initializes the download folder widget based on the folder as stored in
     * preferences.
     */
    document.getElementById('eWizard').getButton("back").setAttribute("collapsed", "false");

    var bundlePreferences = document.getElementById("bundlePreferences");
    var downloadFolder = document.getElementById("downloadFolder");

    var currentDirPref = prefs.getComplexValue("eMusic.download.dir", Components.interfaces.nsILocalFile)    

    var dirDesktop = this._getDownloadsFolder("Desktop");
    var dirDownloads = this._getDownloadsFolder("Downloads");

    var dirMyEmusic = dirDesktop.clone();
    dirMyEmusic.append("My eMusic")
    
    switch (currentDirPref.path) {
      case dirDesktop.path:
      case "":
        downloadFolder.value = bundlePreferences.getString("desktopFolderName");
        break;
      case dirMyEmusic.path:
        downloadFolder.value = "My eMusic";
        break;
      case dirDownloads.path:
        downloadFolder.value = bundlePreferences.getString("myDownloadsFolderName");
        break;
      default:
        downloadFolder.value = currentDirPref.path;
    }

    var ios = Components.classes["@mozilla.org/network/io-service;1"]
                        .getService(Components.interfaces.nsIIOService);
    if (currentDirPref.path != dirMyEmusic.path) {
      document.getElementById("downloadImage").src = dlm_base.getMozIcon(currentDirPref.path);
    }

    // don't override the preference's value in UI
    return undefined;
  },
  chooseFolder: function () {
    /**
     * Displays a file picker in which the user can choose the location where
     * downloads are automatically saved, updating preferences and UI in
     * response to the choice, if one is made.
     */
    const nsIFilePicker = Components.interfaces.nsIFilePicker;
    var fp = Components.classes["@mozilla.org/filepicker;1"]
                       .createInstance(nsIFilePicker);
    var bundlePreferences = document.getElementById("bundlePreferences");
    var title = bundlePreferences.getString("chooseDownloadFolderTitle");
    fp.init(window, title, nsIFilePicker.modeGetFolder);

    const nsILocalFile = Components.interfaces.nsILocalFile;
    var customDirPref = prefs.getComplexValue("eMusic.download.dir", Components.interfaces.nsILocalFile)    

    if (customDirPref.path)
      fp.displayDirectory = customDirPref;
    fp.appendFilters(nsIFilePicker.filterAll);
    if (fp.show() == nsIFilePicker.returnOK) {
      var file = fp.file.QueryInterface(nsILocalFile);
      var currentDirPref = document.getElementById("downloadFolder");
      prefs.setComplexValue("eMusic.download.dir", Components.interfaces.nsILocalFile, file);
      prefs.setComplexValue("eMusic.download.downloadDir", Components.interfaces.nsILocalFile, file);

      nsPreferences.setIntPref("eMusic.download.folderList", this._folderToIndex(file));

      this.readDownloadDirPref();
    }
  },

  _folderToIndex: function (aFolder) {
    /**
    * Determines the type of the given folder.
    *
    * @param   aFolder
    *          the folder whose type is to be determined
    * @returns integer
    *          0 if aFolder is the Desktop or is unspecified,
    *          1 if aFolder is the Downloads folder,
    *          2 otherwise
    */
    if (!aFolder || aFolder.equals(this._getDownloadsFolder("Desktop")))
      return 0;
    else if (aFolder.equals(this._getDownloadsFolder("Downloads")))
      return 1;
    return 2;
  },

  _getDownloadsFolder: function (aFolder) {
    /**
     * Returns the Downloads folder.  If aFolder is "Desktop", then the Downloads
     * folder returned is the desktop folder; otherwise, it is a folder whose name
     * indicates that it is a download folder and whose path is as determined by
     * the XPCOM directory service from aFolder.
     *
     * @throws if aFolder is not "Desktop" or "Downloads"
     */
    var fileLocator = Components.classes["@mozilla.org/file/directory_service;1"]
                                .getService(Components.interfaces.nsIProperties);
    var dir = fileLocator.get(this._getSpecialFolderKey(aFolder),
                              Components.interfaces.nsILocalFile);
    if (aFolder != "Desktop")
      dir.append("My Downloads"); // XXX l12y!

    return dir;
  },

  _getSpecialFolderKey: function (aFolderType) {
    /**
     * Gets the platform-specific key to be fed to the directory service for the
     * given special folder.
     *
     * @param   aFolder
     *          either of the strings "Desktop" or "Downloads"
     * @returns the platform-specific key for the location, which may be used with
     *          the XPCOM directory service
     */

    if (aFolderType == "Desktop")
      return "Desk";

    if (aFolderType == "Downloads") {
//@line 353 "/cygdrive/c/builds/tinderbox/Fx-Mozilla1.8-release/WINNT_5.2_Depend/mozilla/browser/components/preferences/main.js"
      switch (eMusicPlatform.ident) {
        case "WINNT":
          return "Pers"
          break;
        case "Linux":
          return "Home"
          break;
        default:
          return "UsrDocs"
       }
    }
//@line 361 "/cygdrive/c/builds/tinderbox/Fx-Mozilla1.8-release/WINNT_5.2_Depend/mozilla/browser/components/preferences/main.js"

      throw "ASSERTION FAILED: folder type should be 'Desktop' or 'Downloads'";
  }
}