#ifndef ENBD_IOCTL_H
#define ENBD_IOCTL_H 1

int enbd_ioctl_convert(int ioctl);
int enbd_ioctl_convert_inplace(int *ioctl);
int enbd_ioctl_revert(int ioctl);
int enbd_ioctl_size (int cmd, char *arg);
int enbd_ioctl_size_user (int cmd, char *arg);
#ifdef __KERNEL__
int enbd_ioctl_copy_to_user (int cmd, char *arg, char *buf, int size);
int enbd_ioctl_copy_from_user (int cmd, char *buf, char *arg, int size);

// PTB object containing all the above methods, to be registered with
// the enbd.o module
struct enbd_ioctl {
        int (*convert)        (int ioctl);
        int (*convert_inplace)(int *ioctl);
        int (*revert)         (int ioctl);
        int (*size)           (int cmd, char *arg);
        int (*size_user)      (int cmd, char *arg);
        int (*cp_to_user)     (int cmd, char *arg, char *buf, int size);
        int (*cp_from_user)   (int cmd, char *buf, char *arg, int size);
};

extern int enbd_register_remote_ioctl(struct enbd_ioctl *);
extern int enbd_unregister_remote_ioctl(struct enbd_ioctl *);
#endif

// PTB conversion table entries
struct ioctl_conv {
   unsigned int old; // ioctl id, _IO or _IOR or _IOW or _IOWR
   unsigned int new; // ioctl id
};

// PTB extended conversion table entries for special cases
struct ioctl_special {
    int new;
    int (*size) (char *arg);
    int (*size_user) (char *arg);
    int (*ioctl_copy_from_user)(char *buf, char*arg, int size);
    int (*ioctl_copy_to_user)(char *arg, char*buf, int size);
};


#endif
