--- linux-2.5.31/drivers/block/Config.in.pre-enbd	Wed Aug 21 19:06:26 2002
+++ linux-2.5.31/drivers/block/Config.in	Wed Aug 21 19:07:25 2002
@@ -38,6 +38,7 @@
 dep_mbool '       SCSI tape drive support for Smart Array 5xxx' CONFIG_CISS_SCSI_TAPE $CONFIG_BLK_CPQ_CISS_DA $CONFIG_SCSI
 dep_tristate 'Mylex DAC960/DAC1100 PCI RAID Controller support' CONFIG_BLK_DEV_DAC960 $CONFIG_PCI
 dep_tristate 'Micro Memory MM5415 Battery Backed RAM support (EXPERIMENTAL)' CONFIG_BLK_DEV_UMEM $CONFIG_PCI $CONFIG_EXPERIMENTAL
+dep_tristate 'Enhanced network block device support' CONFIG_BLK_DEV_ENBD $CONFIG_NET
 
 tristate 'Loopback device support' CONFIG_BLK_DEV_LOOP
 dep_tristate 'Network block device support' CONFIG_BLK_DEV_NBD $CONFIG_NET
--- linux-2.5.31/drivers/block/Config.help.pre-enbd	Wed Aug 21 19:07:58 2002
+++ linux-2.5.31/drivers/block/Config.help	Wed Aug 21 19:10:50 2002
@@ -134,6 +134,29 @@
 
   If unsure, say N.
 
+CONFIG_BLK_DEV_ENBD
+  Saying Y here will build in support for the "enhanced network 
+  block device".  Like the plain NBD, this device proxies a remote hard
+  disk or other block device, such as a cdrom or floppy.  The difference
+  between ENBD and NBD is that ENBD is a much more heavyweight solution
+  for an industrial setting - it does automatic reconnects after network
+  brownouts, and uses multiple channels at once to carry the data.  It
+  supports remote ioctls, removable devices, and uses an MD5 sampling
+  technique to accelerate softRAID resyncs.  It will connect through
+  (secure) SSL channels. It will hide transient errors from overlying
+  softRAID devices, etc.
+
+  You will need the userspace daemons, which packages are mirrored
+  on several places on the net. The primary source is 
+  ftp://oboe.it.uc3m.es/pub/Programs/nbd/nbd-2.4-current.tgz.
+
+  If you want to compile this driver as a module ( = code which can be
+  inserted in and removed from the running kernel whenever you want),
+  say M here and read <file:Documentation/modules.txt>. The module
+  will be called enbd.o.
+
+  If unsure, say N.
+
 CONFIG_BLK_DEV_XD
   Very old 8 bit hard disk controllers used in the IBM XT computer
   will be supported if you say Y here.
--- linux-2.5.31/drivers/block/Makefile.pre-enbd	Wed Aug 21 18:59:56 2002
+++ linux-2.5.31/drivers/block/Makefile	Wed Aug 21 19:00:23 2002
@@ -31,5 +31,6 @@
 
 obj-$(CONFIG_BLK_DEV_UMEM)	+= umem.o
 obj-$(CONFIG_BLK_DEV_NBD)	+= nbd.o
+obj-$(CONFIG_BLK_DEV_ENBD)	+= enbd.o
 
 include $(TOPDIR)/Rules.make
