/*
 * Network block device - make block devices work over TCP
 *
 * Note that you can not swap over this thing. Seems to work but
 * deadlocks sometimes - you can not swap over TCP in general.
 * 
 * Copyright 1997 Pavel Machek <pavel@elf.mj.gts.cz>
 * 
 * (part of code stolen from loop.c)
 *
 * 97-3-25 compiled 0-th version, not yet tested it 
 *   (it did not work, BTW) (later that day) HEY! it works!
 *   (bit later) hmm, not that much... 2:00am next day:
 *   yes, it works, but it gives something like 50kB/sec
 * 97-3-28 it's completely strange - when using 1024 byte "packets"
 *   it gives 50kB/sec and CPU idle; with 2048 bytes it gives
 *   500kB/sec (and CPU loaded 100% as it should be) (all done
 *   against localhost)
 * 97-4-1 complete rewrite to make it possible for many requests at 
 *   once to be processed
 * 97-4-1 23:57 rewrite once again to make it work :-(
 * 97-4-3 00:02 hmm, it does not work.
 * 97-4-3 23:06 hmm, it will need one more rewrite :-)
 * 97-4-10 It looks like it's working and stable. But I still do not
 *  have any recovery from lost connection...
 * (setq tab-width 4)
 * 97-4-11 Making protocol independent of endianity etc.
 * 97-4-15 Probably one more rewrite, since it loses requests under
 *  heavy loads
 * 97-9-13 Cosmetic changes
 *
 * possible FIXME: make set_sock / set_blksize / set_size / do_it one syscall
 * why not: would need verify_area and friends, would share yet another 
 *          structure with userland
 *
 * FIXME: not module-safe
 *
 * 98-12-18 modules now OK ptb@it.uc3m.es (Peter Breuer) ported to
 * 2.0.*. + better debugging. Still possible lockup in connection with APM
 * and spurious interrupt - only on write. Error treatment should
 * be improved. After 100 errors from end_request the kernel can
 * do anything. We should catch it ourselves.
 * 99-1-sometime fixed lockup by extending semaphore - ptb v1.0.
 * 99-3-sometime reconnect protocol (client mod agreed by pavel) - ptb v1.1
 * 99-4-25 add /proc/nbdinfo - ptb v1.1.1
 * 99-4-sometime add multiplex - ptb v1.2
 * 99-4-26 fix multiplex and redundancy - ptb v1.2.1
 * 99-4-29 reentrant client threads - ptb v1.2.2
 * 99-4-29 socket related stuff placed in user space - amarin v1.3.0
 * 99-5-3  fix all, all writes had to be before all reads - ptb v1.2.4
 * 99-5-5  fix out-of-order, async - ptb v1.2.5
 * 99-5-7  semaphores removed (still works!), fail cases corrected - ptb v1.2.6
 * 99-5-12 signals unblocked in xmit, blksize != 1024 fixed, ioctls
 *         added  - ptb v1.2.7
 * 99-6-1  interaction with client split into two functions - amarin v1.3.0
 * 99-6-3  reintegrated fully, mem manager fixed, accounting fixed  - ptb v1.2.8.3
 * 99-6-3  extra queue removed, mem manager removed  - ptb v1.2.8.4
 * 99-7-3  buffer registration introduced - ptb v1.2.8.5
 * 99-7-3  some client redundancy reestablished - ptb v2.1.1
 * 99-7-10 encapsulated queue calls. One element rollback buffer - ptb v2.1.2
 * 99-7-20 timestamp and rollback old abandoned request - ptb v2.1.3
 * 99-7-24 64bit file sizes and offsets accepted - ptb v2.1.9
 * 99-7-26 experimental request coalesces - ptb v2.1.10
 * 99-7-27 partitioning scheme - ptb v2.2.1
 * 99-8-3  nbd_clr_sock bug in invalidate_device fixed? - ptb v2.2.4
 * 99-8-5  reverse replace of block_fsync, add sig ioctls - ptb v2.2.5
 *         reverse bug introduced about v2.2.3 for compound reqs - ptb v2.2.5
 *         fix clear_que bug (didn't rollback first) from 2.1.3 - ptb v2.2.5
 * 99-8-22 workaround strange nr_sectors bug - ptb v2.2.6
 * 99-8-11 fix MY_NBD_SYNC bug. Never sync'ed all - ptb v2.2.7
 * 99-8-12 wakeups all moved to enqueue - ptb v2.2.7
 * 99-8-23 remove slot->cli_age - ptb v2.2.7
 *         reject timeout in my_nbd_get_req if queue nonempty - amarin v2.2.7
 * 99-8-24 first 8 bytes of signature embedded in packets - ptb v2.2.8
 *         fix SET_SIG define buglet, remove hardcoded constants - ptb v2.2.8
 *         fix huge bug. Missing copy_fromfs in my_nbd_ack - ptb v2.2.8     
 *         removed signature embedding and all other decorations - ptb v2.2.8
 * 99-8-25 recast fix in my_nbd_ack to avoid align. bug - ptb v2.2.9
 *         put in MKDEVs and put back some hardcode const fixes - ptb v2.2.10
 * 99-9-29 fix BLKGETSIZE bug - ptb v2.2.14
 * 99-10-2 run with interrupts on throughout. Think we lose some - ptb v2.2.15
 * 99-10-8 trim dead code, kernel 2.2 ifdef's - ptb v2.2.17
 * 99-12-18 further o-o - ptb v2.2.19
 */

static int paranoia = 1;
#define PARANOIA_BEGIN if(paranoia){
#define PARANOIA_END   }


#include <linux/major.h>

#include <linux/module.h>

#if defined(__GNUC__) && __GNUC__ >= 2
#define _LOOSE_KERNEL_NAMES
#endif

#include <linux/version.h>
#ifndef KERNEL_VERSION
#define KERNEL_VERSION(a,b,c)  (((a) << 16) + ((b) << 8) + (c))
#endif
#define LINUX_VERSION_2_2_0 KERNEL_VERSION(2,2,0)
#define LINUX_VERSION_2_1_0 KERNEL_VERSION(2,1,0)


#include <linux/fs.h>
#include <linux/stat.h>
#include <linux/errno.h>

#include <asm/segment.h>
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
#include <asm/uaccess.h>          /* PTB - when did this arrive in kernel? */
#endif
#include <asm/byteorder.h>
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
#include <linux/wrapper.h>
#endif

#define MAJOR_NR NBD_MAJOR
#include <linux/proc_fs.h>
#include <linux/genhd.h>
#include <linux/hdreg.h>
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
#include <linux/file.h>           /* PTB - when did this arrive in kernel? */
#endif
#include <linux/nbd.h>

/* PTB kernel data - 4KB worth */
static int nbd_blksizes [MAX_NBD * NBD_MAXCONN]; /* {1024, 1024,}; */
static int nbd_sizes    [MAX_NBD * NBD_MAXCONN]; /* {0x7fffffff, 0x7fffffff,};*/
static u64 nbd_bytesizes[MAX_NBD * NBD_MAXCONN]; /* all in init now PTB 132 */

/* PTB our data   - about 3KB */
static struct nbd_device nbd_dev[MAX_NBD];

#if 0
/* PTB device partitioning support */
struct hd_struct nbd_partitions[MAX_NBD * NBD_MAXCONN];

struct gendisk nbd_gendisk = {
   MAJOR_NR,
   "nd",
   NBD_SHIFT,              /* 4 */
   NBD_MAXCONN,            /* 16 = 1 << NBD_SHIFT */
   MAX_NBD,                /* 16 */
   NULL,                   /* init fn */
   nbd_partitions,         /* partition array */
   nbd_blksizes,           /* block sizes */
   0,
   NULL,                   /* unused */
   NULL,                   /* link to next */
};
#endif


#ifndef DEBUG
#define NDEBUG 0
#else
#define NDEBUG DEBUG
#endif

#define NBD_DEBUG(level, s...) \
 if((NDEBUG)>=(level)){ printk( KERN_DEBUG "NBD: " s );}

#define NBD_ERROR( s...) printk( KERN_ERR   "NBD: " s )
#define NBD_ALERT( s...) printk( KERN_ALERT "NBD: " s )
#define NBD_INFO( s...)  printk( KERN_INFO  "NBD: " s )

#define NBD_FAIL( s ) { \
  NBD_DEBUG(1, s "(result %d).\n" , result ); \
  goto error_out; \
}
#define NBD_HARDFAIL( s ) { \
  NBD_ERROR( s "(result %d).\n" , result ); \
  lo->harderror = result; \
  goto hard_error_out; \
}


# if  1 || defined(__SMP__)
#define NBD_SEMAPHORE_UP(s) \
            { \
                up (s);  \
	        NBD_DEBUG(2,"released (queue) semaphore %lx\n", (unsigned long)(s)); \
            }
#define NBD_SEMAPHORE_DOWN(s) \
            { \
	        NBD_DEBUG(2,"wait on (queue) semaphore %lx\n" , (unsigned long)(s)); \
                down (s); \
	        NBD_DEBUG(2,"acquired (queue) semaphore %lx\n", (unsigned long)(s)); \
            }
#else
#define NBD_SEMAPHORE_UP(s)
#define NBD_SEMAPHORE_DOWN(s)
#endif


static int rahead     = NBD_RAHEAD;      /* PTB - read ahead blocks  */
static int sync_intvl = NBD_SYNC_INTVL;  /* PTB - client inactivity timeout */
static int merge_requests                /* PTB - bool, do request coalesce */
                      = NBD_MERGE_REQUESTS;
static int buf_sectors
                      = NBD_MAX_SECTORS; /* PTB - user bufsize required */

#if defined(MODULE) && LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
 MODULE_PARM(rahead,"i");
 MODULE_PARM(sync_intvl,"i");
 MODULE_PARM(merge_requests,"i");
 MODULE_PARM(buf_sectors,"i");
#endif

#define prev sem /* PTB - a coarse hack */

/*
 * PTB count number of blocks in a request. This will be an overestimate
 * if the number is not an exact multiple. It seems to happen. We must
 * guarrantee to return 0 only if the request is invalid as we use this
 * test elsewhere.
 */
inline unsigned long
nr_blks(struct nbd_device *lo, struct request * req) {

    if (!req) {
      return 0;
    } else {

      unsigned log_sectors_per_blk = lo->logblksize - 9;
      unsigned sectors_per_blk = 1 << log_sectors_per_blk;

      return (req->nr_sectors  + sectors_per_blk - 1) >> log_sectors_per_blk;
    }

}

/*
 * PTB - put a request onto the head of the nbd device general queue
 */
static void
nbd_enqueue (struct nbd_device *lo, struct request *req)
{
    unsigned long req_blks = nr_blks(lo,req);

    if (req_blks <= 0)
	return;

PARANOIA_BEGIN;
    if (1) {
      struct buffer_head *bh = req->bh;
      if (! test_bit(BH_Lock, &bh->b_state)) {
          NBD_ALERT("buffer head found unlocked in nbd_enqueue!");
      }
    }
PARANOIA_END;

    req->next = NULL;
    (struct request *) req->prev = lo->head;

    if (lo->head == NULL) {
	lo->tail = lo->head = req;
    } else {
	lo->head->next = req;
	lo->head = req;
    }

    wake_up_interruptible(& lo->wq);

    /* PTB accounting */
    lo->requests_in += req_blks;
    lo->count++;
    if (lo->maxq < lo->count)
	lo->maxq = lo->count;

}

#if 0
/*
 * PTB - pop a request off the tail of the nbd device general queue
 */
static struct request *
nbd_dequeue (struct nbd_device *lo)
{
    struct request *req = lo->tail;

    if (!req)
	return NULL;

    lo->count--;		/* PTB accounting */

    if (lo->head == req)
	lo->head = lo->tail = NULL;
    else {
	lo->tail = req->next;
	if (lo->tail)
	    lo->tail->prev = NULL;
    }
    return req;
}
#endif

/*
 * PTB - remove a request from anywhere in the nbd device general queue 
 *     - return 0 for success, -ve for fail
 */
static int
nbd_remove (struct nbd_device *lo, struct request *req)
{
    if (!req)
	return -2;

    if (req == lo->tail) {	/* PTB standard case - req is the oldest */
	if (lo->head == req)
	    lo->head = lo->tail = NULL;
	else {
	    lo->tail = req->next;
	    if (lo->tail)
		lo->tail->prev = NULL;
	}
	goto success;
    }

    if (req == lo->head) {	/* PTB find the predecessor (head - 1) */
	struct request *xreq;

	xreq = (struct request *) req->prev;
	lo->head = xreq;
	xreq->next = NULL;
	goto success;
    }
    if (1) {			/* PTB - middle of queue case */
	struct request *xreq;

	xreq = (struct request *) req->prev;
	xreq->next = req->next;
	if (req->next)
	    req->next->prev = req->prev;
	goto success;
    }
    goto failure;

  failure:
    NBD_ALERT ("nbd_remove: unexpected handle.\n");
    /* PTB - if we get here we have an unexpected handle and we ignore it 
     *     - do accounts on return as don't know what to do within here */
    return -1;

  success:
    req->next = NULL;		/* PTB */
    lo->count--;		/* PTB accounting */
    return 0;
}

/*
 *  PTB - Open the device
 */
int
nbd_open (struct inode *inode, struct file *file)
{
    int dev = -1;
    struct nbd_device *lo = 0;
    int nbd = -1;

    NBD_DEBUG (3, "nbd_open: entered\n");

    if (1 && !inode && file) {	/* added by ptb for 2.0.35. Necessary? */
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
	inode = file->f_dentry->d_inode;
#else
	inode = file->f_inode;
#endif
    }
    if (!inode) {
	NBD_ERROR ("nbd_open - null inode.\n");
	NBD_DEBUG (3, "nbd_open: exited INVAL\n");
	return -EINVAL;
    }

    dev = MINOR (inode->i_rdev);
    nbd = dev >> NBD_SHIFT;

    NBD_DEBUG (3, "nbd_open: have inode %x for dev %c%d\n",
       (unsigned) inode, 'a' + nbd, dev);

    if (nbd >= MAX_NBD ) {
	NBD_ERROR ("nbd_open - too many (%d) whole devices open\n", nbd);
	NBD_DEBUG (3, "nbd_open: exited NODEV\n");
	return -ENODEV;
    }

    NBD_DEBUG (3, "nbd_open: have device %c%d\n", 'a' + nbd, dev);

    lo = &nbd_dev[nbd];

    NBD_DEBUG (3, "nbd_open: whole device %c has reference count %d\n",
       'a' + nbd, lo->refcnt);
 
    if (dev % NBD_MAXCONN == 0) {
      /* PTB we have got the whole dev's file or inode for 1st time */
      if (!lo->file || lo->file != file)  {
        NBD_DEBUG (3, "nbd_open: set file %x for whole device %c\n",
            (unsigned)file, 'a' + nbd );
         lo->file = file;
      }
      if (!lo->inode || lo->inode != inode) {
         NBD_DEBUG (3, "nbd_open: set inode %x for whole device %c\n",
            (unsigned)inode, 'a' + nbd );
         lo->inode = inode;
      }
    }

#if 0
    /* PTB possible sync before first opens */
    if (lo->refcnt <= lo->aslot|| ! MOD_IN_USE) {
       invalidate_buffers (inode->i_rdev);
       if (lo->inode)
         invalidate_buffers (lo->inode->i_rdev);
       else
         invalidate_buffers (MKDEV(NBD_MAJOR, nbd<<NBD_SHIFT));
       NBD_DEBUG (2, "nbd_open: invalidated buffers\n");
       fsync_dev (inode->i_rdev);
       if (lo->inode)
         fsync_dev (lo->inode->i_rdev);
       else
         fsync_dev (MKDEV(NBD_MAJOR, nbd<<NBD_SHIFT));
       NBD_DEBUG (2, "nbd_open: synced whole device %c\n", 'a' + nbd);
    }                                       
#endif

    lo->refcnt++;

    NBD_DEBUG (3, "nbd_open: increment device %c reference count to %d\n",
         'a' + nbd, lo->refcnt);
    MOD_INC_USE_COUNT;

    if (!(lo->flags & NBD_INITIALISED)) {	/* PTB 132 */
	lo->queue_lock = MUTEX;
	lo->flags |= NBD_INITIALISED;
    }

    NBD_DEBUG (3, "nbd_open: exited OK\n");
    return 0;
}


/*
 * PTB - complete a transaction irrefutably by taking it out of the
 *     - slot pending position it is in, and reporting end_request to kernel
 */
void
nbd_commit (struct nbd_slot *slot, struct request * req)
{

    struct nbd_device *lo = slot->lo;
    unsigned long req_blks = nr_blks(lo,req);

    if (req_blks <= 0)
	return;

    if (slot->req == req)
      slot->req = req->next;   /* PTB was head */
    else {
      ((struct request *)req->prev)->next = req->next;
    }
    if (req->next)
      req->next->prev = req->prev;

    nbd_end_request (req);

    lo->requests_req -= req_blks;

    slot->req_age = 0;
    slot->out += req_blks;
    lo->requests_out += req_blks;
}

/*
 * PTB - undo transactions by taking them out of the slot pending
 *     - position and replacing them on the generic device queue
 */
void
nbd_rollback (struct nbd_slot *slot)
{

    struct nbd_device *lo = slot->lo;
    struct request *req = slot->req;

    while (req = slot->req, req) {
      unsigned long req_blks = nr_blks(lo,req);

      slot->req = req->next;
      if (req->next)
        req->next->prev = NULL;
      req->next = NULL;
      req->prev = NULL;

      NBD_ALERT("nbd_rollback: rollback req %x from slot %d!\n"
		   ,(unsigned) req, slot->i);

      /* PTB accounting */
      lo->requests_req -= req_blks;
      slot->in -= req_blks;
      lo->requests_in -= req_blks; /* PTB - pre-decrement count for enqueue */
      nbd_enqueue (lo, req);
    }

}

/*
 * PTB - let a request onto the slot pending position
 */
void
nbd_accept(struct nbd_slot * slot, struct request * req) {

        struct nbd_device *lo = slot->lo;
        unsigned long req_blks = nr_blks(lo,req);

        if (req_blks <= 0)
            return;

        lo->requests_req += req_blks;
        req->next = slot->req; /* PTB prepare to enqueue more than one */
        slot->req = req;       /* PTB current request */
	if (req->next)         /* PTB doubly link */
	    (struct request *) req->next->prev = req;
	(struct request *) req->prev = NULL;
        slot->req_age = jiffies;
        slot->in += req_blks;
}

/*
 * PTB - andres' kernel half of the user-space network handshake, used
 *     - to complete a transaction.
 *     - return 0 for success and -ve for fail.
 */
int
my_nbd_ack (struct nbd_slot *slot)
{
    struct nbd_reply reply;
    struct request *req, *xreq;
    int result = 0;
    
    void *user;
    unsigned long req_blks = 1;
    struct nbd_device *lo = slot->lo;
    int islot = slot->i;

    NBD_DEBUG (1, "my_nbd_ack (%d): entered\n", islot);
    lo->cthreads++;
    slot = &lo->slots[islot];
    slot->flags |= NBD_SLOT_RUNNING;

    user = slot->buffer + slot->buflen;

#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
    copy_from_user ((char *) &reply, (char *) user, sizeof (struct nbd_reply));
#else
    memcpy_fromfs ((char *) &reply, (char *) user, sizeof (struct nbd_reply));
#endif
    slot->buflen += sizeof (struct nbd_reply);

    memcpy ((char *) &req, reply.handle, sizeof (req));

    for (xreq = slot->req; xreq; xreq = xreq->next) {
      if (xreq == req)
        break;
    }
    if (!xreq) {
	NBD_ALERT ("my_nbd_ack: fatal: Bad handle %x !\n"
		   ,(unsigned) req);
	NBD_FAIL ("my_nbd_ack: exited wrong request\n");
    }

    NBD_DEBUG (3, "my_nbd_ack (%d): ok, got handle %x\n", islot,
	       (unsigned) req);

    if (reply.magic != NBD_REPLY_MAGIC) {
	NBD_ALERT ("Not enough magic in my_nbd_ack\n");
	NBD_FAIL ("Not enough magic in my_nbd_ack\n");
    }

    if (reply.error) {
	/* PTB wasn't error++'ed before */
	NBD_FAIL ("my_nbd_ack: exited with reply error\n");
    }

    PARANOIA_BEGIN
     if (lo->magic != NBD_DEV_MAGIC) {
	NBD_ALERT ("nbd_dev[] corrupted: Not enough magic in my_nbd_ack\n");
	NBD_DEBUG (1, "my_nbd_ack (%d): exited bad magic\n", islot);
	NBD_FAIL ("my_nbd_ack: exited bad magic\n");
    }
    PARANOIA_END

    switch (req->cmd & 0x03) {
      unsigned len;
      char * src;
 
      case READ:
          len = req->current_nr_sectors << 9;
          src = ((char *) user) + sizeof(struct nbd_reply);
          slot->buflen += len;
          NBD_DEBUG (3, "my_nbd_ack: read %d bytes data from %x to %x\n",
                     len, (unsigned) src, (unsigned) req->buffer);
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
          copy_from_user (req->buffer, src, len);
#else
          memcpy_fromfs (req->buffer, src, len);
#endif
    }

    /* PTB - completion of transaction */
     nbd_commit (slot, req);

    slot->buflen = 0;
    lo->cthreads--;
    slot->flags &= ~NBD_SLOT_RUNNING;
    NBD_DEBUG (1, "my_nbd_ack (%d): exited OK\n", islot);
    return 0;

  error_out:			/* PTB we will do a client rollback */
    result = result < 0 ? result : -ENODEV;
    req_blks = nr_blks(lo,req);
    req->errors += req_blks;
    slot->err += req_blks;
    slot->buflen = 0;
    lo->cthreads--;
    slot->flags &= ~NBD_SLOT_RUNNING;
    NBD_DEBUG (1, "my_nbd_ack (%d): exited FAIL\n", islot);
    return result;
}


/*
 * PTB - apply repeatedly to tail of queue to try and merge successive requests
 *     - returns 1 for success and 0 for fail
 */
static inline int 
attempt_merge (struct nbd_device *lo, struct request *req)
{
    struct request *next = 0;

    if (!req) {
	NBD_DEBUG (2, "attempt_merge: no request\n");
	return 0;
    }
    next = req->next;
    if (!next) {
	NBD_DEBUG (2, "attempt_merge: no next request\n");
	return 0;
    }
    if (req->sector + req->nr_sectors != next->sector) {
	NBD_DEBUG (2, "attempt_merge: sectors not adjacent\n");
	return 0;
    }
    if (req->cmd != next->cmd) {
	NBD_DEBUG (2, "attempt_merge: request types differ\n");
	return 0;
    }
    if (req->rq_dev != next->rq_dev) {
	NBD_DEBUG (2, "attempt_merge: request devices differ\n");
	return 0;
    }
    if (req->nr_sectors + next->nr_sectors >= buf_sectors) {
	NBD_DEBUG (2, "attempt_merge: buffer would be too big\n");
	return 0;
    }
#if 0
    if (req->buffer + (req->nr_sectors << 9) != next->buffer) {
	NBD_DEBUG (2, "attempt_merge: buffers %x %x not contiguous\n",
		 (unsigned long) req->buffer, (unsigned long) next->buffer);
	return 0;
    }
#endif

#if 0
    lo = &nbd_dev[MINOR (req->rq_dev) >> NBD_SHIFT];		/* PTB do this instead? */ 
#endif
#if 0
    NBD_DEBUG (1, "attempt_merge: merge %ld, %ld + %ld == %ld\n",
	       req->sector, req->nr_sectors, next->nr_sectors,
	       req->nr_sectors + next->nr_sectors);
#endif
    if (merge_requests) {
	NBD_DEBUG (1, "attempt_merge: will merge request\n");
	req->bhtail->b_reqnext = next->bh;
	req->bhtail = next->bhtail;
	req->nr_sectors += next->nr_sectors;
	next->rq_status = RQ_INACTIVE;          /* PTB FIXME!? */
	req->next = next->next;
	if (req->next)
	    (struct request *) req->next->prev = req;
	if (lo->head == next)
	    lo->head = req;
	lo->count--;
	return 1;
    }
    else {
	NBD_DEBUG (1, "attempt_merge: would merge request\n");
	return 0;
    }
}


/*
 * PTB - andres' kernel half of the userspace networking. This part
 *     - initiates the transaction by taking a request off the generic
 *     - device queue and placing it in the slots pending position.
 *     - I believe we return 0 for success and -ve for fail.
 */
int 
my_nbd_get_req (struct nbd_slot *slot)
{
    struct nbd_request request;
    struct request *req;
    /* unsigned long flags; */ /* PTB - in case we use cli/sti */
    int result = 0;
    static int count;
    unsigned start_time = jiffies;
    const unsigned timeout = sync_intvl * HZ;
    void *user;
    struct nbd_device *lo = slot->lo;
    int islot = slot->i;

    NBD_DEBUG (1, "my_nbd_get_req (%d): entered\n", islot);
    lo->cthreads++;		/* PTB - client thread enters */
    slot = &lo->slots[islot];
    slot->flags |= NBD_SLOT_RUNNING;
    user = slot->buffer + slot->buflen;
    lo->islot = islot;

    req = slot->req;

    if (req) {
	NBD_FAIL ("my_nbd_get_req: already treating one request\n");
	/* PTB we do a nontrivial rollback from the user daemon */
    }

    /* PTB - now spin until request */

    while (!lo->tail && slot->file) {

	NBD_DEBUG (3, "my_nbd_get_req (%d): going to sleep %d\n", islot, count);
	lo->cwaiters++;
        slot->flags |= NBD_SLOT_WAITING;

#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
	interruptible_sleep_on_timeout (&lo->wq, start_time + timeout - jiffies);
#else
	current->timeout = start_time + timeout;
	interruptible_sleep_on (&lo->wq);
	current->timeout = 0;
#endif
	NBD_DEBUG (3, "my_nbd_get_req (%d): I wake up %d\n", islot, count);

        slot->flags &= ~NBD_SLOT_WAITING;
	lo->cwaiters--;
	count++;

	/* PTB fail for recheck if we're inactive too long */

	if (jiffies >= start_time + timeout && !lo->tail) {
	    NBD_DEBUG (1, "my_nbd_get_req (%d): I timeout in the %dth cycle %ld jiffies late\n",
	           islot, count, jiffies - (start_time + timeout));
	    result = -ETIME;
	    NBD_FAIL ("my_nbd_get_req: ho hum nothing to do\n");
	    /* PTB we may do a trivial rollback from the user daemon */
	}

    }

    lo->cwaiters++;
    slot->flags |= NBD_SLOT_WAITING;
    NBD_SEMAPHORE_DOWN (&lo->queue_lock);
    lo->cwaiters--;
    slot->flags &= ~NBD_SLOT_WAITING;

    if (!lo->tail) {
	NBD_SEMAPHORE_UP (&lo->queue_lock);
	/* PTB - somebody else did it while we waited on semaphore. OK */
	result = -EINVAL;
	NBD_FAIL ("my_nbd_get_req: ho hum beaten to the punch\n");
	/* PTB we may do a trivial rollback from the user daemon */
    }

    req = slot->req;
    if (req) {
	NBD_SEMAPHORE_UP (&lo->queue_lock);
	result = -EINVAL;
	NBD_FAIL ("my_nbd_get_req: already treating one request\n");
	/* PTB we do a nontrivial rollback from the user daemon */
    }

    /* PTB cli/sti here looks unnec. hardware interrupts return here */
    /* AMARIN begin uninterruptable code */

    req = lo->tail;		/* PTB oldest=last element in queue */

    if (merge_requests) {
	/* PTB coalesce queue requests */
	unsigned long size = req->nr_sectors << 9;
	NBD_DEBUG (1, "my_nbd_get_req (%d): req=0x%lx has size %lu\n",
		   islot, (unsigned long) req, size);


	while (attempt_merge (lo, req) > 0) ;
	size = req->nr_sectors << 9;
	NBD_DEBUG (1, "my_nbd_get_req (%d): req=0x%lx has size %lu\n",
		   islot, (unsigned long) req, size);
    }
                              /* PTB - must succeed as have the semaphore */
    result = nbd_remove (lo, req);

    NBD_DEBUG (2, "my_nbd_get_req (%d):"
               " despatching request 0x%lx position 0x%lx in queue\n",
	       islot, (unsigned long) req, (unsigned long) lo->tail);

    /* AMARIN end uninterruptable code */
    /* PTB uh - maybe cli/sti is needed? interrupts can muck the queue?
     *        - Nah! I've left them enabled so we can see any errors.
     */

    NBD_SEMAPHORE_UP (&lo->queue_lock);

    request.magic = NBD_REQUEST_MAGIC;
    request.type = req->cmd;
    request.from = req->sector << 9;
    request.len = req->nr_sectors << 9;
    request.flags = 0;

    memcpy (request.handle, (char *) &req, sizeof (req));

    NBD_DEBUG (2, "my_nbd_get_req (%d):"
	       "magic=0x%x, type=%d, from=0x%x, len=%u, handle=0x%x\n",
	       islot,
	       (unsigned) request.magic,
	       (unsigned) request.type,
	       (unsigned) request.from,
	       (unsigned) request.len,
	       (unsigned) *(char **) request.handle);

PARANOIA_BEGIN;
    /* PTB do not assume buffer OK, although verified by REG_BUF
     *     I half believe that we could write to a dead processes
     *     buffer?
     */

    if (result = verify_area(VERIFY_WRITE, user, sizeof(struct nbd_request)),
          result){
        NBD_DEBUG(3, "my_nbd_get_req (%d): exited with %d\n" , islot, result );
	result = -EINVAL;
	NBD_FAIL ("my_nbd_get_req: invalid user buffer\n");
	/* PTB we do a nontrivial rollback from the user daemon, if alive */
    }
    NBD_DEBUG (3, "my_nbd_get_req (%d): verified user buf 0x%x\n",
            islot, (unsigned)user)
PARANOIA_END;

#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
    copy_to_user (user, (char *) &request, sizeof (struct nbd_request));
#else
    memcpy_tofs (user, (char *) &request, sizeof (struct nbd_request));
#endif

    slot->buflen += sizeof (struct nbd_request);

    if ((request.type & 0x03) == WRITE) {

	unsigned size = 0;
	unsigned current_size = req->current_nr_sectors << 9;
	char  *buffer = req->buffer;
	struct buffer_head *bh = req->bh;

	/* PTB assume user verified */

	while (size < request.len) {
	    struct buffer_head *next = bh->b_reqnext;
            unsigned long offset = sizeof (struct nbd_request) + size;

            NBD_DEBUG (3, "my_nbd_get_req (%d): write %d to user at 0x%x\n"
                , islot, current_size, (unsigned)(((char*)user) + offset));

#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
	    copy_to_user (((char *)user) + offset, buffer, current_size);
#else
	    memcpy_tofs (((char *)user) + offset, buffer, current_size);
#endif

	    size += current_size;
	    slot->buflen += current_size;

            /* PTB - arrgh. Subtle bug. If this request is partially
             * handled by the daemon which dies, we mark its buffers
             * up to date now and then roll it back later, to be handled
             * again. The second time nasty things happen. Don't.
             */

            //bh->b_reqnext = 0;          // PTB don't add !
            //mark_buffer_uptodate(bh,1); // PTB don't add !
            //unlock_buffer(bh);          // PTB don't add !

	    bh = next;
	    if (!bh)
		break;

	    NBD_DEBUG (1, "my_nbd_get_req (%d):"
	    " bh has buffer 0x%lx len=%lu in req with buffer 0x%lx len=%lu\n",
		       islot,
                       (unsigned long) bh->b_data, bh->b_size,
                       (unsigned long) req->buffer, req->nr_sectors << 9);
	    buffer = bh->b_data;
	    current_size = bh->b_size;

	}
        //req->bh = 0;                   // PTB don't add !
    }

    /* PTB anyone know what this does? It seems to be unnecessary */
    /* memcpy_fromfs((char *) &request, user, sizeof(struct * nbd_reply)); */

    nbd_accept (slot, req);

    slot->buflen = 0;
    lo->cthreads--;		/* PTB - client thread leaves normally */
    slot->flags &= ~NBD_SLOT_RUNNING;
    NBD_DEBUG (1, "my_nbd_get_req: exiting\n");

    return 0;

  error_out:
    slot->buflen = 0;
    /* PTB accounting - a fail to get a request is not an errored request */
    lo->cthreads--;		/* PTB - client thread leaves abnormally */
    slot->flags &= ~NBD_SLOT_RUNNING;
    result = result < 0 ? result : -ENODEV;
    NBD_DEBUG (1, "my_nbd_get_req (%d): error exit %d\n", islot, result);
    return result;
}

void
nbd_clr_queue (struct nbd_device *lo)
{
    struct request *req;

    NBD_DEBUG (1, "nbd_clr_queue: entered\n");

    while (1) {

	int invalid = 0;
        unsigned long req_blks = 1;

	NBD_SEMAPHORE_DOWN (&lo->queue_lock);

	req = lo->tail;
	if (!req) {
	    NBD_DEBUG (1, "nbd_clr_queue: exited req=0\n");
	    NBD_SEMAPHORE_UP (&lo->queue_lock);
	    return;
	}
        req_blks = nr_blks(lo,req);

	PARANOIA_BEGIN;
	if (lo != &nbd_dev[MINOR (req->rq_dev)]) {
	    NBD_ALERT ("request corrupted when clearing!\n");
	    invalid = 1;
	}
	if (lo->magic != NBD_DEV_MAGIC) {
	    NBD_ERROR ("nbd_dev[] corrupted: Not enough magic when clearing!\n");
	    NBD_DEBUG (3, "nbd_clr_queue: exited bad magic\n");
	    return;
	}
	PARANOIA_END;

	req->errors += req_blks;
	lo->requests_err += req_blks;

	if (!invalid) {
	    struct request *xreq;
	    xreq = CURRENT;
	    nbd_end_request (req);
	    if (xreq != req)
		CURRENT = xreq;
	}

        nbd_remove(lo,req);

	NBD_SEMAPHORE_UP (&lo->queue_lock);
    }

}

/*
 * We always wait for result of write, for now. It would be nice to make it optional
 * in future
 * if ((req->cmd & 0x03 == WRITE) && (lo->flags & NBD_WRITE_NOCHK)) 
 *   { printk( "Warning: Ignoring result!\n"); nbd_end_request( req ); }
 */

#undef NBD_FAIL
#define NBD_FAIL( s ) { \
  NBD_ERROR( "minor %d: " s "\n" , dev ); \
  goto error_out; \
}

static void
do_nbd_request (void)
{
    struct request *req;
    int dev;
    struct nbd_device *lo = 0;
    unsigned long flags;
    int nbd;

    NBD_DEBUG(1, "do_nbd_request: entered\n" );

    INIT_REQUEST;		/* PTB */

    while(CURRENT) {

        unsigned size = 0;
        unsigned long req_blks = 1;

        /* INIT_REQUEST; */    /* PTB */

	req = CURRENT;
        size = req->nr_sectors << 9;
	NBD_DEBUG (1, "do_nbd_request: req=%lx has size %u\n",
                       (unsigned long)req, size);

	dev = MINOR (req->rq_dev);
        nbd = dev >> NBD_SHIFT;

        NBD_DEBUG(1, "do_nbd_request: request on minor %d\n" , dev) ; 
	lo = &nbd_dev[nbd];

	lo->kthreads++;		/* PTB - one kernel thread enters */
	NBD_DEBUG (3, "do_nbd_request: DEBUG 9\n");

	CURRENT= CURRENT->next; /* PTB put me here (don't block before change!) */

	if (nbd >= MAX_NBD ){
	   NBD_FAIL ("Minor too big in do_nbd_request.");
	}
	if (((req->cmd & 0x03) == WRITE) && (lo->flags & NBD_READ_ONLY)){
	   NBD_FAIL ("Write on read-only in do_nbd_request");
	}
PARANOIA_BEGIN
	if (lo->magic != NBD_DEV_MAGIC){
	   NBD_FAIL ("nbd[] is not magical in do_nbd_request!"); 
	}
PARANOIA_END;

	req->errors = 0;

	lo->kwaiters++;
	NBD_SEMAPHORE_DOWN (&lo->queue_lock);
	lo->kwaiters--;

        /* PTB cli/sti here looks unnec. hardware interrupts return here */
	/* AMARIN begin uninterruptable code */
	save_flags (flags); cli();        

        nbd_enqueue(lo,req);

        /* PTB maybe some requests coalesced ? */

        CURRENT = req->next;

        sti(); restore_flags(flags);
	/* AMARIN end uninterruptable code */
        /* PTB change of CURRENT above was all I'm worried about.  */

	NBD_SEMAPHORE_UP (&lo->queue_lock); /**/
	
        lo->kthreads--;		/* PTB one kernel thread leaves normally */

        NBD_DEBUG (3, "do_nbd_request: DEBUG 5\n");
        continue;

        error_out:
        NBD_DEBUG (3, "do_nbd_request: DEBUG 6\n");
        req_blks = nr_blks(lo,req);
        req->errors  += req_blks;
        lo->requests_err += req_blks;

        lo->kthreads--;		/* PTB one kernel thread leaves abnormally */
        NBD_DEBUG (3, "do_nbd_request: DEBUG 7\n");
        return;                 /* or continue? PTB */
    }
    NBD_DEBUG(1, "do_nbd_request: exiting\n") ; 
    return;
}

static int
nbd_clr_req(struct nbd_slot * slot) {
    struct nbd_device *lo;

    NBD_DEBUG (3, "nbd_clr_req: entered\n");

    lo = slot->lo;

    NBD_SEMAPHORE_DOWN (&lo->queue_lock);		/* PTB */
    nbd_rollback(slot);
    NBD_SEMAPHORE_UP (&lo->queue_lock);		/* PTB */
    NBD_DEBUG (3, "nbd_clr_req: exited OK\n");
    return 0;

}

static int
   /* introduced by PTB for better modularity */
nbd_clr_sock (struct nbd_slot * slot)
   /* PTB arg introduced for multiplexing */
   /* PTB the nbd arg if -ve, means don't invalidate buffers also */
{
    int i = 0;
    struct nbd_device *lo = slot->lo;
    int islot = slot->i;

    NBD_DEBUG (3, "nbd_clr_sock: entered with arg %d\n", islot);

    NBD_SEMAPHORE_DOWN (&lo->queue_lock);	/* PTB */

    nbd_rollback(slot);

    if (slot->file) {
	slot->file->f_count--;
	slot->file = NULL;
	slot->sock = NULL;
    }

    /* PTB reset lo->aslot */

    if (lo->aslot > 0) {
	/* PTB grr .. do this the hard way since I don't seem to count right */
	lo->aslot = 0;
	for (i = 0; i < lo->nslot; i++) {
            struct nbd_slot * sloti = & lo->slots[i];
	    if (sloti->file)
		lo->aslot++;
	}
	NBD_DEBUG (3, "nbd_clr_sock: decremented active socket count to %d\n",
                lo->aslot);
    }

    /* PTB reset lo->islot */

    if (lo->islot == islot) {
	for (i = 0; i++ < lo->nslot;) {
	    lo->islot++;
	    if (lo->islot >= lo->nslot)
		lo->islot = 0;
	    if (lo->slots[lo->islot].file)
		break;
	}
	NBD_DEBUG (3, "nbd_clr_sock: reset current socket slot to %d\n",
                lo->islot);
    }

    slot->lock = MUTEX; /* READER (lie) to let writes proceed */

    NBD_DEBUG (3, "nbd_clr_sock: reset semaphore %lx\n",
            (unsigned long) & slot->lock);

    lo->harderror = 0;
    NBD_DEBUG (3, "nbd_clr_sock: reset error to 0\n");

    NBD_SEMAPHORE_UP (&lo->queue_lock);		/* PTB */
	
    /* PTB don't clear device queue as we might still be open */

    NBD_DEBUG (3, "nbd_clr_sock: exited OK\n");
    return 0;
}

/*
 * PTB - check slots for old requests and roll them back. 
 */
static void
nbd_rollback_old(struct nbd_slot *slot){

    int islot = slot->i;
    struct nbd_device * lo = slot->lo;

    NBD_DEBUG (3, "nbd_rollback_old: entered\n");

    NBD_SEMAPHORE_DOWN (&lo->queue_lock);
    if (slot->req_age > 0 && slot->req_age < jiffies - NBD_AGE_REQ * HZ )  {
       NBD_DEBUG (1, "nbd_rollback_old: try rollback req on slot %d\n", islot);
       nbd_rollback(slot);
    }
    
    NBD_SEMAPHORE_UP (&lo->queue_lock);

    NBD_DEBUG (3, "nbd_rollback_old: exited OK\n");
}

/*
 * PTB - check all slots for old requests and roll them back. 
 */
static void
nbd_rollback_old_all(struct nbd_device *lo) {

    int islot;
    NBD_DEBUG (3, "nbd_rollback_old_all: entered\n");

    NBD_SEMAPHORE_DOWN (&lo->queue_lock);
    for (islot = 0; islot < lo->nslot; islot++){
      struct nbd_slot * slot = & lo->slots[islot];
      if (slot->req_age > 0 && slot->req_age < jiffies - NBD_AGE_REQ * HZ )  {
           NBD_DEBUG (1, "nbd_rollback_old_all: try rollback req on slot %d\n",
                   islot);
           nbd_rollback(slot);
      }
    }
    NBD_SEMAPHORE_UP (&lo->queue_lock);

    NBD_DEBUG (3, "nbd_rollback_old_all: exited OK\n");
}


/*
 * PTB - register a socket to a slot.
 *     - Return 0 for success and -ve for failure.
 */
static int
nbd_set_sock (struct nbd_slot * slot, int arg)
{

    struct file *file      = NULL;
    struct inode *inode    = NULL;
    struct nbd_device *lo  = slot->lo;
    int islot = slot->i;

    NBD_DEBUG (3, "nbd_set_sock: entered with arg %d on slot %d\n"
	       ,arg, islot);

    /* this is the file for the fd of the socket */
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
    file = fget(arg); 
    NBD_DEBUG (3, "nbd_set_sock: fget returned %x\n", (unsigned) file);
    if (!file) {
	NBD_ALERT ("nbd_set_sock: NULL file?!?\n");
	NBD_DEBUG (3, "nbd_set_sock: exited INVAL\n");
	return -EINVAL;
    }
    NBD_DEBUG (3, "nbd_set_sock: I got file %x\n", (unsigned) file);
    inode = file->f_dentry->d_inode;	/* PTB */
#else
    file = current->files->fd[arg & 0xffff];
    inode = file->f_inode;	/* PTB */
#endif
    /* N.B. Should verify that it's a socket */
    if (!inode) {
	NBD_ALERT ("nbd_set_sock: NULL inode?!?\n");
	NBD_DEBUG (3, "nbd_set_sock: exited INVAL\n");
	return -EINVAL;
    }
    NBD_DEBUG (3, "nbd_set_sock: got inode %x\n", (unsigned) inode);
    if (1) {			/* added by ptb */
	invalidate_inode_pages (inode);
	NBD_DEBUG (3, "nbd_set_sock: invalidated inode %x\n", (unsigned) inode);
    }
    NBD_DEBUG (3, "nbd_set_sock:"
               " received request for slot %d with %d active of %d\n",
	       islot, lo->aslot, lo->nslot);
    NBD_DEBUG (3, "nbd_set_sock: selected slot %d of %d\n", islot, lo->nslot);

    slot = & lo->slots[islot];

    if (slot->file) {
	int error = -EBUSY;	/* PTB need something better */
	NBD_DEBUG (3, "nbd_set_sock: socket %d is not empty\n", islot);
	NBD_DEBUG (3, "nbd_set_sock: exited with error %d\n", error);
	return error;
    }
    NBD_DEBUG (3, "nbd_set_sock: verified slot %d of %d is available\n",
      islot, lo->nslot);
    file->f_count++;
    NBD_DEBUG (3, "nbd_set_sock: incremented file reference count\n");
    NBD_SEMAPHORE_DOWN (&lo->queue_lock);
    slot->file = file;
    NBD_DEBUG (1, "nbd_set_sock: set file reference %d to %ld\n",
           islot, (long) file);
    slot->sock = &inode->u.socket_i;
    NBD_DEBUG (1, "nbd_set_sock: set socket %d reference on inode %x\n",
	       islot, (unsigned) inode);
    lo->aslot++;
    NBD_DEBUG (3, "nbd_set_sock: increased active socket count to %d\n"
	       ,lo->aslot);
    if (islot >= lo->nslot) {
	lo->nslot = islot + 1;
	NBD_DEBUG (3, "nbd_set_sock: increased socket count to %d\n"
		   ,lo->nslot);
    }
    slot->lock = MUTEX_LOCKED;   /* no reader */
    NBD_DEBUG (3, "nbd_set_sock: set semaphore %lx\n",
        (unsigned long) & slot->lock);
    lo->harderror = 0;
    NBD_DEBUG (3, "nbd_set_sock: set error to 0\n");
    NBD_SEMAPHORE_UP (&lo->queue_lock);
    NBD_DEBUG (3, "nbd_set_sock: exited OK with socket slot %d\n", islot);
    return 0;
}

/*
 * PTB - return the index i of 2^i + j, 0 <= j < 2^i
 */
static inline unsigned 
log2 (unsigned arg)
{
    unsigned log = 0;
    while ((arg >>= 1) > 0)
	log++;
    return log;
}

/*
 * PTB - set the blksize in bytes of the block device. Return 0 for
 *     - success and -ve for failure.
 */
static int
nbd_set_blksize (struct nbd_device *lo, unsigned int arg)
{
    int nbd = lo->nbd;
    NBD_DEBUG (3, "nbd_set_blksize: entered with arg %x (%u) on device %d\n"
	       ,arg, arg, nbd);
    if ((arg & 511) || (arg > PAGE_SIZE)) {
	NBD_ERROR ("nbd_set_blksize: blksize too big (%u)\n", arg);
	NBD_DEBUG (3, "nbd_set_blksize: exited INVAL\n");
	return -EINVAL;
    }
    lo->blksize = nbd_blksizes[nbd << NBD_SHIFT] = arg;
    NBD_DEBUG (1, "nbd_set_blksize: set blksize to %d \n", lo->blksize);
    lo->logblksize = log2 (lo->blksize);
    NBD_DEBUG (3, "nbd_set_blksize: exited OK\n");
    return 0;
}

/*
 * PTB - set the size in bytes of the block device. Return 0 for
 *     - success and -ve for failure.
 */
static int
nbd_set_size (struct nbd_device *lo, u64 arg)
{
    int nbd = lo->nbd;
    NBD_DEBUG (3, "nbd_set_size: entered with arg %Lx (%Lu) on device %d\n"
	       ,arg, arg, nbd);
    lo->bytesize = nbd_bytesizes[nbd << NBD_SHIFT] = arg;
    NBD_DEBUG (1, "nbd_set_size: set bytesize to %Lu \n", nbd_bytesizes[nbd << NBD_SHIFT]);
    lo->size = nbd_sizes[nbd << NBD_SHIFT] = (arg >> 10);
    NBD_DEBUG (1, "nbd_set_size: set size (KB) to %d \n", lo->size);
    NBD_DEBUG (3, "nbd_set_size: exited OK\n");
    return 0;
}

/*
 * PTB - if we're not signed, accept new sig and return success.
 *     - if we are signed, compare the offer and return success if equal,
 *     - and -ve for failure.
 */
static int
my_nbd_set_sig (struct nbd_slot * slot, int * sig) {
    int err = 0;
    int i = 0;
    int buf[NBD_SIGLEN / sizeof(int)];
    int islot = slot->i;
    struct nbd_device * lo = slot->lo;

    NBD_DEBUG (3, "my_nbd_set_sig: entered\n");
    if (err = verify_area(VERIFY_READ, (char*)sig, NBD_SIGLEN), err){
        NBD_DEBUG(3, "my_nbd_set_sig (%d): exited with %d\n" , islot, err );
        return err;
    }
    if (!(lo->flags & NBD_SIGNED)) {
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
        copy_from_user ((char*) lo->signature, (char*) sig, NBD_SIGLEN);
#else
        memcpy_fromfs ((char*) lo->signature, (char*) sig, NBD_SIGLEN);
#endif
        lo->flags |= NBD_SIGNED;
        NBD_DEBUG (3, "my_nbd_set_sig (%d): set sig and exited OK\n", islot);
        return 0;
    }
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
        copy_from_user ((char*)buf, (char*)sig, NBD_SIGLEN);
#else
        memcpy_fromfs ((char*)buf, (char*)sig, NBD_SIGLEN);
#endif

    /* PTB test for equality */

    for (i = 0; i < NBD_SIGLEN / sizeof(int); i++) 
      if (buf[i] != lo->signature[i]) {
        err = -EINVAL;
        NBD_DEBUG(3, "my_nbd_set_sig (%d): failed sigcheck wth %d\n",
              islot, err );
        return err;
      }
    err = 0;
    NBD_DEBUG(3, "my_nbd_set_sig (%d): exited OK\n", islot);
    return err;
}

/*
 * PTB - register a userspace buffer to a slot. Return 0 for success
 *     - and -ve for failure.
 */
static int
my_nbd_reg_buf (struct nbd_slot * slot,  char * buffer) {

    int err=0, siz ;
    struct nbd_device * lo = slot->lo;
    int maxblks = buf_sectors >> (lo->logblksize - 9);
    int islot = slot->i;

    NBD_DEBUG (3, "my_nbd_reg_buf: entered\n");

    if (blk_dev[MAJOR_NR].request_fn != do_nbd_request) { 
        err = -EINVAL;
        NBD_DEBUG(3, "my_nbd_reg_buf (%d): exited INVAL\n", islot);
        return err;
    }

    slot->buffer = buffer;
    slot->bufsiz = siz = lo->blksize + sizeof(struct nbd_request);
    /* verify the buffer holds one block */
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
    if (!access_ok(VERIFY_WRITE, buffer, siz)){
        err = -EINVAL;
#else
    if (err = verify_area(VERIFY_WRITE, buffer, siz), err){
#endif
        NBD_DEBUG(3, "my_nbd_reg_buf (%d): exited with %d\n" , islot, err );
        return err;
    }
#if 0
    /* PTB figure out if the buffer is as big as it should be */
    while (maxblks-- > 0) {
       siz += lo->blksize;
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
       if (!access_ok(VERIFY_WRITE, buffer, siz)){
#else
       if (err = verify_area(VERIFY_WRITE, buffer, siz), err){
#endif
           siz -= lo->blksize;
           /* PTB don't do anything about it if not at present FIXME */
           NBD_ALERT("my_nbd_reg_buf (%d): buffer not big enough!\n", islot);
           break;
       }
    }
#else
    /* PTB hope the buffer is as big as it should be */
    siz = maxblks * lo->blksize;
#endif
    slot->bufsiz = siz;
    NBD_DEBUG(1, "my_nbd_reg_buf (%d): registered buffer %x size %d\n",
       islot, (unsigned) buffer, siz);
    NBD_DEBUG (3, "my_nbd_reg_buf: exited OK\n");
    return 0;
}

/*
 * PTB - drains queue and zeros mod count.
 */
static int 
nbd_reset (struct nbd_device *lo)
{
    int j = 0;
    NBD_DEBUG (3, "nbd_reset: entered\n");
    if (!(lo->flags & NBD_INITIALISED && lo->nslot > 0))
	return -1;
    for (; j < lo->nslot; j++) {
        struct nbd_slot * slot = & lo->slots[j];
	NBD_DEBUG (1, "nbd_reset: clear socket in slot %d\n", j);
	nbd_clr_sock (slot);
    }
    NBD_DEBUG (1, "nbd_reset: clear queue\n");
    nbd_clr_queue (lo);
    lo->maxq = 0;		/* PTB useful for stats */
    lo->flags &= ~NBD_SIGNED;   /* PTB unsign the device */
    // if (lo->wq)
    // wake_up_interruptible (&lo->wq);
    // lo->nslot = lo->aslot = 0;
#ifdef MODULE
    while (MOD_IN_USE)
        MOD_DEC_USE_COUNT;
#endif
    invalidate_buffers (MKDEV(NBD_MAJOR,lo->nbd << NBD_SHIFT));
    NBD_DEBUG (3, "nbd_reset: exited OK\n");
    return 0;
}

/*
 * PTB - added a device/module reset for tidyness in face of rampant hacking
 *     - this does a nbd_reset of all devices with arg 0.
 */
int
nbd_forced_reset (struct nbd_device *lo)
{
    int i;
#ifdef MODULE
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
    int old_count = GET_USE_COUNT(&__this_module);
#else
    int old_count = mod_use_count_;
#endif
#endif
    int err = 0;
    NBD_DEBUG (3, "nbd_forced_reset: entered\n");

    if (!lo) {
	for (i = 0; i < MAX_NBD; i++)
	    nbd_reset (&nbd_dev[i]);
#ifdef MODULE
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
	while (MOD_IN_USE) 
           MOD_DEC_USE_COUNT;
#else
	mod_use_count_ = 0 ;
#endif
#endif

	NBD_DEBUG (1, "nbd_forced_reset: altered usage count to 0 from %d\n",
		   old_count);
    } else {
	err = nbd_reset (lo);
    }
    NBD_DEBUG (3, "nbd_forced_reset: exited\n");
    return err;
}

  
/*
 * PTB - generic ioctl handling
 */
static int
nbd_ioctl (struct inode *inode, struct file *file,
	   unsigned int cmd, unsigned long arg)
{
    struct nbd_device *lo = 0;
    int minor = -1;  /* PTB minor on which we got the ioctl */
    int islot = -1;
    int nbd = -1;   /* the count for the device group */
    struct nbd_slot * slot = 0;

    NBD_DEBUG (3, "nbd_ioctl: entered with arg %lu (%lx)\n", arg, arg);

    if (!suser ()) {
	NBD_ERROR ("nbd_ioctl: caller must be root.\n");
	NBD_DEBUG (3, "nbd_ioctl: exited PERM\n");
	return -EPERM;
    }
    if (!inode) {
	NBD_ERROR ("nbd_ioctl: given bad inode.\n");
	NBD_DEBUG (3, "nbd_ioctl: exited INVAL\n");
	return -EINVAL;
    }
    if (MAJOR (inode->i_rdev) != MAJOR_NR) {
	NBD_ERROR ("nbd_ioctl: pseudo-major != %d\n", MAJOR_NR);
	NBD_DEBUG (3, "nbd_ioctl: exited NODEV\n");
	return -ENODEV;
    }
    minor = MINOR (inode->i_rdev);
    nbd = minor >> NBD_SHIFT;
    if (nbd >= MAX_NBD) {
	NBD_ERROR ("nbd_ioctl: tried to open too many devices, %d\n", minor);
	NBD_DEBUG (3, "nbd_ioctl: exited NODEV\n");
	return -ENODEV;
    }
    lo = & nbd_dev[nbd];
    lo->harderror = 0;
    islot = minor % NBD_MAXCONN - 1;
    slot = &lo->slots[islot];

    switch (cmd) {
	  int err;

      case NBD_CLEAR_SOCK:
	  NBD_DEBUG (1, "nbd_ioctl: NBD_CLEAR_SOCK %ld\n", arg);
	  err = nbd_clr_sock (slot);
          if (lo->aslot <= 0) {	/* PTB - probably incorrect, not sock oriented */
	      invalidate_buffers (MKDEV(NBD_MAJOR, nbd<<NBD_SHIFT));
	      NBD_DEBUG (3, "nbd_ioctl: invalidated buffers on device %c\n", 'a'+nbd);
          }

	  NBD_DEBUG (1, "nbd_ioctl: exited with %d\n", err);
	  return err;

      case NBD_SET_SOCK:
	  NBD_DEBUG (3, "nbd_ioctl: NBD_SET_SOCK %ld\n", arg);
	  err = nbd_set_sock (slot, arg);
	  NBD_DEBUG (3, "nbd_ioctl: exited with %d\n", err);
	  return err;

      case NBD_GET_BLKSIZE:
	  NBD_DEBUG (3, "nbd_ioctl: NBD_GET_BLKSIZE %lx\n", arg);
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
	  err = put_user (lo->blksize, (long *) arg);
	  if (err < 0) {
	      err = -EINVAL;
	      NBD_DEBUG (3, "nbd_ioctl: exited INVAL\n");
	      return err;
	  }
#else
	  err = verify_area(VERIFY_WRITE, (long *) arg, sizeof(long));
	  if (err) {
	      err = -EINVAL;
	      NBD_DEBUG (3, "nbd_ioctl: exited INVAL\n");
	      return err;
	  }
	  put_user (lo->blksize, (long *) arg);
#endif
	  err = 0;
	  NBD_DEBUG (3, "nbd_ioctl: exited OK\n");
	  return err;

       case NBD_SET_BLKSIZE:
	  NBD_DEBUG (3, "nbd_ioctl: NBD_SET_BLKSIZE %ld\n", arg);
	  err = nbd_set_blksize (lo, arg);
	  NBD_DEBUG (3, "nbd_ioctl: exited with %d\n", err);
	  return err;

      case NBD_SET_SIZE:
	  NBD_DEBUG (3, "nbd_ioctl: NBD_SET_SIZE %ld\n", arg);
	  err = nbd_set_size (lo, (u64)arg);
	  NBD_DEBUG (3, "nbd_ioctl: exited with %d\n", err);
	  return err;

      case NBD_SET_SECTORS:
	  NBD_DEBUG (3, "nbd_ioctl: NBD_SET_SECTORS %ld\n", arg);
	  err = nbd_set_size (lo, (u64)arg * 512);
	  NBD_DEBUG (3, "nbd_ioctl: exited with %d\n", err);
	  return err;

      case MY_NBD_REG_BUF: /* PTB register your buffer per socket here */
	  NBD_DEBUG (3, "nbd_ioctl: MY_NBD_REG_BUF %lx\n", arg);
          if (!arg) {
              /* PTB serves as existence check for this ioctl */
              NBD_DEBUG (3, "nbd_ioctl: exited OK\n");
              return 0;
          }
	  err = my_nbd_reg_buf (slot, (char *) arg);
          NBD_DEBUG(3, "nbd_ioctl (%d): exited with %d\n" , islot, err );
	  return err;

      case MY_NBD_SET_SIG: 
	  NBD_DEBUG (3, "nbd_ioctl: MY_NBD_SET_SIG %lx\n", arg);
	  err = my_nbd_set_sig (slot, (int *) arg);
          NBD_DEBUG(3, "nbd_ioctl (%d): exited with %d\n" , islot, err );
	  return err;

      case MY_NBD_GET_REQ:
	  NBD_DEBUG (3, "nbd_ioctl: MY_NBD_GET_REQ %lx\n", arg);
          if (!slot || ! slot->buffer) {
              err = -EINVAL;
              NBD_DEBUG(3, "nbd_ioctl: exited INVAL\n");
              return err;
          }
	  err = my_nbd_get_req (slot);
	  if (err < 0) {
	    /* AMARIN Something missing here? */
	  }
          NBD_DEBUG(3, "nbd_ioctl: exited with %d\n" , err );
	  return err;

      case MY_NBD_CLR_REQ:
	  NBD_DEBUG (3, "nbd_ioctl: MY_NBD_CLR_REQ %ld\n", arg);
	  err = nbd_clr_req (slot);
	  NBD_DEBUG (3, "nbd_ioctl: exited with %d\n", err);
	  return err;

      case MY_NBD_SYNC:
	  NBD_DEBUG (3, "nbd_ioctl: MY_NBD_SYNC %ld\n", arg);
          if ((long)arg >= 0)
	    nbd_rollback_old (slot);
          else
	    nbd_rollback_old_all (lo);
	  err = 0;
	  NBD_DEBUG (3, "nbd_ioctl: exited with %d\n", err);
	  return err;

      case MY_NBD_ACK:
	  NBD_DEBUG (3, "nbd_ioctl: MY_NBD_ACK %lx\n", arg);
          if (!slot || ! slot->buffer) {
              err = -EINVAL;
              NBD_DEBUG(3, "nbd_ioctl: exited INVAL\n");
              return err;
          }
          err = my_nbd_ack (slot);
	  if (err < 0) {
	    /* AMARIN Something missing here? */
	  }
          NBD_DEBUG(3, "nbd_ioctl: exited with %d\n" , err );
	  return err;

	  /* let this be compiled in always - it's useful. PTB */
      case NBD_PRINT_DEBUG:
	  NBD_DEBUG (3, "nbd_ioctl: NBD_PRINT_DEBUG");
	  NBD_INFO ("device %d: head = %x, tail = %x, in = %d, out = %d\n"
		    ,minor, (int) lo->head, (int) lo->tail
		    ,lo->requests_in, lo->requests_out);
	  err = 0;
	  NBD_DEBUG (3, "nbd_ioctl: exited OK\n");
	  return err;


      case BLKFLSBUF:
	  NBD_DEBUG (1, "nbd_ioctl: BLKFLSBUF %lx\n", arg);
          if (!suser()) {
              err =  -EACCES;
	      NBD_DEBUG (1, "nbd_ioctl: BLKFLSBUF exited ACCES\n");
	      return err;
          }
          if (lo->inode)
             fsync_dev(lo->inode->i_rdev);
          else
             fsync_dev(MKDEV(NBD_MAJOR, nbd<<NBD_SHIFT));
          if (lo->inode)
             invalidate_buffers(lo->inode->i_rdev);
          else
             invalidate_buffers(MKDEV(NBD_MAJOR, nbd<<NBD_SHIFT));
          err = 0;
	  NBD_DEBUG (3, "nbd_ioctl: exited OK\n");
	  return err;


      case BLKRAGET:
	  NBD_DEBUG (1, "nbd_ioctl: BLKRAGET %lx\n", arg);
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
          err = put_user(read_ahead[MAJOR_NR], (long *) arg);
          if (err < 0) {
 	      NBD_DEBUG (1, "nbd_ioctl: BLKFLSBUF exited FAIL\n");
 	      return err;
          }
#else
          err = verify_area(VERIFY_WRITE, (long *)arg, sizeof(long));
          if (err) {
	      NBD_DEBUG (1, "nbd_ioctl: BLKFLSBUF exited FAIL\n");
	      return err;
          }
          put_user(read_ahead[MAJOR_NR], (long *) arg);
#endif
          err = 0;
	  NBD_DEBUG (3, "nbd_ioctl: exited OK\n");
	  return err;

      case BLKRASET:
	  NBD_DEBUG (1, "nbd_ioctl: BLKRASET %lx\n", arg);
          if (!suser()) {
              err =  -EACCES;
	      NBD_DEBUG (1, "nbd_ioctl: BLKRASET exited ACCES\n");
	      return err;
          }
          if (arg > 0xff) {
              err =  -EINVAL;
	      NBD_DEBUG (1, "nbd_ioctl: BLKRASET exited INVAL\n");
	      return err;
          }
          rahead = read_ahead[MAJOR_NR] = arg;
          err = 0;
	  NBD_DEBUG (3, "nbd_ioctl: exited OK\n");
	  return err;
          
      case HDIO_GETGEO:
	  NBD_DEBUG (1, "nbd_ioctl: HDIO_GETGEO %lx\n", arg);
          if (!arg) {
              err =  -EINVAL;
	      NBD_DEBUG (1, "nbd_ioctl: HDIO_GETGEO exited INVAL\n");
	      return err;
          }
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
          {
            struct hd_geometry * geo = (struct hd_geometry *) arg;
            int sectors = nbd_sizes[nbd << NBD_SHIFT] * 2;
            sectors &= ~0x3f;
            err = 0;
            if((err = put_user(sectors >> 6, &geo->cylinders), err<0)
            || (err = put_user(           4, &geo->heads),     err<0)
            || (err = put_user(          16, &geo->sectors),   err<0)
            || (err = put_user(           4, &geo->start),     err<0)) {
	      NBD_DEBUG (1, "nbd_ioctl: HDIO_GETGEO exited FAIL\n");
	      return err;
	    }
          }
#else
          err = verify_area(VERIFY_WRITE, (char*)arg, sizeof(struct hd_geometry));
          if (err) {
	      NBD_DEBUG (1, "nbd_ioctl: HDIO_GETGEO exited FAIL\n");
	      return err;
          } else {
            struct hd_geometry * geo = (struct hd_geometry *) arg;
            int sectors = nbd_sizes[nbd << NBD_SHIFT] * 2;
            sectors &= ~0x3f;
            put_user(sectors >> 6, &geo->cylinders);
            put_user(           4, &geo->heads);
            put_user(          16, &geo->sectors);
            put_user(           4, &geo->start);
          }
#endif
          err = 0;
	  NBD_DEBUG (3, "nbd_ioctl: exited OK\n");
	  return err;

      case BLKGETSIZE:		/* PTB 132 */
          /* PTB return nr sectors */
	  NBD_DEBUG (1, "nbd_ioctl: BLKGETSIZE %lx\n", arg);
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
	  err = put_user ((unsigned long) (lo->size << 1), (unsigned long *)arg);
	  if (err < 0) {
	      err = -EINVAL;
	      NBD_DEBUG (3, "nbd_ioctl: invalid user area %lu\n", arg);
	      NBD_DEBUG (1, "nbd_ioctl: BLKGETSIZE exited INVAL\n");
	      return err;
	  }
#else
	  err = verify_area(VERIFY_WRITE, (long *) arg, sizeof(long));
	  if (err) {
	      err = -EINVAL;
	      NBD_DEBUG (3, "nbd_ioctl: invalid user area %lu\n", arg);
	      NBD_DEBUG (1, "nbd_ioctl: BLKGETSIZE exited INVAL\n");
	      return err;
	  }
	  put_user ((unsigned long) (lo->size << 1), (unsigned long *)arg);
#endif
          // PTB this check is silly here and seems to trigger!
	  if ((lo->bytesize >> 10) != (u64) lo->size) {
	      NBD_ALERT ("nbd_ioctl: bytes %Lu mismatch with KB %u in BLKGETSIZE\n"
                     , lo->bytesize, lo->size);
	  } else {
	      NBD_DEBUG (1, "nbd_ioctl: bytes %Lu match with KB %u in BLKGETSIZE\n"
                     , lo->bytesize, lo->size);
          }
	  err = 0;
	  NBD_DEBUG (1, "nbd_ioctl: exited OK\n");
	  return err;

      case NBD_HARD_RESET:     /* PTB - debugging */
	  NBD_DEBUG (3, "nbd_ioctl: NBD_HARD_RESET\n");
          err = nbd_forced_reset(lo);
	  NBD_DEBUG (3, "nbd_ioctl: exited OK\n");
          return err;
	  
      case NBD_DEC_USE_COUNT: /* AMARIN */
          NBD_DEBUG(3,"nbd_dec_use_count enter, MOD_IN_USE=%s\n" ,
               MOD_IN_USE?  "yes": "no");
	  while (MOD_IN_USE){
	    MOD_DEC_USE_COUNT;
	    NBD_DEBUG(3,"Decrementing mod_use_count");
	  }
	  invalidate_buffers (MKDEV(NBD_MAJOR, nbd << NBD_SHIFT));
          NBD_DEBUG(3,"nbd_dec_use_count exited, MOD_IN_USE=%s\n" ,
               MOD_IN_USE?  "yes": "no");
	  return 0;
    }
    NBD_DEBUG (3, "nbd_ioctl: exited INVAL\n");
    return -EINVAL;
}

/*
 * PTB - release the device
 */
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
static int
#else
static void
#endif
nbd_release (struct inode *inode, struct file *file)
{
    struct nbd_device *lo;
    int dev;
    int nbd;

    NBD_DEBUG (2, "nbd_release: entered\n");

    if (!inode) {
	NBD_ALERT ("nbd_release: null inode.\n");
	NBD_DEBUG (3, "nbd_release: exited NODEV\n");
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
        return -ENODEV;
#else
        return;
#endif
    }
    dev = MINOR (inode->i_rdev);
    nbd = dev >> NBD_SHIFT;

    if (nbd >= MAX_NBD ) {
	NBD_ALERT ("nbd_release: too many open devices.\n");
	NBD_DEBUG (3, "nbd_release: exited NODEV\n");
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
	return -ENODEV;
#else
        return;
#endif
    }

    lo = &nbd_dev[nbd];

    if (lo->inode)
         fsync_dev (lo->inode->i_rdev);
    else
         fsync_dev (MKDEV(NBD_MAJOR, nbd << NBD_SHIFT));

    if (lo->refcnt <= 0) {
	NBD_ALERT ("nbd_release: refcount(%d) <= 0\n", lo->refcnt);

        if (lo->inode)
             invalidate_buffers (lo->inode->i_rdev);
        else
             invalidate_buffers (MKDEV(NBD_MAJOR, nbd<<NBD_SHIFT));
        NBD_DEBUG (2, "nbd_release: invalidated buffers\n");

    }
    if (lo->head || lo->tail || lo->requests_req > 0) {
	NBD_ALERT ("Some requests are in progress -> can not turn off.\n");
	NBD_DEBUG (3, "nbd_release: exited BUSY\n");
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
	return -EBUSY;
#else
        return;
#endif
    }

    /* POSSIBLE change socket here PTB */

    lo->refcnt--;
    NBD_DEBUG (3, "nbd_release: decrement device %c reference count.\n",
        'a' + nbd);
    if (MOD_IN_USE)
	MOD_DEC_USE_COUNT;


    if (lo->refcnt <= 0 || ! MOD_IN_USE) {
       if (lo->inode)
         invalidate_buffers (lo->inode->i_rdev);     
       else
         invalidate_buffers (MKDEV(NBD_MAJOR, nbd << NBD_SHIFT));
       NBD_DEBUG (2, "nbd_release: invalidated buffers\n");
    }


    NBD_DEBUG (2, "nbd_release: exited OK with %d requests in queue\n",
	       lo->count);
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
    return 0;
#else
        return;
#endif
}

#if 0
/*
 * PTB - Do a reverse-flush of the device to the queue, either of our
 *     - slot if called from a client minor, or of the whole device if called
 *     - from the whole device minor.
 */
int 
nbd_fsync (struct inode *inode, struct file *file)
{
    int dev = -1;
    struct nbd_device *lo = 0;
    int err = 0;
    int nbd = -1;
    int islot = -1;

    NBD_DEBUG (3, "nbd_fsync: entered\n");

    if (1 && !inode && file) {
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
	inode = file->f_dentry->d_inode;
#else
	inode = file->f_inode;
#endif
    }
    if (!inode) {
	NBD_ERROR ("nbd_fsync - null inode.\n");
	NBD_DEBUG (3, "nbd_fsync: exited INVAL\n");
	return -EINVAL;
    }

    NBD_DEBUG (3, "nbd_fsync: have inode %x\n", (unsigned) inode);

    dev = MINOR (inode->i_rdev);
    nbd = dev >> NBD_SHIFT;
    islot = dev - (nbd << NBD_SHIFT) - 1;

    if (nbd >= MAX_NBD) {
	NBD_ERROR ("nbd_fsync - too many (%d) devices open\n", nbd);
	NBD_DEBUG (3, "nbd_fsync: exited NODEV\n");
	return -ENODEV;
    }

    NBD_DEBUG (3, "nbd_fsync: have minor device %d\n", dev);

    lo = &nbd_dev[nbd];
    slot = & lo->slots[islot];

    if (islot < 0)
      nbd_rollback_old_all (lo);
    else
      nbd_rollback_old_all (slot);

    NBD_DEBUG (3, "nbd_fsync: exited\n");

    return err = 0;
}
#endif

static struct file_operations nbd_fops =
{
        NULL,                       /* lseek - default */
        block_read,                 /* read - general block-dev read */
        block_write,                /* write - general block-dev write */
        NULL,                       /* readdir - bad */
        NULL,                       /* select */
        nbd_ioctl,                  /* ioctl */
        NULL,                       /* mmap */
        nbd_open,                   /* open */
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
        NULL,                       /* flush */
#endif
        nbd_release,                /* release */
        block_fsync,                /* block_fsync = general fsync AMARIN */
};
                                     

/*
 * And here should be modules and kernel interface 
 *  (Just smiley confuses emacs :-)
 */

int 
nbd_read_proc (char *buf, char **start, off_t offset, int len, int unused)
{

    static const int limit = PAGE_SIZE - 80;
    int i;
    struct nbd_device *lo;
    int last = -1;
    static int last_despatched[MAX_NBD];
    /* static long unsigned last_jiffies; */
    extern volatile unsigned long jiffies; 
    int stuck = 0;
    int alive = 0;
    /* int reqlen = len; */

    NBD_DEBUG (2, "nbd_read_proc: entered len=%d\n", len);
    len = 0;

    for (i = 0; i < MAX_NBD; i++) {

	lo = &nbd_dev[i];
	if (lo->nslot <= 0) {
	    continue;
	}
	if (len > limit)
	    return len;
	if (last == i - 2) {
	    len += sprintf (buf + len, "Device %c:\tClosed\n", 'a' + i - 1);
	}
	if (last < i - 2) {
	    len += sprintf (buf + len, "Device %c-%c:\tClosed\n",
                'a' + last + 1, 'a' + i - 1);
	}
	if (len > limit)
	    return len;
	len += sprintf (buf + len,
			"Device %c:\tOpen\n", 'a' + i);
	alive++;
	if (len > limit)
	    return len;
	len += sprintf (buf + len,
	     "[%c] State:\t%s, %s, %s, last error %d\n",
			'a' + i,
	      lo->flags & NBD_INITIALISED ? "initialized" : "uninitialized",
			lo->flags & NBD_WRITE_NOCHK ? "noverify" : "verify",
			lo->flags & NBD_READ_ONLY ? "ro" : "rw",
                        lo->harderror);
	if (len > limit)
	    return len;
	else {
	    int count = 0;
	    struct request *req;

	    NBD_SEMAPHORE_DOWN (&lo->queue_lock);
	    for (req = lo->tail; req; req = req->next) {
		count++;
		if (req == lo->head)
		    break;
	    }
	    NBD_SEMAPHORE_UP (&lo->queue_lock);

	    len += sprintf (buf + len,
               "[%c] Queued:\t%d current/%d real/%d max\n",
			'a' + i, lo->count, count, lo->maxq);
	PARANOIA_BEGIN;
            if (count != lo->count) {
		/* PTB last ditch! HACK HACK HACK FIXME */
		NBD_DEBUG (1, "nbd_read_proc:"
                  " altered queued count to %d from %d\n", count, lo->count);
		lo->count = count;
	    }
	PARANOIA_END;
        }
	if (len > limit)
	    return len;
           
	len += sprintf (buf + len, "[%c] Blocksize:\t%d\t(log=%d)\n",
			'a' + i, lo->blksize, lo->logblksize);
	len += sprintf (buf + len, "[%c] Size:\t%lu\n",
			'a' + i, (unsigned long) lo->bytesize);
	len += sprintf (buf + len, "[%c] Blocks:\t%u\n",
			'a' + i, (lo->size << 1) / (lo->blksize >> 9));
	if (len > limit)
	    return len;
	len += sprintf (buf + len,
			"[%c] Sockets:\t%d",
			'a' + i, lo->nslot);
	if (len > limit)
	    return len;
	else {
	    int j;
	    for (j = 0; j < lo->nslot; j++) {
                struct nbd_slot * slotj = & lo->slots[j];
	        if (j != lo->islot )
		  len += sprintf (buf + len, "\t(%s)", slotj->file ? "+" : "-");
		else
		  len += sprintf (buf + len, "\t(%s)", slotj->file ? "*" : ".");
            }
	}
	len += sprintf (buf + len, "\n");
	if (len > limit)
	    return len;
        else {
            int pending_blks = 0; /* PTB  not reached the slots yet */
	    struct request *req;
	    NBD_SEMAPHORE_DOWN (&lo->queue_lock);
	    for (req = lo->tail; req; req = req->next) {
		pending_blks += nr_blks(lo,req);
		if (req == lo->head)
		    break;
	    }
	    NBD_SEMAPHORE_UP (&lo->queue_lock);
	    len += sprintf (buf + len,
			"[%c] Requested:\t%d+%d",
			'a' + i, lo->requests_in - pending_blks, pending_blks);
        }
	if (len > limit)
	    return len;
	else {
	    int j;
	    for (j = 0; j < lo->nslot; j++) {
                struct nbd_slot * slotj = & lo->slots[j];
		len += sprintf (buf + len, "\t(%d)", slotj->in);
            }
	}

	len += sprintf (buf + len, "\n");
	len += sprintf (buf + len,
			"[%c] Dispatched:\t%d",
			'a' + i, lo->requests_out);
	if (len > limit)
	    return len;
	else {
	    int j;
	    for (j = 0; j < lo->nslot; j++) {
                struct nbd_slot * slotj = & lo->slots[j];
		len += sprintf (buf + len, "\t(%d)", slotj->out);
            }
	}

	len += sprintf (buf + len, "\n");
	len += sprintf (buf + len,
			"[%c] Errored:\t%d",
			'a' + i, lo->requests_err);
	if (len > limit)
	    return len;
	else {
	    int j;
	    for (j = 0; j < lo->nslot; j++) {
                struct nbd_slot * slotj = & lo->slots[j];
		len += sprintf (buf + len, "\t(%d)", slotj->err);
            }
	}

	len += sprintf (buf + len, "\n");
	if (len > limit)
	    return len;
        else {
            int pending_blks = 0; /* PTB  not reached the slots yet */
	    struct request *req;
	    NBD_SEMAPHORE_DOWN (&lo->queue_lock);
	    for (req = lo->tail; req; req = req->next) {
		pending_blks += nr_blks(lo,req);
		if (req == lo->head)
		    break;
	    }
	    NBD_SEMAPHORE_UP (&lo->queue_lock);
	    len += sprintf (buf + len,
			"[%c] Pending:\t%d+%d",
			'a' + i, lo->requests_req, pending_blks);
        }
	if (len > limit)
	    return len;
	else {
	    int j;
	    for (j = 0; j < lo->nslot; j++) {
                struct nbd_slot * slotj = & lo->slots[j];
		len += sprintf (buf + len, "\t(%lu)", nr_blks(lo,slotj->req));
            }
	}
        
        len += sprintf (buf + len, "\n");
	if (lo->requests_out == last_despatched[i] && lo->requests_out > 0)
	    stuck++;
	last_despatched[i] = lo->requests_out;
	if (len > limit)
	    return len;
	len += sprintf (buf + len, "[%c] Kthreads:\t%d", 'a' + i, lo->kthreads);
	len += sprintf (buf + len, "\t(%d waiting/%d running)\n",
                        lo->kwaiters, lo->kthreads - lo->kwaiters);
	if (len > limit)
	    return len;
	len += sprintf (buf + len, "[%c] Cthreads:\t%d", 'a' + i, lo->cthreads);
	if (len > limit)
	    return len;
	else {
	    int j;
	    for (j = 0; j < lo->nslot; j++) {
                struct nbd_slot * slotj = & lo->slots[j];
                int state = ((slotj->flags & NBD_SLOT_RUNNING)?1:0)
                          + ((slotj->flags & NBD_SLOT_WAITING)?2:0);
                char *desc = "?";
                switch (state) {
                    case 0: desc = "-"; break; /* PTB not in */
                    case 1: desc = "*"; break; /* PTB in and not waiting */
                    case 2: desc = "?"; break; /* PTB impossible */
                    case 3: desc = "+"; break; /* PTB in and waiting */
                }
		len += sprintf (buf + len, "\t(%s)", desc);
            }
	}
	len += sprintf (buf + len, "\n");
	last = i;
    }
    if (len > limit)
	return len;
    if (last == i - 2) {
	len += sprintf (buf + len, "Device %c:\tClosed\n", 'a' + i - 1);
    }
    if (len > limit)
	return len;
    if (last < i - 2) {
	len += sprintf (buf + len, "Device %c-%c:\tClosed\n",
            'a' + last + 1, 'a' + i - 1);
    }
    NBD_DEBUG (2, "nbd_read_proc: exited\n");
    return len;
}

struct proc_dir_entry nbd_proc_entry =
{
    0,
    7, "nbdinfo",
    S_IFREG|S_IRUGO|S_IWUSR,
    1, 0, 0,
    0,
    NULL,
    &nbd_read_proc,
};

#ifdef MODULE
#define nbd_init init_module
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
    MODULE_AUTHOR("Peter T. Breuer, Andres Marin");
    MODULE_DESCRIPTION("Network Block Device");
#endif
#endif

int
nbd_init (void)
{
    int i, j;
    NBD_DEBUG (3, "nbd_init: entered\n");

    NBD_INFO ("Network Block Device support by pavel@elf.mj.gts.cz\n");
    NBD_INFO ("Network Block Device port to 2.0 by ptb@it.uc3m.es\n");
    NBD_INFO ("Network Block Device trying to put things in user space by amarin@it.uc3m.es\n");
    if (register_blkdev (MAJOR_NR, "nbd", &nbd_fops)) {
	NBD_ERROR ("Unable to get major number %d for NBD\n", MAJOR_NR);
	return -EIO;
    }
#ifdef MODULE
    NBD_INFO ("registered device at major %d\n", MAJOR_NR);
#endif
    blksize_size[MAJOR_NR] = nbd_blksizes;	/* blksize in B */
    blk_size    [MAJOR_NR] = nbd_sizes;         /* size in KB */
    blk_dev     [MAJOR_NR].request_fn
                           = do_nbd_request;	/* AMARIN */
    read_ahead  [MAJOR_NR] = rahead;	        /* AMARIN/PTB */

    for (i = 0; i < MAX_NBD; i++) {
        struct nbd_device * lo = & nbd_dev[i];
	memset (lo, 0, sizeof (struct nbd_device));
	lo->magic     = NBD_DEV_MAGIC;
        for ( j = 0; j < NBD_MAXCONN; j++) {                  /* PTB */
          lo->slots[j].lo = lo;
          lo->slots[j].i  = j;
        }
	lo->blksize   = 1024;                                 /* PTB 132 */
	lo->logblksize= 10;		                      /* PTB */
	lo->bytesize  = 0x7fffffff;                           /* PTB 132 */
	lo->size      = 0x7fffffff;	                      /* PTB (bytesizes/1024) */
        lo->nbd       = i;
        for ( j = 0; j < NBD_MAXCONN; j++) {
	  nbd_blksizes [i * NBD_MAXCONN + j] = lo->blksize;
	  nbd_bytesizes[i * NBD_MAXCONN + j] = lo->bytesize;
	  nbd_sizes    [i * NBD_MAXCONN + j] = lo->size;
        }

        //nbd_partitions[i << NBD_SHIFT].nr_sects = 2 * lo->size; 

    }

    NBD_DEBUG (3, "nbd_init: creating proc entry\n");
#if LINUX_VERSION_CODE > LINUX_VERSION_2_1_0
    proc_register (&proc_root, &nbd_proc_entry);
#else
    proc_register_dynamic (&proc_root, &nbd_proc_entry);
#endif

    NBD_DEBUG (3, "nbd_init: exited OK\n");
    return 0;
}

#ifdef MODULE
void
cleanup_module (void)
{
    int i;

    NBD_DEBUG (3, "nbd_cleanup: removing proc entry\n");
    proc_unregister (&proc_root, nbd_proc_entry.low_ino);

    for (i = 0; i < MAX_NBD ; i++)
      fsync_dev(MKDEV(MAJOR_NR,i<<NBD_SHIFT));

    blk_dev[MAJOR_NR].request_fn = NULL;
    blk_size[MAJOR_NR]           = NULL;
    read_ahead[MAJOR_NR]         = 0;

    if (unregister_blkdev (MAJOR_NR, "nbd") != 0)
	NBD_ALERT ("cleanup_module failed\n");
    else
	NBD_INFO ("module cleaned up.\n");
}
#endif

/* Compile line:

 *  gcc -O2 -D__KERNEL__ -DMODULE -xc -c nbd.c -o nbd.o
 *
 *  (possibly with -DMODVERSIONS also). PTB
 */
