#ifndef LINUX_ENBD_H
#define LINUX_ENBD_H

/* unsigned comments are Pavel's originals for 2.1.*
 *   pavel@atrey.karlin.mff.cuni.cz (Pavel Machek)
 * comments marked PTB are from
 *   ptb@it.uc3m.es (Peter T. Breuer)
 * comments marked AMARIN are from
 *   amarin@it.uc3m.es (Andres Marin Lopez)
 */

#include <asm/types.h>

#ifndef NBD_VERSION
#define NBD_VERSION "2.4.27 $Date$"
#endif /*NBD_VERSION*/

  /*
   * Third type of request apart from READ or WRITE
   */
  #ifndef IOCTL
  # define IOCTL 2
  #endif
  /*
   * and fourth ..
   */
  #ifndef MD5SUM
  # define MD5SUM 3
  #endif

  /*
   * We need an extra bit of req->flags
   * */
  #define REQ_NBD (1 << __REQ_NR_BITS)

/* PTB - new style ioctl assignments */
  #define NBD_SET_SOCK         _IOW(0xab, 0x00, int)
  #define NBD_TEST_IOCTL1      _IOW(0xab, 0x01, int)
  #define NBD_SET_SIZE         _IOW(0xab, 0x02, int)
  #define NBD_DO_IT            _IOW(0xab, 0x03, int)
  #define NBD_CLEAR_SOCK       _IOW(0xab, 0x04, int)
  #define NBD_CLEAR_QUE        _IO (0xab, 0x05)
  #define NBD_PRINT_DEBUG      _IO (0xab, 0x06)
  #define NBD_TEST_IOCTL2      _IOR(0xab, 0x07, int)
  #define NBD_HARD_RESET       _IO (0xab, 0x09)
  #define NBD_DEC_USE_COUNT    _IO (0xab, 0x09)
  #define MY_NBD_ACK           _IOW(0xab, 0x0a, char *)
  #define MY_NBD_GET_REQ       _IOW(0xab, 0x0b, char *)
  #define MY_NBD_REG_BUF       _IOW(0xab, 0x0c, char *)
  #define MY_NBD_CLR_REQ       _IOW(0xab, 0x0d, int)
  #define MY_NBD_SYNC          _IOW(0xab, 0x0e, int)
  #define NBD_SET_SECTORS      _IOW(0xab, 0x0f, int)
  #define MY_NBD_SET_SIG       _IOW(0xab, 0x10, int *)
  #define NBD_RESET            _IO (0xab, 0x11)
  #define NBD_TEST_IOCTL3      _IOWR(0xab, 0x12, int)
  #define MY_NBD_ERR_REQ       _IOW(0xab, 0x13, int)
  #define MY_NBD_SET_INTVL     _IOW(0xab, 0x14, int)
  #define MY_NBD_SET_SHOW_ERRS _IOW(0xab, 0x15, int) 
  #define NBD_SET_MD5SUM       _IOW(0xab, 0x16, int) 
  #define MY_NBD_SET_BUFFERWR  _IOW(0xab, 0x17, int) 
  #define MY_NBD_INVALIDATE    _IOW(0xab, 0x18, int)
  #define MY_NBD_SET_SPID      _IOW(0xab, 0x19, int) 
  #define MY_NBD_SET_RQ_HANDLE _IOW(0xab, 0x1a, void*) 
  #define MY_NBD_SET_RQ_SEQNO  _IOW(0xab, 0x1b, int) 
  #define MY_NBD_SET_RQ_DIGEST _IOWR(0xab, 0x1d, nbd_digest_t) 
  #define NBD_TEST_IOCTL4      _IOR(0xab, 0x1e, char[256])
  #define NBD_TEST_IOCTL5      _IOWR(0xab, 0x1f, char[256])
  #define NBD_TEST_IOCTL6      _IO(0xab, 0x20) // special r 256B
  #define NBD_TEST_IOCTL7      _IO(0xab, 0x21) // special rw 256B
  #define NBD_SET_BLKSIZE      _IOW(0xab, 0x22, int)
  #define NBD_GET_BLKSIZE      _IOR(0xab, 0x23, long)

#define MAX_NBD 16          /* PTB MAX was 128, but that's a lot */
#define NBD_SHIFT 4         /* PTB 16 partitions/sockets/slots per device */
                            /* PTB number of socket slots per device */
#define NBD_MAXCONN (1<<NBD_SHIFT)
#define NBD_SIGLEN 128      /* PTB length of sig on device */
#define NBD_MAX_SECTORS 512 /* PTB max number of 512B sectors in a buffer */


#ifdef MAJOR_NR
  /* PTB we are included from the kernel nbd.c file so put kernel stuff here */

  #include <linux/locks.h>
  #include <linux/config.h>

  #define ENDREQ_NOCURRENT
  #define LOCAL_END_REQUEST
  #include <linux/blk.h>

  static void end_request(struct request *req, int uptodate) {  
     /* unlock chained buffers */
     struct bio *bio;
     while ((bio = req->bio) != NULL) {
             blk_finished_io(bio_sectors(bio));
             req->bio = bio->bi_next;
             bio->bi_next = NULL;
             bio_endio(bio, uptodate);
     }
     blkdev_release_request(req);
  }                 
 /* 
  * PTB This takes the spinlock itself! So call it with the io spinlock
  * not held.
  */
  static void end_request_lock(struct request *req, int uptodate) {  
     unsigned long flags;
     request_queue_t *q = req->q;
     static void rq_set_seqno(struct request *, int);

     rq_set_seqno(req, 0); // PTB Zero extra seqno info
     /* unlock chained buffers */
     spin_lock_irqsave(q->queue_lock, flags);
     end_request(req, uptodate);
     spin_unlock_irqrestore(q->queue_lock, flags);

  }

 /*
  * PTB Call this only with the io spinlock * held.
  */
  static void nbd_end_request(struct request *req) {

    // PTB the kernel has only 2 queues, read and write, and it uses
    // the cmd field to determine to which the req belongs. We add a
    // seqno to it in nbd_do_req, so we reestablish it here.
    static void rq_set_seqno(struct request *, int);

    rq_set_seqno(req, 0); // PTB Zero extra seqno info
    end_request( req, (req->errors == 0) ? 1 : 0 );
  }
 /* 
  * PTB This takes the spinlock itself! So call it with the io spinlock
  * not held.
  */
  static void nbd_end_request_lock(struct request *req) {  

    // PTB the kernel has only 2 queues, read and write, and it uses
    // the cmd field to determine to which the req belongs. We add a
    // seqno to it in nbd_do_req, so we reestablish it here.
    static void rq_set_seqno(struct request *, int);

    rq_set_seqno(req, 0); // PTB Zero extra seqno info
    end_request_lock( req, !req->errors );
  }


  /* PTB various defaults */
  #define NBD_RAHEAD_DFLT    24 /* PTB slow medium                  */
  #define NBD_SYNC_INTVL      0 /* PTB sync every nK reqs (default disable) */
  #define NBD_REQ_TIMEO       5 /* PTB client inactivity chk intvl (rollback) */
  #define NBD_SPEED_LIM  100000 /* PTB limit to 100M write reqs/s */
  #define NBD_MERGE_REQ_DFLT  0 /* PTB until accounting fixed! */
   /* PTB Jens Axboe says that plug should always be set in 2.4.* */
  #define NBD_PLUG_DFLT       1 
  #define NBD_MD5SUM_DFLT     0 

    struct nbd_slot {
      struct file * file;      /* PTB add - for refcnt, NULL if slot empty */
      struct socket * sock;    /* PTB add                          */
      int in;                  /* PTB add - tot blocks entered     */
      int out;                 /* PTB add - tot blocks released    */
      int err;                 /* PTB add - tot blocks errored     */
      int req;                 /* PTB add - tot blocks pending     */
      char * buffer;           /* PTB add - user space buffer      */
      int  bufsiz;             /* PTB add - user space buffer size */
      struct list_head queue;
      unsigned long req_age;   /* PTB add - age of pending req     */
      unsigned long cli_age;   /* PTB add - age of client          */
      struct nbd_device *lo;   /* PTB add - parent device          */
    #define NBD_SLOT_RUNNING   0x0001
    #define NBD_SLOT_WAITING   0x0002
    #define NBD_SLOT_BUFFERED  0x0004
    #define NBD_SLOT_MD5SUM    0x8000 /* slot reply has a digest in it ..*/
    #define NBD_SLOT_MD5_OK   0x10000 /* .. and equaled req's */
      int flags;               /* PTB add */
      int i;                   /* PTB add - slot number */
      int buflen;              /* PTB add - buffer byte count */
      int pid;                 /* PTB add - client process */
      int refcnt;              /* PTB add - so can set_sock/clr_sock ourself */
      int nerrs;               /* PTB add - local error count */
      int spid;                /* PTB add - server pid */
    };


  struct nbd_speed {
    atomic_t speed;                      /* PTB add - current speed in KB/s */
    atomic_t speedmax;                   /* PTB add - max speed */
    atomic_t speedav;                    /* PTB add - average speed */
    atomic_t distance;                   /* PTB add - last distance measure */
    atomic_t jiffy;                      /* PTB add - last jiffies speed set */
    struct nbd_device *lo;               /* parent */
    int (*getdistance)(struct nbd_device*);
                                         /* get current total measure */
  };

  struct nbd_device {
      atomic_t refcnt;	
    #define NBD_READ_ONLY   0x0001
    #define NBD_WRITE_NOCHK 0x0002
    #define NBD_INITIALISED 0x0004
    #define NBD_SIGNED      0x0008
    #define NBD_ENABLED     0x0010
    #define NBD_SIZED       0x0020
    #define NBD_BLKSIZED    0x0040
    #define NBD_SYNC_REQD   0x0080
    #define NBD_RLSE_REQD   0x0100
    #define NBD_SHOW_ERRS   0x0200
    #define NBD_SYNC        0x0400
    #define NBD_MD5SUM      0x8000


    #define NBD_INVALID    0x40000         /* remote resource vanished */

    #define NBD_BUFFERWR  0x100000         /* buffer writes to device */
      atomic_t flags;
      int harderror;		           /* Code of hard error	    */
      int magic;			   /* FIXME: not if debugging is off  */
      struct list_head queue;
      rwlock_t queue_spinlock;             /* PTB add - spinlock */
      int nslot;                           /* PTB add - total slots */
      atomic_t islot;                      /* PTB add - current slot */
      int aslot;                           /* PTB add - total active slots*/
      atomic_t requests_in[2];             /* PTB add - blocks put on queue */
      atomic_t requests_out[2];            /* PTB add - blocks out from queue */
      atomic_t requests_err;               /* PTB add - blocks erred on queue */
      atomic_t wrequests_5so;              /* PTB add - write blocks md5 skip */
      atomic_t wrequests_5wo;              /* PTB add - write blocks md5 wr */
      atomic_t wrequests_5eo;              /* PTB add - write blocks md5 refus*/
      atomic_t wrequests_5to;              /* PTB add - write blocks md5sum */
      atomic_t wrequests_5co;              /* PTB add - write blocks md5 tot */
      atomic_t wrequests_5no;              /* PTB add - write blocks not md5 */
      atomic_t requests_req[2];            /* PTB add - read blocks pending */
      atomic_t kwaiters;                   /* PTB add - kernel thrds waiting */
      atomic_t kthreads;                   /* PTB add - kernel threads in */
      atomic_t maxq[2];                    /* PTB add - max req queue depth */
      atomic_t countq[2];                  /* PTB add - request queue depth */
      atomic_t errors;                     /* PTB add - tot requests errored */
      atomic_t seqno_out;                  /* PTB add - sequence number */
      atomic_t cwaiters;                   /* PTB add - client thrds waiting */
      atomic_t cthreads;                   /* PTB add - client threads in */
      atomic_t req_in[2][1 + NBD_MAX_SECTORS/2];
      wait_queue_head_t wq;                /* PTB add */
      struct nbd_slot slots[NBD_MAXCONN];  /* PTB add - client array */
      unsigned blksize;                    /* PTB add - device blksize in B */
      u64 bytesize;                        /* PTB add - device size in B */
      u64 sectors;                         /* PTB add - device size (sectors) */
      unsigned size;                       /* PTB add - device size in blks */
      unsigned logblksize;                 /* PTB add - log2 blksize */
      unsigned nbd;                        /* PTB add - this array index */
      int signature[NBD_SIGLEN/sizeof(int)];
                                           /* PTB add - server sig */
      struct file * file;                  /* PTB add - for ref */
      struct inode * inode;                /* PTB add - for ref */
      int  bufsiz;                         /* PTB add - userspace buffer size */
      atomic_t kmax;                       /* PTB add - max kernel threads */
      char *blockmap;                      /* PTB add - map of block states */
      unsigned long disabled;              /* PTB add - when was it disabled */
      int req_timeo;                       /* PTB add - inactivity timeout */
      struct timer_list run_queue;         /* PTB add - run queue */
      struct tq_struct task_queue;         /* PTB add - task queue */
      char devnam[4];                      /* PTB add - drive letters */
      atomic_t maxreqblks;                 /* PTB add - maximum req size seen */
      int max_sectors;                     /* PTB add - max req size allowed! */
      int lives;                           /* PTB add - # times enabled */
      atomic_t seqno_in;                   /* PTB add - wreq sequence number */
      // PTB speed measurement settings
      struct nbd_speed tspeed;
      struct nbd_speed wspeed;
      struct nbd_speed rspeed;
      atomic_t frstj;                      /* PTB add - first jiffies */
      int speed_lim;                       /* PTB add - speed_lim in KB/s */
      struct request req;                  /* PTB fake request for ioctls */
      wait_queue_head_t req_wq;
      char  ctldta[4*4];                   /* PTB ioctl data buffer */
    };

#endif  /* MAJOR_NR */



/* Pavel - This now IS in some kind of include file...	*/

/* PTB 132 */ 
#define NBD_INIT_MAGIC 0x12345678       /* AMARIN */
#define NBD_REQUEST_MAGIC 0x25609513
#define NBD_REPLY_MAGIC 0x67446698     
/* Pavel - Do *not* use magics: 0x12560953 0x96744668. 
 */

#define NBD_DEV_MAGIC 0x68797548

#define NBD_REQUEST_MAGIC_T  __u32
#define NBD_REQUEST_TYPE_T   __u32
#define NBD_HANDLE_LENGTH    sizeof(void*)      /* PTB number of bytes */
#define NBD_REQUEST_FROM_T   __u64
#define NBD_REQUEST_LEN_T    __u32
#define NBD_REQUEST_FLAGS_T  __u32
#define NBD_REQUEST_TIME_T   struct timeval
#define NBD_REQUEST_ZONE_T   struct timezone
#define NBD_REQUEST_SPECIAL_T  __u32

#define NBD_REPLY_MAGIC_T    __u32
#define NBD_REPLY_ERROR_T    __s32
#define NBD_REPLY_FLAGS_T    __u32
#define NBD_REPLY_TIME_T     struct timeval
#define NBD_REPLY_ZONE_T     struct timezone

typedef char nbd_handle_t[NBD_HANDLE_LENGTH];

#define NBD_REQUEST_HANDLE_T nbd_handle_t
#define NBD_REPLY_HANDLE_T   nbd_handle_t

  typedef __u32 nbd_digest_t[4];
  typedef __u32 nbd_ctldta_t[4];

  #define NBD_DIGEST_T   nbd_digest_t
  #define NBD_CTLDTA_T   nbd_ctldta_t

#define NBD_REQUEST_DIGEST_T nbd_digest_t
#define NBD_REPLY_DIGEST_T   nbd_digest_t

#define NBD_REQUEST_CTLDTA_T   NBD_CTLDTA_T
#define NBD_REPLY_CTLDTA_T   NBD_CTLDTA_T

#define NBD_DIGEST_BITS      128
#define NBD_DIGEST_LENGTH    ((NBD_DIGEST_BITS)/8)
#define NBD_CTLDTA_LENGTH    (128/8)
#define NBD_REQUEST_SEQNO_T  __u32

struct nbd_request {
  NBD_REQUEST_MAGIC_T  magic;
  NBD_REQUEST_TYPE_T   type;			/* == READ || == WRITE 	*/
  NBD_REQUEST_HANDLE_T handle;
  NBD_REQUEST_FROM_T   from;                    /* 64 bit PTB 132 */
  NBD_REQUEST_LEN_T    len;



#define NBD_REQUEST_ERRORED    0x0800
#define NBD_REQUEST_MD5SUM     0x8000         /* has a digest in it ..*/
#define NBD_REQUEST_MD5_OK    0x10000         /* .. and equaled req's */
#define NBD_REQUEST_IOCTL     0x40000         /* ioctl in len, arg in from */
  NBD_REQUEST_FLAGS_T  flags;
  NBD_REQUEST_TIME_T   time;
  NBD_REQUEST_ZONE_T   zone;
  NBD_REQUEST_SEQNO_T  seqno;
  union {
       NBD_REQUEST_DIGEST_T digest;
       NBD_REQUEST_CTLDTA_T ctldta;
  } data;
  NBD_REQUEST_SPECIAL_T special;
  char dummy[0] __attribute__ ((aligned (64)));
} __attribute__ ((packed)) ;

  #define NBD_REQUEST_LENGTH sizeof(struct nbd_request)

struct nbd_reply {
  NBD_REPLY_MAGIC_T    magic;
  NBD_REPLY_ERROR_T    error;		      /* 0 = ok, else error	*/
  NBD_REPLY_HANDLE_T   handle;	              /* handle you got from request */



#define NBD_REPLY_ERRORED      0x0800
#define NBD_REPLY_MD5SUM       0x8000         /* has a digest in it .. */
#define NBD_REPLY_MD5_OK      0x10000         /* .. and equaled req's  */
#define NBD_REPLY_CLOSE       0x20000         /* close cmd from server */
#define NBD_REPLY_IOCTL       0x40000         /* ioctl in len, arg in from */
  NBD_REPLY_FLAGS_T    flags;
  NBD_REPLY_TIME_T     time;
  NBD_REPLY_ZONE_T     zone;
  union {
       NBD_REPLY_DIGEST_T digest;
       NBD_REPLY_CTLDTA_T ctldta;
  } data;
  char dummy[0] __attribute__ ((aligned (64)));
} __attribute__ ((packed)) ;

  #define NBD_REPLY_LENGTH sizeof(struct nbd_reply)

  #define NBD_BUFFER_DATA_OFFSET \
   ((NBD_REQUEST_LENGTH>NBD_REPLY_LENGTH)?NBD_REQUEST_LENGTH:NBD_REPLY_LENGTH)

#endif /* LINUX_ENBD_H */


