#include <linux/enbd.h>
#include <linux/enbd_ioctl.h>

/*
 * PTB small driver wide support database for MDRGTR ioctl
 */



#ifndef HOT_ADD_DISK
  #define HOT_ADD_DISK          _IO (MD_MAJOR, 0x28)
#endif
#ifndef SET_DISK_FAULTY
  #define SET_DISK_FAULTY       _IO (MD_MAJOR, 0x29)
#endif

static void
enbd_md_dec (struct enbd_md *md) {
        down(&md->access_sem);
        if (--md->count <= 0)
                md->notify_fn = NULL;
        up(&md->access_sem);
}
static void
enbd_md_inc (struct enbd_md *md) {
        down(&md->access_sem);
        md->count++;
        up(&md->access_sem);
}
static void
enbd_md_reg (struct enbd_md *md, int(*fn)(kdev_t, int)) {
        down(&md->access_sem);
        if (!md->notify_fn) {
                md->notify_fn = fn;
                md->count++;
        }
        up(&md->access_sem);
}

/*
 * PTB tell md devices in which we are embedded that we are alright
 *
 *   @lo the nbd device to tell them about
 */
static int
enbd_notify_md_devices (struct enbd_md *md, kdev_t enbd_dev)
{
	//kdev_t enbd_dev = mk_kdev (major, nbd << ENBD_SHIFT);
        int err;

	down (&md->access_sem);
	if (md->count > 0 && md->notify_fn) {
		ENBD_ALERT ("adding %x:%x to raid devices via fn\n",
                        major(enbd_dev), minor(enbd_dev));
		err = md->notify_fn (enbd_dev, HOT_ADD_DISK);
		if (err < 0) {
			ENBD_ALERT ("HOT_ADD to raid devices returned %d\n",
                                err);
		}
	}
	up (&md->access_sem);

	return 0;
}

static int
enbd_unnotify_md_devices (struct enbd_md *md, kdev_t enbd_dev)
{

	// kdev_t enbd_dev = mk_kdev (major, lo->nbd << ENBD_SHIFT);
        int err;

	down (&md->access_sem);
	if (md->count > 0 && md->notify_fn) {
		ENBD_ALERT ("erasing %x:%x from raid devices via fn\n",
			   major(enbd_dev), minor(enbd_dev));
		err = md->notify_fn (enbd_dev, SET_DISK_FAULTY);
		if (err < 0) {
			ENBD_ALERT
			 ("SETFAULTY to raid devices returned %d\n", err);
		}
	}
	up (&md->access_sem);
        return 0;
}

void
enbd_init_md(struct enbd_md *md)
{
        md->notify_fn = NULL;
        md->count = 0;
        init_MUTEX(&md->access_sem);
        md->notify = enbd_notify_md_devices;
        md->unnotify = enbd_unnotify_md_devices;
        md->dec = enbd_md_dec;
        md->inc = enbd_md_inc;
        md->reg = enbd_md_reg;
}

