#include <linux/enbd.h>


#define _NBD_GENERATION (8*sizeof(int) - __REQ_NBDSEQNO)
/*
 * PTB increment the devices seqno
 *
 *  @lo the nbd device to increment the seqno of
 */
static void
seqno_inc(struct enbd_seqno *nseqno)
{
	if (nseqno->seqno < (1 << _NBD_GENERATION)) {
		++nseqno->seqno;
                return;
        } 
        // PTB next generation !
	nseqno->seqno = 0;
	atomic_inc (&nseqno->seqno_gen);
}
static int
seqno_get (struct enbd_seqno *nseqno)
{
        return nseqno->seqno;
}
static void
seqno_reset (struct enbd_seqno *nseqno)
{
        nseqno->seqno = 0;
	atomic_set(&nseqno->seqno_gen,0);
}
/*
 * PTB convert a seqno number into one with an extra generation number
 * in the msb, so that it can be compared with others. return the
 * result.
 *
 * We add the current generation no. to small seqnos, and we add the
 * previous generation no. to large seqnos.
 *
 *   @lo the nbd device to look at
 *   @seqno the small sequence number to return the full seq number for
 */
static unsigned int
seqno_calc (struct enbd_seqno *nseqno, unsigned int seqno)
{
        unsigned int genno;
        static unsigned int absdiff(unsigned int x, unsigned int y) {
            if (x > y) {
                return x - y;
            } else {
                return y - x;
            }
        };
        genno = atomic_read (&nseqno->seqno_gen);
	if (absdiff(seqno,nseqno->seqno) < (1 << (_NBD_GENERATION - 1))) {
		return seqno + (genno << _NBD_GENERATION);
	}
        if (seqno < nseqno->seqno) {
		return seqno + ((genno + 1) << _NBD_GENERATION);
        } 
        return seqno + ((genno - 1) << _NBD_GENERATION);
}

void enbd_init_seqno (struct enbd_seqno *nseqno) {

        seqno_reset(nseqno);

        nseqno->inc   = seqno_inc;
        nseqno->get   = seqno_get;
        nseqno->reset = seqno_reset;
        nseqno->calc  = seqno_calc;
}



