#include <linux/enbd.h>
#include <linux/enbd_ioctl.h>

/*
 * PTB - update speed counters (if at least 5s has passed)
 *
 *  @spd the speed struct to update
 */
static void
spd_update (struct enbd_speed *spd, int distance)
{

	// last time we measured
	int lastjiffy = atomic_read (&spd->jiffy);
	// jiffies since last time
	int djiffy = jiffies - lastjiffy;

	// previous no we measured
	int lastdist = atomic_read (&spd->distance);
	// blocks since last time
	int ddistance = distance - lastdist;

	// write every 5 second in time
	if (djiffy > 5 * HZ) {

		// jiffies since first time
		int tjiffy = jiffies - atomic_read (&spd->frstj);

		// max tot speed measured so far
		int speedmax = atomic_read (&spd->speedmax);

		// last instantaneous speed we measured
		int lastspeed = atomic_read (&spd->speed);

		// instantaneous read blocks/s
		int speed = djiffy ? (ddistance * HZ) / djiffy : 0;

		// smoothed KB/s
		int speedsmoothed =
		 (djiffy * speed + HZ * lastspeed) / (djiffy + HZ);

		// average speed to now in KB/s
		int speedav = tjiffy ? (distance * HZ) / tjiffy : 0;

		// smoothing count for max
		int speedhi =
		 (speedav > speedsmoothed) ? speedav : speedsmoothed;

		// doing settings
		atomic_set (&spd->speed, speedsmoothed);
		if (speedhi > speedmax)
			atomic_set (&spd->speedmax, speedhi);
		atomic_set (&spd->distance, distance);
		atomic_set (&spd->speedav, speedav);
		atomic_set (&spd->jiffy, jiffies);
	}
}

void
enbd_init_speed(struct enbd_speed *spd) {
        memset(spd, 0, sizeof(*spd));
        spd->update = spd_update;
}

