/* 
 * Copyright (C) 1999-2001 Peter T. Breuer <ptb@it.uc3m.es>
 */


#include <stdlib.h>
#include "db.h"

/* 
 * for small dbs. A simple list.
 */

   /*
    * find an entry by name
    */
   static int lookup(struct nbd_db * self, void *nam, void **val) {
      int i;
      if (!nam)
        return -1;
      for (i = 0; i < self->count; i++) {
        if (self->contents[i].nam == nam) {
          if (val)
            *val = self->contents[i].val;
          return i;
        }
      }
      return -1;
   }

   /*
    * add an entry by name with value
    */
   static int add(struct nbd_db * self, void *nam, void *val) {
      struct dbentry entry    = { nam: nam, val: val };
      int i = self->lookup(self,nam,NULL);

      if (i >= 0) {
        // the case where there is a prior entry
        self->contents[i].val = val;
        return i;
      }

      // the case where there wasn't a prior entry
      if (self->nent >= self->max)
           return -1;

      if (self->count >= self->max) {

           if (self->erased <= 0)
             return -1;

           // have to look for an erased space
           for (i = 0; i < self->max; i++) {
             if (!self->contents[i].nam)
               break;
           }

           if (i >= self->max)
             return -1; // impossible

           self->erased--;
      } else {
          // use a new space
          i = self->count++;
      }

      self->contents[i] = entry;
      self->nent++;
      return i;
   }

   /*
    * delete an entry by name
    */
   static int del(struct nbd_db * self, void *nam) {
      int i = self->lookup(self,nam,NULL);
      if (i < 0) {
        return i;
      }
      self->contents[i].nam = NULL;
      self->erased++;
      self->nent--;

      if (i == self->count - 1) {
         self->count--;
         self->erased--;
      }
      return i;
   }

   /*
    * compact the database
    */
   static void norm(struct nbd_db * self) {
      int i, j;
      j = i = 0;
      while (i < self->count) {
        if (!self->contents[i].nam)
          continue;
        if (j != i) 
          self->contents[j] = self->contents[i];
        j++;
      }
      self->count  = j;
      self->erased = 0;
   }

   /*
    * jump to entry after i
    */
   static int next(struct nbd_db * self, int i, void **nam, void **val) {

      while (++i < self->count) {
        if (!self->contents[i].nam)
          continue;
        if (nam)
          *nam = self->contents[i].nam;
        if (val)
          *val = self->contents[i].val;
        return i;
      }
      return -1;
   }

   /*
    * find first real entry 
    */
   static int first(struct nbd_db * self, void **nam, void **val) {
      return self->next(self,-1,nam,val);
   }

   /*
    * count real entries
    */
   static int size(struct nbd_db * self) {
      // this should be nent
      return self->count - self->erased;
   }

   int init_db(struct nbd_db * self, int max) {
      self->contents = calloc(max,sizeof(struct dbentry));
      if (!self->contents)
        return -1;
      self->max    = max;
      self->count  = 0;
      self->erased = 0;
      self->nent   = 0;

      self->lookup = lookup;
      self->add    = add;
      self->del    = del;
      self->norm   = norm;
      self->next   = next;
      self->first  = first;
      self->size   = size;
      return 0;
   }

