/* 
 * Copyright (C) 1999-2001 Peter T. Breuer <ptb@it.uc3m.es>
 */

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <syslog.h>
#include <stdarg.h>
#include <string.h>
#include <sys/time.h>
#include <sys/errno.h>
#include <netinet/in.h>
//#include <linux/fs.h> // PTB for BLKSSZGET
#include <sys/mount.h>  // PTB for BLKSSZGET
#include <linux/enbd.h>

#define ISSERVER
#define MY_NAME "nbd/fileserver"
#include "cliserv.h"
#include "file.h"

#ifdef USING_SSL
#include "sslincl.h"
#endif

#include "stream.h"
#include "server_stub.h"
#include "pidfile.h"
#include "enbd-client.h"
#include "ioctl.h"

   static int
   writefile(struct nbd_stub_server * self, char * buf, int len, s64 from) {
       struct nbd_file * file = (struct nbd_file *)self->media;
       DEBUG("writefile write at sector %Ld\n", from >> 9);
       return file->write(file, buf,len,from);
   }

   static int
   readfile(struct nbd_stub_server * self, char * buf, int len, s64 from) {

       int tot = 0;
       struct nbd_file * file = (struct nbd_file *)self->media;

       DEBUG("read at sector %Ld\n", from >> 9);

       tot = file->read(file,buf,len,from);
       if (tot >= len) {
         DEBUG("readfile returns OK %d\n", tot);
         return tot; // ? or return len
       }

       DEBUG("readfile returns FAIL %d\n", tot);
       return tot;
   }


   static int
   checkfile(struct nbd_stub_server * self) {

       struct nbd_file * file = (struct nbd_file *)self->media;

       file->close(file);
       if (file->open(file) < 0)
              return -EBADF;
       file->close(file);
       file->flags |= F_OPENWANTED;
       return 0;
   }

   static int
   syncfile(struct nbd_stub_server * self, unsigned dummy) {
            struct nbd_file * file = (struct nbd_file *)self->media;
            return file->sync(file);
   }

   static int
   specialfile(struct nbd_stub_server * self, int rw, int len, u64 from) {
            //struct nbd_file * file = (struct nbd_file *)self->media;
            //return file->lockall(file, rw);
            return len;
   }

   static int
   ioctlfile(struct nbd_stub_server *self, int ioctl, char *arg) {
            struct nbd_file * file = (struct nbd_file *)self->media;
            int err;
            ioctl = nbd_ioctl_revert(ioctl);
            if (ioctl == -1) {
                return err = -EINVAL;
            }
            DEBUG("trying ioctl %#x arg %#x data %d\n", ioctl, (unsigned)arg,
                    *(int *)arg);
            // PTB some stuff is for testing purposes only, and we want
            // to intercept it now!
            switch (ioctl) {
                static long intval;
                static char cbuf[256];
                char tbuf[256];
                long tintval; int j;

                case ENBD_TEST_IOCTL1:
                    DEBUG("received TEST IOCTL1, read W arg %#x\n",
                            (unsigned)arg);
                    intval = (unsigned long)arg;
                    return 0;
                case ENBD_TEST_IOCTL2:
                    *(unsigned long *)arg = intval;
                    DEBUG("received TEST IOCTL2, writing R arg %p to %p\n",
                            (void *)intval, arg);
                    return 0;
                case ENBD_TEST_IOCTL3:
                    intval  = *(unsigned long*)arg;
                    tintval = ~intval;
                    DEBUG("received TEST IOCTL3, read %#x, writing WR arg %#x\n",
                            intval,
                            tintval
                            );
                    *(int *)arg = tintval;
                    return 0;
                case ENBD_TEST_IOCTL4:
                    DEBUG("received TEST IOCTL4, writing R 256B  %#x..\n", 
                            *(unsigned*)&cbuf[0]);
                    memcpy(arg, cbuf, 256);
                    return 0;
                case ENBD_TEST_IOCTL5:
                    memcpy(cbuf, arg, 256);
                    for (j = 0; j < 256; j += sizeof(int)) {
                        *(int*)&tbuf[j] = ~ *(int*) &arg[j];
                    }
                    DEBUG("received TEST IOCTL5, read %#x.., wrote WR 256B %#x\n",
                            *(unsigned *) cbuf,
                            *(unsigned *) tbuf);
                    memcpy(arg, tbuf, 256);
                    return 0;
                case ENBD_TEST_IOCTL6:
                    return -EINVAL;
                case ENBD_TEST_IOCTL7:
                    return -EINVAL;
            }

            // PTB this is the generic case:
            err = file->ioctl(file, ioctl, arg);

            if (err < 0) {
                // PTB in certain cases fixup answer too
                switch(ioctl) {
                }
            }

            return err;
   }

/*
   static s64
   seekfile(struct nbd_stub_server *self, s64 offset, int whence) {
       int fd;
       switch(whence) {
           case SEEK_SET:
             break;
           case SEEK_CUR:
             offset += lastpoint;
             break;
           case SEEK_END:
             offset = self->size - offset;
             break;
           default:
             return -1;
             break;
       }
      fd = file->seek(file,offset,SEEK_SET);
      if (fd < 0)
         return -1;
      return offset;
   }
*/

void
init_fileserver(struct nbd_stub_server *self, short i,
     s64 size, void *file, short ro, void *alternate) {
       self->media = file;
       self->size  = size;
       self->flags = 0;
       self->i     = i;
       self->altmedia
                   = alternate;
       self->write = writefile;
       self->read  = readfile ;
       self->check = checkfile;
       self->sync  = syncfile;
       self->ioctl = ioctlfile;
       self->special
                   = specialfile;
       //self->seek  = seekfile;
       self->magic = ENBD_CLIENT_CACHE_FILEMAGIC;
}

