#ifndef NBD_LOCK_H
#define NBD_LOCK_H 1

#define NBD_LOCK_UDELAY  10000  /* 10ms */
#define NBD_LOCK_UDMAX 1000000  /* 1s   */

#define USE_FCNTL_LOCK 1

struct nbd_lock {
    // PTB the following field is not needed if fcntl is used
    //     and causes compile difficulties for debian
#ifdef USE_FCNTL_LOCK 
    long count;
#else
    atomic_t count;
#endif
    void (*down)(struct nbd_lock *);
    void (*up)(struct nbd_lock *);
    int (*try)(struct nbd_lock *);
#ifdef USE_FCNTL_LOCK 
    int dummy;
    int mfd; // file descriptor for fcntl of mmapped area
    int off; // offset of this struct in mmap
#else
    int fd[2]; // used if fcntl is not used
    int err; // used if fcntl is not used
#endif
};


struct nbd_rwlock {
    struct nbd_lock lock;
    unsigned int writers;
    unsigned int readers;
    void (*down_write)(struct nbd_rwlock *);
    void (*up_write)(struct nbd_rwlock *);
    int (*try_write)(struct nbd_rwlock *);
    void (*down_read)(struct nbd_rwlock *);
    void (*up_read)(struct nbd_rwlock *);
    int (*try_read)(struct nbd_rwlock *);
#ifdef USE_FCNTL_LOCK 
    int dummy;
    int mfd; // file descriptor for fcntl of mmapped area
    int off; // offset of this struct in mmap
#else
    int fd[2]; // used if fcntl is not used
    int err; // used if fcntl is not used
#endif
};


void init_lock (struct nbd_lock *m, int mfd, int off);
void init_rwlock (struct nbd_rwlock *m, int mfd, int off);


#endif
