
#ifndef NBD_SHMEM_H
#define NBD_SHMEM_H 1

#define NBD_SHMEM_REQ_STARTED   1
#define NBD_SHMEM_REQ_DONE      2
#define NBD_SHMEM_REQ_ERROR     4

  struct nbd_shmem {
      unsigned seqno;
      struct nbd_lock lock;
      unsigned pending;
      int (*wait_seqno_timeout)(struct nbd_shmem *data, unsigned seqno, unsigned mdelay);
      void (*update_seqno) (struct nbd_shmem *data, unsigned seqno);
      int fd[2];
      int err;
#define NBD_SHMEM_CACHE         8
      unsigned long flags;
      int signals;
      struct timeval tv;
      int (*lock_req)(struct nbd_shmem *data, u32 handle, unsigned seqno, unsigned mtimeout);
      int (*unlock_req)(struct nbd_shmem *data, u32 handle, unsigned seqno);
      int size;
      int mfd;    // file descriptor for underlying file
      int off;    // offset of this region from file beginning
      struct nbd_hash hash;
      int dummy[0] __attribute__ ((aligned(8192)));
  };
  void init_shmem(struct nbd_shmem *m, int size, int mfd, int off, int cache_lim);

#endif
