/* 
 * Copyright (C) 1999-2001 Peter T. Breuer <ptb@it.uc3m.es>
 */

#ifndef ENBD_STREAM_H
#define ENBD_STREAM_H 1

struct nbd_stream {
    # define ENBD_STREAM_MAGIC 0x1415abca
    unsigned long magic;
    int sock;
    int port;
    char * hostname;
    int timeout;
    int (*read)(struct  nbd_stream * self, char *buf, int size);
    int (*write)(struct nbd_stream * self, char *buf, int size);
    int (*close)(struct nbd_stream * self);
    int (*open)(struct nbd_stream * self, int port, char * hostname);
    int (*reopen)(struct nbd_stream * self);
    //s64 (*seek)(struct nbd_stream * self, s64 offset, int whence);
#ifdef USING_SSL
    SSL * con;
    SSL_CTX **ctx;
#endif
    int errs;
#define ENBD_STREAM_INITIALIZED 0x01
#define ENBD_STREAM_OPEN        0x02
#define ENBD_STREAM_NONBLOCK    0x04
    unsigned long flags;
    int (*clear)(struct nbd_stream * self);
};

int
#ifdef USING_SSL
initstream(struct nbd_stream *self, int timeout, SSL_CTX **ctx);
#else
initstream(struct nbd_stream *self, int timeout, void *dummy);
#endif

#endif
