#include <stdio.h>
#include <unistd.h>		/* get/setpgid stuff */
#include <syslog.h>
#include <sys/time.h>

//#include <linux/enbd.h>
#include <netinet/in.h>


#define MY_NAME "nbd/time"
#include "cliserv.h"
#include "time.h"


/* 
 * track and compensate for systime step changes
 */
int mygettimeofday(struct timeval *tv, struct timezone *tz) {
        static struct timeval last_tv;
        static struct timeval offset;
        int res = gettimeofday(tv, tz);
        if (tv) {
            if (offset.tv_sec > 0 || offset.tv_usec > 0) {
                timeradd(tv, &offset, tv);
            }
            if (timercmp(tv, &last_tv, <)) {
                static struct timeval extra_offset;
                timersub(&last_tv, tv, &extra_offset);
                PERR("time went backwards %ld+%ld/10^6 s\n",
                        extra_offset.tv_sec, extra_offset.tv_usec);
                if (extra_offset.tv_sec < 0) {
                        PERR("time was %ld+%ld/10^6 s and is %ld+%ld/10^6 s\n",
                                last_tv.tv_sec, last_tv.tv_usec,
                                tv->tv_sec, tv->tv_usec);
                }
                timeradd(&offset, &extra_offset, &offset);
                *tv = last_tv;
                // PTB step 1us forward if we don't know any better
                if (++tv->tv_usec >= 1000000) {
                    tv->tv_usec -= 1000000;
                    tv->tv_sec ++;
                }
            }
            last_tv = *tv;
        }
        return res;
}

