#include "encompass.h"
#include <gtkhtml/htmlengine.h>
#include <gtkhtml/htmlobject.h>
#include <gtkhtml/htmlimage.h>
#include <gtkhtml/htmllinktext.h>
#include <gtkhtml/htmlselection.h>
#include <gtkhtml/htmlselect.h>

typedef struct {
  BrowserWindow * window;
  gchar * url;
} RedirectURLInfo;

static gboolean encompass_url_redirect_delayed (RedirectURLInfo * info) {

  encompass_goto_url (info->window, info->url, 0);
  g_free (info->url);

  return FALSE;
}

void encompass_url_redirect (GtkHTML * html, const gchar * url,
			     gint delay, BrowserWindow * window) {
  RedirectURLInfo * info;

  g_return_if_fail (url != NULL);

  info = g_new0 (RedirectURLInfo, 1);

  info->window = window;
  info->url = g_strdup (url);

  gtk_timeout_add (delay * 1000,
		   (GtkFunction) encompass_url_redirect_delayed, info);
		   
}

void encompass_url_hover (GtkHTML * html, const gchar * url,
			  BrowserWindow * window) {
  if (url) {
    gnome_appbar_set_status (GNOME_APPBAR (window->status), url);
  } else {
    gnome_appbar_set_status (GNOME_APPBAR (window->status), "");
  }
}

void encompass_title_changed (GtkHTML * html, const gchar * title,
			      BrowserWindow * window) {
  gchar * s;
  s = g_strconcat ("Encompass: ", title, NULL);
  gtk_window_set_title (GTK_WINDOW (window->window), g_strdup (s));
  g_free (s);
}

void encompass_load_home_page (GtkWidget * widget, BrowserWindow * window) {
  gchar * blah;

  blah = g_strconcat (g_get_home_dir (), "/public_html/index.html", NULL);
  if (g_file_exists (blah)) {
    encompass_goto_url (window, encompass_parse_url (blah, window->base), 0);
  }
  g_free (blah);
}

void encompass_url_requested (GtkHTML * html, const gchar * url,
			      GtkHTMLStream * handle, BrowserWindow * window) {
  EncompassURI * uri;

  encompass_set_referer (window);
  uri = encompass_uri_new (encompass_parse_url ((gchar *)url, window->base));
  if (!strcasecmp (uri->protocol, "file")) {
    encompass_load_file (window, uri, handle);
  } else if (!g_strcasecmp (uri->protocol, "http") ||
	     !g_strcasecmp (uri->protocol, "https")) {
    encompass_http_load_url (window, uri, handle, FALSE, "");
  } else {
    printf ("%s\n", url);
  }
}

void encompass_submit_form (GtkHTML *html, const gchar *method,
			    const gchar *action, const gchar *encoding,
			    BrowserWindow * window) {
  EncompassURI * uri;

  if (!g_strcasecmp (method, "GET")) {
    gchar * blah;
    if (action != NULL && *action) {
      blah = g_strconcat (action, "?", encoding, NULL);
    } else {
      blah = g_strconcat (encompass_uri_to_string (window->base), "?",
			  encoding, NULL);
    }
    encompass_goto_url (window, encompass_parse_url (blah, window->base), 0);
    g_free (blah);
  } else if (!g_strcasecmp (method, "POST")) {
    gchar * realurl;

    if (action != NULL && *action) {
      realurl = encompass_parse_url ((gchar *)action, window->base);
    } else {
      gchar * tmpurl = encompass_uri_to_string (window->base);
      realurl = encompass_parse_url (tmpurl, window->base);
      g_free (tmpurl);
    }
    
    uri = encompass_uri_new (realurl);

    window->handle = gtk_html_begin (html);
    encompass_http_load_url (window, uri, window->handle,
			     TRUE, (gchar *) encoding);
    g_free (realurl);
  } else {
    g_warning ("Encompass: Unsupported submit method '%s'\n", method);
  }
}

gboolean encompass_button_pressed (GtkWidget * widget, GdkEventButton * event,
				   BrowserWindow * window) {

  if (event->type == GDK_BUTTON_PRESS) {
    if (event->button == 2) {
      HTMLObject * object;
      guint offset;

      object = html_engine_get_object_at (GTK_HTML (window->html)->engine,
					  event->x + GTK_HTML (window->html)->engine->x_offset,
					  event->y + GTK_HTML (window->html)->engine->y_offset,
					  &offset, FALSE);

      if (object != NULL && (GTK_HTML (window->html)->pointer_url
	  || (HTML_OBJECT_TYPE (object) == HTML_TYPE_IMAGE
	      && html_object_get_url (object)))) {
	gchar * url = g_strdup (GTK_HTML (window->html)->pointer_url);

	encompass_create_window (NULL,
				 encompass_parse_url (url, window->base));
	g_free (url);
      }
    } else if (event->button == 3) {
      encompass_menu_popup (event, window);
    }
  }
  return FALSE;
}

void encompass_set_referer (BrowserWindow * window) {
  if (window->referer == NULL) {
    window->referer = encompass_uri_dup (window->base, ENCOMPASS_URI_DUP_ALL);
  } else {
    encompass_uri_destroy (window->referer);
    window->referer = encompass_uri_dup (window->base, ENCOMPASS_URI_DUP_ALL);
  }
}

void encompass_set_base (GtkHTML * html, const gchar * url,
			 BrowserWindow * window) {
  gtk_entry_set_text (GTK_ENTRY (window->entry), url);
  if (window->base == NULL) {
    window->base = encompass_uri_new (url);
  } else {
    encompass_set_referer (window);
    encompass_uri_destroy (window->base);
    window->base = encompass_uri_new (url);
  }
}

void encompass_link_clicked (GtkHTML * html, const gchar * url,
			     BrowserWindow * window) {
  g_return_if_fail (html != NULL);
  g_return_if_fail (url != NULL);

  encompass_goto_url (window, encompass_parse_url ((gchar *) url,
						   window->base), 0);
}

void encompass_refresh (GtkWidget * widget, BrowserWindow * window) {
  gtk_widget_draw (window->html, NULL);
}

void encompass_load_done (GtkWidget * widget, BrowserWindow * window) {
  gtk_widget_grab_focus (window->html);
}
