#include "encompass.h"

static void help_about_callback (GtkWidget *widget, void *data) {
  static GtkWidget *about = NULL;
  GdkPixbuf * pixbuf = NULL;
  gchar * iconame;
  const gchar *authors[] = {
    "Rodney Dawes <dobey@free.fr>",
    NULL
  };
  const gchar * documentors[] = {
    "Kevin Breit <battery841@mypad.com>",
    "Jan Van Buggenhout <chipzz@ulyssis.org>",
    "Francis Tyers <fran@thinkgeek.co.uk>",
    NULL
  };

  if (about != NULL) {
    gdk_window_raise (about->window);
    gdk_window_show (about->window);
    return;
  }

  iconame = elysium_pixmap_file ("encompass/encompass-logo.png");
  pixbuf = gdk_pixbuf_new_from_file (iconame, NULL);
  about = gnome_about_new ("Encompass",
			   VERSION,
			   /* copyright notice */
			   "Copyright 1999-2003 (C) Elysium GNU/Linux",
			   /* other comments */
			   _("A Web browser for the GNOME desktop."),
			   authors, documentors, NULL, pixbuf);

  gdk_pixbuf_unref (pixbuf);
  g_free (iconame);

  gtk_signal_connect(GTK_OBJECT(about), "destroy",
		     GTK_SIGNAL_FUNC(gtk_widget_destroyed), &about);
  gtk_widget_show (about);
  
  return;
}

static GnomeUIInfo file_menu[] = {
  {
    GNOME_APP_UI_ITEM, N_("_New Window"),
    N_("Open a new Browser Window"),
    encompass_create_window, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
    'N', GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  /*
  {
    GNOME_APP_UI_ITEM, N_("_Print"),
    N_("Print the current page"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PRINT,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Print P_review..."),
    N_("See what the printed page would look like"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PRINT,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  */
  {
    GNOME_APP_UI_ITEM, N_("Close _Window"),
    N_("Close the current browser window"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE,
    'W', GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("_Quit Encompass"),
    N_("Quit the Encompass Web Browser"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXIT,
    'Q', GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo edit_menu[] = {
  {
    GNOME_APP_UI_ITEM, N_("_Find in page"),
    N_("Find text in the current page"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SEARCH,
    'F', GDK_CONTROL_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Find a_gain"),
    N_("Find the next occurance of searched text"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SEARCH,
    'G', GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_PREFERENCES_ITEM(NULL, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo toolbar_menu[] = {
  GNOMEUIINFO_END
};

static GnomeUIInfo go_menu[] = {
  {
    GNOME_APP_UI_ITEM,
    N_("Back"), N_("Return to the previous page in history list"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BACK,
    GDK_Left, GDK_MOD1_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM,
    N_("Forward"), N_("Go to the next page in history list"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_FORWARD,
    GDK_Right, GDK_MOD1_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM,
    N_("Home"), N_("Go to your home page"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_HOME,
    GDK_Home, GDK_MOD1_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_END
};

static GnomeUIInfo text_menu[] = {
  GNOMEUIINFO_END
};

static GnomeUIInfo encoding_menu[] = {
  GNOMEUIINFO_END
};

static GnomeUIInfo view_menu[] = {
  GNOMEUIINFO_SUBTREE (N_("Toolbars"), toolbar_menu),
  GNOMEUIINFO_TOGGLEITEM (N_("Status Bar"), N_("Show or Hide the status bar"),
			  NULL, NULL),
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM,
    N_("Stop Loading"), N_("Stop loading the current page"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_STOP,
    GDK_Escape, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM,
    N_("Refresh"), N_("Refresh the current page"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REFRESH,
    'R', GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_SUBTREE (N_("Text Size"), text_menu),
  GNOMEUIINFO_SUBTREE (N_("Encoding"), encoding_menu),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_END
};

static GnomeUIInfo bookmarks_menu[] = {
  {
    GNOME_APP_UI_ITEM, N_("Add Bookmark"),
    N_("Add current page to your bookmarks"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Edit Bookmarks"),
    N_("Edit your bookmarks"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BLANK,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_END
};
    
static GnomeUIInfo tool_menu[] = {
  GNOMEUIINFO_END
};

static GnomeUIInfo help_menu[] = {
  /*
  GNOMEUIINFO_HELP("encompass"),
  GNOMEUIINFO_SEPARATOR,
  */
  GNOMEUIINFO_MENU_ABOUT_ITEM(help_about_callback, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo main_menu[] = {
	GNOMEUIINFO_MENU_FILE_TREE (file_menu),
	GNOMEUIINFO_MENU_EDIT_TREE (edit_menu),
	GNOMEUIINFO_MENU_VIEW_TREE (view_menu),
	GNOMEUIINFO_SUBTREE (N_("Go"), go_menu),
	GNOMEUIINFO_SUBTREE (N_("_Bookmarks"), bookmarks_menu),
	GNOMEUIINFO_SUBTREE (N_("_Tools"), tool_menu),
	GNOMEUIINFO_MENU_HELP_TREE (help_menu),
	GNOMEUIINFO_END
};

void encompass_create_menus (BrowserWindow * window) {
  gnome_app_create_menus (GNOME_APP (window->window), main_menu);
  gnome_app_install_menu_hints (GNOME_APP (window->window), main_menu);
  gtk_widget_set_sensitive(bookmarks_menu[1].widget, FALSE);
  gtk_widget_set_sensitive(tool_menu[0].widget, FALSE);

  /*
  gtk_signal_connect (GTK_OBJECT (file_menu[2].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_print_page), window);
  gtk_signal_connect (GTK_OBJECT (file_menu[3].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_print_preview), window);
  */
  gtk_signal_connect (GTK_OBJECT (file_menu[2].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_window_close), window);
  gtk_signal_connect (GTK_OBJECT (file_menu[3].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_main_quit), window);

  gtk_signal_connect (GTK_OBJECT (edit_menu[0].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_search_page), window);
  gtk_signal_connect (GTK_OBJECT (edit_menu[1].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_search_page_next), window);
  gtk_widget_set_sensitive (edit_menu[3].widget, FALSE);

  gtk_signal_connect (GTK_OBJECT (view_menu[1].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_toggle_statusbar), window);
  if (GTK_WIDGET_VISIBLE (GNOME_APP (window->window)->statusbar)) {
    GTK_CHECK_MENU_ITEM (view_menu[1].widget)->active = 1;
  }
  gtk_signal_connect (GTK_OBJECT (view_menu[3].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_http_stop), window);
  gtk_widget_set_sensitive (view_menu[3].widget, FALSE);
  gtk_signal_connect (GTK_OBJECT (view_menu[4].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_refresh), window);

  /* Bind the forward/back history menu items */
  gtk_signal_connect (GTK_OBJECT (go_menu[0].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_history_go_back), window);
  gtk_widget_set_sensitive (go_menu[0].widget, FALSE);
  gtk_signal_connect (GTK_OBJECT (go_menu[1].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_history_go_forward), window);
  gtk_widget_set_sensitive (go_menu[1].widget, FALSE);

  window->back_menu_item = go_menu[0].widget;
  window->fore_menu_item = go_menu[1].widget;
  window->go_menu_item = main_menu[3].widget;
  window->book_menu = main_menu[4].widget;
  window->stop_menu_item = view_menu[3].widget;
  
  gtk_signal_connect (GTK_OBJECT (go_menu[2].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_load_home_page), window);

  encompass_context_menu_init (window);
}

void encompass_set_back_buttons (BrowserWindow * window, gboolean sense) {
  gtk_widget_set_sensitive (window->back_tool_item, sense);
  gtk_widget_set_sensitive (window->back_menu_item, sense);
  gtk_widget_set_sensitive (window->back_pop_item, sense);
}

void encompass_set_fore_buttons (BrowserWindow * window, gboolean sense) {
  gtk_widget_set_sensitive (window->fore_tool_item, sense);
  gtk_widget_set_sensitive (window->fore_menu_item, sense);
  gtk_widget_set_sensitive (window->fore_pop_item, sense);
}

void encompass_go_menu_append (BrowserWindow * window, GtkWidget *widget) {
  gtk_menu_append(GTK_MENU(GTK_MENU_ITEM(window->go_menu_item)->submenu),
		  widget);
}
