#include "encompass.h"

static GNOME_Encompass_Shell * shell = NULL;

void encompass_main_quit (GtkWidget * widget, BrowserWindow * window) {
  g_hash_table_foreach_remove (ECerts, (GHRFunc) e_free_certs, window);

  gnome_vfs_shutdown ();
  ne_sock_exit ();

  g_object_unref (cookies);
  bonobo_main_quit ();
}

static gint encompass_idle_cb (void * data) {
  GSList * uri_list;
  GNOME_Encompass_Shell corba_shell;
  CORBA_Environment ev;
  gboolean restored;

  CORBA_exception_init (&ev);

  uri_list = (GSList *) data;
  num_wins = 0;

  shell = encompass_shell_new ();
  if (shell == NULL) {
    corba_shell =
      bonobo_activation_activate_from_id ("OAFIID:GNOME_Encompass_Shell",
					  0, NULL, &ev);
    if (ev._major != CORBA_NO_EXCEPTION || corba_shell == CORBA_OBJECT_NIL) {
      CORBA_exception_free (&ev);
      g_error ("Couldn't initialize the Encompass Shell.\n");
      bonobo_main_quit ();
      return FALSE;
    }
    restored = FALSE;
  } else {
    if (uri_list == NULL) {
      restored = TRUE;
    } else {
      restored = FALSE;
    }

    corba_shell = bonobo_object_corba_objref (BONOBO_OBJECT (shell));
    corba_shell = CORBA_Object_duplicate (corba_shell, &ev);
    Bonobo_Unknown_ref (corba_shell, &ev);
    ECerts = g_hash_table_new (NULL, g_str_equal);
    cookies = e_cookies_new ();
  }

  if (uri_list == NULL) {
    GNOME_Encompass_Shell_handleURI (corba_shell, "", &ev);
  } else {
    GSList * p;

    for (p = uri_list; p != NULL; p = p->next) {
      gchar * uri;

      uri = encompass_validate_uri ((gchar *) p->data);
      GNOME_Encompass_Shell_handleURI (corba_shell, uri, &ev);
    }
    g_slist_free (p);
  }

  g_slist_free (uri_list);
  CORBA_exception_free (&ev);

  if (shell == NULL) {
    bonobo_main_quit ();
  }
  return FALSE;
}

int main (int argc, char ** argv) {
  CORBA_Environment ev;
  CORBA_ORB orb;
  GnomeProgram * encompass;
  GSList * uri_list = NULL;
  poptContext ctx;
  const gchar ** args;
  GError  *gconf_error  = NULL;
  GValue context = { 0 };
  gchar * encdir;

  CORBA_exception_init (&ev);

  bindtextdomain (GETTEXT_PACKAGE, GNOMELOCALEDIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);

  encompass = gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
				  argc, argv, GNOME_PARAM_POPT_TABLE,
				  NULL, NULL);

  g_object_get_property (G_OBJECT (encompass), GNOME_PARAM_POPT_CONTEXT,
			 g_value_init (&context, G_TYPE_POINTER));
  ctx = g_value_get_pointer (&context);

  if (!bonobo_activation_is_initialized ()) {
    orb = bonobo_activation_init (argc, argv);
  } else {
    orb = bonobo_activation_orb_get ();
  }

  if (!gconf_init (argc, argv, &gconf_error)) {
    g_assert (gconf_error != NULL);
    g_error ("GConf init failed:\n  %s", gconf_error->message);
    return FALSE;
  }

  gnome_vfs_init ();

  gdk_rgb_init ();
  gtk_widget_set_default_colormap (gdk_rgb_get_cmap ());
  gtk_widget_set_default_visual (gdk_rgb_get_visual ());
  ne_sock_init ();

  encdir = gnome_util_home_file ("encompass.d");
  if (!g_file_test (encdir, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR)) {
    mkdir (encdir, 0755);
  }
  g_free (encdir);

/*  ne_debug_init (stderr, NE_DBG_HTTP); */
  uri_list = NULL;

  args = poptGetArgs (ctx);
  if (args != NULL) {
    const gchar ** p;

    for (p = args; *p != NULL; p++) {
      uri_list = g_slist_prepend (uri_list, (char *) *p);
    }
  }
  poptFreeContext (ctx);

  gdk_threads_enter ();
  g_idle_add (encompass_idle_cb, uri_list);
  bonobo_main ();
  gdk_threads_leave ();

  return 0;
}
