/*
		      Endeavour Browser Directory Tree
 */

#ifndef BROWSER_DIR_TREE_H
#define BROWSER_DIR_TREE_H

#include <sys/stat.h>
#include <gtk/gtk.h>

#include "edv_types.h"
#include "edv_obj.h"
#include "edv_device.h"
#include "browser.h"


/* Node Utilities */
extern GtkCTreeNode *EDVBrowserDirTreeGetToplevel(edv_browser_struct *browser);

/* Origin Path */
extern void EDVBrowserDirTreeSetOriginPath(
	edv_browser_struct *browser, const gchar *path
);

/* Get Listing */
extern void EDVBrowserDirTreeCreateToplevels(edv_browser_struct *browser);
extern void EDVBrowserDirTreeGetListing(
	edv_browser_struct *browser, GtkCTreeNode *node,
	const gboolean update_progress
);
extern void EDVBrowserDirTreeClear(edv_browser_struct *browser);

/* Expanding */
extern void EDVBrowserDirTreeExpand(
	edv_browser_struct *browser,
	GtkCTreeNode *node,
	const gboolean update_progress
);

/* Realize Listing */
extern void EDVBrowserDirTreeRealizeListing(
	edv_browser_struct *browser, GtkCTreeNode *node
);

/* Selecting */
extern void EDVBrowserDirTreeSelectPath(
	edv_browser_struct *browser, const gchar *path
);

/* Finding */
extern GtkCTreeNode *EDVBrowserDirTreeFindNodeByIndex(
	edv_browser_struct *browser,
	const gulong device_index, const gulong index
);
extern GtkCTreeNode *EDVBrowserDirTreeFindNodeByPath(
	edv_browser_struct *browser, const gchar *path
);

/* Removing */
extern void EDVBrowserDirTreeRemoveGrandChildrenNodes(
	edv_browser_struct *browser, GtkCTreeNode *node
);

/* Opening */
extern void EDVBrowserDirTreeOpenWith(
	edv_browser_struct *browser, GtkCTreeNode *node
);

/* Renaming */
extern void EDVBrowserDirTreePromptRename(
	edv_browser_struct *browser, GtkCTreeNode *node
);

/* Object Callbacks */
extern void EDVBrowserDirTreeObjectAddedNotify(
	edv_browser_struct *browser, const gchar *path,
	const struct stat *lstat_buf
);
extern void EDVBrowserDirTreeObjectModifiedNotify(
	edv_browser_struct *browser, const gchar *path,
	const gchar *new_path,
	const struct stat *lstat_buf
);
extern void EDVBrowserDirTreeObjectRemovedNotify(
	edv_browser_struct *browser, const gchar *path
);

/* Mount Callbacks */
extern void EDVBrowserDirTreeMountNotify(
	edv_browser_struct *browser, edv_device_struct *dev,
	gboolean is_mounted
);


#endif	/* BROWSER_DIR_TREE_H */
