#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <glib.h>

#include "../include/string.h"
#include "../include/disk.h"

#include "edv_types.h"
#include "edv_archive_obj.h"
#include "edv_utils.h"


edv_archive_object_struct *EDVArchObjectNew(void);
edv_archive_object_struct *EDVArchObjectCopy(
	edv_archive_object_struct *obj
);
void EDVArchObjectSetPath(
	edv_archive_object_struct *obj, const gchar *path
);
void EDVArchObjectSetPath2(
	edv_archive_object_struct *obj,
	const gchar *parent, const gchar *name
);
void EDVArchObjectDelete(edv_archive_object_struct *obj);


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Create a new Archive Object.
 */
edv_archive_object_struct *EDVArchObjectNew(void)
{
	return(EDV_ARCHIVE_OBJECT(
	    g_malloc0(sizeof(edv_archive_object_struct))
	));
}


/*
 *	Coppies the Archive Object.
 */
edv_archive_object_struct *EDVArchObjectCopy(
	edv_archive_object_struct *obj
)
{
	edv_archive_object_struct *new_obj;

	if(obj == NULL)
	    return(NULL);

	new_obj = EDVArchObjectNew();
	if(new_obj == NULL)
	    return(NULL);

	/* Begin copying values */
	new_obj->type = obj->type;

	new_obj->name = STRDUP(obj->name);
	new_obj->full_path = STRDUP(obj->full_path);
	new_obj->link_target = STRDUP(obj->link_target);

	new_obj->permissions = obj->permissions;
	new_obj->access_time = obj->access_time;
	new_obj->modify_time = obj->modify_time;
	new_obj->change_time = obj->change_time;

	new_obj->owner_name = STRDUP(obj->owner_name);
	new_obj->group_name = STRDUP(obj->group_name);

	new_obj->size = obj->size;
	new_obj->compressed_size = obj->compressed_size;

	new_obj->device_type = obj->device_type;

	new_obj->encryption = STRDUP(obj->encryption);
	new_obj->compression_ratio = obj->compression_ratio;
	new_obj->method = STRDUP(obj->method);
	new_obj->crc = STRDUP(obj->crc);

	return(new_obj);
}

/*
 *	Deletes the Archive Object.
 */
void EDVArchObjectDelete(edv_archive_object_struct *obj)
{
	if(obj == NULL)
	    return;

	g_free(obj->name);
	g_free(obj->full_path);

	g_free(obj->link_target);

	g_free(obj->owner_name);
	g_free(obj->group_name);

	g_free(obj->encryption);
	g_free(obj->method);
	g_free(obj->crc);

	g_free(obj);
}
