#ifndef GUIRGBIMG_H
#define GUIRGBIMG_H

#include <gtk/gtk.h>


extern void GUIImageBufferCopyArea(
	const gint bpp,
	const guint8 *src_data,
	const gint src_width, const gint src_height, const gint src_bpl,
	guint8 *tar_data,
	const gint tar_width, const gint tar_height, const gint tar_bpl,
	const gint tar_x, const gint tar_y,
	const gboolean blend,
        gint (*progress_cb)(const gulong, const gulong, gpointer),
        gpointer progress_data
);
extern void GUIImageBufferResize(
	const gint bpp,
	const guint8 *src_data,
	const gint src_width, const gint src_height, const gint src_bpl,
	guint8 *tar_data,
	const gint tar_width, const gint tar_height, const gint tar_bpl,
	gint (*progress_cb)(const gulong, const gulong, gpointer),
	gpointer progress_data
);
extern void GUIImageBufferRotateCW90(
	const gint bpp,
	const guint8 *src_data,
	const gint src_width, const gint src_height, const gint src_bpl,
	guint8 *tar_data,
	const gint tar_width, const gint tar_height, const gint tar_bpl
);
extern void GUIImageBufferRotateCCW90(
	const gint bpp,
	const guint8 *src_data,
	const gint src_width, const gint src_height, const gint src_bpl,
	guint8 *tar_data,
	const gint tar_width, const gint tar_height, const gint tar_bpl
);
extern void GUIImageBufferRotateCW180(
	const gint bpp,
	const guint8 *src_data,
	const gint src_width, const gint src_height, const gint src_bpl,
	guint8 *tar_data,
	const gint tar_width, const gint tar_height, const gint tar_bpl
);
extern void GUIImageBufferMirrorH(
	const gint bpp,
	const guint8 *src_data,
	const gint src_width, const gint src_height, const gint src_bpl,
	guint8 *tar_data,
	const gint tar_width, const gint tar_height, const gint tar_bpl
);
extern void GUIImageBufferMirrorV(
	const gint bpp,
	const guint8 *src_data,
	const gint src_width, const gint src_height, const gint src_bpl,
	guint8 *tar_data,
	const gint tar_width, const gint tar_height, const gint tar_bpl
);
extern void GUIImageBufferFlattenWithBG(
	const gint bpp,
	guint8 *data,
	const gint width, const gint height, const gint bpl,
	const guint8 *bg_color,
	gint (*progress_cb)(const gulong, const gulong, gpointer),
	gpointer progress_data
);
#define gdk_get_rgb_image		GUIGetRGBImage
extern guint8 *GUIGetRGBImage(
	GdkDrawable *drawable,
	const GdkRectangle *rect,
	gint *width_rtn, gint *height_rtn, gint *bpl_rtn
);
#define gdk_get_rgba_image		GUIGetRGBAImage
extern guint8 *GUIGetRGBAImage(
	GdkDrawable *drawable,
	const GdkRectangle *rect,
	gint *width_rtn, gint *height_rtn, gint *bpl_rtn
);


#endif	/* GUIRGBIMG_H */
