/*
			       Devices Fetching
 */

#ifndef EDV_DEVICE_GET_H
#define EDV_DEVICE_GET_H

#include <glib.h>
#include "edv_device.h"
#include "edv_context.h"


/*
 *	Gets the list of Devices.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The total specifies the return value for the total number
 *	of Devices.
 *
 *	The returned list must not be modified or deleted.
 */
extern edv_device_struct **EDVDevicesList(
	edv_context_struct *ctx,
	gint *total
);

/*
 *	Matches the Device by path.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The path specifies the full path to the mount path or the
 *	device path.
 *
 *	Returns the matched Device or NULL on error, the returned
 *	Device must not be modified or deleted.
 */
extern edv_device_struct *EDVDeviceMatch(
	edv_context_struct *ctx,
	const gchar *path
);


#endif	/* EDV_DEVICE_GET_H */
