#include <gtk/gtk.h>
#include "guiutils.h"
#include "edv_cursor.h"
#include "config.h"


edv_cursor_struct *EDVCursorNew(void);
edv_cursor_struct *EDVCursorNewFromGDKCursor(
	const edv_cursor_code code,
	GdkCursor *gdk_cursor
);
edv_cursor_struct *EDVCursorNewFromGDKCursorType(
	const edv_cursor_code code,
	const GdkCursorType gdk_cursor_type
);
void EDVCursorSetGDKCursor(
	edv_cursor_struct *cursor,
	GdkCursor *gdk_cursor
);
void EDVCursorDelete(edv_cursor_struct *cursor);


#define ATOI(s)		(((s) != NULL) ? atoi(s) : 0)
#define ATOL(s)		(((s) != NULL) ? atol(s) : 0)
#define ATOF(s)		(((s) != NULL) ? atof(s) : 0.0f)
#define STRDUP(s)	(((s) != NULL) ? g_strdup(s) : NULL)

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)	(MIN(MAX((a),(l)),(h)))
#define STRLEN(s)	(((s) != NULL) ? strlen(s) : 0)
#define STRISEMPTY(s)	(((s) != NULL) ? (*(s) == '\0') : TRUE)


/*
 *	Creates a new cursor.
 */
edv_cursor_struct *EDVCursorNew(void)
{
	return(EDV_CURSOR(
	    g_malloc0(sizeof(edv_cursor_struct))
	));
}

/*
 *	Creates a new cursor.
 *
 *	The code specifies the cursor code, which can be one of
 *	EDV_CURSOR_CODE_*.
 *
 *	The gdk_cursor specifies the GdkCursor. The GdkCursor will
 *	be passed on to the new cursor and as such, the GdkCursor
 *	should not be referenced again after this call.
 *
 *	Returns the new cursor or NULL on error.
 */
edv_cursor_struct *EDVCursorNewFromGDKCursor(
	const edv_cursor_code code,
	GdkCursor *gdk_cursor
)
{
	edv_cursor_struct *cursor = EDVCursorNew();
	if(cursor == NULL)
	{
	    GDK_CURSOR_DESTROY(gdk_cursor);
	    return(NULL);
	}

	cursor->code = code;
	cursor->cursor = gdk_cursor;

	return(cursor);
}

/*
 *	Creates a new cursor from the GdkCursorType.
 *
 *	The code specifies the cursor code, which can be one of
 *	EDV_CURSOR_CODE_*.
 *
 *	The gdk_cursor_type specifies the GdkCursorType, which is a
 *	code that specifies a predefined GDK cursor.
 *
 *	Returns the new cursor or NULL on error. If the GdkCursorType
 *	is invalid or the GdkCursor was unable to be created then
 *	NULL will also be returned.
 */
edv_cursor_struct *EDVCursorNewFromGDKCursorType(
	const edv_cursor_code code,
	const GdkCursorType gdk_cursor_type
)
{
	GdkCursor *gdk_cursor = gdk_cursor_new(gdk_cursor_type);
	if(gdk_cursor == NULL)
	    return(NULL);

	return(EDVCursorNewFromGDKCursor(code, gdk_cursor));
}

/*
 *	Sets the cursor's GdkCursor.
 */
void EDVCursorSetGDKCursor(
	edv_cursor_struct *cursor,
	GdkCursor *gdk_cursor
)
{
	if(cursor == NULL)
	{
	    GDK_CURSOR_DESTROY(gdk_cursor);
	    return;
	}

	GDK_CURSOR_DESTROY(cursor->cursor);
	cursor->cursor = gdk_cursor;
}

/*
 *	Deletes the cursor.
 */
void EDVCursorDelete(edv_cursor_struct *cursor)
{
	if(cursor == NULL)
	    return;

	GDK_CURSOR_DESTROY(cursor->cursor);
	g_free(cursor);
}
