/*
                             Endeavour Mark II Core
 */

#ifndef ENDEAVOUR2_H
#define ENDEAVOUR2_H

#include <gtk/gtk.h>

#include "cfg.h"
#include "pulist.h"
#include "edv_types.h"
#include "edv_device.h"
#include "edv_mime_type.h"
#include "obj_op_dlg.h"
#include "browser.h"
#include "imbr.h"
#include "archiver.h"
#include "recbin.h"
#include "recbin_desktop_icon.h"
#include "find_win.h"
#include "prop_dlg.h"
#include "history_win.h"
#include "run_dlg.h"
#include "devices_list_win.h"
#include "mime_types_list_win.h"
#include "edv_generic_options_win.h"
#include "about_dlg.h"


/*
 *	Endeavour Core Runlevel:
 */
typedef enum {
	EDV_RUNLEVEL_BASE		= 0,
	EDV_RUNLEVEL_CONSTRUCT		= 1,	/* or deconstruct */
	EDV_RUNLEVEL_IDLE		= 2,
	EDV_RUNLEVEL_BACKGROUND		= 3,
	EDV_RUNLEVEL_PREEMPT		= 4
} edv_runlevel;


/*
 *	Run Flags:
 */
typedef enum {
	EDV_RUN_SAFE_MODE		= (1 << 0),	/* Run in safe mode,
							 * print stdout and
							 * stderr normally
							 * (instead of in
							 * dialogs), and disable
							 * fancy graphics */

	EDV_RUN_STAY_RUNNING		= (1 << 1)	/* Keep the core running
							 * even when all windows
							 * have been closed,
							 * only SIGINT can tell
							 * the core to stop
							 * running */
} edv_run_flags;


/*
 *	Endeavour Mark II Core:
 */
struct _edv_core_struct {

	/* Runlevel */
	edv_runlevel		runlevel;

	/* Run Flags */
	edv_run_flags		run_flags;

	/* Configuration */
        gchar			*cfg_file;
	cfg_item_struct		*cfg_list;

	/* Data Type GdkAtoms */
	GdkAtom			data_type_recycled_object_atom,
				data_type_archive_object_atom;

	/* Pixmaps List (list of edv_pixmaps *) */
	GList			*pixmap_list;

	/* File Browsers */
	edv_browser_struct	**browser;
	gint			total_browsers;

	/* Image Browsers */
	edv_imbr_struct		**imbr;
	gint			total_imbrs;

	/* Archivers */
	edv_archiver_struct	**archiver;
	gint			total_archivers;

	/* Recycle Bin */
	edv_recbin_struct	*recbin;
	/* Recycle Bin Desktop Icon */
	edv_recbin_desktop_icon_struct	*recbin_deskicon;
	/* Last known items in recycle bin, this is used as a quick access
	 * value to check if the recycle bin has contents or not
	 */
	gint			last_recbin_items;

	/* Find Window */
	edv_find_win_struct	*find_win;

	/* Object Operations Dialog */
	edv_obj_op_dlg_struct	*obj_op_dlg;

	/* Property Dialogs */
	edv_propdlg_struct	**propdlg;
	gint			total_propdlgs;

	/* History Window */
	edv_history_win_struct	*history_listwin;

	/* Run Dialog */
	edv_run_dlg_struct	*run_dlg;

	/* Devices Window */
	edv_devices_list_win_struct	*device_listwin;

	/* MIME Types Window */
	edv_mime_types_list_win_struct	*mimetype_listwin;

	/* Options Window */
	edv_gen_opt_win_struct		*options_window;

	/* Customize Window */
	edv_gen_opt_win_struct		*customize_window;

	/* About Dialog */
	about_dlg_struct	*about_dlg;


	/* Timeout callback IDs */
	guint		manage_toid,
			check_devices_toid;

	/* Pending operation flags, signals that a pending operation
	 * should be performed at the next regularly schedualed call
	 * to EDVManageTimeoutCB()
	 */
	edv_core_pending_flags	pending_flags;

	/* InterPS signal count, counts the number of times external
	 * applications have notified us about pending InterPS
	 * commands that should be processed at the next regularly
	 * schedualed call to EDVManageTimeoutCB()
	 */
	gint		interps_signal_count;

	/* Operation level, indicates if this program is copying
	 * a file, recycling a file, syncing, etc
	 *
	 * Level 0 means that no operation is being performed
	 *
	 * This is used to determine reentery into file copying of
	 * recycling functions
	 */
	gint		op_level;


	/* Error message buffers & pointers */
	gchar		*archive_last_error_buf,	/* edv_archive*.c */
			*device_last_error_buf,		/* edv_device*.c */
			*obj_last_error_buf,		/* edv_obj*.c */
			*recbin_last_error_buf;		/* edv_recbin*.c */

	const gchar	*archive_last_error,
			*device_last_error,
			*obj_last_error,
			*recbin_last_error;


        /* This process' ID */
        gint		pid; 

	/* This program object path (taken from command line) */
	gchar		*prog_file;

	/* Home directory */
	gchar		*home_dir;

	/* This process' user and group ID */
	gint		user_id;		/* Real user id */
	gint		effective_user_id;	/* Effective user id */
	gint		group_id;		/* Real group id */
	gint		effective_group_id;	/* Effective group id */

	/* User IDs list (list of edv_uid_struct *) */
	GList		*uids_list;
	pulist_struct	*users_pulist;

	/* Group IDs list (list of edv_gid_struct *) */
	GList		*gids_list;
	pulist_struct	*groups_pulist;

	/* Verbose string describing (effective) "<username>" and
	 * "<username>@<hostname>"
	 *
	 * This is used for quick setting of title bars since the user
	 * and location do not change (often) at run time
	 */
	gchar		*effective_user_id_str;		/* user */
	gchar		*effective_user_id_host_str;	/* user@hostname */

	/* Cursors list */
	GList		*cursors_list;

	/* Devices list */
	edv_device_struct	**device;
	gint			total_devices;
	pulist_struct		*devices_pulist;	/* For mount bars */

	/* MIME Types list */
	edv_mime_type_struct	**mimetype;
	gint			total_mimetypes;
	pulist_struct		*open_with_pulist;	/* Lists application
							 * MIME Types for the
							 * Open With list */

	/* MIME Types index hints
	 *
	 * These are index values of the first and last items of a
	 * particular MIME Type class in the list, these indices are
	 * updated in EDVDoUpdateMIMETypeHintIndices()
	 *
	 * These index values may not be valid, they should be only be
	 * used as reference
	 */
	gint		mimetype_system_index_first,
			mimetype_system_index_last;
	gint		mimetype_format_index_first,
			mimetype_format_index_last;
	gint		mimetype_program_index_first,
			mimetype_program_index_last;
	gint		mimetype_unique_index_first,
			mimetype_unique_index_last;


	/* Basic GUI options */
	gboolean	geometry_set;
	GdkRectangle	geometry;	/* Only defined if geometry_set is TRUE */

	gchar		*font_name;
	GdkFont		*font;

	gchar		*fg_color_name, *bg_color_name,
			*sfg_color_name, *sbg_color_name,
			*cfg_color_name, *cbg_color_name,
			*bg_pixmap_path, *sbg_pixmap_path;
	gchar		*wm_name,
			*wm_class,
			*title;

	/* User defined GtkRcStyles (if not NULL) */
	GtkRcStyle	*standard_rcstyle,
			*lists_rcstyle;


#if defined(HAVE_IMLIB)
	/* Image Library Handle */
	gpointer	imlib_handle;
#endif

};
#define EDV_CORE(p)	((edv_core_struct *)(p))


extern edv_core_struct	*edv_core;


/* edv_core.c */
extern edv_core_struct *EDVNew(
	gint argc, gchar *argv[],
	gint *error_rtn
);
extern void EDVDelete(
	edv_core_struct *core,
	const gboolean save_config
);


#endif	/* ENDEAVOUR2_H */
