/*
				    Pie Chart
 */

#ifndef PIE_CHART_H
#define PIE_CHART_H

#include <gtk/gtk.h>


typedef struct _pie_chart_struct	pie_chart_struct;
#define PIE_CHART(p)			((pie_chart_struct *)(p))
typedef struct _pie_chart_value_struct	pie_chart_value_struct;
#define PIE_CHART_VALUE(p)		((pie_chart_value_struct *)(p))


/*
 *	Pie Chart Value:
 */
struct _pie_chart_value_struct {

	pie_chart_struct	*pc;

	GtkAdjustment	*adj;	/* Only lower and upper used */
	GdkColor	c, c_shade;

	GtkWidget	*type_label_hbox,
			*value_label_hbox,
			*drawing_area;

	gchar		*type_label,
			*value_label;

};

/*
 *	Pie Chart:
 */
struct _pie_chart_struct {

	GtkWidget	*toplevel;
	gboolean	realized,	/* If FALSE then indicates that the
					 * colors and other resources have
					 * not been created yet */
			map_state,
			show_labels,
			shadows,
			outline;
	gint		freeze_count;

	GtkWidget	*drawing_area,
			*type_labels_vbox,
			*value_labels_vbox,
			*title_label,
			*footer_label;

	GdkPixmap	*pixmap;	/* Offscreen GdkPixmap buffer for
					 * the GtkDrawingArea */
	gint		width, height;	/* Size of the pixmap */
	GdkGC		*gc;
	GdkColormap	*colormap;

	GtkAdjustment	*adj;	/* Only lower and upper used */
	GdkColor	c,
			c_shade,
			c_shadow;
	gchar		*base_type_label,
			*base_value_label;

	GList		*values_list;	/* pie_chart_value_struct * */

};


/* Pie Chart Value */
extern pie_chart_value_struct *PieChartValueNew(void);
extern void PieChartValueDelete(pie_chart_value_struct *v);
extern gint PieChartValueAdd(
	pie_chart_struct *pc,
	GtkAdjustment *adj, GdkColor *c,
	const gchar *type_label, const gchar *value_label
);
extern void PieChartValueSet(
	pie_chart_struct *pc, const gint value_num,
	GtkAdjustment *adj, GdkColor *c,
	const gchar *type_label, const gchar *value_label
);
extern void PieChartValueRemove(
	pie_chart_struct *pc, const gint value_num
);
extern void PieChartClear(pie_chart_struct *pc);

/* Pie Chart */
extern pie_chart_struct *PieChartNew(
	const gint width, const gint height,
	GtkAdjustment *adj,
	GdkColor *c,
	const gchar *title, const gchar *footer,
	const gchar *base_type_label, const gchar *base_value_label
);
extern void PieChartMap(pie_chart_struct *pc);
extern void PieChartUnmap(pie_chart_struct *pc);
extern void PieChartDelete(pie_chart_struct *pc);


#endif	/* PIE_CHART_H */
