; example2.nsi
;
; This script is based on example1.nsi, but adds uninstall support
; and (optionally) start menu shortcuts.
;
; It will install notepad.exe into a directory that the user selects,
;

!define VERSION "1.00"

; Source directory
!define SDIR ".\"

; The name of the installer
Name "Enigma"
Caption "Enigma ${VERSION} Setup"

; The file to write
OutFile "Enigma-1.00.exe"
SetCompressor lzma

; The default installation directory
InstallDir $PROGRAMFILES\Enigma
; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM SOFTWARE\Enigma "Install_Dir"

; The text to prompt the user to enter a directory
ComponentText "This will install Enigma on your computer. Select which optional things you want installed."
; The text to prompt the user to enter a directory
DirText "Choose a directory to install in to:"

; The stuff to install
Section "Enigma (required)"
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR

  ; Put file there
  File /r "${SDIR}\data"
  File /r "${SDIR}\images"
  File /r "${SDIR}\manual"
  File /r "${SDIR}\reference"
  File    "${SDIR}\*.*"
  ; Write the installation path into the registry
  WriteRegStr HKLM SOFTWARE\Enigma "Install_Dir" "$INSTDIR"
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Enigma" "DisplayName" "Enigma"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Enigma" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteUninstaller "uninstall.exe"
SectionEnd

; optional section
Section "Start Menu Shortcuts"
  CreateDirectory "$SMPROGRAMS\Enigma"
  CreateShortCut "$SMPROGRAMS\Enigma\Enigma.lnk" "$INSTDIR\enigma.exe" "" "$INSTDIR\enigma.exe" 0
  CreateShortCut "$SMPROGRAMS\Enigma\Documentation.lnk" "$INSTDIR\index.html" "" "$INSTDIR\index.html" 0
  CreateShortCut "$SMPROGRAMS\Enigma\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
SectionEnd

; uninstall stuff

UninstallText "This will uninstall Enigma. Hit next to continue."

; special uninstall section.
Section "Uninstall"
  ; remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Enigma"
  DeleteRegKey HKLM SOFTWARE\Enigma
  ; remove files
  ; Delete $INSTDIR\not.exe
  ; MUST REMOVE UNINSTALLER, too
  ;Delete $INSTDIR\uninstall.exe
  ; remove shortcuts, if any.
  Delete "$SMPROGRAMS\Enigma\*.*"
  ; remove directories used.
  RMDir "$SMPROGRAMS\Enigma"
  RMDir /r "$INSTDIR"
SectionEnd

; eof
