"""
This demonstrates the most basic drawing capabilities using Enable.  A new
component is created and added to a container.
"""


from enthought.enable import Component, Container
from enthought.enable.wx import Window

# Relative imports
from demo_base import DemoFrame, demo_main

class Box(Component):
    def _draw(self, gc):
        gc.save_state()
        gc.set_fill_color((1.0, 0.0, 0.0, 1.0))
        x, y, dx, dy = self.bounds
        gc.rect(x, y, dx, dy)
        gc.fill_path()
        gc.restore_state()

class MyFrame(DemoFrame):
    def _create_window(self):
        box = Box(bounds=(50,50,100,100))
        container = Container(bounds=(0,0,500,500))
        container.add(box)
        return Window(self, -1, component=container)

if __name__ == "__main__":
    demo_main(MyFrame)

# EOF
