# Function to convert simple ETS project names and versions to a requirements
# spec that works for both development builds and stable builds.  Allows
# a caller to specify a max version, which is intended to work along with
# Enthought's standard versioning scheme -- see the following write up:
#    https://svn.enthought.com/enthought/wiki/EnthoughtVersionNumbers
def etsdep(p, min, max=None, literal=False):
    require = '%s >=%s.dev' % (p, min)
    if max is not None:
        if literal is False:
            require = '%s, <%sa' % (require, max)
        else:
            require = '%s, <%s' % (require, max)
    return require


# Declare our ETS project dependencies.
ETSCONFIG = etsdep('enthought.etsconfig', '2.0.2', '3.0')
TRAITS = etsdep('enthought.traits', '2.0.5', '3.0')
TRAITSUIWX = etsdep('enthought.traits.ui.wx', '2.0.5', '3.0')


# A dictionary of the setup data information.
INFO = {
    'extras_require': {
        'ps': [
            ],
        'svg': [
            ],
        'traits': [
            TRAITS,
            TRAITSUIWX,
            ],

        # All non-ets dependencies should be in this extra to ensure users can
        # decide whether to require them or not.
        'nonets': [
            "numpy >=1.0.2",
            ],
        },
    'install_requires': [
        ETSCONFIG,
        ],
    'name': 'enthought.kiva',
    'version': '2.0.4',
    }
