""" Demo to redefine legal values of one attribute based on another via GUI.
"""

from enthought.traits.api \
    import HasTraits, Str, Enum, TraitEnum
    
from enthought.traits.ui.api \
    import View, Group, Item, Handler, EnumEditor


# Dictionary of defined states and cities.
cities_by_state = {
    'GA': [ 'Athens', 'Atlanta', 'Macon', 'Marietta', 'Savannah' ],
    'TX': [ 'Austin', 'Amarillo', 'Dallas', 'Houston', 'San Antonio', 'Waco' ],
    'OR': [ 'Albany', 'Eugene', 'Portland' ]
}


class AddressHandler ( Handler ):
    """ Handler class to redefine the possible values of 'city' based on 'st'.
    """
    def object_st_changed ( self, info ):
        # Change the selector options:
        info.cityedit.factory.values = cities[ info.object.st ]

        # Assign the default value to the first element of the list:
        info.object.city = cities[ info.object.st ][0]


class CityList(HasTraits):
    cities = cities_by_state('GA')

    
class Address ( HasTraits ):
    """ Demo class for demonstrating dynamic redefinition of valid trait values.
    """
    street_address = Str
    st             = Str
    city           = Str

    view = View( Item( name  = 'street_address' ),
                 Item( name  = 'st', 
                       label = 'State' ),
                 Item( name  = 'city', 
                       editor = EnumEditor(object='citylist', name='cities'), 
                       id     = 'cityedit' ),
                 title   = 'Address Information',
                 handler = AddressHandler())


# Code to run the demo standalone:
if __name__ == '__main__':
    addr = Address()
    citylist = CityList()
    addr.configure_traits(context={'object':addr, 'citylist': citylist})

