#ifndef __ENODE_TREEWALK_H__
#define __ENODE_TREEWALK_H__

/* The treewalk function is a utility function for walking through the tree
 * in a relatively fast and easy manner.  This is a utility function for the
 * enode api, and is not to be used directly unless you know what you are
 * doing. */

typedef struct _ENodeTreeWalk ENodeTreeWalk;

struct _ENodeTreeWalk {
    ENode *top_node;
    ENode *curnode;
    ENode *parentnode;
    gpointer user_data1;
    gpointer user_data2;
    gpointer user_data3;
    gpointer user_data4;
};

typedef gint (*ENodeTreeWalkCallback) (ENodeTreeWalk * treewalk);

ENodeTreeWalk *enode_treewalk_new (ENode * topnode);

void
 enode_treewalk (ENodeTreeWalk * treewalk,
		 ENodeTreeWalkCallback child_callback,
		 ENodeTreeWalkCallback parent_callback);

void
 enode_treewalk_free (ENodeTreeWalk * treewalk);

/* forward is boolean.. switches between forward or reverse list. */
GSList *enode_child_list (ENode * topnode, gint forward);



#endif				/* __ENODE_TREEWALK_H__ */


