#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>


#include "entity.h"

static gint
system_timer_callback (gpointer data)
{
  ENode * node = data;
  gchar * function;

  EDEBUG (("system-timer", "callback."));

  function = enode_attrib_str (node, "action", NULL);
  enode_call_ignore_return (node, function, "");

  return (TRUE);
}

static gint
system_timer_interval_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
  gint intval;
  gint id;

  intval  = erend_get_integer (value);
  
  EDEBUG (("system-timer", "interval attr set, val %d", intval));


  /* delete old timer */
  id = GPOINTER_TO_INT(enode_get_kv (node, "timer"));
  if (id)
    g_source_remove (id);

  if (intval < 0)
    return (TRUE);

  id = g_timeout_add (intval, system_timer_callback, node);
  enode_set_kv (node, "timer", GINT_TO_POINTER(id));

  return (TRUE);
}

static void
system_timer_destroy (ENode * node)
{
  gint id = GPOINTER_TO_INT(enode_get_kv (node, "timer"));
  if (id)
    g_source_remove (id);

  EDEBUG (("system-timer", "destroy"));
  
}

static void
system_timer_render (ENode * node)
{
  EDEBUG (("system-timer", "render??!"));

  enode_attribs_sync (node);
}

void
system_timer_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    EDEBUG (("system-timer", "register."));

    element = g_new0 (Element, 1);
    element->tag = "system-timer";
    element->render_func = system_timer_render;
    element->destroy_func = system_timer_destroy;
    element->description = "Invoke a callback at regular intervals.";
    element_register (element);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "interval";
    e_attr->description = "Time between invocations, in milliseconds.";
    e_attr->set_attr_func = system_timer_interval_attr_set;
    e_attr->value_desc = "integer";
    e_attr->possible_values = "1,*";
    element_register_attrib (element, e_attr);

    /*
    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "active";
    e_attr->description = "Is the timer currently running?.";
    e_attr->value_desc = "boolean";
    e_attr->set_attr_func = system_timer_active_attr_set;
    element_register_attrib (element, e_attr);
    */


    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "action";
    e_attr->description = "The function to call when the timeout occurs.";
    e_attr->value_desc = "function";
    element_register_attrib (element, e_attr);

}
