#!/usr/bin/env entity

<object default-lang = "tcl">
  
  <timer interval="2000" action="search"/>
  <?tcl
    set numnodes 10000
    puts -nonewline stderr "creating $numnodes node tree: "

    set time [time {
      set obj [enode object]
      
      $obj attrib "foo" "goo"
      
      for {set i 0} {$i < $numnodes} {incr i} {
          set node [$obj new_child "fooey"]
          if {!($i % 2)} {
            $node attrib "foo" "goo"
          }
      }
    }]
    puts stderr [list [expr double([lindex $time 0]) / 1000000] s]
    
    proc search {node args} {
      global numnodes
      puts -nonewline stderr "\nsearching $numnodes node tree: "
      set time [time {
        set children [[enode object] children_attrib "foo" "goo"]
      }]
      puts stderr [list [expr double([lindex $time 0]) / 1000000] s]
      puts stderr [list returned [llength $children] results.]
    }
    
    
  ?>

</object>
