#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
DIR=epigrass-$2

# clean up the upstream tarball
tar -x -z -f $3
rm -f $3
DFSGTARBALL=`echo $3 | sed 's/\(_[0-9.b]\+\)\(.orig.tar.gz\)/\1~dfsg\2/'`
# make sure the removed files will not show up in epigrass.egg-info/SOURCES.txt
cd $DIR/epigrass.egg-info; sed -i -e '/\.pdf$/d' -e '/\.pyc$/d' -e '/~$/d' SOURCES.txt ; cd ../..
tar -c -z -f $DFSGTARBALL --exclude '*.pdf' --exclude '*.pyc' --exclude '*~' $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $DFSGTARBALL $origDir
  echo "moved $DFSGTARBALL to $origDir"
fi
